/*
 * Decompiled with CFR 0.152.
 */
package AccuShiftDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import org.json.JSONException;
import org.json.JSONObject;

public class BreakInfo {
    public int id = 0;
    public String type = "";
    public int appliesAfter = 0;
    public int breakTime = 0;
    public int minimumTime = 0;
    public boolean isPaid = false;
    public String textColor = "1Black";

    public BreakInfo() {
    }

    public BreakInfo(String xml) {
        this.id = Utility.getIntElement("ID", xml);
        this.type = Utility.getElement("Type", xml);
        this.appliesAfter = Utility.getIntElement("AppliesAfter", xml);
        this.breakTime = Utility.getIntElement("BreakTime", xml);
        this.minimumTime = Utility.getIntElement("MinimumTime", xml);
        this.isPaid = Utility.getBooleanElement("IsPaid", xml);
        this.textColor = Utility.getElement("TextColor", xml);
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<BreakInfo>\r\n");
        xml.append("  <ID>" + this.id + "</ID>\r\n");
        xml.append("  <Type>" + this.type + "</Type>\r\n");
        xml.append("  <AppliesAfter>" + this.appliesAfter + "</AppliesAfter>\r\n");
        xml.append("  <BreakTime>" + this.breakTime + "</BreakTime>\r\n");
        xml.append("  <MinimumTime>" + this.minimumTime + "</MinimumTime>\r\n");
        xml.append("  <IsPaid>" + this.isPaid + "</IsPaid>\r\n");
        xml.append("  <TextColor>" + this.textColor + "</TextColor>\r\n");
        xml.append("</BreakInfo>\r\n");
        return xml.toString();
    }

    public BreakInfo(JSONString jsonString) {
        String breakInfoJson = jsonString.toString();
        this.id = Utility.getJSONInt(breakInfoJson, "id");
        this.type = Utility.getJSONString(breakInfoJson, "type");
        this.appliesAfter = Utility.getJSONInt(breakInfoJson, "appliesAfter");
        this.breakTime = Utility.getJSONInt(breakInfoJson, "breakTime");
        this.minimumTime = Utility.getJSONInt(breakInfoJson, "minimumTime");
        this.isPaid = Utility.getJSONBoolean(breakInfoJson, "isPaid");
        this.textColor = Utility.getJSONString(breakInfoJson, "textColor");
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("id", this.id);
            jsonObject.put("type", (Object)this.type);
            jsonObject.put("appliesAfter", this.appliesAfter);
            jsonObject.put("breakTime", this.breakTime);
            jsonObject.put("minimumTime", this.minimumTime);
            jsonObject.put("isPaid", this.isPaid);
            jsonObject.put("textColor", (Object)this.textColor);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }
}

