/*
 * Decompiled with CFR 0.152.
 */
package AccuShiftDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.POSDataContainer;
import java.sql.Timestamp;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Holiday {
    public int id;
    public String description = "";
    public Timestamp start;
    public Timestamp end;
    public String type = "";
    public String group = "";

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<Holiday>");
        xml.append("<Id>" + this.id + "</Id>");
        xml.append("<Description>" + this.description + "</Description>");
        xml.append("<StartDate>" + this.getDateString(this.start) + "</StartDate>");
        xml.append("<EndDate>" + this.getDateString(this.end) + "</EndDate>");
        xml.append("<StartTime>" + this.getTimeString(this.start) + "</StartTime>");
        xml.append("<EndTime>" + this.getTimeString(this.end) + "</EndTime>");
        xml.append("<Type>" + this.type + "</Type>");
        xml.append("<Group>" + this.group + "</Group>");
        xml.append("</Holiday>");
        return xml.toString();
    }

    public Holiday() {
    }

    public Holiday(String xml) {
        this.id = Utility.getIntElement("Id", xml);
        this.description = Utility.getElement("Description", xml);
        String startDate = Utility.getElement("StartDate", xml);
        String endDate = Utility.getElement("EndDate", xml);
        String startTime = Utility.getElement("StartTime", xml);
        String endTime = Utility.getElement("EndTime", xml);
        this.type = Utility.getElement("Type", xml);
        this.group = Utility.getElement("Group", xml);
        if (this.start != null) {
            this.start = Timestamp.valueOf(startDate + " " + startTime);
        }
        if (this.end != null) {
            this.end = Timestamp.valueOf(endDate + " " + endTime);
        }
    }

    public Holiday(JSONObject json) {
        try {
            this.id = json.getInt("id");
            this.description = json.getString("description");
            this.type = json.getString("type");
            this.group = json.getString("group");
            String startDate = json.getString("startDate");
            String endDate = json.getString("endDate");
            String startTime = json.getString("startTime");
            String endTime = json.getString("endTime");
            if (startDate != null && startTime != null) {
                this.start = Timestamp.valueOf(startDate + " " + startTime);
            }
            if (endDate != null && endTime != null) {
                this.end = Timestamp.valueOf(endDate + " " + endTime);
            }
        }
        catch (JSONException ex) {
            ex.printStackTrace();
        }
    }

    public static POSDataContainer fromJson(JSONArray json) {
        POSDataContainer holidays = new POSDataContainer();
        int len = json.length();
        try {
            for (int i = 0; i < len; ++i) {
                JSONObject thisJsonHoliday = json.getJSONObject(i);
                holidays.add(new Holiday(thisJsonHoliday));
            }
        }
        catch (JSONException ex) {
            ex.printStackTrace();
        }
        return holidays;
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("id", this.id);
            jsonObject.put("description", (Object)this.description);
            jsonObject.put("type", (Object)this.type);
            jsonObject.put("group", (Object)this.group);
            jsonObject.put("startDate", (Object)this.getDateString(this.start));
            jsonObject.put("endDate", (Object)this.getDateString(this.end));
            jsonObject.put("startTime", (Object)this.getTimeString(this.start));
            jsonObject.put("endTime", (Object)this.getTimeString(this.end));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    public static JSONArray toJson(POSDataContainer holidays) {
        JSONArray holidaysJson = new JSONArray();
        int len = holidays.size();
        for (int i = 0; i < len; ++i) {
            Holiday thisHoliday = (Holiday)holidays.get(i);
            holidaysJson.put((Object)thisHoliday.toJson());
        }
        return holidaysJson;
    }

    public String toString() {
        return this.description;
    }

    private String getDateString(Timestamp timestamp) {
        return timestamp.toString().substring(0, 10);
    }

    private String getTimeString(Timestamp timestamp) {
        return timestamp.toString().substring(11, 19);
    }
}

