/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class QboTaxRate {
    public String id;
    public String name;
    public BigDecimal rateValue;

    public QboTaxRate() {
    }

    public QboTaxRate(String xmlString) {
        this.id = Utility.getElement("Id", xmlString);
        this.name = Utility.getElement("Name", xmlString);
        this.rateValue = BigDecimal.ZERO;
        Vector effectiveTaxRates = Utility.getElementList("EffectiveTaxRate", xmlString);
        if (effectiveTaxRates != null && effectiveTaxRates.size() > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
            int numRates = effectiveTaxRates.size();
            for (int i = 0; i < numRates; ++i) {
                double doubleRateValue;
                String effectiveTaxRateXml = (String)effectiveTaxRates.get(i);
                Date today = new Date();
                String thisEffectiveDateXml = Utility.getElement("EffectiveDate", effectiveTaxRateXml);
                String thisEndDateXml = Utility.getElement("EndDate", effectiveTaxRateXml);
                Date thisEffectiveDate = null;
                if (thisEffectiveDateXml != null && !thisEffectiveDateXml.isEmpty()) {
                    try {
                        thisEffectiveDate = sdf.parse(thisEffectiveDateXml);
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
                Date thisEndDate = null;
                if (thisEndDateXml != null && !thisEndDateXml.isEmpty()) {
                    try {
                        thisEndDate = sdf.parse(thisEndDateXml);
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
                if (thisEndDate != null || thisEffectiveDate != null && thisEffectiveDate.after(today) || (doubleRateValue = Utility.getDoubleElement("RateValue", effectiveTaxRateXml)) == 0.0) continue;
                this.rateValue = new BigDecimal(doubleRateValue);
            }
        }
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<qboTaxRate>");
        xml.append("<Id>" + this.id + "</Id>");
        xml.append("<Name>" + this.name + "</Name>");
        xml.append("<RateValue>" + this.rateValue + "</RateValue>");
        xml.append("</qboTaxRate>");
        return xml.toString();
    }
}

