/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;
import IntegratorDataObjects.XmlCustomer;
import java.util.ArrayList;
import java.util.Vector;

public class XmlARCustomers {
    private ArrayList customers;

    public XmlARCustomers(ArrayList customers) {
        this.customers = customers;
    }

    public XmlARCustomers() {
    }

    public XmlARCustomers(String xmlString) {
        String customersXml = Utility.getElement("customers", xmlString);
        Vector customerStrings = Utility.getElementList("customer", customersXml);
        ArrayList<XmlCustomer> customerList = new ArrayList<XmlCustomer>();
        int numCustomers = 0;
        if (customerStrings != null && !customerStrings.isEmpty()) {
            numCustomers = customerStrings.size();
        }
        for (int i = 0; i < numCustomers; ++i) {
            String thisCustomerXml = (String)customerStrings.get(i);
            XmlCustomer thisCustomer = new XmlCustomer(thisCustomerXml);
            customerList.add(thisCustomer);
        }
        this.customers = customerList;
    }

    public ArrayList getCustomers() {
        return this.customers;
    }

    public void setCustomers(ArrayList customers) {
        this.customers = customers;
    }

    public boolean isEmpty() {
        return this.customers.isEmpty();
    }

    public String toXml() {
        return this.toXml(true);
    }

    public String toXml(boolean legacySupport) {
        StringBuilder sb = new StringBuilder();
        sb.append("<customers>");
        int len = this.customers.size();
        for (int i = 0; i < len; ++i) {
            XmlCustomer customer = (XmlCustomer)this.customers.get(i);
            sb.append(customer.toXml(legacySupport));
        }
        sb.append("</customers>");
        return sb.toString();
    }
}

