/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;

public class XmlLineItem {
    private String item = "";
    private String description = "";
    private double quantity = 0.0;
    private double price = 0.0;
    private double listPrice = 0.0;
    private boolean taxable = false;
    private String changedBy = "";
    private double lineTotal = 0.0;
    private double original = 0.0;
    private String user = "";
    private String taxCode = "";
    private String salesAccount = "";
    private String serialNumber = "";
    private boolean group = false;
    private double vat1 = 0.0;
    private double vat2 = 0.0;
    private String itemType = "";
    private String vatCode = "";
    private String sku = "";
    private String choiceGroup = "";
    private boolean stock = false;
    private String taxType = "";
    private String masterItem = "";
    private String itemAccountingRef = "";

    public XmlLineItem(String xmlString) {
        this.item = Utility.getElement("item", xmlString);
        this.description = Utility.getElement("description", xmlString);
        this.quantity = Utility.getDoubleElement("quantity", xmlString);
        this.price = Utility.getDoubleElement("price", xmlString);
        this.listPrice = Utility.getDoubleElement("listPrice", xmlString);
        this.taxable = Utility.getBooleanElement("taxable", xmlString, false);
        this.changedBy = Utility.getElement("changedBy", xmlString);
        this.lineTotal = Utility.getDoubleElement("lineTotal", xmlString);
        this.original = Utility.getDoubleElement("original", xmlString);
        this.user = Utility.getElement("user", xmlString);
        this.taxCode = Utility.getElement("taxCode", xmlString);
        this.salesAccount = Utility.getElement("salesAccount", xmlString);
        this.serialNumber = Utility.getElement("salesNumber", xmlString);
        this.group = Utility.getBooleanElement("group", xmlString, false);
        this.vat1 = Utility.getDoubleElement("vat1", xmlString);
        this.vat2 = Utility.getDoubleElement("vat2", xmlString);
        this.itemType = Utility.getElement("itemType", xmlString);
        this.vatCode = Utility.getElement("vatCode", xmlString);
        this.sku = Utility.getElement("sku", xmlString);
        this.choiceGroup = Utility.getElement("choiceGroup", xmlString);
        this.stock = Utility.getBooleanElement("stock", xmlString, false);
        this.taxType = Utility.getElement("taxType", xmlString);
        this.masterItem = Utility.getElement("masterItem", xmlString);
        this.itemAccountingRef = Utility.getElement("itemAccountingRef", xmlString);
    }

    public XmlLineItem(String item, String description, double quantity, double price, double listPrice, boolean taxable, String changedBy, double lineTotal, double original, String user, String taxCode, String salesAccount, String serialNumber, boolean group, double vat1, double vat2, String itemType, String vatCode, String sku, String choiceGroup, boolean stock, String taxType, String masterItem) {
        this.item = item;
        this.description = description;
        this.quantity = quantity;
        this.price = price;
        this.listPrice = listPrice;
        this.taxable = taxable;
        this.changedBy = changedBy;
        this.lineTotal = lineTotal;
        this.original = original;
        this.user = user;
        this.taxCode = taxCode;
        this.salesAccount = salesAccount;
        this.serialNumber = serialNumber;
        this.group = group;
        this.vat1 = vat1;
        this.vat2 = vat2;
        this.itemType = itemType;
        this.vatCode = vatCode;
        this.sku = sku;
        this.choiceGroup = choiceGroup;
        this.stock = stock;
        this.taxType = taxType;
        this.masterItem = masterItem;
    }

    public XmlLineItem() {
    }

    public String toXml() {
        return this.toXml(true);
    }

    public String toXml(boolean legacySupport) {
        StringBuilder xml = new StringBuilder();
        xml.append("      <lineItem>\r\n");
        xml.append("        <item>" + this.item + "</item>" + "\r\n");
        xml.append("        <description>" + this.description + "</description>" + "\r\n");
        xml.append("        <quantity>" + this.quantity + "</quantity>" + "\r\n");
        xml.append("        <price>" + this.price + "</price>" + "\r\n");
        xml.append("        <listPrice>" + this.listPrice + "</listPrice>" + "\r\n");
        xml.append("        <taxable>" + this.taxable + "</taxable>" + "\r\n");
        xml.append("        <changedBy>" + this.changedBy + "</changedBy>" + "\r\n");
        xml.append("        <lineTotal>" + this.lineTotal + "</lineTotal>" + "\r\n");
        xml.append("        <original>" + this.original + "</original>" + "\r\n");
        xml.append("        <user>" + this.user + "</user>" + "\r\n");
        xml.append("        <taxCode>" + this.taxCode + "</taxCode>" + "\r\n");
        xml.append("        <salesAccount>" + this.salesAccount + "</salesAccount>" + "\r\n");
        xml.append("        <serialNumber>" + this.serialNumber + "</serialNumber>" + "\r\n");
        xml.append("        <group>" + this.group + "</group>" + "\r\n");
        xml.append("        <vat1>" + this.vat1 + "</vat1>" + "\r\n");
        xml.append("        <vat2>" + this.vat2 + "</vat2>" + "\r\n");
        xml.append("        <itemType>" + this.itemType + "</itemType>" + "\r\n");
        xml.append("        <vatCode>" + this.vatCode + "</vatCode>" + "\r\n");
        xml.append("        <sku>" + this.sku + "</sku>" + "\r\n");
        xml.append("        <choiceGroup>" + this.choiceGroup + "</choiceGroup>" + "\r\n");
        xml.append("        <stock>" + this.stock + "</stock>" + "\r\n");
        xml.append("        <taxType>" + this.taxType + "</taxType>" + "\r\n");
        if (this.masterItem != null && !this.masterItem.isEmpty()) {
            xml.append("        <masterItem>" + this.masterItem + "</masterItem>" + "\r\n");
        }
        if (!legacySupport) {
            xml.append("        <itemAccountingRef>" + this.itemAccountingRef + "</itemAccountingRef>" + "\r\n");
        }
        xml.append("      </lineItem>\r\n");
        return xml.toString();
    }

    public void setItem(String item) {
        this.item = item;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public void setListPrice(double listPrice) {
        this.listPrice = listPrice;
    }

    public void setTaxable(boolean taxable) {
        this.taxable = taxable;
    }

    public void setChangedBy(String changedBy) {
        this.changedBy = changedBy;
    }

    public void setLineTotal(double lineTotal) {
        this.lineTotal = lineTotal;
    }

    public void setOriginal(double original) {
        this.original = original;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public void setSalesAccount(String salesAccount) {
        this.salesAccount = salesAccount;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public void setVat1(double vat1) {
        this.vat1 = vat1;
    }

    public void setVat2(double vat2) {
        this.vat2 = vat2;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public void setVatCode(String vatCode) {
        this.vatCode = vatCode;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public void setChoiceGroup(String choiceGroup) {
        this.choiceGroup = choiceGroup;
    }

    public void setStock(boolean stock) {
        this.stock = stock;
    }

    public void setTaxType(String taxType) {
        this.taxType = taxType;
    }

    public void setMasterItem(String masterItem) {
        this.masterItem = masterItem;
    }

    public void setItemAccountingRef(String accountingRef) {
        this.itemAccountingRef = accountingRef;
    }

    public String getItem() {
        return this.item;
    }

    public String getDescription() {
        return this.description;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public double getPrice() {
        return this.price;
    }

    public double getListPrice() {
        return this.listPrice;
    }

    public boolean isTaxable() {
        return this.taxable;
    }

    public String getChangedBy() {
        return this.changedBy;
    }

    public double getLineTotal() {
        return this.lineTotal;
    }

    public double getOriginal() {
        return this.original;
    }

    public String getUser() {
        return this.user;
    }

    public String getTaxCode() {
        return this.taxCode;
    }

    public String getSalesAccount() {
        return this.salesAccount;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public boolean isGroup() {
        return this.group;
    }

    public double getVat1() {
        return this.vat1;
    }

    public double getVat2() {
        return this.vat2;
    }

    public String getItemType() {
        return this.itemType;
    }

    public String getVatCode() {
        return this.vatCode;
    }

    public String getSku() {
        return this.sku;
    }

    public String getChoiceGroup() {
        return this.choiceGroup;
    }

    public boolean isStock() {
        return this.stock;
    }

    public String getTaxType() {
        return this.taxType;
    }

    public String getMasterItem() {
        return this.masterItem;
    }

    public String getItemAccountingRef() {
        return this.itemAccountingRef;
    }
}

