/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;
import IntegratorDataObjects.XmlEmployee;
import java.util.ArrayList;
import java.util.Vector;

public class XmlPrEmployees {
    private ArrayList<XmlEmployee> employees;
    private String payTypes;

    public XmlPrEmployees(ArrayList<XmlEmployee> employees, String payTypes) {
        this.employees = employees;
        this.payTypes = payTypes;
    }

    public XmlPrEmployees(String xmlString) {
        String employeesXml = Utility.getElement("employees", xmlString);
        Vector employeeStrings = Utility.getElementList("employee", employeesXml);
        ArrayList<XmlEmployee> employeesList = new ArrayList<XmlEmployee>();
        int numEmployees = 0;
        if (employeeStrings != null && !employeeStrings.isEmpty()) {
            numEmployees = employeeStrings.size();
        }
        for (int i = 0; i < numEmployees; ++i) {
            String thisEmployeeXml = (String)employeeStrings.get(i);
            XmlEmployee thisEmployee = new XmlEmployee(thisEmployeeXml);
            employeesList.add(thisEmployee);
        }
        this.employees = employeesList;
        this.payTypes = Utility.getElement("payTypes", xmlString);
    }

    public XmlPrEmployees() {
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<PrEmployees>");
        xml.append("<employees>");
        int numEmployees = 0;
        if (this.employees != null && !this.employees.isEmpty()) {
            numEmployees = this.employees.size();
        }
        for (int i = 0; i < numEmployees; ++i) {
            XmlEmployee employeeNode = this.employees.get(i);
            xml.append(employeeNode.toXml());
        }
        xml.append("</employees>");
        xml.append("<payTypes>" + this.payTypes + "</payTypes>");
        xml.append("</PrEmployees>");
        return xml.toString();
    }

    public void setEmployees(ArrayList employees) {
        this.employees = employees;
    }

    public void setPayTypes(String payTypes) {
        this.payTypes = payTypes;
    }

    public ArrayList getEmployees() {
        return this.employees;
    }

    public String getPayTypes() {
        return this.payTypes;
    }
}

