/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;
import IntegratorDataObjects.XmlInvoices;

public class XmlSales {
    private XmlInvoices invoices = new XmlInvoices();
    private String taxCode = "";

    public XmlSales(XmlInvoices invoices, String taxCode) {
        this.invoices = invoices;
        this.taxCode = taxCode;
    }

    public XmlSales(String xmlString) {
        this.invoices = new XmlInvoices(Utility.getElement("invoices", xmlString));
        this.taxCode = Utility.getElement("salesTaxCode", xmlString);
    }

    public XmlSales() {
    }

    public String toXml() {
        return this.toXml(true);
    }

    public String toXml(boolean legacySupport) {
        StringBuilder xml = new StringBuilder();
        xml.append("\r\n<Sales>\r\n");
        xml.append(this.invoices.toXml(legacySupport));
        xml.append("<taxCode>" + this.taxCode + "</taxCode>" + "\r\n");
        if (!legacySupport) {
            xml.append("<salesTaxCode>" + this.taxCode + "</salesTaxCode>" + "\r\n");
        }
        xml.append("</Sales>\r\n");
        return xml.toString();
    }

    public void setInvoices(XmlInvoices invoices) {
        this.invoices = invoices;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public XmlInvoices getInvoices() {
        return this.invoices;
    }

    public String getTaxCode() {
        return this.taxCode;
    }
}

