/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import org.json.JSONException;
import org.json.JSONObject;

public class AlternateTax {
    public int id = 0;
    public String itemType = "";
    public String taxAuthority = "";
    public double taxRate = 0.0;
    public double taxableSubTotal = 0.0;
    public double tax = 0.0;

    public AlternateTax() {
    }

    public AlternateTax(String itemType, String taxAuthority, double taxRate, double taxableSubTotal, double tax) {
        this.itemType = itemType;
        this.taxAuthority = taxAuthority;
        this.taxRate = taxRate;
        this.taxableSubTotal = taxableSubTotal;
        this.tax = tax;
    }

    public AlternateTax(String xml) {
        this.id = Utility.getIntElement("Id", xml);
        this.itemType = Utility.getElement("ItemType", xml);
        this.taxAuthority = Utility.getElement("TaxAuthority", xml);
        this.taxRate = Utility.getDoubleElement("TaxRate", xml);
        this.taxableSubTotal = Utility.getDoubleElement("SubTotal", xml);
        this.tax = Utility.getDoubleElement("Tax", xml);
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<AlternateTax>");
        xml.append("<Id>" + this.id + "</Id>");
        xml.append("<ItemType>" + this.itemType + "</ItemType>");
        xml.append("<TaxAuthority>" + this.taxAuthority + "</TaxAuthority>");
        xml.append("<TaxRate>" + this.taxRate + "</TaxRate>");
        xml.append("<SubTotal>" + this.taxableSubTotal + "</SubTotal>");
        xml.append("<Tax>" + this.tax + "</Tax>");
        xml.append("</AlternateTax>");
        return xml.toString();
    }

    public String toString() {
        return "itemType=" + this.itemType + ", auth=" + this.taxAuthority + ", rate=" + this.taxRate + ", subtotal=" + this.taxableSubTotal + ", tax=" + this.tax;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj == null || obj.getClass() != this.getClass()) {
            return result;
        }
        result = this.taxAuthority.equals(((AlternateTax)obj).taxAuthority) && this.itemType.equals(((AlternateTax)obj).itemType);
        return result;
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("id", this.id);
            jsonObject.put("itemType", (Object)this.itemType);
            jsonObject.put("taxAuthority", (Object)this.taxAuthority);
            jsonObject.put("taxRate", this.taxRate);
            jsonObject.put("taxableSubTotal", this.taxableSubTotal);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    public AlternateTax(JSONString jsonString) {
        this.id = Utility.getJSONInt(jsonString.toString(), "id");
        this.itemType = Utility.getJSONString(jsonString.toString(), "itemType");
        this.taxAuthority = Utility.getJSONString(jsonString.toString(), "taxAuthority");
        this.taxRate = Utility.getJSONDouble(jsonString.toString(), "taxRate");
        this.taxableSubTotal = Utility.getJSONDouble(jsonString.toString(), "taxableSubTotal");
    }
}

