/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;

public class Check {
    public boolean isPersonalCheck = false;
    public boolean isCorporateCheck = false;
    public boolean isPersonalAuthenticateCheck = false;
    public boolean isWebCheck = false;
    public String firstName = "";
    public String middleInitial = "";
    public String lastName = "";
    public String address = "";
    public String city = "";
    public String state = "";
    public String zip = "";
    public String email = "";
    public String routeNumber = "";
    public String acctNumber = "";
    public boolean isCheckingAcct = true;
    public String ein = "";
    public String ssn = "";
    public String dlState = "";
    public String dlNumber = "";
    public String dob = "";

    public Check() {
    }

    public Check(String xml) {
        this.isPersonalCheck = Utility.getBooleanElement("IS_PERSONAL_CHECK", xml);
        this.isCorporateCheck = Utility.getBooleanElement("IS_CORPORATE_CHECK", xml);
        this.isPersonalAuthenticateCheck = Utility.getBooleanElement("IS_PERSONAL_AUTHENTICATE_CHECK", xml);
        this.isWebCheck = Utility.getBooleanElement("IS_WEB_CHECK", xml);
        this.firstName = Utility.getElement("FIRST_NAME", xml);
        this.middleInitial = Utility.getElement("MIDDLE_INITIAL", xml);
        this.lastName = Utility.getElement("LAST_NAME", xml);
        this.address = Utility.getElement("ADDRESS", xml);
        this.city = Utility.getElement("CITY", xml);
        this.state = Utility.getElement("STATE", xml);
        this.zip = Utility.getElement("ZIP", xml);
        this.email = Utility.getElement("EMAIL", xml);
        this.routeNumber = Utility.getElement("ROUTE_NUMBER", xml);
        this.acctNumber = Utility.getElement("ACCT_NUMBER", xml);
        this.isCheckingAcct = Utility.getBooleanElement("IS_CHECKING_ACCT", xml);
        this.ein = Utility.getElement("EIN", xml);
        this.ssn = Utility.getElement("SSN", xml);
        this.dlState = Utility.getElement("DL_STATE", xml);
        this.dlNumber = Utility.getElement("DL_NUMBER", xml);
        this.dob = Utility.getElement("DOB", xml);
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<CHECK>\r\n");
        xml.append("  <IS_PERSONAL_CHECK>" + this.isPersonalCheck + "</IS_PERSONAL_CHECK>\r\n");
        xml.append("  <IS_CORPORATE_CHECK>" + this.isCorporateCheck + "</IS_CORPORATE_CHECK>\r\n");
        xml.append("  <IS_PERSONAL_AUTHENTICATE_CHECK>" + this.isPersonalAuthenticateCheck + "</IS_PERSONAL_AUTHENTICATE_CHECK>\r\n");
        xml.append("  <IS_WEB_CHECK>" + this.isWebCheck + "</IS_WEB_CHECK>\r\n");
        xml.append("  <FIRST_NAME>" + this.firstName + "</FIRST_NAME>\r\n");
        xml.append("  <MIDDLE_INITIAL>" + this.middleInitial + "</MIDDLE_INITIAL>\r\n");
        xml.append("  <LAST_NAME>" + this.lastName + "</LAST_NAME>\r\n");
        xml.append("  <ADDRESS>" + this.address + "</ADDRESS>\r\n");
        xml.append("  <CITY>" + this.city + "</CITY>\r\n");
        xml.append("  <STATE>" + this.state + "</STATE>\r\n");
        xml.append("  <ZIP>" + this.zip + "</ZIP>\r\n");
        xml.append("  <EMAIL>" + this.email + "</EMAIL>\r\n");
        xml.append("  <ROUTE_NUMBER>" + this.routeNumber + "</ROUTE_NUMBER>\r\n");
        xml.append("  <ACCT_NUMBER>" + this.acctNumber + "</ACCT_NUMBER>\r\n");
        xml.append("  <IS_CHECKING_ACCT>" + this.isCheckingAcct + "</IS_CHECKING_ACCT>\r\n");
        xml.append("  <EIN>" + this.ein + "</EIN>\r\n");
        xml.append("  <SSN>" + this.ssn + "</SSN>\r\n");
        xml.append("  <DL_STATE>" + this.dlState + "</DL_STATE>\r\n");
        xml.append("  <DL_NUMBER>" + this.dlNumber + "</DL_NUMBER>\r\n");
        xml.append("  <DOB>" + this.dob + "</DOB>\r\n");
        xml.append("</CHECK>\r\n");
        return xml.toString();
    }
}

