/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.ComoExtendedDiscount;
import java.util.Vector;

public class ComoBenefit {
    public String code = "";
    public String description = "";
    public double discountAmount = 0.0;
    public Vector extendedDiscounts = null;

    public ComoBenefit() {
    }

    public ComoBenefit(String thisBenefitXml) {
        this.code = Utility.getElement("Code", thisBenefitXml);
        this.description = Utility.getElement("Description", thisBenefitXml);
        this.discountAmount = Utility.getDoubleElement("DiscountAmount", thisBenefitXml);
        String extendedDiscountsXml = Utility.getElement("ExtendedDiscounts", thisBenefitXml);
        Vector extendedDiscountsList = Utility.getElementList("ComoExtendedDiscount", extendedDiscountsXml);
        int len = extendedDiscountsList.size();
        for (int i = 0; i < len; ++i) {
            String thisExtendedDiscountXml = (String)extendedDiscountsList.get(i);
            ComoExtendedDiscount thisExtendedDiscount = new ComoExtendedDiscount(thisExtendedDiscountXml);
            if (this.extendedDiscounts == null) {
                this.extendedDiscounts = new Vector();
            }
            this.extendedDiscounts.add(thisExtendedDiscount);
        }
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        StringBuffer extendedDiscountsXml = new StringBuffer();
        int len = 0;
        if (this.extendedDiscounts != null) {
            len = this.extendedDiscounts.size();
        }
        for (int i = 0; i < len; ++i) {
            ComoExtendedDiscount thisExtendedDiscount = (ComoExtendedDiscount)this.extendedDiscounts.get(i);
            extendedDiscountsXml.append(thisExtendedDiscount.toXml());
        }
        xml.append("<ComoBenefit>");
        xml.append("<Code>" + this.code + "</Code>");
        xml.append("<Description>" + this.description + "</Description>");
        xml.append("<ExtendedDiscounts>" + extendedDiscountsXml.toString() + "</ExtendedDiscounts>\r\n");
        xml.append("<DiscountAmount>" + this.discountAmount + "</DiscountAmount>");
        xml.append("</ComoBenefit>\r\n");
        return xml.toString();
    }

    public boolean isDiscount() {
        boolean isDiscount = false;
        if (this.description != null && !this.description.isEmpty() && this.discountAmount > 0.0) {
            isDiscount = true;
        }
        return isDiscount;
    }

    public boolean hasExtendedDiscount() {
        boolean hasExtendedDiscount = false;
        if (this.description != null && !this.description.isEmpty() && this.discountAmount > 0.0 && this.extendedDiscounts != null && this.extendedDiscounts.size() > 0) {
            hasExtendedDiscount = true;
        }
        return hasExtendedDiscount;
    }
}

