/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.ComoLoyaltyItem;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class ComoClubMember {
    public String code = "";
    public String email = "";
    public String mobile = "";
    public String carrier = "";
    public String firstName = "";
    public String middleName = "";
    public String lastName = "";
    public Date birthday = null;
    public Timestamp memberSince = null;
    public double budgetPoints = 0.0;
    public Vector giftItems = new Vector();

    public ComoClubMember() {
    }

    public ComoClubMember(String thisMemberXml) {
        this.code = Utility.getElement("Code", thisMemberXml);
        this.email = Utility.getElement("Email", thisMemberXml);
        this.firstName = Utility.getElement("FirstName", thisMemberXml);
        this.middleName = Utility.getElement("MiddleName", thisMemberXml);
        this.lastName = Utility.getElement("LastName", thisMemberXml);
        String birthDayDate = Utility.getElement("Birthday", thisMemberXml);
        if (birthDayDate.equals("null") || birthDayDate == null || birthDayDate.length() == 0) {
            this.birthday = null;
        } else {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("MM.dd.yyyy");
            try {
                this.birthday = dateFormatter.parse(birthDayDate);
            }
            catch (Exception e) {
                this.birthday = null;
            }
        }
        String memberSinceDate = Utility.getElement("MemberSince", thisMemberXml);
        this.memberSince = memberSinceDate.equals("null") || memberSinceDate == null || memberSinceDate.length() == 0 ? null : Timestamp.valueOf(memberSinceDate);
        this.budgetPoints = Utility.getDoubleElement("BudgetPoints", thisMemberXml);
        Vector giftItemsListXml = Utility.getElementList("ComoLoyaltyItem", thisMemberXml);
        int len = giftItemsListXml.size();
        for (int i = 0; i < len; ++i) {
            String thisAssetXml = (String)giftItemsListXml.get(i);
            ComoLoyaltyItem thisLoyaltyItem = new ComoLoyaltyItem(thisAssetXml);
            this.giftItems.add(thisLoyaltyItem);
        }
    }

    public String toXml() {
        DecimalFormat decimal = new DecimalFormat("####0.00;-####0.00");
        SimpleDateFormat dateFormatter = new SimpleDateFormat("MM.dd.yyyy");
        StringBuffer xml = new StringBuffer();
        xml.append("<ComoClubMember>");
        xml.append("<Code>" + this.code + "</Code>");
        xml.append("<Email>" + this.email + "</Email>");
        xml.append("<FirstName>" + this.firstName + "</FirstName>");
        xml.append("<MiddleName>" + this.middleName + "</MiddleName>");
        xml.append("<LastName>" + this.lastName + "</LastName>");
        xml.append("<Birthday>" + dateFormatter.format(this.birthday) + "</Birthday>");
        xml.append("<MemberSince>" + this.memberSince + "</MemberSince>");
        xml.append("<BudgetPoints>" + decimal.format(this.budgetPoints) + "</BudgetPoints>");
        int len = 0;
        if (this.giftItems != null) {
            len = this.giftItems.size();
        }
        for (int i = 0; i < len; ++i) {
            ComoLoyaltyItem thisLoyaltyItem = (ComoLoyaltyItem)this.giftItems.get(i);
            String thisAssetXml = thisLoyaltyItem.toXml();
            xml.append(thisAssetXml);
        }
        xml.append("</ComoClubMember>\r\n");
        return xml.toString();
    }
}

