/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.SummaryData;
import POSDataObjects.VatSummaryData;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DataSummary {
    public Hashtable items = new Hashtable();
    public Hashtable tenders = new Hashtable();
    public Hashtable taxes = new Hashtable();
    public Hashtable voids = new Hashtable();
    public Hashtable vatTaxes = new Hashtable();
    public int guestCount = 0;
    public double itemQuantityTotal = 0.0;
    public double itemTotal = 0.0;
    public double tenderingTotal = 0.0;
    public double taxTotal = 0.0;
    public double vat1Tax = 0.0;
    public double vat2Tax = 0.0;
    public double voidQuantityTotal = 0.0;
    public double voidTotal = 0.0;
    public double tipsTotal = 0.0;
    public double tipsPaid = 0.0;
    public double netCash = 0.0;
    public double autoGratuity = 0.0;
    public double reportTaxable = 0.0;
    public double reportNontaxable = 0.0;
    public double customerPayments = 0.0;
    public double compTotal = 0.0;
    public double payoutsTotal = 0.0;
    public double salesDiscountTotal = 0.0;
    public double priceChangeTotal = 0.0;

    public DataSummary() {
    }

    public DataSummary(String xml) {
        String vatTaxesXml;
        Vector vatSummarys;
        String taxesXml;
        Vector taxesSummarys;
        String tendersXml;
        Vector tendersSummarys;
        String voidsXml;
        Vector voidsSummarys;
        String itemsXml = Utility.getElement("Items", xml);
        Vector itemsSummarys = Utility.getElementList("Summary", itemsXml);
        if (itemsSummarys != null) {
            int len = itemsSummarys.size();
            for (int i = 0; i < len; ++i) {
                String summaryXml = (String)itemsSummarys.get(i);
                SummaryData thisSummary = new SummaryData(summaryXml);
                this.items.put(thisSummary.name, thisSummary);
            }
        }
        if ((voidsSummarys = Utility.getElementList("Summary", voidsXml = Utility.getElement("Voids", xml))) != null) {
            int len = voidsSummarys.size();
            for (int i = 0; i < len; ++i) {
                String summaryXml = (String)voidsSummarys.get(i);
                SummaryData thisSummary = new SummaryData(summaryXml);
                this.voids.put(thisSummary.name, thisSummary);
            }
        }
        if ((tendersSummarys = Utility.getElementList("Summary", tendersXml = Utility.getElement("Tenders", xml))) != null) {
            int len = tendersSummarys.size();
            for (int i = 0; i < len; ++i) {
                String summaryXml = (String)tendersSummarys.get(i);
                SummaryData thisSummary = new SummaryData(summaryXml);
                this.tenders.put(thisSummary.name, thisSummary);
            }
        }
        if ((taxesSummarys = Utility.getElementList("Summary", taxesXml = Utility.getElement("Taxes", xml))) != null) {
            int len = taxesSummarys.size();
            for (int i = 0; i < len; ++i) {
                String summaryXml = (String)taxesSummarys.get(i);
                SummaryData thisSummary = new SummaryData(summaryXml);
                this.taxes.put(thisSummary.name, thisSummary);
            }
        }
        if ((vatSummarys = Utility.getElementList("VatSummary", vatTaxesXml = Utility.getElement("VatTaxes", xml))) != null) {
            int len = vatSummarys.size();
            for (int i = 0; i < len; ++i) {
                String summaryXml = (String)vatSummarys.get(i);
                VatSummaryData thisSummary = new VatSummaryData(summaryXml);
                this.vatTaxes.put(thisSummary.vatCode, thisSummary);
            }
        }
        this.guestCount = Utility.getIntElement("GuestCount", xml);
        this.itemQuantityTotal = Utility.getDoubleElement("ItemQuantityTotal", xml);
        this.itemTotal = Utility.getDoubleElement("ItemTotal", xml);
        this.tenderingTotal = Utility.getDoubleElement("TenderingTotal", xml);
        this.taxTotal = Utility.getDoubleElement("TaxTotal", xml);
        this.vat1Tax = Utility.getDoubleElement("Vat1Tax", xml);
        this.vat2Tax = Utility.getDoubleElement("Vat2Tax", xml);
        this.voidQuantityTotal = Utility.getDoubleElement("VoidQuantityTotal", xml);
        this.voidTotal = Utility.getDoubleElement("VoidTotal", xml);
        this.tipsTotal = Utility.getDoubleElement("TipsTotal", xml);
        this.tipsPaid = Utility.getDoubleElement("TipsPaid", xml);
        this.netCash = Utility.getDoubleElement("NetCash", xml);
        this.autoGratuity = Utility.getDoubleElement("AutoGratuity", xml);
        this.reportTaxable = Utility.getDoubleElement("ReportTaxable", xml);
        this.reportNontaxable = Utility.getDoubleElement("ReportNontaxable", xml);
        this.customerPayments = Utility.getDoubleElement("CustomerPayments", xml);
        this.compTotal = Utility.getDoubleElement("CompTotal", xml);
        this.payoutsTotal = Utility.getDoubleElement("PayoutsTotal", xml);
    }

    public String toXml() {
        Object thisSummary;
        String key;
        Enumeration e;
        StringBuilder xml = new StringBuilder();
        if (!this.items.isEmpty()) {
            xml.append("<Items>");
            e = this.items.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                thisSummary = (SummaryData)this.items.get(key);
                xml.append(((SummaryData)thisSummary).toXml());
            }
            xml.append("</Items>");
        }
        if (!this.voids.isEmpty()) {
            xml.append("<Voids>");
            e = this.voids.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                thisSummary = (SummaryData)this.voids.get(key);
                xml.append(((SummaryData)thisSummary).toXml());
            }
            xml.append("</Voids>");
        }
        if (!this.tenders.isEmpty()) {
            xml.append("<Tenders>");
            e = this.tenders.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                thisSummary = (SummaryData)this.tenders.get(key);
                xml.append(((SummaryData)thisSummary).toXml());
            }
            xml.append("</Tenders>");
        }
        if (!this.taxes.isEmpty()) {
            xml.append("<Taxes>");
            e = this.taxes.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                thisSummary = (SummaryData)this.taxes.get(key);
                xml.append(((SummaryData)thisSummary).toXml());
            }
            xml.append("</Taxes>");
        }
        if (!this.vatTaxes.isEmpty()) {
            xml.append("<VatTaxes>");
            e = this.vatTaxes.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                thisSummary = (VatSummaryData)this.vatTaxes.get(key);
                xml.append(((VatSummaryData)thisSummary).toXml());
            }
            xml.append("</VatTaxes>");
        }
        xml.append("<GuestCount>" + this.guestCount + "</GuestCount>");
        xml.append("<ItemQuantityTotal>" + this.itemQuantityTotal + "</ItemQuantityTotal>");
        xml.append("<ItemTotal>" + this.itemTotal + "</ItemTotal>");
        xml.append("<TenderingTotal>" + this.tenderingTotal + "</TenderingTotal>");
        xml.append("<TaxTotal>" + this.taxTotal + "</TaxTotal>");
        xml.append("<Vat1Tax>" + this.vat1Tax + "</Vat1Tax>");
        xml.append("<Vat2Tax>" + this.vat2Tax + "</Vat2Tax>");
        xml.append("<VoidQuantityTotal>" + this.voidQuantityTotal + "</VoidQuantityTotal>");
        xml.append("<VoidTotal>" + this.voidTotal + "</VoidTotal>");
        xml.append("<TipsTotal>" + this.tipsTotal + "</TipsTotal>");
        xml.append("<TipsPaid>" + this.tipsPaid + "</TipsPaid>");
        xml.append("<NetCash>" + this.netCash + "</NetCash>");
        xml.append("<AutoGratuity>" + this.autoGratuity + "</AutoGratuity>");
        xml.append("<ReportTaxable>" + this.reportTaxable + "</ReportTaxable>");
        xml.append("<ReportNontaxable>" + this.reportNontaxable + "</ReportNontaxable>");
        xml.append("<CustomerPayments>" + this.customerPayments + "</CustomerPayments>");
        xml.append("<CompTotal>" + this.compTotal + "</CompTotal>");
        xml.append("<PayoutsTotal>" + this.payoutsTotal + "</PayoutsTotal>");
        return xml.toString();
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        JSONArray itemsArray = new JSONArray();
        if (!this.items.isEmpty()) {
            Enumeration e = this.items.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                SummaryData thisSummary = (SummaryData)this.items.get(key);
                itemsArray.put((Object)thisSummary.toJson());
            }
        }
        JSONArray tendersArray = new JSONArray();
        if (!this.tenders.isEmpty()) {
            Enumeration e = this.tenders.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                SummaryData thisSummary = (SummaryData)this.tenders.get(key);
                tendersArray.put((Object)thisSummary.toJson());
            }
        }
        JSONArray taxesArray = new JSONArray();
        if (!this.taxes.isEmpty()) {
            Enumeration e = this.taxes.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                SummaryData thisSummary = (SummaryData)this.taxes.get(key);
                taxesArray.put((Object)thisSummary.toJson());
            }
        }
        JSONArray voidsArray = new JSONArray();
        if (!this.voids.isEmpty()) {
            Enumeration e = this.voids.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                SummaryData thisSummary = (SummaryData)this.voids.get(key);
                voidsArray.put((Object)thisSummary.toJson());
            }
        }
        JSONArray vatTaxesArray = new JSONArray();
        if (!this.vatTaxes.isEmpty()) {
            Enumeration e = this.vatTaxes.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                VatSummaryData thisSummary = (VatSummaryData)this.vatTaxes.get(key);
                vatTaxesArray.put((Object)thisSummary.toJson());
            }
        }
        try {
            jsonObject.put("guestCount", this.guestCount);
            jsonObject.put("itemQuantityTotal", this.itemQuantityTotal);
            jsonObject.put("tenderingTotal", this.tenderingTotal);
            jsonObject.put("itemTotal", this.itemTotal);
            jsonObject.put("taxTotal", this.taxTotal);
            jsonObject.put("vat1Tax", this.vat1Tax);
            jsonObject.put("vat2Tax", this.vat2Tax);
            jsonObject.put("voidQuantityTotal", this.voidQuantityTotal);
            jsonObject.put("voidTotal", this.voidTotal);
            jsonObject.put("tipsTotal", this.tipsTotal);
            jsonObject.put("tipsPaid", this.tipsPaid);
            jsonObject.put("netCash", this.netCash);
            jsonObject.put("autoGratuity", this.autoGratuity);
            jsonObject.put("reportTaxable", this.reportTaxable);
            jsonObject.put("reportNontaxable", this.reportNontaxable);
            jsonObject.put("customerPayments", this.customerPayments);
            jsonObject.put("compTotal", this.compTotal);
            jsonObject.put("payoutsTotal", this.payoutsTotal);
            jsonObject.put("salesDiscountTotal", this.salesDiscountTotal);
            jsonObject.put("priceChangeTotal", this.priceChangeTotal);
            jsonObject.put("items", (Object)itemsArray);
            jsonObject.put("tenders", (Object)tendersArray);
            jsonObject.put("taxes", (Object)taxesArray);
            jsonObject.put("voids", (Object)voidsArray);
            jsonObject.put("vatTaxes", (Object)vatTaxesArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }
}

