/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.DisplayItem;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Vector;

public class DisplayOrder
implements Serializable {
    public long number;
    public ArrayList items;
    public String name;
    public String request;
    public String table;
    public String server;
    public String userGroup;
    public boolean carryOutOrder;
    public String till;
    public int guestCount;
    public boolean fireOrder = false;
    public boolean delivery = false;
    public boolean reprint = false;
    public Timestamp created = null;
    public String processStatus = "";
    public int ticketNumber;
    public String currentCourse;

    public DisplayOrder() {
    }

    public DisplayOrder(long xNumber, ArrayList xItems, String xName, String request, boolean carryOut, int guestCount) {
        this.number = xNumber;
        this.items = xItems;
        this.name = xName;
        this.request = request;
        this.carryOutOrder = carryOut;
        this.guestCount = guestCount;
    }

    public void setUserGroup(String userGroup) {
        this.userGroup = userGroup;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String toXml() {
        StringBuilder itemsXml = new StringBuilder();
        int len = this.items.size();
        for (int i = 0; i < len; ++i) {
            DisplayItem thisLine = (DisplayItem)this.items.get(i);
            itemsXml.append(thisLine.toXml());
        }
        StringBuilder xml = new StringBuilder();
        xml.append("<Order>\r\n");
        xml.append("  <Number>" + this.number + "</Number>\r\n");
        xml.append("  <Name>" + this.name + "</Name>\r\n");
        xml.append("  <Request>" + this.request + "</Request>\r\n");
        xml.append("  <Table>" + this.table + "</Table>\r\n");
        xml.append("  <Server>" + this.server + "</Server>\r\n");
        xml.append("  <UserGroup>" + this.userGroup + "</UserGroup>\r\n");
        xml.append("  <Till>" + this.till + "</Till>\r\n");
        xml.append("  <CarryOut>" + this.carryOutOrder + "</CarryOut>\r\n");
        xml.append("  <GuestCount>" + this.guestCount + "</GuestCount>\r\n");
        xml.append("  <Items>" + itemsXml.toString() + "</Items>\r\n");
        xml.append("  <FireOrder>" + this.fireOrder + "</FireOrder>\r\n");
        xml.append("  <Delivery>" + this.delivery + "</Delivery>\r\n");
        if (this.created != null) {
            xml.append("  <Created>" + this.created.getTime() + "</Created>\r\n");
        }
        xml.append("  <OrderProcessStatus>" + this.processStatus + "</OrderProcessStatus>\r\n");
        xml.append("  <TicketNumber>" + this.ticketNumber + "</TicketNumber>\r\n");
        xml.append("  <CurrentCourse>" + this.currentCourse + "</CurrentCourse>\r\n");
        xml.append("</Order>\r\n");
        return xml.toString();
    }

    public DisplayOrder(String xml) {
        this.number = Utility.getLongElement("Number", xml);
        this.name = Utility.getElement("Name", xml);
        this.request = Utility.getElement("Request", xml);
        this.table = Utility.getElement("Table", xml);
        this.server = Utility.getElement("Server", xml);
        this.userGroup = Utility.getElement("UserGroup", xml);
        this.carryOutOrder = Utility.getBooleanElement("CarryOut", xml);
        this.guestCount = Utility.getIntElement("GuestCount", xml);
        this.delivery = Utility.getBooleanElement("Delivery", xml);
        this.till = Utility.getElement("Till", xml);
        this.items = new ArrayList();
        String itemsXml = Utility.getElement("Items", xml);
        Vector itemsList = Utility.getElementList("Item", itemsXml);
        int len = itemsList.size();
        for (int i = 0; i < len; ++i) {
            String itemXml = (String)itemsList.get(i);
            DisplayItem item = new DisplayItem(itemXml);
            this.items.add(item);
        }
        long createdDate = Utility.getLongElement("Created", xml);
        if (createdDate > 0L) {
            this.created = new Timestamp(createdDate);
        }
        this.processStatus = Utility.getElement("OrderProcessStatus", xml);
        this.ticketNumber = Utility.getIntElement("TicketNumber", xml);
        this.currentCourse = Utility.getElement("CurrentCourse", xml);
    }
}

