/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import java.util.ArrayList;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DisplayPrinter {
    public ArrayList itemTypes;
    public ArrayList tills;
    public String name;
    public String address;
    public boolean isMonitor;
    public boolean isLabelPrinter;
    public boolean printLabelsForAllTypes;
    public String excludeGroup;
    public String templateName;
    public int pageWidth = 600;

    public DisplayPrinter(String xName) {
        this.name = xName;
        this.itemTypes = new ArrayList();
    }

    public DisplayPrinter() {
        this.itemTypes = new ArrayList();
        this.tills = new ArrayList();
    }

    public void setExcludeGroup(String exclude) {
        this.excludeGroup = this.excludeGroup == null || this.excludeGroup.isEmpty() ? exclude : this.excludeGroup + "||" + exclude;
    }

    public DisplayPrinter(String xml, boolean isXml) {
        Vector tillList;
        this.name = Utility.getElement("DisplayName", xml);
        this.address = Utility.getElement("DisplayAddress", xml);
        this.isMonitor = Utility.getBooleanElement("IsMonitor", xml);
        this.isLabelPrinter = Utility.getBooleanElement("IsLabelPrinter", xml);
        this.excludeGroup = Utility.getElement("ExcludeGroup", xml);
        this.templateName = Utility.getElement("TemplateName", xml);
        this.pageWidth = Utility.getIntElement("PageWidth", xml);
        Vector itemTypesList = Utility.getElementList("ItemType", xml);
        int len = itemTypesList.size();
        if (len > 0) {
            this.itemTypes = new ArrayList();
            for (int i = 0; i < len; ++i) {
                String thisItemType = (String)itemTypesList.get(i);
                this.itemTypes.add(thisItemType);
            }
        }
        if ((len = (tillList = Utility.getElementList("TillName", xml)).size()) > 0) {
            this.tills = new ArrayList();
            for (int i = 0; i < len; ++i) {
                String thisTill = (String)tillList.get(i);
                this.tills.add(thisTill);
            }
        }
    }

    public String toXml() {
        int i;
        int len;
        StringBuffer xml = new StringBuffer();
        xml.append("<DisplayPrinter>");
        xml.append("<DisplayName>" + this.name + "</DisplayName>");
        xml.append("<DisplayAddress>" + this.address + "</DisplayAddress>");
        xml.append("<IsMonitor>" + this.isMonitor + "</IsMonitor>");
        xml.append("<IsLabelPrinter>" + this.isLabelPrinter + "</IsLabelPrinter>");
        xml.append("<ExcludeGroup>" + this.excludeGroup + "</ExcludeGroup>");
        xml.append("<TemplateName>" + this.templateName + "</TemplateName>");
        xml.append("<PageWidth>" + this.pageWidth + "</PageWidth>");
        if (this.itemTypes != null) {
            len = this.itemTypes.size();
            for (i = 0; i < len; ++i) {
                String thisItemType = (String)this.itemTypes.get(i);
                xml.append("<ItemType>" + thisItemType + "</ItemType>");
            }
        }
        if (this.tills != null) {
            len = this.tills.size();
            for (i = 0; i < len; ++i) {
                String thisTill = (String)this.tills.get(i);
                xml.append("<TillName>" + thisTill + "</TillName>");
            }
        }
        xml.append("</DisplayPrinter>");
        return xml.toString();
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            JSONArray jsonArrayitemTypes = new JSONArray();
            for (int i = 0; i < this.itemTypes.size(); ++i) {
                String currentItemType = (String)this.itemTypes.get(i);
                try {
                    jsonArrayitemTypes.put((Object)currentItemType);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            JSONArray jsonArrayTills = new JSONArray();
            for (int i = 0; i < this.tills.size(); ++i) {
                Object currentTill = this.tills.get(i);
                try {
                    jsonArrayTills.put(currentTill);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            jsonObject.put("itemTypes", (Object)jsonArrayitemTypes);
            jsonObject.put("tills", (Object)jsonArrayTills);
            jsonObject.put("name", (Object)this.name);
            jsonObject.put("address", (Object)this.address);
            jsonObject.put("isMonitor", this.isMonitor);
            jsonObject.put("isLabelPrinter", this.isLabelPrinter);
            jsonObject.put("excludeGroup", (Object)this.excludeGroup);
            jsonObject.put("templateName", (Object)this.templateName);
            jsonObject.put("pageWidth", this.pageWidth);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    public DisplayPrinter(JSONString jsonString) {
        this.name = Utility.getJSONString(jsonString.toString(), "name");
        this.address = Utility.getJSONString(jsonString.toString(), "address");
        this.pageWidth = Utility.getJSONInt(jsonString.toString(), "pageWidth");
        this.templateName = Utility.getJSONString(jsonString.toString(), "templateName");
        this.isMonitor = Utility.getJSONBoolean(jsonString.toString(), "isMonitor");
        this.isLabelPrinter = Utility.getJSONBoolean(jsonString.toString(), "isLabelPrinter");
        this.excludeGroup = Utility.getJSONString(jsonString.toString(), "userGroup");
        JSONObject json = null;
        JSONArray itemTypesJsonArray = null;
        JSONArray tillsJsonArray = null;
        try {
            json = new JSONObject(jsonString.toString());
            itemTypesJsonArray = json.getJSONArray("itemTypes");
            tillsJsonArray = json.getJSONArray("tills");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (itemTypesJsonArray.length() > 0) {
            int i;
            this.itemTypes = new ArrayList();
            this.tills = new ArrayList();
            for (i = 0; i < itemTypesJsonArray.length(); ++i) {
                try {
                    String thisItemType = itemTypesJsonArray.getString(i);
                    this.itemTypes.add(thisItemType);
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            for (i = 0; i < tillsJsonArray.length(); ++i) {
                try {
                    String thisTill = tillsJsonArray.getString(i);
                    this.tills.add(thisTill);
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

