/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;

public class GratuitySetup {
    public boolean tipsHandling = false;
    public int includeTipLimit = 0;
    public boolean sendTips = false;

    public GratuitySetup(boolean tipsHandling, int includeTipLimit, boolean sendTips) {
        this.tipsHandling = tipsHandling;
        this.includeTipLimit = includeTipLimit;
        this.sendTips = sendTips;
    }

    public GratuitySetup(String xml) {
        this.tipsHandling = Utility.getBooleanElement("TipsHandling", xml);
        this.includeTipLimit = Utility.getIntElement("IncludeTipLimit", xml);
        this.sendTips = Utility.getBooleanElement("SendTips", xml);
    }

    public GratuitySetup(JSONString jsonString) {
        this.tipsHandling = Utility.getJSONBoolean(jsonString.toString(), "gratuityHandling");
        this.includeTipLimit = Utility.getJSONInt(jsonString.toString(), "gratutityInclusion");
        this.sendTips = Utility.getJSONBoolean(jsonString.toString(), "sendTips");
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<GratuitySetup>");
        xml.append("<TipsHandling>" + this.tipsHandling + "</TipsHandling>");
        xml.append("<IncludeTipLimit>" + this.includeTipLimit + "</IncludeTipLimit>");
        xml.append("<SendTips>" + this.sendTips + "</SendTips>");
        xml.append("</GratuitySetup>");
        return xml.toString();
    }
}

