/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.FollowOn;
import POSDataObjects.ItemExtended;
import POSDataObjects.ItemGroup;
import POSDataObjects.JSONString;
import POSDataObjects.SalePrice;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Vector;
import org.json.JSONException;
import org.json.JSONObject;

public class Item {
    public String code = "";
    public String name = "";
    public double price = 0.0;
    public double list = 0.0;
    public boolean changed = false;
    public String accountingCode = null;
    public String description = null;
    public String alternateDescription = null;
    public String type = null;
    public double price1 = 0.0;
    public double price2 = 0.0;
    public double price3 = 0.0;
    public double price4 = 0.0;
    public double price5 = 0.0;
    public String UOM = " ";
    public String salesAccount = " ";
    public double cost = 0.0;
    public boolean taxable = true;
    public boolean scale = false;
    public String notes = " ";
    public boolean noDiscount = false;
    public String vatCode = "";
    public boolean trackAvailable = false;
    public String trackAvailableOption = "";
    public int warnAvailableNumber = 5;
    public double available = 0.0;
    public boolean isStock = false;
    public String choiceGroup = "";
    public boolean serialized = false;
    public boolean imported = false;
    public String masterItem = "";
    public boolean isGroup = false;
    public boolean operatorMessage = false;
    public int barcodeCount = 0;
    public boolean inactive = false;
    public double quantity = 0.0;
    public boolean hasFollowOn = false;
    public boolean hasSalePrice = false;
    public boolean isBundle = false;
    public boolean isGiftCardActivate = false;
    public boolean isGiftCardIncrement = false;
    public Timestamp updated = null;
    public double onHand = 0.0;
    public String onHandInfo = "";
    public String location = "";
    public String inventoryAccount = "";
    public String cogsAccount = "";
    public long taxType = 0L;
    public boolean isAppetizer = false;
    public String operatorMessageText = "";
    public Vector salePrices = null;
    public Vector detailItems = null;
    public FollowOn followOns = null;
    public double loyaltyCost = 0.0;
    public boolean hasLoyaltyProgram = false;
    public boolean noPartialQuantity = false;
    public boolean embeddedBarcodePrice = false;
    public boolean embeddedBarcodeQuantity = false;
    public String itemCategory = "";
    public String menuPage = "";
    public String productLineName = "";
    public boolean noSync = false;
    public Timestamp lastChanged;
    public ItemExtended itemExtended = null;
    public String barcodeTemplate = "";
    public String accountingRef = "";
    public boolean useTare = false;
    public String courseName = "";
    public String manufacturerPartNumber = "";

    public Item() {
    }

    public Item(Item source) {
        this.code = source.code;
        this.name = source.name;
        this.price = source.price;
        this.list = source.list;
        this.changed = source.changed;
        this.accountingCode = source.accountingCode;
        this.description = source.description;
        this.alternateDescription = source.alternateDescription;
        this.type = source.type;
        this.price1 = source.price1;
        this.price2 = source.price2;
        this.price3 = source.price3;
        this.price4 = source.price4;
        this.price5 = source.price5;
        this.UOM = source.UOM;
        this.salesAccount = source.salesAccount;
        this.cost = source.cost;
        this.taxable = source.taxable;
        this.scale = source.scale;
        this.notes = source.notes;
        this.noDiscount = source.noDiscount;
        this.vatCode = source.vatCode;
        this.trackAvailable = source.trackAvailable;
        this.trackAvailableOption = source.trackAvailableOption;
        this.warnAvailableNumber = source.warnAvailableNumber;
        this.available = source.available;
        this.isStock = source.isStock;
        this.choiceGroup = source.choiceGroup;
        this.serialized = source.serialized;
        this.imported = source.imported;
        this.masterItem = source.masterItem;
        this.isGroup = source.isGroup;
        this.operatorMessage = source.operatorMessage;
        this.barcodeCount = source.barcodeCount;
        this.inactive = source.inactive;
        this.quantity = source.quantity;
        this.hasFollowOn = source.hasFollowOn;
        this.hasSalePrice = source.hasSalePrice;
        this.isBundle = source.isBundle;
        this.isGiftCardActivate = source.isGiftCardActivate;
        this.isGiftCardIncrement = source.isGiftCardIncrement;
        this.updated = source.updated;
        this.onHand = source.onHand;
        this.onHandInfo = source.onHandInfo;
        this.location = source.location;
        this.inventoryAccount = source.inventoryAccount;
        this.cogsAccount = source.cogsAccount;
        this.taxType = source.taxType;
        this.isAppetizer = source.isAppetizer;
        this.operatorMessageText = source.operatorMessageText;
        this.salePrices = source.salePrices;
        this.detailItems = source.detailItems;
        this.followOns = source.followOns;
        this.loyaltyCost = source.loyaltyCost;
        this.noPartialQuantity = source.noPartialQuantity;
        this.embeddedBarcodePrice = source.embeddedBarcodePrice;
        this.embeddedBarcodeQuantity = source.embeddedBarcodeQuantity;
        this.itemCategory = source.itemCategory;
        this.noSync = source.noSync;
        this.lastChanged = source.lastChanged;
        this.itemExtended = source.itemExtended;
        this.barcodeTemplate = source.barcodeTemplate;
        this.accountingRef = source.accountingRef;
        this.useTare = source.useTare;
        this.courseName = source.courseName;
        this.manufacturerPartNumber = source.manufacturerPartNumber;
    }

    public Item(String id, String description, double price) {
        this.code = id;
        this.description = description;
        this.price1 = price;
    }

    public Item(String code, String name, String description, String type, double price, double list, boolean taxable) {
        this.code = code;
        this.name = name;
        this.description = description;
        this.type = type;
        this.price = price;
        this.list = list;
    }

    public Item(String thisItemXml) {
        String itemExtendedXml;
        this.code = Utility.getElement("Code", thisItemXml);
        this.name = Utility.getElement("Name", thisItemXml);
        this.price = Utility.getDoubleElement("Price", thisItemXml);
        this.list = Utility.getDoubleElement("List", thisItemXml);
        this.accountingCode = Utility.getElement("AccountingCode", thisItemXml);
        this.description = Utility.getElement("Description", thisItemXml);
        this.alternateDescription = Utility.getElement("AlternateDescription", thisItemXml);
        this.type = Utility.getElement("Type", thisItemXml);
        this.price1 = Utility.getDoubleElement("Price1", thisItemXml);
        this.price2 = Utility.getDoubleElement("Price2", thisItemXml);
        this.price3 = Utility.getDoubleElement("Price3", thisItemXml);
        this.price4 = Utility.getDoubleElement("Price4", thisItemXml);
        this.price5 = Utility.getDoubleElement("Price5", thisItemXml);
        this.UOM = Utility.getElement("UOM", thisItemXml);
        this.salesAccount = Utility.getElement("SalesAccount", thisItemXml);
        this.cost = Utility.getDoubleElement("Cost", thisItemXml);
        this.taxable = Utility.getBooleanElement("Taxable", thisItemXml);
        this.scale = Utility.getBooleanElement("Scale", thisItemXml);
        this.notes = Utility.getElement("Notes", thisItemXml);
        this.noDiscount = Utility.getBooleanElement("NoDiscount", thisItemXml);
        this.vatCode = Utility.getElement("VatCode", thisItemXml);
        this.trackAvailable = Utility.getBooleanElement("TrackAvailable", thisItemXml);
        this.trackAvailableOption = Utility.getElement("TrackAvailableOption", thisItemXml);
        this.warnAvailableNumber = Utility.getIntElement("WarnAvailableNumber", thisItemXml);
        this.available = Utility.getDoubleElement("Available", thisItemXml);
        this.isStock = Utility.getBooleanElement("IsStock", thisItemXml);
        this.choiceGroup = Utility.getElement("ChoiceGroup", thisItemXml);
        this.serialized = Utility.getBooleanElement("Serialized", thisItemXml);
        this.imported = Utility.getBooleanElement("Imported", thisItemXml);
        this.masterItem = Utility.getElement("MasterItem", thisItemXml);
        this.isGroup = Utility.getBooleanElement("IsGroup", thisItemXml);
        this.operatorMessage = Utility.getBooleanElement("OperatorMessage", thisItemXml);
        this.barcodeCount = Utility.getIntElement("BarcodeCount", thisItemXml);
        this.inactive = Utility.getBooleanElement("Inactive", thisItemXml);
        this.quantity = Utility.getDoubleElement("Quantity", thisItemXml);
        this.hasFollowOn = Utility.getBooleanElement("HasFollowOn", thisItemXml);
        this.hasSalePrice = Utility.getBooleanElement("HasSalePrice", thisItemXml);
        String updatedDate = Utility.getElement("Updated", thisItemXml);
        this.updated = updatedDate == null || updatedDate.length() == 0 || updatedDate.equals("null") ? null : Timestamp.valueOf(updatedDate);
        this.onHand = Utility.getDoubleElement("OnHand", thisItemXml);
        this.onHandInfo = Utility.getElement("OnHandInfo", thisItemXml);
        this.changed = Utility.getBooleanElement("Changed", thisItemXml);
        this.isBundle = Utility.getBooleanElement("IsBundle", thisItemXml);
        this.isGiftCardActivate = Utility.getBooleanElement("IsGiftCardActivate", thisItemXml);
        this.isGiftCardIncrement = Utility.getBooleanElement("IsGiftCardIncrement", thisItemXml);
        this.location = Utility.getElement("Location", thisItemXml);
        this.inventoryAccount = Utility.getElement("InventoryAccount", thisItemXml);
        this.cogsAccount = Utility.getElement("CogsAccount", thisItemXml);
        this.taxType = Utility.getLongElement("TaxType", thisItemXml);
        this.isAppetizer = Utility.getBooleanElement("IsAppetizer", thisItemXml);
        this.operatorMessageText = Utility.getElement("OperatorMessageText", thisItemXml);
        String salePricesXml = Utility.getElement("SalePrices", thisItemXml);
        Vector salePricesListXml = Utility.getElementList("SalePrice", salePricesXml);
        int len = salePricesListXml.size();
        this.salePrices = new Vector();
        for (int i = 0; i < len; ++i) {
            String thisSalePriceXml = (String)salePricesListXml.get(i);
            SalePrice thisSalePrice = new SalePrice(thisSalePriceXml);
            this.salePrices.add(thisSalePrice);
        }
        String detailItemsXml = Utility.getElement("DetailItems", thisItemXml);
        Vector detailItemsListXml = Utility.getElementList("ItemGroup", detailItemsXml);
        len = detailItemsListXml.size();
        this.detailItems = new Vector();
        for (int i = 0; i < len; ++i) {
            String thisDetailItemXml = (String)detailItemsListXml.get(i);
            ItemGroup thisItemGroup = new ItemGroup(thisDetailItemXml);
            this.detailItems.add(thisItemGroup);
        }
        String followItemsXml = Utility.getElement("FollowOn", thisItemXml);
        if (followItemsXml != null && !followItemsXml.isEmpty()) {
            this.followOns = new FollowOn(followItemsXml);
            this.hasFollowOn = true;
        } else {
            this.followOns = null;
            this.hasFollowOn = false;
        }
        this.loyaltyCost = Utility.getDoubleElement("LoyaltyCost", thisItemXml);
        this.noPartialQuantity = Utility.getBooleanElement("NoPartialQuantity", thisItemXml);
        this.embeddedBarcodePrice = Utility.getBooleanElement("EmbeddedBarcodePrice", thisItemXml);
        this.embeddedBarcodeQuantity = Utility.getBooleanElement("EmbeddedBarcodeQuantity", thisItemXml);
        this.itemCategory = Utility.getElement("ItemCategory", thisItemXml);
        this.noSync = Utility.getBooleanElement("NoSync", thisItemXml);
        long lastChangedValue = Utility.getLongElement("LastChanged", thisItemXml);
        if (lastChangedValue > 0L) {
            this.lastChanged = new Timestamp(lastChangedValue);
        }
        if ((itemExtendedXml = Utility.getElement("ItemExtended", thisItemXml)) != null && !itemExtendedXml.isEmpty()) {
            this.itemExtended = new ItemExtended(itemExtendedXml);
        }
        this.barcodeTemplate = Utility.getElement("BarcodeTemplate", thisItemXml);
        this.accountingRef = Utility.getElement("AccountingRef", thisItemXml);
        this.useTare = Utility.getBooleanElement("UseTare", thisItemXml);
        this.courseName = Utility.getElement("CourseName", thisItemXml);
        this.manufacturerPartNumber = Utility.getElement("ManufacturerPartNumber", thisItemXml);
    }

    public Item(JSONString jsonString) {
        this.code = Utility.getJSONString(jsonString.toString(), "id");
        this.code = Utility.translateSpecial(this.code);
        this.accountingCode = Utility.getJSONString(jsonString.toString(), "accountingCode");
        this.accountingCode = Utility.translateSpecial(this.accountingCode);
        boolean allowDiscount = Utility.getJSONBoolean(jsonString.toString(), "allowDiscount");
        this.noDiscount = !allowDiscount;
        this.alternateDescription = Utility.getJSONString(jsonString.toString(), "altDescription");
        String onHandString = Utility.getJSONString(jsonString.toString(), "onHand");
        this.onHand = 0.0;
        if (onHandString != null && !onHandString.isEmpty()) {
            try {
                this.onHand = Double.parseDouble(onHandString);
            }
            catch (Exception e) {
                this.onHand = 0.0;
            }
        }
        this.itemCategory = Utility.getJSONString(jsonString.toString(), "category");
        this.choiceGroup = Utility.getJSONString(jsonString.toString(), "choiceGroup");
        this.description = Utility.getJSONString(jsonString.toString(), "description");
        this.description = Utility.translateSpecial(this.description);
        this.inactive = Utility.getJSONBoolean(jsonString.toString(), "inactive");
        this.isStock = Utility.getJSONBoolean(jsonString.toString(), "isStock");
        this.type = Utility.getJSONString(jsonString.toString(), "itemTypeName");
        this.noPartialQuantity = Utility.getJSONBoolean(jsonString.toString(), "noPartialQuantity");
        this.price = Utility.getJSONDouble(jsonString.toString(), "price");
        this.trackAvailableOption = Utility.getJSONString(jsonString.toString(), "trackAvailableOption");
        this.warnAvailableNumber = Utility.getJSONInt(jsonString.toString(), "warnAvailableNumber");
        this.available = Utility.getJSONDouble(jsonString.toString(), "available");
        this.price1 = Utility.getJSONDouble(jsonString.toString(), "priceLevel1");
        this.price2 = Utility.getJSONDouble(jsonString.toString(), "priceLevel2");
        this.price3 = Utility.getJSONDouble(jsonString.toString(), "priceLevel3");
        this.price4 = Utility.getJSONDouble(jsonString.toString(), "priceLevel4");
        this.price5 = Utility.getJSONDouble(jsonString.toString(), "priceLevel5");
        this.cost = Utility.getJSONDouble(jsonString.toString(), "cost");
        this.quantity = Utility.getJSONDouble(jsonString.toString(), "quantity");
        this.salesAccount = Utility.getJSONString(jsonString.toString(), "salesAccount");
        this.scale = Utility.getJSONBoolean(jsonString.toString(), "scale");
        this.serialized = Utility.getJSONBoolean(jsonString.toString(), "serialized");
        this.taxable = Utility.getJSONBoolean(jsonString.toString(), "taxable");
        this.vatCode = Utility.getJSONString(jsonString.toString(), "vatCode");
        this.menuPage = Utility.getJSONString(jsonString.toString(), "menuPage");
        this.barcodeCount = Utility.getJSONInt(jsonString.toString(), "barcodeCount");
        this.accountingRef = Utility.getJSONString(jsonString.toString(), "accountingRef");
        try {
            JSONObject itemObject = new JSONObject(jsonString.toString());
            JSONObject itemExtendedObject = itemObject.getJSONObject("itemExtended");
            if (itemExtendedObject != null) {
                Timestamp now;
                this.itemExtended = new ItemExtended();
                this.itemExtended.caloriesPer100g = itemExtendedObject.optString("caloriesPer100g");
                this.itemExtended.caloriesPerServing = itemExtendedObject.optString("caloriesPerServing");
                this.itemExtended.detailedDescription = itemExtendedObject.optString("detailedDescription");
                this.itemExtended.imageCreated = now = new Timestamp(new Date().getTime());
                this.itemExtended.imageUrl = itemExtendedObject.optString("imageUrl");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.useTare = Utility.getJSONBoolean(jsonString.toString(), "useTare");
        this.courseName = Utility.getJSONString(jsonString.toString(), "courseName");
        this.manufacturerPartNumber = Utility.getJSONString(jsonString.toString(), "manufacturerPartNumber");
    }

    public String toFollowOnXml() {
        DecimalFormat decimal = new DecimalFormat("####0.00##;-####0.00##");
        StringBuffer xml = new StringBuffer();
        xml.append("<FollowonItem>");
        xml.append("<Code>" + this.code + "</Code>");
        xml.append("<Description>" + this.description + "</Description>");
        xml.append("<Quantity>" + decimal.format(this.quantity) + "</Quantity>");
        xml.append("</FollowonItem>\r\n");
        return xml.toString();
    }

    public String toXml() {
        DecimalFormat decimal = new DecimalFormat("####0.00##;-####0.00##");
        StringBuffer xml = new StringBuffer();
        xml.append("<Item>");
        xml.append("<Code>" + this.code + "</Code>");
        xml.append("<Name>" + this.name + "</Name>");
        xml.append("<Price>" + decimal.format(this.price) + "</Price>");
        xml.append("<List>" + decimal.format(this.price) + "</List>");
        xml.append("<AccountingCode>" + this.accountingCode + "</AccountingCode>");
        xml.append("<Description>" + this.description + "</Description>");
        xml.append("<AlternateDescription>" + this.alternateDescription + "</AlternateDescription>");
        xml.append("<Type>" + this.type + "</Type>");
        xml.append("<Price1>" + decimal.format(this.price1) + "</Price1>");
        xml.append("<Price2>" + decimal.format(this.price2) + "</Price2>");
        xml.append("<Price3>" + decimal.format(this.price3) + "</Price3>");
        xml.append("<Price4>" + decimal.format(this.price4) + "</Price4>");
        xml.append("<Price5>" + decimal.format(this.price5) + "</Price5>");
        xml.append("<UOM>" + this.UOM + "</UOM>");
        xml.append("<SalesAccount>" + this.salesAccount + "</SalesAccount>");
        xml.append("<Cost>" + decimal.format(this.cost) + "</Cost>");
        xml.append("<Taxable>" + this.taxable + "</Taxable>");
        xml.append("<Scale>" + this.scale + "</Scale>");
        xml.append("<Notes>" + this.notes + "</Notes>");
        xml.append("<NoDiscount>" + this.noDiscount + "</NoDiscount>");
        xml.append("<VatCode>" + this.vatCode + "</VatCode>");
        xml.append("<TrackAvailable>" + this.trackAvailable + "</TrackAvailable>");
        xml.append("<TrackAvailableOption>" + this.trackAvailableOption + "</TrackAvailableOption>");
        xml.append("<WarnAvailableNumber>" + this.warnAvailableNumber + "</WarnAvailableNumber>");
        xml.append("<Available>" + decimal.format(this.available) + "</Available>");
        xml.append("<IsStock>" + this.isStock + "</IsStock>");
        xml.append("<ChoiceGroup>" + this.choiceGroup + "</ChoiceGroup>");
        xml.append("<Serialized>" + this.serialized + "</Serialized>");
        xml.append("<Imported>" + this.imported + "</Imported>");
        xml.append("<MasterItem>" + this.masterItem + "</MasterItem>");
        xml.append("<IsGroup>" + this.isGroup + "</IsGroup>");
        xml.append("<OperatorMessage>" + this.operatorMessage + "</OperatorMessage>");
        xml.append("<BarcodeCount>" + this.barcodeCount + "</BarcodeCount>");
        xml.append("<Inactive>" + this.inactive + "</Inactive>");
        xml.append("<Quantity>" + decimal.format(this.quantity) + "</Quantity>");
        xml.append("<HasFollowOn>" + this.hasFollowOn + "</HasFollowOn>");
        xml.append("<HasSalePrice>" + this.hasSalePrice + "</HasSalePrice>");
        xml.append("<Updated>" + this.updated + "</Updated>");
        xml.append("<OnHand>" + decimal.format(this.onHand) + "</OnHand>");
        xml.append("<OnHandInfo>" + this.onHandInfo + "</OnHandInfo>");
        xml.append("<Changed>" + this.changed + "</Changed>");
        xml.append("<IsBundle>" + this.isBundle + "</IsBundle>");
        xml.append("<IsGiftCardActivate>" + this.isGiftCardActivate + "</IsGiftCardActivate>");
        xml.append("<IsGiftCardIncrement>" + this.isGiftCardIncrement + "</IsGiftCardIncrement>");
        xml.append("<Location>" + this.location + "</Location>");
        xml.append("<InventoryAccount>" + this.inventoryAccount + "</InventoryAccount>");
        xml.append("<CogsAccount>" + this.cogsAccount + "</CogsAccount>");
        xml.append("<TaxType>" + this.taxType + "</TaxType>");
        xml.append("<IsAppetizer>" + this.isAppetizer + "</IsAppetizer>");
        xml.append("<OperatorMessageText>" + this.operatorMessageText + "</OperatorMessageText>");
        StringBuilder salePricesXml = new StringBuilder();
        if (this.salePrices != null) {
            int len = this.salePrices.size();
            for (int i = 0; i < len; ++i) {
                SalePrice thisSalePrice = (SalePrice)this.salePrices.get(i);
                salePricesXml.append(thisSalePrice.toXml());
            }
        }
        xml.append("<SalePrices>" + salePricesXml.toString() + "</SalePrices>");
        StringBuilder detailItemsXml = new StringBuilder();
        if (this.detailItems != null) {
            int len = this.detailItems.size();
            for (int i = 0; i < len; ++i) {
                ItemGroup thisItemGroup = (ItemGroup)this.detailItems.get(i);
                detailItemsXml.append(thisItemGroup.toXml());
            }
        }
        xml.append("<DetailItems>" + detailItemsXml.toString() + "</DetailItems>");
        if (this.followOns != null) {
            xml.append("<FollowOn>" + this.followOns.toXml() + "</FollowOn>");
        }
        xml.append("<LoyaltyCost>" + this.loyaltyCost + "</LoyaltyCost>");
        xml.append("<NoPartialQuantity>" + this.noPartialQuantity + "</NoPartialQuantity>");
        xml.append("<EmbeddedBarcodePrice>" + this.embeddedBarcodePrice + "</EmbeddedBarcodePrice>");
        xml.append("<EmbeddedBarcodeQuantity>" + this.embeddedBarcodeQuantity + "</EmbeddedBarcodeQuantity>");
        xml.append("<ItemCategory>" + this.itemCategory + "</ItemCategory>");
        xml.append("    <NoSync>" + this.noSync + "</NoSync>\n");
        if (this.lastChanged != null) {
            xml.append("<LastChanged>" + this.lastChanged.getTime() + "</LastChanged>\r\n");
        }
        if (this.itemExtended != null) {
            xml.append(this.itemExtended.toXml());
        }
        xml.append("<BarcodeTemplate>" + this.barcodeTemplate + "</BarcodeTemplate>");
        xml.append("<AccountingRef>" + this.accountingRef + "</AccountingRef>");
        xml.append("<UseTare>" + this.useTare + "</UseTare>");
        xml.append("<CourseName>" + this.courseName + "</CourseName>");
        xml.append("<ManufacturerPartNumber>" + this.manufacturerPartNumber + "</ManufacturerPartNumber>");
        xml.append("</Item>\r\n");
        return xml.toString();
    }

    public String toReferenceDataXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<Item>");
        xml.append("<Code>" + this.code + "</Code>");
        xml.append("<Name>" + this.name + "</Name>");
        xml.append("<AccountingCode>" + this.accountingCode + "</AccountingCode>");
        xml.append("<Description>" + this.description + "</Description>");
        xml.append("<Type>" + this.type + "</Type>");
        xml.append("<Price1>" + this.price1 + "</Price1>");
        xml.append("<SalesAccount>" + this.salesAccount + "</SalesAccount>");
        xml.append("</Item>\r\n");
        return xml.toString();
    }

    public String toAccuCountXml() {
        DecimalFormat decimal = new DecimalFormat("####0.00##;-####0.00##");
        StringBuffer xml = new StringBuffer();
        xml.append("<Item>");
        xml.append("<Code>" + this.code + "</Code>");
        xml.append("<Name>" + this.name + "</Name>");
        xml.append("<Price>" + decimal.format(this.price) + "</Price>");
        xml.append("<List>" + decimal.format(this.price) + "</List>");
        xml.append("<Description>" + this.description + "</Description>");
        xml.append("<AccountingCode>" + this.accountingCode + "</AccountingCode>");
        xml.append("<Cost>" + decimal.format(this.cost) + "</Cost>");
        xml.append("<Price1>" + decimal.format(this.price1) + "</Price1>");
        xml.append("<Price2>" + decimal.format(this.price2) + "</Price2>");
        xml.append("<Price3>" + decimal.format(this.price3) + "</Price3>");
        xml.append("<Price4>" + decimal.format(this.price4) + "</Price4>");
        xml.append("<Price5>" + decimal.format(this.price5) + "</Price5>");
        xml.append("<OnHand>" + decimal.format(this.onHand) + "</OnHand>");
        xml.append("<InventoryAccount>" + this.inventoryAccount + "</InventoryAccount>");
        xml.append("<ItemCategory>" + this.itemCategory + "</ItemCategory>");
        xml.append("<BarcodeTemplate>" + this.barcodeTemplate + "</BarcodeTemplate>");
        xml.append("</Item>\r\n");
        return xml.toString();
    }

    public boolean equals(Object obj) {
        String source = ((Item)obj).code;
        return source.compareToIgnoreCase(this.code) == 0;
    }

    public JSONObject toJson() {
        DecimalFormat decimal = new DecimalFormat("####0.00##;-####0.00##");
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("id", (Object)this.code);
            jsonObject.put("description", (Object)this.description);
            jsonObject.put("type", (Object)this.type);
            jsonObject.put("price", this.price);
            jsonObject.put("accountingCode", (Object)this.accountingCode);
            jsonObject.put("priceLevel1", this.price1);
            jsonObject.put("priceLevel2", this.price2);
            jsonObject.put("priceLevel3", this.price3);
            jsonObject.put("priceLevel4", this.price4);
            jsonObject.put("priceLevel5", this.price5);
            jsonObject.put("cost", this.cost);
            jsonObject.put("choiceGroup", (Object)this.choiceGroup);
            jsonObject.put("altDescription", (Object)this.alternateDescription);
            jsonObject.put("category", (Object)this.itemCategory);
            jsonObject.put("salesAccount", (Object)this.salesAccount);
            jsonObject.put("allowDiscount", !this.noDiscount);
            jsonObject.put("isStock", this.isStock);
            jsonObject.put("inactive", this.inactive);
            jsonObject.put("scale", this.scale);
            jsonObject.put("serialized", this.serialized);
            jsonObject.put("noPartialQuantity", this.noPartialQuantity);
            jsonObject.put("quantity", this.quantity);
            jsonObject.put("taxable", this.taxable);
            jsonObject.put("onHand", this.onHand);
            jsonObject.put("trackAvailableOption", (Object)this.trackAvailableOption);
            jsonObject.put("warnAvailableNumber", this.warnAvailableNumber);
            jsonObject.put("available", (Object)decimal.format(this.available));
            jsonObject.put("taxType", this.taxType);
            jsonObject.put("menuPage", (Object)this.menuPage);
            jsonObject.put("vatCode", (Object)this.vatCode);
            jsonObject.put("isGroup", this.isGroup);
            jsonObject.put("barcodeCount", this.barcodeCount);
            jsonObject.put("accountingRef", (Object)this.accountingRef);
            jsonObject.put("useTare", this.useTare);
            jsonObject.put("courseName", (Object)this.courseName);
            jsonObject.put("manufacturerPartNumber", (Object)this.manufacturerPartNumber);
            if (this.itemExtended != null) {
                jsonObject.put("itemExtended", (Object)this.itemExtended.toJson());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }
}

