/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import java.sql.Timestamp;
import org.json.JSONException;
import org.json.JSONObject;

public class NoPartialQuantity {
    public String itemId;
    public String itemType;
    public boolean noSync = false;
    public Timestamp lastChanged;

    public NoPartialQuantity(String itemId, String itemType) {
        this.itemId = itemId;
        this.itemType = itemType;
    }

    public NoPartialQuantity(String xml) {
        this.itemId = Utility.getElement("ItemId", xml);
        this.itemType = Utility.getElement("ItemType", xml);
        this.noSync = Utility.getBooleanElement("NoSync", xml);
        long lastChangedValue = Utility.getLongElement("LastChanged", xml);
        if (lastChangedValue > 0L) {
            this.lastChanged = new Timestamp(lastChangedValue);
        }
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<NoPartialQuantity>\n");
        xml.append("  <ItemId>" + this.itemId + "</ItemId>\n");
        xml.append("  <ItemType>" + this.itemType + "</ItemType>\n");
        xml.append("    <NoSync>" + this.noSync + "</NoSync>\n");
        if (this.lastChanged != null) {
            xml.append("<LastChanged>" + this.lastChanged.getTime() + "</LastChanged>\r\n");
        }
        xml.append("</NoPartialQuantity>\n");
        return xml.toString();
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        JSONObject noPartial = new JSONObject();
        try {
            noPartial.put("itemId", (Object)this.itemId);
            noPartial.put("itemType", (Object)this.itemType);
            noPartial.put("noSync", this.noSync);
            jsonObject.put("no_partial", (Object)noPartial);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }
}

