/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.Customer;
import POSDataObjects.DataChange;
import POSDataObjects.LineItem;
import POSDataObjects.TaxAuthority;
import POSDataObjects.Tender;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Vector;

public class Order {
    public String orderId = "";
    public int orderNumber = 0;
    public int receiptNumber = 0;
    public Timestamp created = null;
    public Timestamp dateInvoiced = null;
    public Vector lineItems = null;
    public int nextLineNumber = 1;
    public String user = null;
    public String table = "";
    public boolean displayOnRemote = false;
    public boolean carryOut = false;
    public double total = 0.0;
    public double tenderedTotal = 0.0;
    public double totalTax = 0.0;
    public double subTotal = 0.0;
    public double taxableSubTotal = 0.0;
    public Vector taxAuthorities = null;
    public Vector tenderings = null;
    public int guestCount = 0;
    public byte[] swipe = null;
    public int originalInvoiceNumber = 0;
    public String shift = "";
    public boolean autoGratuity = false;
    public double autoGratuityAmount = 0.0;
    public Customer customer = null;
    public String discountItem = "";
    public double discountAmount = 0.0;
    public double discountPercent = 0.0;
    public boolean orderFired = false;
    public boolean checkPrinted = false;
    public double snapTaxable = 0.0;
    public double snapNontaxable = 0.0;
    public double snapTendered = 0.0;
    public int priceLevel = 0;
    public String openBy = "";
    public String preAuthId = "";
    public String preAuthCode = "";
    public String preAuthNumber = "";
    public String preAuthExp = "";
    public String preAuthApproval = "";
    public String preAuthHolder = "";
    public double preAuthAmount = 0.0;
    public String preAuthRecordNumber = "";
    public String taxCode = "";
    public String comoConfirmationCode = "";
    public String driver = "";
    public boolean delivery = false;
    public double preTipAmount = 0.0;
    public String requested = "";
    public String location = "";
    public int znum = 0;
    public boolean reprintRemoteTicket = false;
    public String status = "";
    public String processStatus = "";
    public String currentCourse = "";
    public Vector orderChanges = null;
    public String orderType = "";

    public Order(String text, boolean isXml) {
        this.lineItems = new Vector();
        this.taxAuthorities = new Vector();
        this.tenderings = new Vector();
        if (isXml) {
            this.orderId = Utility.getElement("OrderId", text);
            this.user = Utility.getElement("User", text);
            this.shift = Utility.getElement("Shift", text);
            this.table = Utility.getElement("Table", text);
            this.created = new Timestamp(Utility.getLongElement("Created", text));
            long invoiceDate = Utility.getLongElement("DateInvoiced", text);
            if (invoiceDate > 0L) {
                this.dateInvoiced = new Timestamp(invoiceDate);
            }
            this.orderNumber = Utility.getIntElement("OrderNumber", text);
            this.receiptNumber = Utility.getIntElement("ReceiptNumber", text);
            this.originalInvoiceNumber = Utility.getIntElement("OriginalInvoiceNumber", text);
            this.nextLineNumber = Utility.getIntElement("NextLineNumber", text);
            this.displayOnRemote = Utility.getBooleanElement("DisplayOnRemote", text);
            this.carryOut = Utility.getBooleanElement("CarryOut", text);
            String linesXml = Utility.getElement("LineItems", text);
            Vector linesListXml = Utility.getElementList("LineItem", linesXml);
            int len = linesListXml.size();
            for (int i = 0; i < len; ++i) {
                String thisLineXml = (String)linesListXml.get(i);
                LineItem thisLineItem = new LineItem(thisLineXml);
                this.lineItems.add(thisLineItem);
            }
            this.nextLineNumber = len;
            String taxAuthoritiesXml = Utility.getElement("TaxAuthorities", text);
            Vector taxAuthoritiesListXml = Utility.getElementList("TaxAuthority", taxAuthoritiesXml);
            len = taxAuthoritiesListXml.size();
            for (int i = 0; i < len; ++i) {
                String thisTaxAuthorityXml = (String)taxAuthoritiesListXml.get(i);
                TaxAuthority thisTaxAuthority = new TaxAuthority(thisTaxAuthorityXml);
                this.taxAuthorities.add(thisTaxAuthority);
            }
            this.nextLineNumber += len;
            String tenderXml = Utility.getElement("Tendering", text);
            Vector tenderListXml = Utility.getElementList("Tender", tenderXml);
            len = tenderListXml.size();
            for (int i = 0; i < len; ++i) {
                String thisTenderXml = (String)tenderListXml.get(i);
                Tender thisTender = new Tender(thisTenderXml);
                this.tenderings.add(thisTender);
            }
            this.nextLineNumber += len;
            ++this.nextLineNumber;
            this.subTotal = Utility.getDoubleElement("SubTotal", text);
            this.taxableSubTotal = Utility.getDoubleElement("TaxableSubTotal", text);
            this.totalTax = Utility.getDoubleElement("TotalTax", text);
            this.total = Utility.getDoubleElement("OrderTotal", text);
            this.snapTaxable = Utility.getDoubleElement("SnapTaxable", text);
            this.snapNontaxable = Utility.getDoubleElement("SnapNontaxable", text);
            this.snapTendered = Utility.getDoubleElement("SnapTendered", text);
            this.guestCount = Utility.getIntElement("GuestCount", text);
            this.autoGratuity = Utility.getBooleanElement("AutoGratuity", text);
            this.autoGratuityAmount = Utility.getDoubleElement("AutoGratuityAmount", text);
            String customerXml = Utility.getElement("OrderCustomer", text);
            if (customerXml != null && customerXml.length() > 0) {
                this.customer = new Customer(customerXml);
            }
            this.discountItem = Utility.getElement("DiscountItem", text);
            this.discountAmount = Utility.getDoubleElement("DiscountAmount", text);
            this.discountPercent = Utility.getDoubleElement("DiscountPercent", text);
            this.orderFired = Utility.getBooleanElement("OrderFired", text);
            this.checkPrinted = Utility.getBooleanElement("CheckPrinted", text);
            this.priceLevel = Utility.getIntElement("OrderPriceLevel", text);
            this.openBy = Utility.getElement("OpenBy", text);
            this.preAuthId = Utility.getElement("PreAuthId", text);
            this.preAuthCode = Utility.getElement("PreAuthCode", text);
            this.preAuthNumber = Utility.getElement("PreAuthNumber", text);
            this.preAuthExp = Utility.getElement("PreAuthExp", text);
            this.preAuthApproval = Utility.getElement("PreAuthApproval", text);
            this.preAuthHolder = Utility.getElement("PreAuthHolder", text);
            this.preAuthAmount = Utility.getDoubleElement("PreAuthAmount", text);
            this.preAuthRecordNumber = Utility.getElement("PreAuthRecordNumber", text);
            this.taxCode = Utility.getElement("POSTaxCode", text);
            this.comoConfirmationCode = Utility.getElement("ComoConfirmationCode", text);
            this.driver = Utility.getElement("Driver", text);
            this.delivery = Utility.getBooleanElement("Delivery", text);
            this.preTipAmount = Utility.getDoubleElement("PreTipAmount", text);
            this.requested = Utility.getElement("Requested", text);
            this.znum = Utility.getIntElement("Znum", text);
            this.location = Utility.getElement("Location", text);
            this.status = Utility.getElement("OrderStatus", text);
            this.processStatus = Utility.getElement("OrderProcessStatus", text);
            this.currentCourse = Utility.getElement("CurrentCourse", text);
            this.orderChanges = new Vector();
            String orderChangesXml = Utility.getElement("OrderChanges", text);
            Vector orderChangesListXml = Utility.getElementList("DataChange", orderChangesXml);
            int changesLen = orderChangesListXml.size();
            for (int i = 0; i < changesLen; ++i) {
                String thisOrderChangeXml = (String)orderChangesListXml.get(i);
                DataChange thisOrderChange = new DataChange(thisOrderChangeXml);
                this.orderChanges.add(thisOrderChange);
            }
            this.orderType = Utility.getElement("OrderType", text);
        } else {
            this.orderId = text;
            this.created = new Timestamp(new Date().getTime());
        }
    }

    public Order() {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Order other = (Order)obj;
        return this.orderId.compareToIgnoreCase(other.orderId) == 0 && (this.orderNumber == 0 || this.orderNumber == other.orderNumber);
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }

    public int getNextLineNumber() {
        return this.nextLineNumber++;
    }

    public String toXml() {
        DecimalFormat decimal = new DecimalFormat("####0.00;-####0.00");
        DecimalFormat discountdecimal = new DecimalFormat("####0.000;-####0.000");
        StringBuffer linesXml = new StringBuffer();
        int len = 0;
        if (this.lineItems != null) {
            len = this.lineItems.size();
        }
        double taxTotal = 0.0;
        for (int i = 0; i < len; ++i) {
            LineItem thisLine = (LineItem)this.lineItems.get(i);
            linesXml.append(thisLine.toXml());
            taxTotal += thisLine.vatTax1 + thisLine.vatTax2;
        }
        StringBuffer taxAuthorityXml = new StringBuffer();
        if (this.taxAuthorities != null) {
            len = this.taxAuthorities.size();
            for (int i = 0; i < len; ++i) {
                TaxAuthority thisTaxAuthority = (TaxAuthority)this.taxAuthorities.get(i);
                taxAuthorityXml.append(thisTaxAuthority.toXml());
                taxTotal += Double.valueOf(decimal.format(thisTaxAuthority.tax)).doubleValue();
            }
        }
        StringBuffer tenderXml = new StringBuffer();
        if (this.tenderings != null) {
            len = this.tenderings.size();
            for (int i = 0; i < len; ++i) {
                Tender thisTender = (Tender)this.tenderings.get(i);
                tenderXml.append(thisTender.toXml());
            }
        }
        StringBuilder orderChangesXml = new StringBuilder();
        if (this.orderChanges != null) {
            len = this.orderChanges.size();
            for (int i = 0; i < len; ++i) {
                DataChange thisChange = (DataChange)this.orderChanges.get(i);
                orderChangesXml.append(thisChange.toXml());
            }
        }
        if (this.lineItems == null || this.lineItems.isEmpty()) {
            taxTotal = this.totalTax;
        }
        this.total = this.subTotal + this.totalTax + this.autoGratuityAmount + this.preTipAmount;
        StringBuffer xml = new StringBuffer();
        xml.append("<Order>\r\n");
        if (this.created != null) {
            xml.append("<Created>" + this.created.getTime() + "</Created>\r\n");
        }
        if (this.dateInvoiced != null) {
            xml.append("<DateInvoiced>" + this.dateInvoiced.getTime() + "</DateInvoiced>\r\n");
        }
        xml.append("<OrderId>" + this.orderId + "</OrderId>\r\n");
        xml.append("<User>" + this.user + "</User>\r\n");
        xml.append("<Shift>" + this.shift + "</Shift>\r\n");
        xml.append("<Table>" + this.table + "</Table>\r\n");
        xml.append("<OrderNumber>" + this.orderNumber + "</OrderNumber>\r\n");
        xml.append("<ReceiptNumber>" + this.receiptNumber + "</ReceiptNumber>\r\n");
        xml.append("<OriginalInvoiceNumber>" + this.originalInvoiceNumber + "</OriginalInvoiceNumber>\r\n");
        xml.append("<SubTotal>" + decimal.format(this.subTotal) + "</SubTotal>\r\n");
        xml.append("<TaxableSubTotal>" + decimal.format(this.taxableSubTotal) + "</TaxableSubTotal>\r\n");
        xml.append("<SnapTaxable>" + decimal.format(this.snapTaxable) + "</SnapTaxable>\r\n");
        xml.append("<SnapNontaxable>" + decimal.format(this.snapNontaxable) + "</SnapNontaxable>\r\n");
        xml.append("<SnapTendered>" + decimal.format(this.snapTendered) + "</SnapTendered>\r\n");
        xml.append("<DisplayOnRemote>" + Boolean.toString(this.displayOnRemote) + "</DisplayOnRemote>\r\n");
        xml.append("<CarryOut>" + Boolean.toString(this.carryOut) + "</CarryOut>\r\n");
        xml.append("<LineItems>" + linesXml.toString() + "</LineItems>\r\n");
        xml.append("<TaxAuthorities>" + taxAuthorityXml.toString() + "</TaxAuthorities>\r\n");
        xml.append("<TotalTax>" + decimal.format(this.totalTax) + "</TotalTax>\r\n");
        xml.append("<Tendering>" + tenderXml + "</Tendering>\r\n");
        xml.append("<GuestCount>" + this.guestCount + "</GuestCount>\r\n");
        xml.append("<OrderTotal>" + decimal.format(this.total) + "</OrderTotal>\r\n");
        xml.append("<AutoGratuity>" + Boolean.toString(this.autoGratuity) + "</AutoGratuity>\r\n");
        xml.append("<AutoGratuityAmount>" + decimal.format(this.autoGratuityAmount) + "</AutoGratuityAmount>\r\n");
        if (this.customer != null) {
            xml.append("<OrderCustomer>" + this.customer.toXml() + "</OrderCustomer>\r\n");
        }
        xml.append("<DiscountItem>" + this.discountItem + "</DiscountItem>\r\n");
        xml.append("<DiscountAmount>" + decimal.format(this.discountAmount) + "</DiscountAmount>\r\n");
        xml.append("<DiscountPercent>" + discountdecimal.format(this.discountPercent) + "</DiscountPercent>\r\n");
        xml.append("<OrderFired>" + this.orderFired + "</OrderFired>\r\n");
        xml.append("<CheckPrinted>" + this.checkPrinted + "</CheckPrinted>\r\n");
        xml.append("<OrderPriceLevel>" + this.priceLevel + "</OrderPriceLevel>\r\n");
        xml.append("<OpenBy>" + this.openBy + "</OpenBy>\r\n");
        xml.append("<PreAuthId>" + this.preAuthId + "</PreAuthId>\r\n");
        xml.append("<PreAuthCode>" + this.preAuthCode + "</PreAuthCode>\r\n");
        xml.append("<PreAuthNumber>" + this.preAuthNumber + "</PreAuthNumber>\r\n");
        xml.append("<PreAuthExp>" + this.preAuthExp + "</PreAuthExp>\r\n");
        xml.append("<PreAuthApproval>" + this.preAuthApproval + "</PreAuthApproval>\r\n");
        xml.append("<PreAuthHolder>" + this.preAuthHolder + "</PreAuthHolder>\r\n");
        xml.append("<PreAuthAmount>" + decimal.format(this.preAuthAmount) + "</PreAuthAmount>\r\n");
        xml.append("<PreAuthRecordNumber>" + this.preAuthRecordNumber + "</PreAuthRecordNumber>\r\n");
        xml.append("<POSTaxCode>" + this.taxCode + "</POSTaxCode>\r\n");
        xml.append("<ComoConfirmationCode>" + this.comoConfirmationCode + "</ComoConfirmationCode>\r\n");
        xml.append("<Driver>" + this.driver + "</Driver>\r\n");
        xml.append("<Delivery>" + this.delivery + "</Delivery>\r\n");
        xml.append("<PreTipAmount>" + decimal.format(this.preTipAmount) + "</PreTipAmount>\r\n");
        xml.append("<Location>" + this.location + "</Location>\r\n");
        xml.append("<Requested>" + this.requested + "</Requested>\r\n");
        xml.append("<Znum>" + this.znum + "</Znum>\r\n");
        xml.append("<OrderStatus>" + this.status + "</OrderStatus>\r\n");
        xml.append("<OrderProcessStatus>" + this.processStatus + "</OrderProcessStatus>\r\n");
        xml.append("<TenderTotal>" + decimal.format(this.tenderedTotal) + "</TenderTotal>\r\n");
        xml.append("<CurrentCourse>" + this.currentCourse + "</CurrentCourse>\r\n");
        xml.append("<OrderChanges>" + orderChangesXml + "</OrderChanges>\r\n");
        xml.append("<OrderType>" + this.orderType + "</OrderType>\r\n");
        xml.append("</Order>\r\n");
        return xml.toString();
    }
}

