/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import java.sql.Timestamp;
import java.text.DecimalFormat;

public class OrderCounts {
    public String user = null;
    public String table = null;
    public int count = 0;
    public Timestamp orderTime = null;
    public double tableTotal = 0.0;
    public int fireCount = 0;
    public int printCount = 0;

    public OrderCounts(String text, boolean isXml) {
        if (isXml) {
            this.user = Utility.getElement("User", text);
            this.table = Utility.getElement("Table", text);
            this.count = Utility.getIntElement("Count", text);
            this.tableTotal = Utility.getDoubleElement("TableTotal", text);
            long orderTimeValue = Utility.getLongElement("OrderTime", text);
            if (orderTimeValue > 0L) {
                this.orderTime = new Timestamp(orderTimeValue);
            }
            this.fireCount = Utility.getIntElement("FireCount", text);
            this.printCount = Utility.getIntElement("PrintCount", text);
        }
    }

    public OrderCounts() {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrderCounts other = (OrderCounts)obj;
        return this.table.compareToIgnoreCase(other.table) == 0;
    }

    public String toXml() {
        DecimalFormat decimal = new DecimalFormat("####0.00##;-####0.00##");
        StringBuilder xml = new StringBuilder();
        xml.append("<OrderCount>");
        xml.append("<Table>" + this.table + "</Table>");
        xml.append("<Count>" + this.count + "</Count>");
        xml.append("<FireCount>" + this.fireCount + "</FireCount>");
        xml.append("<PrintCount>" + this.printCount + "</PrintCount>");
        xml.append("<User>" + this.user + "</User>");
        if (this.orderTime != null) {
            xml.append("<OrderTime>" + this.orderTime.getTime() + "</OrderTime>\r\n");
        } else {
            xml.append("<OrderTime>0</OrderTime>\r\n");
        }
        xml.append("<TableTotal>" + decimal.format(this.tableTotal) + "</TableTotal>");
        xml.append("</OrderCount>");
        return xml.toString();
    }
}

