/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class Reset {
    public String till = "";
    public int sequence = 0;
    public Timestamp start = null;
    public Timestamp end = null;
    public double cash = 0.0;
    public double startCash = 0.0;
    public String station;
    public boolean sentToAccounting = false;

    public Reset() {
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<Reset>");
        xml.append("<Till>" + this.till + "</Till>");
        xml.append("<Sequence>" + this.sequence + "</Sequence>");
        xml.append("<Start>" + this.start + "</Start>");
        xml.append("<End>" + this.end + "</End>");
        xml.append("<Cash>" + this.cash + "</Cash>");
        xml.append("<StartCash>" + this.startCash + "</StartCash>");
        xml.append("<Station>" + this.station + "</Station>");
        xml.append("<SentToAccounting>" + this.sentToAccounting + "</SentToAccounting>");
        xml.append("</Reset>");
        return xml.toString();
    }

    public Reset(String resetXml) {
        this.till = Utility.getElement("Till", resetXml);
        this.sequence = Utility.getIntElement("Sequence", resetXml);
        String startTime = Utility.getElement("Start", resetXml);
        this.start = !startTime.equals("null") ? Timestamp.valueOf(startTime) : null;
        String endTime = Utility.getElement("End", resetXml);
        this.end = !endTime.equals("null") ? Timestamp.valueOf(endTime) : null;
        this.cash = Utility.getDoubleElement("Cash", resetXml);
        this.startCash = Utility.getDoubleElement("StartCash", resetXml);
        this.station = Utility.getElement("Station", resetXml);
        this.sentToAccounting = Utility.getBooleanElement("SentToAccounting", resetXml);
    }

    public String toString() {
        SimpleDateFormat format = new SimpleDateFormat("MMMM dd, yyyy HH:MM");
        String from = "";
        String to = "";
        if (this.start != null) {
            from = format.format(this.start);
        }
        if (this.end != null) {
            to = " to " + format.format(this.end);
        }
        return this.till + " " + this.sequence + " " + from + to;
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        SimpleDateFormat format = new SimpleDateFormat("MMMM dd, yyyy HH:MM");
        Date date = new Date();
        String todaysDate = format.format(date);
        try {
            jsonObject.put("id", this.sequence);
            jsonObject.put("till", (Object)this.till);
            if (this.start != null) {
                jsonObject.put("start", (Object)this.start.toString());
            } else {
                jsonObject.put("start", (Object)todaysDate);
            }
            if (this.end != null) {
                jsonObject.put("end", (Object)this.end.toString());
            } else {
                jsonObject.put("end", (Object)todaysDate);
            }
            jsonObject.put("sentToAccounting", this.sentToAccounting);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }
}

