/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.LineItem;
import POSDataObjects.Taxes;
import POSDataObjects.Tender;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class Transaction {
    public long transaction = 0L;
    public long invoice = 0L;
    public Date dateInvoiced = null;
    public Date dateEntered = null;
    public String till = "";
    public String originalTill = "";
    public int sequence = 0;
    public String server = "";
    public ArrayList lineItems = new ArrayList();
    public ArrayList movedLineItems = new ArrayList();
    public ArrayList tendering = new ArrayList();
    public ArrayList taxes = new ArrayList();
    public String taxcode = "";
    public String companyName = "";
    public String first = "";
    public String middle = "";
    public String last = "";
    public String contact = "";
    public String address1 = "";
    public String address2 = "";
    public String address3 = "";
    public String city = "";
    public String state = "";
    public String zip = "";
    public String phone = "";
    public String fax = "";
    public String email = "";
    public String customerCode = "";
    public String resaleNo = "";
    public double total = 0.0;
    public double vatTotal = 0.0;
    public double quantity = 0.0;
    public int guestCount = 0;
    public String receiptEmail = "";
    public Date dateDue = null;
    public Date discountDue = null;
    public String customerTerms = "";
    public boolean addedByPOS = false;
    public boolean changedByPOS = false;
    public String fullName = "";
    public String country = "";
    public String customerType = "";
    public int priceLevel = 0;
    public double creditLimit = 0.0;
    public boolean isCarryout = false;
    public boolean delivery = false;
    public String orderType = "";
    public String locationCode = "";
    public String customerAccountingRef = "";

    public boolean equals(Object obj) {
        if (obj.getClass() == Transaction.class) {
            return this.transaction == ((Transaction)obj).transaction;
        }
        return false;
    }

    public Transaction() {
        this.lineItems = new ArrayList();
        this.tendering = new ArrayList();
        this.taxes = new ArrayList();
    }

    public Transaction(String xml) {
        this.transaction = Utility.getLongElement("TransactionNumber", xml);
        this.invoice = Utility.getLongElement("Invoice", xml);
        String invoiceDate = Utility.getElement("DateInvoiced", xml);
        this.dateInvoiced = invoiceDate.equals("null") || invoiceDate.length() == 0 ? null : Timestamp.valueOf(invoiceDate);
        String enteredDate = Utility.getElement("DateEntered", xml);
        this.dateEntered = enteredDate.equals("null") || enteredDate.length() == 0 ? null : Timestamp.valueOf(enteredDate);
        this.till = Utility.getElement("Till", xml);
        this.originalTill = Utility.getElement("OriginalTill", xml);
        this.sequence = Utility.getIntElement("Sequence", xml);
        this.server = Utility.getElement("Server", xml);
        String lineItemsXml = Utility.getElement("LineItems", xml);
        Vector lineItemsList = Utility.getElementList("LineItem", lineItemsXml);
        int len = lineItemsList.size();
        for (int i = 0; i < len; ++i) {
            String lineItemXml = (String)lineItemsList.get(i);
            LineItem lineItem = new LineItem(lineItemXml);
            this.lineItems.add(lineItem);
        }
        String tendersXml = Utility.getElement("Tenders", xml);
        Vector tendersList = Utility.getElementList("Tender", tendersXml);
        len = tendersList.size();
        for (int i = 0; i < len; ++i) {
            String tenderXml = (String)tendersList.get(i);
            Tender tender = new Tender(tenderXml);
            this.tendering.add(tender);
        }
        Vector taxesList = Utility.getElementList("Taxes", xml);
        len = taxesList.size();
        for (int i = 0; i < len; ++i) {
            String taxXml = (String)taxesList.get(i);
            Taxes tax = new Taxes(taxXml);
            this.taxes.add(tax);
        }
        this.taxcode = Utility.getElement("Taxcode", xml);
        this.companyName = Utility.getElement("CompanyName", xml);
        this.first = Utility.getElement("First", xml);
        this.middle = Utility.getElement("Middle", xml);
        this.last = Utility.getElement("Last", xml);
        this.contact = Utility.getElement("Contact", xml);
        this.address1 = Utility.getElement("Address1", xml);
        this.address2 = Utility.getElement("Address2", xml);
        this.address3 = Utility.getElement("Address3", xml);
        this.city = Utility.getElement("City", xml);
        this.state = Utility.getElement("State", xml);
        this.zip = Utility.getElement("Zip", xml);
        this.phone = Utility.getElement("Phone", xml);
        this.fax = Utility.getElement("Fax", xml);
        this.email = Utility.getElement("Email", xml);
        this.customerCode = Utility.getElement("CustomerCode", xml);
        this.resaleNo = Utility.getElement("ResaleNo", xml);
        this.total = Utility.getDoubleElement("TransactionTotal", xml);
        this.vatTotal = Utility.getDoubleElement("TransactionVatTotal", xml);
        this.quantity = Utility.getDoubleElement("Quantity", xml);
        this.guestCount = Utility.getIntElement("GuestCount", xml);
        this.locationCode = Utility.getElement("LocationCode", xml);
        this.receiptEmail = Utility.getElement("ReceiptEmail", xml);
        this.customerAccountingRef = Utility.getElement("AccountingRef", xml);
    }

    public String toXml() {
        LineItem lineItem;
        int i;
        StringBuffer xml = new StringBuffer();
        xml.append("<Transaction>");
        xml.append("<TransactionNumber>" + this.transaction + "</TransactionNumber>");
        xml.append("<Invoice>" + this.invoice + "</Invoice>");
        xml.append("<DateInvoiced>" + this.dateInvoiced + "</DateInvoiced>");
        xml.append("<DateEntered>" + this.dateEntered + "</DateEntered>");
        xml.append("<Till>" + this.till + "</Till>");
        xml.append("<OriginalTill>" + this.originalTill + "</OriginalTill>");
        xml.append("<Sequence>" + this.sequence + "</Sequence>");
        xml.append("<Server>" + this.server + "</Server>");
        xml.append("<LineItems>");
        int len = this.lineItems.size();
        for (i = 0; i < len; ++i) {
            lineItem = (LineItem)this.lineItems.get(i);
            xml.append(lineItem.toXml());
        }
        xml.append("</LineItems>");
        xml.append("<MovedLineItems>");
        len = this.movedLineItems.size();
        for (i = 0; i < len; ++i) {
            lineItem = (LineItem)this.movedLineItems.get(i);
            xml.append(lineItem.toXml());
        }
        xml.append("</MovedLineItems>");
        xml.append("<Tenders>");
        len = this.tendering.size();
        for (i = 0; i < len; ++i) {
            Tender tender = (Tender)this.tendering.get(i);
            xml.append(tender.toXml());
        }
        xml.append("</Tenders>");
        len = this.taxes.size();
        for (i = 0; i < len; ++i) {
            Taxes tax = (Taxes)this.taxes.get(i);
            xml.append(tax.toXml());
        }
        xml.append("<Taxcode>" + this.taxcode + "</Taxcode>");
        xml.append("<CompanyName>" + this.companyName + "</CompanyName>");
        xml.append("<First>" + this.first + "</First>");
        xml.append("<Middle>" + this.middle + "</Middle>");
        xml.append("<Last>" + this.last + "</Last>");
        xml.append("<Contact>" + this.contact + "</Contact>");
        xml.append("<Address1>" + this.address1 + "</Address1>");
        xml.append("<Address2>" + this.address2 + "</Address2>");
        xml.append("<Address3>" + this.address3 + "</Address3>");
        xml.append("<City>" + this.city + "</City>");
        xml.append("<State>" + this.state + "</State>");
        xml.append("<Zip>" + this.zip + "</Zip>");
        xml.append("<Phone>" + this.phone + "</Phone>");
        xml.append("<Fax>" + this.fax + "</Fax>");
        xml.append("<Email>" + this.email + "</Email>");
        xml.append("<CustomerCode>" + this.customerCode + "</CustomerCode>");
        xml.append("<ResaleNo>" + this.resaleNo + "</ResaleNo>");
        xml.append("<TransactionTotal>" + this.total + "</TransactionTotal>");
        xml.append("<TransactionVatTotal>" + this.vatTotal + "</TransactionVatTotal>");
        xml.append("<Quantity>" + this.quantity + "</Quantity>");
        xml.append("<GuestCount>" + this.guestCount + "</GuestCount>");
        xml.append("<ReceiptEmail>" + this.receiptEmail + "</ReceiptEmail>");
        xml.append("<LocationCode>" + this.locationCode + "</LocationCode>");
        xml.append("<CustomerAccountingRef>" + this.customerAccountingRef + "</CustomerAccountingRef>");
        xml.append("</Transaction>");
        return xml.toString();
    }
}

