/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import org.json.JSONException;
import org.json.JSONObject;

public class UnitOfMeasure {
    public String code = "";
    public String stockingItem = "";
    public double quantity = 0.0;

    public UnitOfMeasure(String code, String stockingItem, double quantity) {
        this.code = code;
        this.stockingItem = stockingItem;
        this.quantity = quantity;
    }

    public UnitOfMeasure() {
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<UOM>");
        xml.append("<Code>" + this.code + "</Code>");
        xml.append("<StockingItem>" + this.stockingItem + "</StockingItem>");
        xml.append("<Quantity>" + this.quantity + "</Quantity>");
        xml.append("</UOM>");
        return xml.toString();
    }

    public UnitOfMeasure(String uomXml) {
        this.code = Utility.getElement("Code", uomXml);
        this.stockingItem = Utility.getElement("StockingItem", uomXml);
        this.quantity = Utility.getDoubleElement("Quantity", uomXml);
    }

    public String toString() {
        return this.code + ", " + this.stockingItem + ", " + this.quantity;
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        JSONObject unitOfMeasure = new JSONObject();
        try {
            unitOfMeasure.put("code", (Object)this.code);
            unitOfMeasure.put("id", (Object)this.code);
            unitOfMeasure.put("stockingItem", (Object)this.stockingItem);
            unitOfMeasure.put("quantity", this.quantity);
            jsonObject.put("unit_of_measure", (Object)unitOfMeasure);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    public UnitOfMeasure(JSONString jsonString) {
        this.code = Utility.getJSONString(jsonString.toString(), "code");
        this.stockingItem = Utility.getJSONString(jsonString.toString(), "stockingItem");
        this.quantity = Utility.getJSONDouble(jsonString.toString(), "quantity");
    }
}

