/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import java.sql.Timestamp;
import java.util.Date;

public class UserSession {
    Timestamp started = null;
    Timestamp lastActive = null;
    public String userId = "";
    byte[] token = null;

    public boolean isValid() {
        long idleMax = 60000L;
        Date now = new Date();
        long last = this.lastActive.getTime();
        return now.getTime() - last < idleMax;
    }

    public void setToken(byte[] token) {
        this.token = token;
    }

    public byte[] getToken() {
        return this.token;
    }

    public boolean authenticateToken(byte[] sourceToken) {
        if (sourceToken == null || this.token == null) {
            return false;
        }
        if (sourceToken.length != this.token.length) {
            return false;
        }
        for (int i = 0; i < this.token.length; ++i) {
            if (this.token[i] == sourceToken[i]) continue;
            return false;
        }
        return true;
    }

    public UserSession(String userId) {
        Timestamp now = new Timestamp(new Date().getTime());
        this.userId = userId;
        this.started = now;
        this.lastActive = now;
    }

    public void updateActive() {
        Timestamp now;
        this.lastActive = now = new Timestamp(new Date().getTime());
    }
}

