/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import org.json.JSONException;
import org.json.JSONObject;

public class ValueAddedTax {
    public int id = 0;
    public String code = "";
    public String description = "";
    public double rate = 0.0;
    public double rate2 = 0.0;
    public boolean isPiggyBack = false;
    public double vatTax1 = 0.0;
    public double vatTax2 = 0.0;

    public ValueAddedTax() {
    }

    public JSONObject toJson() {
        JSONObject output = new JSONObject();
        try {
            output.put("rate2", this.rate2);
            output.put("rate", this.rate);
            output.put("code", (Object)this.code);
            output.put("id", this.id);
            output.put("isPiggyBack", this.isPiggyBack);
            output.put("description", (Object)this.description);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return output;
    }

    public ValueAddedTax(int id, String code, String description, double rate, double rate2, boolean isPiggyBack) {
        this.id = id;
        this.code = code;
        this.description = description;
        this.rate = rate;
        this.rate2 = rate2;
        this.isPiggyBack = isPiggyBack;
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<VatCode>");
        xml.append("<Id>" + this.id + "</Id>");
        xml.append("<Code>" + this.code + "</Code>");
        xml.append("<Description>" + this.description + "</Description>");
        xml.append("<Rate>" + this.rate + "</Rate>");
        xml.append("<Rate2>" + this.rate2 + "</Rate2>");
        xml.append("<IsPiggyBack>" + this.isPiggyBack + "</IsPiggyBack>");
        xml.append("</VatCode>");
        return xml.toString();
    }

    public ValueAddedTax(JSONString jsonString) {
        this.id = Utility.getJSONInt(jsonString.toString(), "id");
        this.description = Utility.getJSONString(jsonString.toString(), "description");
        this.code = Utility.getJSONString(jsonString.toString(), "code");
        this.rate = Utility.getJSONDouble(jsonString.toString(), "rate");
        this.rate2 = Utility.getJSONDouble(jsonString.toString(), "rate2");
        this.isPiggyBack = Utility.getJSONBoolean(jsonString.toString(), "isPiggyBack");
    }

    public ValueAddedTax(String vatCodeXml) {
        this.id = Utility.getIntElement("Id", vatCodeXml);
        this.code = Utility.getElement("Code", vatCodeXml);
        this.description = Utility.getElement("Description", vatCodeXml);
        this.rate = Utility.getDoubleElement("Rate", vatCodeXml);
        this.rate2 = Utility.getDoubleElement("Rate2", vatCodeXml);
        this.isPiggyBack = Utility.getBooleanElement("IsPiggyBack", vatCodeXml);
    }

    public String toString() {
        return this.code + ", " + this.description + ", " + this.rate + ", " + this.rate2 + ", " + this.isPiggyBack;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != ValueAddedTax.class) {
            return false;
        }
        return this.code.equalsIgnoreCase(((ValueAddedTax)obj).code);
    }
}

