/*
 * Decompiled with CFR 0.152.
 */
package AccuServerConnector;

import AccuServerConnector.WebSocketClientConnection;
import AccuServerConnector.WebSocketHost;
import AccuServerConnector.WebSocketRequestHandler;
import java.net.InetSocketAddress;
import java.util.Hashtable;
import java.util.Map;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

public class WebSocketConnector
extends WebSocketServer {
    WebSocketHost host = null;
    Hashtable clients = null;
    Hashtable webSockets = null;

    public WebSocketConnector(int port, WebSocketHost host) {
        super(new InetSocketAddress(port));
        this.host = host;
    }

    public WebSocketClientConnection getWebSocketClientConnection(WebSocket websocket) {
        WebSocketClientConnection thisConnection = null;
        thisConnection = (WebSocketClientConnection)this.webSockets.get(websocket);
        return thisConnection;
    }

    public WebSocketClientConnection getWebSocketClientConnection(String serialNumber) {
        WebSocketClientConnection thisConnection = null;
        thisConnection = (WebSocketClientConnection)this.clients.get(serialNumber);
        return thisConnection;
    }

    public void sendTo(String deviceId, String message) {
        if (this.clients == null) {
            return;
        }
        WebSocketClientConnection thisConnection = (WebSocketClientConnection)this.clients.get(deviceId);
        if (thisConnection == null) {
            this.host.core.logText("No AccuPOS Client connection found for " + deviceId);
            return;
        }
        WebSocket clientConnection = thisConnection.websocketConnection;
        if (thisConnection.websocketConnection == null) {
            this.host.core.logText("No AccuPOS Client connection found for " + deviceId);
            return;
        }
        clientConnection.send(message);
    }

    public void sendAdapterMessage(String message) {
        if (this.clients == null) {
            return;
        }
        WebSocketClientConnection thisConnection = (WebSocketClientConnection)this.clients.get("Adapter");
        if (thisConnection == null) {
            this.host.core.logText("No AccuPOS Client connection found for Accounting Adapter");
            return;
        }
        WebSocket adapterConnection = thisConnection.websocketConnection;
        if (thisConnection.websocketConnection == null) {
            this.host.core.logText("No AccuPOS Client connection found for Accounting Adapter");
            return;
        }
        adapterConnection.send(message);
    }

    public void forceClose(String serialNumber) {
        WebSocketClientConnection thisConnection = (WebSocketClientConnection)this.clients.get(serialNumber);
        WebSocket clientConnection = thisConnection.websocketConnection;
        clientConnection.close(5);
    }

    public void onOpen(WebSocket clientWebsocketConnection, ClientHandshake handshake) {
        String clientInfo = "";
        System.out.println("entering on open");
        WebSocketClientConnection thisConnection = null;
        if (handshake.hasFieldValue("Sec-WebSocket-Key")) {
            String resourceDescriptor = handshake.getResourceDescriptor();
            String secWebsocketKey = handshake.getFieldValue("Sec-WebSocket-Key");
            if (resourceDescriptor != null && !resourceDescriptor.equals("/")) {
                if (this.clients == null) {
                    this.clients = new Hashtable();
                }
                if (this.webSockets == null) {
                    this.webSockets = new Hashtable();
                }
                if ((clientInfo = resourceDescriptor.substring(resourceDescriptor.indexOf("/") + 1)) != null && !clientInfo.isEmpty()) {
                    thisConnection = new WebSocketClientConnection();
                    if (clientInfo.contains("/")) {
                        String[] clientInfoSegments = clientInfo.split("/");
                        thisConnection.clientName = clientInfoSegments[1];
                        thisConnection.clientType = clientInfoSegments[0];
                    } else {
                        thisConnection.clientType = "RDS";
                        thisConnection.clientName = clientInfo;
                    }
                    thisConnection.websocketConnection = clientWebsocketConnection;
                    this.clients.put(thisConnection.clientName, thisConnection);
                    this.webSockets.put(thisConnection.websocketConnection, thisConnection);
                }
                System.out.println("Client " + thisConnection.clientName + "-" + thisConnection.clientType + " connected");
            }
        }
        System.out.println("exiting on open");
    }

    public void onClose(WebSocket websocket, int i, String string, boolean bln) {
        System.out.println("closing .....");
        this.host.core.input("Closing Web Socket Connection");
        WebSocketClientConnection thisConnection = (WebSocketClientConnection)this.webSockets.get(websocket);
        if (thisConnection != null) {
            this.host.core.input("Web Socket Connection Closed for " + thisConnection.clientName);
            String serialNumber = thisConnection.clientName;
            if (thisConnection.clientType.compareToIgnoreCase("PAYMENT_TERMINAL") == 0) {
                String terminalIpAddress = thisConnection.websocketConnection.getRemoteSocketAddress().getAddress().getHostAddress();
                this.host.core.removeTerminal(terminalIpAddress);
            }
            this.clients.remove(serialNumber);
            this.webSockets.remove(websocket);
        }
    }

    public void onMessage(WebSocket clientWebSocketConnection, String message) {
        System.out.println("entering on message");
        WebSocketRequestHandler handler = new WebSocketRequestHandler(this.host, clientWebSocketConnection, message);
        handler.start();
    }

    public void onError(WebSocket ws, Exception excptn) {
        System.out.println("entering on error");
        System.out.println(excptn.getMessage());
        excptn.printStackTrace();
    }

    public void onStart() {
        System.out.println("WebSocketHost Started");
        this.host.output("WebSocketHost Started");
    }

    public void sendAllPOSMessage(String message) {
        if (this.clients == null || this.clients.isEmpty()) {
            return;
        }
        for (Map.Entry pair : this.clients.entrySet()) {
            System.out.println(pair.getKey() + " = " + pair.getValue());
            String clientName = (String)pair.getKey();
            WebSocketClientConnection thisClientConnection = (WebSocketClientConnection)pair.getValue();
            if (!thisClientConnection.clientType.contains("POS")) continue;
            this.sendTo(clientName, message);
        }
    }
}

