/*
 * Decompiled with CFR 0.152.
 */
package AccuServerWebServers.Controllers;

import AccuServerBase.ServerCore;
import AccuServerWebServers.AccuServerWebServerNew;
import AccuServerWebServers.Controllers.AbstractController;
import POSDataObjects.POSDataContainer;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.Hashtable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class POSStationsController
extends AbstractController {
    public POSStationsController(AccuServerWebServerNew webServer, ServerCore core, Socket socket, String path, Hashtable parameters) {
        super(webServer, core, socket, path, parameters);
    }

    public void getPOSStations() {
        if (!this.sessionTokenValid()) {
            return;
        }
        POSDataContainer results = null;
        JSONArray response = new JSONArray();
        try {
            results = this.core.getPOSStations();
            int len = results.size();
            for (int i = 0; i < len; ++i) {
                String thisStationId = (String)results.get(i);
                String thisStationName = this.core.getPOSStationName(thisStationId);
                JSONObject json = new JSONObject();
                json.put("name", (Object)thisStationName);
                json.put("id", (Object)thisStationId);
                response.put((Object)json);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.webServer.sendJsonResponse(this.socket, response.toString());
    }

    public void updatePosStation() {
        if (!this.sessionTokenValid()) {
            return;
        }
        boolean success = false;
        try {
            String jsonString = URLDecoder.decode((String)this.parameters.get("posStation"), "UTF-8");
            JSONObject json = new JSONObject(jsonString);
            String id = json.getString("id");
            String name = json.getString("name");
            POSDataContainer results = this.core.getPOSStations();
            int len = results.size();
            for (int i = 0; i < len; ++i) {
                String thisStationId = (String)results.get(i);
                if (!id.equals(thisStationId)) continue;
                Hashtable<String, String> table = new Hashtable<String, String>();
                table.put(thisStationId, name);
                this.core.updatePOSStations(table);
                success = true;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JSONObject response = new JSONObject();
        try {
            if (success) {
                response.put("success", true);
                this.webServer.sendJsonResponse(this.socket, response.toString());
            } else {
                response.put("success", false);
                this.webServer.sendJsonResponse(this.socket, response.toString(), 500);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

