/*
 * Decompiled with CFR 0.152.
 */
package AccuServerWebServers;

import AccuServerBase.ServerCore;
import AccuServerBase.UserReportObject;
import AccuServerBase.Utility;
import POSDataObjects.LineItem;
import POSDataObjects.Order;
import POSDataObjects.POSDataContainer;
import POSDataObjects.ReceiptPrintSetup;
import POSDataObjects.Reset;
import POSDataObjects.Taxes;
import POSDataObjects.Tender;
import POSDataObjects.Transaction;
import POSDataObjects.TransactionReportOptions;
import POSDataObjects.User;
import java.io.IOException;
import java.net.Socket;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DriverSummary
implements UserReportObject {
    ServerCore core = null;
    Socket socket = null;
    ReceiptPrintSetup companyInfo = null;
    Vector transactions = null;
    Vector<Order> orders = new Vector();
    boolean byReset = false;
    Timestamp fromDate = null;
    Timestamp thruDate = null;
    Reset reset = null;
    String html = "";
    boolean export = false;
    String reportFileName = "";
    String userName = "";
    boolean showGraphs = false;
    Vector<String> driversList = new Vector();
    private String countryCode;
    static final String template = "driver_summary";

    public void initialize(ServerCore core, Socket socket, boolean export) {
        this.core = core;
        this.socket = socket;
        this.export = export;
        this.countryCode = core.getCountry();
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public void setByReset(Reset thisReset) {
        this.reset = thisReset;
        this.byReset = true;
    }

    public void setByDates(Timestamp fromDate, Timestamp thruDate) {
        this.fromDate = fromDate;
        this.thruDate = thruDate;
        this.byReset = false;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setShowGraphs(boolean showGraphs) {
        this.showGraphs = showGraphs;
    }

    public void loadData() {
        this.companyInfo = this.core.getReceiptPrintSetup();
        TransactionReportOptions reportOptions = new TransactionReportOptions();
        reportOptions.fromDate = this.fromDate;
        reportOptions.thruDate = this.thruDate;
        reportOptions.reset = this.reset;
        reportOptions.userName = this.userName;
        this.transactions = this.core.getTransactionData(reportOptions);
        if (this.transactions == null) {
            this.transactions = new POSDataContainer();
        }
        int len = this.transactions.size();
        for (int i = 0; i < len; ++i) {
            Transaction thisTransaction = (Transaction)this.transactions.get(i);
            if (!thisTransaction.delivery) continue;
            Order thisOrder = this.core.getOrder((int)thisTransaction.transaction, true);
            thisOrder.lineItems = new Vector(thisTransaction.lineItems);
            if (thisOrder.driver.isEmpty()) continue;
            this.orders.add(thisOrder);
        }
        if (this.userName != null && !this.userName.isEmpty()) {
            this.driversList.add(this.userName);
        } else {
            POSDataContainer users = this.core.getUserList();
            if (users != null && !users.isEmpty()) {
                int size = users.size();
                for (int i = 0; i < size; ++i) {
                    User thisUser = (User)users.get(i);
                    if (!thisUser.isDriver) continue;
                    this.driversList.add(thisUser.id);
                }
            }
        }
    }

    public boolean getReportHtml() {
        SimpleDateFormat dateFormat = null;
        DecimalFormat currencyFormat = null;
        DecimalFormat quantityFormat = null;
        DecimalFormat priceFormat = null;
        String taxableString = "";
        String nontaxableString = "";
        String errors = "";
        double autoGratuity = 0.0;
        if (this.transactions == null || this.transactions.isEmpty()) {
            this.transactions = new Vector();
        }
        this.html = this.export ? this.core.getWebServer().getTemplateHtml("driver_summary.tml") : this.core.getWebServer().getTemplateHtml("driver_summary.tmpl");
        if (this.html == null) {
            return false;
        }
        if (this.export) {
            String reportStylesXml = this.core.getWebServer().getReportStylesXml();
            this.html = Utility.replaceDataTag((String)this.html, (String)"ReportStylesBlock", (String)reportStylesXml);
        }
        SimpleDateFormat titleFormat = new SimpleDateFormat(this.core.getWebServer().getDateFormat());
        String runTime = titleFormat.format(new Date());
        this.html = Utility.replaceDataTag((String)this.html, (String)"DateRun", (String)runTime);
        String ranges = "";
        SimpleDateFormat rangeDate = new SimpleDateFormat(this.core.getWebServer().getDateTimeFormat());
        ranges = this.byReset ? "For Till " + this.reset.till + " Sequence " + this.reset.sequence : "From " + rangeDate.format(this.fromDate) + " Through " + rangeDate.format(this.thruDate);
        this.html = Utility.replaceDataTag((String)this.html, (String)"Range", (String)ranges);
        String serverBlock = Utility.getDataBlockContents((String)"ServerBlock", (String)this.html);
        String tenderBlock = Utility.getDataBlockContents((String)"TenderBlock", (String)this.html);
        String itemTypeBlock = Utility.getDataBlockContents((String)"ItemTypeBlock", (String)this.html);
        String taxBlock = Utility.getDataBlockContents((String)"TaxBlock", (String)this.html);
        String voidBlock = Utility.getDataBlockContents((String)"VoidBlock", (String)this.html);
        String dateFormatString = Utility.getDataBlockContents((String)"DateFormat", (String)this.html);
        this.html = Utility.replaceBlock((String)this.html, (String)"DateFormat", (String)"");
        String currencyFormatString = Utility.getDataBlockContents((String)"CurrencyFormat", (String)this.html);
        this.html = Utility.replaceBlock((String)this.html, (String)"CurrencyFormat", (String)"");
        String priceFormatString = Utility.getDataBlockContents((String)"PriceFormat", (String)this.html);
        this.html = Utility.replaceBlock((String)this.html, (String)"PriceFormat", (String)"");
        String quantityFormatString = Utility.getDataBlockContents((String)"QuantityFormat", (String)this.html);
        this.html = Utility.replaceBlock((String)this.html, (String)"QuantityFormat", (String)"");
        taxableString = Utility.getDataBlockContents((String)"TaxableText", (String)this.html);
        this.html = Utility.replaceBlock((String)this.html, (String)"TaxableText", (String)"");
        nontaxableString = Utility.getDataBlockContents((String)"NontaxableText", (String)this.html);
        this.html = Utility.replaceBlock((String)this.html, (String)"NontaxableText", (String)"");
        if (this.companyInfo != null) {
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyName", (String)this.companyInfo.companyName);
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyAddress1", (String)this.companyInfo.companyAddress1);
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyAddress2", (String)this.companyInfo.companyAddress2);
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyCity", (String)this.companyInfo.companyCity);
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyState", (String)this.companyInfo.companyState);
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyZip", (String)this.companyInfo.companyZip);
        } else {
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyName", (String)"");
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyAddress1", (String)"");
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyAddress2", (String)"");
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyCity", (String)"");
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyState", (String)"");
            this.html = Utility.replaceDataTag((String)this.html, (String)"CompanyZip", (String)"");
        }
        dateFormat = new SimpleDateFormat(dateFormatString);
        currencyFormat = new DecimalFormat(currencyFormatString);
        quantityFormat = new DecimalFormat(quantityFormatString);
        priceFormat = new DecimalFormat(priceFormatString);
        double reportTaxable = 0.0;
        double reportNontaxable = 0.0;
        double reportTax = 0.0;
        int len = this.orders.size();
        Hashtable<String, Double> usersTable = new Hashtable<String, Double>();
        int driversLen = this.driversList.size();
        StringBuilder serverText = new StringBuilder();
        for (int s = 0; s < driversLen; ++s) {
            String driverId = this.driversList.get(s);
            String thisServerBlock = serverBlock;
            Hashtable<String, Summary> items = new Hashtable<String, Summary>();
            Hashtable<String, Summary> tender = new Hashtable<String, Summary>();
            Hashtable<String, Summary> taxes = new Hashtable<String, Summary>();
            Hashtable<String, Summary> voids = new Hashtable<String, Summary>();
            double itemQuantityTotal = 0.0;
            double itemTotal = 0.0;
            double tenderingTotal = 0.0;
            double taxTotal = 0.0;
            double voidQuantityTotal = 0.0;
            double voidTotal = 0.0;
            int guestCount = 0;
            double tipsTotal = 0.0;
            double tipsPaid = 0.0;
            double netCash = 0.0;
            autoGratuity = 0.0;
            double customerPayments = 0.0;
            int creditCardCount = 0;
            int debitCardCount = 0;
            int checkCount = 0;
            for (int t = 0; t < len; ++t) {
                Summary thisSummary;
                Order thisTransaction = this.orders.get(t);
                if (thisTransaction.driver.compareToIgnoreCase(driverId) != 0) continue;
                guestCount += thisTransaction.guestCount;
                int itemsLen = thisTransaction.lineItems.size();
                int tenderLen = thisTransaction.tenderings.size();
                int taxesLen = thisTransaction.taxAuthorities.size();
                for (int l = 0; l < itemsLen; ++l) {
                    LineItem thisLine = (LineItem)thisTransaction.lineItems.get(l);
                    thisSummary = (Summary)items.get(thisLine.itemType);
                    if (thisSummary == null) {
                        thisSummary = new Summary();
                    }
                    thisSummary.name = thisLine.itemType;
                    thisSummary.quantity += thisLine.quantity;
                    thisSummary.total += thisLine.total;
                    itemTotal += thisLine.total;
                    itemQuantityTotal += thisLine.quantity;
                    if (this.countryCode.equals("IL")) {
                        if (thisLine.taxCode.equals("\u05de\u05e2\u05de")) {
                            reportTaxable += thisLine.total;
                        } else {
                            reportNontaxable += thisLine.total;
                        }
                    } else if (thisLine.taxable) {
                        reportTaxable += thisLine.total;
                    } else {
                        reportNontaxable += thisLine.total;
                    }
                    items.put(thisLine.itemType, thisSummary);
                    taxTotal = thisLine.vatGross < -1.0E-4 || thisLine.vatGross > 1.0E-4 ? (taxTotal += thisLine.vatGross - thisLine.total) : (taxTotal += thisLine.vatTax1 + thisLine.vatTax2);
                    if (!(thisLine.quantity < -1.0E-4) || thisLine.itemId.equalsIgnoreCase("Discount") || thisLine.itemId.equalsIgnoreCase("Disc")) continue;
                    Summary voidSummary = (Summary)voids.get(thisLine.itemType);
                    if (voidSummary == null) {
                        voidSummary = new Summary();
                    }
                    voidSummary.name = thisLine.itemType;
                    voidSummary.quantity += thisLine.quantity;
                    voidSummary.total += thisLine.total;
                    voidTotal += thisLine.total;
                    voidQuantityTotal += thisLine.quantity;
                    voids.put(thisLine.itemType, voidSummary);
                }
                for (int n = 0; n < tenderLen; ++n) {
                    Tender thisTender = (Tender)thisTransaction.tenderings.get(n);
                    if (thisTender.type.equals("Y")) {
                        customerPayments += thisTender.amount * -1.0;
                        continue;
                    }
                    if ((thisTender.type.compareToIgnoreCase("$") == 0 || thisTender.type.compareToIgnoreCase("P") == 0) && thisTender.status.compareToIgnoreCase("A") != 0) {
                        netCash += thisTender.amount;
                    }
                    if (thisTender.type.equals("C") || thisTender.type.equals("D")) {
                        ++creditCardCount;
                    }
                    if (thisTender.type.equals("B")) {
                        ++debitCardCount;
                    }
                    if (thisTender.status.compareToIgnoreCase("G") == 0 && (thisTender.type.equals("C") || thisTender.type.equals("D"))) {
                        tipsPaid += thisTender.amount;
                    } else if (thisTender.status.compareToIgnoreCase("T") == 0) {
                        tipsTotal += thisTender.amount * -1.0;
                    } else if (thisTender.status.compareToIgnoreCase("A") == 0) {
                        tipsTotal += thisTender.amount * -1.0;
                        autoGratuity += thisTender.amount * -1.0;
                    }
                    if (thisTender.status.compareToIgnoreCase("A") == 0) continue;
                    thisSummary = (Summary)tender.get(thisTender.description);
                    if (thisSummary == null) {
                        thisSummary = new Summary();
                    }
                    thisSummary.name = thisTender.description;
                    thisSummary.total += thisTender.amount;
                    tenderingTotal += thisTender.amount;
                    tender.put(thisTender.description, thisSummary);
                    if (!(thisTender.amount > 1.0E-4) || thisTender.status.equalsIgnoreCase("V") || thisTender.status.equalsIgnoreCase("G")) continue;
                    ++checkCount;
                }
                for (int x = 0; x < taxesLen; ++x) {
                    Taxes thisTax = (Taxes)thisTransaction.taxAuthorities.get(x);
                    thisSummary = (Summary)taxes.get(thisTax.authority);
                    if (thisSummary == null) {
                        thisSummary = new Summary();
                    }
                    thisSummary.name = thisTax.authority;
                    thisSummary.total += thisTax.amount;
                    taxTotal += thisTax.amount;
                    taxes.put(thisTax.authority, thisSummary);
                }
            }
            double taxable = 0.0;
            double nonTaxable = 0.0;
            ArrayList tenderList = new ArrayList(tender.values());
            StringBuilder tenderText = new StringBuilder();
            int tenderLen = tenderList.size();
            for (int n = 0; n < tenderLen; ++n) {
                String thisTenderBlock = tenderBlock;
                Summary thisTender = (Summary)tenderList.get(n);
                thisTenderBlock = Utility.replaceDataTag((String)thisTenderBlock, (String)"TenderName", (String)thisTender.name);
                thisTenderBlock = Utility.replaceDataTag((String)thisTenderBlock, (String)"TenderAmount", (String)currencyFormat.format(thisTender.total));
                tenderText.append(thisTenderBlock);
            }
            thisServerBlock = Utility.replaceBlock((String)thisServerBlock, (String)"TenderBlock", (String)tenderText.toString());
            thisServerBlock = Utility.replaceDataTag((String)thisServerBlock, (String)"TenderTotal", (String)currencyFormat.format(tenderingTotal));
            thisServerBlock = guestCount > 0 ? Utility.replaceDataTag((String)thisServerBlock, (String)"AverageCheck", (String)currencyFormat.format(itemTotal / (double)guestCount)) : Utility.replaceDataTag((String)thisServerBlock, (String)"AverageCheck", (String)"");
            thisServerBlock = Utility.replaceDataTag((String)thisServerBlock, (String)"CreditCardTips", (String)currencyFormat.format(tipsPaid));
            thisServerBlock = Utility.replaceDataTag((String)thisServerBlock, (String)"TotalCreditCardTips", (String)currencyFormat.format(tipsTotal));
            thisServerBlock = Utility.replaceDataTag((String)thisServerBlock, (String)"TotalOtherTips", (String)currencyFormat.format(tipsTotal - tipsPaid - autoGratuity));
            thisServerBlock = Utility.replaceDataTag((String)thisServerBlock, (String)"AutoGratuity", (String)currencyFormat.format(autoGratuity));
            thisServerBlock = Utility.replaceDataTag((String)thisServerBlock, (String)"NetCash", (String)currencyFormat.format(netCash));
            ArrayList typesList = new ArrayList(items.values());
            StringBuilder typesText = new StringBuilder();
            int typesLen = typesList.size();
            for (int t = 0; t < typesLen; ++t) {
                String thisItemTypeBlock = itemTypeBlock;
                Summary thisType = (Summary)typesList.get(t);
                thisItemTypeBlock = Utility.replaceDataTag((String)thisItemTypeBlock, (String)"ItemType", (String)thisType.name);
                thisItemTypeBlock = Utility.replaceDataTag((String)thisItemTypeBlock, (String)"ItemQuantity", (String)quantityFormat.format(thisType.quantity));
                thisItemTypeBlock = Utility.replaceDataTag((String)thisItemTypeBlock, (String)"ItemAmount", (String)currencyFormat.format(thisType.total));
                typesText.append(thisItemTypeBlock);
            }
            thisServerBlock = Utility.replaceBlock((String)thisServerBlock, (String)"ItemTypeBlock", (String)typesText.toString());
            thisServerBlock = Utility.replaceDataTag((String)thisServerBlock, (String)"ItemTotal", (String)currencyFormat.format(itemTotal));
            thisServerBlock = Utility.replaceDataTag((String)thisServerBlock, (String)"ItemQuantityTotal", (String)quantityFormat.format(itemQuantityTotal));
            ArrayList voidsList = new ArrayList(voids.values());
            StringBuilder voidsText = new StringBuilder();
            int voidsLen = voidsList.size();
            for (int v = 0; v < voidsLen; ++v) {
                String thisVoidBlock = voidBlock;
                Summary thisVoid = (Summary)voidsList.get(v);
                thisVoidBlock = Utility.replaceDataTag((String)thisVoidBlock, (String)"VoidItemType", (String)thisVoid.name);
                thisVoidBlock = Utility.replaceDataTag((String)thisVoidBlock, (String)"VoidItemQuantity", (String)quantityFormat.format(thisVoid.quantity));
                thisVoidBlock = Utility.replaceDataTag((String)thisVoidBlock, (String)"VoidItemAmount", (String)currencyFormat.format(thisVoid.total));
                voidsText.append(thisVoidBlock);
            }
            thisServerBlock = Utility.replaceBlock((String)thisServerBlock, (String)"VoidBlock", (String)voidsText.toString());
            thisServerBlock = Utility.replaceDataTag((String)thisServerBlock, (String)"VoidItemTotal", (String)currencyFormat.format(voidTotal));
            thisServerBlock = Utility.replaceDataTag((String)thisServerBlock, (String)"VoidItemQuantityTotal", (String)quantityFormat.format(voidQuantityTotal));
            ArrayList taxList = new ArrayList(taxes.values());
            StringBuilder taxesText = new StringBuilder();
            int taxesLen = taxList.size();
            for (int x = 0; x < taxesLen; ++x) {
                String thisTaxBlock = taxBlock;
                Summary thisType = (Summary)taxList.get(x);
                thisTaxBlock = Utility.replaceDataTag((String)thisTaxBlock, (String)"TaxAuthority", (String)thisType.name);
                thisTaxBlock = Utility.replaceDataTag((String)thisTaxBlock, (String)"TaxAmount", (String)currencyFormat.format(thisType.total));
                taxesText.append(thisTaxBlock);
            }
            thisServerBlock = Utility.replaceBlock((String)thisServerBlock, (String)"TaxBlock", (String)taxesText.toString());
            thisServerBlock = Utility.replaceDataTag((String)thisServerBlock, (String)"TaxTotal", (String)currencyFormat.format(taxTotal));
            reportTaxable += taxable;
            reportNontaxable += nonTaxable;
            reportTax += taxTotal;
            thisServerBlock = Utility.replaceDataTag((String)thisServerBlock, (String)"GuestCount", (String)("" + guestCount));
            thisServerBlock = Utility.replaceDataTag((String)thisServerBlock, (String)"CheckCount", (String)("" + checkCount));
            thisServerBlock = Utility.replaceDataTag((String)thisServerBlock, (String)"ServerId", (String)driverId);
            serverText.append(thisServerBlock);
            if (usersTable.containsKey(driverId)) {
                double usersTotal = (Double)usersTable.get(driverId);
                usersTable.put(driverId, usersTotal + itemTotal);
                continue;
            }
            usersTable.put(driverId, itemTotal);
        }
        DecimalFormat decimal = new DecimalFormat("#0.00;-#0.00");
        if (this.showGraphs && usersTable != null && !usersTable.isEmpty()) {
            int colorCount = 0;
            String[] barColors = new String[]{"#6495ED", "#DAA520", "#DC143C", "#2E8B57", "#708090", "#8B4513", "#000080", "#3CB371", "#FA8072", "#4B0082"};
            StringBuilder labels = new StringBuilder();
            StringBuilder fillColors = new StringBuilder();
            StringBuilder data = new StringBuilder();
            Enumeration e = usersTable.keys();
            while (e.hasMoreElements()) {
                String userName = (String)e.nextElement();
                double userValue = (Double)usersTable.get(userName);
                if (labels.length() == 0) {
                    labels.append("'" + userName + "'");
                } else {
                    labels.append(", '" + userName + "'");
                }
                String barColor = barColors[colorCount];
                if (fillColors.length() == 0) {
                    fillColors.append("'" + barColor + "'");
                } else {
                    fillColors.append(", '" + barColor + "'");
                }
                if (data.length() == 0) {
                    data.append(decimal.format(Math.abs(userValue)));
                } else {
                    data.append(", " + decimal.format(Math.abs(userValue)));
                }
                if (++colorCount <= barColors.length - 1) continue;
                colorCount = 0;
            }
            StringBuilder barChartData = new StringBuilder();
            barChartData.append("labels: [" + labels + "],\r\n");
            barChartData.append("datasets:\r\n");
            barChartData.append("[{\r\n");
            barChartData.append("  fillColor: [" + fillColors + "],\r\n");
            barChartData.append("  strokeColor: '#FFFFFF', \r\n");
            barChartData.append("  data: [" + data + "]\r\n");
            barChartData.append("}]");
            this.html = Utility.replaceDataTag((String)this.html, (String)"BarChartData", (String)barChartData.toString());
            this.html = Utility.replaceDataTag((String)this.html, (String)"ShowChartData", (String)"display: inline-block;");
        } else {
            this.html = Utility.replaceDataTag((String)this.html, (String)"BarChartData", (String)"");
            this.html = Utility.replaceDataTag((String)this.html, (String)"ShowChartData", (String)"display: none;");
        }
        this.html = Utility.replaceBlock((String)this.html, (String)"ServerBlock", (String)serverText.toString());
        this.html = Utility.replaceDataTag((String)this.html, (String)"ReportTaxableTotal", (String)currencyFormat.format(reportTaxable));
        this.html = Utility.replaceDataTag((String)this.html, (String)"ReportNontaxableTotal", (String)currencyFormat.format(reportNontaxable));
        this.html = Utility.replaceDataTag((String)this.html, (String)"ReportTaxTotal", (String)currencyFormat.format(reportTax));
        this.html = Utility.replaceDataTag((String)this.html, (String)"AutoGratuity", (String)currencyFormat.format(autoGratuity));
        this.html = Utility.replaceDataTag((String)this.html, (String)"ReportTotal", (String)currencyFormat.format(reportTaxable + reportNontaxable + reportTax + autoGratuity));
        this.html = Utility.replaceDataTag((String)this.html, (String)"Errors", (String)errors);
        if (!this.export) {
            this.core.getWebServer().sendHtmlResponse(this.socket, this.html, true, true);
        }
        this.reportFileName = this.export ? this.core.getWebServer().getReportPath() + template + ".xml" : this.core.getWebServer().getReportPath() + template + ".html";
        try {
            Utility.writeXml((String)this.reportFileName, (String)this.html);
        }
        catch (IOException ex) {
            this.core.raiseException((Exception)ex);
        }
        return true;
    }

    class Summary {
        public String name = "";
        public double quantity = 0.0;
        public double total = 0.0;

        Summary() {
        }
    }
}

