/*
 * Decompiled with CFR 0.152.
 */
package CardHandlers;

import AccuServerBase.MoneyCardHandlerBase;
import AccuServerBase.ServerCore;
import AccuServerBase.ServerObject;
import AccuServerBase.Utility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Vector;

public class CibusCardHandler
implements ServerObject,
MoneyCardHandlerBase {
    ServerCore core = null;
    String hostUrl = "https://api.poslb.pluxee.co.il/poswebservice/posws.asmx";
    String resId = "";
    String posId = "";
    String companyCode = "0";
    boolean debug = false;
    boolean waitingOnResponse = false;
    String postResponse = "";
    boolean six = false;
    DecimalFormat decimal = new DecimalFormat("####0.00;-####0.00");

    public void initialize(ServerCore core, Hashtable parameters) {
        this.core = core;
        String parameter = (String)parameters.get("ResId");
        if (parameter != null && parameter.length() > 0) {
            this.resId = parameter;
        }
        if ((parameter = (String)parameters.get("PosId")) != null && parameter.length() > 0) {
            this.posId = parameter;
        }
        if ((parameter = (String)parameters.get("Debug")) != null && parameter.length() > 0) {
            this.debug = parameter.equalsIgnoreCase("true");
        }
        if ((parameter = (String)parameters.get("Six")) != null && parameter.length() > 0) {
            this.six = parameter.equalsIgnoreCase("true");
        }
        this.core.setCibusCardHandler((MoneyCardHandlerBase)this);
        if (!this.resId.isEmpty() && !this.posId.isEmpty()) {
            this.companyCode = this.getCompanyCode();
        }
    }

    public void output(String output) {
        this.core.input(output);
    }

    private String getCompanyCode() {
        int listItemsCount;
        StringBuilder request = new StringBuilder();
        request.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
        request.append("<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"> \r\n");
        request.append("  <soap:Body>\r\n");
        request.append("    <LoadCompanies1255 xmlns=\"www.cibusnet.co.il\">\r\n");
        request.append("      <restaurantID>" + this.resId + "</restaurantID>\r\n");
        request.append("      <posID>" + this.posId + "</posID>\r\n");
        request.append("      <prefix>0</prefix>\r\n");
        request.append("    </LoadCompanies1255>\r\n");
        request.append("  </soap:Body>\r\n");
        request.append("</soap:Envelope>\r\n");
        this.companyCode = "0";
        String resultXml = this.sendRequest(request.toString(), "LoadCompanies1255");
        int response = Utility.getIntElement((String)"LoadCompanies1255Result", (String)resultXml);
        if (response == 0 && (listItemsCount = Utility.getIntElement((String)"listItemsCount", (String)resultXml)) > 0) {
            Vector companyCodeList = Utility.getElementList((String)"companyCodeList", (String)resultXml);
            Vector companyNameList = Utility.getElementList((String)"companyNameList", (String)resultXml);
            for (int i = 0; i < listItemsCount; ++i) {
                System.out.println("companyCodeList=" + companyCodeList.get(i));
                System.out.println("companyNameList=" + companyCodeList.get(i));
            }
            this.companyCode = (String)companyCodeList.get(0);
        }
        return this.companyCode;
    }

    public String processMoneyCard(String cardNumber, double amount, int companyCode) {
        StringBuilder request = new StringBuilder();
        request.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
        request.append("<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"> \r\n");
        request.append("  <soap:Body>\r\n");
        request.append("    <AddOrder xmlns=\"www.cibusnet.co.il\">\r\n");
        request.append("      <restaurantID>" + this.resId + "</restaurantID>\r\n");
        request.append("      <posID>" + this.posId + "</posID>\r\n");
        request.append("      <companyCode>" + companyCode + "</companyCode>\r\n");
        request.append("      <companyCard>" + cardNumber + "</companyCard>\r\n");
        request.append("      <price>" + this.decimal.format(amount) + "</price>\r\n");
        request.append("    </AddOrder>\r\n");
        request.append("  </soap:Body>\r\n");
        request.append("</soap:Envelope>\r\n");
        StringBuilder result = new StringBuilder();
        String resultXml = this.sendRequest(request.toString(), "AddOrder");
        if (resultXml != null && !resultXml.isEmpty()) {
            int resultCode = Utility.getIntElement((String)"AddOrderResult", (String)resultXml);
            if (resultCode == 0) {
                result.append("<RESULT>APPROVED</RESULT>\n");
                String orderId = Utility.getElement((String)"orderID", (String)resultXml);
                result.append("<TROUTD>" + orderId + "</TROUTD>\n");
                double balance = Utility.getDoubleElement((String)"budget", (String)resultXml);
                result.append("<MESSAGE>" + this.core.getLiteral("Money Card Balance") + ": " + this.decimal.format(balance) + "</MESSAGE>");
            } else {
                String errorMessage = Utility.getElement((String)"errorMessage", (String)resultXml);
                if (errorMessage != null && !errorMessage.isEmpty()) {
                    result.append("<RESULT>" + errorMessage + "</RESULT>");
                } else {
                    result.append("<RESULT>" + this.core.getLiteral("Unknown Error") + "</RESULT>\n");
                }
            }
        } else {
            result.append("<RESULT>" + this.core.getLiteral("Could not connect") + "\n\n" + this.core.getLiteral("Check connection and try again") + "</RESULT>");
        }
        return result.toString();
    }

    public String processMoneyCardVoid(String reference) {
        StringBuilder request = new StringBuilder();
        request.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
        request.append("<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"> \r\n");
        request.append("  <soap:Body>\r\n");
        request.append("    <CancelOrder xmlns=\"www.cibusnet.co.il\">\r\n");
        request.append("      <restaurantID>" + this.resId + "</restaurantID>\r\n");
        request.append("      <posID>" + this.posId + "</posID>\r\n");
        request.append("      <orderID>" + reference + "</orderID>\r\n");
        request.append("    </CancelOrder>\r\n");
        request.append("  </soap:Body>\r\n");
        request.append("</soap:Envelope>\r\n");
        StringBuilder result = new StringBuilder();
        String resultXml = this.sendRequest(request.toString(), "CancelOrder");
        if (resultXml != null && !resultXml.isEmpty()) {
            int resultCode = Utility.getIntElement((String)"CancelOrderResult", (String)resultXml);
            if (resultCode == 0) {
                result.append("<RESULT>APPROVED</RESULT>\n");
                double balance = Utility.getDoubleElement((String)"budget", (String)resultXml);
                result.append("<MESSAGE>" + this.core.getLiteral("Money Card Balance") + ": " + this.decimal.format(balance) + "</MESSAGE>");
            } else {
                String errorMessage = Utility.getElement((String)"errorMessage", (String)resultXml);
                if (errorMessage != null && !errorMessage.isEmpty()) {
                    result.append("<RESULT>" + errorMessage + "</RESULT>");
                } else {
                    result.append("<RESULT>" + this.core.getLiteral("Unknown Error") + "</RESULT>\n");
                }
            }
        } else {
            result.append("<RESULT>" + this.core.getLiteral("Could not connect") + "\n\n" + this.core.getLiteral("Check connection and try again") + "</RESULT>");
        }
        return result.toString();
    }

    public String processMoneyCardBalance(String cardNumber) {
        StringBuilder result = new StringBuilder();
        StringBuilder request = new StringBuilder();
        request.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
        request.append("<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"> \r\n");
        request.append("  <soap:Body>\r\n");
        request.append("    <QueryPolicy xmlns=\"www.cibusnet.co.il\">\r\n");
        request.append("      <restaurantID>" + this.resId + "</restaurantID>\r\n");
        request.append("      <posID>" + this.posId + "</posID>\r\n");
        request.append("      <companyCard>" + cardNumber + "</companyCard>\r\n");
        request.append("    </QueryPolicy>\r\n");
        request.append("  </soap:Body>\r\n");
        request.append("</soap:Envelope>\r\n");
        String resultXml = this.sendRequest(request.toString(), "QueryPolicyPrice");
        if (resultXml != null && !resultXml.isEmpty()) {
            int resultCode = Utility.getIntElement((String)"QueryPolicyPriceResult", (String)resultXml);
            if (resultCode == 0) {
                result.append("<RESULT>APPROVED</RESULT>\n");
                double balance = Utility.getDoubleElement((String)"approvedPrice", (String)resultXml);
                result.append("<BALANCE>" + this.decimal.format(balance) + "</BALANCE>\n");
            } else {
                String errorMessage = Utility.getElement((String)"errorMessage", (String)resultXml);
                if (errorMessage != null && !errorMessage.isEmpty()) {
                    result.append("<RESULT>" + errorMessage + "</RESULT>");
                } else {
                    result.append("<RESULT>" + this.core.getLiteral("Unknown Error") + "</RESULT>\n");
                }
            }
        } else {
            result.append("<RESULT>" + this.core.getLiteral("Could not connect") + "\n\n" + this.core.getLiteral("Check connection and try again") + "</RESULT>");
        }
        return result.toString();
    }

    private String sendRequest(String request, String transaction) {
        String result = "";
        this.waitingOnResponse = true;
        SendHttpsPost post = new SendHttpsPost(request, transaction);
        post.start();
        while (this.waitingOnResponse) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                this.core.raiseException((Exception)ex);
            }
        }
        if (this.postResponse != null) {
            result = Utility.getElement((String)(transaction + "Response"), (String)this.postResponse);
        }
        return result;
    }

    public String processMoneyCardVoid(String cardNumber, double amount) {
        return "";
    }

    public class SendHttpsPost
    extends Thread {
        String request = "";
        String transaction = "";

        public SendHttpsPost(String request, String transaction) {
            this.request = request;
            this.transaction = transaction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CibusCardHandler.this.postResponse = null;
            Object reader = null;
            Object isr = null;
            if (CibusCardHandler.this.debug) {
                System.out.println("Send to host:\r\n" + this.request);
                CibusCardHandler.this.core.debugLog("CIBUS REQUEST:\r\n" + this.request);
            }
            OutputStream ostream = null;
            InputStream istream = null;
            ByteArrayOutputStream baos = null;
            try {
                byte[] data = this.request.getBytes();
                URL theUrl = new URL(CibusCardHandler.this.hostUrl);
                URLConnection conn = theUrl.openConnection();
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setUseCaches(false);
                conn.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
                conn.setRequestProperty("Content-Length", "" + this.request.length());
                conn.setRequestProperty("SOAPAction", "www.cibusnet.co.il/" + this.transaction);
                ostream = conn.getOutputStream();
                ostream.write(data);
                ostream.flush();
                StringBuilder sb = new StringBuilder();
                byte[] b = new byte[1024];
                istream = conn.getInputStream();
                int byteRead = istream.read(b);
                while (byteRead > 0) {
                    byte[] buf = new byte[byteRead];
                    baos = new ByteArrayOutputStream();
                    baos.write(b, 0, byteRead);
                    byte[] result = baos.toByteArray();
                    sb.append(new String(result));
                    byteRead = istream.read(b);
                }
                CibusCardHandler.this.postResponse = sb.toString();
                if (CibusCardHandler.this.debug) {
                    System.out.println("Response from host:\r\n" + CibusCardHandler.this.postResponse);
                    CibusCardHandler.this.core.debugLog("CIBUS RESPONSE:\r\n" + CibusCardHandler.this.postResponse);
                }
            }
            catch (IOException e) {
                CibusCardHandler.this.core.raiseException((Exception)e);
            }
            finally {
                try {
                    if (baos != null) {
                        baos.close();
                    }
                    if (istream != null) {
                        istream.close();
                    }
                    if (ostream != null) {
                        ostream.close();
                    }
                }
                catch (Exception exception) {}
            }
            CibusCardHandler.this.waitingOnResponse = false;
        }
    }
}

