/*
 * Decompiled with CFR 0.152.
 */
package DataHandlers;

import AccuServerBase.OnlineOrdersHandlerBase;
import AccuServerBase.ServerCore;
import AccuServerBase.ServerObject;
import AccuServerBase.Utility;
import POSDataObjects.Customer;
import POSDataObjects.Item;
import POSDataObjects.ItemChoice;
import POSDataObjects.LineItem;
import POSDataObjects.Order;
import POSDataObjects.POSDataContainer;
import POSDataObjects.Tax;
import POSDataObjects.Tender;
import POSDataObjects.TenderCode;
import POSDataObjects.Till;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TenBisDataHandler
implements ServerObject,
OnlineOrdersHandlerBase {
    ServerCore core = null;
    String baseUrl = null;
    int timeOut = 10000;
    String merchantId;
    String user;
    String password;
    String till = "TenBis";
    boolean debug = false;
    boolean verbose = false;
    int retryMinutes = 5;
    Timer ordersDownloadTimer = null;
    String token = "";
    String posUser = "TenBis";
    POSDataContainer tenderCodesList = null;
    boolean autoAcceptOrders = false;

    public void initialize(ServerCore core, Hashtable parameters) {
        String retryMinutesText;
        String verboseText;
        String debugText;
        String autoAcceptOrdersText;
        this.core = core;
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            this.output(ex.toString());
        }
        this.baseUrl = "https://www.10bis.co.il/api/reshome/v2/reshomeservice.svc";
        String merchantIdText = (String)parameters.get("merchantId");
        if (merchantIdText != null && !merchantIdText.isEmpty()) {
            this.merchantId = merchantIdText;
        } else {
            merchantIdText = (String)parameters.get("MerchantId");
            if (merchantIdText != null && !merchantIdText.isEmpty()) {
                this.merchantId = merchantIdText;
            } else {
                core.input(core.getLiteral("TenBis Data Handler: MerchantId not found.\n Terminating TenBis Data Handler!"));
                return;
            }
        }
        String userText = (String)parameters.get("user");
        if (userText != null && !userText.isEmpty()) {
            this.user = userText;
        } else {
            userText = (String)parameters.get("User");
            if (userText != null && !userText.isEmpty()) {
                this.user = userText;
            } else {
                core.input(core.getLiteral("TenBis Data Handler: user not found.\n Terminating TenBis Data Handler!"));
                return;
            }
        }
        String passwordText = (String)parameters.get("password");
        if (passwordText != null && !passwordText.isEmpty()) {
            this.password = passwordText;
        } else {
            passwordText = (String)parameters.get("Password");
            if (passwordText != null && !passwordText.isEmpty()) {
                this.password = passwordText;
            } else {
                core.input(core.getLiteral("TenBis Data Handler: password not found.\n Terminating TenBis Data Handler!"));
                return;
            }
        }
        String timeOutText = (String)parameters.get("TimeOut");
        if (timeOutText != null && !timeOutText.isEmpty()) {
            try {
                this.timeOut = Integer.parseInt(timeOutText);
            }
            catch (NumberFormatException numberFormatException) {
                this.timeOut = 10000;
            }
        }
        if ((autoAcceptOrdersText = (String)parameters.get("AutoAcceptOrders")) != null && !autoAcceptOrdersText.isEmpty()) {
            try {
                this.autoAcceptOrders = Boolean.parseBoolean(autoAcceptOrdersText);
            }
            catch (Exception e) {
                this.autoAcceptOrders = false;
            }
        }
        if ((debugText = (String)parameters.get("Debug")) != null && !debugText.isEmpty()) {
            try {
                this.debug = Boolean.parseBoolean(debugText);
            }
            catch (Exception e) {
                this.debug = false;
            }
        }
        if ((verboseText = (String)parameters.get("Verbose")) != null && !verboseText.isEmpty()) {
            try {
                this.verbose = Boolean.parseBoolean(verboseText);
            }
            catch (Exception e) {
                this.verbose = false;
            }
        }
        if ((retryMinutesText = (String)parameters.get("RetryMinutes")) != null && !retryMinutesText.isEmpty()) {
            try {
                this.retryMinutes = Integer.parseInt(retryMinutesText);
            }
            catch (Exception e) {
                this.retryMinutes = 5;
            }
        }
        core.input(core.getLiteral("TenBis Data Handler Retry set to ") + this.retryMinutes + " " + core.getLiteral("minutes"));
        String tillText = (String)parameters.get("Till");
        if (tillText != null && !tillText.isEmpty()) {
            this.till = tillText;
        }
        this.getToken();
        this.ordersDownloadTimer = new Timer();
        this.retryMinutes = this.retryMinutes * 60 * 1000;
        this.ordersDownloadTimer.schedule((TimerTask)new OrdersDownloadTimer(), 10000L, (long)this.retryMinutes);
        core.setTenBisDataHandler((OnlineOrdersHandlerBase)this);
        core.input(core.getLiteral("TenBis Data Handler Successfully Started"));
    }

    private boolean isHandlerDataExists() {
        boolean success = this.core.getUser(this.posUser) != null;
        success = success && this.core.getTenderCode("TB") != null;
        Till tenBisTill = this.core.getTillByName(this.till);
        success = success && tenBisTill != null && tenBisTill.name.equals(this.till);
        success = success && this.core.getItemByCode("UndefinedChoice") != null;
        success = success && this.core.getItemByCode("Undefined") != null;
        success = success && this.core.getItemByCode("Delivery") != null;
        return success;
    }

    private boolean isResponseOk(JSONObject responseJson, long requestId) {
        boolean success;
        boolean returnValue = true;
        String requestIdString = String.valueOf(requestId);
        String responseRequestId = "";
        try {
            if (responseJson.has("RequestId")) {
                responseRequestId = responseJson.getString("RequestId");
            } else if (responseJson.has("requestId")) {
                responseRequestId = responseJson.getString("requestId");
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (!responseRequestId.equals(requestIdString)) {
            this.core.input("Error Requesting TenBis. RequestId: " + requestId + " responseRequestId: " + responseRequestId);
            returnValue = false;
        }
        if (!(success = responseJson.optBoolean("Success"))) {
            JSONObject errors = null;
            try {
                errors = responseJson.getJSONArray("Errors").getJSONObject(0);
                this.core.input("Error Requesting TenBis Open Orders.");
                this.core.input(errors.getString("ErrorCode") + " : " + errors.getString("ErrorDesc"));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            returnValue = false;
        }
        return returnValue;
    }

    public void orderNotice(String string) {
    }

    public void output(String output) {
        System.out.println(output);
        if (this.debug) {
            this.core.input(output);
        }
    }

    public String fixQuotes(String requestString) {
        String editedString = requestString.replaceAll("\"", "\\\\\"");
        return editedString;
    }

    private void getToken() {
        block3: {
            long requestId = new Date().getTime();
            String url = this.baseUrl + "/login/" + this.user + "/" + this.password + "/" + this.merchantId + "/" + requestId;
            this.core.input("getting TenBis token");
            this.core.input("url: " + url);
            try {
                String response = this.sendHttpsRequest(url, 30000, "GET", null);
                JSONObject responseJson = new JSONObject(response);
                if (responseJson.has("Data")) {
                    JSONObject data = responseJson.getJSONObject("Data");
                    this.token = data.getString("Token");
                    this.core.input("TenBis Token: " + this.token);
                }
            }
            catch (Exception e) {
                this.core.input("Error Requesting TenBis Token");
                if (!this.debug) break block3;
                this.output(e.toString());
            }
        }
    }

    public void getOpenOrders() {
        block14: {
            long requestId = new Date().getTime();
            String url = this.baseUrl + "/GetTodaysOrders/" + this.token + "/Pending/" + requestId;
            String responseData = "";
            try {
                responseData = this.sendHttpsRequest(url, 30000, "GET", null);
                JSONObject responseJson = new JSONObject(responseData);
                this.output("TenBis Get Open Orders Response Data: " + responseData);
                boolean success = this.isResponseOk(responseJson, requestId);
                if (!success) {
                    return;
                }
            }
            catch (Exception e) {
                this.core.input("Error Requesting TenBis Open Orders");
                this.core.input("Exception:" + e.toString() + " " + responseData);
                return;
            }
            try {
                Vector<TenBisOrder> orderIdsList = new Vector<TenBisOrder>();
                JSONArray dataJsonArray = new JSONObject(responseData).getJSONArray("Data");
                int dataLen = dataJsonArray.length();
                for (int i = 0; i < dataLen; ++i) {
                    long orderIdLong = dataJsonArray.getJSONObject(i).getLong("OrderID");
                    long poolIdLong = dataJsonArray.getJSONObject(i).getLong("PoolID");
                    if (orderIdLong > 0L) {
                        String orderId = String.valueOf(orderIdLong);
                        orderIdsList.add(new TenBisOrder(orderId, false));
                        continue;
                    }
                    if (poolIdLong <= 0L) continue;
                    String poolId = String.valueOf(poolIdLong);
                    orderIdsList.add(new TenBisOrder(poolId, true));
                }
                int numRemoteOrders = orderIdsList.size();
                if (numRemoteOrders <= 0) break block14;
                for (int n = 0; n < numRemoteOrders; ++n) {
                    boolean success;
                    TenBisOrder thisTenBisOrder = (TenBisOrder)orderIdsList.get(n);
                    String thisOrderId = thisTenBisOrder.orderId;
                    try {
                        requestId = new Date().getTime();
                        url = thisTenBisOrder.isPoolOrder ? this.baseUrl + "/GetPoolOrder/" + thisOrderId + "/" + this.token + "/" + requestId + "/" : this.baseUrl + "/GetSingleOrder/" + thisOrderId + "/" + this.token + "/" + requestId;
                        responseData = this.sendHttpsRequest(url, 30000, "GET", null);
                    }
                    catch (Exception ex) {
                        this.core.input("Error Requesting TenBis Order No. " + thisOrderId);
                        this.core.input("Exception:" + ex.toString() + " " + responseData);
                        continue;
                    }
                    JSONObject responseJson = new JSONObject(responseData);
                    if (this.debug) {
                        this.output("TenBis Get Open Orders Response Data: " + responseData);
                    }
                    if (!(success = this.isResponseOk(responseJson, requestId))) continue;
                    JSONObject data = responseJson.getJSONObject("Data");
                    String poolOrderPhone = data.optString("PoolOrderPhone");
                    JSONArray orders = new JSONArray();
                    if (thisTenBisOrder.isPoolOrder) {
                        orders = data.getJSONArray("Orders");
                    } else {
                        orders.put((Object)data);
                    }
                    int ordersLen = orders.length();
                    for (int orderSequence = 0; orderSequence < ordersLen; ++orderSequence) {
                        JSONObject orderData = (JSONObject)orders.get(orderSequence);
                        this.createNewOrder(orderData, ordersLen, orderSequence, thisTenBisOrder, poolOrderPhone);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.output("TenBis Get Open Orders Completed");
    }

    public void createNewOrder(JSONObject orderData, int ordersLen, int orderSequence, TenBisOrder thisTenBisOrder, String poolOrderPhone) {
        block70: {
            try {
                Date createdDate;
                JSONObject thisRemoteOrder = orderData.getJSONObject("Order");
                String thisOrderId = String.valueOf(thisRemoteOrder.getLong("OrderId"));
                if (thisTenBisOrder.isPoolOrder) {
                    String orderNumOutOf = orderSequence + 1 + "/" + ordersLen;
                    if (thisTenBisOrder.isPoolOrder) {
                        thisOrderId = orderNumOutOf + " | " + thisOrderId;
                    }
                }
                if (this.orderExists(thisOrderId)) {
                    this.output("Remote Order: " + thisOrderId + " - has already been imported\r\n");
                    return;
                }
                JSONArray items = thisRemoteOrder.getJSONArray("dishList");
                JSONObject times = thisRemoteOrder.getJSONObject("Times");
                String deliveryNotes = "";
                if (thisRemoteOrder.has("OrderRemarks")) {
                    deliveryNotes = thisRemoteOrder.getString("OrderRemarks");
                    deliveryNotes = deliveryNotes.replace("\n", " ");
                }
                JSONObject enteredTimeJson = times.getJSONObject("entered");
                JSONObject customerJSON = thisRemoteOrder.getJSONObject("user");
                JSONObject companyJSON = thisRemoteOrder.getJSONObject("company");
                int deliveryType = thisRemoteOrder.getInt("DeliveryMethod");
                JSONObject deliveryAddressJSON = null;
                if (thisRemoteOrder.has("address")) {
                    deliveryAddressJSON = thisRemoteOrder.getJSONObject("address");
                }
                JSONObject billingInfo = thisRemoteOrder.getJSONObject("BillingInfo");
                if (this.debug) {
                    this.output("Processing Remote Order: " + thisOrderId + "\r\n");
                }
                int nextLineNumber = 1;
                Order newOrder = new Order();
                newOrder.orderId = thisOrderId;
                String createdString = enteredTimeJson.getString("localDateTime");
                SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                try {
                    createdDate = df.parse(createdString);
                }
                catch (ParseException ex) {
                    createdDate = new Date();
                }
                newOrder.created = new Timestamp(createdDate.getTime());
                newOrder.nextLineNumber = nextLineNumber;
                if (deliveryType == 1) {
                    newOrder.delivery = true;
                    newOrder.carryOut = false;
                } else {
                    newOrder.delivery = false;
                    newOrder.carryOut = true;
                }
                newOrder.displayOnRemote = true;
                Customer remoteOrderCustomer = null;
                if (customerJSON != null) {
                    remoteOrderCustomer = new Customer();
                    String firstName = this.optString(customerJSON, "FirstName");
                    String lastName = this.optString(customerJSON, "LastName");
                    String email = this.optString(customerJSON, "Email");
                    String phone = this.optString(customerJSON, "CellPhone");
                    String companyName = this.optString(customerJSON, "CompanyName");
                    if (companyJSON != null && thisTenBisOrder.isPoolOrder) {
                        companyName = companyJSON.optString("Name");
                    }
                    remoteOrderCustomer.first = companyName + " " + firstName;
                    remoteOrderCustomer.companyName = companyName;
                    remoteOrderCustomer.last = lastName;
                    remoteOrderCustomer.email = email;
                    remoteOrderCustomer.phone = thisTenBisOrder.isPoolOrder && !poolOrderPhone.isEmpty() ? poolOrderPhone : phone;
                    remoteOrderCustomer.code = customerJSON.getLong("ID") + "";
                }
                if (deliveryAddressJSON != null) {
                    if (remoteOrderCustomer == null) {
                        remoteOrderCustomer = new Customer();
                    }
                    String city = "";
                    if (deliveryAddressJSON.has("CityName")) {
                        city = deliveryAddressJSON.getString("CityName");
                    }
                    String address1 = "";
                    String street = "";
                    if (deliveryAddressJSON.has("StreetName")) {
                        address1 = street = deliveryAddressJSON.getString("StreetName");
                    }
                    String number = "";
                    if (deliveryAddressJSON.has("HouseNumber")) {
                        number = deliveryAddressJSON.getString("HouseNumber");
                        address1 = street + " " + number;
                    }
                    String postalCode = "";
                    if (deliveryAddressJSON.has("ZipCode")) {
                        postalCode = deliveryAddressJSON.getString("ZipCode");
                    }
                    String address2 = "";
                    String apt = "";
                    if (deliveryAddressJSON.has("ApartementNumber")) {
                        apt = deliveryAddressJSON.getString("ApartementNumber");
                        address2 = address2 + this.core.getLiteral("Apt") + " " + apt;
                    }
                    String floor = "";
                    if (deliveryAddressJSON.has("Floor")) {
                        floor = deliveryAddressJSON.getString("Floor");
                        address2 = address2 + " - " + this.core.getLiteral("Floor") + " " + floor;
                    }
                    String entrance = "";
                    if (deliveryAddressJSON.has("Enterance")) {
                        entrance = deliveryAddressJSON.getString("Enterance");
                        address2 = address2 + " - " + this.core.getLiteral("Entrance") + " " + entrance;
                    }
                    String remarks = "";
                    if (deliveryAddressJSON.has("Remarks")) {
                        remarks = deliveryAddressJSON.getString("Remarks");
                    }
                    remoteOrderCustomer.address1 = address1;
                    remoteOrderCustomer.address2 = address2;
                    remoteOrderCustomer.city = city;
                    remoteOrderCustomer.zip = postalCode;
                    remoteOrderCustomer.deliveryNotes = deliveryNotes + "\r\n" + remarks;
                }
                if (remoteOrderCustomer != null) {
                    boolean saved = false;
                    if (remoteOrderCustomer.code != null && !remoteOrderCustomer.code.isEmpty()) {
                        saved = this.core.updateCustomer(remoteOrderCustomer);
                    }
                    if (saved) {
                        newOrder.customer = remoteOrderCustomer;
                    }
                }
                Vector<Object> newLineItems = new Vector<Object>();
                int numLines = 0;
                if (items != null && items.length() > 0) {
                    numLines = items.length();
                    for (int i = 0; i < numLines; ++i) {
                        ItemChoice newItemChoice;
                        String taxCode;
                        Item thisItem;
                        JSONObject thisLine = items.getJSONObject(i);
                        String itemId = "";
                        try {
                            itemId = thisLine.getString("CatalogId");
                            this.core.input(thisOrderId + " | " + itemId + " | " + thisLine.getDouble("DishPrice"));
                        }
                        catch (Exception ex) {
                            this.output(this.core.getLiteral("Error Importing TenBis Open Order - #") + thisOrderId + " " + this.core.getLiteral("Item Id not received - Setting to Undefined"));
                            itemId = "Undefined";
                        }
                        String description = thisLine.getString("DishName");
                        double price = thisLine.getDouble("DishPrice");
                        double qty = thisLine.getDouble("Quantity");
                        boolean discountable = thisLine.optBoolean("discountable");
                        String itemForName = "";
                        String itemKitchenNotes = "";
                        if (thisLine.has("DishNotes") && !thisLine.isNull("DishNotes")) {
                            String linecomment = thisLine.optString("DishNotes");
                            String[] temp = new String[2];
                            temp = linecomment.split("\r\n");
                            if (temp != null) {
                                if (temp.length == 2) {
                                    itemKitchenNotes = temp[0];
                                    itemForName = temp[1];
                                } else {
                                    itemForName = temp[0];
                                }
                            }
                        }
                        if ((thisItem = this.core.getItemByCode(itemId)) == null) {
                            this.output(this.core.getLiteral("Error Importing TenBis Open Order - #") + thisOrderId + " " + this.core.getLiteral("Item Id") + " " + itemId + " " + this.core.getLiteral("not found - Setting to Undefined"));
                            thisItem = this.core.getItemByCode("Undefined");
                            if (thisItem == null) {
                                this.output("Error Importing TenBis Open Order - #" + thisOrderId + " Item: " + itemId + " not found");
                                continue;
                            }
                            itemId = "Undefined";
                        }
                        if ((taxCode = this.core.getCarryOutTaxCode()) == null || taxCode.isEmpty()) {
                            taxCode = thisItem.vatCode;
                        }
                        double priceWithVatRemoved = this.core.getPriceWithVatRemoved(price, taxCode);
                        LineItem newLineItem = new LineItem();
                        newLineItem.itemId = itemId;
                        newLineItem.itemDescription = description;
                        newLineItem.price = price;
                        newLineItem.quantity = qty;
                        newLineItem.noDiscount = discountable;
                        newLineItem.displayOnRemote = true;
                        newLineItem.altDescription = thisItem.alternateDescription;
                        newLineItem.list = thisItem.list;
                        newLineItem.originalPrice = thisItem.price;
                        if (newLineItem.tax == null) {
                            newLineItem.tax = new Tax();
                        }
                        newLineItem.tax.taxable = thisItem.taxable;
                        newLineItem.taxable = thisItem.taxable;
                        newLineItem.isAppetizer = thisItem.isAppetizer;
                        newLineItem.itemType = thisItem.type;
                        newLineItem.noPartialQuantity = thisItem.noPartialQuantity;
                        newLineItem.carryOut = !newOrder.delivery;
                        newLineItem.userId = this.posUser;
                        newLineItem.total = newLineItem.quantity * priceWithVatRemoved;
                        newLineItem.vatGross = newLineItem.quantity * price;
                        newLineItem.vatTax1 = (double)Math.round((newLineItem.vatGross - priceWithVatRemoved * Math.abs(newLineItem.quantity)) * 1000.0) / 1000.0;
                        newLineItem.created = new Date().getTime() + (long)newOrder.nextLineNumber;
                        ++newOrder.nextLineNumber;
                        newLineItem.changedPrice = "TenBis";
                        newLineItem.till = this.till;
                        JSONArray choices = thisLine.getJSONArray("Choices");
                        Vector<ItemChoice> newChoices = new Vector<ItemChoice>();
                        if (itemForName != null && !itemForName.isEmpty()) {
                            newItemChoice = new ItemChoice();
                            newItemChoice.text = itemForName;
                            newChoices.add(newItemChoice);
                        }
                        if (itemKitchenNotes != null && !itemKitchenNotes.isEmpty()) {
                            newItemChoice = new ItemChoice();
                            newItemChoice.text = itemKitchenNotes;
                            newChoices.add(newItemChoice);
                        }
                        Vector<LineItem> newOptionalItems = new Vector<LineItem>();
                        if (choices != null && choices.length() > 0) {
                            int numChoices = choices.length();
                            for (int c = 0; c < numChoices; ++c) {
                                JSONObject thisChoice = choices.getJSONObject(c);
                                JSONArray theseChoiceItems = thisChoice.getJSONArray("SubsChosen");
                                int theseChoiceItemsLen = theseChoiceItems.length();
                                for (int ch = 0; ch < theseChoiceItemsLen; ++ch) {
                                    ItemChoice newItemChoice2;
                                    JSONObject thisChoiceItem = theseChoiceItems.getJSONObject(ch);
                                    String thisChoiceId = "";
                                    try {
                                        thisChoiceId = thisChoiceItem.getString("CatalogId");
                                    }
                                    catch (Exception ex) {
                                        this.output(this.core.getLiteral("Error Importing TenBis Open Order - #") + thisOrderId + " " + this.core.getLiteral("Choice Item Id not received - Setting to UndefinedChoice"));
                                        thisChoiceId = "UndefinedChoice";
                                    }
                                    String thisChoiceDescription = thisChoiceItem.getString("Name");
                                    double thisChoicePrice = thisChoiceItem.getDouble("Price");
                                    String catalogId = thisChoiceItem.getString("CatalogId");
                                    if (catalogId.contains("Null")) {
                                        newItemChoice2 = new ItemChoice();
                                        newItemChoice2.itemCode = thisChoiceId;
                                        newItemChoice2.display = thisChoiceDescription;
                                        newItemChoice2.text = thisChoiceDescription;
                                        newItemChoice2.cr = true;
                                        newChoices.add(newItemChoice2);
                                        continue;
                                    }
                                    newItemChoice2 = new ItemChoice();
                                    newItemChoice2.itemCode = "";
                                    newItemChoice2.display = thisChoiceDescription;
                                    newItemChoice2.text = thisChoiceDescription;
                                    newItemChoice2.cr = true;
                                    newChoices.add(newItemChoice2);
                                    LineItem newOptionalItem = new LineItem();
                                    Item thisOptionalItem = this.core.getItemByCode(thisChoiceId);
                                    if (thisOptionalItem == null) {
                                        this.output(this.core.getLiteral("Error Importing TenBis Open Order - #") + thisOrderId + " " + this.core.getLiteral("Choice Item Id") + " " + thisChoiceId + " " + this.core.getLiteral("not found - Setting to UndefinedChoice"));
                                        thisOptionalItem = this.core.getItemByCode("UndefinedChoice");
                                        if (thisOptionalItem == null) {
                                            this.output("Error Importing TenBis Open Order - #" + thisOrderId + " Optional Item: " + thisChoiceId + " not found");
                                            continue;
                                        }
                                        thisChoiceId = "UndefinedChoice";
                                    }
                                    if ((taxCode = this.core.getCarryOutTaxCode()) == null || taxCode.isEmpty()) {
                                        taxCode = thisOptionalItem.vatCode;
                                    }
                                    double optionalItemPriceWithVatRemoved = this.core.getPriceWithVatRemoved(thisChoicePrice, taxCode);
                                    newOptionalItem.itemId = thisChoiceId;
                                    newOptionalItem.itemDescription = thisChoiceDescription;
                                    newOptionalItem.price = thisChoicePrice;
                                    newOptionalItem.quantity = qty;
                                    newOptionalItem.noDiscount = false;
                                    newOptionalItem.doNotPrint = true;
                                    newOptionalItem.altDescription = thisOptionalItem.alternateDescription;
                                    newOptionalItem.list = thisOptionalItem.list;
                                    newOptionalItem.originalPrice = thisOptionalItem.price;
                                    if (newOptionalItem.tax == null) {
                                        newOptionalItem.tax = new Tax();
                                    }
                                    newOptionalItem.tax.taxable = thisOptionalItem.taxable;
                                    newOptionalItem.taxable = thisOptionalItem.taxable;
                                    newOptionalItem.isAppetizer = thisOptionalItem.isAppetizer;
                                    newOptionalItem.itemType = thisOptionalItem.type;
                                    newOptionalItem.noPartialQuantity = thisOptionalItem.noPartialQuantity;
                                    newOptionalItem.carryOut = !newOrder.delivery;
                                    newOptionalItem.userId = this.posUser;
                                    newOptionalItem.total = newOptionalItem.quantity * optionalItemPriceWithVatRemoved;
                                    newOptionalItem.vatGross = newOptionalItem.quantity * thisChoicePrice;
                                    newOptionalItem.vatTax1 = (double)Math.round((newOptionalItem.vatGross - optionalItemPriceWithVatRemoved * Math.abs(newOptionalItem.quantity)) * 1000.0) / 1000.0;
                                    newOptionalItem.created = new Date().getTime() + (long)newOrder.nextLineNumber;
                                    ++newOrder.nextLineNumber;
                                    newOptionalItem.changedPrice = "TenBis";
                                    newOptionalItem.till = this.till;
                                    newOptionalItems.add(newOptionalItem);
                                }
                            }
                        }
                        newLineItem.choices = newChoices;
                        newLineItems.add(newLineItem);
                        if (newOptionalItems == null || newOptionalItems.isEmpty()) continue;
                        newLineItems.addAll(newOptionalItems);
                    }
                }
                String resultXml = "";
                JSONArray billingLines = billingInfo.getJSONArray("BillingLines");
                int numTenders = billingLines.length();
                double tipAmount = 0.0;
                if (billingLines != null && numTenders > 0) {
                    for (int i = 0; i < numTenders; ++i) {
                        JSONObject thisBillingLine = billingLines.getJSONObject(i);
                        int billingType = thisBillingLine.getInt("Type");
                        double amount = thisBillingLine.getDouble("Amount");
                        if (billingType == 0) {
                            tipAmount = amount;
                            continue;
                        }
                        if (billingType != 3) continue;
                        String chargeItemId = "Delivery";
                        Item thisChargeItem = this.core.getItemByCode(chargeItemId);
                        if (thisChargeItem == null) {
                            this.output("Error Importing TenBis Open Order - #" + thisOrderId + " Item: Delivery not found");
                            thisChargeItem = this.core.getItemByCode("Undefined");
                            if (thisChargeItem == null) {
                                this.output("Error Importing TenBis Open Order - #" + thisOrderId + " Item: Undefined not found");
                            }
                        }
                        LineItem newChargeLineItem = new LineItem();
                        newChargeLineItem.itemId = thisChargeItem.code;
                        String taxCode = this.core.getCarryOutTaxCode();
                        if (taxCode == null || taxCode.isEmpty()) {
                            taxCode = thisChargeItem.vatCode;
                        }
                        double chargeItemPriceWithVatRemoved = this.core.getPriceWithVatRemoved(amount, taxCode);
                        newChargeLineItem.itemDescription = "";
                        newChargeLineItem.price = amount;
                        newChargeLineItem.quantity = 1.0;
                        newChargeLineItem.noDiscount = true;
                        newChargeLineItem.displayOnRemote = true;
                        newChargeLineItem.altDescription = thisChargeItem.alternateDescription;
                        newChargeLineItem.list = thisChargeItem.list;
                        newChargeLineItem.originalPrice = thisChargeItem.price;
                        if (newChargeLineItem.tax == null) {
                            newChargeLineItem.tax = new Tax();
                        }
                        newChargeLineItem.tax.taxable = thisChargeItem.taxable;
                        newChargeLineItem.taxable = thisChargeItem.taxable;
                        newChargeLineItem.isAppetizer = thisChargeItem.isAppetizer;
                        newChargeLineItem.itemType = thisChargeItem.type;
                        newChargeLineItem.noPartialQuantity = thisChargeItem.noPartialQuantity;
                        newChargeLineItem.carryOut = !newOrder.delivery;
                        newChargeLineItem.userId = this.posUser;
                        newChargeLineItem.total = newChargeLineItem.quantity * chargeItemPriceWithVatRemoved;
                        newChargeLineItem.vatGross = newChargeLineItem.quantity * amount;
                        newChargeLineItem.vatTax1 = (double)Math.round((newChargeLineItem.vatGross - chargeItemPriceWithVatRemoved * Math.abs(newChargeLineItem.quantity)) * 1000.0) / 1000.0;
                        newChargeLineItem.created = new Date().getTime() + (long)newOrder.nextLineNumber;
                        ++newOrder.nextLineNumber;
                        newChargeLineItem.changedPrice = "TenBis";
                        newLineItems.add(newChargeLineItem);
                    }
                }
                JSONArray discountBillingLines = billingInfo.getJSONArray("DiscountBillingLines");
                int discountBillingLinesLen = discountBillingLines.length();
                for (int i = 0; i < discountBillingLinesLen; ++i) {
                    JSONObject discountLine = discountBillingLines.getJSONObject(i);
                    double amount = discountLine.getDouble("Amount");
                    String caption = discountLine.getString("Caption");
                    String discountItemId = "Discount";
                    Item discountItem = this.core.getItemByCode(discountItemId);
                    if (discountItem == null) {
                        this.output("Error Importing TenBis Open Order - #" + thisOrderId + " Item: Discount not found");
                        discountItem = this.core.getItemByCode("Undefined");
                        if (discountItem == null) {
                            this.output("Error Importing TenBis Open Order - #" + thisOrderId + " Item: Undefined not found");
                        }
                    }
                    LineItem newDiscountLineItem = new LineItem();
                    newDiscountLineItem.itemId = discountItem.code;
                    String taxCode = this.core.getCarryOutTaxCode();
                    if (taxCode == null || taxCode.isEmpty()) {
                        taxCode = discountItem.vatCode;
                    }
                    double chargeItemPriceWithVatRemoved = this.core.getPriceWithVatRemoved(amount, taxCode);
                    newDiscountLineItem.itemDescription = caption;
                    newDiscountLineItem.price = amount;
                    newDiscountLineItem.quantity = 1.0;
                    newDiscountLineItem.noDiscount = true;
                    newDiscountLineItem.displayOnRemote = true;
                    newDiscountLineItem.altDescription = discountItem.alternateDescription;
                    newDiscountLineItem.list = discountItem.list;
                    newDiscountLineItem.originalPrice = discountItem.price;
                    if (newDiscountLineItem.tax == null) {
                        newDiscountLineItem.tax = new Tax();
                    }
                    newDiscountLineItem.tax.taxable = discountItem.taxable;
                    newDiscountLineItem.taxable = discountItem.taxable;
                    newDiscountLineItem.isAppetizer = discountItem.isAppetizer;
                    newDiscountLineItem.itemType = discountItem.type;
                    newDiscountLineItem.noPartialQuantity = discountItem.noPartialQuantity;
                    newDiscountLineItem.carryOut = !newOrder.delivery;
                    newDiscountLineItem.userId = this.posUser;
                    newDiscountLineItem.total = newDiscountLineItem.quantity * chargeItemPriceWithVatRemoved;
                    newDiscountLineItem.vatGross = newDiscountLineItem.quantity * amount;
                    newDiscountLineItem.vatTax1 = (double)Math.round((newDiscountLineItem.vatGross - chargeItemPriceWithVatRemoved * Math.abs(newDiscountLineItem.quantity)) * 1000.0) / 1000.0;
                    newDiscountLineItem.created = new Date().getTime() + (long)newOrder.nextLineNumber;
                    ++newOrder.nextLineNumber;
                    newDiscountLineItem.changedPrice = "TenBis";
                    newLineItems.add(newDiscountLineItem);
                }
                newOrder.lineItems = newLineItems;
                newOrder.user = this.posUser;
                String savedOrderXml = this.core.saveEMVOrder(newOrder.user, this.till, newOrder.toXml());
                newOrder = new Order(savedOrderXml, true);
                JSONArray paymentInfoLines = billingInfo.getJSONArray("PaymentInfo");
                int paymentInfoLen = paymentInfoLines.length();
                for (int i = 0; i < paymentInfoLen; ++i) {
                    JSONObject paymentInfo = paymentInfoLines.getJSONObject(i);
                    int paymentMethod = paymentInfo.getInt("PaymentMethod");
                    double amount = paymentInfo.getDouble("Sum");
                    Tender newTender = new Tender();
                    newTender.amount = amount;
                    if (paymentMethod == 4) {
                        newTender.cardNumber = "";
                        newTender.description = this.core.getLiteral("TenBis");
                        newTender.approval = "";
                        newTender.newTender = true;
                        newTender.code = "TB";
                        newTender.user = this.posUser;
                        resultXml = this.core.processOtherTender("TenBis", this.till, newOrder.toXml(), newTender.code, amount, "", newOrder.created.getTime(), "");
                        continue;
                    }
                    if (paymentMethod != 3) continue;
                    this.core.saveOrder(newOrder.toXml(), "TenBis", this.till);
                }
                String orderXml = Utility.getElement((String)"Order", (String)resultXml);
                if (orderXml == null || orderXml.isEmpty()) break block70;
                Order currentOrder = new Order(orderXml, true);
                if (currentOrder != null && tipAmount > 0.0) {
                    int newTenderId = Utility.getIntElement((String)"NewTenderId", (String)resultXml);
                    int tenderLen = currentOrder.tenderings.size();
                    String thisTenderCode = "";
                    for (int i = 0; i < tenderLen; ++i) {
                        Tender thisTender = (Tender)currentOrder.tenderings.get(i);
                        if (thisTender.id != newTenderId) continue;
                        thisTenderCode = thisTender.code;
                        break;
                    }
                    Date now = new Date();
                    Tender newCashoutTender = new Tender(this.getPrimaryCashCode().code, tipAmount * -1.0);
                    newCashoutTender.status = "T";
                    newCashoutTender.origin = "PreTip";
                    newCashoutTender.user = "TenBis";
                    newCashoutTender.masterId = newTenderId;
                    now = new Date();
                    newCashoutTender.created = now.getTime() + 1L;
                    currentOrder.tenderings.add(newCashoutTender);
                    this.core.saveOrder(currentOrder.toXml(), this.posUser, this.till);
                    try {
                        Thread.currentThread();
                        Thread.sleep(3000L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.tenderAdded(currentOrder);
                if (this.autoAcceptOrders) {
                    this.core.setOnlineOrderStatus(currentOrder.orderNumber, currentOrder.orderId, this.posUser, "Accept");
                }
            }
            catch (JSONException je) {
                this.output("Error Invoicing TenBis Order (Json error) - Order Id:" + thisTenBisOrder.orderId);
                this.output(orderData.toString());
            }
        }
    }

    public void tenderAdded(Order currentOrder) {
        boolean result;
        double balance = (double)Math.round((currentOrder.total - this.getTenderTotal(currentOrder)) * 100.0) / 100.0;
        boolean hasChange = false;
        if (balance < -0.009 && currentOrder.total > 1.0E-4) {
            hasChange = true;
        }
        if ((balance > -1.0E-4 && balance < 1.0E-4 || balance < 1.0E-4 && hasChange) && !(result = this.core.invoiceOrder(currentOrder.toXml(), currentOrder.user, currentOrder.shift, "", ""))) {
            this.output("Error Invoicing TenBis Order - Order Id:" + currentOrder.orderId);
        }
    }

    public TenderCode getPrimaryCashCode() {
        if (this.tenderCodesList == null) {
            this.tenderCodesList = this.core.getTenderCodesList();
        }
        TenderCode result = null;
        if (this.tenderCodesList != null) {
            int len = this.tenderCodesList.size();
            for (int i = 0; i < len; ++i) {
                TenderCode thisCode = (TenderCode)this.tenderCodesList.get(i);
                if (thisCode.tenderType.compareToIgnoreCase("P") != 0) continue;
                result = thisCode;
            }
        }
        return result;
    }

    public double getTenderTotal(Order currentOrder) {
        double result = 0.0;
        if (currentOrder != null && currentOrder.tenderings != null) {
            int len = currentOrder.tenderings.size();
            for (int i = 0; i < len; ++i) {
                Tender thisTender = (Tender)currentOrder.tenderings.get(i);
                result += thisTender.amount;
            }
        }
        return result;
    }

    public boolean setOrderStatus(int statusCode, String orderId) {
        boolean isPoolOrder = orderId.contains("|");
        String reply = "";
        long requestId = new Date().getTime();
        String url = "";
        String payload = "{ \"EstimatedTimeToArrival\": 0 }";
        boolean success = false;
        String statusString = "";
        if (statusCode == 2) {
            statusString = "InProcess";
        }
        if (!isPoolOrder) {
            url = this.baseUrl + "/ChangeStandardOrderStatusAndSetMetadata/" + orderId + "/" + statusString + "/" + this.token + "/" + requestId;
        } else {
            url = this.baseUrl + "/ChangePooledOrderStatus/" + orderId + "/" + statusString + "/" + this.token + "/" + requestId;
            payload = "";
        }
        String responseData = "";
        try {
            responseData = this.sendHttpsRequest(url, this.timeOut, "POST", payload);
            if (this.debug) {
                this.output("TenBis Set Order Status Get Data: " + url);
                this.output("TenBis Set Order Status Response Data: " + responseData);
            }
            JSONObject responseJson = new JSONObject(responseData);
            success = this.isResponseOk(responseJson, requestId);
        }
        catch (Exception e) {
            this.core.input("TenBis - Error during Set Order Status for Order # " + orderId);
            responseData = "<Result>ERROR</Result><ErrorMessage>Error during Set Order Status</ErrorMessage>";
        }
        String result = Utility.getJSONString((String)responseData, (String)"Result");
        if (result != null && !result.isEmpty() && result.compareTo("0") != 0) {
            this.core.input("TenBis - Error during Set Order Status for Order # " + orderId);
        }
        return success;
    }

    public boolean orderExists(String orderId) {
        boolean exists = true;
        Vector openOrders = this.core.getOrdersByOrderId(orderId);
        if (openOrders != null && openOrders.isEmpty()) {
            exists = false;
        }
        return exists;
    }

    private String optString(JSONObject json, String key) {
        String value = "";
        try {
            if (!json.isNull(key)) {
                value = json.getString(key);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return value;
    }

    public String sendHttpsRequest(String url, int timeout, String method, String payload) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        if (this.verbose) {
            System.out.println("URL: " + url);
        }
        if (!url.contains("login") && this.token.isEmpty()) {
            this.getToken();
        }
        OutputStream ostream = null;
        BufferedReader istream = null;
        ByteArrayOutputStream baos = null;
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, null, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            URL theUrl = new URL(url);
            System.out.println("Attempting to connect ");
            HttpsURLConnection conn = (HttpsURLConnection)theUrl.openConnection();
            System.out.println("Connected ");
            conn.setReadTimeout(timeout);
            conn.setConnectTimeout(timeout);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod(method);
            conn.setRequestProperty("accept", "application/json");
            if (payload != null) {
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", "text/json; charset=utf-8");
                OutputStream os = conn.getOutputStream();
                os.write(payload.toString().getBytes("UTF-8"));
                os.close();
            }
            istream = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            StringBuilder replyText = new StringBuilder();
            do {
                String reply = istream.readLine();
                replyText.append(reply);
            } while (istream.ready());
            String sResult = replyText.toString();
            if (this.verbose) {
                System.out.println("Receive from host:\r\n" + sResult);
            }
            String string = sResult;
            return string;
        }
        catch (NoSuchAlgorithmException ex) {
            throw ex;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (istream != null) {
                    istream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ostream != null) {
                    ostream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String getRemoteOrderId(String orderId) {
        String remoteOrderId = orderId.contains("|") ? orderId.substring(orderId.indexOf("|") + 2, orderId.length()) : orderId;
        return remoteOrderId;
    }

    class TenBisOrder {
        public String orderId;
        public boolean isPoolOrder;

        public TenBisOrder(String orderId, boolean isPoolOrder) {
            this.orderId = orderId;
            this.isPoolOrder = isPoolOrder;
        }
    }

    class OrdersDownloadTimer
    extends TimerTask {
        OrdersDownloadTimer() {
        }

        @Override
        public void run() {
            if (!TenBisDataHandler.this.core.isBlockLogin()) {
                TenBisDataHandler.this.getOpenOrders();
            }
        }
    }
}

