var AdvancedSettingsView = Backbone.View.extend({
    breadcrumb: {},

    events: {
        'click #auditCard': 'openAuditModal',
        'click #cancelAuditModal': 'closeAuditModal',
        'click #saveAuditModal': 'saveAuditModal'
    },

    initialize: function (options) {
        this.options = options;
        this.template = _.template(options.template);
        this.breadcrumb = options.breadcrumb;
    },

    render: function () {        
        var that = this;
        this.$el.html(this.template());
        App.breadCrumbToolTip = "Further setup your POS";
        App.setBreadcrumbs(this.breadcrumb);
        $('.tooltipped').tooltip({delay: 0});
        return this;
    },

    openAuditModal: function () {
        var pickerElement = document.querySelectorAll('.datepicker');
        var instances = M.Datepicker.init(pickerElement, {
            autoClose: true,
            container: 'body'
        });
        var auditModal = $('#audit-modal').modal();
        auditModal.modal('open');
    },

    closeAuditModal: function() {
        var auditModal = $('#audit-modal').modal();
        auditModal.modal('close');
    },

    saveAuditModal: async function() {
        var that = this;
        var startDay = document.getElementById("startDay").value;
        var endDay =document.getElementById("endDay").value;

        if (startDay != "" && endDay != "") {
            var d = new Date(startDay),
            month = '' + (d.getMonth() + 1),
            day = '' + d.getDate(),
            year = d.getFullYear();
            if (month.length < 2) month = '0' + month;
            if (day.length < 2) day = '0' + day;
        
            startDay = [year, month, day].join('-');

            var d = new Date(endDay),
            month = '' + (d.getMonth() + 1),
            day = '' + d.getDate(),
            year = d.getFullYear();
            if (month.length < 2) month = '0' + month;
            if (day.length < 2) day = '0' + day;
            endDay = [year, month, day].join('-');

            startDay = startDay + ' 00:00:01.0';
            endDay = endDay + ' 23:59:59.0';

            await this.getCookie();
            var sessionToken = this.getCookie();
           
            M.toast({ html: '{Literal}Creating Audit Data, your download will begin shortly{/Literal}' });
            $.ajax({
                url: '/data/create-audit-data',
                data: {
                    token: sessionToken,
                    startDay: startDay,
                    endDay: endDay
                },
                dataType: 'json',
                type: 'POST',

                success: function (data) {
                    that.download("AuditFile.html", data.auditData)
                    $('#audit-modal').hide();
                    var auditModal = $('#audit-modal').modal();
                    auditModal.modal('close');
                },

                error: function (e) {
                    if (e.status == 523) {
                        window.location.href = "#/log-in";
                        location.reload();
                    }
                    else if (e.responseJSON.hasAccess == false) {
                        M.toast({ html: '{Literal}An error has occured{/Literal}' });
                    }
                }
            });
        }
        else {
            M.toast({ html: '{Literal}Both fields are required{/Literal}' });
        }
    },

    getCookie: function () {
        var nameEQ = "sessionCookie" + "=";
        var ca = document.cookie.split(';');
        for(var i=0;i < ca.length;i++) {
            var c = ca[i];
            while (c.charAt(0)==' ') c = c.substring(1,c.length);
            if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
        }
    },

    download: function (filename, text) {
        var element = document.createElement('a');
        element.setAttribute('href', 'data:text/plain;charset=utf-8,' + encodeURIComponent(text));
        element.setAttribute('download', filename);

        element.style.display = 'none';
        document.body.appendChild(element);

        element.click();

        document.body.removeChild(element);
    }
});
