var TenderTypesFormView = Backbone.View.extend({
    events: {
        'change #tenderTypesName': 'updateName'
    },

    

    initialize: function (options) {
        this.options = options;
        this.template = _.template(options.template);
        this.model = options.model;
        this.tenderTypes = options.tenderTypes;
        
        this.paymentTypes = Object.keys(options.paymentTypes).map(function (key) {
            return {
                id: key,
                name: options.paymentTypes[key]
            };
        });

        this.paymentTypes.sort(function (a, b) {
            return a.name.toLowerCase() < b.name.toLowerCase() ? -1 : (a.name.toLowerCase() > b.name.toLowerCase() ? 1 : 0);
        });
    },

    render: function () {
        var that = this;
        this.$el.detach();

        this.$el.html(this.template({
            tenderTypes: this.model.toJSON(),
            paymentTypes: this.paymentTypes
        }));

        $(document).ready(function() {
            $('.tooltipped').tooltip();
            if (that.model.attributes.paymentType == "D" || that.model.attributes.paymentType == "B") {
                $('#cardTypeField').show();
            }
            else if (that.model.attributes.paymentType == "N") {
                $('#conversionRateField').show();
            }
        });
        return this;
    },

    updateName: function (e) {
        var element = $(e.currentTarget);
        var name = $(element).val();
        this.model.set('tenderName', name);
    }
});