precision highp float;

attribute vec4 p0, p1, p2, p3,
               p4, p5, p6, p7,
               p8, p9, pa, pb,
               pc, pd, pe;

attribute vec4 pf;

uniform mat4 dim1A, dim2A, dim1B, dim2B, dim1C, dim2C, dim1D, dim2D;

uniform vec2 resolution,
             viewBoxPosition,
             viewBoxSize;

uniform sampler2D palette;

uniform vec2 colorClamp;

varying vec4 fragColor;

#pragma glslify: unfilteredPosition = require("./unfiltered_position.glsl")

void main() {

    float prominence = abs(pf[3]);

    mat4 p[4];
    p[0] = mat4(p0, p1, p2, p3);
    p[1] = mat4(p4, p5, p6, p7);
    p[2] = mat4(p8, p9, pa, pb);
    p[3] = mat4(pc, pd, pe, abs(pf));

    gl_Position = unfilteredPosition(
        1.0 - prominence,
        resolution, viewBoxPosition, viewBoxSize,
        p,
        sign(pf[3]),
        dim1A, dim2A, dim1B, dim2B, dim1C, dim2C, dim1D, dim2D
    );

    float clampedColorIndex = clamp((prominence - colorClamp[0]) / (colorClamp[1] - colorClamp[0]), 0.0, 1.0);
    fragColor = texture2D(palette, vec2((clampedColorIndex * 255.0 + 0.5) / 256.0, 0.5));
}
