/*
 * Decompiled with CFR 0.152.
 */
package AccuServerConnector;

import AccuServerBase.ServerCore;
import AccuServerBase.Utility;

public class HostRequestHandler
extends Thread {
    ServerCore core = null;
    String message = "";
    String serialNumber = null;
    String machineId = null;

    public HostRequestHandler(ServerCore core, String serialNumber, String machineId, String message) {
        this.core = core;
        this.message = message;
        this.serialNumber = serialNumber;
        this.machineId = machineId;
    }

    @Override
    public void run() {
        String request;
        String action = Utility.getElement((String)"Request", (String)this.message);
        System.out.println("Action " + action);
        if (action.equalsIgnoreCase("GetClientInfo")) {
            String info = this.core.getCloudInfo();
            request = "<Request>UpdateClientInfo</Request><SerialNumber>" + this.serialNumber + "</SerialNumber><MachineId>" + this.machineId + "</MachineId>" + info;
            this.core.sendToHost(request);
        }
        if (action.equalsIgnoreCase("Refused")) {
            this.core.addToLog("AccuServer Host Connection Exception: host.accupos.com connection refused");
            this.core.input("AccuServer Host Connection Exception: host.accupos.com connection refused");
            this.core.setHostReply("Refused", "HostConnectionRefused");
            return;
        }
        if (action.equalsIgnoreCase("Disabled")) {
            this.core.addToLog("AccuServer Host Connection Exception: host.accupos.com connection disabled");
            this.core.input("AccuServer Host Connection Exception: host.accupos.com connection disabled");
            this.core.setHostReply("Disabled", "HostConnectionDisabled");
            return;
        }
        if (action.equalsIgnoreCase("HostDelay")) {
            this.core.addToLog("AccuServer Host Connection Exception: host.accupos.com connection delayed");
            this.core.input("AccuServer Host Connection Exception: host.accupos.com connection delayed");
            this.core.setHostReply("Delay", "HostConnectionDelay");
            return;
        }
        if (action.equalsIgnoreCase("PingResponse")) {
            this.core.setHostReply("PingResponse", "PingResponse");
            return;
        }
        if (action.equalsIgnoreCase("PingDisable")) {
            this.core.setHostReply("PingDisable", "PingDisable");
            return;
        }
        if (action.equalsIgnoreCase("WoltOrderNotice")) {
            this.core.woltOrderNotice(this.message);
        }
        if (action.equalsIgnoreCase("AllLocations")) {
            this.core.setHostReply("AllLocations", this.message);
        }
        if (action.equalsIgnoreCase("Transactions")) {
            this.core.setHostReply("Transactions", this.message);
        }
        if (action.equalsIgnoreCase("ItemTypeSummary")) {
            this.core.setHostReply("ItemTypeSummary", this.message);
        }
        if (action.equalsIgnoreCase("ItemTypes")) {
            this.core.setHostReply("ItemTypes", this.message);
        }
        if (action.equalsIgnoreCase("ItemCategories")) {
            this.core.setHostReply("ItemCategories", this.message);
        }
        if (action.equalsIgnoreCase("TenderSummary")) {
            this.core.setHostReply("TenderSummary", this.message);
        }
        if (action.equalsIgnoreCase("SetSyncActive")) {
            this.core.setHostSyncActive(this.message);
        }
        if (action.equalsIgnoreCase("SyncedOrders")) {
            this.core.setHostReply("SyncedOrders", this.message);
        }
        if (action.equalsIgnoreCase("SyncedCustomers")) {
            this.core.setHostReply("SyncedCustomers", this.message);
        }
        if (action.equalsIgnoreCase("SyncedEmployees")) {
            this.core.setHostReply("SyncedEmployees", this.message);
        }
        if (action.equalsIgnoreCase("SyncedCompanyInfo")) {
            this.core.setHostReply("SyncedCompanyInfo", this.message);
        }
        if (action.equalsIgnoreCase("SyncedFollowOnItems")) {
            this.core.setHostReply("SyncedFollowOnItems", this.message);
        }
        if (action.equalsIgnoreCase("SyncedUnitOfMeasures")) {
            this.core.setHostReply("SyncedUnitOfMeasures", this.message);
        }
        if (action.equalsIgnoreCase("SyncedItemGroups")) {
            this.core.setHostReply("SyncedItemGroups", this.message);
        }
        if (action.equalsIgnoreCase("SyncedSalePrices")) {
            this.core.setHostReply("SyncedSalePrices", this.message);
        }
        if (action.equalsIgnoreCase("SyncedFlexGroups")) {
            this.core.setHostReply("SyncedFlexGroups", this.message);
        }
        if (action.equalsIgnoreCase("SyncedFlexGroupDetails")) {
            this.core.setHostReply("SyncedFlexGroupDetails", this.message);
        }
        if (action.equalsIgnoreCase("SyncedNoPartialQtys")) {
            this.core.setHostReply("SyncedNoPartialQtys", this.message);
        }
        if (action.contains("SyncedItems")) {
            int itemsSegment = Utility.getIntElement((String)"SyncedItemsSegment", (String)this.message);
            this.core.setHostReply("SyncedItems-" + itemsSegment, this.message);
        }
        if (action.equalsIgnoreCase("SyncedFollowOns")) {
            this.core.setHostReply("SyncedFollowOns", this.message);
        }
        if (action.equalsIgnoreCase("SyncedUOMs")) {
            this.core.setHostReply("SyncedUOMs", this.message);
        }
        if (action.equalsIgnoreCase("SyncedItemGroups")) {
            this.core.setHostReply("SyncedItemGroups", this.message);
        }
        if (action.equalsIgnoreCase("SyncedSalePrices")) {
            this.core.setHostReply("SyncedSalePrices", this.message);
        }
        if (action.equalsIgnoreCase("SyncedFlexGroups")) {
            this.core.setHostReply("SyncedFlexGroups", this.message);
        }
        if (action.equalsIgnoreCase("SyncedFlexGroupDetails")) {
            this.core.setHostReply("SyncedFlexGroupDetails", this.message);
        }
        if (action.equalsIgnoreCase("SyncedNoPartialQtys")) {
            this.core.setHostReply("SyncedNoPartialQtys", this.message);
        }
        if (action.equalsIgnoreCase("SyncedUserGroups")) {
            this.core.setHostReply("SyncedUserGroups", this.message);
        }
        if (action.equalsIgnoreCase("SyncedUsers")) {
            this.core.setHostReply("SyncedUsers", this.message);
        }
        if (action.equalsIgnoreCase("SyncedTaxCodes")) {
            this.core.setHostReply("SyncedTaxCodes", this.message);
        }
        if (action.equalsIgnoreCase("SyncedTaxAuthorities")) {
            this.core.setHostReply("SyncedTaxAuthorities", this.message);
        }
        if (action.equalsIgnoreCase("SyncedTenderCodes")) {
            this.core.setHostReply("SyncedTenderCodes", this.message);
        }
        if (action.equalsIgnoreCase("SyncedTills")) {
            this.core.setHostReply("SyncedTills", this.message);
        }
        if (action.equalsIgnoreCase("SyncedMenuKeys")) {
            this.core.setHostReply("SyncedMenuKeys", this.message);
        }
        if (action.equalsIgnoreCase("SyncedVendors")) {
            this.core.setHostReply("SyncedVendors", this.message);
        }
        if (action.equalsIgnoreCase("SyncedVatCodes")) {
            this.core.setHostReply("SyncedVatCodes", this.message);
        }
        if (action.equalsIgnoreCase("SyncedAdjustmentSessions")) {
            this.core.setHostReply("SyncedAdjustmentSessions", this.message);
        }
        if (action.equalsIgnoreCase("SyncedReceivingSessions")) {
            this.core.setHostReply("SyncedReceivingSessions", this.message);
        }
        if (action.equalsIgnoreCase("SyncedPriceChangeSessions")) {
            this.core.setHostReply("SyncedPriceChangeSessions", this.message);
        }
        if (action.equalsIgnoreCase("SyncedPriceChangeSessions")) {
            this.core.setHostReply("SyncedPriceChangeSessions", this.message);
        }
        if (action.equalsIgnoreCase("SyncedAlternateTaxes")) {
            this.core.setHostReply("SyncedAlternateTaxes", this.message);
        }
        if (action.equalsIgnoreCase("SyncedCompReasons")) {
            this.core.setHostReply("SyncedCompReasons", this.message);
        }
        if (action.equalsIgnoreCase("SyncedFoodStampTypes")) {
            this.core.setHostReply("SyncedFoodStampTypes", this.message);
        }
        if (action.equalsIgnoreCase("SyncedItemCategories")) {
            this.core.setHostReply("SyncedItemCategories", this.message);
        }
        if (action.equalsIgnoreCase("SyncedOperatorMessages")) {
            this.core.setHostReply("SyncedOperatorMessages", this.message);
        }
        if (action.equalsIgnoreCase("SyncedServerLocations")) {
            this.core.setHostReply("SyncedServerLocations", this.message);
        }
        if (action.equalsIgnoreCase("SyncedBreaks")) {
            this.core.setHostReply("SyncedBreaks", this.message);
        }
        if (action.equalsIgnoreCase("SyncedChoiceKeys")) {
            this.core.setHostReply("SyncedChoiceKeys", this.message);
        }
        if (action.equalsIgnoreCase("SyncedEConduitTerminals")) {
            this.core.setHostReply("SyncedEConduitTerminals", this.message);
        }
        if (action.equalsIgnoreCase("SyncedProductLines")) {
            this.core.setHostReply("SyncedProductLines", this.message);
        }
        if (action.equalsIgnoreCase("SyncedPriceLevelTimes")) {
            this.core.setHostReply("SyncedPriceLevelTimes", this.message);
        }
        if (action.equalsIgnoreCase("SyncedRemoteDisplays")) {
            this.core.setHostReply("SyncedRemoteDisplays", this.message);
        }
        if (action.equalsIgnoreCase("SyncedResets")) {
            this.core.setHostReply("SyncedResets", this.message);
        }
        if (action.equalsIgnoreCase("SyncedTables")) {
            this.core.setHostReply("SyncedTables", this.message);
        }
        if (action.equalsIgnoreCase("SyncedTerms")) {
            this.core.setHostReply("SyncedTerms", this.message);
        }
        if (action.equalsIgnoreCase("SyncedTCControl")) {
            this.core.setHostReply("SyncedTCControl", this.message);
        }
        if (action.equalsIgnoreCase("SyncedDiscountReasons")) {
            this.core.setHostReply("SyncedDiscountReasons", this.message);
        }
        if (action.equalsIgnoreCase("SyncedQualifyingQtyTypes")) {
            this.core.setHostReply("SyncedQualifyingQtyTypes", this.message);
        }
        if (action.equalsIgnoreCase("SyncedPOSStations")) {
            this.core.setHostReply("SyncedPOSStations", this.message);
        }
        if (action.equalsIgnoreCase("SyncedCourseNames")) {
            this.core.setHostReply("SyncedCourseNames", this.message);
        }
        if (action.equalsIgnoreCase("SyncedItemAttributes")) {
            this.core.setHostReply("SyncedItemAttributes", this.message);
        }
        if (action.equalsIgnoreCase("SyncedLogo")) {
            this.core.setHostReply("SyncedLogo", this.message);
        }
        if (action.equalsIgnoreCase("RequestClientConnectCode")) {
            String newCode = this.core.generateClientConnectCode();
            request = "<Request>RequestClientConnectCode</Request><SerialNumber>" + this.serialNumber + "</SerialNumber><ConnectCode>" + newCode + "</ConnectCode>";
            this.core.sendToHost(request);
        }
        if (action.equalsIgnoreCase("ValidateClientConnectCode")) {
            boolean isValid = false;
            String enteredCode = Utility.getElement((String)"EnteredCode", (String)this.message);
            if (enteredCode != null && !enteredCode.isEmpty()) {
                isValid = this.core.validateClientConnectCode(enteredCode);
            }
            String request2 = "<Request>ValidateClientConnectCode</Request><SerialNumber>" + this.serialNumber + "</SerialNumber><IsValid>" + isValid + "</IsValid>";
            this.core.sendToHost(request2);
        }
        if (action.equalsIgnoreCase("QbWebRequest")) {
            String soapActionLine = Utility.getElement((String)"SoapActionLine", (String)this.message);
            String qbRequest = Utility.getElement((String)"QbRequestXml", (String)this.message);
            this.core.processHostAccountingRequest(soapActionLine, qbRequest);
        }
        if (action.equalsIgnoreCase("AdapterResponse")) {
            String adapterData = Utility.getElement((String)"AdapterData", (String)this.message);
            this.core.processHostAccountingResponse("AdapterResponse", adapterData);
        }
        if (action.equalsIgnoreCase("GeneratedClientReceiptLink")) {
            String clientReceiptLink = Utility.getElement((String)"ClientReceiptLink", (String)this.message);
            this.core.setHostReply("GeneratedClientReceiptLink", clientReceiptLink);
        }
        if (action.equalsIgnoreCase("ForceHostSync")) {
            this.core.forceHostSync(true);
        }
    }
}

