/*
 * Decompiled with CFR 0.152.
 */
package AccuServerIntegrator;

import AccuServerLogger.AuditTrailFormatter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Logger;

public class AccuServerIntegratorExportLogger {
    private Logger logger;
    private String version;
    private static AccuServerIntegratorExportLogger thisInstance = null;

    public static AccuServerIntegratorExportLogger getInstance(String version) {
        if (thisInstance == null) {
            thisInstance = new AccuServerIntegratorExportLogger(version);
        }
        return thisInstance;
    }

    public AccuServerIntegratorExportLogger(String xVersion) {
        this.version = xVersion;
        try {
            boolean append = true;
            FileHandler handler = new FileHandler("AccuServerIntegratorExportLog.xml", 65536, 2, append);
            handler.setFormatter(new AuditTrailFormatter());
            this.logger = Logger.getLogger("accuServerIntegratorExport");
            this.logger.addHandler(handler);
            this.log("starting version " + this.version);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void log(String text) {
        Date now = new Date();
        String msg = now.toString() + " " + text + "\n";
        this.logger.info(msg);
    }

    public void log(Exception ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        String stacktrace = sw.toString();
        Date now = new Date();
        String msg = now.toString() + " " + ex.toString() + "\n" + stacktrace + "\n";
        this.logger.info(msg);
    }
}

