/*
 * Decompiled with CFR 0.152.
 */
package AccuServerIntegrator;

import AccuCountDataObjects.AdjustmentSession;
import AccuServerBase.AccuServerIntegratorBase;
import AccuServerBase.ServerCore;
import AccuServerBase.ServerObject;
import AccuServerBase.Utility;
import AccuServerIntegrator.AccuServerIntegratorLogger;
import AccuServerIntegrator.IntegratorStatusLogger;
import POSDataObjects.Company;
import POSDataObjects.CompanySetupInfo;
import POSDataObjects.Customer;
import POSDataObjects.Item;
import POSDataObjects.LineItem;
import POSDataObjects.Order;
import POSDataObjects.POSDataContainer;
import POSDataObjects.Reset;
import POSDataObjects.Tender;
import POSDataObjects.TenderCode;
import POSDataObjects.Transaction;
import POSDataObjects.User;
import POSDataObjects.ValueAddedTax;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class AccuServerRivhitIntegrator
implements ServerObject,
AccuServerIntegratorBase {
    private ServerCore core;
    private final DecimalFormat decimal = new DecimalFormat("00.0##");
    private final DecimalFormat decimalPercent = new DecimalFormat("00.0%");
    private final SimpleDateFormat invoiceDateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private final SimpleDateFormat invoiceTimeFormat = new SimpleDateFormat("HH:mm");
    private AccuServerIntegratorLogger logger;
    private String baseUrl = "https://api.rivhit.co.il/online/RivhitOnlineAPI.svc/";
    private String token = "";
    private String siteName;
    private IntegratorStatusLogger statusLogger;
    private boolean debug = false;
    private boolean verbose = false;
    private boolean importingInventory = false;
    private boolean importingCustomers = false;
    private boolean exportingSales = false;
    private boolean exportingItems = false;
    private boolean isExportingLive = false;
    private boolean summarizeAllCashSales = false;
    private boolean itemPriceUpdate = false;
    private boolean liveAccounting = false;
    private Timestamp liveAccountingStartDate;
    private boolean createCustomers = false;
    private boolean createItems = false;
    private boolean summarizeItemsByVat = false;
    private boolean hasExportError = false;
    private int cashCustomerId;
    private CompanySetupInfo companyInfo;
    private Hashtable storageList = new Hashtable();
    private Hashtable documentTypeList = new Hashtable();
    private String tillSequence;
    private Transaction summaryTransaction;
    private POSDataContainer tenderCodes;
    private LineItem summaryLine;
    private Tender summaryTender;
    private Hashtable projectList;
    private Hashtable customerTypeList;
    private Hashtable vatSummaryItems;
    private Hashtable vatRates = new Hashtable();
    private boolean paramsValid = true;
    private boolean importedItemsVatNotIncluded;

    public void initialize(ServerCore core, Hashtable parameters) {
        this.core = core;
        this.logger = AccuServerIntegratorLogger.getInstance((String)this.getApVersion());
        this.statusLogger = new IntegratorStatusLogger(core);
        this.pause(500L);
        this.updateParameters(parameters);
        this.siteName = core.getSiteName();
        this.getVatRates();
        this.getCashCustomerId();
        if (this.summarizeItemsByVat) {
            this.getVatSummaryItemIds();
        }
        this.getProjectList();
        this.getStorageList();
        this.getCustomerTypeList();
        if (this.paramsValid) {
            core.setIntegratorHandler((AccuServerIntegratorBase)this);
            core.input(core.getLiteral("\nRivhit Integrator started...\n"));
        } else {
            core.input(core.getLiteral("\nRivhit Integrator NOT started\n"));
        }
    }

    public void updateParameters(Hashtable parameters) {
        String debugString;
        String createItemsString;
        this.token = (String)parameters.get("Token");
        if (this.token == null || this.token.length() == 0) {
            this.paramsValid = false;
            this.output("Rivhit Integrator: Error, token not found.");
            return;
        }
        String itemUpdateString = (String)parameters.get("ItemUpdate");
        if (itemUpdateString == null && itemUpdateString.length() == 0) {
            itemUpdateString = (String)parameters.get("itemUpdate");
        }
        this.itemPriceUpdate = itemUpdateString == null || itemUpdateString.length() == 0 ? true : Boolean.parseBoolean(itemUpdateString);
        String summarize = (String)parameters.get("SummarizeAllCashSales");
        this.summarizeAllCashSales = summarize == null || summarize.length() == 0 ? false : Boolean.parseBoolean(summarize);
        String summarizeItemsByVatString = (String)parameters.get("SummarizeItemsByVat");
        this.summarizeItemsByVat = summarizeItemsByVatString == null || summarizeItemsByVatString.length() == 0 ? false : Boolean.parseBoolean(summarizeItemsByVatString);
        String createCustomersString = (String)parameters.get("CreateCustomer");
        if (createCustomersString != null && createCustomersString.equalsIgnoreCase("true")) {
            this.createCustomers = true;
        }
        if ((createItemsString = (String)parameters.get("CreateItems")) != null && createItemsString.equalsIgnoreCase("true")) {
            this.createItems = true;
        }
        this.debug = (debugString = (String)parameters.get("Debug")) == null || debugString.length() == 0 ? false : Boolean.parseBoolean(debugString);
        String verboseString = (String)parameters.get("Verbose");
        this.verbose = verboseString == null || verboseString.length() == 0 ? false : Boolean.parseBoolean(verboseString);
        String startDateString = (String)parameters.get("StartDate");
        try {
            int day = Integer.valueOf(startDateString.substring(0, 2));
            int month = Integer.valueOf(startDateString.substring(2, 4));
            int year = Integer.valueOf(startDateString.substring(4, 8));
            GregorianCalendar cal = new GregorianCalendar(year, month - 1, day);
            this.liveAccountingStartDate = new Timestamp(cal.getTimeInMillis());
        }
        catch (Exception e) {
            this.output("Rivhit Integrator: Error, StartDate not found.");
            this.liveAccountingStartDate = new Timestamp(Calendar.getInstance().getTimeInMillis());
        }
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm");
        this.output("Rivhit Integrator: StartDate " + dateTimeFormat.format(this.liveAccountingStartDate));
        String liveAccountingString = (String)parameters.get("LiveAccounting");
        this.liveAccounting = liveAccountingString == null || liveAccountingString.length() == 0 ? false : Boolean.parseBoolean(liveAccountingString);
        String importItemsWithoutVatText = (String)parameters.get("ImportItemsWithoutVat");
        this.importedItemsVatNotIncluded = importItemsWithoutVatText == null || importItemsWithoutVatText.length() == 0 ? false : Boolean.parseBoolean(importItemsWithoutVatText);
        int logLimit = 100;
        String actionLogLimit = (String)parameters.get("ActionLogLimit");
        if (actionLogLimit != null) {
            try {
                logLimit = Integer.valueOf(actionLogLimit);
            }
            catch (Exception ex) {
                logLimit = 100;
            }
        }
        this.statusLogger.setActionLogLimit(logLimit);
        this.core.input(this.core.getLiteral("\nRivhit Integrator Parameters updated.\n"));
    }

    public Vector getCompanyInfoList() {
        return null;
    }

    public JSONObject sendQuery(String queryString, JSONObject payload) {
        JSONObject responseJson = null;
        try {
            StringBuffer requestData = new StringBuffer();
            queryString = queryString.replace(" ", "%20");
            queryString = queryString.replace("'", "%27");
            String urlString = this.baseUrl + queryString;
            SSLContext ssl_ctx = SSLContext.getInstance("TLSv1.2");
            SSLContext.setDefault(ssl_ctx);
            ssl_ctx.init(null, null, null);
            SSLSocketFactory socketFactory = ssl_ctx.getSocketFactory();
            String response = "";
            boolean done = false;
            while (!done) {
                String line;
                BufferedReader br;
                URL url = new URL(urlString);
                HttpsURLConnection urlConnection = (HttpsURLConnection)url.openConnection();
                urlConnection.setSSLSocketFactory(socketFactory);
                urlConnection.setRequestProperty("Content-Type", "application/json");
                if (payload != null) {
                    payload.put("api_token", (Object)this.token);
                    String payloadString = payload.toString();
                    if (this.verbose) {
                        this.output("Request: " + queryString);
                        this.output(payloadString);
                    }
                    urlConnection.setRequestMethod("POST");
                    urlConnection.setDoOutput(true);
                    urlConnection.setRequestProperty("Accept", "*/*");
                    OutputStream os = urlConnection.getOutputStream();
                    os.write(payloadString.getBytes("UTF-8"));
                    os.close();
                } else {
                    urlConnection.setRequestMethod("GET");
                }
                StringBuilder sb = new StringBuilder();
                int HttpResult = urlConnection.getResponseCode();
                if (HttpResult == 200 || HttpResult == 201) {
                    br = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "utf-8"));
                    line = null;
                    while ((line = br.readLine()) != null) {
                        sb.append(line + "\n");
                    }
                    br.close();
                    response = response + sb.toString();
                    if (this.verbose) {
                        this.output("Response:");
                        this.output(response);
                    }
                    responseJson = new JSONObject(response);
                } else {
                    if (HttpResult == 401) {
                        this.output("Rivhit Integrator: Credentials Invalid");
                        done = true;
                    } else {
                        this.output("" + urlConnection.getResponseMessage());
                        br = new BufferedReader(new InputStreamReader(urlConnection.getErrorStream(), "utf-8"));
                        line = null;
                        while ((line = br.readLine()) != null) {
                            sb.append(line + "\n");
                        }
                        br.close();
                        if (this.debug) {
                            this.output("\n" + sb.toString());
                        }
                    }
                    done = true;
                }
                if (response == null || response.isEmpty()) continue;
                done = true;
            }
            this.pause(2000L);
        }
        catch (Exception e) {
            this.logger.log(e);
            e.printStackTrace();
            responseJson = new JSONObject();
        }
        return responseJson;
    }

    public void output(String output) {
        System.out.println(output);
        this.logger.log(output);
        if (output.length() > 1000) {
            output = output.substring(0, 1000);
        }
        this.core.input(output);
    }

    public int getType() {
        return 28;
    }

    public boolean checkExistingRequest() {
        return this.importingInventory || this.importingCustomers || this.exportingSales;
    }

    public boolean importInventory() {
        System.out.println("Import Items");
        this.logger.log("Import Items");
        this.statusLogger.log(this.core.getLiteral("ImportItems"), "Started", this.core.getLiteral("Import Items Started"));
        if (this.checkExistingRequest()) {
            return false;
        }
        this.importingInventory = true;
        this.companyInfo = this.core.getCompanySetup();
        try {
            JSONObject response = this.sendQuery("Item.List", new JSONObject());
            JSONObject data = response.getJSONObject("data");
            POSDataContainer items = this.getItems(data);
            this.core.saveAllItems(items, true);
        }
        catch (Exception ex) {
            this.output("Error importing items.");
            this.logger.log(ex);
            ex.printStackTrace();
        }
        this.importingInventory = false;
        return true;
    }

    public boolean importCustomers() {
        System.out.println("requesting Customers");
        this.logger.log("Requesting Customers");
        boolean success = false;
        if (this.checkExistingRequest()) {
            return success;
        }
        try {
            this.importingCustomers = true;
            JSONObject response = this.sendQuery("Customer.List", new JSONObject());
            JSONObject data = response.getJSONObject("data");
            POSDataContainer customers = this.getCustomers(data);
            if (customers != null) {
                this.core.saveAllCustomers(customers);
            }
            POSDataContainer users = this.core.getUserList();
            int len = customers.size();
            String agentsTypeName = (String)this.customerTypeList.get(60);
            for (int i = 0; i < len; ++i) {
                User user;
                Customer customer = (Customer)customers.get(i);
                if (!agentsTypeName.equals(customer.type) || (user = this.core.getUser(customer.first)) == null) continue;
                int index = users.indexOf((Object)user);
                user.serverId = Integer.parseInt(customer.code);
                users.set(index, (Object)user);
            }
            this.core.updateUsers(users);
            success = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.importingCustomers = false;
        return success;
    }

    public boolean exportNewItems() {
        return false;
    }

    public boolean exportSales(int sequence, String till, boolean isResend) {
        if (this.liveAccounting) {
            this.exportLiveAccountingUpdate();
            return true;
        }
        System.out.println("Export Sales");
        this.logger.log("Exporting Sales");
        this.statusLogger.log(this.core.getLiteral("ExportSales"), "Started", this.core.getLiteral("Export Sales Started, Sequence:") + " " + sequence + ", " + this.core.getLiteral("Till:") + " " + till);
        if (this.checkExistingRequest()) {
            return false;
        }
        if (this.exportingSales) {
            return false;
        }
        this.exportingSales = true;
        ExportSalesThread export = new ExportSalesThread(sequence, till, isResend);
        export.start();
        return true;
    }

    private JSONObject createOrder(Transaction thisTransaction, Reset reset, boolean isCash, boolean addCustomer, boolean isAddItems, boolean isAddPayments, int docType) {
        this.output("\nRivhit Integration - Adding Invoice for Transaction " + thisTransaction.transaction);
        JSONObject jsonInvoice = new JSONObject();
        try {
            if (!isAddItems && isAddPayments) {
                jsonInvoice.put("receipt_type", docType);
            } else {
                jsonInvoice.put("document_type", docType);
                jsonInvoice.put("price_include_vat", false);
                jsonInvoice.put("create_items", this.createItems);
            }
            jsonInvoice.put("reference", reset.sequence);
            jsonInvoice.put("digital_signature", true);
            jsonInvoice.put("create_customer", this.createCustomers);
            jsonInvoice.put("issue_date", (Object)this.invoiceDateFormat.format(reset.start));
            jsonInvoice.put("issue_time", (Object)this.invoiceTimeFormat.format(reset.start));
            if (this.projectList.containsKey(this.companyInfo.siteName)) {
                int projectId = (Integer)this.projectList.get(this.companyInfo.siteName);
                jsonInvoice.put("project_id", projectId);
            }
            if (isAddItems) {
                this.addItems(new Vector(thisTransaction.lineItems), jsonInvoice, thisTransaction.server);
            }
            if (isAddPayments) {
                this.addPayments(new Vector(thisTransaction.tendering), jsonInvoice);
            }
            if (isCash || this.summarizeAllCashSales && !addCustomer) {
                this.addCustomer(null, jsonInvoice);
            } else {
                Customer customer = this.core.getCustomerByCode(thisTransaction.customerCode);
                this.addCustomer(customer, jsonInvoice);
            }
        }
        catch (Exception ex) {
            this.logger.log(ex);
            ex.printStackTrace();
        }
        return jsonInvoice;
    }

    public void processHostAccountingRequest(String action, String data) {
    }

    public void processHostAccountingResponse(String action, String data) {
    }

    private LineItem getSummaryLineItem(LineItem lineItem) {
        LineItem foundLine = null;
        int linesLen = this.summaryTransaction.lineItems.size();
        for (int i = 0; i < linesLen; ++i) {
            LineItem thisLine = (LineItem)this.summaryTransaction.lineItems.get(i);
            if (!thisLine.itemId.equals(lineItem.itemId) || thisLine.price != lineItem.price) continue;
            foundLine = thisLine;
            break;
        }
        if (foundLine == null) {
            foundLine = new LineItem();
            foundLine.itemId = lineItem.itemId;
            foundLine.itemName = lineItem.itemName;
            foundLine.itemDescription = lineItem.itemDescription;
            foundLine.price = lineItem.price;
            foundLine.taxCode = lineItem.taxCode;
            this.summaryTransaction.lineItems.add(foundLine);
        }
        return foundLine;
    }

    private Tender getSummaryTender(Tender tender) {
        Tender foundTender = null;
        int linesLen = this.summaryTransaction.tendering.size();
        for (int i = 0; i < linesLen; ++i) {
            Tender thisTender = (Tender)this.summaryTransaction.tendering.get(i);
            if (!thisTender.code.equals(tender.code)) continue;
            foundTender = thisTender;
            break;
        }
        if (foundTender == null) {
            foundTender = new Tender();
            foundTender.code = tender.code;
            foundTender.description = tender.description;
            foundTender.glAccountNumber = tender.glAccountNumber;
            this.summaryTransaction.tendering.add(foundTender);
        }
        return foundTender;
    }

    public boolean prepareSalesExport(int sequence, String till, boolean isResend) {
        int i;
        this.core.input(this.core.getLiteral("\nRivhit Integrator - Starting Sales Export"));
        this.tillSequence = till + sequence;
        POSDataContainer transactions = null;
        this.companyInfo = this.core.getCompanySetup();
        Company company = this.core.getCompany();
        ArrayList<JSONObject> invoicesToSend = new ArrayList<JSONObject>();
        this.summaryTransaction = new Transaction();
        Reset reset = this.core.getReset(till, sequence);
        boolean success = false;
        try {
            block21: {
                block20: {
                    try {
                        this.logger.log("get export sales transactions from the db");
                        transactions = this.core.getExportSales(sequence, till);
                    }
                    catch (Exception ex) {
                        if (!ex.getMessage().contains("Missing")) break block20;
                        this.core.input(this.core.getLiteral("\nRivhit Integrator - Missing items/customers, export aborted (see Missing" + till + sequence + ".log file)"));
                        this.statusLogger.log(this.core.getLiteral("ExportSales"), "Failed", this.core.getLiteral("Missing items/customers, Export Sales aborted...") + "(see Missing" + till + sequence + ".log file)");
                        return success;
                    }
                }
                try {
                    this.tenderCodes = this.core.getTenderCodesList();
                }
                catch (Exception ex) {
                    if (!ex.getMessage().contains("Missing")) break block21;
                    this.core.input(this.core.getLiteral("\nRivhit Integrator - Missing items/customers, export aborted (see Missing") + till + sequence + this.core.getLiteral(".log file)"));
                    this.statusLogger.log(this.core.getLiteral("ExportSales"), "Failed", this.core.getLiteral("Missing items/customers, Export Sales aborted...") + "(see Missing" + till + sequence + ".log file)");
                    return success;
                }
            }
            this.logger.log("starting to convert sales");
            int transLen = 0;
            if (transactions != null) {
                // empty if block
            }
            transLen = transactions.size();
            for (i = 0; i < transLen; ++i) {
                Transaction thisTransaction = (Transaction)transactions.get(i);
                boolean isCash = false;
                isCash = thisTransaction.customerCode == null || thisTransaction.customerCode.isEmpty();
                this.logger.log("processing transaction :" + thisTransaction.invoice);
                if (thisTransaction.total < -1.0E-4) {
                    JSONObject thisInvoice = this.createOrder(thisTransaction, reset, false, true, true, false, 3);
                    JSONObject response = this.sendQuery("Document.New", thisInvoice);
                    success = success && this.isSuccess(response, thisInvoice);
                    thisInvoice = this.createOrder(thisTransaction, reset, isCash, false, false, true, 1);
                    response = this.sendQuery("Receipt.New", thisInvoice);
                    success = success && this.isSuccess(response, thisInvoice);
                    continue;
                }
                if (thisTransaction.total > -1.0E-4 && thisTransaction.total < 1.0E-4) {
                    JSONObject thisInvoice = this.createOrder(thisTransaction, reset, false, false, true, false, 4);
                    invoicesToSend.add(thisInvoice);
                    continue;
                }
                boolean hasAR = false;
                boolean hasCP = false;
                boolean hasOrder = false;
                int tendersLen = thisTransaction.tendering.size();
                for (int j = 0; j < tendersLen; ++j) {
                    JSONObject thisInvoice;
                    Tender thisTender = (Tender)thisTransaction.tendering.get(j);
                    TenderCode tenderCode = this.core.getTenderCode(thisTender.code);
                    if (tenderCode.tenderType.equals("A")) {
                        hasAR = true;
                        thisInvoice = this.createOrder(thisTransaction, reset, isCash, true, true, false, 1);
                        invoicesToSend.add(thisInvoice);
                        continue;
                    }
                    if (tenderCode.tenderType.equals("Y")) {
                        hasCP = true;
                        thisInvoice = this.createOrder(thisTransaction, reset, isCash, true, false, true, 1);
                        invoicesToSend.add(thisInvoice);
                        continue;
                    }
                    if (!tenderCode.tenderType.equalsIgnoreCase("H") && !tenderCode.tenderType.equalsIgnoreCase("U") && !tenderCode.tenderType.equalsIgnoreCase("T") && !tenderCode.tenderType.equalsIgnoreCase("W")) continue;
                    thisInvoice = this.createOrder(thisTransaction, reset, false, false, true, false, 4);
                    invoicesToSend.add(thisInvoice);
                }
                if (isCash || this.summarizeAllCashSales && !hasAR) {
                    int j;
                    this.summaryTransaction.total += thisTransaction.total;
                    int linesLen = thisTransaction.lineItems.size();
                    for (j = 0; j < linesLen; ++j) {
                        LineItem thisLine = (LineItem)thisTransaction.lineItems.get(j);
                        if (thisLine.status.equals("V")) continue;
                        this.summaryLine = this.getSummaryLineItem(thisLine);
                        this.summaryLine.vatGross += thisLine.vatGross;
                        this.summaryLine.total += thisLine.total;
                        this.summaryLine.quantity += thisLine.quantity;
                        this.summaryLine.vatTax1 += thisLine.vatTax1;
                        this.summaryLine.vatTax2 += thisLine.vatTax2;
                    }
                    for (j = 0; j < tendersLen; ++j) {
                        Tender thisTender = (Tender)thisTransaction.tendering.get(j);
                        if (thisTender.status.equals("V")) continue;
                        this.summaryTender = this.getSummaryTender(thisTender);
                        this.summaryTender.amount += thisTender.amount;
                    }
                    continue;
                }
                if (hasAR && tendersLen > 1) {
                    JSONObject thisInvoice = this.createOrder(thisTransaction, reset, isCash, hasAR, false, true, 1);
                    invoicesToSend.add(thisInvoice);
                }
                if (hasCP || hasAR) continue;
                JSONObject thisInvoice = this.createOrder(thisTransaction, reset, isCash, hasAR, true, true, 2);
                invoicesToSend.add(thisInvoice);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (transactions == null || transactions.size() == 0) {
            this.core.input(this.core.getLiteral("\nRivhit Integrator - No sales records found to export"));
            this.statusLogger.log(this.core.getLiteral("ExportSales"), "Failed", this.core.getLiteral("No sales records found to export, Export Sales aborted..."));
            return false;
        }
        this.core.input(this.core.getLiteral("\nRivhit Integrator - Exporting Sales for Till " + till + " Sequence " + sequence));
        if (this.summaryTransaction.lineItems.size() > 0) {
            JSONObject summaryInvoice = this.createOrder(this.summaryTransaction, reset, true, false, true, true, 2);
            JSONObject responseArray = this.sendQuery("Document.New", summaryInvoice);
            this.isSuccess(responseArray, summaryInvoice);
        }
        int invoicesLen = invoicesToSend.size();
        for (i = 0; i < invoicesLen; ++i) {
            JSONObject thisInvoice = (JSONObject)invoicesToSend.get(i);
            JSONObject responseArray = this.sendQuery("Document.New", thisInvoice);
            this.isSuccess(responseArray, thisInvoice);
        }
        this.core.input(this.core.getLiteral("\nRivhit Integrator - Finished Sales Export for Till " + till + " Sequence " + sequence));
        this.statusLogger.log(this.core.getLiteral("ExportSales"), "Completed", this.core.getLiteral("Completed, Export Sales for Sequence:") + " " + sequence + ", " + this.core.getLiteral("Till:") + " " + till);
        return success;
    }

    public boolean prepareSalesByVatTypeExport(int sequence, String till, boolean isResend) {
        int i;
        this.core.input(this.core.getLiteral("\nRivhit Integrator - Starting Sales By Vat Type Export"));
        this.tillSequence = till + sequence;
        POSDataContainer transactions = null;
        this.companyInfo = this.core.getCompanySetup();
        this.summaryTransaction = new Transaction();
        ArrayList<JSONObject> invoicesToSend = new ArrayList<JSONObject>();
        ArrayList<JSONObject> receiptsToSend = new ArrayList<JSONObject>();
        Hashtable linesByVatCode = new Hashtable();
        Reset reset = this.core.getReset(till, sequence);
        boolean success = false;
        try {
            block19: {
                block18: {
                    try {
                        this.logger.log("get export sales transactions from the db");
                        transactions = this.core.getExportSales(sequence, till);
                    }
                    catch (Exception ex) {
                        if (!ex.getMessage().contains("Missing")) break block18;
                        this.core.input(this.core.getLiteral("\nRivhit Integrator - Missing items/customers, export aborted (see Missing" + till + sequence + ".log file)"));
                        this.statusLogger.log(this.core.getLiteral("ExportSales"), "Failed", this.core.getLiteral("Missing items/customers, Export Sales aborted...") + "(see Missing" + till + sequence + ".log file)");
                        return success;
                    }
                }
                try {
                    this.tenderCodes = this.core.getTenderCodesList();
                }
                catch (Exception ex) {
                    if (!ex.getMessage().contains("Missing")) break block19;
                    this.core.input(this.core.getLiteral("\nRivhit Integrator - Missing items/customers, export aborted (see Missing") + till + sequence + this.core.getLiteral(".log file)"));
                    this.statusLogger.log(this.core.getLiteral("ExportSales"), "Failed", this.core.getLiteral("Missing items/customers, Export Sales aborted...") + "(see Missing" + till + sequence + ".log file)");
                    return success;
                }
            }
            this.logger.log("starting to convert sales");
            int transLen = 0;
            if (transactions != null) {
                transLen = transactions.size();
            }
            for (i = 0; i < transLen; ++i) {
                Tender thisTender;
                int j;
                Transaction thisTransaction = (Transaction)transactions.get(i);
                int tendersLen = thisTransaction.tendering.size();
                boolean hasAR = false;
                boolean hasCP = false;
                boolean hasOrder = false;
                if (thisTransaction.total > -1.0E-4 && thisTransaction.total < 1.0E-4) {
                    JSONObject thisInvoice = this.createOrder(thisTransaction, reset, false, false, true, false, 4);
                    invoicesToSend.add(thisInvoice);
                    continue;
                }
                for (j = 0; j < tendersLen; ++j) {
                    JSONObject thisInvoice;
                    thisTender = (Tender)thisTransaction.tendering.get(j);
                    TenderCode tenderCode = this.core.getTenderCode(thisTender.code);
                    if (tenderCode.tenderType.equals("A")) {
                        hasAR = true;
                        Date dateInvoiced = thisTransaction.dateInvoiced;
                        Date dateEntered = thisTransaction.dateEntered;
                        thisTransaction.dateInvoiced = null;
                        thisTransaction.dateEntered = null;
                        Transaction newTransaction = new Transaction(thisTransaction.toXml());
                        thisTransaction.dateInvoiced = new Timestamp(dateInvoiced.getTime());
                        thisTransaction.dateEntered = new Timestamp(dateEntered.getTime());
                        newTransaction.dateInvoiced = new Timestamp(dateInvoiced.getTime());
                        newTransaction.dateEntered = new Timestamp(dateEntered.getTime());
                        Hashtable linesByVatCodeForThisTrans = new Hashtable();
                        this.summerizeLinesByVatCode(thisTransaction, linesByVatCodeForThisTrans);
                        newTransaction.lineItems = new ArrayList(linesByVatCodeForThisTrans.values());
                        JSONObject thisInvoice2 = this.createOrder(newTransaction, reset, false, true, true, false, 1);
                        invoicesToSend.add(thisInvoice2);
                        continue;
                    }
                    if (tenderCode.tenderType.equals("Y")) {
                        hasCP = true;
                        thisInvoice = this.createOrder(thisTransaction, reset, false, true, false, true, 1);
                        receiptsToSend.add(thisInvoice);
                        continue;
                    }
                    if (!tenderCode.tenderType.equalsIgnoreCase("H") && !tenderCode.tenderType.equalsIgnoreCase("U") && !tenderCode.tenderType.equalsIgnoreCase("T") && !tenderCode.tenderType.equalsIgnoreCase("W")) continue;
                    hasOrder = true;
                    thisInvoice = this.createOrder(thisTransaction, reset, false, false, true, false, 4);
                    invoicesToSend.add(thisInvoice);
                }
                if (hasAR && tendersLen > 1) {
                    JSONObject thisReceipt = this.createOrder(thisTransaction, reset, false, true, false, true, 1);
                    receiptsToSend.add(thisReceipt);
                    continue;
                }
                if (hasOrder || hasAR || hasCP) continue;
                for (j = 0; j < tendersLen; ++j) {
                    thisTender = (Tender)thisTransaction.tendering.get(j);
                    if (thisTender.status.equals("V")) continue;
                    this.summaryTender = this.getSummaryTender(thisTender);
                    this.summaryTender.amount += thisTender.amount;
                }
                this.summaryTransaction.total += thisTransaction.total;
                this.summerizeLinesByVatCode(thisTransaction, linesByVatCode);
            }
            this.summaryTransaction.lineItems = new ArrayList(linesByVatCode.values());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (transactions == null || transactions.size() == 0) {
            this.core.input(this.core.getLiteral("\nRivhit Integrator - No sales records found to export"));
            this.statusLogger.log(this.core.getLiteral("ExportSales"), "Failed", this.core.getLiteral("No sales records found to export, Export Sales aborted..."));
            return false;
        }
        this.core.input(this.core.getLiteral("\nRivhit Integrator - Exporting Sales for Till " + till + " Sequence " + sequence));
        if (this.summaryTransaction.lineItems.size() > 0) {
            JSONObject summaryInvoice = this.createOrder(this.summaryTransaction, reset, true, false, true, true, 2);
            JSONObject responseArray = this.sendQuery("Document.New", summaryInvoice);
            this.isSuccess(responseArray, summaryInvoice);
        }
        int invoicesLen = invoicesToSend.size();
        for (i = 0; i < invoicesLen; ++i) {
            JSONObject thisInvoice = (JSONObject)invoicesToSend.get(i);
            JSONObject responseArray = this.sendQuery("Document.New", thisInvoice);
            this.isSuccess(responseArray, thisInvoice);
        }
        int receiptsLen = receiptsToSend.size();
        for (int i2 = 0; i2 < receiptsLen; ++i2) {
            JSONObject thisReceipt = (JSONObject)receiptsToSend.get(i2);
            JSONObject responseArray = this.sendQuery("Receipt.New", thisReceipt);
            this.isSuccess(responseArray, thisReceipt);
        }
        this.core.input(this.core.getLiteral("\nRivhit Integrator - Finished Sales Export for Till " + till + " Sequence " + sequence));
        this.statusLogger.log(this.core.getLiteral("ExportSales"), "Completed", this.core.getLiteral("Completed, Export Sales for Sequence:") + " " + sequence + ", " + this.core.getLiteral("Till:") + " " + till);
        return success;
    }

    private void summerizeLinesByVatCode(Transaction transaction, Hashtable linesByVatCode) {
        int linesLen = transaction.lineItems.size();
        for (int k = 0; k < linesLen; ++k) {
            LineItem thisLine = (LineItem)transaction.lineItems.get(k);
            if (thisLine.status.equals("V")) continue;
            LineItem thisVatLineTotal = (LineItem)linesByVatCode.get(thisLine.taxCode);
            VatItem vatItem = (VatItem)this.vatSummaryItems.get(thisLine.taxCode);
            if (thisVatLineTotal == null) {
                thisVatLineTotal = new LineItem();
                thisVatLineTotal.taxCode = thisLine.taxCode;
                thisVatLineTotal.itemId = vatItem.rivhitId + "";
                thisVatLineTotal.itemDescription = vatItem.itemName;
                thisVatLineTotal.quantity = 1.0;
            }
            thisVatLineTotal.price += thisLine.vatGross;
            thisVatLineTotal.total += thisLine.total;
            linesByVatCode.put(thisLine.taxCode, thisVatLineTotal);
        }
    }

    public boolean exportItemAdjustments(AdjustmentSession as) {
        return false;
    }

    public boolean exportItemReceipts(Vector vector) {
        return false;
    }

    public void exportLiveAccountingUpdate() {
        if (this.liveAccounting) {
            this.output("Rivhit Integration: Initializing Live Accounting...");
            ExportLiveThread syncThread = new ExportLiveThread();
            syncThread.start();
        }
    }

    private JSONObject createRemoteOrderAccountsReceivable(Order thisOrder) {
        JSONObject remoteOrder = new JSONObject();
        try {
            remoteOrder.put("document_type", 1);
            remoteOrder.put("reference", thisOrder.orderNumber);
            remoteOrder.put("price_include_vat", false);
            remoteOrder.put("digital_signature", true);
            remoteOrder.put("create_items", this.createItems);
            remoteOrder.put("create_customer", this.createCustomers);
            remoteOrder.put("issue_date", (Object)this.invoiceDateFormat.format(thisOrder.dateInvoiced));
            remoteOrder.put("issue_time", (Object)this.invoiceTimeFormat.format(thisOrder.dateInvoiced));
            remoteOrder.put("order", (Object)(thisOrder.orderNumber + ""));
            if (this.projectList.containsKey(this.companyInfo.siteName)) {
                int projectId = (Integer)this.projectList.get(this.companyInfo.siteName);
                remoteOrder.put("project_id", projectId);
            }
            this.addCustomer(thisOrder.customer, remoteOrder);
            this.addItems(thisOrder.lineItems, remoteOrder, thisOrder.user);
        }
        catch (Exception e) {
            this.output("Error Creating Order");
            this.logger.log(e);
        }
        return remoteOrder;
    }

    private JSONObject createRemoteOrderPayment(Order thisOrder) {
        JSONObject remoteOrder = new JSONObject();
        try {
            remoteOrder.put("receipt_type", 1);
            remoteOrder.put("reference", thisOrder.orderNumber);
            remoteOrder.put("create_customer", this.createCustomers);
            remoteOrder.put("issue_date", (Object)this.invoiceDateFormat.format(thisOrder.dateInvoiced));
            remoteOrder.put("issue_time", (Object)this.invoiceTimeFormat.format(thisOrder.dateInvoiced));
            this.addCustomer(thisOrder.customer, remoteOrder);
            this.addPayments(thisOrder.tenderings, remoteOrder);
        }
        catch (Exception e) {
            this.output("Error Creating Order");
            this.logger.log(e);
        }
        return remoteOrder;
    }

    private JSONObject createRemoteOrder(Order thisOrder) {
        JSONObject remoteOrder = new JSONObject();
        try {
            remoteOrder.put("document_type", 2);
            remoteOrder.put("reference", thisOrder.orderNumber);
            remoteOrder.put("price_include_vat", false);
            remoteOrder.put("digital_signature", true);
            remoteOrder.put("create_items", this.createItems);
            remoteOrder.put("order", (Object)(thisOrder.orderNumber + ""));
            if (this.projectList.containsKey(this.companyInfo.siteName)) {
                int projectId = (Integer)this.projectList.get(this.companyInfo.siteName);
                remoteOrder.put("project_id", projectId);
            }
            remoteOrder.put("create_customer", this.createCustomers);
            remoteOrder.put("issue_date", (Object)this.invoiceDateFormat.format(thisOrder.dateInvoiced));
            remoteOrder.put("issue_time", (Object)this.invoiceTimeFormat.format(thisOrder.dateInvoiced));
            this.addCustomer(thisOrder.customer, remoteOrder);
            this.addItems(thisOrder.lineItems, remoteOrder, thisOrder.user);
            this.addPayments(thisOrder.tenderings, remoteOrder);
        }
        catch (Exception e) {
            this.output("Error Creating Order");
            this.logger.log(e);
        }
        return remoteOrder;
    }

    private JSONObject createRemoteRefundReceipt(Order thisOrder) {
        JSONObject remoteOrder = new JSONObject();
        try {
            remoteOrder.put("document_type", 3);
            remoteOrder.put("reference", thisOrder.orderNumber);
            remoteOrder.put("price_include_vat", false);
            remoteOrder.put("digital_signature", true);
            remoteOrder.put("create_items", this.createItems);
            remoteOrder.put("create_customer", this.createCustomers);
            remoteOrder.put("issue_date", (Object)this.invoiceDateFormat.format(thisOrder.dateInvoiced));
            remoteOrder.put("issue_time", (Object)this.invoiceTimeFormat.format(thisOrder.dateInvoiced));
            remoteOrder.put("order", (Object)(thisOrder.orderNumber + ""));
            if (this.projectList.containsKey(this.companyInfo.siteName)) {
                int projectId = (Integer)this.projectList.get(this.companyInfo.siteName);
                remoteOrder.put("project_id", projectId);
            }
            this.addCustomer(thisOrder.customer, remoteOrder);
            int len = thisOrder.lineItems.size();
            for (int i = 0; i < len; ++i) {
                LineItem thisItemLine = (LineItem)thisOrder.lineItems.get(i);
                if (thisItemLine.status.equals("V") || !(thisItemLine.quantity < 0.0)) continue;
                thisItemLine.quantity *= -1.0;
                thisItemLine.changedQuantity = "Refund";
            }
            this.addItems(thisOrder.lineItems, remoteOrder, thisOrder.user);
            this.addPayments(thisOrder.tenderings, remoteOrder);
        }
        catch (Exception e) {
            this.output("Error Creating Refund Receipt");
            this.logger.log(e);
        }
        return remoteOrder;
    }

    private JSONObject createRemoteOrderDeliveryDocument(Order thisOrder) {
        JSONObject remoteOrder = new JSONObject();
        try {
            remoteOrder.put("document_type", 4);
            remoteOrder.put("reference", thisOrder.orderNumber);
            remoteOrder.put("price_include_vat", false);
            remoteOrder.put("digital_signature", true);
            remoteOrder.put("create_items", this.createItems);
            remoteOrder.put("create_customer", this.createCustomers);
            remoteOrder.put("issue_date", (Object)this.invoiceDateFormat.format(thisOrder.dateInvoiced));
            remoteOrder.put("issue_time", (Object)this.invoiceTimeFormat.format(thisOrder.dateInvoiced));
            remoteOrder.put("order", (Object)(thisOrder.orderNumber + ""));
            if (this.projectList.containsKey(this.companyInfo.siteName)) {
                int projectId = (Integer)this.projectList.get(this.companyInfo.siteName);
                remoteOrder.put("project_id", projectId);
            }
            if (this.storageList.containsKey(this.companyInfo.qbClassExports)) {
                int storageId = (Integer)this.storageList.get(this.companyInfo.qbClassExports);
                remoteOrder.put("storage_id", storageId);
            }
            this.addCustomer(thisOrder.customer, remoteOrder);
            this.addItems(thisOrder.lineItems, remoteOrder, thisOrder.user);
        }
        catch (Exception e) {
            this.output("Error Creating Order");
            this.logger.log(e);
        }
        return remoteOrder;
    }

    private void addCustomer(Customer customer, JSONObject remoteOrder) {
        try {
            if (customer != null) {
                if (this.hasIntValue(customer.contact)) {
                    remoteOrder.put("customer_id", (Object)Integer.valueOf(customer.contact));
                }
                if (customer.companyName != null && !customer.companyName.trim().isEmpty()) {
                    remoteOrder.put("last_name", (Object)customer.companyName);
                } else {
                    if (customer.last != null && !customer.last.trim().isEmpty()) {
                        remoteOrder.put("last_name", (Object)customer.last);
                    }
                    if (customer.first != null && !customer.first.trim().isEmpty()) {
                        remoteOrder.put("first_name", (Object)customer.first);
                    }
                }
                if (customer.address1 != null && !customer.address1.trim().isEmpty()) {
                    remoteOrder.put("address", (Object)customer.address1);
                }
                if (customer.city != null && !customer.city.trim().isEmpty()) {
                    remoteOrder.put("city", (Object)customer.city);
                }
                if (customer.zip != null && !customer.zip.trim().isEmpty()) {
                    remoteOrder.put("zipcode", (Object)customer.zip);
                }
                if (!this.hasIntValue(customer.contact) && this.createCustomers) {
                    int customerId = this.createUpdateCustomer(customer, false);
                    remoteOrder.put("customer_id", customerId);
                }
            } else {
                remoteOrder.put("customer_id", this.cashCustomerId);
            }
        }
        catch (Exception e) {
            this.output("Error Addding Customer");
            this.logger.log(e);
        }
    }

    private void addItems(Vector lineItems, JSONObject jsonInvoice, String serverId) {
        try {
            double saleDiscount = 0.0;
            double total = 0.0;
            JSONArray jsonItemsArray = new JSONArray();
            int itemsSize = lineItems.size();
            for (int i = 0; i < itemsSize; ++i) {
                JSONObject jsonItem = new JSONObject();
                LineItem thisItemLine = (LineItem)lineItems.get(i);
                if (thisItemLine.status.equals("V")) continue;
                if ((thisItemLine.itemId.equalsIgnoreCase("DISC") || thisItemLine.itemId.equalsIgnoreCase("Discount")) && this.liveAccounting) {
                    double discountAmount = 0.0;
                    if (!thisItemLine.status.equals("V")) {
                        discountAmount = this.getItemDiscountAmount(thisItemLine);
                    }
                    saleDiscount += discountAmount * thisItemLine.quantity;
                    continue;
                }
                total += thisItemLine.vatGross;
                Item thisItem = this.core.getItemByCode(thisItemLine.itemId);
                if (!this.summarizeItemsByVat) {
                    String itemId = thisItem.accountingCode;
                    if (itemId == null || itemId.trim().isEmpty()) {
                        itemId = thisItem.code;
                    }
                    if (thisItem.imported && !itemId.equals("null")) {
                        jsonItem.put("item_id", (Object)itemId);
                    }
                } else {
                    jsonItem.put("item_id", (Object)thisItemLine.itemId);
                }
                if (!thisItem.description.equals(thisItemLine.itemDescription)) {
                    jsonItem.put("description", (Object)thisItemLine.itemDescription);
                }
                if (thisItemLine.total < 0.0 && thisItemLine.quantity > 0.0 && !thisItemLine.changedQuantity.equals("Refund")) {
                    thisItemLine.quantity *= -1.0;
                }
                jsonItem.put("quantity", thisItemLine.quantity);
                jsonItem.put("price_nis", thisItemLine.total / thisItemLine.quantity);
                double discountAmount = this.getItemDiscountAmount(thisItemLine);
                if (discountAmount > 0.0) {
                    Double vatPecent = (Double)this.vatRates.get(thisItemLine.taxCode);
                    double originalPriceWithoutVat = thisItemLine.originalPrice / ((100.0 + vatPecent) / 100.0);
                    jsonItem.put("bruto_price_nis", (Object)this.decimal.format(originalPriceWithoutVat));
                }
                jsonItem.put("exempt_vat", thisItemLine.taxCode.equals("\u05e4\u05d8\u05d5\u05e8"));
                String storageId = this.companyInfo.qbClassExports;
                if (storageId != null && !storageId.isEmpty()) {
                    jsonItem.put("storage_id", (Object)storageId);
                }
                jsonItemsArray.put((Object)jsonItem);
            }
            jsonInvoice.put("items", (Object)jsonItemsArray);
            if (this.liveAccounting) {
                if (saleDiscount > 0.0) {
                    double discountPercent = saleDiscount / total * 100.0;
                    jsonInvoice.put("discount_value", discountPercent);
                    jsonInvoice.put("discount_type", 1);
                }
                User user = this.core.getUser(serverId);
                if (user.isServer && user.serverId > 0) {
                    jsonInvoice.put("agent_id", user.serverId);
                }
            }
        }
        catch (Exception e) {
            this.output("Error Addding Items");
            this.logger.log(e);
        }
    }

    private double getItemDiscountAmount(LineItem lineItem) {
        double discount = 0.0;
        if (lineItem.itemId.equalsIgnoreCase("DISC") || lineItem.itemId.equalsIgnoreCase("Discount")) {
            discount = lineItem.vatGross * -1.0;
        } else if (lineItem.originalPrice - lineItem.price > 0.001) {
            discount = lineItem.originalPrice - lineItem.price;
        }
        return discount;
    }

    private void addPayments(Vector tenderings, JSONObject jsonInvoice) {
        try {
            JSONArray jsonTendersArray = new JSONArray();
            int tendersLen = tenderings.size();
            for (int i = 0; i < tendersLen; ++i) {
                JSONObject jsonTender;
                Tender thisTender = (Tender)tenderings.get(i);
                if (thisTender.amount == 0.0) continue;
                TenderCode tenderCode = this.core.getTenderCode(thisTender.code);
                String thisType = tenderCode.tenderType;
                String glAccount = tenderCode.glAccount.trim();
                if (thisType.equals("P")) {
                    jsonTender = new JSONObject();
                    int paymentType = this.hasIntValue(glAccount) ? Integer.valueOf(glAccount) : 2;
                    jsonTender.put("payment_type", paymentType);
                    jsonTender.put("description", (Object)thisTender.description);
                    jsonTender.put("amount_nis", thisTender.amount);
                    jsonTendersArray.put((Object)jsonTender);
                    continue;
                }
                if (thisType.equals("$")) {
                    jsonTender = new JSONObject();
                    Hashtable checkDetails = this.getCheckDetails(thisTender.responseData);
                    String date = (String)checkDetails.get("CheckDate");
                    if (!date.isEmpty()) {
                        date = date.replace("/", "");
                        date = date.replace("/", "20");
                        jsonTender.put("due_date", (Object)date);
                    }
                    jsonTender.put("bank_code", this.tryParseInt((String)checkDetails.get("BankNumber")));
                    jsonTender.put("branch_number", this.tryParseInt((String)checkDetails.get("BranchNumber")));
                    jsonTender.put("bank_account_number", this.tryParseInt((String)checkDetails.get("AccountNumber")));
                    jsonTender.put("check_number", this.tryParseInt((String)checkDetails.get("CheckNumber")));
                    jsonTender.put("payment_type", (Object)Integer.valueOf(glAccount));
                    jsonTender.put("description", (Object)thisTender.description);
                    jsonTender.put("amount_nis", thisTender.amount);
                    jsonTendersArray.put((Object)jsonTender);
                    continue;
                }
                if (thisType.equals("X") || thisType.equals("Y") || thisType.equals("A")) continue;
                jsonTender = new JSONObject();
                if (thisType.equals("D") && thisTender.responseData != null && !thisTender.responseData.isEmpty()) {
                    boolean isPinpad = thisTender.responseData.contains("<Transaction>");
                    String cardNum = "";
                    if (isPinpad) {
                        cardNum = this.getCreditCardDetail(thisTender.responseData, "\u05de\u05e1\u05e4\u05e8 \u05db\u05e8\u05d8\u05d9\u05e1");
                    } else {
                        cardNum = this.getCreditCardDetail(thisTender.responseData, "\u05de\u05e1\u05e4\u05e8");
                        int curdNumLen = cardNum.length();
                        cardNum = "************" + cardNum.substring(curdNumLen - 4, curdNumLen);
                    }
                    jsonTender.put("bank_account_number", (Object)cardNum);
                    String numberPayments = Utility.getElement((String)"NumberPayments", (String)thisTender.responseData);
                    if (!numberPayments.isEmpty()) {
                        jsonTender.put("number_of_payments", (Object)numberPayments);
                    }
                    String description = "\u05d0\u05e1. ";
                    description = description + thisTender.approval;
                    jsonTender.put("description", (Object)description);
                }
                jsonTender.put("payment_type", (Object)Integer.valueOf(glAccount));
                if (!thisType.equals("D")) {
                    jsonTender.put("description", (Object)thisTender.description);
                }
                jsonTender.put("amount_nis", thisTender.amount);
                jsonTendersArray.put((Object)jsonTender);
            }
            jsonInvoice.put("payments", (Object)jsonTendersArray);
        }
        catch (NumberFormatException e) {
            this.output("Error Adding Payments. Please make sure tender GL Account is set.");
            this.logger.log((Exception)e);
        }
        catch (Exception e) {
            this.output("Error Adding Payments.");
            this.logger.log(e);
        }
    }

    public int tryParseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private boolean isSuccess(JSONObject response, JSONObject request) {
        boolean success = false;
        try {
            if (response != null) {
                boolean bl = success = response.optInt("error_code", Integer.MAX_VALUE) == 0;
                if (!success) {
                    this.output(response.getString("client_message") + "\r\n" + request.toString());
                }
            } else {
                this.output("Error getting Rivhit response\r\n" + request.toString());
            }
        }
        catch (Exception e) {
            this.output("Error getting Rivhit response");
        }
        return success;
    }

    private Hashtable getCheckDetails(String xml) {
        String[] tenderFields = new String[]{Utility.getElement((String)"TenderField1", (String)xml), Utility.getElement((String)"TenderField2", (String)xml), Utility.getElement((String)"TenderField3", (String)xml), Utility.getElement((String)"TenderField4", (String)xml), Utility.getElement((String)"TenderField5", (String)xml)};
        Hashtable<String, String> values = new Hashtable<String, String>();
        values.put("BankNumber", "");
        values.put("BranchNumber", "");
        values.put("AccountNumber", "");
        values.put("CheckNumber", "");
        values.put("CheckDate", "");
        for (int j = 0; j < 5; ++j) {
            String fieldName = Utility.getElement((String)"FieldName", (String)tenderFields[j]);
            if (fieldName.equalsIgnoreCase(this.core.getLiteral("BankNumber")) || fieldName.contentEquals("BankNumber")) {
                values.put("BankNumber", Utility.getElement((String)"FieldData", (String)tenderFields[j]));
                continue;
            }
            if (fieldName.equalsIgnoreCase(this.core.getLiteral("BranchNumber")) || fieldName.contentEquals("BranchNumber")) {
                values.put("BranchNumber", Utility.getElement((String)"FieldData", (String)tenderFields[j]));
                continue;
            }
            if (fieldName.equalsIgnoreCase(this.core.getLiteral("AccountNumber")) || fieldName.contentEquals("AccountNumber")) {
                values.put("AccountNumber", Utility.getElement((String)"FieldData", (String)tenderFields[j]));
                continue;
            }
            if (fieldName.equalsIgnoreCase(this.core.getLiteral("CheckNumber")) || fieldName.contentEquals("CheckNumber")) {
                values.put("CheckNumber", Utility.getElement((String)"FieldData", (String)tenderFields[j]));
                continue;
            }
            if (!fieldName.equalsIgnoreCase(this.core.getLiteral("CheckDate")) && !fieldName.contentEquals("CheckDate")) continue;
            values.put("CheckDate", Utility.getElement((String)"FieldData", (String)tenderFields[j]));
        }
        return values;
    }

    private String getCreditCardDetail(String xml, String fieldName) {
        String value = "";
        xml = Utility.getElement((String)"PrintData", (String)xml);
        Vector receiptLines = Utility.getElementList((String)"ReceiptLine", (String)xml);
        int receiptLinesLen = receiptLines.size();
        for (int i = 0; i < receiptLinesLen; ++i) {
            String thisLine = (String)receiptLines.get(i);
            String thisLable = Utility.getElement((String)"ReceiptLabel", (String)thisLine);
            if (!thisLable.equals(fieldName)) continue;
            value = Utility.getElement((String)"ReceiptField", (String)thisLine);
            break;
        }
        return value;
    }

    public void importReset() {
    }

    public void setSiteName(String string) {
    }

    public boolean importEmployees(boolean bln) {
        return false;
    }

    public boolean exportTimes(ArrayList al) {
        return false;
    }

    public String getEncryptKey() {
        return null;
    }

    public boolean isDisableCustomerBalance() {
        return false;
    }

    public void disconnectAuth() {
    }

    public String[] getIdAndSecret(String string) {
        return new String[0];
    }

    private String getApVersion() {
        String version = this.decimal.format(this.core.getApVersion());
        return version;
    }

    private void pause(long delay) {
        try {
            Thread.currentThread();
            Thread.sleep(delay);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void handleException(Exception e) {
        this.core.raiseException(e);
    }

    private POSDataContainer getItems(JSONObject data) {
        POSDataContainer items = new POSDataContainer();
        Timestamp today = new Timestamp(new Date().getTime());
        try {
            JSONArray itemList = data.getJSONArray("item_list");
            Hashtable itemGroupList = this.getItemGroupList();
            int itemsLen = itemList.length();
            for (int i = 0; i < itemsLen; ++i) {
                int groupId;
                JSONObject jsonItem = itemList.getJSONObject(i);
                String barcode = this.optString(jsonItem, "barcode", null);
                String itemIdString = "";
                int itemId = jsonItem.getInt("item_id");
                itemIdString = String.valueOf(itemId);
                Item item = this.core.getItemByAccountingRef(itemIdString);
                boolean isNewItem = false;
                if (item == null) {
                    item = new Item();
                    isNewItem = true;
                }
                item.imported = true;
                item.changed = true;
                item.updated = today;
                item.code = barcode != null && !barcode.isEmpty() ? barcode : itemIdString;
                item.accountingCode = itemIdString;
                item.accountingRef = itemIdString;
                item.description = this.optString(jsonItem, "item_name");
                item.alternateDescription = this.optString(jsonItem, "item_extended_description");
                if (item.alternateDescription.isEmpty()) {
                    item.alternateDescription = item.description;
                }
                if (itemGroupList.containsKey(groupId = jsonItem.optInt("item_group_id"))) {
                    String groupName = (String)itemGroupList.get(groupId);
                    item.type = groupName != null ? groupName : "";
                    item.scale = item.type.contains("/#");
                }
                item.cost = jsonItem.optDouble("cost_nis");
                boolean exemptVat = jsonItem.optBoolean("exempt_vat", false);
                String string = item.vatCode = exemptVat ? "\u05e4\u05d8\u05d5\u05e8" : "\u05de\u05e2\u05de";
                if (this.itemPriceUpdate || isNewItem) {
                    if (this.importedItemsVatNotIncluded) {
                        item.price4 = item.price5 = jsonItem.optDouble("sale_nis");
                        item.price3 = item.price5;
                        item.price2 = item.price5;
                        item.price1 = item.price5;
                        item.price = item.price5;
                    } else {
                        item.price4 = item.price5 = this.core.getPriceWithVatRemoved(jsonItem.optDouble("sale_nis"), item.vatCode);
                        item.price3 = item.price5;
                        item.price2 = item.price5;
                        item.price1 = item.price5;
                        item.price = item.price5;
                    }
                }
                item.onHand = jsonItem.optDouble("quantity");
                items.add((Object)item);
            }
        }
        catch (Exception ex) {
            this.output("Error importing items.");
            this.logger.log(ex);
        }
        return items;
    }

    private Hashtable getItemGroupList() {
        Hashtable<Integer, String> itemGroupList = new Hashtable<Integer, String>();
        try {
            JSONObject response = this.sendQuery("Item.Groups", new JSONObject());
            JSONObject data = response.getJSONObject("data");
            JSONArray itemGroups = data.getJSONArray("item_group_list");
            int itemGroupsLen = itemGroups.length();
            for (int i = 0; i < itemGroupsLen; ++i) {
                JSONObject itemGroup = itemGroups.getJSONObject(i);
                itemGroupList.put(itemGroup.getInt("item_group_id"), itemGroup.getString("item_group_name"));
            }
        }
        catch (Exception ex) {
            this.output("Error getting item groups from Rivhit.");
            this.logger.log(ex);
        }
        return itemGroupList;
    }

    private POSDataContainer getCustomers(JSONObject data) {
        POSDataContainer customers = new POSDataContainer();
        JSONObject jsonCustomer = null;
        try {
            JSONArray customerList = data.getJSONArray("customer_list");
            int length = customerList.length();
            for (int i = 0; i < length; ++i) {
                jsonCustomer = (JSONObject)customerList.get(i);
                int customerId = jsonCustomer.getInt("customer_id");
                String accRef = this.optString(jsonCustomer, "acc_ref");
                if (accRef.equals("\u05dc\u05e7\u05d5\u05d7\u05de\u05d6\u05de\u05d3\u05de\u05df")) continue;
                Customer customer = new Customer();
                customer.code = customer.contact = String.valueOf(customerId);
                customer.first = this.optString(jsonCustomer, "first_name");
                customer.last = this.optString(jsonCustomer, "last_name");
                customer.phone = this.optString(jsonCustomer, "phone");
                customer.email = this.optString(jsonCustomer, "email");
                customer.address1 = this.optString(jsonCustomer, "street");
                customer.city = this.optString(jsonCustomer, "city");
                customer.zip = this.optString(jsonCustomer, "zipcode");
                customer.fax = this.optString(jsonCustomer, "fax");
                customer.balance = jsonCustomer.optDouble("balance");
                int customerType = jsonCustomer.getInt("customer_type");
                customer.type = (String)this.customerTypeList.get(customerType);
                customer.note = this.optString(jsonCustomer, "comments");
                customers.add((Object)customer);
            }
        }
        catch (Exception e) {
            this.output("Error importing customer");
            if (jsonCustomer != null) {
                this.output(jsonCustomer.toString());
            }
            this.logger.log(e);
        }
        return customers;
    }

    private int createUpdateCustomer(Customer customer, boolean isUpdate) {
        int customerId = -1;
        if (this.debug) {
            this.core.input("Rivhit Integrator: Creating/Updating Customer Id...");
        }
        JSONObject customerJson = new JSONObject();
        try {
            if (!customer.last.trim().isEmpty()) {
                customerJson.put("last_name", (Object)customer.last);
            } else {
                customerJson.put("last_name", (Object)customer.code);
            }
            if (!customer.first.isEmpty()) {
                customerJson.put("first_name", (Object)customer.first);
            }
            if (customer.code.length() <= 20) {
                customerJson.put("acc_ref", (Object)customer.code);
            }
            if (!customer.address1.isEmpty()) {
                customerJson.put("address", (Object)customer.address1);
            }
            if (!customer.city.isEmpty()) {
                customerJson.put("city", (Object)customer.city);
            }
            if (this.hasIntValue(customer.zip)) {
                customerJson.put("zipcode", (Object)Integer.valueOf(customer.zip));
            }
            if (!customer.phone.isEmpty()) {
                customerJson.put("phone", (Object)customer.phone);
            }
            if (!customer.fax.isEmpty()) {
                customerJson.put("fax", (Object)customer.fax);
            }
            if (!customer.email.isEmpty()) {
                customerJson.put("email", (Object)customer.email);
            }
            if (!customer.note.isEmpty()) {
                customerJson.put("comments", (Object)customer.note);
            }
            if (this.hasIntValue(customer.type)) {
                customerJson.put("customer_type", (Object)Integer.valueOf(customer.type));
            }
            if (!customer.country.isEmpty()) {
                customerJson.put("country", (Object)customer.country);
            }
            if (!customer.state.isEmpty()) {
                customerJson.put("state", (Object)customer.state);
            }
            if (isUpdate) {
                customerJson.put("customer_id", (Object)customer.contact);
                JSONObject response = this.sendQuery("Customer.Update", customerJson);
                if (response == null) {
                    this.output("Rivhit Integration: Error updating customer " + customer.code);
                }
            } else {
                customerJson.put("id_customer", 0);
                JSONObject response = this.sendQuery("Customer.New", customerJson);
                if (!this.isSuccess(response, customerJson)) {
                    this.output("Rivhit Integration: Error creating customer " + customer.code);
                } else {
                    JSONObject data = response.getJSONObject("data");
                    customerId = data.getInt("customer_id");
                    customer.contact = String.valueOf(customerId);
                    POSDataContainer customersList = new POSDataContainer();
                    customersList.add((Object)customer);
                    this.core.saveAllCustomers(customersList);
                }
            }
        }
        catch (Exception e) {
            if (isUpdate) {
                this.output("Rivhit Integration: Error updating customer " + customer.code);
            } else {
                this.output("Rivhit Integration: Error creating customer " + customer.code);
            }
            this.logger.log(e);
        }
        return customerId;
    }

    private void getCashCustomerId() {
        if (this.debug) {
            this.core.input("Rivhit Integrator: Getting Cash Customer Id...");
        }
        try {
            JSONObject request = new JSONObject();
            request.put("acc_ref", (Object)"\u05dc\u05e7\u05d5\u05d7\u05de\u05d6\u05d3\u05de\u05df");
            JSONObject response = this.sendQuery("Customer.Get", request);
            if (response != null) {
                JSONObject data = response.getJSONObject("data");
                this.cashCustomerId = data.getInt("customer_id");
            } else {
                JSONObject jsonCustomer = new JSONObject();
                jsonCustomer.put("last_name", (Object)"\u05dc\u05e7\u05d5\u05d7 \u05de\u05d6\u05d3\u05de\u05df");
                jsonCustomer.put("acc_ref", (Object)"\u05dc\u05e7\u05d5\u05d7\u05de\u05d6\u05d3\u05de\u05df");
                response = this.sendQuery("Customer.New", jsonCustomer);
                if (response != null) {
                    this.cashCustomerId = response.getInt("customer_id");
                } else {
                    this.output("Rivhit Integrator: Error Getting Cash Customer Id");
                }
            }
            if (this.debug) {
                this.core.input("Rivhit Cash Customer Id: " + this.cashCustomerId);
            }
        }
        catch (Exception ex) {
            this.output("Rivhit Integrator: Error Getting Cash Customer Id");
            this.logger.log(ex);
        }
    }

    private void getVatSummaryItemIds() {
        if (this.debug) {
            this.core.input("Rivhit Integrator: Getting Vat Summary Item Ids...");
        }
        try {
            this.vatSummaryItems = new Hashtable();
            POSDataContainer vatCodes = this.core.getVatCodes();
            int vatCodesLen = vatCodes.size();
            JSONObject request = new JSONObject();
            JSONObject response = this.sendQuery("Item.List", request);
            if (response != null) {
                JSONObject data = response.getJSONObject("data");
                JSONArray itemsList = data.getJSONArray("item_list");
                for (int i = 0; i < vatCodesLen; ++i) {
                    ValueAddedTax thisVat = (ValueAddedTax)vatCodes.get(i);
                    String vatItemName = "\u05e4\u05e8\u05d9\u05d8 \u05e1\u05d9\u05db\u05d5\u05dd - " + thisVat.code;
                    VatItem vatItem = new VatItem();
                    for (int j = 0; j < itemsList.length(); ++j) {
                        JSONObject thisItem = itemsList.getJSONObject(j);
                        String itemName = thisItem.getString("item_name");
                        if (!itemName.equals(vatItemName)) continue;
                        vatItem.rivhitId = thisItem.getInt("item_id");
                    }
                    if (vatItem.rivhitId == 0) {
                        JSONObject newItem = new JSONObject();
                        newItem.put("item_name", (Object)vatItemName);
                        response = this.sendQuery("Item.New", newItem);
                        if (response != null && response.has("data")) {
                            data = response.getJSONObject("data");
                            vatItem.rivhitId = data.getInt("item_id");
                        }
                    }
                    vatItem.vatCode = thisVat.code;
                    vatItem.itemName = vatItemName;
                    this.vatSummaryItems.put(thisVat.code, vatItem);
                }
            }
        }
        catch (Exception ex) {
            this.output("Rivhit Integrator: Error Getting Vat Summary Item Ids");
            this.logger.log(ex);
        }
    }

    private void getStorageList() {
        if (this.debug) {
            this.core.input("Rivhit Integrator: Getting Storage List...");
        }
        try {
            JSONObject response = this.sendQuery("Item.StorageList", new JSONObject());
            if (response != null) {
                JSONObject data = response.getJSONObject("data");
                JSONArray storageListJsonArray = data.getJSONArray("storage_list");
                int storageListLen = storageListJsonArray.length();
                for (int i = 0; i < storageListLen; ++i) {
                    JSONObject thisStorage = storageListJsonArray.getJSONObject(i);
                    this.storageList.put(thisStorage.getString("storage_name"), thisStorage.getInt("storage_id"));
                }
            } else {
                this.core.input("Error Getting Storage List.");
            }
        }
        catch (Exception e) {
            this.output("Error Getting Storage List.");
            this.logger.log(e);
            e.printStackTrace();
        }
    }

    private void getDocumnetTypeList() {
        if (this.debug) {
            this.core.input("Rivhit Integrator: Getting Document Type List...");
        }
        try {
            JSONObject response = this.sendQuery("Document.TypeList", new JSONObject());
            if (response != null) {
                JSONArray docTypeListJsonArray = response.getJSONArray("document_type_list");
                int docTypeListLen = docTypeListJsonArray.length();
                for (int i = 0; i < docTypeListLen; ++i) {
                    JSONObject thisDocType = docTypeListJsonArray.getJSONObject(i);
                    DocumentType docType = new DocumentType();
                    docType.typeId = thisDocType.getInt("document_type");
                    docType.name = thisDocType.getString("document_name");
                    docType.isAccounting = thisDocType.getBoolean("is_accounting");
                    docType.isInvoiceReceipt = thisDocType.getBoolean("is_invoice_receipt");
                    docType.priceIncludeVat = thisDocType.getBoolean("price_include_vat");
                    this.documentTypeList.put(docType.typeId, docType);
                }
            } else {
                this.core.input("Error Getting Document Type List.");
            }
        }
        catch (Exception e) {
            this.output("Error Getting Document Type List.");
            this.logger.log(e);
        }
    }

    private void getProjectList() {
        if (this.debug) {
            this.core.input("Rivhit Integrator: Getting Project List...");
        }
        try {
            JSONObject response = this.sendQuery("Project.List", new JSONObject());
            this.projectList = new Hashtable();
            if (response != null) {
                JSONArray projectListJsonArray = response.getJSONObject("data").getJSONArray("project_list");
                int jsonArrayLen = projectListJsonArray.length();
                for (int i = 0; i < jsonArrayLen; ++i) {
                    JSONObject thisProject = projectListJsonArray.getJSONObject(i);
                    this.projectList.put(thisProject.getString("project_name"), thisProject.getInt("project_id"));
                }
            } else {
                this.core.input("Error Getting Project List.");
            }
        }
        catch (Exception e) {
            this.output("Error Getting Document Type List.");
            this.logger.log(e);
        }
    }

    private void getCustomerTypeList() {
        if (this.debug) {
            this.core.input("Rivhit Integrator: Getting Customer Type List...");
        }
        try {
            JSONObject response = this.sendQuery("Customer.TypeList", new JSONObject());
            this.customerTypeList = new Hashtable();
            if (response != null) {
                JSONArray customerTypeListJsonArray = response.getJSONObject("data").getJSONArray("customer_type_list");
                int jsonArrayLen = customerTypeListJsonArray.length();
                for (int i = 0; i < jsonArrayLen; ++i) {
                    JSONObject thisCustomerType = customerTypeListJsonArray.getJSONObject(i);
                    this.customerTypeList.put(thisCustomerType.getInt("customer_type"), thisCustomerType.getString("customer_type_name"));
                }
            } else {
                this.core.input("Error Customer Type List.");
            }
        }
        catch (Exception e) {
            this.output("Error Getting Customer Type List.");
            this.logger.log(e);
        }
    }

    private boolean cancelInvoice(Order order) {
        int[] documentInfo = this.getExternalDocumentNumber(order);
        int documentNumber = documentInfo[0];
        int documentType = documentInfo[1];
        JSONObject cancelRequest = new JSONObject();
        JSONObject response = null;
        boolean success = false;
        if (documentNumber > 0 && documentType > 0) {
            try {
                cancelRequest.put("document_type", documentType);
                cancelRequest.put("document_number", documentNumber);
                cancelRequest.put("price_include_vat", false);
                cancelRequest.put("digital_signature", true);
            }
            catch (Exception e) {
                this.output("Error Creating Order");
                this.logger.log(e);
            }
            response = this.sendQuery("Document.Cancel", cancelRequest);
        }
        success = this.isSuccess(response, cancelRequest);
        return success;
    }

    private int[] getExternalDocumentNumber(Order order) {
        int documentType;
        int documentNumber;
        block4: {
            documentNumber = 0;
            documentType = 0;
            try {
                JSONObject request = new JSONObject();
                request.put("from_date", (Object)this.invoiceDateFormat.format(order.dateInvoiced));
                request.put("to_date", (Object)this.invoiceDateFormat.format(order.dateInvoiced));
                JSONObject response = this.sendQuery("Document.List", request);
                boolean success = this.isSuccess(response, request);
                if (success) {
                    JSONArray foundDocuments = response.getJSONObject("data").getJSONArray("document_list");
                    int jsonArrayLen = foundDocuments.length();
                    for (int i = 0; i < jsonArrayLen; ++i) {
                        JSONObject thisDocument = foundDocuments.getJSONObject(i);
                        boolean isCancelled = thisDocument.getBoolean("is_cancelled");
                        String orderId = thisDocument.getString("order");
                        if (!orderId.equals(order.orderId) || isCancelled) continue;
                        documentNumber = thisDocument.getInt("document_number");
                        documentType = thisDocument.getInt("document_type");
                        break block4;
                    }
                    break block4;
                }
                this.core.input("Error Getting Rivhit Document Number.");
            }
            catch (Exception e) {
                this.output("Error Getting Rivhit Document Number.");
                this.logger.log(e);
            }
        }
        int[] returnValue = new int[]{documentNumber, documentType};
        return returnValue;
    }

    private boolean hasIntValue(String value) {
        boolean success = true;
        try {
            Integer.valueOf(value);
        }
        catch (Exception e) {
            success = false;
        }
        return success;
    }

    private String optString(JSONObject json, String key) {
        String value = "";
        try {
            if (!json.isNull(key)) {
                value = json.getString(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    private String optString(JSONObject json, String key, String defualtValue) {
        String value = defualtValue;
        try {
            if (!json.isNull(key)) {
                value = json.getString(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    private void getVatRates() {
        POSDataContainer vatRecords = this.core.getVatRecords();
        int len = vatRecords.size();
        for (int i = 0; i < len; ++i) {
            ValueAddedTax tax = (ValueAddedTax)vatRecords.get(i);
            this.vatRates.put(tax.code, tax.rate);
        }
    }

    class VatItem {
        int rivhitId;
        String vatCode;
        String itemName;

        VatItem() {
        }
    }

    class DocumentType {
        int typeId;
        String name;
        boolean isInvoiceReceipt;
        boolean isAccounting;
        boolean priceIncludeVat;

        DocumentType() {
        }
    }

    class ExportLiveThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (AccuServerRivhitIntegrator.this.isExportingLive) {
                return;
            }
            try {
                AccuServerRivhitIntegrator.this.isExportingLive = true;
                AccuServerRivhitIntegrator.this.companyInfo = AccuServerRivhitIntegrator.this.core.getCompanySetup();
                POSDataContainer updateOrders = AccuServerRivhitIntegrator.this.core.getLiveAccountingUpdateOrders(AccuServerRivhitIntegrator.this.liveAccountingStartDate);
                int numOrders = updateOrders.size();
                for (int i = 0; i < numOrders; ++i) {
                    JSONObject response;
                    boolean success = true;
                    Order thisOrder = (Order)updateOrders.get(i);
                    if (thisOrder.originalInvoiceNumber != 0) {
                        AccuServerRivhitIntegrator.this.cancelInvoice(thisOrder);
                    }
                    int tendersLen = thisOrder.tenderings.size();
                    int linesLen = thisOrder.lineItems.size();
                    boolean hasAR = false;
                    boolean hasCP = false;
                    boolean hasOrder = false;
                    thisOrder.total = thisOrder.subTotal + thisOrder.totalTax;
                    double totalPayments = 0.0;
                    if (thisOrder.total < 0.0) {
                        JSONObject remoteOrder = AccuServerRivhitIntegrator.this.createRemoteRefundReceipt(thisOrder);
                        response = AccuServerRivhitIntegrator.this.sendQuery("Document.New", remoteOrder);
                        success = success && AccuServerRivhitIntegrator.this.isSuccess(response, remoteOrder);
                        remoteOrder = AccuServerRivhitIntegrator.this.createRemoteOrderPayment(thisOrder);
                        response = AccuServerRivhitIntegrator.this.sendQuery("Receipt.New", remoteOrder);
                        success = success && AccuServerRivhitIntegrator.this.isSuccess(response, remoteOrder);
                    } else if (thisOrder.total > 0.0 || linesLen > 0 || tendersLen > 0) {
                        for (int j = 0; j < tendersLen; ++j) {
                            JSONObject response2;
                            JSONObject remoteOrder;
                            Tender thisTender = (Tender)thisOrder.tenderings.get(j);
                            if (thisTender.type.equals("A")) {
                                remoteOrder = AccuServerRivhitIntegrator.this.createRemoteOrderAccountsReceivable(thisOrder);
                                response2 = AccuServerRivhitIntegrator.this.sendQuery("Document.New", remoteOrder);
                                success = success && AccuServerRivhitIntegrator.this.isSuccess(response2, remoteOrder);
                                hasAR = true;
                                continue;
                            }
                            if (thisTender.type.equals("Y")) {
                                remoteOrder = AccuServerRivhitIntegrator.this.createRemoteOrderPayment(thisOrder);
                                response2 = AccuServerRivhitIntegrator.this.sendQuery("Receipt.New", remoteOrder);
                                success = success && AccuServerRivhitIntegrator.this.isSuccess(response2, remoteOrder);
                                hasCP = true;
                                continue;
                            }
                            if (thisTender.type.equalsIgnoreCase("H") || thisTender.type.equalsIgnoreCase("U") || thisTender.type.equalsIgnoreCase("T") || thisTender.type.equalsIgnoreCase("W")) {
                                hasOrder = true;
                                continue;
                            }
                            totalPayments += thisTender.amount;
                        }
                        if (hasAR && totalPayments > 0.0) {
                            JSONObject remoteOrder = AccuServerRivhitIntegrator.this.createRemoteOrderPayment(thisOrder);
                            response = AccuServerRivhitIntegrator.this.sendQuery("Receipt.New", remoteOrder);
                            boolean bl = success = success && AccuServerRivhitIntegrator.this.isSuccess(response, remoteOrder);
                        }
                        if (!hasCP && !hasAR && totalPayments != 0.0 || hasOrder && tendersLen > 1) {
                            JSONObject remoteOrder = AccuServerRivhitIntegrator.this.createRemoteOrder(thisOrder);
                            response = AccuServerRivhitIntegrator.this.sendQuery("Document.New", remoteOrder);
                            boolean bl = success = success && AccuServerRivhitIntegrator.this.isSuccess(response, remoteOrder);
                        }
                        if (totalPayments == 0.0 && tendersLen <= 1 || hasOrder && tendersLen == 1) {
                            JSONObject remoteOrder = AccuServerRivhitIntegrator.this.createRemoteOrderDeliveryDocument(thisOrder);
                            response = AccuServerRivhitIntegrator.this.sendQuery("Document.New", remoteOrder);
                            boolean bl = success = success && AccuServerRivhitIntegrator.this.isSuccess(response, remoteOrder);
                        }
                    }
                    if (success) {
                        Date updateDate = new Date();
                        Timestamp updateTimestamp = new Timestamp(updateDate.getTime());
                        AccuServerRivhitIntegrator.this.core.updateLiveAccountingTimeStamp(thisOrder.orderNumber, updateTimestamp);
                        AccuServerRivhitIntegrator.this.output("Rivhit Integrator: invoice " + thisOrder.receiptNumber + " exported successfully.");
                        continue;
                    }
                    AccuServerRivhitIntegrator.this.output("Rivhit Integrator: error exporting invoice " + thisOrder.receiptNumber);
                }
            }
            catch (Exception e) {
                AccuServerRivhitIntegrator.this.logger.log(e);
                e.printStackTrace();
            }
            finally {
                AccuServerRivhitIntegrator.this.isExportingLive = false;
            }
        }
    }

    private class ExportSalesThread
    extends Thread {
        private int sequence;
        private String till;
        private boolean isResend;

        public ExportSalesThread(int sequence, String till, boolean isResend) {
            this.sequence = sequence;
            this.till = till;
            this.isResend = isResend;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (AccuServerRivhitIntegrator.this.summarizeItemsByVat) {
                    AccuServerRivhitIntegrator.this.prepareSalesByVatTypeExport(this.sequence, this.till, this.isResend);
                } else {
                    AccuServerRivhitIntegrator.this.prepareSalesExport(this.sequence, this.till, this.isResend);
                }
            }
            catch (Exception ex) {
                AccuServerRivhitIntegrator.this.handleException(ex);
            }
            finally {
                AccuServerRivhitIntegrator.this.exportingSales = false;
            }
        }
    }
}

