/*
 * Decompiled with CFR 0.152.
 */
package AccuServerIntegrator;

import AccuServerBase.ServerCore;
import AccuServerBase.Utility;
import POSDataObjects.IntegratorLogMessage;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Vector;

public class IntegratorStatusLogger {
    private ServerCore core;
    private int actionLogLimit = 100;
    private boolean updatingLogfile = false;

    public IntegratorStatusLogger(ServerCore core, int logLimit) {
        this.core = core;
        this.actionLogLimit = logLimit;
    }

    public IntegratorStatusLogger(ServerCore core) {
        this.core = core;
    }

    public void setActionLogLimit(int actionLogLimit) {
        this.actionLogLimit = actionLogLimit;
    }

    public void log(String action, String status, String message) {
        LogThread thisLogThread = new LogThread(action, status, "", message);
        thisLogThread.start();
    }

    public void log(String action, String status, String statusCode, String message) {
        LogThread thisLogThread = new LogThread(action, status, statusCode, message);
        thisLogThread.start();
    }

    private class LogThread
    extends Thread {
        String action;
        String status;
        String message;
        String statusCode;

        public LogThread(String action, String status, String statusCode, String message) {
            this.action = action;
            this.status = status;
            this.statusCode = statusCode;
            this.message = message;
        }

        @Override
        public void run() {
            while (IntegratorStatusLogger.this.updatingLogfile) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            IntegratorStatusLogger.this.updatingLogfile = true;
            try {
                Vector xmlList;
                Timestamp now = new Timestamp(System.currentTimeMillis());
                String date = now.toString();
                String pathSeparator = System.getProperty("file.separator");
                String userDir = System.getProperty("user.dir");
                String fileName = userDir + pathSeparator + "integratorStatusLog.xml";
                String xml = Utility.getXml((String)fileName);
                if (xml == null || xml.isEmpty()) {
                    xml = "";
                }
                if (!(xmlList = Utility.getElementList((String)"IntegratorMessage", (String)xml)).isEmpty()) {
                    while (xmlList.size() > IntegratorStatusLogger.this.actionLogLimit) {
                        xmlList.remove(0);
                    }
                }
                IntegratorLogMessage logMessage = new IntegratorLogMessage(date, this.action, this.status, this.statusCode, this.message);
                xmlList.add(logMessage.toXml());
                int len = xmlList.size();
                StringBuilder updatedXml = new StringBuilder();
                for (int i = 0; i < len; ++i) {
                    String xmlMsg = (String)xmlList.get(i);
                    logMessage = new IntegratorLogMessage(xmlMsg);
                    updatedXml.append(logMessage.toXml());
                }
                try {
                    Utility.writeXml((String)fileName, (String)updatedXml.toString());
                }
                catch (IOException ex) {
                    IntegratorStatusLogger.this.core.raiseException((Exception)ex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            IntegratorStatusLogger.this.updatingLogfile = false;
        }
    }
}

