/*
 * Decompiled with CFR 0.152.
 */
package AccuServerLogger;

import AccuServerBase.ServerCore;
import AccuServerLogger.AuditTrailFormatter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Logger;

public class AccuServerAuditTrailLogger {
    private Logger logger;
    private static AccuServerAuditTrailLogger thisInstance = null;
    private static ServerCore core = null;
    private static String version = "";
    SimpleDateFormat dateFormat = null;
    boolean noLog = false;

    public static AccuServerAuditTrailLogger getInstance(ServerCore core) {
        if (thisInstance == null) {
            thisInstance = new AccuServerAuditTrailLogger(core);
        }
        return thisInstance;
    }

    public void setNoLog() {
        this.noLog = true;
    }

    public AccuServerAuditTrailLogger(ServerCore core) {
        try {
            AccuServerAuditTrailLogger.core = core;
            version = core.getVersion();
            this.dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss");
            boolean append = true;
            FileHandler handler = new FileHandler("accuServerAuditTrailLog.xml", 0x40000000, 200, append);
            handler.setFormatter(new AuditTrailFormatter());
            this.logger = Logger.getLogger("accuServerAuditTrailLog");
            this.logger.addHandler(handler);
            this.log("startup of audit trail logger, AccuSERVER version " + core.getVersion());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void log(String text) {
        this.logAuditTrail("Local", "AccuServer.AuditTrailLogger", text);
    }

    public void logAuditTrail(String from, String who, String what) {
        if (this.noLog) {
            return;
        }
        Date now = new Date();
        StringBuilder msg = new StringBuilder();
        msg.append(this.dateFormat.format(now) + "\t");
        msg.append("AccuServer Audit Log\t" + from + "\t" + who + "\t" + what + "\n");
        this.logger.info(msg.toString());
    }
}

