/*
 * Decompiled with CFR 0.152.
 */
package AccuServerMonitor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class PrinterSetupPanel
extends JPanel {
    Font font = null;
    Color textColor = Color.black;
    String printerType;
    String printerPOSName;
    String printerName;
    int panelWidth = 0;
    int panelHeight = 0;

    public PrinterSetupPanel(String printerType, String printerPOSName, String printerName, int width) {
        this.initComponents();
        this.font = new Font("Arial", 1, 12);
        this.printerType = printerType;
        this.printerPOSName = printerPOSName;
        this.printerName = printerName;
        this.panelWidth = width;
        JLabel myLabel = new JLabel();
        FontMetrics fontMetrics = myLabel.getFontMetrics(this.font);
        this.panelHeight = fontMetrics.getHeight() + 10;
        this.setPreferredSize(new Dimension(this.panelWidth, this.panelHeight));
        this.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Rectangle bounds = this.getBounds();
        double recHeight = bounds.height;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setFont(this.font);
        FontMetrics fm = g2.getFontMetrics();
        int textHeight = fm.getHeight();
        float fontFactor = (float)textHeight / 24.0f;
        float yPosition = (float)(recHeight - (double)textHeight) / 2.0f + 20.0f * fontFactor;
        g2.setColor(this.textColor);
        g2.drawString(this.printerType, 10.0f, yPosition);
        g2.drawString(this.printerPOSName, (float)((int)((double)this.panelWidth * 0.3)), yPosition);
        g2.drawString(this.printerName, (float)((int)((double)this.panelWidth * 0.6)), yPosition);
    }

    private void initComponents() {
        this.setBackground(new Color(255, 255, 255));
        this.setFont(new Font("Arial", 1, 14));
        this.setPreferredSize(new Dimension(100, 65));
        this.setLayout(new BorderLayout());
    }
}

