/*
 * Decompiled with CFR 0.152.
 */
package AccuServerTaxCalculator;

import POSDataObjects.LineItem;
import java.util.Hashtable;
import java.util.Vector;

public class GroupItemPriceAdjuster {
    public void updateGroupItemPrices(Vector lineItems) {
        double groupTotal;
        int i;
        Hashtable<Integer, Double> groups = new Hashtable<Integer, Double>();
        int len = lineItems.size();
        for (i = 0; i < len; ++i) {
            LineItem thisItem = (LineItem)lineItems.get(i);
            if (thisItem.masterItem != 0 || !thisItem.isBundle) continue;
            groupTotal = this.getGroupTotal(thisItem.id, lineItems);
            groups.put(thisItem.id, groupTotal);
        }
        if (!groups.isEmpty()) {
            block1: for (i = 0; i < len; ++i) {
                LineItem thisLine = (LineItem)lineItems.get(i);
                if (!groups.containsKey(thisLine.id) || !thisLine.isBundle) continue;
                groupTotal = (Double)groups.get(thisLine.id);
                if ((!thisLine.changedPrice.trim().isEmpty() || thisLine.isSalePrice) && !this.hasGroupLineItemChanged(thisLine.id, lineItems) || !thisLine.compReason.isEmpty()) {
                    double percentChange = thisLine.total / groupTotal;
                    double groupItemTotal = this.updateDetailLines(thisLine.id, lineItems, percentChange);
                    double totalDiff = thisLine.total - groupItemTotal;
                    if (!(totalDiff < -1.0E-4) && !(totalDiff > 1.0E-4)) continue;
                    for (int j = len - 1; j >= 0; --j) {
                        LineItem thisLineItem = (LineItem)lineItems.get(j);
                        if (thisLineItem.masterItem != thisLine.id || thisLineItem.status.equalsIgnoreCase("V")) continue;
                        thisLineItem.total += totalDiff;
                        thisLineItem.price = (double)Math.round(thisLineItem.total / thisLineItem.quantity * 100.0) / 100.0;
                        continue block1;
                    }
                    continue;
                }
                thisLine.total = groupTotal;
                thisLine.vatGross = groupTotal;
                thisLine.price = (double)Math.round(thisLine.total / thisLine.quantity * 100.0) / 100.0;
            }
        }
    }

    private double getGroupTotal(int masterId, Vector lineItems) {
        double groupTotal = 0.0;
        int len = lineItems.size();
        for (int i = 0; i < len; ++i) {
            LineItem thisItem = (LineItem)lineItems.get(i);
            if (thisItem.masterItem <= 0 || thisItem.masterItem != masterId || thisItem.status.equalsIgnoreCase("V")) continue;
            groupTotal += thisItem.total;
            groupTotal += this.getGroupTotal(thisItem.id, lineItems);
        }
        return groupTotal;
    }

    private double updateDetailLines(int masterId, Vector lineItems, double percentChange) {
        double detailTotal = 0.0;
        int len = lineItems.size();
        for (int j = 0; j < len; ++j) {
            LineItem thisLineItem = (LineItem)lineItems.get(j);
            if (thisLineItem.masterItem != masterId || thisLineItem.status.equalsIgnoreCase("V")) continue;
            thisLineItem.price = (double)Math.round(thisLineItem.price * percentChange * 100.0) / 100.0;
            thisLineItem.total = (double)Math.round(thisLineItem.quantity * thisLineItem.price * 100.0) / 100.0;
            detailTotal += thisLineItem.total;
            detailTotal += this.updateDetailLines(thisLineItem.id, lineItems, percentChange);
        }
        return detailTotal;
    }

    private boolean hasGroupLineItemChanged(int masterItemId, Vector lineItems) {
        boolean hasLineItemChange = false;
        int len = lineItems.size();
        for (int i = 0; i < len; ++i) {
            LineItem thisLine = (LineItem)lineItems.get(i);
            if (thisLine.masterItem != masterItemId || thisLine.status.equalsIgnoreCase("V")) continue;
            if (!thisLine.changedPrice.trim().isEmpty()) {
                hasLineItemChange = true;
                break;
            }
            if (!this.hasGroupLineItemChanged(thisLine.id, lineItems)) continue;
            hasLineItemChange = true;
            break;
        }
        return hasLineItemChange;
    }
}

