/*
 * Decompiled with CFR 0.152.
 */
package AccuServerWebServers;

import AccuServerBase.ReportObject;
import AccuServerBase.ServerCore;
import AccuServerWebServers.AccuServerWebServerNew;
import AccuServerWebServers.Controllers.ServerConfigurationController;
import POSDataObjects.CompanySetupInfo;
import POSDataObjects.Customer;
import POSDataObjects.Item;
import POSDataObjects.LineItem;
import POSDataObjects.POSDataContainer;
import POSDataObjects.Reset;
import POSDataObjects.Tender;
import POSDataObjects.TenderCode;
import POSDataObjects.Transaction;
import POSDataObjects.TransactionReportOptions;
import POSDataObjects.ValueAddedTax;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class MoveinReport
implements ReportObject {
    private ServerCore core;
    private SimpleDateFormat dateFormatMovinDat = new SimpleDateFormat("ddMMyy");
    private SimpleDateFormat dateFormatMovinDoc = new SimpleDateFormat("dd/MM/yyyy");
    private String tenderSummaryAccount;
    private Vector<JournalLine> summaryLines;
    private String cashSalesAccount = "\u05dc\u05e7\u05d5\u05d7\u05de\u05d6\u05d3\u05de\u05df";
    private String vatGlAccount;
    private double vatRate;
    private Timestamp fromDate;
    private Timestamp thruDate;
    private String reportFilename;
    private String reportsPath;
    private POSDataContainer resets;
    private POSDataContainer transactions;
    private boolean summerizeCashSales;

    public void initialize(ServerCore core, Socket socket, boolean export) {
        this.core = core;
        AccuServerWebServerNew webserver = (AccuServerWebServerNew)core.getWebServer();
        this.reportFilename = webserver.getReportPath() + webserver.getPathSeparator() + "movein.zip";
        this.reportsPath = webserver.getReportPath() + webserver.getPathSeparator();
    }

    public void setByReset(Reset reset) {
        this.fromDate = reset.start;
        this.thruDate = reset.end;
    }

    public void setByDates(Timestamp fromDate, Timestamp thruDate) {
        this.fromDate = fromDate;
        this.thruDate = thruDate;
    }

    public void loadData() {
        CompanySetupInfo companyInfo = this.core.getCompanySetup();
        this.tenderSummaryAccount = companyInfo.tenderSummaryAcct;
        this.vatGlAccount = companyInfo.vatGlAccount;
        ServerConfigurationController serverConfig = new ServerConfigurationController(null, this.core, null, "", null);
        this.vatGlAccount = serverConfig.getModuleParam("Settings", "HashavshevetVatGlAccount");
        this.cashSalesAccount = serverConfig.getModuleParam("Settings", "HashavshevetCashCustomerAccount");
        String summerizeCashSalesString = serverConfig.getModuleParam("Settings", "HashavshevetSummerizeCashSales");
        if (summerizeCashSalesString != null) {
            this.summerizeCashSales = summerizeCashSalesString.equalsIgnoreCase("true");
        }
        POSDataContainer vatCodes = this.core.getVatCodes();
        for (int i = 0; i < vatCodes.size(); ++i) {
            ValueAddedTax vatCode = (ValueAddedTax)vatCodes.get(i);
            if (!vatCode.code.equals("\u05de\u05e2\u05de")) continue;
            this.vatRate = vatCode.rate / 100.0;
        }
        this.resets = this.core.getResets();
        TransactionReportOptions options = new TransactionReportOptions();
        options.fromDate = this.fromDate;
        options.thruDate = this.thruDate;
        int resetsLen = this.resets.size();
        Collections.sort(this.resets, new SortResetByStartDate(false));
        this.transactions = this.core.getTransactionData(options);
        Collections.sort(this.transactions, new SortByTillSequence());
    }

    public String getReportFileName() {
        return this.reportFilename;
    }

    public boolean getReportHtml() {
        boolean success = false;
        try {
            int i;
            Customer customer;
            this.summaryLines = new Vector();
            Hashtable<String, Double> tenderTotals = new Hashtable<String, Double>();
            int lastSequence = 0;
            String lastTill = "";
            Hashtable<String, Double> incomeTotalExempt = new Hashtable<String, Double>();
            Hashtable<String, Double> incomeTotal = new Hashtable<String, Double>();
            POSDataContainer customers = new POSDataContainer();
            int transactionsCount = 0;
            for (int i2 = 0; i2 < this.transactions.size(); ++i2) {
                TenderCode tc;
                Tender thisTender;
                int j;
                Transaction thisTransaction = (Transaction)this.transactions.get(i2);
                String transactionTotal = String.format("%.2f", thisTransaction.total);
                thisTransaction.total = Double.valueOf(transactionTotal);
                if (thisTransaction.sequence == 0 || thisTransaction.total <= 0.01 && thisTransaction.total >= -0.01) continue;
                if (!this.summerizeCashSales) {
                    if (thisTransaction.customerCode != null && !thisTransaction.customerCode.isEmpty() && (customer = this.core.getCustomerByCode(thisTransaction.customerCode)) != null) {
                        customers.add((Object)customer);
                    }
                    this.addCustomerJournalLines(thisTransaction);
                    continue;
                }
                if (!(lastSequence == 0 || lastSequence == thisTransaction.sequence && lastTill.equals(thisTransaction.till))) {
                    this.addJournalLines(incomeTotal, incomeTotalExempt, tenderTotals, lastSequence, lastTill, transactionsCount, this.cashSalesAccount, "");
                    transactionsCount = 0;
                    incomeTotalExempt.clear();
                    incomeTotal.clear();
                    tenderTotals.clear();
                }
                ++transactionsCount;
                int tendLen = thisTransaction.tendering.size();
                boolean hasAR = false;
                boolean hasCP = false;
                for (j = 0; j < tendLen; ++j) {
                    thisTender = (Tender)thisTransaction.tendering.get(j);
                    tc = this.core.getTenderCode(thisTender.code);
                    if (tc.tenderType.equals("A")) {
                        hasAR = true;
                        continue;
                    }
                    if (!tc.tenderType.equals("Y")) continue;
                    hasCP = true;
                }
                if (hasAR || hasCP) {
                    this.addCustomerJournalLines(thisTransaction);
                    Customer customer2 = this.core.getCustomerByCode(thisTransaction.customerCode);
                    customers.add((Object)customer2);
                    continue;
                }
                for (j = 0; j < tendLen; ++j) {
                    thisTender = (Tender)thisTransaction.tendering.get(j);
                    tc = this.core.getTenderCode(thisTender.code);
                    if (thisTender.status.equals("V") || tc.tenderType.equals("A") || tc.tenderType.equals("Y")) continue;
                    if (tenderTotals.get(thisTender.code) != null) {
                        double thisTenderTotal = (Double)tenderTotals.get(thisTender.code);
                        tenderTotals.put(thisTender.code, thisTenderTotal + thisTender.amount);
                        continue;
                    }
                    tenderTotals.put(thisTender.code, thisTender.amount);
                }
                int lineItemsLen = thisTransaction.lineItems.size();
                for (int j2 = 0; j2 < lineItemsLen; ++j2) {
                    double total;
                    LineItem thisLineItem = (LineItem)thisTransaction.lineItems.get(j2);
                    if (thisLineItem.status.equals("V")) continue;
                    double thisItemTotal = thisLineItem.vatGross;
                    Item thisItem = this.core.getItemByCode(thisLineItem.itemId);
                    String glSalesAccount = thisItem.salesAccount;
                    if (thisLineItem.taxCode.equals("\u05de\u05e2\u05de")) {
                        if (incomeTotal.get(glSalesAccount) != null) {
                            total = (Double)incomeTotal.get(glSalesAccount);
                            incomeTotal.put(glSalesAccount, thisItemTotal + total);
                            continue;
                        }
                        incomeTotal.put(glSalesAccount, thisItemTotal);
                        continue;
                    }
                    if (!thisLineItem.taxCode.equals("\u05e4\u05d8\u05d5\u05e8")) continue;
                    if (incomeTotalExempt.get(glSalesAccount) != null) {
                        total = (Double)incomeTotalExempt.get(glSalesAccount);
                        incomeTotalExempt.put(glSalesAccount, thisItemTotal + total);
                        continue;
                    }
                    incomeTotalExempt.put(glSalesAccount, thisItemTotal);
                }
                lastSequence = thisTransaction.sequence;
                lastTill = thisTransaction.till;
            }
            if (this.summerizeCashSales) {
                this.addJournalLines(incomeTotal, incomeTotalExempt, tenderTotals, lastSequence, lastTill, transactionsCount, this.cashSalesAccount, "");
            }
            Hashtable<String, String> files = new Hashtable<String, String>();
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < this.summaryLines.size(); ++i) {
                sb.append(this.summaryLines.get(i).toMoveInDocLine());
            }
            files.put("movein.doc", sb.toString());
            files.put("movein.prm", this.generatePrm(this.getMovinPrmRecordsLen()));
            sb.setLength(0);
            for (i = 0; i < customers.size(); ++i) {
                customer = (Customer)customers.get(i);
                sb.append(this.toHeshInDatLine(customer));
            }
            sb.append(this.getCashCustomerLine());
            files.put("heshin.dat", sb.toString());
            files.put("heshin.prm", this.generatePrm(this.getHeshinPrmRecordsLen()));
            this.addFileToZip(files);
            success = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return success;
    }

    private void addCustomerJournalLines(Transaction thisTransaction) {
        Hashtable<String, Double> tenderTotals = new Hashtable<String, Double>();
        Hashtable<String, Double> incomeTotal = new Hashtable<String, Double>();
        Hashtable<String, Double> incomeTotalExempt = new Hashtable<String, Double>();
        int tendLen = thisTransaction.tendering.size();
        String customerCode = thisTransaction.customerCode;
        if (customerCode == null || customerCode.isEmpty()) {
            customerCode = this.cashSalesAccount;
        }
        String tenderType = "";
        for (int j = 0; j < tendLen; ++j) {
            Tender thisTender = (Tender)thisTransaction.tendering.get(j);
            TenderCode tc = this.core.getTenderCode(thisTender.code);
            if (thisTender.status.equals("V")) continue;
            if (tc.tenderType.equals("A") || tc.tenderType.equals("Y")) {
                tenderType = tc.tenderType;
                continue;
            }
            if (tenderTotals.get(thisTender.code) != null) {
                double thisTenderTotal = (Double)tenderTotals.get(thisTender.code);
                tenderTotals.put(thisTender.code, thisTenderTotal + thisTender.amount);
                continue;
            }
            tenderTotals.put(thisTender.code, thisTender.amount);
        }
        int lineItemsLen = thisTransaction.lineItems.size();
        for (int j = 0; j < lineItemsLen; ++j) {
            double total;
            LineItem thisLineItem = (LineItem)thisTransaction.lineItems.get(j);
            if (thisLineItem.status.equals("V")) continue;
            double thisItemTotal = thisLineItem.vatGross;
            Item thisItem = this.core.getItemByCode(thisLineItem.itemId);
            String glSalesAccount = thisItem.salesAccount;
            if (thisLineItem.taxCode.equals("\u05de\u05e2\u05de")) {
                if (incomeTotal.get(glSalesAccount) != null) {
                    total = (Double)incomeTotal.get(glSalesAccount);
                    incomeTotal.put(glSalesAccount, thisItemTotal + total);
                    continue;
                }
                incomeTotal.put(glSalesAccount, thisItemTotal);
                continue;
            }
            if (!thisLineItem.taxCode.equals("\u05e4\u05d8\u05d5\u05e8")) continue;
            if (incomeTotalExempt.get(glSalesAccount) != null) {
                total = (Double)incomeTotalExempt.get(glSalesAccount);
                incomeTotalExempt.put(glSalesAccount, thisItemTotal + total);
                continue;
            }
            incomeTotalExempt.put(glSalesAccount, thisItemTotal);
        }
        this.addJournalLines(incomeTotal, incomeTotalExempt, tenderTotals, thisTransaction.sequence, thisTransaction.till, thisTransaction.invoice, customerCode, tenderType);
    }

    private void addJournalLines(Hashtable incomeTotal, Hashtable incomeTotalExempt, Hashtable tenderTotals, int lastSequence, String lastTill, long ref1, String customerAccount, String tenderType) {
        Reset reset;
        JournalLine summary;
        double thisTotal;
        String thisAccount;
        Enumeration accounts = incomeTotal.keys();
        while (accounts.hasMoreElements()) {
            thisAccount = (String)accounts.nextElement();
            thisTotal = (Double)incomeTotal.get(thisAccount);
            summary = new JournalLine();
            summary.reference1 = ref1;
            reset = this.core.getReset(lastTill, lastSequence);
            summary.reference1Date = reset.start;
            summary.reference2 = lastSequence;
            summary.dateEntered = reset.start;
            summary.details = "\u05d4\u05db.\u05d7\u05d9\u05d9\u05d1\u05d5\u05ea ";
            summary.details = summary.details + " Z" + lastSequence + " " + lastTill;
            summary.debitAccount1 = thisAccount;
            summary.debitAccount2 = this.vatGlAccount;
            summary.debitTotal1 = thisTotal / (1.0 + this.vatRate);
            summary.debitTotal2 = summary.debitTotal1 * this.vatRate;
            summary.creditAccount1 = customerAccount;
            summary.creditTotal1 = thisTotal;
            this.summaryLines.add(summary);
        }
        accounts = incomeTotalExempt.keys();
        while (accounts.hasMoreElements()) {
            thisAccount = (String)accounts.nextElement();
            thisTotal = (Double)incomeTotalExempt.get(thisAccount);
            summary = new JournalLine();
            summary.reference1 = ref1;
            reset = this.core.getReset(lastTill, lastSequence);
            summary.reference1Date = reset.start;
            summary.reference2 = lastSequence;
            summary.dateEntered = reset.start;
            summary.details = "\u05d4\u05db. \u05e4\u05d8\u05d5\u05e8\u05d5\u05ea";
            summary.details = summary.details + " Z" + lastSequence + " " + lastTill;
            summary.debitAccount1 = thisAccount;
            summary.debitTotal1 = thisTotal;
            summary.creditAccount1 = customerAccount;
            summary.creditTotal1 = thisTotal;
            this.summaryLines.add(summary);
        }
        Enumeration tenderCodes = tenderTotals.keys();
        while (tenderCodes.hasMoreElements()) {
            String thisTenderCode = (String)tenderCodes.nextElement();
            double thisTotal2 = (Double)tenderTotals.get(thisTenderCode);
            TenderCode tender = this.core.getTenderCode(thisTenderCode);
            JournalLine summary2 = new JournalLine();
            summary2.moveType = "";
            summary2.reference1 = ref1;
            Reset reset2 = this.core.getReset(lastTill, lastSequence);
            summary2.reference1Date = reset2.start;
            summary2.reference2 = lastSequence;
            summary2.dateEntered = reset2.start;
            summary2.details = "Z" + lastSequence + " " + lastTill + " ";
            summary2.details = summary2.details + tender.description;
            summary2.debitAccount1 = customerAccount;
            summary2.debitTotal1 = thisTotal2;
            summary2.creditAccount1 = tender.glAccount;
            summary2.creditTotal1 = thisTotal2;
            this.summaryLines.add(summary2);
        }
    }

    String toHeshInDatLine(Customer customer) {
        String line = "";
        line = line + String.format("%1$-15s", customer.code);
        String name = customer.first + " " + customer.last;
        line = line + String.format("%1$-50s", name.trim());
        line = line + String.format("%1$-30s", customer.phone);
        String address = customer.address1;
        if (!customer.address2.isEmpty()) {
            address = address + ", " + customer.address2;
        }
        line = line + String.format("%1$-50s", address.trim());
        line = line + String.format("%1$-20s", customer.city);
        line = line + String.format("%1$-5s", customer.zip);
        line = line + String.format("%1$-50s", customer.note);
        line = line + String.format("%1$-12s", String.format("%.3f", customer.creditLimit));
        line = line + String.format("%1$-12s", String.format("%.3f", customer.balance));
        line = line + String.format("%1$-12s", String.format("%.3f", customer.discountPercent * 100.0));
        line = line + String.format("%1$-50s", customer.email);
        line = line + String.format("%1$-30s", customer.fax);
        line = line + String.format("%1$-20s", customer.state);
        String exemptVat = "0";
        if (customer.taxCode.equals("\u05de\u05e2\u05de")) {
            exemptVat = "1";
        }
        line = line + String.format("%1$-1s", exemptVat);
        line = line + "\r\n";
        return line;
    }

    String getCashCustomerLine() {
        Customer customer = new Customer();
        customer.code = this.cashSalesAccount;
        customer.first = "\u05dc\u05e7\u05d5\u05d7 \u05de\u05d6\u05d3\u05de\u05df";
        return this.toHeshInDatLine(customer);
    }

    String generatePrm(int[] recordsLen) {
        String text = "";
        int position = 1;
        for (int i = 2; i < recordsLen.length; ++i) {
            if (recordsLen[i] != 0) {
                text = text + position;
                text = text + " " + (position += recordsLen[i] - 1) + "\r\n";
                ++position;
                continue;
            }
            text = text + "0 0\r\n";
        }
        text = ++position + "\r\n" + text;
        return text;
    }

    int[] getHeshinPrmRecordsLen() {
        int[] recordsLen = new int[70];
        recordsLen[2] = 15;
        recordsLen[3] = 50;
        recordsLen[6] = 30;
        recordsLen[7] = 50;
        recordsLen[9] = 20;
        recordsLen[10] = 5;
        recordsLen[13] = 50;
        recordsLen[20] = 12;
        recordsLen[22] = 12;
        recordsLen[24] = 5;
        return recordsLen;
    }

    int[] getMovinPrmRecordsLen() {
        int[] recordsLen = new int[35];
        recordsLen[2] = 3;
        recordsLen[3] = 9;
        recordsLen[4] = 9;
        recordsLen[5] = 10;
        recordsLen[6] = 10;
        recordsLen[7] = 0;
        recordsLen[8] = 0;
        recordsLen[9] = 50;
        recordsLen[10] = 15;
        recordsLen[11] = 15;
        recordsLen[12] = 15;
        recordsLen[13] = 15;
        recordsLen[14] = 12;
        recordsLen[15] = 12;
        recordsLen[16] = 12;
        recordsLen[17] = 12;
        return recordsLen;
    }

    String limitStringLength(String text, int maxLength) {
        if (text.length() > maxLength) {
            text = text.substring(0, maxLength);
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileToZip(Hashtable files) {
        ZipOutputStream out = null;
        try {
            File f = new File(this.reportFilename);
            out = new ZipOutputStream(new FileOutputStream(f));
            Enumeration fileNames = files.keys();
            while (fileNames.hasMoreElements()) {
                String fileName = (String)fileNames.nextElement();
                String text = (String)files.get(fileName);
                ZipEntry e = new ZipEntry(fileName);
                out.putNextEntry(e);
                byte[] data = text.getBytes("ISO8859_8");
                out.write(data, 0, data.length);
            }
            out.closeEntry();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFileNoAppend(String fileName, String text) {
        Writer fw = null;
        try {
            fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName, false), "ISO8859_8"));
            fw.write(text);
            fw.close();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    class JournalLine {
        String moveType = "";
        long reference1;
        Timestamp reference1Date;
        int reference2;
        Timestamp dateEntered;
        String currencyCode = "";
        String pricingCode = "";
        String details = "";
        String creditAccount1;
        String creditAccount2 = "";
        String debitAccount1;
        String debitAccount2 = "";
        double creditTotal1;
        double creditTotal2;
        double debitTotal1;
        double debitTotal2;
        double foreignCurrencyCreditTotal1;
        double foreignCurrencycreditTotal2;
        double foreignCurrencydebitTotal1;
        double foreignCurrencydebitTotal2;
        String reference3Date = "";
        String reference3 = "";
        String quantity = "";
        String file = "";
        String moreDetails = "";
        String moreDetails2 = "";
        String branch = "";
        String taxId = "";

        JournalLine() {
        }

        String toMoveInDatLine() {
            String line = "";
            line = line + String.format("%1$-3s", this.moveType);
            line = line + String.format("%1$-5s", this.reference1);
            line = line + String.format("%1$-6s", MoveinReport.this.dateFormatMovinDat.format(this.reference1Date));
            line = line + String.format("%1$-5s", this.reference2);
            line = line + String.format("%1$-6s", MoveinReport.this.dateFormatMovinDat.format(this.dateEntered));
            line = line + String.format("%1$-3s", "$");
            if (this.details.length() > 22) {
                this.details = this.details.substring(0, 21);
            }
            line = line + String.format("%1$-22s", this.details.replaceAll(" ", "_"));
            line = line + String.format("%1$-8s", MoveinReport.this.limitStringLength(this.creditAccount1, 8));
            line = line + String.format("%1$-8s", MoveinReport.this.limitStringLength(this.creditAccount2, 8));
            line = line + String.format("%1$-8s", MoveinReport.this.limitStringLength(this.debitAccount1, 8));
            line = line + String.format("%1$-8s", MoveinReport.this.limitStringLength(this.debitAccount2, 8));
            line = line + String.format("%1$-12s", String.format("%.3f", this.creditTotal1));
            line = line + String.format("%1$-12s", String.format("%.3f", this.creditTotal2));
            line = line + String.format("%1$-12s", String.format("%.3f", this.debitTotal1));
            line = line + String.format("%1$-12s", String.format("%.3f", this.debitTotal2));
            line = line + String.format("%1$-12s", 0.0);
            line = line + String.format("%1$-12s", 0.0);
            line = line + String.format("%1$-12s", 0.0);
            line = line + String.format("%1$-12s", 0.0);
            line = line + "\r\n";
            return line;
        }

        String toMoveInDocLine() {
            String line = "";
            line = line + String.format("%1$-3s", this.moveType);
            line = line + String.format("%1$-9s", this.reference1);
            line = line + String.format("%1$-9s", this.reference2);
            line = line + String.format("%1$-10s", MoveinReport.this.dateFormatMovinDoc.format(this.reference1Date));
            line = line + String.format("%1$-10s", MoveinReport.this.dateFormatMovinDoc.format(this.dateEntered));
            line = line + String.format("%1$-50s", MoveinReport.this.limitStringLength(this.details, 50));
            line = line + String.format("%1$-15s", MoveinReport.this.limitStringLength(this.creditAccount1, 15));
            line = line + String.format("%1$-15s", MoveinReport.this.limitStringLength(this.creditAccount2, 15));
            line = line + String.format("%1$-15s", MoveinReport.this.limitStringLength(this.debitAccount1, 15));
            line = line + String.format("%1$-15s", MoveinReport.this.limitStringLength(this.debitAccount2, 15));
            line = line + String.format("%1$-12s", String.format("%.2f", this.creditTotal1));
            line = line + String.format("%1$-12s", String.format("%.2f", this.creditTotal2));
            line = line + String.format("%1$-12s", String.format("%.2f", this.debitTotal1));
            line = line + String.format("%1$-12s", String.format("%.2f", this.debitTotal2));
            line = line + "\r\n";
            return line;
        }
    }

    class SortByTillSequence
    implements Comparator {
        SortByTillSequence() {
        }

        public int compare(Object obj1, Object obj2) {
            Transaction trans1 = (Transaction)obj1;
            Transaction trans2 = (Transaction)obj2;
            int compareResult = trans1.till.compareTo(trans2.till);
            if (compareResult != 0) {
                return compareResult;
            }
            if (trans1.sequence > trans2.sequence) {
                return 1;
            }
            if (trans1.sequence < trans2.sequence) {
                return -1;
            }
            return 0;
        }
    }

    class SortResetByStartDate
    implements Comparator {
        private boolean descending;

        public SortResetByStartDate(boolean descending) {
            this.descending = descending;
        }

        public int compare(Object obj1, Object obj2) {
            Reset reset1 = (Reset)obj1;
            Reset reset2 = (Reset)obj2;
            if (reset1.start == null || reset2.start == null) {
                return 0;
            }
            if (this.descending) {
                return reset2.start.compareTo(reset1.start);
            }
            return reset1.start.compareTo(reset2.start);
        }
    }
}

