/*
 * Decompiled with CFR 0.152.
 */
package DataHandlers;

import AccuServerBase.OnlineOrdersHandlerBase;
import AccuServerBase.ServerCore;
import AccuServerBase.ServerObject;
import AccuServerBase.Utility;
import POSDataObjects.Customer;
import POSDataObjects.Item;
import POSDataObjects.ItemChoice;
import POSDataObjects.LineItem;
import POSDataObjects.Order;
import POSDataObjects.POSDataContainer;
import POSDataObjects.Tax;
import POSDataObjects.Tender;
import POSDataObjects.TenderCode;
import POSDataObjects.Till;
import POSDataObjects.User;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Random;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WoltDataHandler
implements ServerObject,
OnlineOrdersHandlerBase {
    ServerCore core = null;
    String url = "https://merchant-api.wolt.com/v2/purchases";
    int timeOut = 10000;
    String till = "Wolt";
    String posUser = "Wolt";
    boolean debug = false;
    int retryMinutes = 5;
    Timer ordersDownloadTimer = null;
    String token = "";
    boolean isFullDayFetch = true;
    Calendar lastTimeChecked = null;
    final TimeZone utcTimezone = TimeZone.getTimeZone("UTC");
    final SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private boolean inProgress = false;
    private boolean useOldApi = false;

    public void initialize(ServerCore core, Hashtable parameters) {
        String tillText;
        String retryMinutesText;
        String testText;
        String debugText;
        this.core = core;
        this.verifyHandlerData();
        String timeOutText = (String)parameters.get("TimeOut");
        if (timeOutText != null && !timeOutText.isEmpty()) {
            try {
                this.timeOut = Integer.parseInt(timeOutText);
            }
            catch (NumberFormatException numberFormatException) {
                this.timeOut = 10000;
            }
        }
        if ((debugText = (String)parameters.get("Debug")) != null && !debugText.isEmpty()) {
            try {
                this.debug = Boolean.parseBoolean(debugText);
            }
            catch (Exception e) {
                this.debug = false;
            }
        }
        if ((testText = (String)parameters.get("Test")) != null && !testText.isEmpty() && testText.equalsIgnoreCase("true")) {
            this.url = "https://merchant-api.creditornot.com/v2/purchases";
        }
        if ((retryMinutesText = (String)parameters.get("RetryMinutes")) != null && !retryMinutesText.isEmpty()) {
            try {
                this.retryMinutes = Integer.parseInt(retryMinutesText);
            }
            catch (Exception e) {
                this.retryMinutes = 5;
            }
        }
        if ((tillText = (String)parameters.get("Till")) != null && !tillText.isEmpty()) {
            this.till = tillText;
        }
        this.token = (String)parameters.get("Token");
        String useOldApiText = (String)parameters.get("UseOldApi");
        if (useOldApiText != null && !useOldApiText.isEmpty()) {
            try {
                this.useOldApi = Boolean.parseBoolean(useOldApiText);
            }
            catch (Exception e) {
                this.useOldApi = false;
            }
        }
        if (this.useOldApi && (this.token == null || this.token.isEmpty())) {
            core.input("Token not found.\nClosing Wolt Data Handler!");
            return;
        }
        if (this.useOldApi) {
            core.input(core.getLiteral("Wolt Data Handler Retry set to ") + this.retryMinutes + " " + core.getLiteral("minutes"));
            this.ordersDownloadTimer = new Timer();
            this.retryMinutes = this.retryMinutes * 60 * 1000;
            this.ordersDownloadTimer.schedule((TimerTask)new OrdersDownloadTimer(), 10000L, (long)this.retryMinutes);
        }
        this.datetimeFormat.setTimeZone(this.utcTimezone);
        core.setWoltDataHandler((OnlineOrdersHandlerBase)this);
        core.input(core.getLiteral("Wolt Data Handler Successfully Started"));
    }

    private void verifyHandlerData() {
        Item item;
        Till till;
        while (this.core.isBlockLogin()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.core.getUser(this.posUser) == null) {
            Random random = new Random();
            int password = random.nextInt(100000000) + 10000000;
            User user = new User(this.posUser, password + "", "ADMIN", 0L, this.till);
            POSDataContainer users = this.core.getUserList();
            users.add((Object)user);
            this.core.updateUsers(users);
        }
        if (this.core.getTenderCode("WO") == null) {
            TenderCode tc = new TenderCode("WO", this.posUser, "H", "", this.posUser, false, 0.0, "", "", "", "");
            this.core.updateTenderCode(tc);
        }
        if ((till = this.core.getTillByName(this.till)) == null || !till.name.equals(this.till)) {
            till = new Till();
            till.active = true;
            till.name = this.till;
            this.core.updateTill(till);
        }
        POSDataContainer itemsList = new POSDataContainer();
        if (this.core.getItemByCode("UndefinedChoice") == null) {
            item = new Item();
            item.code = "UndefinedChoice";
            item.description = "Undefined Choice";
            item.type = "";
            item.changed = true;
            itemsList.add((Object)item);
            this.core.updateItemsCache(item, false);
        }
        if (this.core.getItemByCode("Undefined") == null) {
            item = new Item();
            item.code = "Undefined";
            item.description = "Undefined";
            item.type = "";
            item.changed = true;
            itemsList.add((Object)item);
            this.core.updateItemsCache(item, false);
        }
        if (this.core.getItemByCode("Delivery") == null) {
            item = new Item();
            item.code = "Delivery";
            item.description = "Delivery";
            item.type = "";
            item.changed = true;
            itemsList.add((Object)item);
            this.core.updateItemsCache(item, false);
        }
        if (itemsList.size() > 0) {
            this.core.saveAllItems(itemsList, true);
        }
    }

    private JSONObject sendHttpGet(int timeout, boolean verbose, String params) throws IOException, NoSuchAlgorithmException, KeyManagementException, JSONException {
        if (verbose) {
            System.out.println("URL: " + this.url + params);
        }
        OutputStream ostream = null;
        BufferedReader istream = null;
        ByteArrayOutputStream baos = null;
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, null, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            URL theUrl = new URL(this.url + params);
            System.out.println("Attempting to connect ");
            HttpsURLConnection conn = (HttpsURLConnection)theUrl.openConnection();
            System.out.println("Connected ");
            conn.setReadTimeout(timeout);
            conn.setConnectTimeout(timeout);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("accept", "application/json");
            conn.setRequestProperty("Authorization", "Bearer " + this.token);
            istream = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            StringBuilder replyText = new StringBuilder();
            do {
                String reply = istream.readLine();
                replyText.append(reply);
            } while (istream.ready());
            String sResult = replyText.toString();
            if (verbose) {
                System.out.println("Receive from host:\r\n" + sResult);
            }
            JSONObject jSONObject = new JSONObject(sResult);
            return jSONObject;
        }
        catch (NoSuchAlgorithmException ex) {
            throw ex;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (istream != null) {
                    istream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ostream != null) {
                    ostream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private JSONObject sendHttpGetOrder(int timeout, boolean verbose, String url, String apiKey) throws IOException, NoSuchAlgorithmException, KeyManagementException, JSONException {
        OutputStream ostream = null;
        BufferedReader reader = null;
        ByteArrayOutputStream baos = null;
        String sResult = "";
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, null, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            URL theUrl = new URL(url);
            System.out.println("Attempting to connect ");
            HttpsURLConnection conn = (HttpsURLConnection)theUrl.openConnection();
            System.out.println("Connected ");
            conn.setReadTimeout(timeout);
            conn.setConnectTimeout(timeout);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("accept", "application/json");
            conn.setRequestProperty("WOLT-API-KEY", apiKey);
            int status = conn.getResponseCode();
            if (status == 200) {
                int readLen;
                reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                int contentLength = conn.getHeaderFieldInt("Content-Length", 0);
                StringBuilder postBody = new StringBuilder();
                int totalReadLen = 0;
                do {
                    char[] buffer;
                    if ((readLen = reader.read(buffer = new char[1024])) <= 0) continue;
                    totalReadLen += readLen;
                    postBody.append(buffer, 0, readLen);
                } while (totalReadLen < contentLength && readLen != -1 || contentLength == 0 && readLen != -1);
                sResult = postBody.toString();
                if (verbose) {
                    System.out.println("Receive from host:\r\n" + sResult);
                }
            }
            JSONObject jSONObject = new JSONObject(sResult);
            return jSONObject;
        }
        catch (NoSuchAlgorithmException ex) {
            throw ex;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ostream != null) {
                    ostream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean setOrderStatus(int i, String string) {
        return true;
    }

    public void orderNotice(String notice) {
        try {
            String jsonNoticeString = Utility.getElement((String)"Data", (String)notice);
            String woltApiKey = Utility.getElement((String)"WoltId", (String)notice);
            if (!jsonNoticeString.isEmpty()) {
                int jsonStartIdx = jsonNoticeString.indexOf("{");
                int jsonEndIdx = jsonNoticeString.lastIndexOf("}");
                jsonNoticeString = jsonNoticeString.substring(jsonStartIdx, jsonEndIdx + 1);
                JSONObject jsonNotice = new JSONObject(jsonNoticeString);
                JSONObject jsonNoticeOrder = jsonNotice.getJSONObject("order");
                String url = jsonNoticeOrder.getString("resource_url");
                JSONObject jsonOrder = this.sendHttpGetOrder(this.timeOut, false, url, woltApiKey);
                this.processWoltOrder(jsonOrder);
            }
        }
        catch (Exception e) {
            this.core.logText("Could not receive Wolt order. \n" + e.getMessage() + "\n" + notice);
            this.output("Could not receive Wolt order. \n" + e.getMessage() + "\n" + notice);
        }
    }

    public void output(String output) {
        System.out.println(output);
        if (this.debug) {
            this.core.input(output);
        }
    }

    public String fixQuotes(String requestString) {
        String editedString = requestString.replaceAll("\"", "\\\\\"");
        return editedString;
    }

    public void getOpenOrders() {
        block45: {
            JSONArray purchasesList = new JSONArray();
            JSONObject response = new JSONObject();
            try {
                String getParams;
                if (this.isFullDayFetch) {
                    String startTime = this.getStartOfThisDay();
                    String endTime = this.getEndOfThisDay();
                    String filterBy = "&statuses=production,ready,delivered,rejected";
                    getParams = "?start_time=" + startTime + "&end_time=" + endTime + filterBy;
                    this.output(getParams);
                } else {
                    String lastModified = this.getLastModifed();
                    getParams = "?last_modified_at=" + lastModified;
                    this.output(getParams);
                }
                response = this.sendHttpGet(30000, false, getParams);
                if (response.has("purchases")) {
                    if (!this.isFullDayFetch) {
                        this.lastTimeChecked.add(14, this.retryMinutes);
                    }
                    this.isFullDayFetch = false;
                    purchasesList = response.getJSONArray("purchases");
                }
                this.output("Wolt Get Open Orders Response Data: " + response);
            }
            catch (Exception e) {
                this.core.input("Error Requesting Wolt Open Orders");
                this.core.input("Exception:" + e.toString() + " " + response);
                return;
            }
            try {
                if (purchasesList == null || purchasesList.length() <= 0) break block45;
                int numPurchases = purchasesList.length();
                this.core.input("Processing " + numPurchases + " Wolt Orders...");
                for (int p = 0; p < numPurchases; ++p) {
                    String firstName;
                    JSONObject thisPurchase = purchasesList.getJSONObject(p);
                    String createdString = thisPurchase.getString("created_at");
                    String[] split = createdString.split("\\.");
                    createdString = split[0] + "Z";
                    JSONObject delivery = thisPurchase.getJSONObject("delivery");
                    String deliveryType = delivery.getString("type");
                    String orderStatus = thisPurchase.getString("order_status");
                    String comment = "";
                    if (thisPurchase.has("consumer_comment") && !thisPurchase.isNull("consumer_comment")) {
                        comment = thisPurchase.getString("consumer_comment");
                        comment = comment.replace("\n", " ");
                    }
                    Customer remoteOrderCustomer = new Customer();
                    remoteOrderCustomer.first = firstName = thisPurchase.getString("consumer_name");
                    remoteOrderCustomer.code = firstName;
                    remoteOrderCustomer.deliveryNotes = comment;
                    String orderId = "Wolt " + thisPurchase.getString("order_number");
                    Order existingOrder = this.getExistingOrder(orderId, remoteOrderCustomer.code);
                    if (existingOrder != null) {
                        if (orderStatus.equals("production") || orderStatus.equals("ready") || orderStatus.equals("delivered")) {
                            this.output("Remote Order: " + orderId + " - has already been imported\r\n");
                            continue;
                        }
                        if (orderStatus.equals("rejected") || orderStatus.equals("refunded")) {
                            if (existingOrder.status.equals("Rejected")) continue;
                            this.core.setOnlineOrderStatus(existingOrder.orderNumber, orderId, this.posUser, "Reject");
                            continue;
                        }
                    } else if (!orderStatus.equals("production") && !orderStatus.equals("ready") && !orderStatus.equals("delivered")) continue;
                    JSONArray items = thisPurchase.getJSONArray("items");
                    if (this.debug) {
                        this.output("Processing Remote Order: " + orderId + "\r\n");
                    }
                    int nextLineNumber = 1;
                    Order newOrder = new Order();
                    newOrder.orderId = orderId;
                    long created = this.datetimeFormat.parse(createdString).getTime();
                    newOrder.created = new Timestamp(created);
                    newOrder.nextLineNumber = nextLineNumber;
                    if (deliveryType.equals("homedelivery")) {
                        newOrder.delivery = true;
                        newOrder.carryOut = false;
                    } else if (deliveryType.equals("takeaway")) {
                        newOrder.delivery = false;
                        newOrder.carryOut = true;
                    } else if (deliveryType.equals("eatin")) {
                        newOrder.delivery = false;
                        newOrder.carryOut = false;
                    }
                    newOrder.displayOnRemote = true;
                    boolean saved = false;
                    if (remoteOrderCustomer.code != null && !remoteOrderCustomer.code.isEmpty()) {
                        saved = this.core.updateCustomer(remoteOrderCustomer);
                    }
                    if (saved) {
                        newOrder.customer = remoteOrderCustomer;
                    }
                    Vector<Object> newLineItems = new Vector<Object>();
                    int numLines = 0;
                    if (items != null && items.length() > 0) {
                        numLines = items.length();
                        for (int i = 0; i < numLines; ++i) {
                            String taxCode;
                            JSONObject thisLine = items.getJSONObject(i);
                            String itemId = "";
                            try {
                                itemId = thisLine.optString("pos_id");
                            }
                            catch (Exception ex) {
                                this.output(this.core.getLiteral("Error Importing Wolt Open Order - #") + orderId + " " + this.core.getLiteral("Item Id not received - Setting to Undefined"));
                                itemId = "Undefined";
                            }
                            String description = thisLine.getString("name");
                            JSONObject basePrice = thisLine.getJSONObject("base_price");
                            double price = basePrice.getInt("amount");
                            price /= 100.0;
                            double itemQty = thisLine.getDouble("count");
                            Item thisItem = this.core.getItemByCode(itemId);
                            if (thisItem == null) {
                                this.output(this.core.getLiteral("Error Importing Wolt Open Order - #") + " " + this.core.getLiteral("Item Id") + " " + itemId + " " + this.core.getLiteral("not found - Setting to Undefined"));
                                thisItem = this.core.getItemByCode("Undefined");
                                if (thisItem == null) {
                                    this.output("Error Importing Wolt Open Order - #" + orderId + " Item: " + itemId + " not found");
                                    continue;
                                }
                                itemId = "Undefined";
                            }
                            if ((taxCode = this.core.getCarryOutTaxCode()) == null || taxCode.isEmpty()) {
                                taxCode = thisItem.vatCode;
                            }
                            double priceWithVatRemoved = this.core.getPriceWithVatRemoved(price, taxCode);
                            LineItem newLineItem = new LineItem();
                            newLineItem.itemId = itemId;
                            newLineItem.itemDescription = description;
                            newLineItem.price = price;
                            newLineItem.quantity = itemQty;
                            newLineItem.displayOnRemote = true;
                            newLineItem.altDescription = thisItem.alternateDescription;
                            newLineItem.list = thisItem.list;
                            newLineItem.originalPrice = thisItem.price;
                            if (newLineItem.tax == null) {
                                newLineItem.tax = new Tax();
                            }
                            newLineItem.tax.taxable = thisItem.taxable;
                            newLineItem.taxable = thisItem.taxable;
                            newLineItem.isAppetizer = thisItem.isAppetizer;
                            newLineItem.itemType = thisItem.type;
                            newLineItem.noPartialQuantity = thisItem.noPartialQuantity;
                            newLineItem.carryOut = !newOrder.delivery;
                            newLineItem.userId = this.posUser;
                            newLineItem.total = newLineItem.quantity * priceWithVatRemoved;
                            newLineItem.vatGross = newLineItem.quantity * price;
                            newLineItem.vatTax1 = (double)Math.round((newLineItem.vatGross - priceWithVatRemoved * Math.abs(newLineItem.quantity)) * 1000.0) / 1000.0;
                            newLineItem.created = new Date().getTime() + (long)newOrder.nextLineNumber;
                            ++newOrder.nextLineNumber;
                            newLineItem.changedPrice = "Wolt";
                            JSONArray choices = thisLine.getJSONArray("options");
                            Vector<ItemChoice> newChoices = new Vector<ItemChoice>();
                            Vector<LineItem> newOptionalItems = new Vector<LineItem>();
                            if (choices != null && choices.length() > 0) {
                                int numChoices = choices.length();
                                for (int c = 0; c < numChoices; ++c) {
                                    ItemChoice newItemChoice;
                                    JSONObject thisChoice = choices.getJSONObject(c);
                                    String thisChoiceId = "";
                                    try {
                                        thisChoiceId = thisChoice.optString("value_pos_id");
                                    }
                                    catch (Exception ex) {
                                        this.output(this.core.getLiteral("Error Importing Wolt Open Order - #") + orderId + " " + this.core.getLiteral("Choice Item Id not received - Setting to UndefinedChoice"));
                                        thisChoiceId = "UndefinedChoice";
                                    }
                                    String thisChoiceDescription = thisChoice.getString("value");
                                    JSONObject choicePrice = thisChoice.getJSONObject("price");
                                    double thisChoicePrice = choicePrice.optDouble("amount");
                                    double thisChoiceQty = thisChoice.getDouble("count");
                                    if ((thisChoicePrice /= 100.0) == 0.0) {
                                        newItemChoice = new ItemChoice();
                                        newItemChoice.itemCode = thisChoiceId;
                                        newItemChoice.display = thisChoiceDescription;
                                        newItemChoice.text = thisChoiceDescription;
                                        newItemChoice.cr = true;
                                        newChoices.add(newItemChoice);
                                        continue;
                                    }
                                    newItemChoice = new ItemChoice();
                                    newItemChoice.itemCode = "";
                                    newItemChoice.display = thisChoiceDescription;
                                    newItemChoice.text = thisChoiceDescription;
                                    newItemChoice.cr = true;
                                    newChoices.add(newItemChoice);
                                    LineItem newOptionalItem = new LineItem();
                                    Item thisOptionalItem = this.core.getItemByCode(thisChoiceId);
                                    if (thisOptionalItem == null) {
                                        this.output(this.core.getLiteral("Error Importing Wolt Open Order - #") + " " + this.core.getLiteral("Choice Item Id") + " " + thisChoiceId + " " + this.core.getLiteral("not found - Setting to UndefinedChoice"));
                                        thisOptionalItem = this.core.getItemByCode("UndefinedChoice");
                                        if (thisOptionalItem == null) {
                                            this.output("Error Importing Wolt Open Order - #" + orderId + " Optional Item: " + thisChoiceId + " not found");
                                            continue;
                                        }
                                        thisChoiceId = "UndefinedChoice";
                                    }
                                    if ((taxCode = this.core.getCarryOutTaxCode()) == null || taxCode.isEmpty()) {
                                        taxCode = thisItem.vatCode;
                                    }
                                    double optionalItemPriceWithVatRemoved = this.core.getPriceWithVatRemoved(thisChoicePrice, taxCode);
                                    newOptionalItem.itemId = thisChoiceId;
                                    newOptionalItem.itemDescription = thisChoiceDescription;
                                    newOptionalItem.price = thisChoicePrice;
                                    newOptionalItem.quantity = thisChoiceQty * itemQty;
                                    newOptionalItem.displayOnRemote = true;
                                    newOptionalItem.altDescription = thisOptionalItem.alternateDescription;
                                    newOptionalItem.list = thisOptionalItem.list;
                                    newOptionalItem.originalPrice = thisOptionalItem.price;
                                    if (newOptionalItem.tax == null) {
                                        newOptionalItem.tax = new Tax();
                                    }
                                    newOptionalItem.tax.taxable = thisOptionalItem.taxable;
                                    newOptionalItem.taxable = thisOptionalItem.taxable;
                                    newOptionalItem.isAppetizer = thisOptionalItem.isAppetizer;
                                    newOptionalItem.itemType = thisOptionalItem.type;
                                    newOptionalItem.noPartialQuantity = thisOptionalItem.noPartialQuantity;
                                    newOptionalItem.carryOut = !newOrder.delivery;
                                    newOptionalItem.userId = this.posUser;
                                    newOptionalItem.total = newOptionalItem.quantity * optionalItemPriceWithVatRemoved;
                                    newOptionalItem.vatGross = newOptionalItem.quantity * thisChoicePrice;
                                    newOptionalItem.vatTax1 = (double)Math.round((newOptionalItem.vatGross - optionalItemPriceWithVatRemoved * Math.abs(newOptionalItem.quantity)) * 1000.0) / 1000.0;
                                    newOptionalItem.created = new Date().getTime() + (long)newOrder.nextLineNumber;
                                    ++newOrder.nextLineNumber;
                                    newOptionalItem.changedPrice = "Wolt";
                                    newOptionalItems.add(newOptionalItem);
                                }
                            }
                            newLineItem.choices = newChoices;
                            newLineItems.add(newLineItem);
                            if (newOptionalItems == null || newOptionalItems.isEmpty()) continue;
                            newLineItems.addAll(newOptionalItems);
                        }
                    }
                    boolean numCharges = false;
                    if (!delivery.isNull("fee")) {
                        JSONObject deliveryFee = delivery.getJSONObject("fee");
                        double chargeAmount = deliveryFee.getDouble("amount");
                        double chargeQty = 0.0;
                        String chargeItemId = "";
                        chargeItemId = "Delivery";
                        chargeAmount /= 100.0;
                        chargeQty = 1.0;
                        Item thisChargeItem = this.core.getItemByCode(chargeItemId);
                        if (thisChargeItem == null && (thisChargeItem = this.core.getItemByCode("Undefined")) == null) {
                            this.output("Error Importing Wolt Open Order - #" + orderId + " Item: " + chargeItemId + " not found");
                            continue;
                        }
                        LineItem newChargeLineItem = new LineItem();
                        newChargeLineItem.itemId = chargeItemId;
                        String taxCode = this.core.getCarryOutTaxCode();
                        if (taxCode == null || taxCode.isEmpty()) {
                            taxCode = thisChargeItem.vatCode;
                        }
                        double chargeItemPriceWithVatRemoved = this.core.getPriceWithVatRemoved(chargeAmount, taxCode);
                        newChargeLineItem.itemDescription = thisChargeItem.description;
                        newChargeLineItem.price = chargeAmount;
                        newChargeLineItem.quantity = chargeQty;
                        newChargeLineItem.noDiscount = true;
                        newChargeLineItem.displayOnRemote = true;
                        newChargeLineItem.altDescription = thisChargeItem.alternateDescription;
                        newChargeLineItem.list = thisChargeItem.list;
                        newChargeLineItem.originalPrice = thisChargeItem.price;
                        if (newChargeLineItem.tax == null) {
                            newChargeLineItem.tax = new Tax();
                        }
                        newChargeLineItem.tax.taxable = thisChargeItem.taxable;
                        newChargeLineItem.taxable = thisChargeItem.taxable;
                        newChargeLineItem.isAppetizer = thisChargeItem.isAppetizer;
                        newChargeLineItem.itemType = thisChargeItem.type;
                        newChargeLineItem.noPartialQuantity = thisChargeItem.noPartialQuantity;
                        newChargeLineItem.carryOut = !newOrder.delivery;
                        newChargeLineItem.userId = this.posUser;
                        newChargeLineItem.total = newChargeLineItem.quantity * chargeItemPriceWithVatRemoved;
                        newChargeLineItem.vatGross = newChargeLineItem.quantity * chargeAmount;
                        newChargeLineItem.vatTax1 = (double)Math.round((newChargeLineItem.vatGross - chargeItemPriceWithVatRemoved * Math.abs(newChargeLineItem.quantity)) * 1000.0) / 1000.0;
                        newChargeLineItem.created = new Date().getTime() + (long)newOrder.nextLineNumber;
                        newChargeLineItem.changedPrice = "Wolt";
                        newLineItems.add(newChargeLineItem);
                    }
                    newOrder.lineItems = newLineItems;
                    newOrder.user = this.posUser;
                    if (this.debug) {
                        String lineItemIds = "itemIds:";
                        for (int i = 0; i < newLineItems.size(); ++i) {
                            LineItem li = (LineItem)newLineItems.get(i);
                            lineItemIds = lineItemIds + " " + li.itemId;
                        }
                        this.output(lineItemIds);
                    }
                    String savedOrderXml = this.core.saveEMVOrder(newOrder.user, this.till, newOrder.toXml());
                    newOrder = new Order(savedOrderXml, true);
                    String resultXml = "";
                    JSONObject totalPrice = thisPurchase.getJSONObject("price");
                    double amount = totalPrice.optDouble("amount");
                    Tender newTender = new Tender();
                    newTender.amount = amount /= 100.0;
                    newTender.description = "Wolt";
                    newTender.approval = "";
                    newTender.newTender = true;
                    newTender.code = "WL";
                    newTender.user = this.posUser;
                    resultXml = this.core.processOtherTender(this.posUser, this.till, newOrder.toXml(), newTender.code, amount, "", created, "");
                    String orderXml = Utility.getElement((String)"Order", (String)resultXml);
                    if (orderXml == null || orderXml.isEmpty()) continue;
                    Order currentOrder = new Order(orderXml, true);
                    currentOrder.status = "Accepted";
                    this.tenderAdded(currentOrder, orderId);
                }
            }
            catch (Exception e) {
                this.output(e.toString());
                e.printStackTrace();
                this.core.raiseException(e);
            }
        }
        this.output("Wolt Get Open Orders Completed");
    }

    public void processWoltOrder(JSONObject thisPurchase) {
        String orderId = "Wolt 0";
        String orderUniqueId = "";
        try {
            String firstName;
            this.core.input("Starting to Precess Wolt Order");
            orderUniqueId = thisPurchase.getString("id");
            String createdString = thisPurchase.getString("created_at");
            String[] split = createdString.split("\\.");
            createdString = split[0] + "Z";
            JSONObject delivery = thisPurchase.getJSONObject("delivery");
            String deliveryType = delivery.getString("type");
            String orderStatus = thisPurchase.getString("order_status");
            String comment = "";
            if (thisPurchase.has("consumer_comment") && !thisPurchase.isNull("consumer_comment")) {
                comment = thisPurchase.getString("consumer_comment");
                comment = comment.replace("\n", " ");
            }
            Customer remoteOrderCustomer = new Customer();
            remoteOrderCustomer.first = firstName = thisPurchase.getString("consumer_name");
            remoteOrderCustomer.code = firstName;
            remoteOrderCustomer.deliveryNotes = comment;
            orderId = "Wolt " + thisPurchase.getString("order_number");
            Order existingOrder = this.getExistingOrder(orderId, remoteOrderCustomer.code);
            if (existingOrder != null) {
                if (orderStatus.equals("production") || orderStatus.equals("ready") || orderStatus.equals("delivered")) {
                    this.output("Remote Order: " + orderId + " - has already been imported\r\n");
                    return;
                }
                if (orderStatus.equals("rejected") || orderStatus.equals("refunded")) {
                    if (!existingOrder.status.equals("Rejected")) {
                        this.core.setOnlineOrderStatus(existingOrder.orderNumber, orderId, this.posUser, "Reject");
                    }
                    return;
                }
            } else if (!(orderStatus.equals("production") || orderStatus.equals("ready") || orderStatus.equals("delivered"))) {
                return;
            }
            JSONArray items = thisPurchase.getJSONArray("items");
            if (this.debug) {
                this.output("Processing Remote Order: " + orderId + "\r\n");
            }
            int nextLineNumber = 1;
            Order newOrder = new Order();
            newOrder.orderId = orderId;
            long created = this.datetimeFormat.parse(createdString).getTime();
            newOrder.created = new Timestamp(created);
            newOrder.nextLineNumber = nextLineNumber;
            if (deliveryType.equals("homedelivery")) {
                newOrder.delivery = true;
                newOrder.carryOut = false;
            } else if (deliveryType.equals("takeaway")) {
                newOrder.delivery = false;
                newOrder.carryOut = true;
            } else if (deliveryType.equals("eatin")) {
                newOrder.delivery = false;
                newOrder.carryOut = false;
            }
            newOrder.displayOnRemote = true;
            boolean saved = false;
            if (remoteOrderCustomer.code != null && !remoteOrderCustomer.code.isEmpty()) {
                saved = this.core.updateCustomer(remoteOrderCustomer);
            }
            if (saved) {
                newOrder.customer = remoteOrderCustomer;
            }
            Vector<Object> newLineItems = new Vector<Object>();
            int numLines = 0;
            if (items != null && items.length() > 0) {
                numLines = items.length();
                for (int i = 0; i < numLines; ++i) {
                    String taxCode;
                    JSONObject thisLine = items.getJSONObject(i);
                    String itemId = "";
                    try {
                        itemId = thisLine.optString("pos_id");
                    }
                    catch (Exception ex) {
                        this.output(this.core.getLiteral("Error Importing Wolt Open Order - #") + orderId + " " + this.core.getLiteral("Item Id not received - Setting to Undefined"));
                        itemId = "Undefined";
                    }
                    String description = thisLine.getString("name");
                    JSONObject basePrice = thisLine.getJSONObject("base_price");
                    double price = basePrice.getInt("amount");
                    price /= 100.0;
                    double itemQty = thisLine.getDouble("count");
                    Item thisItem = this.core.getItemByCode(itemId);
                    if (thisItem == null) {
                        this.output(this.core.getLiteral("Error Importing Wolt Open Order - #") + " " + this.core.getLiteral("Item Id") + " " + itemId + " " + this.core.getLiteral("not found - Setting to Undefined"));
                        thisItem = this.core.getItemByCode("Undefined");
                        if (thisItem == null) {
                            this.output("Error Importing Wolt Open Order - #" + orderId + " Item: " + itemId + " not found");
                            continue;
                        }
                        itemId = "Undefined";
                    }
                    if ((taxCode = this.core.getCarryOutTaxCode()) == null || taxCode.isEmpty()) {
                        taxCode = thisItem.vatCode;
                    }
                    double priceWithVatRemoved = this.core.getPriceWithVatRemoved(price, taxCode);
                    LineItem newLineItem = new LineItem();
                    newLineItem.itemId = itemId;
                    newLineItem.itemDescription = description;
                    newLineItem.price = price;
                    newLineItem.quantity = itemQty;
                    newLineItem.displayOnRemote = true;
                    newLineItem.altDescription = thisItem.alternateDescription;
                    newLineItem.list = thisItem.list;
                    newLineItem.originalPrice = thisItem.price;
                    if (newLineItem.tax == null) {
                        newLineItem.tax = new Tax();
                    }
                    newLineItem.tax.taxable = thisItem.taxable;
                    newLineItem.taxable = thisItem.taxable;
                    newLineItem.isAppetizer = thisItem.isAppetizer;
                    newLineItem.itemType = thisItem.type;
                    newLineItem.noPartialQuantity = thisItem.noPartialQuantity;
                    newLineItem.carryOut = !newOrder.delivery;
                    newLineItem.userId = this.posUser;
                    newLineItem.total = newLineItem.quantity * priceWithVatRemoved;
                    newLineItem.vatGross = newLineItem.quantity * price;
                    newLineItem.vatTax1 = (double)Math.round((newLineItem.vatGross - priceWithVatRemoved * Math.abs(newLineItem.quantity)) * 1000.0) / 1000.0;
                    newLineItem.created = new Date().getTime() + (long)newOrder.nextLineNumber;
                    ++newOrder.nextLineNumber;
                    newLineItem.changedPrice = "Wolt";
                    JSONArray choices = thisLine.getJSONArray("options");
                    Vector<ItemChoice> newChoices = new Vector<ItemChoice>();
                    Vector<LineItem> newOptionalItems = new Vector<LineItem>();
                    if (choices != null && choices.length() > 0) {
                        int numChoices = choices.length();
                        for (int c = 0; c < numChoices; ++c) {
                            ItemChoice newItemChoice;
                            JSONObject thisChoice = choices.getJSONObject(c);
                            String thisChoiceId = "";
                            try {
                                thisChoiceId = thisChoice.optString("value_pos_id");
                            }
                            catch (Exception ex) {
                                this.output(this.core.getLiteral("Error Importing Wolt Open Order - #") + orderId + " " + this.core.getLiteral("Choice Item Id not received - Setting to UndefinedChoice"));
                                thisChoiceId = "UndefinedChoice";
                            }
                            String thisChoiceDescription = thisChoice.getString("value");
                            JSONObject choicePrice = thisChoice.getJSONObject("price");
                            double thisChoicePrice = choicePrice.optDouble("amount");
                            double thisChoiceQty = thisChoice.getDouble("count");
                            if ((thisChoicePrice /= 100.0) == 0.0) {
                                newItemChoice = new ItemChoice();
                                newItemChoice.itemCode = thisChoiceId;
                                newItemChoice.display = thisChoiceDescription;
                                newItemChoice.text = thisChoiceDescription;
                                newItemChoice.cr = true;
                                newChoices.add(newItemChoice);
                                continue;
                            }
                            newItemChoice = new ItemChoice();
                            newItemChoice.itemCode = "";
                            newItemChoice.display = thisChoiceDescription;
                            newItemChoice.text = thisChoiceDescription;
                            newItemChoice.cr = true;
                            newChoices.add(newItemChoice);
                            LineItem newOptionalItem = new LineItem();
                            Item thisOptionalItem = this.core.getItemByCode(thisChoiceId);
                            if (thisOptionalItem == null) {
                                this.output(this.core.getLiteral("Error Importing Wolt Open Order - #") + " " + this.core.getLiteral("Choice Item Id") + " " + thisChoiceId + " " + this.core.getLiteral("not found - Setting to UndefinedChoice"));
                                thisOptionalItem = this.core.getItemByCode("UndefinedChoice");
                                if (thisOptionalItem == null) {
                                    this.output("Error Importing Wolt Open Order - #" + orderId + " Optional Item: " + thisChoiceId + " not found");
                                    continue;
                                }
                                thisChoiceId = "UndefinedChoice";
                            }
                            if ((taxCode = this.core.getCarryOutTaxCode()) == null || taxCode.isEmpty()) {
                                taxCode = thisItem.vatCode;
                            }
                            double optionalItemPriceWithVatRemoved = this.core.getPriceWithVatRemoved(thisChoicePrice, taxCode);
                            newOptionalItem.itemId = thisChoiceId;
                            newOptionalItem.itemDescription = thisChoiceDescription;
                            newOptionalItem.price = thisChoicePrice;
                            newOptionalItem.quantity = thisChoiceQty * itemQty;
                            newOptionalItem.displayOnRemote = true;
                            newOptionalItem.altDescription = thisOptionalItem.alternateDescription;
                            newOptionalItem.list = thisOptionalItem.list;
                            newOptionalItem.originalPrice = thisOptionalItem.price;
                            if (newOptionalItem.tax == null) {
                                newOptionalItem.tax = new Tax();
                            }
                            newOptionalItem.tax.taxable = thisOptionalItem.taxable;
                            newOptionalItem.taxable = thisOptionalItem.taxable;
                            newOptionalItem.isAppetizer = thisOptionalItem.isAppetizer;
                            newOptionalItem.itemType = thisOptionalItem.type;
                            newOptionalItem.noPartialQuantity = thisOptionalItem.noPartialQuantity;
                            newOptionalItem.carryOut = !newOrder.delivery;
                            newOptionalItem.userId = this.posUser;
                            newOptionalItem.total = newOptionalItem.quantity * optionalItemPriceWithVatRemoved;
                            newOptionalItem.vatGross = newOptionalItem.quantity * thisChoicePrice;
                            newOptionalItem.vatTax1 = (double)Math.round((newOptionalItem.vatGross - optionalItemPriceWithVatRemoved * Math.abs(newOptionalItem.quantity)) * 1000.0) / 1000.0;
                            newOptionalItem.created = new Date().getTime() + (long)newOrder.nextLineNumber;
                            ++newOrder.nextLineNumber;
                            newOptionalItem.changedPrice = "Wolt";
                            newOptionalItems.add(newOptionalItem);
                        }
                    }
                    newLineItem.choices = newChoices;
                    newLineItems.add(newLineItem);
                    if (newOptionalItems == null || newOptionalItems.isEmpty()) continue;
                    newLineItems.addAll(newOptionalItems);
                }
            }
            boolean numCharges = false;
            if (!delivery.isNull("fee")) {
                JSONObject deliveryFee = delivery.getJSONObject("fee");
                double chargeAmount = deliveryFee.getDouble("amount");
                double chargeQty = 0.0;
                String chargeItemId = "";
                chargeItemId = "Delivery";
                chargeAmount /= 100.0;
                chargeQty = 1.0;
                Item thisChargeItem = this.core.getItemByCode(chargeItemId);
                if (thisChargeItem == null && (thisChargeItem = this.core.getItemByCode("Undefined")) == null) {
                    this.output("Error Importing Wolt Open Order - #" + orderId + " Item: " + chargeItemId + " not found");
                    return;
                }
                LineItem newChargeLineItem = new LineItem();
                newChargeLineItem.itemId = chargeItemId;
                String taxCode = this.core.getCarryOutTaxCode();
                if (taxCode == null || taxCode.isEmpty()) {
                    taxCode = thisChargeItem.vatCode;
                }
                double chargeItemPriceWithVatRemoved = this.core.getPriceWithVatRemoved(chargeAmount, taxCode);
                newChargeLineItem.itemDescription = thisChargeItem.description;
                newChargeLineItem.price = chargeAmount;
                newChargeLineItem.quantity = chargeQty;
                newChargeLineItem.noDiscount = true;
                newChargeLineItem.displayOnRemote = true;
                newChargeLineItem.altDescription = thisChargeItem.alternateDescription;
                newChargeLineItem.list = thisChargeItem.list;
                newChargeLineItem.originalPrice = thisChargeItem.price;
                if (newChargeLineItem.tax == null) {
                    newChargeLineItem.tax = new Tax();
                }
                newChargeLineItem.tax.taxable = thisChargeItem.taxable;
                newChargeLineItem.taxable = thisChargeItem.taxable;
                newChargeLineItem.isAppetizer = thisChargeItem.isAppetizer;
                newChargeLineItem.itemType = thisChargeItem.type;
                newChargeLineItem.noPartialQuantity = thisChargeItem.noPartialQuantity;
                newChargeLineItem.carryOut = !newOrder.delivery;
                newChargeLineItem.userId = this.posUser;
                newChargeLineItem.total = newChargeLineItem.quantity * chargeItemPriceWithVatRemoved;
                newChargeLineItem.vatGross = newChargeLineItem.quantity * chargeAmount;
                newChargeLineItem.vatTax1 = (double)Math.round((newChargeLineItem.vatGross - chargeItemPriceWithVatRemoved * Math.abs(newChargeLineItem.quantity)) * 1000.0) / 1000.0;
                newChargeLineItem.created = new Date().getTime() + (long)newOrder.nextLineNumber;
                newChargeLineItem.changedPrice = "Wolt";
                newLineItems.add(newChargeLineItem);
            }
            newOrder.lineItems = newLineItems;
            newOrder.user = this.posUser;
            if (this.debug) {
                String lineItemIds = "itemIds:";
                for (int i = 0; i < newLineItems.size(); ++i) {
                    LineItem li = (LineItem)newLineItems.get(i);
                    lineItemIds = lineItemIds + " " + li.itemId;
                }
                this.output(lineItemIds);
            }
            JSONObject totalPrice = thisPurchase.getJSONObject("price");
            double amount = totalPrice.optDouble("amount");
            Tender newTender = new Tender();
            newTender.amount = amount /= 100.0;
            newTender.description = "Wolt";
            newTender.approval = "";
            newTender.newTender = true;
            newTender.code = "WL";
            newTender.user = this.posUser;
            newOrder.tenderings = new Vector();
            newOrder.tenderings.add(newTender);
            boolean result = this.core.invoiceOrder(newOrder.toXml(), newOrder.user, this.till, "", "");
            if (!result) {
                this.output("Error Invoicing Wolt Order - Order Id:" + newOrder.orderId);
            }
            this.core.logText(orderId + " Completed Processing.");
        }
        catch (Exception e) {
            String message = "Error Occoured While Processing " + orderId + "Order\nUnique order id: " + orderUniqueId;
            this.core.logText(message);
            this.core.addToLog(message);
            this.output(e.toString());
            e.printStackTrace();
            this.core.raiseException(e);
        }
    }

    public void tenderAdded(Order currentOrder, String orderId) {
        boolean result;
        double balance = (double)Math.round((currentOrder.total - this.getTenderTotal(currentOrder)) * 100.0) / 100.0;
        boolean hasChange = false;
        if (balance < -0.009 && currentOrder.total > 1.0E-4) {
            hasChange = true;
        }
        if ((balance > -1.0E-4 && balance < 1.0E-4 || balance < 1.0E-4 && hasChange) && !(result = this.core.invoiceOrder(currentOrder.toXml(), currentOrder.user, currentOrder.shift, "", ""))) {
            this.output("Error Invoicing Wolt Order - Order Id:" + currentOrder.orderId);
        }
    }

    public double getTenderTotal(Order currentOrder) {
        double result = 0.0;
        if (currentOrder != null && currentOrder.tenderings != null) {
            int len = currentOrder.tenderings.size();
            for (int i = 0; i < len; ++i) {
                Tender thisTender = (Tender)currentOrder.tenderings.get(i);
                result += thisTender.amount;
            }
        }
        return result;
    }

    Order getExistingOrder(String orderId, String customerCode) {
        Order order = null;
        Vector orders = this.core.getOrdersByOrderId(orderId);
        if (orders != null && !orders.isEmpty()) {
            int len = orders.size();
            long now = System.currentTimeMillis();
            long month = 2592000000L;
            long lastMonth = now - month;
            for (int i = 0; i < len; ++i) {
                Order thisOrder = (Order)orders.get(i);
                if (thisOrder.created.getTime() <= lastMonth || !thisOrder.customer.code.equals(customerCode)) continue;
                order = thisOrder;
                break;
            }
        }
        return order;
    }

    private String getEndOfThisDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        String dateString = this.datetimeFormat.format(calendar.getTime());
        return dateString;
    }

    private String getStartOfThisDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        String dateString = this.datetimeFormat.format(calendar.getTime());
        return dateString;
    }

    private String getLastModifed() {
        Calendar cal = null;
        if (this.lastTimeChecked == null) {
            this.lastTimeChecked = Calendar.getInstance();
        }
        cal = (Calendar)this.lastTimeChecked.clone();
        cal.add(14, -1 * (this.retryMinutes + 1000));
        String dateString = this.datetimeFormat.format(cal.getTime());
        return dateString;
    }

    class OrdersDownloadTimer
    extends TimerTask {
        OrdersDownloadTimer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (!WoltDataHandler.this.core.isBlockLogin() && !WoltDataHandler.this.inProgress) {
                    WoltDataHandler.this.inProgress = true;
                    WoltDataHandler.this.getOpenOrders();
                }
            }
            catch (Exception e) {
                WoltDataHandler.this.core.raiseException(e);
            }
            finally {
                WoltDataHandler.this.inProgress = false;
            }
        }
    }
}

