/*
 * Decompiled with CFR 0.152.
 */
package DataHandlers;

import AccuServerBase.OnlineOrdersHandlerBase;
import AccuServerBase.ServerCore;
import AccuServerBase.ServerObject;
import AccuServerBase.Utility;
import POSDataObjects.CompanySetupInfo;
import POSDataObjects.Customer;
import POSDataObjects.Item;
import POSDataObjects.ItemChoice;
import POSDataObjects.LineItem;
import POSDataObjects.Order;
import POSDataObjects.POSDataContainer;
import POSDataObjects.Tax;
import POSDataObjects.Tender;
import POSDataObjects.TenderCode;
import POSDataObjects.Till;
import POSDataObjects.User;
import POSDataObjects.ValueAddedTax;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WooCommerceDataHandler
implements ServerObject,
OnlineOrdersHandlerBase {
    String baseURL = "";
    boolean debug = true;
    private String authBase64;
    private ServerCore core;
    final DecimalFormat decimal = new DecimalFormat("####0.00##;-####0.00##");
    Hashtable itemRefTable = new Hashtable();
    String posUser = "WooCommerce";
    String till = "WooCommerce";
    String tenderCode = "WC";
    Timer ordersDownloadTimer = null;
    long retryMiliseconds;
    Timestamp startDate;
    boolean useWebhook = false;
    boolean isFoodService;
    CompanySetupInfo companyInfo;
    boolean test = false;

    public void initialize(ServerCore core, Hashtable parameters) {
        String testText;
        String apiSecretText;
        String apiKeyText;
        this.core = core;
        String key = "";
        String secret = "";
        String siteUrlText = (String)parameters.get("SiteUrl");
        if (siteUrlText != null && !siteUrlText.isEmpty()) {
            this.baseURL = siteUrlText.startsWith("http://") || siteUrlText.startsWith("https://") ? siteUrlText : "https://" + siteUrlText;
        }
        if ((apiKeyText = (String)parameters.get("ApiKey")) != null && !apiKeyText.isEmpty()) {
            key = apiKeyText;
        }
        if ((apiSecretText = (String)parameters.get("ApiSecret")) != null && !apiSecretText.isEmpty()) {
            secret = apiSecretText;
        }
        String userAndPassword = key + ":" + secret;
        this.authBase64 = new String(Base64.encode(userAndPassword.getBytes()));
        String debugText = (String)parameters.get("Debug");
        if (debugText != null && !debugText.isEmpty()) {
            try {
                this.debug = Boolean.parseBoolean(debugText);
            }
            catch (Exception e) {
                this.debug = false;
            }
        }
        if ((testText = (String)parameters.get("Test")) != null && !testText.isEmpty()) {
            try {
                this.test = Boolean.parseBoolean(testText);
            }
            catch (Exception e) {
                this.test = false;
            }
        }
        this.isFoodService = !core.getRemoveFoodService();
        this.verifyHandlerData();
        String retryMinutesText = (String)parameters.get("WooRetryMinutes");
        int retryMinutes = 1;
        if (retryMinutesText != null && !retryMinutesText.isEmpty()) {
            try {
                retryMinutes = Integer.parseInt(retryMinutesText);
            }
            catch (Exception e) {
                retryMinutes = 5;
            }
        }
        this.companyInfo = core.getCompanySetup();
        this.retryMiliseconds = retryMinutes * 60 * 1000;
        if (!this.useWebhook) {
            this.ordersDownloadTimer = new Timer();
            this.ordersDownloadTimer.schedule((TimerTask)new OrdersDownloadTimer(), 10000L, this.retryMiliseconds);
        }
    }

    private void verifyHandlerData() {
        Item item;
        Till till;
        while (this.core.isBlockLogin()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (this.core.getUser(this.posUser) == null) {
            Random random = new Random();
            int password = random.nextInt(100000000) + 10000000;
            User user = new User(this.posUser, password + "", "ADMIN", 0L, this.till);
            POSDataContainer users = this.core.getUserList();
            users.add((Object)user);
            this.core.updateUsers(users);
        }
        if (this.core.getTenderCode(this.tenderCode) == null) {
            TenderCode tc = new TenderCode(this.tenderCode, "WooCom", "H", "", this.posUser, false, 0.0, "", "", "", "");
            this.core.updateTenderCode(tc);
        }
        if ((till = this.core.getTillByName(this.till)) == null || !till.name.equals(this.till)) {
            till = new Till();
            till.active = true;
            till.name = this.till;
            this.core.updateTill(till);
        }
        POSDataContainer itemsList = new POSDataContainer();
        if (this.core.getItemByCode("UndefinedChoice") == null) {
            item = new Item();
            item.code = "UndefinedChoice";
            item.description = this.core.getLiteral("Undefined Choice");
            item.type = "General Item";
            item.changed = true;
            itemsList.add((Object)item);
            this.core.updateItemsCache(item, false);
        }
        if (this.core.getItemByCode("Undefined") == null) {
            item = new Item();
            item.code = "Undefined";
            item.description = this.core.getLiteral("Undefined");
            item.type = this.core.getLiteral("General Item");
            item.changed = true;
            itemsList.add((Object)item);
            this.core.updateItemsCache(item, false);
        }
        if (this.core.getItemByCode("Delivery") == null) {
            item = new Item();
            item.code = "Delivery";
            item.description = this.core.getLiteral("Delivery");
            item.type = this.core.getLiteral("General Item");
            item.changed = true;
            itemsList.add((Object)item);
            this.core.updateItemsCache(item, false);
        }
        if (this.core.getItemByCode("Fee") == null) {
            item = new Item();
            item.code = "Fee";
            item.description = this.core.getLiteral("Fee");
            item.type = this.core.getLiteral("General Item");
            item.changed = true;
            itemsList.add((Object)item);
            this.core.updateItemsCache(item, false);
        }
        if (itemsList.size() > 0) {
            this.core.saveAllItems(itemsList, true);
        }
    }

    void exportItems() {
        POSDataContainer itemList = this.core.getItemList();
        int len = itemList.size();
        JSONArray newItemsToExport = new JSONArray();
        try {
            for (int i = 0; i < len; ++i) {
                Item item = (Item)itemList.get(i);
                Integer id = (Integer)this.itemRefTable.get(item.code);
                if (id != null) continue;
                JSONObject itemJson = new JSONObject();
                itemJson.put("sku", (Object)item.code);
                itemJson.put("name", (Object)item.description);
                if (item.itemExtended != null) {
                    itemJson.put("description", (Object)item.itemExtended.detailedDescription);
                }
                itemJson.put("short_description", (Object)item.description);
                itemJson.put("regular_price", (Object)this.decimal.format(item.price));
                if (item.isStock) {
                    itemJson.put("manage_stock", true);
                }
                if (!item.taxable) {
                    itemJson.put("tax_status", (Object)"none");
                }
                JSONObject category = new JSONObject();
                category.put("name", (Object)item.type);
                JSONArray categories = new JSONArray();
                categories.put((Object)category);
                itemJson.put("categories", (Object)categories);
                newItemsToExport.put((Object)itemJson);
            }
            JSONObject json = new JSONObject();
            json.put("create", (Object)newItemsToExport);
            JSONArray responseJson = this.sendRequest("/wp-json/wc/v3/products/batch", "POST", json.toString());
            JSONArray createdItemList = responseJson.getJSONObject(0).getJSONArray("create");
            int createdLen = createdItemList.length();
            for (int i = 0; i < createdLen; ++i) {
                JSONObject itemJson = createdItemList.getJSONObject(i);
                int id = itemJson.getInt("id");
                String itemCode = itemJson.getString("sku");
                Item item = this.core.getItemByCode(itemCode);
                if (item == null) continue;
                this.itemRefTable.put(itemCode, id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void updateSiteStock() {
        JSONArray newItemsToExport = new JSONArray();
        try {
            POSDataContainer orders = this.core.getLiveAccountingUpdateOrders(this.startDate);
            int len = orders.size();
            for (int i = 0; i < len; ++i) {
                Order order = (Order)orders.get(i);
                int itemsLine = order.lineItems.size();
                for (int j = 0; j < itemsLine; ++j) {
                    LineItem lineItem = (LineItem)order.lineItems.get(j);
                    Item item = this.core.getItemByCode(lineItem.itemId);
                    JSONObject itemJson = new JSONObject();
                    itemJson.put("sku", (Object)item.code);
                    itemJson.put("name", (Object)item.description);
                    if (item.itemExtended != null) {
                        itemJson.put("description", (Object)item.itemExtended.detailedDescription);
                    }
                    itemJson.put("short_description", (Object)item.description);
                    itemJson.put("price", (Object)this.decimal.format(item.price));
                    JSONObject category = new JSONObject();
                    category.put("name", (Object)item.type);
                    JSONArray categories = new JSONArray();
                    categories.put((Object)category);
                    itemJson.put("categories", (Object)categories);
                    newItemsToExport.put((Object)itemJson);
                }
            }
            JSONObject json = new JSONObject();
            json.put("update", (Object)newItemsToExport);
            this.sendRequest("/wp-json/wc/v3/products/batch", "POST", json.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void getAllItems() {
        this.core.input("Getting all itmes from WooCommerce...");
        JSONArray response = this.sendRequest("/wp-json/wc/v3/products?status=publish", "GET", "");
        int len = response.length();
        POSDataContainer items = new POSDataContainer();
        for (int i = 0; i < len; ++i) {
            try {
                JSONObject itemJson = response.getJSONObject(i);
                int id = itemJson.getInt("id");
                String sku = itemJson.getString("sku");
                Item item = this.core.getItemByCode(sku);
                if (item == null) {
                    item = new Item();
                    item.code = sku;
                }
                item.description = itemJson.getString("name");
                String price = itemJson.getString("price");
                if (price != null && !price.isEmpty()) {
                    item.price = Double.valueOf(price);
                }
                item.price1 = item.price;
                item.price2 = item.price;
                item.price3 = item.price;
                item.price4 = item.price;
                item.price5 = item.price;
                if (!sku.isEmpty()) {
                    this.itemRefTable.put(sku, id);
                }
                item.imported = true;
                item.changed = true;
                item.updated = new Timestamp(System.currentTimeMillis());
                items.add((Object)item);
                continue;
            }
            catch (JSONException e) {
                this.output("skipping item");
            }
        }
        if (items.size() > 0) {
            this.core.saveAllItems(items, true);
        }
    }

    void exportVatCodes() {
        JSONArray vatCodesToExport = new JSONArray();
        POSDataContainer vatCodes = this.core.getVatCodes();
        String country = this.core.getCountry();
        int len = vatCodes.size();
        for (int i = 0; i < len; ++i) {
            ValueAddedTax vatCode = (ValueAddedTax)vatCodes.get(i);
            try {
                JSONObject json = new JSONObject();
                json.put("country", (Object)country);
                json.put("rate", vatCode.rate);
                json.put("name", (Object)vatCode.code);
                vatCodesToExport.put((Object)json);
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        JSONObject json = new JSONObject();
        try {
            json.put("create", (Object)vatCodesToExport);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.sendRequest("/wp-json/wc/v3/taxes/batch", "POST", json.toString());
    }

    void saveNewOrder(JSONObject remoteOrder) throws JSONException, ParseException {
        JSONObject shippingLine;
        String methodId;
        Timestamp created;
        String createdString = remoteOrder.getString("date_created");
        String orderId = "WC" + remoteOrder.getString("number");
        if (this.orderExists(orderId)) {
            this.core.input("Remote Order: " + orderId + " - has already been imported\r\n");
            return;
        }
        JSONArray items = remoteOrder.getJSONArray("line_items");
        JSONObject shippingAddressJSON = remoteOrder.getJSONObject("shipping");
        this.core.input("Processing Remote Order: " + orderId + "\r\n");
        int nextLineNumber = 1;
        Order newOrder = new Order();
        newOrder.taxCode = this.companyInfo.salesTaxCode;
        newOrder.orderId = orderId;
        createdString = createdString.replace("T", " ");
        newOrder.created = created = Timestamp.valueOf(createdString);
        newOrder.nextLineNumber = nextLineNumber;
        JSONArray shippingLines = remoteOrder.getJSONArray("shipping_lines");
        JSONObject billing = remoteOrder.getJSONObject("billing");
        String shippingType = null;
        if (billing.has("shipping_type")) {
            shippingType = billing.getString("shipping_type");
        }
        if (shippingType != null) {
            if (shippingType.equals("\u05de\u05e9\u05dc\u05d5\u05d7")) {
                newOrder.delivery = true;
                newOrder.carryOut = false;
            } else if (shippingType.equals("\u05d0\u05d9\u05e1\u05d5\u05e3")) {
                newOrder.delivery = false;
                newOrder.carryOut = true;
            }
        } else if (shippingLines.length() > 0) {
            JSONObject shippingLine2 = shippingLines.getJSONObject(0);
            String shippingMethodId = shippingLine2.optString("method_id");
            if (shippingMethodId.equals("local_pickup")) {
                newOrder.delivery = false;
                newOrder.carryOut = true;
            } else {
                newOrder.delivery = true;
                newOrder.carryOut = false;
            }
        }
        newOrder.displayOnRemote = true;
        Customer remoteOrderCustomer = new Customer();
        String firstName = shippingAddressJSON.getString("first_name");
        String lastName = shippingAddressJSON.getString("last_name");
        String company = shippingAddressJSON.getString("company");
        String email = billing.getString("email");
        String phone = billing.optString("phone");
        String address1 = shippingAddressJSON.optString("address_1");
        String address2 = shippingAddressJSON.optString("address_2");
        String state = shippingAddressJSON.optString("state");
        String country = shippingAddressJSON.optString("country");
        String city = shippingAddressJSON.optString("city");
        String postcode = shippingAddressJSON.optString("postcode");
        remoteOrderCustomer.code = !phone.isEmpty() ? phone : firstName + lastName;
        remoteOrderCustomer.first = firstName;
        remoteOrderCustomer.last = lastName;
        remoteOrderCustomer.email = email;
        remoteOrderCustomer.phone = phone;
        remoteOrderCustomer.city = city;
        remoteOrderCustomer.address1 = address1;
        remoteOrderCustomer.address2 = address2;
        remoteOrderCustomer.companyName = company;
        remoteOrderCustomer.state = state;
        remoteOrderCustomer.country = country;
        remoteOrderCustomer.zip = postcode;
        boolean saved = false;
        if (remoteOrderCustomer.code != null && !remoteOrderCustomer.code.isEmpty()) {
            saved = this.core.updateCustomer(remoteOrderCustomer);
        }
        if (saved) {
            newOrder.customer = remoteOrderCustomer;
        }
        Hashtable<Integer, Vector<Option>> optionsTable = new Hashtable<Integer, Vector<Option>>();
        Vector<Integer> optinsProductIds = new Vector<Integer>();
        Vector<Object> newLineItems = new Vector<Object>();
        int numLines = 0;
        if (items != null && items.length() > 0) {
            JSONObject thisLine;
            int i;
            numLines = items.length();
            for (i = 0; i < numLines; ++i) {
                thisLine = items.getJSONObject(i);
                if (!thisLine.has("id")) continue;
                int parentLineItemId = thisLine.getInt("id");
                JSONArray metaDataArray = thisLine.getJSONArray("meta_data");
                int metaLen = metaDataArray.length();
                for (int j = 0; j < metaLen; ++j) {
                    JSONObject value;
                    Object obj;
                    JSONObject thisMeta = metaDataArray.getJSONObject(j);
                    if (!thisMeta.has("value") || !((obj = thisMeta.get("value")) instanceof JSONObject) || !(value = (JSONObject)obj).has("groups") || (obj = value.get("groups")) instanceof JSONArray) continue;
                    JSONObject groups = value.getJSONObject("groups");
                    Iterator keys = groups.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        JSONObject thisGroup = groups.getJSONObject(key);
                        Iterator subObjKeys = thisGroup.keys();
                        while (subObjKeys.hasNext()) {
                            String subKey = (String)subObjKeys.next();
                            JSONObject subObj = thisGroup.getJSONObject(subKey);
                            if (!subObj.has("type")) continue;
                            String type = subObj.getString("type");
                            if (type.equals("product-categories") || type.equals("products")) {
                                String id = subObj.getString("value");
                                JSONObject child_products_quantities = subObj.getJSONObject("child_products_quantities");
                                String[] splitProductIds = id.split(",");
                                Vector<Option> list = null;
                                block8: for (int k = 0; k < splitProductIds.length; ++k) {
                                    Option option = new Option();
                                    option.parentLineItemId = parentLineItemId;
                                    option.productId = Integer.parseInt(splitProductIds[k]);
                                    for (int l = 0; l < numLines; ++l) {
                                        JSONObject thisLine2 = items.getJSONObject(l);
                                        if (!thisLine2.has("sku")) continue;
                                        int lineItemId = thisLine2.getInt("id");
                                        String sku = thisLine2.getString("sku");
                                        String name = thisLine2.getString("name");
                                        double price = thisLine2.getDouble("price");
                                        double total = thisLine2.getDouble("total");
                                        double totalTax = thisLine2.getDouble("total_tax");
                                        int qty = thisLine2.getInt("quantity");
                                        int productId = thisLine2.getInt("product_id");
                                        if (productId != option.productId) continue;
                                        option.price = price;
                                        option.sku = sku;
                                        option.name = name;
                                        option.total = total;
                                        option.totalTax = totalTax;
                                        option.tax = totalTax * 100.0 / (double)(qty * 100);
                                        option.qty = child_products_quantities.getInt(option.productId + "");
                                        list = (Vector<Option>)optionsTable.get(parentLineItemId);
                                        if (list == null) {
                                            list = new Vector<Option>();
                                        }
                                        list.add(option);
                                        optionsTable.put(parentLineItemId, list);
                                        optinsProductIds.add(productId);
                                        continue block8;
                                    }
                                }
                                continue;
                            }
                            if (!type.equals("checkbox") && !type.equals("text")) continue;
                            String name = subObj.getString("label");
                            if (type.equals("text")) {
                                name = subObj.getString("value");
                            }
                            if (name.isEmpty()) continue;
                            Option option = new Option();
                            option.name = name;
                            Vector<Option> list = (Vector<Option>)optionsTable.get(parentLineItemId);
                            if (list == null) {
                                list = new Vector<Option>();
                            }
                            list.add(option);
                            optionsTable.put(parentLineItemId, list);
                        }
                    }
                }
            }
            for (i = 0; i < numLines; ++i) {
                String taxCode;
                thisLine = items.getJSONObject(i);
                String itemId = "";
                String sku = "";
                try {
                    itemId = sku = thisLine.optString("sku");
                }
                catch (Exception ex) {
                    this.core.input(this.core.getLiteral("Error Importing WooCommerce Open Order - #") + orderId + " " + this.core.getLiteral("Item Id not received - Setting to Undefined"));
                    itemId = "Undefined";
                }
                int productId = thisLine.getInt("product_id");
                boolean isChoice = optinsProductIds.contains(productId);
                if (isChoice) continue;
                String description = thisLine.getString("name");
                double price = thisLine.getDouble("price");
                double total = thisLine.getDouble("total");
                double totalTax = thisLine.getDouble("total_tax");
                double itemQty = thisLine.getDouble("quantity");
                double tax = totalTax / itemQty;
                Item thisItem = this.core.getItemByCode(itemId);
                if (thisItem == null && thisItem == null) {
                    this.core.input(this.core.getLiteral("Error Importing WooCommerce Open Order - #") + " " + this.core.getLiteral("Item Id") + " " + itemId + " " + this.core.getLiteral("not found - Setting to Undefined"));
                    thisItem = this.core.getItemByCode("Undefined");
                    if (thisItem == null) {
                        this.core.input("Error Importing WooCommerce Open Order - #" + orderId + " Item: " + itemId + " not found");
                        continue;
                    }
                    itemId = "Undefined";
                }
                if ((taxCode = this.core.getCarryOutTaxCode()) == null || taxCode.isEmpty()) {
                    taxCode = thisItem.vatCode;
                }
                LineItem newLineItem = new LineItem();
                newLineItem.itemId = itemId;
                newLineItem.itemDescription = description;
                newLineItem.price = this.addNumbersPrecision(price, tax);
                newLineItem.quantity = itemQty;
                newLineItem.displayOnRemote = true;
                newLineItem.altDescription = thisItem.alternateDescription;
                newLineItem.list = thisItem.list;
                newLineItem.originalPrice = this.core.getPriceWithVatIncluded(thisItem.price, taxCode);
                if (newLineItem.tax == null) {
                    newLineItem.tax = new Tax();
                }
                newLineItem.tax.taxable = thisItem.taxable;
                newLineItem.taxable = thisItem.taxable;
                newLineItem.isAppetizer = thisItem.isAppetizer;
                newLineItem.itemType = thisItem.type;
                newLineItem.noPartialQuantity = thisItem.noPartialQuantity;
                newLineItem.carryOut = !newOrder.delivery;
                newLineItem.userId = this.posUser;
                newLineItem.total = total;
                if (!this.companyInfo.country.equals("US")) {
                    newLineItem.vatGross = newLineItem.price * itemQty;
                    newLineItem.vatTax1 = totalTax;
                }
                newLineItem.created = new Date().getTime() + (long)newOrder.nextLineNumber;
                ++newOrder.nextLineNumber;
                newLineItem.changedPrice = "WooCommerce";
                Vector<ItemChoice> newChoices = new Vector<ItemChoice>();
                int lineItemId = thisLine.getInt("id");
                Vector choices = (Vector)optionsTable.get(lineItemId);
                Vector<LineItem> newOptionalItems = new Vector<LineItem>();
                if (choices != null && choices.size() > 0) {
                    int numChoices = choices.size();
                    for (int c = 0; c < numChoices; ++c) {
                        String choiceTaxCode;
                        ItemChoice newItemChoice;
                        Option thisChoice = (Option)choices.get(c);
                        String thisChoiceDescription = thisChoice.name;
                        double thisChoiceQty = thisChoice.qty;
                        String thisChoiceId = "";
                        try {
                            thisChoiceId = thisChoice.sku;
                        }
                        catch (Exception ex) {
                            this.output(this.core.getLiteral("Error Importing WooCommerce Open Order - #") + orderId + " " + this.core.getLiteral("Choice Item Id not received - Setting to UndefinedChoice"));
                            thisChoiceId = "UndefinedChoice";
                        }
                        double choicePrice = thisChoice.price;
                        if (choicePrice == 0.0) {
                            newItemChoice = new ItemChoice();
                            newItemChoice.itemCode = thisChoiceId;
                            newItemChoice.display = thisChoiceDescription;
                            newItemChoice.text = thisChoiceDescription;
                            newItemChoice.cr = true;
                            newChoices.add(newItemChoice);
                            continue;
                        }
                        newItemChoice = new ItemChoice();
                        newItemChoice.itemCode = "";
                        newItemChoice.display = thisChoiceDescription;
                        newItemChoice.text = thisChoiceDescription;
                        newItemChoice.cr = true;
                        newChoices.add(newItemChoice);
                        LineItem newOptionalItem = new LineItem();
                        Item thisOptionalItem = this.core.getItemByCode(thisChoiceId);
                        if (thisOptionalItem == null) {
                            this.output(this.core.getLiteral("Error Importing WooCommerce Open Order - #") + " " + this.core.getLiteral("Choice Item Id") + " " + thisChoiceId + " " + this.core.getLiteral("not found - Setting to UndefinedChoice"));
                            thisOptionalItem = this.core.getItemByCode("UndefinedChoice");
                            if (thisOptionalItem == null) {
                                this.output("Error Importing WooCommerce Open Order - #" + orderId + " Optional Item: " + thisChoiceId + " not found");
                                continue;
                            }
                            thisChoiceId = "UndefinedChoice";
                        }
                        if ((choiceTaxCode = this.core.getCarryOutTaxCode()) == null || choiceTaxCode.isEmpty()) {
                            choiceTaxCode = thisItem.vatCode;
                        }
                        newOptionalItem.itemId = thisChoiceId;
                        newOptionalItem.itemDescription = thisChoiceDescription;
                        newOptionalItem.price = this.addNumbersPrecision(thisChoice.price, thisChoice.tax);
                        newOptionalItem.quantity = thisChoiceQty;
                        newOptionalItem.displayOnRemote = true;
                        newOptionalItem.altDescription = thisOptionalItem.alternateDescription;
                        newOptionalItem.list = thisOptionalItem.list;
                        newOptionalItem.originalPrice = this.core.getPriceWithVatIncluded(thisOptionalItem.price, choiceTaxCode);
                        if (newOptionalItem.tax == null) {
                            newOptionalItem.tax = new Tax();
                        }
                        newOptionalItem.tax.taxable = thisOptionalItem.taxable;
                        newOptionalItem.taxable = thisOptionalItem.taxable;
                        newOptionalItem.isAppetizer = thisOptionalItem.isAppetizer;
                        newOptionalItem.itemType = thisOptionalItem.type;
                        newOptionalItem.noPartialQuantity = thisOptionalItem.noPartialQuantity;
                        newOptionalItem.carryOut = !newOrder.delivery;
                        newOptionalItem.userId = this.posUser;
                        newOptionalItem.total = thisChoice.total;
                        if (!this.companyInfo.country.equals("US")) {
                            newOptionalItem.vatGross = newOptionalItem.price * thisChoiceQty;
                            newOptionalItem.vatTax1 = thisChoice.totalTax;
                        }
                        newOptionalItem.created = new Date().getTime() + (long)newOrder.nextLineNumber;
                        ++newOrder.nextLineNumber;
                        newOptionalItem.changedPrice = "WooCommerce";
                        newOptionalItems.add(newOptionalItem);
                    }
                }
                newLineItem.choices = newChoices;
                newLineItems.add(newLineItem);
                if (newOptionalItems == null || newOptionalItems.isEmpty()) continue;
                newLineItems.addAll(newOptionalItems);
            }
        }
        boolean numCharges = false;
        JSONArray feeLines = remoteOrder.getJSONArray("fee_lines");
        int feeLinesLen = feeLines.length();
        if (feeLinesLen > 0) {
            for (int i = 0; i < feeLinesLen; ++i) {
                JSONObject feeLine = feeLines.getJSONObject(i);
                double total = feeLine.getDouble("total");
                double totalTax = feeLine.getDouble("total_tax");
                String name = feeLine.getString("name");
                String taxable = feeLine.getString("tax_status");
                double chargeQty = 1.0;
                String chargeItemId = "Fee";
                Item thisChargeItem = this.core.getItemByCode(chargeItemId);
                if (thisChargeItem == null && (thisChargeItem = this.core.getItemByCode("Undefined")) == null) {
                    this.core.input("Error Importing WooCommerce Open Order - #" + orderId + " Item: " + chargeItemId + " not found");
                    return;
                }
                LineItem newChargeLineItem = new LineItem();
                String taxCode = this.core.getCarryOutTaxCode();
                if (taxCode == null || taxCode.isEmpty()) {
                    taxCode = thisChargeItem.vatCode;
                }
                newChargeLineItem.itemDescription = name;
                newChargeLineItem.price = this.addNumbersPrecision(total, totalTax);
                newChargeLineItem.quantity = chargeQty;
                newChargeLineItem.noDiscount = true;
                newChargeLineItem.displayOnRemote = true;
                newChargeLineItem.altDescription = thisChargeItem.alternateDescription;
                newChargeLineItem.list = thisChargeItem.list;
                newChargeLineItem.originalPrice = this.core.getPriceWithVatIncluded(thisChargeItem.price, taxCode);
                if (newChargeLineItem.tax == null) {
                    newChargeLineItem.tax = new Tax();
                }
                newChargeLineItem.tax.taxable = thisChargeItem.taxable;
                newChargeLineItem.isAppetizer = thisChargeItem.isAppetizer;
                newChargeLineItem.itemType = thisChargeItem.type;
                newChargeLineItem.noPartialQuantity = thisChargeItem.noPartialQuantity;
                newChargeLineItem.carryOut = !newOrder.delivery;
                newChargeLineItem.userId = this.posUser;
                newChargeLineItem.total = total;
                if (!this.companyInfo.country.equals("US")) {
                    newChargeLineItem.vatGross = newChargeLineItem.price * chargeQty;
                    newChargeLineItem.vatTax1 = totalTax;
                }
                newChargeLineItem.created = new Date().getTime() + (long)newOrder.nextLineNumber;
                newChargeLineItem.changedPrice = "WooCommerce";
                newLineItems.add(newChargeLineItem);
            }
        }
        if (shippingLines.length() > 0 && !(methodId = (shippingLine = shippingLines.getJSONObject(0)).getString("method_id")).equals("local_pickup")) {
            double total = shippingLine.getDouble("total");
            double totalTax = shippingLine.getDouble("total_tax");
            String methodTitle = shippingLine.getString("method_title");
            double chargeQty = 1.0;
            String chargeItemId = "Delivery";
            Item thisChargeItem = this.core.getItemByCode(chargeItemId);
            if (thisChargeItem == null && (thisChargeItem = this.core.getItemByCode("Undefined")) == null) {
                this.core.input("Error Importing WooCommerce Open Order - #" + orderId + " Item: " + chargeItemId + " not found");
                return;
            }
            LineItem newChargeLineItem = new LineItem();
            newChargeLineItem.itemId = chargeItemId;
            String taxCode = this.core.getCarryOutTaxCode();
            if (taxCode == null || taxCode.isEmpty()) {
                taxCode = thisChargeItem.vatCode;
            }
            newChargeLineItem.itemDescription = methodTitle;
            newChargeLineItem.price = this.addNumbersPrecision(total, totalTax);
            newChargeLineItem.quantity = chargeQty;
            newChargeLineItem.noDiscount = true;
            newChargeLineItem.displayOnRemote = true;
            newChargeLineItem.altDescription = thisChargeItem.alternateDescription;
            newChargeLineItem.list = thisChargeItem.list;
            newChargeLineItem.originalPrice = this.core.getPriceWithVatIncluded(thisChargeItem.price, taxCode);
            if (newChargeLineItem.tax == null) {
                newChargeLineItem.tax = new Tax();
            }
            newChargeLineItem.tax.taxable = thisChargeItem.taxable;
            newChargeLineItem.taxable = thisChargeItem.taxable;
            newChargeLineItem.isAppetizer = thisChargeItem.isAppetizer;
            newChargeLineItem.itemType = thisChargeItem.type;
            newChargeLineItem.noPartialQuantity = thisChargeItem.noPartialQuantity;
            newChargeLineItem.carryOut = !newOrder.delivery;
            newChargeLineItem.userId = this.posUser;
            newChargeLineItem.total = total;
            if (!this.companyInfo.country.equals("US")) {
                newChargeLineItem.vatGross = newChargeLineItem.price * chargeQty;
                newChargeLineItem.vatTax1 = totalTax;
            }
            newChargeLineItem.created = new Date().getTime() + (long)newOrder.nextLineNumber;
            newChargeLineItem.changedPrice = "WooCommerce";
            newLineItems.add(newChargeLineItem);
        }
        newOrder.lineItems = newLineItems;
        newOrder.user = this.posUser;
        String tenderMethod = remoteOrder.getString("payment_method");
        double total = remoteOrder.optDouble("total");
        Tender newTender = new Tender();
        newTender.amount = total;
        String payMethod = "WC";
        if (!tenderMethod.isEmpty() && !tenderMethod.equals("cod")) {
            TenderCode tenderCode = this.core.getTenderCode(payMethod);
            if (tenderCode == null) {
                this.core.input("WooCommerce: error - tender code " + payMethod + " not found!");
            } else {
                newTender.description = tenderCode.description;
            }
            newTender.approval = "";
            newTender.newTender = true;
            newTender.code = payMethod;
            newTender.user = this.posUser;
            String resultXml = this.core.processOtherTender(this.posUser, this.till, newOrder.toXml(), newTender.code, total, "", created.getTime(), "");
            String orderXml = Utility.getElement((String)"Order", (String)resultXml);
            if (orderXml != null && !orderXml.isEmpty()) {
                Order currentOrder = new Order(orderXml, true);
                newOrder.status = "Accepted";
                this.tenderAdded(currentOrder, orderId);
            }
        } else {
            this.core.saveOrder(newOrder.toXml(), this.posUser, this.till);
        }
    }

    public void tenderAdded(Order currentOrder, String orderId) {
        boolean result;
        double balance = (double)Math.round((currentOrder.total - this.getTenderTotal(currentOrder)) * 100.0) / 100.0;
        boolean hasChange = false;
        if (balance < -0.009 && currentOrder.total > 1.0E-4) {
            hasChange = true;
        }
        if ((balance > -1.0E-4 && balance < 1.0E-4 || balance < 1.0E-4 && hasChange) && !(result = this.core.invoiceOrder(currentOrder.toXml(), currentOrder.user, currentOrder.shift, "", ""))) {
            this.core.input("Error Invoicing WooCommerce Order - Order Id:" + currentOrder.orderId);
        }
    }

    public double getTenderTotal(Order currentOrder) {
        double result = 0.0;
        if (currentOrder != null && currentOrder.tenderings != null) {
            int len = currentOrder.tenderings.size();
            for (int i = 0; i < len; ++i) {
                Tender thisTender = (Tender)currentOrder.tenderings.get(i);
                result += thisTender.amount;
            }
        }
        return result;
    }

    boolean orderExists(String orderId) {
        boolean exists = false;
        Vector openOrders = this.core.getOrdersByOrderId(orderId);
        if (openOrders != null && !openOrders.isEmpty()) {
            exists = true;
        }
        return exists;
    }

    JSONArray sendRequest(String action, String method, String data) {
        JSONArray value = new JSONArray();
        String urlString = this.baseURL + action;
        this.output(urlString);
        try {
            SSLContext ssl_ctx = SSLContext.getInstance("TLSv1.2");
            SSLContext.setDefault(ssl_ctx);
            if (this.test) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                ssl_ctx.init(null, trustAllCerts, new SecureRandom());
                HostnameVerifier allHostsValid = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
                HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            } else {
                ssl_ctx.init(null, null, null);
            }
            SSLSocketFactory socketFactory = ssl_ctx.getSocketFactory();
            String response = "";
            boolean done = false;
            while (!done) {
                String line;
                BufferedReader br;
                URL url = new URL(urlString);
                HttpsURLConnection urlConnection = (HttpsURLConnection)url.openConnection();
                urlConnection.setSSLSocketFactory(socketFactory);
                urlConnection.setRequestProperty("Authorization", "Basic " + this.authBase64);
                if (method.equalsIgnoreCase("POST")) {
                    this.output("Request:");
                    this.output(data);
                    urlConnection.setRequestMethod("POST");
                    urlConnection.setDoOutput(true);
                    urlConnection.setRequestProperty("Accept", "*/*");
                    urlConnection.setRequestProperty("Content-Type", "application/json");
                    OutputStream os = urlConnection.getOutputStream();
                    os.write(data.getBytes("UTF-8"));
                    os.close();
                } else if (method.equalsIgnoreCase("GET")) {
                    data = data.replace(" ", "%20");
                    data = data.replace("'", "%27");
                    urlConnection.setRequestMethod("GET");
                    urlConnection.setRequestProperty("Content-Type", "application/json");
                }
                StringBuilder sb = new StringBuilder();
                int HttpResult = urlConnection.getResponseCode();
                if (HttpResult == 200 || HttpResult == 201) {
                    br = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "utf-8"));
                    line = null;
                    while ((line = br.readLine()) != null) {
                        sb.append(line + "\n");
                    }
                    br.close();
                    response = response + sb.toString();
                    if (response.startsWith("{")) {
                        sb.insert(0, "[");
                        sb.append("]");
                    }
                    value = new JSONArray(sb.toString());
                    this.output(sb.toString());
                } else {
                    if (HttpResult == 401) {
                        this.core.input("WooCommerce: Credentials Invalid");
                    } else {
                        this.output("" + urlConnection.getResponseMessage());
                        br = new BufferedReader(new InputStreamReader(urlConnection.getErrorStream(), "utf-8"));
                        line = null;
                        while ((line = br.readLine()) != null) {
                            sb.append(line + "\n");
                        }
                        this.output(sb.toString());
                        br.close();
                        this.output("" + sb.toString());
                    }
                    done = true;
                }
                if (response == null || response.isEmpty()) continue;
                done = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.output(e.getMessage());
        }
        return value;
    }

    public void output(String text) {
        if (this.debug) {
            this.core.input(text);
        }
        System.out.println(text);
    }

    public boolean setOrderStatus(int i, String string) {
        return true;
    }

    public void orderNotice(String string) {
    }

    public double addNumbersPrecision(double num1, double num2) {
        BigDecimal first = BigDecimal.valueOf(num1);
        BigDecimal second = BigDecimal.valueOf(num2);
        BigDecimal result = first.add(second);
        return result.setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    class Option {
        int parentLineItemId;
        String sku;
        int qty;
        double price;
        String name;
        double total;
        double totalTax;
        double tax;
        int productId;

        Option() {
        }
    }

    class OrdersDownloadTimer
    extends TimerTask {
        OrdersDownloadTimer() {
        }

        @Override
        public void run() {
            if (!WooCommerceDataHandler.this.core.isBlockLogin()) {
                SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                Timestamp startDate = new Timestamp(System.currentTimeMillis());
                String date = startDate.toString().substring(0, 10);
                startDate = Timestamp.valueOf(date + " 00:00:00");
                String statusFilter = "&status=pending,processing,completed";
                if (WooCommerceDataHandler.this.isFoodService) {
                    statusFilter = "";
                }
                String params = "?modified_after=" + datetimeFormat.format(startDate);
                params = params + statusFilter;
                params = params + "&" + System.currentTimeMillis();
                JSONArray response = WooCommerceDataHandler.this.sendRequest("/wp-json/wc/v3/orders" + params, "GET", "");
                int len = response.length();
                for (int i = 0; i < len; ++i) {
                    try {
                        JSONObject order = response.getJSONObject(i);
                        WooCommerceDataHandler.this.saveNewOrder(order);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

