/*
 * Decompiled with CFR 0.152.
 */
package Outputs;

import AccuServerBase.ClockTicketPrinter;
import AccuServerBase.ServerCore;
import AccuServerBase.ServerObject;
import AccuServerBase.Utility;
import AccuShiftDataObjects.Employee;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Hashtable;

public class TimeClockPrinter
implements ServerObject,
ClockTicketPrinter {
    ServerCore core = null;
    String templateName = "";
    public String name = "";
    public String printerName = "";
    float pageWidth = 8.5f;
    float pageLength = 11.0f;
    String posType = "";

    public int getType() {
        return 21;
    }

    public void output(String output) {
        this.core.input(output);
    }

    public String getName() {
        return this.name;
    }

    public String getPOSType() {
        return this.posType;
    }

    public void initialize(ServerCore core, Hashtable parameters) {
        String pageLengthText;
        this.core = core;
        this.printerName = (String)parameters.get("Printer");
        this.name = (String)parameters.get("Name");
        String pageWidthText = (String)parameters.get("PageWidth");
        if (pageWidthText == null) {
            pageWidthText = "";
        }
        if ((pageLengthText = (String)parameters.get("PageLength")) == null) {
            pageLengthText = "";
        }
        try {
            this.pageWidth = Float.parseFloat(pageWidthText);
        }
        catch (NumberFormatException numberFormatException) {
            this.pageWidth = 8.5f;
        }
        try {
            this.pageLength = Float.parseFloat(pageLengthText);
        }
        catch (NumberFormatException numberFormatException) {
            this.pageLength = 11.0f;
        }
        if (this.pageLength < 0.0f) {
            this.pageLength = 1200.0f;
        }
        this.posType = (String)parameters.get("POSType");
        if (this.posType == null || this.posType.isEmpty()) {
            this.posType = "PC";
        }
        this.templateName = (String)parameters.get("Template");
        core.setClockTicketPrinter((ClockTicketPrinter)this);
    }

    public String clockInTicket(Employee employee, int payLevelNumber, Timestamp clockIn) {
        String dateTimeFormat;
        String template = Utility.getXml((String)(System.getProperty("user.dir") + "\\" + this.templateName));
        if (template == null || template.length() < 10) {
            this.core.raiseException((Exception)new RuntimeException("ClockInOut template " + this.templateName + " not found"));
            this.core.input("ClockInOut template " + this.templateName + " not found");
        }
        if ((dateTimeFormat = Utility.getElement((String)"DateTimeFormat", (String)template)) == null || dateTimeFormat.length() == 0) {
            dateTimeFormat = "MMMM-dd-yyyy hh:mm a";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateTimeFormat);
        String title = this.core.getLiteral("Employee Clock In");
        String employeeName = employee.name;
        String payLevel = this.getPayLevel(employee, payLevelNumber);
        String clockInTime = dateFormat.format(clockIn);
        String clockInBlock = Utility.getXmlBlock((String)"ClockInBlock", (String)template);
        clockInBlock = Utility.replaceXmlDataTag((String)clockInBlock, (String)"Title", (String)title);
        clockInBlock = Utility.replaceXmlDataTag((String)clockInBlock, (String)"EmployeeName", (String)employeeName);
        clockInBlock = Utility.replaceXmlDataTag((String)clockInBlock, (String)"PayLevel", (String)payLevel);
        clockInBlock = Utility.replaceXmlDataTag((String)clockInBlock, (String)"ClockInTime", (String)clockInTime);
        template = Utility.replaceXmlBlock((String)template, (String)"ClockInBlock", (String)clockInBlock);
        template = Utility.replaceXmlBlock((String)template, (String)"ClockOutBlock", (String)"");
        return template;
    }

    public String clockOutTicket(Employee employee, int payLevelNumber, Timestamp clockIn, long payPeriodTime) {
        String dateTimeFormat;
        String template = Utility.getXml((String)(System.getProperty("user.dir") + "\\" + this.templateName));
        if (template == null || template.length() < 10) {
            this.core.raiseException((Exception)new RuntimeException("ClockInOut template " + this.templateName + " not found"));
        }
        if ((dateTimeFormat = Utility.getElement((String)"DateTimeFormat", (String)template)) == null || dateTimeFormat.length() == 0) {
            dateTimeFormat = "MMMM-dd-yyyy hh:mm a";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateTimeFormat);
        boolean timeFormatDecimal = Utility.getBooleanElement((String)"TimeFormatDecimal", (String)template);
        String title = this.core.getLiteral("Employee Clock Out");
        String employeeName = employee.name;
        String payLevel = this.getPayLevel(employee, payLevelNumber);
        Timestamp clockOut = new Timestamp(System.currentTimeMillis());
        String clockOutTime = dateFormat.format(clockOut);
        String todaysTime = "";
        long timeDiff = clockOut.getTime() - clockIn.getTime();
        int timeHours = (int)(timeDiff / 3600000L % 24L);
        int timeMins = (int)(timeDiff / 60000L % 60L);
        if (timeFormatDecimal) {
            if (timeMins == 0) {
                todaysTime = String.format("%d.0 hrs", timeHours);
            } else {
                double hours = (double)timeHours + (double)Math.round((double)timeMins / 60.0 * 100.0) / 100.0;
                todaysTime = String.format("%.2f hrs", hours);
            }
        } else {
            todaysTime = String.format("%d hrs, %d mins", timeHours, timeMins);
        }
        String periodTime = "";
        timeHours = (int)(payPeriodTime / 3600000L % 24L);
        timeMins = (int)(payPeriodTime / 60000L % 60L);
        if (timeFormatDecimal) {
            if (timeMins == 0) {
                periodTime = String.format("%d.0 hrs", timeHours);
            } else {
                double hours = (double)timeHours + (double)Math.round((double)timeMins / 60.0 * 100.0) / 100.0;
                periodTime = String.format("%.2f hrs", hours);
            }
        } else {
            periodTime = String.format("%d hrs, %d mins", timeHours, timeMins);
        }
        String clockOutBlock = Utility.getXmlBlock((String)"ClockOutBlock", (String)template);
        clockOutBlock = Utility.replaceXmlDataTag((String)clockOutBlock, (String)"Title", (String)title);
        clockOutBlock = Utility.replaceXmlDataTag((String)clockOutBlock, (String)"EmployeeName", (String)employeeName);
        clockOutBlock = Utility.replaceXmlDataTag((String)clockOutBlock, (String)"PayLevel", (String)payLevel);
        clockOutBlock = Utility.replaceXmlDataTag((String)clockOutBlock, (String)"ClockOutTime", (String)clockOutTime);
        clockOutBlock = Utility.replaceXmlDataTag((String)clockOutBlock, (String)"TimeWorkedToday", (String)todaysTime);
        clockOutBlock = Utility.replaceXmlDataTag((String)clockOutBlock, (String)"TimePayPeriod", (String)periodTime);
        template = Utility.replaceXmlBlock((String)template, (String)"ClockOutBlock", (String)clockOutBlock);
        template = Utility.replaceXmlBlock((String)template, (String)"ClockInBlock", (String)"");
        return template;
    }

    private String getPayLevel(Employee employee, int payLevelNumber) {
        String payLevel = "";
        switch (payLevelNumber) {
            case 0: {
                payLevel = employee.payLevel1;
                break;
            }
            case 1: {
                payLevel = employee.payLevel1;
                break;
            }
            case 2: {
                payLevel = employee.payLevel2;
                break;
            }
            case 3: {
                payLevel = employee.payLevel3;
                break;
            }
            case 4: {
                payLevel = employee.payLevel4;
                break;
            }
            case 5: {
                payLevel = employee.payLevel5;
                break;
            }
            case 6: {
                payLevel = employee.payLevel6;
                break;
            }
            case 7: {
                payLevel = employee.payLevel7;
                break;
            }
            case 8: {
                payLevel = employee.payLevel8;
                break;
            }
            case 9: {
                payLevel = employee.payLevel9;
                break;
            }
            case 10: {
                payLevel = employee.payLevel1;
                break;
            }
            case 11: {
                payLevel = employee.payLevel11;
                break;
            }
            case 12: {
                payLevel = employee.payLevel12;
                break;
            }
            case 13: {
                payLevel = employee.payLevel13;
                break;
            }
            case 14: {
                payLevel = employee.payLevel14;
                break;
            }
            case 15: {
                payLevel = employee.payLevel15;
                break;
            }
            case 16: {
                payLevel = employee.payLevel16;
                break;
            }
            case 17: {
                payLevel = employee.payLevel17;
                break;
            }
            case 18: {
                payLevel = employee.payLevel18;
                break;
            }
            case 19: {
                payLevel = employee.payLevel19;
                break;
            }
            case 20: {
                payLevel = employee.payLevel20;
            }
        }
        return payLevel;
    }
}

