/*
 * Decompiled with CFR 0.152.
 */
package AccuServer;

import ATSClasses.ATSClassLoader;
import AccuCountDataObjects.AdjustmentSession;
import AccuCountDataObjects.InventoryItem;
import AccuCountDataObjects.PriceChangeSession;
import AccuCountDataObjects.ReceivingSession;
import AccuCountDataObjects.Vendor;
import AccuServer.Version;
import AccuServerBase.AccuServerEmailBase;
import AccuServerBase.AccuServerHostConnectorBase;
import AccuServerBase.AccuServerIntegratorBase;
import AccuServerBase.AccuServerMonitorBase;
import AccuServerBase.AccuServerRegionalSyncBase;
import AccuServerBase.AccuServerSMSHandlerBase;
import AccuServerBase.AccuServerTaxBase;
import AccuServerBase.Ad2POSClientBase;
import AccuServerBase.CardHandlerBase;
import AccuServerBase.CardPostAuthBase;
import AccuServerBase.CardsSetupHandlerBase;
import AccuServerBase.ClockTicketPrinter;
import AccuServerBase.CloudDataBase;
import AccuServerBase.ComoLoyaltyHandlerBase;
import AccuServerBase.CustomerPriceBase;
import AccuServerBase.EConduitHandlerBase;
import AccuServerBase.EncryptionBase;
import AccuServerBase.GiftCardHandlerBase;
import AccuServerBase.LicenseHandlerBase;
import AccuServerBase.LoyaltyHandlerBase;
import AccuServerBase.MoneyCardHandlerBase;
import AccuServerBase.NetReportServerBase;
import AccuServerBase.OnlineOrdersHandlerBase;
import AccuServerBase.OrderPrinter;
import AccuServerBase.RemoteDisplayBase;
import AccuServerBase.ReportShiftPrinter;
import AccuServerBase.ServerCore;
import AccuServerBase.ServerObject;
import AccuServerBase.SetupDataReceiverBase;
import AccuServerBase.TriPOSHandlerBase;
import AccuServerBase.UserSecurityHandlerBase;
import AccuServerBase.Utility;
import AccuServerBase.WebServerBase;
import AccuServerBase.WebSocketClientBase;
import AccuServerBase.WebSocketHostBase;
import AccuServerLogger.AccuServerAuditTrailLogger;
import AccuServerLogger.AccuServerDebugLogger;
import AccuServerLogger.AccuServerLogger;
import AccuServerLogger.AccuServerTransactionLogger;
import AccuServerMonitor.SetupDataReceiverScreen;
import AccuServerWebServers.WebSocketProxyClient;
import AccuShiftBase.AccuShiftData;
import AccuShiftDataObjects.Employee;
import AccuShiftDataObjects.PayPeriodInfo;
import AccuShiftDataObjects.TimeDetail;
import POSBase.POSData;
import POSDataObjects.AdInfo;
import POSDataObjects.BackupInfo;
import POSDataObjects.BarCodeInfo;
import POSDataObjects.Check;
import POSDataObjects.Choice;
import POSDataObjects.ChoiceGroup;
import POSDataObjects.ChoicesPage;
import POSDataObjects.ComoClubMember;
import POSDataObjects.Company;
import POSDataObjects.CompanySetupInfo;
import POSDataObjects.Customer;
import POSDataObjects.CustomerFiltered;
import POSDataObjects.CustomerTerm;
import POSDataObjects.DataSummary;
import POSDataObjects.DisplayItem;
import POSDataObjects.DisplayOrder;
import POSDataObjects.DisplayPrinter;
import POSDataObjects.EConduitTerminal;
import POSDataObjects.FlexGroup;
import POSDataObjects.FlexGroupDetail;
import POSDataObjects.FollowOn;
import POSDataObjects.GiftCardDetail;
import POSDataObjects.GiftCardTransaction;
import POSDataObjects.GratuitySetup;
import POSDataObjects.Item;
import POSDataObjects.ItemCategory;
import POSDataObjects.ItemChoice;
import POSDataObjects.ItemGroup;
import POSDataObjects.LineItem;
import POSDataObjects.LoyaltyCustomer;
import POSDataObjects.LoyaltyPointsProgram;
import POSDataObjects.LoyaltyProg;
import POSDataObjects.LoyaltyPurchase;
import POSDataObjects.MenuKey;
import POSDataObjects.NoPartialQuantity;
import POSDataObjects.Order;
import POSDataObjects.POSDataContainer;
import POSDataObjects.PriceLevelTime;
import POSDataObjects.PricingSetup;
import POSDataObjects.ProductLine;
import POSDataObjects.QBOAuth;
import POSDataObjects.QualifyingQtyType;
import POSDataObjects.ReceiptPrintSetup;
import POSDataObjects.Reset;
import POSDataObjects.RoomChargeGuest;
import POSDataObjects.SMTPCredentials;
import POSDataObjects.SageAuth;
import POSDataObjects.SalePrice;
import POSDataObjects.SearchField;
import POSDataObjects.SearchObject;
import POSDataObjects.ServerLocation;
import POSDataObjects.SyncControl;
import POSDataObjects.Tax;
import POSDataObjects.TaxAuthority;
import POSDataObjects.TaxCode;
import POSDataObjects.Tender;
import POSDataObjects.TenderCode;
import POSDataObjects.Till;
import POSDataObjects.TransactionReportOptions;
import POSDataObjects.UnitOfMeasure;
import POSDataObjects.User;
import POSDataObjects.UserGroupInfo;
import POSDataObjects.UserSecureCodes;
import POSDataObjects.UserSession;
import POSDataObjects.ValueAddedTax;
import apow.Main;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.print.PrintService;
import javax.print.attribute.standard.PrinterName;
import javax.swing.JOptionPane;
import org.json.JSONArray;

public class AccuServerCore
implements ServerCore {
    WebSocketClientBase webSocketClient = null;
    WebSocketHostBase webSocketHost = null;
    String configFilename = "";
    ArrayList inputList = null;
    ArrayList outputList = null;
    Hashtable orderPrinters = null;
    Hashtable shiftPrinters = null;
    ArrayList exceptionList = null;
    POSData posLocalData = null;
    AccuShiftData accuShiftLocalData = null;
    AccuServerTaxBase accuServerTaxHandler = null;
    CloudDataBase cloudDataAccess = null;
    CustomerPriceBase customerPriceHandler = null;
    Company company = null;
    String country = "";
    CardHandlerBase cardHandler = null;
    GiftCardHandlerBase giftCardHandler = null;
    LoyaltyHandlerBase loyaltyHandler = null;
    ComoLoyaltyHandlerBase comoLoyaltyHandler = null;
    AccuServerIntegratorBase integratorHandler = null;
    AccuServerEmailBase emailExceptionHandler = null;
    AccuServerEmailBase emailReceiptHandler = null;
    RemoteDisplayBase remoteDisplayHandler = null;
    AccuServerMonitorBase serverMonitor = null;
    NetReportServerBase netReportServerHandler = null;
    CardPostAuthBase cardPostAuthProcessor = null;
    SetupDataReceiverBase setupDataReceiver = null;
    public POSDataContainer itemList = null;
    public POSDataContainer usersList = null;
    public POSDataContainer choicesList = null;
    public POSDataContainer menuKeysList = null;
    public POSDataContainer tablesList = null;
    public POSDataContainer taxAuthoritiesList = null;
    public POSDataContainer alternateTaxAuthoritiesList = null;
    public POSDataContainer tenderCodesList = null;
    public POSDataContainer tillsList = null;
    public POSDataContainer priceLevelList = null;
    public POSDataContainer vatRecordsList = null;
    public POSDataContainer foodStampTypeList = null;
    public POSDataContainer messagesList = null;
    public POSDataContainer payoutItemList = null;
    public int clientTimeDifference = 0;
    public int serverPort = 0;
    public StringBuffer log = null;
    public String invoiceMessage = "";
    public static AccuServerLogger logger = null;
    public static AccuServerAuditTrailLogger auditLogger = null;
    public static AccuServerTransactionLogger transactionLogger = null;
    public Item gratuityItem = null;
    public GratuitySetup gratuitySetup = null;
    public BarCodeInfo barCodeSetup = null;
    public Hashtable literalsTable = null;
    Hashtable userSessions = null;
    Hashtable terminalSessions = null;
    Hashtable posStations = null;
    UserSecurityHandlerBase userSecurityHandler = null;
    LicenseHandlerBase licenseHandler = null;
    EncryptionBase encryption = null;
    Timer gcTimer = null;
    boolean autoUpdates = false;
    boolean blockLogin = false;
    boolean downloadingVersion = false;
    CardsSetupHandlerBase cardsSetupHandler = null;
    boolean logTendering = false;
    String validationErrorMsg = "";
    ClockTicketPrinter clockTicketPrinter = null;
    Ad2POSClientBase ad2POSClient = null;
    AccuServerDebugLogger debugLog = null;
    boolean debugLoggingOn = false;
    WebServerBase webServer = null;
    MoneyCardHandlerBase tenbisCardHandler = null;
    QBOAuth qboAuth;
    SageAuth sageAuth;
    Hashtable flexGroups = null;
    Hashtable flexGroupDetail = null;
    POSDataContainer qualifyingQtyTypes = null;
    MoneyCardHandlerBase cibusCardHandler = null;
    long choicesCacheSyncTime = 0L;
    Hashtable vatTable = null;
    public boolean removeFoodService = false;
    public boolean printReportsRTL = false;
    public boolean savingItems = false;
    public String tipsTenderCode = "";
    public boolean autoCreateMenuButtons = false;
    public boolean autoChangeClientConfig = false;
    public boolean printZeroFlexGroupItems = true;
    AccuServerRegionalSyncBase regionalSyncHandler = null;
    EConduitHandlerBase eConduitCardHandler = null;
    TriPOSHandlerBase triPOSCardHandler = null;
    OnlineOrdersHandlerBase mishlohaDataHandler = null;
    OnlineOrdersHandlerBase tenbisDataHandler = null;
    OnlineOrdersHandlerBase cibusDataHandler = null;
    OnlineOrdersHandlerBase woltDataHandler = null;
    OnlineOrdersHandlerBase biteDataHandler = null;
    OnlineOrdersHandlerBase clickEatDataHandler = null;
    AccuServerSMSHandlerBase smsHandler = null;
    Hashtable taxAuthoritiesTable = null;
    StringBuilder monitorLog = null;
    String serverStartupDate = "";
    String internalIp = "";
    String externalIp = "";
    int bytesIn = 0;
    int bytesOut = 0;
    AccuServerHostConnectorBase hostConnector = null;
    Hashtable hostReplies = null;
    POSDataContainer remoteDisplays = null;
    Hashtable remotePrinters = null;
    String pluAddress = "";
    int pluPort = 9300;
    String pluPath = "";
    String clientConnectCode = "";
    public boolean hostEmailReceipt = false;
    public boolean hostSyncActive = false;
    public boolean disableHostConnection = false;
    public boolean disableHostPing = false;
    public boolean disableCustomerBalance = false;
    int currentTransactionNumber = -1;
    int currentInvoiceNumber = -1;
    int currentReturnNumber = -1;
    int currentInvoiceAccountNumber = -1;
    int currentInvoicePaymentNumber = -1;
    int currentInvoiceOrderNumber = -1;

    public AccuServerCore(String config) {
        this.configFilename = config;
        this.inputList = new ArrayList();
        this.outputList = new ArrayList();
        this.exceptionList = new ArrayList();
        this.itemList = new POSDataContainer();
        this.payoutItemList = new POSDataContainer();
        this.monitorLog = new StringBuilder();
        logger = AccuServerLogger.getInstance((ServerCore)this);
        auditLogger = AccuServerAuditTrailLogger.getInstance((ServerCore)this);
        transactionLogger = AccuServerTransactionLogger.getInstance((ServerCore)this);
        this.debugLog = AccuServerDebugLogger.getInstance((ServerCore)this);
        this.userSessions = new Hashtable();
        System.setProperty("file.encoding", "UTF-8");
        this.startGCTimer();
        this.startAutoZOutTimer();
        this.startInternetConnectionTimer();
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd-yyyy");
        this.serverStartupDate = dateFormat.format(now);
        this.externalIp = this.getLiteral("Unavailable");
        try {
            this.internalIp = InetAddress.getLocalHost().getHostAddress();
            URL whatismyip = new URL("http://checkip.amazonaws.com");
            URLConnection connection = whatismyip.openConnection();
            connection.addRequestProperty("Protocol", "Http/1.1");
            connection.addRequestProperty("Connection", "keep-alive");
            connection.addRequestProperty("User-Agent", "Web-Agent");
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            this.externalIp = in.readLine();
            in.close();
            connection = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Hashtable getHostSyncControlData() {
        Hashtable hostSyncControlData = null;
        if (this.posLocalData != null && this.hasHostConnector() && ((hostSyncControlData = this.posLocalData.getHostSyncControlData()) == null || hostSyncControlData.isEmpty())) {
            this.forceHostSync(false);
            hostSyncControlData = this.posLocalData.getHostSyncControlData();
        }
        return hostSyncControlData;
    }

    public void updateHostSyncStatus(String syncType, boolean changed, boolean syncInProgress) {
        if (this.posLocalData != null && this.hasHostConnector() && this.cloudDataAccess != null) {
            this.posLocalData.updateHostSyncStatus(syncType, changed, syncInProgress);
        }
    }

    public void updateHostSyncStatus(String syncType, boolean changed) {
        if (this.posLocalData != null && this.hasHostConnector() && this.cloudDataAccess != null) {
            this.posLocalData.updateHostSyncStatus(syncType, changed);
        }
    }

    public void updateHostSyncStatus(String syncType) {
        if (this.posLocalData != null && this.hasHostConnector() && this.cloudDataAccess != null) {
            this.logText(syncType + " Sync Successfully Completed");
            this.input(new Date().toString() + " " + syncType + " Sync Successfully Completed");
            this.posLocalData.updateHostSyncStatus(syncType, false);
        }
    }

    public void updateSyncedItemsLastChanged(Vector itemCodes) {
        if (this.posLocalData != null && this.hasHostConnector() && this.cloudDataAccess != null) {
            try {
                this.posLocalData.updateSyncedItemsLastChanged(itemCodes);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    public void forceHostSync(boolean startSync) {
        if (this.posLocalData != null && this.hasHostConnector() && this.cloudDataAccess != null) {
            this.logText("Host Sync Control has been reset to force all tables to Sync");
            this.input(new Date().toString() + " Host Sync Control has been reset to force all tables to Sync");
            this.posLocalData.forceHostSync();
            if (startSync) {
                this.cloudDataAccess.syncData();
            }
        }
    }

    public void setHostReply(String key, String data) {
        if (this.hostReplies == null) {
            this.hostReplies = new Hashtable();
        }
        if (key.contains("Refused")) {
            this.sendToHost("HostConnectionRefused");
        } else if (key.contains("Disabled")) {
            this.sendToHost("HostConnectionDisabled");
        } else if (key.contains("HostDelay")) {
            this.sendToHost("HostConnectionDelayed");
        } else if (key.contains("PingResponse")) {
            this.logText("Host Ping Response");
        } else if (key.contains("PingDisable")) {
            this.logText("Host Ping Disabled");
            this.disableHostPing = true;
        } else {
            this.hostReplies.put(key, data);
        }
    }

    public String getHostReply(String key) {
        if (this.hostReplies == null) {
            return null;
        }
        String reply = (String)this.hostReplies.get(key);
        this.hostReplies.remove(key);
        return reply;
    }

    public void sendToHost(String message) {
        SendToHostThread sendToHostThread = new SendToHostThread(message);
        sendToHostThread.start();
    }

    public boolean hasHostConnector() {
        return this.hostConnector != null;
    }

    public void woltOrderNotice(String message) {
        this.woltDataHandler.orderNotice(message);
    }

    public void debugLog(String text) {
        if (this.debugLog != null && this.debugLoggingOn) {
            this.debugLog.log(text);
        }
    }

    public void setGratuityItem(Item item) {
        this.gratuityItem = item;
    }

    public Item getGratuityItem() {
        return this.gratuityItem;
    }

    public void logText(String text) {
        logger.log(text);
    }

    public void logTransactionText(String what) {
        transactionLogger.log(what);
    }

    public void logAuditTrail(String from, String who, String what) {
        auditLogger.logAuditTrail(from, who, what);
    }

    void startGCTimer() {
        this.gcTimer = new Timer();
        this.gcTimer.scheduleAtFixedRate((TimerTask)new GCTask(), 600000L, 600000L);
    }

    public int getThreadCount() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        int result = bean.getThreadCount();
        return result;
    }

    public void startProcesses() {
        String serialNumber;
        EncryptionBase o;
        Class c;
        this.getLiterals();
        ATSClassLoader loader = new ATSClassLoader();
        try {
            c = loader.loadClass("Security.Encryption");
            o = null;
            if (c == null) {
                System.out.println("Encryption cls not found");
            } else {
                this.encryption = o = (EncryptionBase)c.newInstance();
            }
            if (o == null) {
                System.out.println("no object");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.raiseException(e);
        }
        loader = new ATSClassLoader();
        try {
            c = loader.loadClass("License.LicenseHandler");
            o = null;
            if (c == null) {
                System.out.println("License cls not found");
            } else {
                o = (LicenseHandlerBase)c.newInstance();
                o.initialize((ServerCore)this);
                this.licenseHandler = o;
            }
            if (o == null) {
                System.out.println("no object");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.raiseException(e);
        }
        try {
            c = loader.loadClass("CardHandlers.CardsSetupHandler");
            o = null;
            if (c == null) {
                System.out.println("CardsSetupHandler cls not found");
            } else {
                o = (CardsSetupHandlerBase)c.newInstance();
                this.cardsSetupHandler = o;
            }
            if (o == null) {
                System.out.println("no object");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.raiseException(e);
        }
        try {
            c = loader.loadClass("AccuServerConnector.WebSocketHost");
            o = null;
            if (c == null) {
                System.out.println("WebSocketHost cls not found");
            } else {
                o = (ServerObject)c.newInstance();
                o.initialize((ServerCore)this, null);
            }
            if (o == null) {
                System.out.println("no object");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.raiseException(e);
        }
        if (this.configFilename == null || this.configFilename.length() == 0) {
            this.configFilename = System.getProperty("user.dir") + "/AccuServer.cfg";
        }
        logger.log("loading " + this.configFilename);
        System.out.println("loading " + this.configFilename);
        String config = Utility.getXml((String)this.configFilename);
        if (config != null) {
            String hostEmailReceiptText;
            String pluPathText;
            String pluPortText;
            String pluAddressText;
            String printZeroFlexGroupItemsText;
            String autoChangeClientConfigText;
            String autoCreateMenuString;
            String printReportsRTL;
            String tipsTenderCodeText;
            String autoUpdatesText;
            String logTenderingText;
            String debugLogText;
            String noLogText;
            String noAuditLogText;
            ServerObject o2;
            String hostDisableText;
            Hashtable settings = new Hashtable();
            String settingsText = Utility.getElement((String)"Settings", (String)config, settings);
            String countryText = (String)settings.get("Country");
            this.country = countryText == null || countryText.isEmpty() ? "US" : countryText.trim();
            String disableCustomerBalanceText = (String)settings.get("DisableCustomerBalance");
            if (disableCustomerBalanceText != null && !disableCustomerBalanceText.isEmpty()) {
                try {
                    this.disableCustomerBalance = Boolean.parseBoolean(disableCustomerBalanceText);
                }
                catch (Exception e) {
                    this.disableCustomerBalance = false;
                }
            }
            if ((hostDisableText = (String)settings.get("DisableHostConnection")) != null && !hostDisableText.isEmpty()) {
                try {
                    this.disableHostConnection = Boolean.parseBoolean(hostDisableText);
                }
                catch (Exception e) {
                    this.disableHostConnection = false;
                }
            }
            Vector parameters = new Vector();
            Vector modules = Utility.getElementList((String)"Module", (String)config, parameters);
            int len = modules.size();
            for (int i = 0; i < len; ++i) {
                String moduleXml = (String)modules.get(i);
                if (!moduleXml.contains("TaxCalculator")) continue;
                System.out.println("starting " + moduleXml);
                logger.log("starting " + moduleXml);
                Class c2 = null;
                loader = new ATSClassLoader();
                try {
                    c2 = loader.loadClass(moduleXml);
                    o2 = null;
                    if (c2 == null) {
                        System.out.println("cls not found");
                    } else {
                        System.out.println("init class " + moduleXml);
                        o2 = (ServerObject)c2.newInstance();
                        Hashtable theseParameters = (Hashtable)parameters.get(i);
                        o2.initialize((ServerCore)this, theseParameters);
                    }
                    if (o2 != null) continue;
                    System.out.println("no object");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.raiseException(e);
                }
            }
            boolean startedAccuServerHostConnector = false;
            boolean startedAccuServerHostSync = false;
            for (int i = 0; i < len; ++i) {
                String moduleXml = (String)modules.get(i);
                if (moduleXml.contains("TaxCalculator")) continue;
                if (moduleXml.contains("AccuServerConnector.AccuServerHostConnector")) {
                    startedAccuServerHostConnector = true;
                }
                if (moduleXml.contains("AccuServerDataAccess.HostDataAccess")) {
                    startedAccuServerHostSync = true;
                }
                if (moduleXml.contains("AccuServerConnector.WebSocketHost")) continue;
                System.out.println("starting " + moduleXml);
                logger.log("starting " + moduleXml);
                Class c3 = null;
                loader = new ATSClassLoader();
                try {
                    c3 = loader.loadClass(moduleXml);
                    ServerObject o3 = null;
                    if (c3 == null) {
                        System.out.println("cls not found");
                    } else {
                        System.out.println("init class " + moduleXml);
                        o3 = (ServerObject)c3.newInstance();
                        Hashtable theseParameters = (Hashtable)parameters.get(i);
                        o3.initialize((ServerCore)this, theseParameters);
                    }
                    if (o3 != null) continue;
                    System.out.println("no object");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.raiseException(e);
                }
            }
            if (!startedAccuServerHostConnector && !this.disableHostConnection) {
                try {
                    Class<?> c4 = Class.forName("AccuServerConnector.AccuServerHostConnector");
                    o2 = null;
                    if (c4 == null) {
                        System.out.println("AccuServerHostConnector cls not found");
                    } else {
                        o2 = (ServerObject)c4.newInstance();
                        o2.initialize((ServerCore)this, null);
                    }
                    if (o2 == null) {
                        System.out.println("no object");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.raiseException(e);
                }
            }
            if (!startedAccuServerHostSync && !this.disableHostConnection) {
                try {
                    Class c5 = loader.loadClass("AccuServerDataAccess.HostDataAccess");
                    o2 = null;
                    if (c5 == null) {
                        System.out.println("HostDataAccess cls not found");
                    } else {
                        o2 = (ServerObject)c5.newInstance();
                        o2.initialize((ServerCore)this, null);
                    }
                    if (o2 == null) {
                        System.out.println("no object");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.raiseException(e);
                }
            }
            if ((noAuditLogText = (String)settings.get("NoAuditLog")) != null && !noAuditLogText.isEmpty() && noAuditLogText.equalsIgnoreCase("TRUE")) {
                auditLogger.setNoLog();
            }
            if ((noLogText = (String)settings.get("NoLog")) != null && !noLogText.isEmpty() && noLogText.equalsIgnoreCase("TRUE")) {
                logger.setNoLog();
            }
            if ((debugLogText = (String)settings.get("DebugLog")) != null && !debugLogText.isEmpty() && debugLogText.equalsIgnoreCase("TRUE")) {
                this.debugLoggingOn = true;
            }
            if ((logTenderingText = (String)settings.get("LogTendering")) != null && !logTenderingText.isEmpty() && logTenderingText.equalsIgnoreCase("True")) {
                this.logTendering = true;
            }
            if ((autoUpdatesText = (String)settings.get("AutoUpdates")) == null || autoUpdatesText.isEmpty() || autoUpdatesText.equalsIgnoreCase("True")) {
                this.autoUpdates = true;
                VersionInstaller versionInstaller = new VersionInstaller();
                versionInstaller.start();
            } else {
                this.showLoadingDataMessage(false);
            }
            String removeFoodServiceText = (String)settings.get("RemoveFoodService");
            if (removeFoodServiceText != null && removeFoodServiceText.equalsIgnoreCase("TRUE")) {
                this.removeFoodService = true;
            }
            if ((tipsTenderCodeText = (String)settings.get("TipsTenderCode")) != null && !tipsTenderCodeText.isEmpty()) {
                this.tipsTenderCode = tipsTenderCodeText;
            }
            if ((printReportsRTL = (String)settings.get("PrintReportsRTL")) != null && printReportsRTL.equalsIgnoreCase("TRUE")) {
                this.printReportsRTL = true;
            }
            if ((autoCreateMenuString = (String)settings.get("AutoCreateMenuButtons")) != null && autoCreateMenuString.equalsIgnoreCase("TRUE")) {
                this.autoCreateMenuButtons = true;
            }
            if ((autoChangeClientConfigText = (String)settings.get("AutoChangeClientConfig")) != null && !autoChangeClientConfigText.isEmpty() && autoChangeClientConfigText.equalsIgnoreCase("TRUE")) {
                this.autoChangeClientConfig = true;
            }
            if ((printZeroFlexGroupItemsText = (String)settings.get("PrintZeroFlexGroupItems")) != null && !printZeroFlexGroupItemsText.isEmpty() && printZeroFlexGroupItemsText.equalsIgnoreCase("False")) {
                this.printZeroFlexGroupItems = false;
            }
            if ((pluAddressText = (String)settings.get("PLUAddress")) != null && !pluAddressText.isEmpty()) {
                this.pluAddress = pluAddressText;
            }
            if ((pluPortText = (String)settings.get("PLUPort")) != null && !pluPortText.isEmpty()) {
                try {
                    this.pluPort = Integer.parseInt(pluPortText);
                }
                catch (Exception e) {
                    this.pluPort = 9300;
                }
            }
            if ((pluPathText = (String)settings.get("PLUPath")) != null && !pluPathText.isEmpty()) {
                this.pluPath = pluPathText;
            }
            if ((hostEmailReceiptText = (String)settings.get("HostEmailReceipt")) != null && hostEmailReceiptText.equalsIgnoreCase("TRUE")) {
                this.hostEmailReceipt = true;
            }
        }
        if ((serialNumber = this.getSerialNumber()).endsWith("0000") && this.setupDataReceiver != null) {
            SetupDataReceiverScreen setupScreen = new SetupDataReceiverScreen((ServerCore)this);
            setupScreen.displayScreen();
            this.setupDataReceiver.start();
        } else {
            this.setupDataReceiver = null;
        }
        this.licenseHandler.checkLicense(serialNumber);
        if (this.serverMonitor != null) {
            this.serverMonitor.updateSerialNumber(serialNumber);
        }
        if (this.cloudDataAccess != null) {
            this.cloudDataAccess.checkDatabase();
        }
        if (this.comoLoyaltyHandler != null) {
            this.comoLoyaltyHandler.setMerchantInfo();
        }
        this.validateAccountingIntegration();
        if (this.autoUpdates) {
            this.checkForServerUpdates();
        }
        this.startOpenSaleMessageTimer();
        this.loadStartingTransactionNumbers();
    }

    public static void main(String[] args) {
        String config = "";
        if (args.length > 0) {
            config = args[0];
        }
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                StringBuilder logText = new StringBuilder();
                logText.append("\n*** uncaughtException - " + e.getLocalizedMessage() + "\n");
                StackTraceElement[] traces = e.getStackTrace();
                for (int i = 0; i < traces.length; ++i) {
                    logText.append(traces[i] + "\n");
                }
                System.out.println(logText.toString());
                logger.log(logText.toString());
            }
        });
        AccuServerCore core = new AccuServerCore(config);
        core.startProcesses();
    }

    public void loadStartingTransactionNumbers() {
        CompanySetupInfo companyInfo = this.getCompanySetup();
        if (companyInfo != null) {
            this.currentTransactionNumber = companyInfo.transactionNumber;
            this.currentTransactionNumber = this.verifyCurrentTransactionNumber();
            this.currentInvoiceNumber = companyInfo.invoiceNumber;
            this.currentReturnNumber = companyInfo.returnNumber;
            this.currentInvoiceAccountNumber = companyInfo.invoiceAccount;
            this.currentInvoicePaymentNumber = companyInfo.invoicePayment;
            this.currentInvoiceOrderNumber = companyInfo.invoiceOrder;
            logger.log("Starting Transaction Number: " + this.currentTransactionNumber);
            logger.log("Starting Invoice Number: " + this.currentInvoiceNumber);
            logger.log("Starting Return Number: " + this.currentReturnNumber);
            logger.log("Starting Invoice Account Number: " + this.currentInvoiceAccountNumber);
            logger.log("Starting Invoice Payment Number: " + this.currentInvoicePaymentNumber);
            logger.log("Starting Invoice Order Number: " + this.currentInvoiceOrderNumber);
            logger.log("Starting Transaction Numbers Loaded");
            this.input("Starting Transaction Number: " + this.currentTransactionNumber);
            this.input("Starting Invoice Number: " + this.currentInvoiceNumber);
            this.input("Starting Return Number: " + this.currentReturnNumber);
            this.input("Starting Invoice Account Number: " + this.currentInvoiceAccountNumber);
            this.input("Starting Invoice Payment Number: " + this.currentInvoicePaymentNumber);
            this.input("Starting Invoice Order Number: " + this.currentInvoiceOrderNumber);
            this.input("Starting Transaction Numbers Loaded");
        }
    }

    public int getNextTransactionNumber() {
        int nextTransactionNumber = this.currentTransactionNumber++;
        return nextTransactionNumber;
    }

    public int getNextInvoiceNumber() {
        int nextInvoiceNumber = this.currentInvoiceNumber++;
        return nextInvoiceNumber;
    }

    public int getNextReturnNumber() {
        int nextReturnNumber = this.currentReturnNumber++;
        return nextReturnNumber;
    }

    public int getNextInvoiceAccountNumber() {
        int nextInvoiceAccountNumber = this.currentInvoiceAccountNumber++;
        return nextInvoiceAccountNumber;
    }

    public int getNextInvoicePaymentNumber() {
        int nextInvoicePaymentNumber = this.currentInvoicePaymentNumber++;
        return nextInvoicePaymentNumber;
    }

    public int getNextInvoiceOrderNumber() {
        int nextInvoiceOrderNumber = this.currentInvoiceOrderNumber++;
        return nextInvoiceOrderNumber;
    }

    public int verifyCurrentTransactionNumber() {
        if (this.posLocalData != null) {
            try {
                this.currentTransactionNumber = this.posLocalData.verifyCurrentTransactionNumber(this.currentTransactionNumber);
            }
            catch (Exception e) {
                this.raiseException(e);
            }
        }
        return this.currentTransactionNumber;
    }

    public void input(String inputText) {
        String message = inputText.replace("\n", "<br>");
        this.monitorLog.append(message);
        this.monitorLog.append("<br>");
        ServerObject thisOutput = null;
        int len = this.outputList.size();
        for (int i = 0; i < len; ++i) {
            thisOutput = (ServerObject)this.outputList.get(i);
            thisOutput.output(inputText);
        }
    }

    public void addToInputs(ServerObject object) {
        this.inputList.add(object);
    }

    public void addToOutputs(ServerObject object) {
        this.outputList.add(object);
    }

    public void setLocalDataHandler(POSData object) {
        this.posLocalData = object;
    }

    public void setLocalDataHandler(AccuShiftData object) {
        this.accuShiftLocalData = object;
    }

    public void setCloudDataHandler(CloudDataBase object) {
        this.cloudDataAccess = object;
    }

    public void setAlternateTaxesList(POSDataContainer list) {
        this.alternateTaxAuthoritiesList = list;
    }

    public void setTenderCodesList(POSDataContainer list) {
        this.tenderCodesList = list;
    }

    public void setItemList(POSDataContainer allItemCodes) {
        int len;
        POSDataContainer payoutItems = new POSDataContainer();
        if (this.itemList != null && !this.itemList.isEmpty()) {
            len = this.itemList.size();
            for (int i = len - 1; i >= 0; --i) {
                Item item = (Item)this.itemList.get(i);
                int pos = allItemCodes.indexOf((Object)item.code);
                if (pos == -1) {
                    this.itemList.remove((Object)item);
                    continue;
                }
                if (!item.type.equalsIgnoreCase("Payout")) continue;
                payoutItems.add((Object)item);
            }
            this.payoutItemList = payoutItems;
        }
        len = this.itemList.size();
        System.out.println("item count " + len);
    }

    public void setTablesList(POSDataContainer list) {
        this.tablesList = list;
        int len = list.size();
        System.out.println("table count " + len);
    }

    public void setMenuKeysList(POSDataContainer list) {
        this.menuKeysList = list;
        int len = list.size();
        System.out.println("menu keys count " + len);
    }

    public void stop() {
        this.stop(true);
    }

    public void stop(boolean confirmClose) {
        int result = 0;
        if (confirmClose) {
            String message = this.getLiteral("Are you sure you want to Close AccuServer?");
            String title = this.getLiteral("Close AccuServer");
            result = JOptionPane.showConfirmDialog(null, message, title, 0, 0);
        }
        if (result == 0) {
            if (this.posLocalData != null) {
                this.posLocalData.shutDown();
            }
            if (this.accuShiftLocalData != null) {
                this.accuShiftLocalData.shutDown();
            }
            if (this.cloudDataAccess != null) {
                this.cloudDataAccess.shutDown();
            }
            if (this.webServer != null) {
                this.webServer.stopServer();
            }
            System.exit(0);
        }
    }

    public void setLoyaltyRedeemable(Order order) {
        if (this.loyaltyHandler != null) {
            this.loyaltyHandler.setRedeemable(order);
        }
    }

    public double getLoyaltyOrderPoints(Order order) {
        if (this.loyaltyHandler != null) {
            return this.loyaltyHandler.getOrderPoints(order);
        }
        return 0.0;
    }

    public void getLoyaltyPlanBalances(Customer customer) {
        if (this.loyaltyHandler != null) {
            this.loyaltyHandler.getPlanBalances(customer);
        }
    }

    public void addToExceptions(ServerObject object) {
        this.exceptionList.add(object);
    }

    public void handleException(Exception e) {
        StackTraceElement[] traces = e.getStackTrace();
        int len = traces.length;
        String logText = e.getClass().getName() + " " + e.getLocalizedMessage();
        for (int i = 0; i < len; ++i) {
            logText = logText + traces[i] + "\n";
        }
        this.input(logText);
        logger.log(logText);
        if (this.emailExceptionHandler != null) {
            this.emailException("", e);
        }
    }

    public void raiseException(Exception e) {
        this.handleException(e);
    }

    public Item findPOSItemByCode(String code) {
        int pos;
        Item item = null;
        Item replyItem = null;
        if (this.itemList != null && (pos = this.itemList.indexOf((Object)new Item(code, "", "", "", 0.0, 0.0, true))) >= 0) {
            item = (Item)this.itemList.get(pos);
        }
        if (item != null) {
            replyItem = new Item(item);
            if (replyItem != null) {
                this.accuServerTaxHandler.calculatePriceWithTax(replyItem);
            }
            return replyItem;
        }
        return item;
    }

    public Item findItemByCode(String code) {
        return this.findItemByCode(code, new Date().getTime());
    }

    public Item findItemByCode(String code, boolean stockOnly) {
        return this.findItemByCode(code, new Date().getTime(), stockOnly, false);
    }

    public Item findItemByCode(String code, boolean stockOnly, boolean isAccuCount) {
        return this.findItemByCode(code, new Date().getTime(), stockOnly, isAccuCount);
    }

    public Item findItemByCode(String code, long localTime) {
        return this.findItemByCode(code, localTime, false, false);
    }

    public Item findItemByCode(String code, long localTime, boolean stockOnly, boolean isAccuCount) {
        Item item = null;
        Item replyItem = null;
        if (this.itemList != null) {
            int pos;
            boolean isSystemItem = false;
            if (code != null && !code.isEmpty() && (code.contains("UndefinedChoice") || code.contains("Undefined") || code.contains("FIRE") || code.contains("Discount") || code.contains("Delivery") || code.contains("DISC"))) {
                isSystemItem = true;
            }
            if ((pos = this.itemList.indexOf((Object)new Item(code, "", "", "", 0.0, 0.0, true))) >= 0) {
                item = (Item)this.itemList.get(pos);
                if (item != null && !isSystemItem && item.inactive) {
                    item = new Item();
                    item.code = "*Item_Invalid*";
                    item.description = this.getLiteral("This item - " + code + " - is inactive and cannot be sold");
                    return item;
                }
                if (stockOnly && !item.isStock && !isAccuCount) {
                    item = new Item();
                    item.code = "*Item_Invalid*";
                    item.description = this.getLiteral("This item - " + code + " - is out of stock and cannot be sold");
                    return item;
                }
                if (item != null && item.type != null && this.messagesList != null && (pos = this.messagesList.indexOf((Object)item.type)) >= 0) {
                    try {
                        item.operatorMessageText = this.posLocalData.getOperatorMessage(item.type);
                        item.operatorMessage = true;
                    }
                    catch (Exception ex) {
                        this.raiseException(ex);
                    }
                }
            }
        }
        if (item != null) {
            replyItem = new Item(item);
            if (replyItem != null) {
                this.accuServerTaxHandler.calculatePriceWithTax(replyItem);
                this.accuServerTaxHandler.getItemPriceLevelPrice(replyItem, localTime);
                this.accuServerTaxHandler.checkFlexGroupItemInEffect(replyItem, localTime);
            }
            return replyItem;
        }
        try {
            int prefixLen = this.barCodeSetup.prefix.length();
            int codeLen = 0;
            if (code != null) {
                codeLen = code.length();
            }
            if (prefixLen > 0 && codeLen > prefixLen && code.substring(0, prefixLen).equals(this.barCodeSetup.prefix)) {
                String itemCode;
                int pos;
                int itemStart = this.barCodeSetup.itemStart - 1;
                int itemEnd = itemStart + this.barCodeSetup.itemLength;
                if (itemStart < code.length() && itemEnd < code.length() && (pos = this.itemList.indexOf((Object)new Item(itemCode = code.substring(itemStart, itemStart + this.barCodeSetup.itemLength), "", "", "", 0.0, 0.0, true))) >= 0) {
                    item = (Item)this.itemList.get(pos);
                    if (item != null && item.inactive) {
                        item = new Item();
                        item.code = "*Item_Invalid*";
                        item.description = this.getLiteral("This item - " + code + " - is inactive and cannot be sold");
                        return item;
                    }
                    replyItem = new Item(item);
                    if (replyItem != null) {
                        this.accuServerTaxHandler.calculatePriceWithTax(replyItem);
                        if (this.barCodeSetup.priceStart > 0) {
                            int priceStart = this.barCodeSetup.priceStart - 1;
                            if (codeLen >= priceStart + this.barCodeSetup.priceLength) {
                                double roundedQuantity;
                                String barcodePrice = code.substring(priceStart, priceStart + this.barCodeSetup.priceLength);
                                double total = Double.valueOf(barcodePrice) / Double.valueOf(this.barCodeSetup.priceDivisor);
                                if (replyItem.price < 1.0E-4 && replyItem.price > -1.0E-4) {
                                    replyItem.embeddedBarcodePrice = true;
                                    replyItem.price = total;
                                } else {
                                    replyItem.embeddedBarcodeQuantity = true;
                                }
                                double quantity = total / replyItem.price;
                                double divisor = 1000.0;
                                replyItem.quantity = roundedQuantity = (double)Math.round(quantity * divisor) / divisor;
                                return replyItem;
                            }
                            return null;
                        }
                        if (this.barCodeSetup.weightStart > 0) {
                            int weightStart = this.barCodeSetup.weightStart - 1;
                            if (codeLen >= weightStart + this.barCodeSetup.weightLength) {
                                double roundedWeight;
                                String weight = code.substring(weightStart, weightStart + this.barCodeSetup.weightLength);
                                replyItem.quantity = roundedWeight = Double.valueOf(weight) / (double)this.barCodeSetup.weightDivisor;
                                replyItem.embeddedBarcodeQuantity = true;
                                return replyItem;
                            }
                            return null;
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return item;
    }

    public POSDataContainer getTablesList() {
        return this.tablesList;
    }

    public POSDataContainer getItemList() {
        return this.itemList;
    }

    public POSDataContainer getPayoutItemList() {
        return this.payoutItemList;
    }

    public POSDataContainer getChoicesList() {
        return this.choicesList;
    }

    public POSDataContainer getTenderCodesList() {
        if (this.tipsTenderCode.isEmpty()) {
            return this.tenderCodesList;
        }
        POSDataContainer tenderCodes = new POSDataContainer();
        int len = this.tenderCodesList.size();
        for (int i = 0; i < len; ++i) {
            TenderCode thisTenderCode = (TenderCode)this.tenderCodesList.get(i);
            if (thisTenderCode.code.equalsIgnoreCase(this.tipsTenderCode)) continue;
            tenderCodes.add((Object)thisTenderCode);
        }
        return tenderCodes;
    }

    public POSDataContainer getMenuKeysList() {
        return this.menuKeysList;
    }

    public void updateMenuKeyCacheForItem(Item updateItem) {
        if (this.menuKeysList != null) {
            int numKeys = this.menuKeysList.size();
            for (int i = 0; i < numKeys; ++i) {
                MenuKey thisKey = (MenuKey)this.menuKeysList.get(i);
                if (thisKey.text.compareToIgnoreCase(updateItem.code) != 0) continue;
                if (updateItem.itemExtended != null) {
                    thisKey.imageUrl = updateItem.itemExtended.imageUrl;
                    thisKey.detailedDescription = updateItem.itemExtended.detailedDescription;
                    thisKey.imageCreated = updateItem.itemExtended.imageCreated;
                }
                thisKey.price = updateItem.price;
                this.menuKeysList.set(i, (Object)thisKey);
            }
        }
    }

    public void updateMenuKeyCacheForItemList(POSDataContainer items) {
        int len = items.size();
        for (int i = 0; i < len; ++i) {
            Item updateItem = (Item)items.get(i);
            if (this.menuKeysList == null) continue;
            int numKeys = this.menuKeysList.size();
            for (int k = 0; k < numKeys; ++k) {
                MenuKey thisKey = (MenuKey)this.menuKeysList.get(k);
                if (thisKey.text.compareToIgnoreCase(updateItem.code) != 0) continue;
                if (updateItem.itemExtended != null) {
                    thisKey.imageUrl = updateItem.itemExtended.imageUrl;
                    thisKey.detailedDescription = updateItem.itemExtended.detailedDescription;
                    thisKey.imageCreated = updateItem.itemExtended.imageCreated;
                }
                thisKey.price = updateItem.price;
                this.menuKeysList.set(k, (Object)thisKey);
            }
        }
    }

    public void saveAllItems(POSDataContainer list, boolean updateItems) {
        this.saveAllItems(list, updateItems, true);
    }

    public void saveAllItems(POSDataContainer list, boolean updateItems, boolean useThread) {
        boolean hasDeliScaleItems = false;
        try {
            POSDataContainer deliScaleCategories = new POSDataContainer();
            POSDataContainer categories = this.getAllItemCategories();
            int categoriesLen = 0;
            if (categories != null) {
                categoriesLen = categories.size();
            }
            for (int i = 0; i < categoriesLen; ++i) {
                ItemCategory thisCategory = (ItemCategory)categories.get(i);
                if (!thisCategory.deliScale) continue;
                deliScaleCategories.add((Object)thisCategory.category);
            }
            if (useThread) {
                StringBuilder itemsXml = new StringBuilder();
                int len = list.size();
                for (int i = 0; i < len; ++i) {
                    Item item = (Item)list.get(i);
                    if (deliScaleCategories.contains((Object)item.itemCategory)) {
                        hasDeliScaleItems = true;
                    }
                    itemsXml.append(item.toXml());
                }
                String command = "<Action>SaveAllItems</Action>" + itemsXml.toString() + "<UpdateItems>" + updateItems + "</UpdateItems>";
                this.posLocalData.setCommand(command);
                itemsXml.setLength(0);
                if (hasDeliScaleItems) {
                    ExportPLU exportPLU = new ExportPLU();
                    exportPLU.start();
                }
            } else {
                int len = list.size();
                for (int i = 0; i < len; ++i) {
                    Item item = (Item)list.get(i);
                    if (!deliScaleCategories.contains((Object)item.itemCategory)) continue;
                    hasDeliScaleItems = true;
                }
                this.posLocalData.saveAllItems(list, updateItems);
                if (hasDeliScaleItems) {
                    ExportPLU exportPLU = new ExportPLU();
                    exportPLU.start();
                }
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public TenderCode getTenderCode(String code) {
        TenderCode tenderCode = null;
        int len = this.tenderCodesList.size();
        for (int i = 0; i < len; ++i) {
            TenderCode thisCode = (TenderCode)this.tenderCodesList.get(i);
            if (!thisCode.code.equalsIgnoreCase(code)) continue;
            return thisCode;
        }
        return tenderCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLog() {
        File outFile = null;
        Writer output = null;
        try {
            outFile = new File(System.getProperty("user.dir") + "\\log.txt");
            output = new BufferedWriter(new FileWriter(outFile, true));
            output.write(new String(this.log));
        }
        catch (Exception e) {
            this.raiseException(e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException ex) {
                    this.raiseException(ex);
                }
            }
        }
    }

    public void addToLog(String xml) {
        if (this.log == null) {
            this.log = new StringBuffer();
        }
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM-dd-yyyy HH:mm:ss:SSS");
        this.log.append(xml + " " + dateFormat.format(now) + "\r\n");
        logger.log(this.log.toString());
    }

    public Vector getOpenOrders(String orderId) {
        this.debugLog("core - get open orders for id " + orderId);
        Vector orders = null;
        try {
            this.debugLog("core - calling DB for for id " + orderId);
            orders = this.posLocalData.getOpenOrders(orderId);
            this.debugLog("core - DB returned - calculating taxes");
            if (this.accuServerTaxHandler != null && orders.size() > 0) {
                for (int i = 0; i < orders.size(); ++i) {
                    Order order = (Order)orders.get(i);
                    this.accuServerTaxHandler.calculateOrderTaxes(order);
                }
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        this.debugLog("core - returning orders for id " + orderId);
        return orders;
    }

    public Vector getOrdersByOrderId(String orderId) {
        this.debugLog("core - get open orders for id " + orderId);
        Vector orders = null;
        try {
            this.debugLog("core - calling DB for for id " + orderId);
            orders = this.posLocalData.getOrdersByOrderId(orderId);
            this.debugLog("core - DB returned - calculating taxes");
            if (this.accuServerTaxHandler != null && orders.size() > 0) {
                for (int i = 0; i < orders.size(); ++i) {
                    Order order = (Order)orders.get(i);
                    this.accuServerTaxHandler.calculateOrderTaxes(order);
                }
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        this.debugLog("core - returning orders for id " + orderId);
        return orders;
    }

    public byte[] getImage(String filename) {
        byte[] bytes = null;
        File file = null;
        FileInputStream fis = null;
        try {
            file = new File(System.getProperty("user.dir") + "/images/" + filename);
            if (file.exists()) {
                fis = new FileInputStream(file);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        if (fis != null) {
            ByteArrayOutputStream bos = null;
            byte[] buf = new byte[4096];
            try {
                int readNum;
                bos = new ByteArrayOutputStream();
                while ((readNum = fis.read(buf)) != -1) {
                    bos.write(buf, 0, readNum);
                }
            }
            catch (IOException ex) {
                this.handleException(ex);
            }
            bytes = bos.toByteArray();
        }
        return bytes;
    }

    public String getClientConfiguration(String name) {
        String name2 = "";
        if (name.isEmpty()) {
            return "";
        }
        int dash = name.indexOf(45);
        if (dash > -1 && ++dash < name.length()) {
            name2 = name.substring(dash);
            name = name.substring(0, dash - 1);
        }
        String result = "";
        String folder = System.getProperty("user.dir") + "/ClientConfigurations";
        String filename = folder + "/" + name + ".cfg";
        String debugFilename = "";
        if (!name2.isEmpty()) {
            debugFilename = folder + "/" + name + "-" + name2 + ".cfc";
        }
        result = Utility.getXml((String)filename);
        if (!name2.isEmpty()) {
            filename = folder + "/" + name2 + ".cfg";
            String result2 = Utility.getXml((String)filename);
            if (result != null && result2 != null && !result2.isEmpty() && this.autoChangeClientConfig) {
                this.input("Replacing Sizing for: " + filename);
                result2 = this.replacePCPOSClientConfigSizing(result2, filename);
                this.updateClientConfiguration(name2, result2);
            }
            result = result != null && result2 != null && !result2.isEmpty() ? this.combineConfigurations(result, result2) : "";
        }
        if (!name2.isEmpty()) {
            try {
                Utility.writeXml((String)debugFilename, (String)result);
            }
            catch (IOException ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public String combineConfigurations(String configuration1, String configuration2) {
        String name;
        String value;
        ModuleParameters configOne;
        Hashtable paramsTable;
        ModuleParameters moduleParameters;
        int i;
        Enumeration moduleParametersListNames;
        Vector moduleParametersList;
        int m;
        Hashtable paramsTable2;
        ModuleParameters moduleParameters2;
        String combinedConfiguration = "";
        Vector<String> moduleNames = new Vector<String>();
        Object result = null;
        Vector module1Params = new Vector();
        Vector printers1Params = new Vector();
        Vector shiftPrinters1Params = new Vector();
        Vector settings1Params = new Vector();
        Vector modules1 = Utility.getElementList((String)"Module", (String)configuration1, module1Params);
        Vector printers1 = Utility.getElementList((String)"Printer", (String)configuration1, printers1Params);
        Vector shiftPrinters1 = Utility.getElementList((String)"ShiftPrinter", (String)configuration1, shiftPrinters1Params);
        Vector settings1 = Utility.getElementList((String)"Settings", (String)configuration1, settings1Params);
        Vector module2Params = new Vector();
        Vector printers2Params = new Vector();
        Vector shiftPrinters2Params = new Vector();
        Vector settings2Params = new Vector();
        Vector modules2 = Utility.getElementList((String)"Module", (String)configuration2, module2Params);
        Vector printers2 = Utility.getElementList((String)"Printer", (String)configuration2, printers2Params);
        Vector shiftPrinters2 = Utility.getElementList((String)"ShiftPrinter", (String)configuration2, shiftPrinters2Params);
        Vector settings2 = Utility.getElementList((String)"Settings", (String)configuration2, settings2Params);
        int len = modules1.size();
        Hashtable<String, ModuleParameters> configOneTable = new Hashtable<String, ModuleParameters>();
        for (int i2 = 0; i2 < len; ++i2) {
            String moduleName = (String)modules1.get(i2);
            Hashtable paramsTable3 = (Hashtable)module1Params.get(i2);
            String thisType = (String)paramsTable3.get("Type");
            if (thisType != null) {
                moduleName = moduleName + "/" + thisType;
            }
            moduleParameters2 = new ModuleParameters();
            moduleParameters2.name = moduleName;
            moduleParameters2.parameters = paramsTable3;
            moduleNames.add(moduleName);
            configOneTable.put(moduleName, moduleParameters2);
        }
        int len2 = modules2.size();
        for (int i3 = 0; i3 < len2; ++i3) {
            String moduleName = (String)modules2.get(i3);
            int pos = moduleNames.indexOf(moduleName);
            if (pos < 0) {
                moduleNames.add(moduleName);
            }
            paramsTable2 = (Hashtable)module2Params.get(i3);
            ModuleParameters configOne2 = (ModuleParameters)configOneTable.get(moduleName);
            if (configOne2 == null) {
                ModuleParameters moduleParameters3 = new ModuleParameters();
                moduleParameters3.name = moduleName;
                moduleParameters3.parameters = paramsTable2;
                configOneTable.put(moduleName, moduleParameters3);
                continue;
            }
            Vector parametersList = new Vector(paramsTable2.values());
            Enumeration parametersListNames = paramsTable2.keys();
            int len3 = parametersList.size();
            for (int p = 0; p < len3; ++p) {
                String value2 = (String)parametersList.get(p);
                String name2 = "";
                if (parametersListNames.hasMoreElements()) {
                    name2 = (String)parametersListNames.nextElement();
                }
                configOne2.parameters.put(name2, value2);
            }
        }
        int modulesLen = moduleNames.size();
        for (m = 0; m < modulesLen; ++m) {
            String moduleName = (String)moduleNames.get(m);
            moduleParameters2 = (ModuleParameters)configOneTable.get(moduleName);
            if (moduleParameters2 == null) continue;
            combinedConfiguration = combinedConfiguration + "<Module";
            moduleParametersList = new Vector(moduleParameters2.parameters.values());
            moduleParametersListNames = moduleParameters2.parameters.keys();
            int paramslen = moduleParametersList.size();
            for (int mp = 0; mp < paramslen; ++mp) {
                String value3 = (String)moduleParametersList.get(mp);
                String name3 = "";
                if (moduleParametersListNames.hasMoreElements()) {
                    name3 = (String)moduleParametersListNames.nextElement();
                }
                combinedConfiguration = combinedConfiguration + " " + name3 + "=" + value3;
            }
            if (moduleParameters2.name.contains("/")) {
                moduleParameters2.name = moduleParameters2.name.substring(0, moduleParameters2.name.indexOf("/"));
            }
            combinedConfiguration = combinedConfiguration + ">" + moduleParameters2.name + "</Module>\r\n";
        }
        len = printers1.size();
        configOneTable = new Hashtable();
        moduleNames = new Vector();
        for (i = 0; i < len; ++i) {
            String moduleName = (String)printers1.get(i);
            moduleNames.add(moduleName);
            paramsTable2 = (Hashtable)printers1Params.get(i);
            moduleParameters = new ModuleParameters();
            moduleParameters.name = moduleName;
            moduleParameters.parameters = paramsTable2;
            configOneTable.put(moduleName, moduleParameters);
        }
        len2 = printers2.size();
        for (i = 0; i < len2; ++i) {
            String moduleName = (String)printers2.get(i);
            int pos = moduleNames.indexOf(moduleName);
            if (pos < 0) {
                moduleNames.add(moduleName);
            }
            paramsTable = (Hashtable)printers2Params.get(i);
            configOne = (ModuleParameters)configOneTable.get(moduleName);
            if (configOne == null) {
                ModuleParameters moduleParameters4 = new ModuleParameters();
                moduleParameters4.name = moduleName;
                moduleParameters4.parameters = paramsTable;
                configOneTable.put(moduleName, moduleParameters4);
                continue;
            }
            Vector parametersList = new Vector(paramsTable.values());
            Enumeration parametersListNames = paramsTable.keys();
            int len3 = parametersList.size();
            for (int p = 0; p < len3; ++p) {
                value = (String)parametersList.get(p);
                name = "";
                if (parametersListNames.hasMoreElements()) {
                    name = (String)parametersListNames.nextElement();
                }
                configOne.parameters.put(name, value);
            }
        }
        modulesLen = moduleNames.size();
        for (m = 0; m < modulesLen; ++m) {
            String moduleName = (String)moduleNames.get(m);
            ModuleParameters moduleParameters5 = (ModuleParameters)configOneTable.get(moduleName);
            if (moduleParameters5 == null) continue;
            combinedConfiguration = combinedConfiguration + "<Printer";
            moduleParametersList = new Vector(moduleParameters5.parameters.values());
            moduleParametersListNames = moduleParameters5.parameters.keys();
            int paramslen = moduleParametersList.size();
            for (int mp = 0; mp < paramslen; ++mp) {
                String value4 = (String)moduleParametersList.get(mp);
                String name4 = "";
                if (moduleParametersListNames.hasMoreElements()) {
                    name4 = (String)moduleParametersListNames.nextElement();
                }
                combinedConfiguration = combinedConfiguration + " " + name4 + "=" + value4;
            }
            combinedConfiguration = combinedConfiguration + ">" + moduleParameters5.name + "</Printer>\r\n";
        }
        len = shiftPrinters1.size();
        configOneTable = new Hashtable();
        moduleNames = new Vector();
        for (i = 0; i < len; ++i) {
            String moduleName = (String)shiftPrinters1.get(i);
            moduleNames.add(moduleName);
            Hashtable paramsTable4 = (Hashtable)shiftPrinters1Params.get(i);
            moduleParameters = new ModuleParameters();
            moduleParameters.name = moduleName;
            moduleParameters.parameters = paramsTable4;
            configOneTable.put(moduleName, moduleParameters);
        }
        len2 = shiftPrinters2.size();
        for (i = 0; i < len2; ++i) {
            String moduleName = (String)shiftPrinters2.get(i);
            int pos = moduleNames.indexOf(moduleName);
            if (pos < 0) {
                moduleNames.add(moduleName);
            }
            paramsTable = (Hashtable)shiftPrinters2Params.get(i);
            configOne = (ModuleParameters)configOneTable.get(moduleName);
            if (configOne == null) {
                ModuleParameters moduleParameters6 = new ModuleParameters();
                moduleParameters6.name = moduleName;
                moduleParameters6.parameters = paramsTable;
                configOneTable.put(moduleName, moduleParameters6);
                continue;
            }
            Vector parametersList = new Vector(paramsTable.values());
            Enumeration parametersListNames = paramsTable.keys();
            int len3 = parametersList.size();
            for (int p = 0; p < len3; ++p) {
                value = (String)parametersList.get(p);
                name = "";
                if (parametersListNames.hasMoreElements()) {
                    name = (String)parametersListNames.nextElement();
                }
                configOne.parameters.put(name, value);
            }
        }
        modulesLen = moduleNames.size();
        for (m = 0; m < modulesLen; ++m) {
            String moduleName = (String)moduleNames.get(m);
            ModuleParameters moduleParameters7 = (ModuleParameters)configOneTable.get(moduleName);
            if (moduleParameters7 == null) continue;
            combinedConfiguration = combinedConfiguration + "<ShiftPrinter";
            moduleParametersList = new Vector(moduleParameters7.parameters.values());
            moduleParametersListNames = moduleParameters7.parameters.keys();
            int paramslen = moduleParametersList.size();
            for (int mp = 0; mp < paramslen; ++mp) {
                String value5 = (String)moduleParametersList.get(mp);
                String name5 = "";
                if (moduleParametersListNames.hasMoreElements()) {
                    name5 = (String)moduleParametersListNames.nextElement();
                }
                combinedConfiguration = combinedConfiguration + " " + name5 + "=" + value5;
            }
            combinedConfiguration = combinedConfiguration + ">" + moduleParameters7.name + "</ShiftPrinter>\r\n";
        }
        len = settings1.size();
        configOneTable = new Hashtable();
        moduleNames = new Vector();
        for (i = 0; i < len; ++i) {
            String moduleName = (String)settings1.get(i);
            moduleNames.add(moduleName);
            Hashtable paramsTable5 = (Hashtable)settings1Params.get(i);
            moduleParameters = new ModuleParameters();
            moduleParameters.name = moduleName;
            moduleParameters.parameters = paramsTable5;
            configOneTable.put(moduleName, moduleParameters);
        }
        len2 = settings2.size();
        for (i = 0; i < len2; ++i) {
            String moduleName = (String)settings2.get(i);
            int pos = moduleNames.indexOf(moduleName);
            if (pos < 0) {
                moduleNames.add(moduleName);
            }
            paramsTable = (Hashtable)settings2Params.get(i);
            configOne = (ModuleParameters)configOneTable.get(moduleName);
            if (configOne == null) {
                ModuleParameters moduleParameters8 = new ModuleParameters();
                moduleParameters8.name = moduleName;
                moduleParameters8.parameters = paramsTable;
                configOneTable.put(moduleName, moduleParameters8);
                continue;
            }
            Vector parametersList = new Vector(paramsTable.values());
            Enumeration parametersListNames = paramsTable.keys();
            int len3 = parametersList.size();
            for (int p = 0; p < len3; ++p) {
                value = (String)parametersList.get(p);
                name = "";
                if (parametersListNames.hasMoreElements()) {
                    name = (String)parametersListNames.nextElement();
                }
                configOne.parameters.put(name, value);
            }
        }
        modulesLen = moduleNames.size();
        for (m = 0; m < modulesLen; ++m) {
            String moduleName = (String)moduleNames.get(m);
            ModuleParameters moduleParameters9 = (ModuleParameters)configOneTable.get(moduleName);
            if (moduleParameters9 == null) continue;
            combinedConfiguration = combinedConfiguration + "<Settings";
            moduleParametersList = new Vector(moduleParameters9.parameters.values());
            moduleParametersListNames = moduleParameters9.parameters.keys();
            int paramslen = moduleParametersList.size();
            for (int mp = 0; mp < paramslen; ++mp) {
                String value6 = (String)moduleParametersList.get(mp);
                String name6 = "";
                if (moduleParametersListNames.hasMoreElements()) {
                    name6 = (String)moduleParametersListNames.nextElement();
                }
                combinedConfiguration = combinedConfiguration + " " + name6 + "=" + value6;
            }
            combinedConfiguration = combinedConfiguration + ">" + moduleParameters9.name + "</Settings>\r\n";
        }
        String secondaryPrinters = this.getSecondaryPrinterModuleLines(configuration2);
        if (secondaryPrinters != null && secondaryPrinters.length() > 0) {
            combinedConfiguration = combinedConfiguration + secondaryPrinters;
        }
        return combinedConfiguration;
    }

    private String getSecondaryPrinterModuleLines(String configXml) {
        String lines = "";
        String moduleLine = "";
        String startTag = "<SecondaryPrinter";
        String endTag = "</SecondaryPrinter>";
        int lastEnd = 0;
        int endPos = configXml.indexOf(endTag);
        while (endPos >= 0) {
            int startPos = configXml.indexOf(startTag, lastEnd + 1);
            if (endPos > startPos) {
                moduleLine = configXml.substring(startPos, endPos + endTag.length());
            }
            if (!moduleLine.startsWith("<SecondaryPrinter") || !moduleLine.endsWith("</SecondaryPrinter>")) break;
            lines = lines + moduleLine + "\r\n";
            lastEnd = endPos + endTag.length();
            endPos = configXml.indexOf(endTag, lastEnd);
        }
        return lines;
    }

    private String replacePCPOSClientConfigSizing(String stationConfigXml, String stationConfigName) {
        StringBuilder module = new StringBuilder();
        String baseModulesConfigXml = this.getClientConfiguration("POSModules");
        Vector configModuleParms = new Vector();
        Vector configModules = Utility.getElementList((String)"Module", (String)stationConfigXml, configModuleParms);
        Vector baseModuleParms = new Vector();
        String FsRt = "";
        FsRt = stationConfigXml.indexOf("DisplayRetailOrderView") > -1 ? "RT" : "FS";
        Vector baseModules = Utility.getElementList((String)"Module", (String)baseModulesConfigXml, baseModuleParms);
        int configLen = configModules.size();
        int baseLen = baseModules.size();
        boolean foundGraphicsProvider = false;
        boolean foundPOSMessageBox = false;
        for (int i = 0; i < configLen; ++i) {
            String parm;
            Enumeration baseE;
            String moduleXml = (String)configModules.get(i);
            Hashtable configParameters = (Hashtable)configModuleParms.get(i);
            String baseModule = "";
            String newModuleName = "";
            String genericModuleName = "";
            Hashtable baseParameters = null;
            for (int b = 0; b < baseLen; ++b) {
                String thisModule = (String)baseModules.get(b);
                if (thisModule.indexOf("</Sizing>") > -1) {
                    thisModule = "<Sizing>" + thisModule;
                }
                String sizingBlock = Utility.getXmlBlock((String)"Sizing", (String)thisModule);
                String foodServiceBlock = Utility.getXmlBlock((String)"FS", (String)sizingBlock);
                String retailBlock = Utility.getXmlBlock((String)"RT", (String)sizingBlock);
                if (!retailBlock.isEmpty() && !foodServiceBlock.isEmpty()) {
                    if (baseModulesConfigXml.indexOf("DisplayRetailOrderView") > -1) {
                        thisModule = Utility.replaceXmlBlock((String)thisModule, (String)"Sizing", (String)retailBlock);
                        thisModule = thisModule.replace("<RT>", "");
                        thisModule = thisModule.replace("</RT>", "");
                    } else {
                        thisModule = Utility.replaceXmlBlock((String)thisModule, (String)"Sizing", (String)foodServiceBlock);
                        thisModule = thisModule.replace("<FS>", "");
                        thisModule = thisModule.replace("</FS>", "");
                    }
                    int blockStart = thisModule.indexOf("<Module", 0);
                    int startTagEnd = thisModule.indexOf(">", blockStart);
                    String name = "Module";
                    String parametersText = thisModule.substring(blockStart + name.length() + 1, startTagEnd);
                    String[] pairs = parametersText.split(" ");
                    Hashtable<String, String> theseParameters = new Hashtable<String, String>();
                    String lastName = "";
                    for (int t = 0; t < pairs.length; ++t) {
                        String[] thisPair = pairs[t].split("=");
                        if (thisPair.length > 1) {
                            lastName = thisPair[0].trim();
                            if (thisPair[1].contains("N/A") || thisPair[1].contains("n/a")) continue;
                            theseParameters.put(lastName, thisPair[1]);
                            continue;
                        }
                        if (lastName == null || lastName.length() <= 0) continue;
                        String value = (String)theseParameters.get(lastName);
                        if ((value = value + " " + thisPair[0]).contains("N/A") || value.contains("n/a")) continue;
                        theseParameters.put(lastName, value.trim());
                    }
                    baseModuleParms.set(b, theseParameters);
                }
                newModuleName = this.getNewModuleName(moduleXml);
                genericModuleName = this.getGenericModuleName(newModuleName);
                String thisModuleName = this.getNewModuleName(thisModule);
                if (!thisModuleName.equalsIgnoreCase(newModuleName)) continue;
                baseParameters = (Hashtable)baseModuleParms.get(b);
                baseModule = thisModule;
                break;
            }
            int baseTop = -1;
            int baseLeft = -1;
            int baseWidth = -1;
            int baseHeight = -1;
            module.append("<Module ");
            String thisModuleName = this.getNewModuleName(baseModule);
            if (thisModuleName.equals("AccuPOSView.QuickBarButtonGP")) {
                baseE = configParameters.keys();
                boolean isNotQuickbarButton = false;
                while (baseE.hasMoreElements()) {
                    String key = (String)baseE.nextElement();
                    String parm2 = (String)baseParameters.get(key);
                    if (key.compareToIgnoreCase("Left") != 0) continue;
                    isNotQuickbarButton = true;
                    break;
                }
                if (isNotQuickbarButton) {
                    newModuleName = "AccuPOSView.QuickBarGP";
                    thisModuleName = "AccuPOSView.QuickBarGP";
                }
            }
            if (thisModuleName.equals("AccuPOSView.GraphicsProviderWhite")) {
                foundGraphicsProvider = true;
            } else if (thisModuleName.equals("AccuPOSView.POSMessageBox")) {
                foundPOSMessageBox = true;
            }
            if (!baseModule.isEmpty() && thisModuleName.compareToIgnoreCase(newModuleName) == 0) {
                baseE = baseParameters.keys();
                while (baseE.hasMoreElements()) {
                    String key = (String)baseE.nextElement();
                    parm = (String)baseParameters.get(key);
                    if (key.compareToIgnoreCase("Top") == 0) {
                        try {
                            baseTop = Integer.parseInt(parm);
                        }
                        catch (Exception e) {
                            baseTop = -1;
                        }
                    }
                    if (key.compareToIgnoreCase("Left") == 0) {
                        try {
                            baseLeft = Integer.parseInt(parm);
                        }
                        catch (Exception e) {
                            baseLeft = -1;
                        }
                    }
                    if (key.compareToIgnoreCase("Width") == 0) {
                        try {
                            baseWidth = Integer.parseInt(parm);
                        }
                        catch (Exception e) {
                            baseWidth = -1;
                        }
                    }
                    if (key.compareToIgnoreCase("Height") != 0) continue;
                    try {
                        baseHeight = Integer.parseInt(parm);
                    }
                    catch (Exception e) {
                        baseHeight = -1;
                    }
                }
            }
            Enumeration configE = configParameters.keys();
            while (configE.hasMoreElements()) {
                String key = (String)configE.nextElement();
                parm = (String)configParameters.get(key);
                if (baseTop > -1 && key.compareToIgnoreCase("Top") == 0 && baseTop != -1) {
                    parm = "" + baseTop;
                }
                if (baseLeft > -1 && key.compareToIgnoreCase("Left") == 0 && baseLeft != -1) {
                    parm = "" + baseLeft;
                }
                if (baseWidth > -1 && key.compareToIgnoreCase("Width") == 0 && baseWidth != -1) {
                    parm = "" + baseWidth;
                }
                if (baseHeight > -1 && key.compareToIgnoreCase("Height") == 0 && baseHeight != -1) {
                    parm = "" + baseHeight;
                }
                module.append(key + "=" + parm + " ");
            }
            module.append(">" + newModuleName + "</Module>\r\n");
        }
        if (!foundGraphicsProvider) {
            module.append("<Module >AccuPOSView.GraphicsProviderWhite</Module>");
        }
        if (!foundPOSMessageBox) {
            module.append("<Module >AccuPOSView.POSMessageBoxGP</Module>");
        }
        return module.toString();
    }

    private String getGenericModuleName(String newModuleName) {
        String genericModuleName = "";
        if (newModuleName != null && !newModuleName.isEmpty()) {
            String countryString = this.getCountry();
            if (countryString.compareToIgnoreCase("US") != 0) {
                genericModuleName = newModuleName.replace(this.country, "");
            }
            genericModuleName = newModuleName.replace("GP", "");
        }
        return genericModuleName;
    }

    private String getNewModuleName(String oldModuleName) {
        String newModuleName = oldModuleName;
        if (oldModuleName.indexOf("AccuPOSView.AssignDeliveryOrdersView") > -1) {
            newModuleName = "AccuPOSView.AssignDeliveryOrdersViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.CanadianCardTenderScreen") > -1) {
            newModuleName = "";
        } else if (oldModuleName.indexOf("AccuPOSView.CardTenderScreen") > -1) {
            newModuleName = "AccuPOSView.CardTenderScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.CardTenderScreenIL") > -1) {
            newModuleName = "";
        } else if (oldModuleName.indexOf("AccuPOSView.CardTenderScreenILEMV") > -1) {
            newModuleName = "AccuPOSView.CardTenderScreenILEMVGP";
        } else if (oldModuleName.indexOf("AccuPOSView.CardTenderScreenSageEMV") > -1) {
            newModuleName = "";
        } else if (oldModuleName.indexOf("AccuPOSView.CardTenderScreenUKEMV") > -1) {
            newModuleName = "";
        } else if (oldModuleName.indexOf("AccuPOSView.CardTenderScreenUSEMV") > -1) {
            newModuleName = "AccuPOSView.CardTenderScreenUSEMVGP";
        } else if (oldModuleName.indexOf("AccuPOSView.CashTenderScreen") > -1) {
            newModuleName = "AccuPOSView.CashTenderScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.CheckInformationScreen") > -1) {
            newModuleName = "AccuPOSView.CheckInformationScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.CheckInformationScreenIL") > -1) {
            newModuleName = "CheckInformationScreenILGP";
        } else if (oldModuleName.indexOf("AccuPOSView.CheckTabView") > -1) {
            newModuleName = "AccuPOSView.CheckTabViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.CheckTabViewIL") > -1) {
            newModuleName = "AccuPOSView.CheckTabViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.ChoicesFreeTextView") > -1) {
            newModuleName = "AccuPOSView.ChoicesFreeTextViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.ChoicesFreeTextViewIL") > -1) {
            newModuleName = "AccuPOSView.ChoicesFreeTextViewILGP";
        } else if (oldModuleName.indexOf("AccuPOSView.ComoScanScreen") > -1) {
            newModuleName = "AccuPOSView.ComoScanScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.ComoSelectGiftsScreen") > -1) {
            newModuleName = "AccuPOSView.ComoSelectGiftsScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.CustomerHistoryScreen") > -1) {
            newModuleName = "AccuPOSView.CustomerHistoryScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.CustomerHistoryScreenIL") > -1) {
            newModuleName = "AccuPOSView.CustomerHistoryScreenILGP";
        } else if (oldModuleName.indexOf("AccuPOSView.CustomerHistoryScreenUK") > -1) {
            newModuleName = "AccuPOSView.CustomerHistoryScreenUKGP";
        } else if (oldModuleName.indexOf("AccuPOSView.DebitTenderScreen") > -1) {
            newModuleName = "AccuPOSView.DebitTenderScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.DebitTenderScreenUSEMV") > -1) {
            newModuleName = "AccuPOSView.DebitTenderScreenUSEMVGP";
        } else if (oldModuleName.indexOf("AccuPOSView.DisplayOrderView") > -1) {
            newModuleName = "AccuPOSView.DisplayOrderViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.DisplayOrderViewIL") > -1) {
            newModuleName = "AccuPOSView.DisplayOrderViewILGP";
        } else if (oldModuleName.indexOf("AccuPOSView.DisplayOrderViewNew") > -1) {
            newModuleName = "";
        } else if (oldModuleName.indexOf("AccuPOSView.DisplayOrderViewUK") > -1) {
            newModuleName = "AccuPOSView.DisplayOrderViewUKGP";
        } else if (oldModuleName.indexOf("AccuPOSView.DisplayRetailOrderView") > -1) {
            newModuleName = "AccuPOSView.DisplayRetailOrderViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.DisplayRetailOrderViewCA") > -1) {
            newModuleName = "AccuPOSView.DisplayRetailOrderViewCAGP";
        } else if (oldModuleName.indexOf("AccuPOSView.DisplayRetailOrderViewIL") > -1) {
            newModuleName = "AccuPOSView.DisplayRetailOrderViewILGP";
        } else if (oldModuleName.indexOf("AccuPOSView.DisplayRetailOrderViewUK") > -1) {
            newModuleName = "AccuPOSView.DisplayRetailOrderViewUKGP";
        } else if (oldModuleName.indexOf("AccuPOSView.DisplayTotalView") > -1) {
            newModuleName = "AccuPOSView.DisplayTotalViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.DisplayTotalViewIL") > -1) {
            newModuleName = "AccuPOSView.DisplayTotalViewILGP";
        } else if (oldModuleName.indexOf("AccuPOSView.DisplayTotalViewNew") > -1) {
            newModuleName = "";
        } else if (oldModuleName.indexOf("AccuPOSView.EConduitEMVCardTenderScreen") > -1) {
            newModuleName = "AccuPOSView.EConduitEMVCardTenderScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.EditGuestCountScreen") > -1) {
            newModuleName = "AccuPOSView.EditGuestCountScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.EditGuestCountScreenGPJN") > -1) {
            newModuleName = "";
        } else if (oldModuleName.indexOf("AccuPOSView.EditItemDescription") > -1) {
            newModuleName = "AccuPOSView.EditItemDescriptionScreenGP";
        } else if (oldModuleName.indexOf("EditItemDescriptionIL") > -1) {
            newModuleName = "AccuPOSView.EditItemDescriptionScreenILGP";
        } else if (oldModuleName.indexOf("AccuPOSView.EditItemView") > -1) {
            newModuleName = "AccuPOSView.EditItemViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.EditItemViewIL") > -1) {
            newModuleName = "AccuPOSView.EditItemViewILGP";
        } else if (oldModuleName.indexOf("AccuPOSView.EditItemViewUK") > -1) {
            newModuleName = "AccuPOSView.EditItemViewUKGP";
        } else if (oldModuleName.indexOf("AccuPOSView.EditOrderIdScreen") > -1) {
            newModuleName = "AccuPOSView.EditOrderIdScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.EditSerialNumberScreen") > -1) {
            newModuleName = "AccuPOSView.EditSerialNumberScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.FindItemView") > -1) {
            newModuleName = "AccuPOSView.FindItemViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.FindItemViewIL") > -1) {
            newModuleName = "AccuPOSView.FindItemViewILGP";
        } else if (oldModuleName.indexOf("AccuPOSView.FoodServiceMenusView") > -1) {
            newModuleName = "AccuPOSView.FoodServiceMenusViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.FoodServiceMenusViewNew") > -1) {
            newModuleName = "";
        } else if (oldModuleName.indexOf("AccuPOSView.GiftcardSalesScreen") > -1) {
            newModuleName = "AccuPOSView.GiftcardSalesScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.GiftcardTenderScreen") > -1) {
            newModuleName = "AccuPOSView.GiftcardTenderScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.KeyboardView") > -1) {
            newModuleName = "AccuPOSView.KeyboardViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.LoginManagerScreen") > -1) {
            newModuleName = "AccuPOSView.LoginManagerScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.LoginScreen") > -1) {
            newModuleName = "AccuPOSView.LoginScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.LoginScreenWithLogo") > -1) {
            newModuleName = "AccuPOSView.LoginScreenWithLogoGP";
        } else if (oldModuleName.indexOf("AccuPOSView.LoginScreenWithLogoNew") > -1) {
            newModuleName = "";
        } else if (oldModuleName.indexOf("AccuPOSView.LoginSecureScreen") > -1) {
            newModuleName = "";
        } else if (oldModuleName.indexOf("AccuPOSView.MainFrameView") > -1) {
            newModuleName = "AccuPOSView.MainFrameViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.MoneyCardBalanceScreen") > -1) {
            newModuleName = "AccuPOSView.MoneyCardBalanceScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.MoneyCardTenderScreen") > -1) {
            newModuleName = "AccuPOSView.MoneyCardTenderScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.NumberPadView") > -1) {
            newModuleName = "AccuPOSView.NumberPadViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.OptionalItemsScreen") > -1) {
            newModuleName = "AccuPOSView.OptionalItemsScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.PaymentsTabView") > -1) {
            newModuleName = "AccuPOSView.PaymentsTabViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.PaymentsTabViewIL") > -1) {
            newModuleName = "AccuPOSView.PaymentsTabViewILGP";
        } else if (oldModuleName.indexOf("AccuPOSView.PaymentsTabViewUK") > -1) {
            newModuleName = "AccuPOSView.PaymentsTabViewUKGP";
        } else if (oldModuleName.indexOf("AccuPOSView.PayoutScreen") > -1) {
            newModuleName = "AccuPOSView.PayoutScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.PickTillsScreen") > -1) {
            newModuleName = "AccuPOSView.PickTillsScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.POSMessageBox") > -1) {
            newModuleName = "AccuPOSView.POSMessageBoxGP";
        } else if (oldModuleName.indexOf("AccuPOSView.PriceQuantityChangeScreen") > -1) {
            newModuleName = "AccuPOSView.PriceQuantityChangeScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.PriceQuantityChangeScreenBase") > -1) {
            newModuleName = "";
        } else if (oldModuleName.indexOf("AccuPOSView.PriceQuantityChangeScreenVatIncluded") > -1) {
            newModuleName = "AccuPOSView.PriceQuantityChangeScreenVatIncludedGP";
        } else if (oldModuleName.indexOf("AccuPOSView.QuickBar") > -1) {
            newModuleName = "AccuPOSView.QuickBarButtonGP";
        } else if (oldModuleName.indexOf("AccuPOSView.ReceiptOptionsView") > -1) {
            newModuleName = "AccuPOSView.ReceiptOptionsViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.RetailButtonsView") > -1) {
            newModuleName = "AccuPOSView.RetailButtonsViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.ReturnSalesView") > -1) {
            newModuleName = "AccuPOSView.ReturnSalesViewIL";
        } else if (oldModuleName.indexOf("AccuPOSView.RoomChargeScreen") > -1) {
            newModuleName = "";
        } else if (oldModuleName.indexOf("AccuPOSView.SalesRepSelector") > -1) {
            newModuleName = "AccuPOSView.SalesRepSelectorGP";
        } else if (oldModuleName.indexOf("AccuPOSView.ScanLineView") > -1) {
            newModuleName = "AccuPOSView.ScanLineViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.SecurePasscodeScreen") > -1) {
            newModuleName = "";
        } else if (oldModuleName.indexOf("AccuPOSView.SelectChoicesView") > -1) {
            newModuleName = "AccuPOSView.SelectChoicesViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.SelectClosedOrderView") > -1) {
            newModuleName = "AccuPOSView.SelectClosedOrderViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.SelectCompReasonsView") > -1) {
            newModuleName = "AccuPOSView.SelectCompReasonsViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.SelectCompReasonsViewIL") > -1) {
            newModuleName = "AccuPOSView.SelectCompReasonsViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.SelectCustomerView") > -1) {
            newModuleName = "AccuPOSView.SelectCustomerViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.SelectCustomerViewCA") > -1) {
            newModuleName = "AccuPOSView.SelectCustomerViewCAGP";
        } else if (oldModuleName.indexOf("AccuPOSView.SelectCustomerViewIL") > -1) {
            newModuleName = "AccuPOSView.SelectCustomerViewILGP";
        } else if (oldModuleName.indexOf("AccuPOSView.SelectDriverOrdersView") > -1) {
            newModuleName = "AccuPOSView.SelectDriverOrdersViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.SelectOrderView") > -1) {
            newModuleName = "AccuPOSView.SelectOrderViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.SelectReprintOrderView") > -1) {
            newModuleName = "AccuPOSView.SelectReprintOrderViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.SelectServerView") > -1) {
            newModuleName = "AccuPOSView.SelectServerViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.SelectShiftScreen") > -1) {
            newModuleName = "AccuPOSView.SelectShiftScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.SelectTipsOrderView") > -1) {
            newModuleName = "AccuPOSView.SelectTipsOrderViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.ServerConfigScreen") > -1) {
            newModuleName = "";
        } else if (oldModuleName.indexOf("AccuPOSView.SignatureCaptureScreen") > -1) {
            newModuleName = "AccuPOSView.SignatureCaptureScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.SplitCheckView") > -1) {
            newModuleName = "AccuPOSView.SplitCheckViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.SplitCheckViewIL") > -1) {
            newModuleName = "AccuPOSView.SplitCheckViewILGP";
        } else if (oldModuleName.indexOf("AccuPOSView.SplitCheckViewUK") > -1) {
            newModuleName = "AccuPOSView.SplitCheckViewUKGP";
        } else if (oldModuleName.indexOf("AccuPOSView.StationSettingsScreen") > -1) {
            newModuleName = "";
        } else if (oldModuleName.indexOf("AccuPOSView.TabBar") > -1) {
            newModuleName = "AccuPOSView.TabBarGP";
        } else if (oldModuleName.indexOf("AccuPOSView.TabBarNew") > -1) {
            newModuleName = "";
        } else if (oldModuleName.indexOf("AccuPOSView.TablesListView") > -1) {
            newModuleName = "AccuPOSView.TablesListViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.TablesListViewIL") > -1) {
            newModuleName = "AccuPOSView.TablesListViewILGP";
        } else if (oldModuleName.indexOf("AccuPOSView.TablesView") > -1) {
            newModuleName = "AccuPOSView.TablesViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.TenderScreen") > -1) {
            newModuleName = "AccuPOSView.TenderScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.TipsScreen") > -1) {
            newModuleName = "AccuPOSView.TipsScreenGP";
        } else if (oldModuleName.indexOf("AccuPOSView.YourRetailShiftTabView") > -1) {
            newModuleName = "AccuPOSView.YourRetailShiftTabViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.YourRetailShiftTabViewIL") > -1) {
            newModuleName = "AccuPOSView.YourRetailShiftTabViewILGP";
        } else if (oldModuleName.indexOf("AccuPOSView.YourShiftTabView") > -1) {
            newModuleName = "AccuPOSView.YourShiftTabViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.YourShiftTabViewIL") > -1) {
            newModuleName = "AccuPOSView.YourShiftTabViewGP";
        } else if (oldModuleName.indexOf("AccuPOSView.ZOutEndingCashCalculator") > -1) {
            newModuleName = "AccuPOSView.ZOutEndingCashCalculatorGP";
        } else if (oldModuleName.indexOf("AccuPOSView.ZOutTotalScreen") > -1) {
            newModuleName = "AccuPOSView.ZOutTotalScreenGP";
        }
        return newModuleName;
    }

    public boolean removeClientConfiguration(String name) {
        boolean result = true;
        String folder = System.getProperty("user.dir") + "/ClientConfigurations";
        String fileName = folder + "/" + name + ".cfg";
        File file = new File(fileName);
        result = file.delete();
        return result;
    }

    public boolean updateClientConfiguration(String name, String content) {
        boolean result = true;
        String[] lines = content.split("\r\n");
        if (lines != null && lines.length > 0) {
            StringBuilder output = new StringBuilder();
            boolean prevLineBlank = false;
            for (int i = 0; i < lines.length; ++i) {
                String thisLine = lines[i];
                if (!thisLine.isEmpty()) {
                    output.append(thisLine + "\r\n");
                    prevLineBlank = false;
                    continue;
                }
                if (prevLineBlank) continue;
                output.append("\r\n");
                prevLineBlank = true;
            }
            content = output.toString();
        }
        String folder = System.getProperty("user.dir") + "/ClientConfigurations";
        String fileName = folder + "/" + name + ".cfg";
        try {
            Utility.writeXml((String)fileName, (String)content);
        }
        catch (IOException ex) {
            this.raiseException(ex);
        }
        return result;
    }

    public String getAccuShiftClientConfiguration(String name) {
        String result = "";
        String folder = System.getProperty("user.dir") + "/AccuShiftClientConfigurations";
        String filename = folder + "/" + name + ".cfg";
        result = Utility.getXml((String)filename);
        return result;
    }

    public String getAccuCountClientConfiguration(String name) {
        String name2 = "";
        if (name.isEmpty()) {
            return "";
        }
        int dash = name.indexOf(45);
        if (dash > -1 && ++dash < name.length()) {
            name2 = name.substring(dash);
            name = name.substring(0, dash - 1);
        }
        String result = "";
        String folder = System.getProperty("user.dir") + "/AccuCountClientConfigurations";
        String filename = folder + "/" + name + ".cfg";
        String debugFilename = "";
        if (!name2.isEmpty()) {
            debugFilename = folder + "/" + name + "-" + name2 + ".cfc";
        }
        result = Utility.getXml((String)filename);
        if (!name2.isEmpty()) {
            filename = folder + "/" + name2 + ".cfg";
            String result2 = Utility.getXml((String)filename);
            result = result != null && result2 != null && !result2.isEmpty() ? this.combineConfigurations(result, result2) : "";
        }
        if (!name2.isEmpty()) {
            try {
                Utility.writeXml((String)debugFilename, (String)result);
            }
            catch (IOException ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public boolean updateAccuCountClientConfiguration(String name, String content) {
        boolean result = true;
        String folder = System.getProperty("user.dir") + "/AccuCountClientConfigurations";
        String fileName = folder + "/" + name + ".cfg";
        try {
            Utility.writeXml((String)fileName, (String)content);
        }
        catch (IOException ex) {
            this.raiseException(ex);
        }
        return result;
    }

    public void saveOrder(String orderXml, String user, String userTill) {
        try {
            String command = "<Action>SaveOrder</Action><User>" + user + "</User><UserTill>" + userTill + "</UserTill><Order>" + orderXml + "</Order>";
            this.posLocalData.setCommand(command);
            Order thisOrder = new Order(orderXml, true);
            if (thisOrder.customer != null && this.loyaltyHandler != null) {
                this.loyaltyHandler.clearCustomer(thisOrder.customer);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public String saveOrderAndReturnNumber(String orderXml, String user, String userTill) {
        StringBuilder result = new StringBuilder();
        Order order = null;
        try {
            order = new Order(orderXml, true);
            int orderNumber = this.posLocalData.saveOrder(order, user, userTill);
            if (orderNumber == -1) {
                result.append("NOT_PROCESSED_SERVERERROR");
                return result.toString();
            }
            order = this.getOrder(orderNumber, true);
            if (this.accuServerTaxHandler != null) {
                order = this.accuServerTaxHandler.calculateTaxes(order.toXml());
            }
            result.append("<SavedOrderNumber>" + order.orderNumber + "</SavedOrderNumber>" + order.toXml());
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return result.toString();
    }

    public String saveTableOrder(String user, String userTill, String orderXml) {
        Order thisOrder = null;
        String result = "";
        try {
            int orderNumber;
            thisOrder = new Order(orderXml, true);
            if (thisOrder.user == null || thisOrder.user.length() == 0) {
                thisOrder.user = user;
            }
            if (thisOrder.shift == null || thisOrder.shift.length() == 0) {
                thisOrder.shift = userTill;
            }
            if ((orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill)) == -1) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
            thisOrder = this.calculateTaxes(this.posLocalData.getOrder(orderNumber, true).toXml());
            result = thisOrder.toXml();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        return result;
    }

    public Order getOrder(int id, boolean detail) {
        Order order = null;
        try {
            order = this.posLocalData.getOrder(id, detail);
            if (detail && order.customer != null && this.loyaltyHandler != null) {
                this.loyaltyHandler.getPlanBalances(order.customer);
            }
        }
        catch (Exception ex) {
            order = null;
            this.handleException(ex);
        }
        return order;
    }

    public void updateOrderOpenBy(String orderNumber, String user) {
        try {
            String command = "<Action>UpdateOrderOpenBy</Action><OrderNumber>" + orderNumber + "</OrderNumber><User>" + user + "</User>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public Order reopenOrder(String orderXml, String user, String userTill) {
        Order order = null;
        try {
            order = new Order(orderXml, true);
            int invoiceNumber = order.receiptNumber;
            if (order.receiptNumber > 0) {
                int transactionNumber = order.orderNumber;
                order = this.posLocalData.getOrder(transactionNumber, true);
                if (this.loyaltyHandler != null) {
                    this.loyaltyHandler.orderReopened(order, user, userTill);
                }
                if (this.comoLoyaltyHandler != null && order.comoConfirmationCode != null && !order.comoConfirmationCode.isEmpty()) {
                    this.comoLoyaltyHandler.cancelPurchase(order.comoConfirmationCode);
                }
                order.originalInvoiceNumber = invoiceNumber;
                order.receiptNumber = 0;
                order.table = "";
                this.posLocalData.reopenOrder(order, user, userTill);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return order;
    }

    public POSDataContainer getOpenOrders(String tableId, String orderId, String userId) {
        return this.getOpenOrders(tableId, orderId, userId, true);
    }

    public POSDataContainer getOpenOrders(String tableId, String orderId, String userId, boolean detail) {
        POSDataContainer orders = null;
        try {
            int len;
            orders = this.posLocalData.getOpenOrders(tableId, orderId, userId, detail);
            if (detail && (len = orders.size()) > 0) {
                for (int i = 0; i < len; ++i) {
                    Order order = (Order)orders.get(i);
                    if (this.accuServerTaxHandler != null) {
                        order = this.accuServerTaxHandler.calculateTaxes(order.toXml());
                    }
                    orders.set(i, (Object)order);
                }
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return orders;
    }

    public POSDataContainer getOpenGratuityOrders(String userId, String tenderFilter) {
        POSDataContainer orders = null;
        try {
            String filter = "Credit";
            if (tenderFilter != null && !tenderFilter.isEmpty()) {
                filter = tenderFilter;
            }
            orders = this.posLocalData.getOpenGratuityOrders(userId, filter);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return orders;
    }

    public POSDataContainer getClosedOrders(String userId) {
        POSDataContainer orders = null;
        try {
            orders = this.posLocalData.getClosedOrders(userId);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return orders;
    }

    public POSDataContainer getOpenOrderCounts(String by) {
        POSDataContainer orders = null;
        try {
            orders = this.posLocalData.getOpenOrderCounts(by);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return orders;
    }

    public void postMessage(String message) {
        this.input(message);
    }

    public void setUserList(POSDataContainer list) {
        this.usersList = list;
    }

    public void setChoicesList(POSDataContainer list) {
        this.choicesList = list;
    }

    public boolean userSessionIsValid(User thisUser, String sessionToken) {
        boolean result = false;
        if (this.userSecurityHandler != null) {
            if (thisUser != null && !this.userSecurityHandler.sessionIsValid(thisUser, sessionToken)) {
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    public User login(String passcode, String shift, String securecode, String ipAddress) {
        User result;
        block14: {
            result = null;
            User findUser = null;
            try {
                if (this.blockLogin) {
                    result = new User("SERVER LOADING DATA", "", "", 0L, "");
                    break block14;
                }
                findUser = new User("", passcode, "", 0L, "");
                int pos = this.usersList.indexOf((Object)findUser);
                result = new User("USER NOT VALID", "", "", 0L, "");
                if (pos < 0) break block14;
                try {
                    result = (User)this.usersList.get(pos);
                    if (this.userSecurityHandler != null) {
                        if (!this.userSecurityHandler.sessionIsValid(result)) {
                            byte[] token = null;
                            token = this.userSecurityHandler.createUserSession(result, securecode);
                            if (token == null) {
                                result = new User("USER SESSION INVALID", "", "", 0L, "");
                            } else {
                                result.token = new String(token, "UTF-8");
                            }
                            if (result.token.equals("SESSION PASSCODE UNDEFINED") || result.token.equals("SESSION PASSCODE EXPIRED") || result.token.equals("USER LOGIN LOCKED")) {
                                result = new User(result.token, "", "", 0L, "");
                            }
                        } else if (!this.licenseHandler.addStationConnection(ipAddress)) {
                            result = new User("USER STATIONS EXCEEDED", "", "", 0L, "");
                        }
                    } else if (!this.licenseHandler.addStationConnection(ipAddress)) {
                        result = new User("USER STATIONS EXCEEDED", "", "", 0L, "");
                    }
                }
                catch (Exception ex) {
                    result = new User("USER SESSION INVALID", "", "", 0L, "");
                    this.raiseException(ex);
                }
            }
            catch (Exception e) {
                result = new User("USER NOT VALID", "", "", 0L, "");
                this.raiseException(e);
            }
        }
        return result;
    }

    public void logout(String userId, String ipAddress) {
        this.licenseHandler.updateStationConnection(ipAddress);
    }

    public void setLoginScreen(ServerObject loginScreen) {
    }

    public ChoiceGroup getChoiceGroup(String name) {
        Object group = new ChoiceGroup();
        group.name = name;
        int pos = this.choicesList.indexOf(group);
        group = pos < 0 ? null : (ChoiceGroup)this.choicesList.get(pos);
        return group;
    }

    public Employee getEmployeeInfo(String employeeId) {
        Employee result = null;
        try {
            if (this.accuShiftLocalData != null) {
                result = this.accuShiftLocalData.getEmployeeInfo(employeeId);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return result;
    }

    public boolean setEmployeeClockIn(String employeeId, int payLevel, int breakId) {
        return this.setEmployeeClockIn(employeeId, payLevel, breakId, true);
    }

    public boolean setEmployeeClockIn(String employeeId, int payLevel, int breakId, boolean isClockedIn) {
        boolean result = false;
        try {
            result = this.accuShiftLocalData.setEmployeeClockIn(employeeId, payLevel, breakId);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return result;
    }

    public Timestamp getClockInTime(String employeeId, int payLevel) {
        Timestamp clockIn = null;
        try {
            clockIn = this.accuShiftLocalData.getClockInTime(employeeId, payLevel);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return clockIn;
    }

    public boolean isClockedIntoBreak(String employeeId) {
        boolean result = false;
        try {
            result = this.accuShiftLocalData.isClockedIntoBreak(employeeId);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return result;
    }

    public int getClockInPayLevel(String employeeId) {
        int result = 0;
        try {
            result = this.accuShiftLocalData.getClockInPayLevel(employeeId);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return result;
    }

    public String getClockInPrintData(String loginId, int payLevel) {
        if (this.clockTicketPrinter == null) {
            this.input("TimeClockPrinter is Null");
            return "";
        }
        String result = "";
        try {
            Employee employee = this.accuShiftLocalData.getEmployeeInfo(loginId);
            if (employee != null) {
                Timestamp clockIn = this.accuShiftLocalData.getClockInTime(employee.id, payLevel);
                result = this.clockTicketPrinter.clockInTicket(employee, payLevel, clockIn);
            } else {
                employee = this.accuShiftLocalData.getEmployeeInfo(loginId, true);
                if (employee != null) {
                    Timestamp clockIn = this.accuShiftLocalData.getClockInTime(employee.id, payLevel);
                    result = this.clockTicketPrinter.clockInTicket(employee, payLevel, clockIn);
                } else {
                    this.input("Employee for " + loginId + " Not Found for Clock in Print Data");
                }
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return result;
    }

    public boolean setEmployeeClockOut(String employeeId) {
        boolean result = false;
        try {
            result = this.accuShiftLocalData.setEmployeeClockOut(employeeId);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return result;
    }

    public String getClockOutPrintData(String loginId, int payLevel, Timestamp clockIn) {
        if (this.clockTicketPrinter == null) {
            return "";
        }
        String result = "";
        try {
            Employee employee = this.accuShiftLocalData.getEmployeeInfo(loginId);
            if (employee != null) {
                long payPeriodTime = this.accuShiftLocalData.getEmployeePayPeriodTime(employee.id);
                result = this.clockTicketPrinter.clockOutTicket(employee, payLevel, clockIn, payPeriodTime);
            } else {
                employee = this.accuShiftLocalData.getEmployeeInfo(loginId, true);
                if (employee != null) {
                    long payPeriodTime = this.accuShiftLocalData.getEmployeePayPeriodTime(employee.id);
                    result = this.clockTicketPrinter.clockOutTicket(employee, payLevel, clockIn, payPeriodTime);
                } else {
                    this.input("Employee for " + loginId + " Not Found for Clock out Print Data");
                }
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return result;
    }

    public void setTaxHandler(AccuServerTaxBase object) {
        this.accuServerTaxHandler = object;
    }

    public void setCustomerPriceHandler(CustomerPriceBase object) {
        this.customerPriceHandler = object;
    }

    public CustomerPriceBase getCustomerPriceHandler() {
        return this.customerPriceHandler;
    }

    public Order calculateTaxes(String orderXml) {
        Date now = new Date();
        return this.calculateTaxes(orderXml, now.getTime());
    }

    public POSDataContainer getTaxAuthoritiesList() {
        if (this.taxAuthoritiesList == null) {
            try {
                this.taxAuthoritiesList = this.posLocalData.getTaxAuthorities();
            }
            catch (Exception ex) {
                this.raiseException(ex);
            }
        }
        return this.taxAuthoritiesList;
    }

    public User getUser(String id) {
        User result = null;
        User thisUser = null;
        int len = this.usersList.size();
        for (int i = 0; i < len; ++i) {
            thisUser = (User)this.usersList.get(i);
            if (thisUser.id.compareToIgnoreCase(id) != 0) continue;
            result = thisUser;
            return result;
        }
        return result;
    }

    public void printOrder(Order order, String printerName) {
        try {
            OrderPrinter thisPrinter = (OrderPrinter)this.orderPrinters.get(printerName);
            if (thisPrinter != null) {
                thisPrinter.printOrder(order);
                this.posLocalData.setCheckPrinted(order.orderNumber);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void savePrintOrder(String orderXml, String user, String userTill, String printerName) {
        try {
            String command = "<Action>SavePrintOrder</Action><Order>" + orderXml + "</Order><User>" + user + "</User><UserTill>" + userTill + "</UserTill><PrinterName>" + printerName + "</PrinterName>";
            this.posLocalData.setCommand(command);
            Order thisOrder = new Order(orderXml, true);
            if (thisOrder.customer != null && this.loyaltyHandler != null) {
                this.loyaltyHandler.clearCustomer(thisOrder.customer);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void addDiscountItems(Order order) {
        Item discountItem = null;
        Item orderDiscountItem = null;
        Item customerDiscountItem = null;
        if (order.discountItem.isEmpty() && (order.customer == null || order.customer.discountItemId.isEmpty())) {
            return;
        }
        if (!order.discountItem.isEmpty()) {
            orderDiscountItem = this.findItemByCode(order.discountItem);
        }
        if (order.customer != null && !order.customer.discountItemId.isEmpty()) {
            customerDiscountItem = this.findItemByCode(order.customer.discountItemId);
        }
        if (orderDiscountItem != null && customerDiscountItem == null) {
            discountItem = orderDiscountItem;
        } else if (orderDiscountItem == null && customerDiscountItem != null) {
            if (order.discountPercent == customerDiscountItem.price) {
                discountItem = customerDiscountItem;
            } else if (order.discountPercent < customerDiscountItem.price) {
                order.discountPercent = 0.0;
                discountItem = customerDiscountItem;
            }
        } else if (orderDiscountItem != null && customerDiscountItem != null) {
            discountItem = orderDiscountItem.price > customerDiscountItem.price ? orderDiscountItem : customerDiscountItem;
        }
        if (this.accuServerTaxHandler != null && discountItem != null) {
            order.discountItem = discountItem.code;
            boolean skip = false;
            if (order.lineItems != null) {
                int len = order.lineItems.size();
                for (int i = 0; i < len; ++i) {
                    LineItem thisLine = (LineItem)order.lineItems.get(i);
                    if (!thisLine.itemId.equalsIgnoreCase(order.discountItem) || !(thisLine.quantity < 1.0E-4)) continue;
                    skip = true;
                    break;
                }
            }
            if (!skip) {
                this.accuServerTaxHandler.addDiscountItems(order, discountItem);
            }
        }
    }

    public boolean invoiceOrder(String orderXml, String user, String userTill, String printerName, String emailAddress) {
        boolean invoiceable = true;
        Order thisOrder = null;
        User thisUser = null;
        try {
            thisOrder = new Order(orderXml, true);
            thisUser = this.getUser(thisOrder.user);
            if (thisUser == null) {
                thisUser = this.getUser(user);
            }
            if (thisUser != null && (invoiceable = this.isInvoiceable(orderXml, user))) {
                this.posLocalData.setShiftZ(userTill, true);
                this.addDiscountItems(thisOrder);
                String command = "<Action>InvoiceOrder</Action><Order>" + thisOrder.toXml() + "</Order><User>" + user + "</User><UserTill>" + userTill + "</UserTill><PrinterName>" + printerName + "</PrinterName>";
                this.posLocalData.setCommand(command);
                if (this.comoLoyaltyHandler != null && !this.saleWasCanceled(thisOrder)) {
                    String comoResponse;
                    if (this.accuServerTaxHandler != null) {
                        thisOrder = this.accuServerTaxHandler.calculateTaxes(thisOrder.toXml());
                    }
                    if ((comoResponse = this.comoLoyaltyHandler.submitPurchase(thisOrder)) != null && !comoResponse.isEmpty()) {
                        String comoResult = Utility.getElement((String)"Result", (String)comoResponse);
                        if (comoResult.contains("OK")) {
                            String comoConfirmation = Utility.getElement((String)"ComoConfirmation", (String)comoResponse);
                            if (comoConfirmation != null && !comoConfirmation.isEmpty()) {
                                this.posLocalData.saveComoConfirmationCode(thisOrder.orderNumber, comoConfirmation);
                            }
                        } else {
                            String errorMessage = Utility.getElement((String)"ErrorMessage", (String)comoResponse);
                            String comoErrorMessage = this.getLiteral("Como Submit Purchase Error") + " - " + errorMessage + " " + this.getLiteral("processing order") + " " + thisOrder.orderNumber;
                            this.emailException(comoErrorMessage, null);
                            this.input(comoErrorMessage);
                        }
                    }
                }
                if (thisOrder.customer != null && this.loyaltyHandler != null) {
                    this.loyaltyHandler.clearCustomer(thisOrder.customer);
                }
                if (emailAddress.contains("<SMSAddress>")) {
                    String smsAddress = Utility.getElement((String)"SMSAddress", (String)emailAddress);
                    this.sendSMSReceipt(thisOrder.orderNumber, smsAddress);
                } else {
                    this.emailReceipt(thisOrder, emailAddress);
                }
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return invoiceable;
    }

    public String savePrintFormatOrder(String orderXml, String user, String userTill, String printerName) {
        return this.savePrintFormatOrder(orderXml, user, userTill, printerName, false);
    }

    public String savePrintFormatOrder(String orderXml, String user, String userTill, String printerName, boolean includeCardSlips) {
        StringBuilder result = new StringBuilder();
        Order order = null;
        OrderPrinter thisPrinter = null;
        try {
            order = new Order(orderXml, true);
            int orderNumber = this.posLocalData.saveOrder(order, user, userTill);
            if (orderNumber == -1) {
                result.append("NOT_PROCESSED_SERVERERROR");
                return result.toString();
            }
            order = this.getOrder(orderNumber, true);
            thisPrinter = (OrderPrinter)this.orderPrinters.get(printerName);
            if (thisPrinter != null) {
                if (this.accuServerTaxHandler != null) {
                    order = this.accuServerTaxHandler.calculateTaxes(order.toXml());
                }
                thisPrinter.setPrintCopy(false);
                if (order.receiptNumber > 0) {
                    thisPrinter.setPrintCopy(true);
                }
                result.append(thisPrinter.printOrder(order));
                this.posLocalData.setCheckPrinted(order.orderNumber);
            }
            if (includeCardSlips) {
                double cardSlipLimit = 0.0;
                CompanySetupInfo companyInfo = this.getCompanySetup();
                if (companyInfo != null) {
                    cardSlipLimit = companyInfo.creditCardLimit;
                }
                int tenderLen = order.tenderings.size();
                for (int i = 0; i < tenderLen; ++i) {
                    String printData;
                    String slipData = "";
                    Tender tender = (Tender)order.tenderings.get(i);
                    if (tender.approval.trim().isEmpty() || !(tender.amount > cardSlipLimit) && !(tender.amount < -1.0E-4)) continue;
                    if (tender.origin.equalsIgnoreCase("MercuryEMV") || tender.origin.equalsIgnoreCase("OptomanyEMV")) {
                        printData = Utility.getElement((String)"PrintData", (String)tender.responseData);
                        slipData = "<EMVPrintData>" + printData + "</EMVPrintData>";
                        result.append(slipData);
                        continue;
                    }
                    if (tender.origin.equalsIgnoreCase("CredixEMV")) {
                        printData = Utility.getElement((String)"PrintData", (String)tender.responseData);
                        String refNumber = Utility.getElement((String)"RefNo", (String)tender.responseData);
                        slipData = "<EMVPrintData><RefNo>" + refNumber + "</RefNo><PrintData>" + printData + "</PrintData></EMVPrintData>";
                        result.append(slipData);
                        continue;
                    }
                    slipData = thisPrinter.printOrder(order, tender);
                    result.append(slipData);
                }
            }
            if (order.customer != null && this.loyaltyHandler != null) {
                this.loyaltyHandler.clearCustomer(order.customer);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return result.toString();
    }

    public String printClosedOrder(String orderXml, String user, String userTill, String printerName) {
        return this.printClosedOrder(orderXml, user, userTill, printerName, false);
    }

    public String printClosedOrder(String orderXml, String user, String userTill, String printerName, boolean includeCardSlips) {
        StringBuilder result = new StringBuilder();
        Order order = null;
        OrderPrinter thisPrinter = null;
        try {
            order = new Order(orderXml, true);
            thisPrinter = (OrderPrinter)this.orderPrinters.get(printerName);
            if (thisPrinter != null) {
                if (this.accuServerTaxHandler != null) {
                    order = this.accuServerTaxHandler.calculateClosedOrderTaxes(orderXml);
                }
                thisPrinter.setPrintCopy(false);
                if (order.receiptNumber > 0) {
                    thisPrinter.setPrintCopy(true);
                }
                result.append(thisPrinter.printOrder(order));
            }
            if (includeCardSlips) {
                int tenderLen = order.tenderings.size();
                for (int i = 0; i < tenderLen; ++i) {
                    String slipData = "";
                    Tender tender = (Tender)order.tenderings.get(i);
                    if (tender.approval.trim().isEmpty()) continue;
                    slipData = thisPrinter.printOrder(order, tender);
                    result.append(slipData);
                }
            }
            if (order.customer != null && this.loyaltyHandler != null) {
                this.loyaltyHandler.clearCustomer(order.customer);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return result.toString();
    }

    public String getOrderAndPrint(int id, String printerName) {
        StringBuilder result = new StringBuilder();
        Order order = null;
        OrderPrinter thisPrinter = null;
        String orderXml = "";
        try {
            order = this.getOrder(id, true);
            if (this.accuServerTaxHandler != null) {
                order = order.receiptNumber > 0 ? this.accuServerTaxHandler.calculateClosedOrderTaxes(order.toXml()) : this.accuServerTaxHandler.calculateTaxes(order.toXml());
            }
            orderXml = order.toXml();
            result.append(orderXml);
        }
        catch (Exception ex) {
            order = null;
            this.handleException(ex);
        }
        thisPrinter = (OrderPrinter)this.orderPrinters.get(printerName);
        if (thisPrinter != null) {
            thisPrinter.setPrintCopy(false);
            if (order.receiptNumber > 0) {
                thisPrinter.setPrintCopy(true);
            }
            result.append("<PrinterData>");
            result.append(thisPrinter.printOrder(order));
            result.append("</PrinterData>");
        }
        return result.toString();
    }

    public String invoiceFormatOrder(String orderXml, String user, String userTill, String printerName, String emailAddress) {
        boolean invoiceable = true;
        String result = "";
        Order thisOrder = null;
        User thisUser = null;
        OrderPrinter thisPrinter = null;
        try {
            Date today = new Date();
            if (today.getYear() + 1900 < 2022) {
                result = "INVALID_DATE_SERVERERROR";
                return result;
            }
            thisOrder = new Order(orderXml, true);
            thisUser = this.getUser(thisOrder.user);
            if (thisUser == null) {
                thisUser = this.getUser(user);
            }
            if (thisUser != null) {
                invoiceable = this.isInvoiceable(orderXml, user);
                if (!invoiceable) {
                    result = "NOT_INVOICEABLE_SERVERERROR";
                } else {
                    this.posLocalData.setShiftZ(userTill, true);
                    this.addDiscountItems(thisOrder);
                    int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill, true);
                    if (orderNumber == -1) {
                        result = "NOT_PROCESSED_SERVERERROR";
                        return result;
                    }
                    thisOrder = this.posLocalData.getOrder(orderNumber, true);
                    if (this.accuServerTaxHandler != null) {
                        thisOrder = this.accuServerTaxHandler.calculateTaxes(thisOrder.toXml());
                    }
                    if ((thisPrinter = (OrderPrinter)this.orderPrinters.get(printerName)) != null) {
                        thisPrinter.setPrintCopy(false);
                        result = thisPrinter.printOrder(thisOrder, true);
                        this.posLocalData.setCheckPrinted(thisOrder.orderNumber);
                    }
                    if (thisOrder.customer != null && this.loyaltyHandler != null) {
                        this.loyaltyHandler.clearCustomer(thisOrder.customer);
                    }
                    if (emailAddress.contains("<SMSAddress>")) {
                        String smsAddress = Utility.getElement((String)"SMSAddress", (String)emailAddress);
                        this.sendSMSReceipt(thisOrder.orderNumber, smsAddress);
                    } else {
                        this.emailReceipt(thisOrder, emailAddress);
                    }
                    if (this.comoLoyaltyHandler != null && !this.saleWasCanceled(thisOrder)) {
                        String comoResponse;
                        if (this.accuServerTaxHandler != null) {
                            thisOrder = this.accuServerTaxHandler.calculateTaxes(thisOrder.toXml());
                        }
                        if ((comoResponse = this.comoLoyaltyHandler.submitPurchase(thisOrder)) != null && !comoResponse.isEmpty()) {
                            String comoResult = Utility.getElement((String)"Result", (String)comoResponse);
                            if (comoResult.contains("OK")) {
                                String comoConfirmation = Utility.getElement((String)"ComoConfirmation", (String)comoResponse);
                                if (comoConfirmation != null && !comoConfirmation.isEmpty()) {
                                    this.posLocalData.saveComoConfirmationCode(thisOrder.orderNumber, comoConfirmation);
                                }
                            } else {
                                String errorMessage = Utility.getElement((String)"ErrorMessage", (String)comoResponse);
                                String comoErrorMessage = this.getLiteral("Como Submit Purchase Error") + " - " + errorMessage + " " + this.getLiteral("processing order") + " " + thisOrder.orderNumber;
                                this.emailException(comoErrorMessage, null);
                                this.input(comoErrorMessage);
                            }
                        }
                    }
                    this.posLocalData.setCommand("<Action>LoadUsers</Action>");
                }
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return result;
    }

    public Order getOrderWithServiceFee(Order order) {
        double serviceFee = 0.0;
        Order serviceFeeOrder = new Order(order.toXml(), true);
        CompanySetupInfo companySetup = this.getCompanySetup();
        if (companySetup != null && (companySetup.serviceFeeLimit == 0.0 || serviceFeeOrder.total < companySetup.serviceFeeLimit)) {
            serviceFee = companySetup.serviceFeeAmount > 0.0 ? companySetup.serviceFeeAmount : serviceFeeOrder.total * companySetup.serviceFeePercent;
        }
        if (serviceFee == 0.0) {
            return order;
        }
        serviceFee *= 100.0;
        serviceFee = Math.round(serviceFee);
        serviceFee /= 100.0;
        Item serviceFeeItem = this.findItemByCode("SERVICEFEE");
        if (serviceFeeItem == null) {
            return order;
        }
        long localTime = new Date().getTime();
        LineItem serviceFeeLine = new LineItem();
        serviceFeeLine.created = localTime;
        serviceFeeLine.id = serviceFeeOrder.nextLineNumber;
        serviceFeeLine.displayOnRemote = false;
        serviceFeeLine.itemId = serviceFeeItem.code;
        serviceFeeLine.itemDescription = serviceFeeItem.description;
        serviceFeeLine.altDescription = serviceFeeItem.description;
        serviceFeeLine.changedPrice = "SYSTEM";
        serviceFeeLine.noDiscount = false;
        serviceFeeLine.tax = new Tax();
        serviceFeeLine.taxable = serviceFeeLine.tax.taxable = serviceFeeItem.taxable;
        serviceFeeLine.isAppetizer = false;
        serviceFeeLine.userId = "SYSTEM";
        serviceFeeLine.sort = 0;
        serviceFeeLine.quantity = 1.0;
        serviceFeeLine.itemType = "ServiceFee";
        serviceFeeLine.price = serviceFee;
        serviceFeeLine.originalPrice = 0.0;
        serviceFeeLine.list = 0.0;
        serviceFeeLine.total = serviceFeeLine.price;
        serviceFeeOrder.lineItems.add(serviceFeeLine);
        serviceFeeOrder = this.calculateTaxes(serviceFeeOrder.toXml());
        return serviceFeeOrder;
    }

    public void addToOrderPrinters(ServerObject printer) {
        if (this.orderPrinters == null) {
            this.orderPrinters = new Hashtable();
        }
        this.orderPrinters.put(((OrderPrinter)printer).getName(), (OrderPrinter)printer);
    }

    public POSDataContainer getAlternateTaxesList() {
        if (this.alternateTaxAuthoritiesList == null) {
            try {
                this.alternateTaxAuthoritiesList = this.posLocalData.getAlternateTaxes();
            }
            catch (Exception ex) {
                this.raiseException(ex);
            }
        }
        return this.alternateTaxAuthoritiesList;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public void setInvoiceMessage(String message) {
        this.invoiceMessage = message;
    }

    public String getInvoiceMessage() {
        return this.invoiceMessage;
    }

    public String getLiteral(String name) {
        String result = null;
        if (this.literalsTable != null) {
            result = (String)this.literalsTable.get(name);
        }
        return result == null || result.trim().isEmpty() ? name : result;
    }

    public void setCountry(String country) {
        this.country = country.trim();
    }

    public String getCountry() {
        return this.country;
    }

    public POSDataContainer getConfigFiles() {
        POSDataContainer fileList = new POSDataContainer();
        String folderName = System.getProperty("user.dir") + "/ClientConfigurations";
        File directory = new File(folderName);
        String[] children = directory.list();
        if (children != null) {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".cfg");
                }
            };
            children = directory.list(filter);
            int fileLen = children.length;
            for (int i = 0; i < fileLen; ++i) {
                fileList.add((Object)children[i]);
            }
        }
        return fileList;
    }

    public String getLiterals() {
        Vector literalsList;
        int len;
        String result = "";
        File literalsFile = null;
        String fileName = System.getProperty("user.dir") + "/Literals.xml";
        literalsFile = new File(fileName);
        if (literalsFile.exists() && literalsFile.isFile()) {
            result = Utility.getXml((String)fileName);
        }
        if ((len = (literalsList = Utility.getElementList((String)"Literal", (String)result)).size()) > 0 && this.literalsTable == null) {
            this.literalsTable = new Hashtable();
        }
        for (int i = 0; i < len; ++i) {
            String literalXml = (String)literalsList.get(i);
            String name = Utility.getLiteralElement((String)"Name", (String)literalXml);
            String text = Utility.getLiteralElement((String)"Text", (String)literalXml);
            if (text == null) continue;
            this.literalsTable.put(name, text);
        }
        return result;
    }

    public String getFontNames() {
        String result = "";
        File fontNameFile = null;
        String fileName = System.getProperty("user.dir") + "/FontNames.xml";
        fontNameFile = new File(fileName);
        if (fontNameFile.exists() && fontNameFile.isFile()) {
            result = Utility.getXml((String)fileName);
        }
        return result;
    }

    public String getAccuPOSModuleConfigurations() {
        String result = "";
        File configFile = null;
        String folder = System.getProperty("user.dir") + "/ClientConfigurations";
        String fileName = folder + "/ModuleConfigurations.xml";
        configFile = new File(fileName);
        if (configFile.exists() && configFile.isFile()) {
            result = Utility.getXml((String)fileName);
        }
        return result;
    }

    public String getAccuShiftModuleConfigurations() {
        String result = "";
        File configFile = null;
        String folder = System.getProperty("user.dir") + "/AccuShiftClientConfigurations";
        String fileName = folder + "/ModuleConfigurations.xml";
        configFile = new File(fileName);
        if (configFile.exists() && configFile.isFile()) {
            result = Utility.getXml((String)fileName);
        }
        return result;
    }

    public User userLogin(String passcode) {
        User result = null;
        User findUser = null;
        try {
            if (this.blockLogin) {
                result = new User("SERVER LOADING DATA", "", "", 0L, "");
            } else {
                findUser = new User("", passcode, "", 0L, "");
                int pos = this.usersList.indexOf((Object)findUser);
                result = new User("USER NOT VALID", "", "", 0L, "");
                if (pos >= 0) {
                    result = (User)this.usersList.get(pos);
                }
            }
        }
        catch (Exception e) {
            this.raiseException(e);
        }
        return result;
    }

    public User getUserFromReference(String reference) {
        User result = null;
        User findUser = null;
        try {
            findUser = new User("", reference, "", 0L, "");
            int pos = this.usersList.indexOf((Object)findUser);
            if (pos >= 0) {
                result = (User)this.usersList.get(pos);
            }
        }
        catch (Exception e) {
            this.raiseException(e);
        }
        return result;
    }

    public POSDataContainer getTillsList() {
        return this.getTillsList(true);
    }

    public POSDataContainer getTillsList(boolean includeInactive) {
        POSDataContainer tillsList = null;
        if (this.posLocalData != null) {
            try {
                tillsList = this.posLocalData.getTills(includeInactive);
            }
            catch (Exception ex) {
                this.raiseException(ex);
            }
        }
        return tillsList;
    }

    public void setTillsList(POSDataContainer list) {
        this.tillsList = list;
    }

    public boolean deleteTill(String tillName) {
        boolean result = true;
        try {
            this.posLocalData.deleteTill(tillName);
            String command = "<Action>GetTills</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean updateTill(Till till) {
        boolean result = true;
        try {
            this.posLocalData.updateTill(till);
            String command = "<Action>GetTills</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean deleteTenderCode(String code) {
        boolean result = true;
        try {
            this.posLocalData.deleteTenderCode(code);
            String command = "<Action>LoadTenderCodes</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean loadTenderCodes() {
        boolean result = true;
        try {
            this.setTenderCodesList(this.posLocalData.getTenderCodes());
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean updateTenderCode(TenderCode tenderCode) {
        boolean result = true;
        try {
            this.posLocalData.updateTenderCode(tenderCode);
            String command = "<Action>LoadTenderCodes</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public POSDataContainer getVatCodes() {
        POSDataContainer vatCodesList = null;
        try {
            vatCodesList = this.posLocalData.getVatCodes();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return vatCodesList;
    }

    public POSDataContainer getAllFollowOns() {
        POSDataContainer followOnsList = null;
        try {
            followOnsList = this.posLocalData.getAllFollowOns();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return followOnsList;
    }

    public POSDataContainer getAllSalePrices() {
        POSDataContainer salePricesList = null;
        try {
            salePricesList = this.posLocalData.getAllSalePrices();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return salePricesList;
    }

    public POSDataContainer getAllOperatorMessages() {
        try {
            this.messagesList = this.posLocalData.getAllOperatorMessages();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return this.messagesList;
    }

    public POSDataContainer getAllItemsSold() {
        POSDataContainer itemsSoldList = null;
        try {
            itemsSoldList = this.posLocalData.getAllItemsSold();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return itemsSoldList;
    }

    public FollowOn getFollowOns(String code, String type) {
        FollowOn followOn = null;
        try {
            followOn = this.posLocalData.getFollowOns(code, type);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return followOn;
    }

    public String saveFollowOns(FollowOn followOn) {
        String result = "OK";
        try {
            boolean validation = true;
            if (followOn.items != null && !followOn.items.isEmpty()) {
                int len = followOn.items.size();
                for (int i = 0; i < len; ++i) {
                    Item followOnItem = (Item)followOn.items.get(i);
                    if (followOn.isItem) {
                        validation = this.validateFollowOns(followOn.code, followOnItem.code);
                        if (!validation) {
                            break;
                        }
                    } else {
                        followOnItem = this.findPOSItemByCode(followOnItem.code);
                        ArrayList itemCodes = this.getItemCodesByItemType(followOnItem.type);
                        if (itemCodes != null && !itemCodes.isEmpty()) {
                            String itemCode;
                            int typesLen = itemCodes.size();
                            for (int j = 0; j < typesLen && (validation = this.validateFollowOns("", itemCode = (String)itemCodes.get(j))); ++j) {
                            }
                        }
                    }
                    if (!validation) break;
                }
            }
            if (!validation) {
                result = "<Error>" + this.validationErrorMsg + "</Error>";
            } else {
                this.posLocalData.saveFollowOns(followOn);
                String command = "<Action>LoadItems</Action>";
                this.posLocalData.setCommand(command);
            }
        }
        catch (Exception ex) {
            result = "<Error>" + ex.getMessage() + "</Error>";
            this.raiseException(ex);
        }
        return result;
    }

    public void saveAllItems(String itemsXml) {
        try {
            String command = "<Action>SaveAllItems</Action>" + itemsXml;
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public POSDataContainer getAllVendors() {
        POSDataContainer vendorsList = null;
        try {
            vendorsList = this.posLocalData.getAllVendors();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return vendorsList;
    }

    public void saveAllVendors(POSDataContainer vendors) {
        StringBuffer vendorsXml = new StringBuffer();
        int len = vendors.size();
        for (int i = 0; i < len; ++i) {
            Vendor vendor = (Vendor)vendors.get(i);
            vendorsXml.append(vendor.toXml());
        }
        try {
            String command = "<Action>SaveAllVendors</Action>" + vendorsXml;
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public POSDataContainer getAdjustmentSessions() {
        POSDataContainer sessionsList = null;
        try {
            sessionsList = this.posLocalData.getAdjustmentSessions(true, true, true);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return sessionsList;
    }

    public POSDataContainer getAdjustmentSessions(boolean includeClosed, boolean includeDetail) {
        POSDataContainer sessionsList = null;
        try {
            sessionsList = this.posLocalData.getAdjustmentSessions(false, includeClosed, includeDetail);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return sessionsList;
    }

    public POSDataContainer getReceivingSessions() {
        POSDataContainer sessionsList = null;
        try {
            sessionsList = this.posLocalData.getReceivingSessions(true, true, true);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return sessionsList;
    }

    public POSDataContainer getReceivingSessions(boolean includeClosed, boolean includeDetail) {
        POSDataContainer sessionsList = null;
        try {
            sessionsList = this.posLocalData.getReceivingSessions(false, includeClosed, includeDetail);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return sessionsList;
    }

    public POSDataContainer getPriceChangeSessions() {
        POSDataContainer sessionsList = null;
        try {
            sessionsList = this.posLocalData.getPriceChangeSessions(true, true);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return sessionsList;
    }

    public POSDataContainer getPriceChangeSessions(boolean includeClosed) {
        POSDataContainer sessionsList = null;
        try {
            sessionsList = this.posLocalData.getPriceChangeSessions(false, includeClosed);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return sessionsList;
    }

    public int updateAdjustmentSession(AdjustmentSession adjustmentSession) {
        int sessionID = -1;
        try {
            sessionID = this.posLocalData.updateAdjustmentSession(adjustmentSession);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return sessionID;
    }

    public int updateReceivingSession(ReceivingSession receivingSession) {
        int sessionID = -1;
        try {
            sessionID = this.posLocalData.updateReceivingSession(receivingSession);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return sessionID;
    }

    public int updatePriceChangeSession(PriceChangeSession priceChangeSession) {
        int sessionID = -1;
        try {
            sessionID = this.posLocalData.updatePriceChangeSession(priceChangeSession);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return sessionID;
    }

    public boolean processPriceChangeSession(PriceChangeSession priceChangeSession) {
        boolean result = true;
        if (priceChangeSession == null || priceChangeSession.itemList == null || priceChangeSession.itemList.size() == 0) {
            return false;
        }
        POSDataContainer sessionChanges = new POSDataContainer();
        for (int i = 0; i < priceChangeSession.itemList.size(); ++i) {
            InventoryItem thisPriceChangeItem = (InventoryItem)priceChangeSession.itemList.get(i);
            boolean goodResult = this.changeItemPrice(thisPriceChangeItem);
            if (!goodResult) {
                result = false;
                break;
            }
            int pos = this.itemList.indexOf((Object)new Item(thisPriceChangeItem.item.code, "", "", "", 0.0, 0.0, true));
            if (pos <= 0) continue;
            Item thisItem = (Item)this.itemList.get(pos);
            sessionChanges.add((Object)thisItem);
        }
        this.saveAllItems(sessionChanges, true);
        if (result) {
            priceChangeSession.setSentToAccounting();
            this.updatePriceChangeSession(priceChangeSession);
        }
        return result;
    }

    public boolean changeItemPrice(InventoryItem priceChangeItem) {
        if (priceChangeItem.item == null) {
            return false;
        }
        int pos = this.itemList.indexOf((Object)new Item(priceChangeItem.item.code, "", "", "", 0.0, 0.0, true));
        boolean result = false;
        if (pos >= 0) {
            Timestamp updatedTime;
            Item thisItem = (Item)this.itemList.get(pos);
            double priceWithoutVat = 0.0;
            priceWithoutVat = this.accuServerTaxHandler != null && !thisItem.vatCode.isEmpty() ? this.accuServerTaxHandler.getPriceBeforeTax(priceChangeItem.price, thisItem.vatCode) : priceChangeItem.price;
            thisItem.price1 = priceWithoutVat;
            thisItem.cost = priceChangeItem.cost;
            if (priceChangeItem.barcodeCount > 0) {
                thisItem.barcodeCount = priceChangeItem.barcodeCount;
            }
            if (priceChangeItem.price2 > 0.0) {
                double price2WithoutVat = 0.0;
                price2WithoutVat = this.accuServerTaxHandler != null && !thisItem.vatCode.isEmpty() ? this.accuServerTaxHandler.getPriceBeforeTax(priceChangeItem.price2, thisItem.vatCode) : priceChangeItem.price2;
                thisItem.price2 = price2WithoutVat;
            }
            if (priceChangeItem.price3 > 0.0) {
                double price3WithoutVat = 0.0;
                price3WithoutVat = this.accuServerTaxHandler != null && !thisItem.vatCode.isEmpty() ? this.accuServerTaxHandler.getPriceBeforeTax(priceChangeItem.price3, thisItem.vatCode) : priceChangeItem.price3;
                thisItem.price3 = price3WithoutVat;
            }
            if (priceChangeItem.price4 > 0.0) {
                double price4WithoutVat = 0.0;
                price4WithoutVat = this.accuServerTaxHandler != null && !thisItem.vatCode.isEmpty() ? this.accuServerTaxHandler.getPriceBeforeTax(priceChangeItem.price4, thisItem.vatCode) : priceChangeItem.price4;
                thisItem.price4 = price4WithoutVat;
            }
            if (priceChangeItem.price5 > 0.0) {
                double price5WithoutVat = 0.0;
                price5WithoutVat = this.accuServerTaxHandler != null && !thisItem.vatCode.isEmpty() ? this.accuServerTaxHandler.getPriceBeforeTax(priceChangeItem.price5, thisItem.vatCode) : priceChangeItem.price5;
                thisItem.price5 = price5WithoutVat;
            }
            thisItem.updated = updatedTime = new Timestamp(new GregorianCalendar().getTimeInMillis());
            thisItem.changed = true;
            if (this.hasRegionalServers()) {
                thisItem.lastChanged = new Timestamp(System.currentTimeMillis());
            }
            this.itemList.set(pos, (Object)thisItem);
            result = true;
        }
        return result;
    }

    public String exportItemAdjustmentsRequest(AdjustmentSession adjustmentSession) {
        int i;
        String licenseState;
        String licenseResponse;
        String reply = "";
        if (this.hasAccountingIntegration() && (licenseResponse = Utility.getElement((String)"Status", (String)(licenseState = this.getLicenseFor("AccuCount")))).equalsIgnoreCase("Invalid")) {
            reply = "<Status>Invalid License</Status>";
            this.input("Unable to Export Item Adjustments - Not Licensed for AccuCount");
            return reply;
        }
        POSDataContainer updatedItemList = new POSDataContainer();
        int len = adjustmentSession.itemList.size();
        if (this.hasAccountingIntegration()) {
            for (i = 0; i < len; ++i) {
                Item refreshItem;
                InventoryItem thisInventoryItem = (InventoryItem)adjustmentSession.itemList.get(i);
                thisInventoryItem.item = refreshItem = this.findItemByCode(thisInventoryItem.item.code);
                adjustmentSession.itemList.set(i, thisInventoryItem);
            }
            boolean exportSuccess = this.integratorHandler.exportItemAdjustments(adjustmentSession);
            if (!exportSuccess) {
                reply = "<Status>Failed</Status>";
                return reply;
            }
        }
        for (i = 0; i < len; ++i) {
            Timestamp updatedTime;
            Timestamp referenceTime = Timestamp.valueOf("2000-01-01 00:00:00.0");
            InventoryItem thisItem = (InventoryItem)adjustmentSession.itemList.get(i);
            Item updateItem = this.findItemByCode(thisItem.item.code);
            if (thisItem.sentToAccounting == null || thisItem.sentToAccounting.before(referenceTime)) {
                updateItem.onHand = thisItem.count;
            }
            updateItem.changed = true;
            if (this.hasRegionalServers()) {
                updateItem.lastChanged = new Timestamp(System.currentTimeMillis());
            }
            updateItem.updated = updatedTime = new Timestamp(new GregorianCalendar().getTimeInMillis());
            double priceWithoutVat1 = 0.0;
            priceWithoutVat1 = this.accuServerTaxHandler != null && !updateItem.vatCode.isEmpty() ? this.accuServerTaxHandler.getPriceBeforeTax(updateItem.price1, updateItem.vatCode) : updateItem.price1;
            updateItem.price1 = priceWithoutVat1;
            double priceWithoutVat2 = 0.0;
            priceWithoutVat2 = this.accuServerTaxHandler != null && !updateItem.vatCode.isEmpty() ? this.accuServerTaxHandler.getPriceBeforeTax(updateItem.price2, updateItem.vatCode) : updateItem.price2;
            updateItem.price2 = priceWithoutVat2;
            double priceWithoutVat3 = 0.0;
            priceWithoutVat3 = this.accuServerTaxHandler != null && !updateItem.vatCode.isEmpty() ? this.accuServerTaxHandler.getPriceBeforeTax(updateItem.price3, updateItem.vatCode) : updateItem.price3;
            updateItem.price3 = priceWithoutVat3;
            double priceWithoutVat4 = 0.0;
            priceWithoutVat4 = this.accuServerTaxHandler != null && !updateItem.vatCode.isEmpty() ? this.accuServerTaxHandler.getPriceBeforeTax(updateItem.price4, updateItem.vatCode) : updateItem.price4;
            updateItem.price4 = priceWithoutVat4;
            double priceWithoutVat5 = 0.0;
            priceWithoutVat5 = this.accuServerTaxHandler != null && !updateItem.vatCode.isEmpty() ? this.accuServerTaxHandler.getPriceBeforeTax(updateItem.price5, updateItem.vatCode) : updateItem.price5;
            updateItem.price5 = priceWithoutVat5;
            updatedItemList.add((Object)updateItem);
        }
        this.saveAllItems(updatedItemList, true);
        reply = "<Status>OK</Status>";
        return reply;
    }

    public String exportItemReceivingRequest(Vector exportSessions) {
        int j;
        int itemsLen;
        ReceivingSession thisReceiving;
        int i;
        String licenseState;
        String licenseResponse;
        String reply = "";
        if (this.hasAccountingIntegration() && (licenseResponse = Utility.getElement((String)"Status", (String)(licenseState = this.getLicenseFor("AccuCount")))).equalsIgnoreCase("Invalid")) {
            reply = "<Status>Invalid License</Status>";
            this.input("Unable to Export Item Receiving - Not Licensed for AccuCount");
            return reply;
        }
        POSDataContainer updatedItemList = new POSDataContainer();
        int sessionsLen = exportSessions.size();
        if (this.hasAccountingIntegration()) {
            for (i = 0; i < sessionsLen; ++i) {
                thisReceiving = (ReceivingSession)exportSessions.get(i);
                itemsLen = thisReceiving.itemList.size();
                for (j = 0; j < itemsLen; ++j) {
                    Item refreshItem;
                    InventoryItem thisInventoryItem = (InventoryItem)thisReceiving.itemList.get(i);
                    thisInventoryItem.item = refreshItem = this.findItemByCode(thisInventoryItem.item.code);
                    thisReceiving.itemList.set(i, thisInventoryItem);
                }
            }
            boolean exportSuccess = this.integratorHandler.exportItemReceipts(exportSessions);
            if (!exportSuccess) {
                reply = "<Status>Failed</Status>";
                return reply;
            }
        }
        for (i = 0; i < sessionsLen; ++i) {
            thisReceiving = (ReceivingSession)exportSessions.get(i);
            itemsLen = thisReceiving.itemList.size();
            for (j = 0; j < itemsLen; ++j) {
                Timestamp updatedTime;
                InventoryItem thisItem = (InventoryItem)thisReceiving.itemList.get(j);
                Item updateItem = this.findItemByCode(thisItem.item.code);
                updateItem.cost = thisItem.cost;
                updateItem.onHand += thisItem.count;
                updateItem.inventoryAccount = thisItem.item.inventoryAccount;
                updateItem.changed = true;
                if (this.hasRegionalServers()) {
                    updateItem.lastChanged = new Timestamp(System.currentTimeMillis());
                }
                updateItem.updated = updatedTime = new Timestamp(new GregorianCalendar().getTimeInMillis());
                double priceWithoutVat1 = 0.0;
                priceWithoutVat1 = this.accuServerTaxHandler != null && !updateItem.vatCode.isEmpty() ? this.accuServerTaxHandler.getPriceBeforeTax(updateItem.price1, updateItem.vatCode) : updateItem.price1;
                updateItem.price1 = priceWithoutVat1;
                double priceWithoutVat2 = 0.0;
                priceWithoutVat2 = this.accuServerTaxHandler != null && !updateItem.vatCode.isEmpty() ? this.accuServerTaxHandler.getPriceBeforeTax(updateItem.price2, updateItem.vatCode) : updateItem.price2;
                updateItem.price2 = priceWithoutVat2;
                double priceWithoutVat3 = 0.0;
                priceWithoutVat3 = this.accuServerTaxHandler != null && !updateItem.vatCode.isEmpty() ? this.accuServerTaxHandler.getPriceBeforeTax(updateItem.price3, updateItem.vatCode) : updateItem.price3;
                updateItem.price3 = priceWithoutVat3;
                double priceWithoutVat4 = 0.0;
                priceWithoutVat4 = this.accuServerTaxHandler != null && !updateItem.vatCode.isEmpty() ? this.accuServerTaxHandler.getPriceBeforeTax(updateItem.price4, updateItem.vatCode) : updateItem.price4;
                updateItem.price4 = priceWithoutVat4;
                double priceWithoutVat5 = 0.0;
                priceWithoutVat5 = this.accuServerTaxHandler != null && !updateItem.vatCode.isEmpty() ? this.accuServerTaxHandler.getPriceBeforeTax(updateItem.price5, updateItem.vatCode) : updateItem.price5;
                updateItem.price5 = priceWithoutVat5;
                if (thisItem.barcodeCount > 0) {
                    updateItem.barcodeCount = thisItem.barcodeCount;
                }
                updatedItemList.add((Object)updateItem);
            }
        }
        this.saveAllItems(updatedItemList, true);
        reply = "<Status>OK</Status>";
        return reply;
    }

    public POSDataContainer getLiveAccountingUpdateOrders(Timestamp syncStartDate) {
        POSDataContainer orders = null;
        try {
            orders = this.posLocalData.getLiveAccountingUpdateOrders(syncStartDate);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return orders;
    }

    public POSDataContainer getLiveAccountingUpdateOrders(Timestamp syncStartDate, boolean getSequenceZero) {
        POSDataContainer orders = null;
        try {
            orders = this.posLocalData.getLiveAccountingUpdateOrders(syncStartDate, getSequenceZero);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return orders;
    }

    public void updateLiveAccountingTimeStamp(int orderNumber, Timestamp lastUpdateTimeStamp) {
        Order checkReopenOrder = this.getOrder(orderNumber, true);
        if (checkReopenOrder.receiptNumber == 0) {
            return;
        }
        try {
            this.posLocalData.updateLiveAccountingTimeStamp(orderNumber, lastUpdateTimeStamp);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public boolean updateItemBarcodeTemplateName(Item updateItem) {
        boolean updated = false;
        try {
            updated = this.posLocalData.updateItemBarcodeTemplateName(updateItem);
            if (updated) {
                Item cacheItem = this.getItemByCode(updateItem.code);
                cacheItem.barcodeTemplate = updateItem.barcodeTemplate;
                this.updateItemsCache(cacheItem, false);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return updated;
    }

    public void readQBOAuthValues() {
        String fileName = System.getProperty("user.dir") + "/QBOAuth.cfg";
        String resultXml = Utility.getXml((String)fileName);
        if (resultXml != null && !resultXml.isEmpty()) {
            this.qboAuth = new QBOAuth(resultXml);
            try {
                String encryptKey = this.integratorHandler.getEncryptKey();
                if (encryptKey == null || encryptKey.isEmpty()) {
                    encryptKey = this.getSerialNumber();
                    encryptKey = encryptKey + "00000";
                    encryptKey = encryptKey.substring(0, 16);
                }
                byte[] dataBytes = Base64.decode(this.qboAuth.realmId);
                String decryptedRealmId = this.decrypt(encryptKey, dataBytes);
                this.qboAuth.realmId = new String(decryptedRealmId);
                String[] qboIdSecret = this.getQBOIdAndSecret(this.qboAuth.applicationKey);
                if (qboIdSecret != null) {
                    this.qboAuth.clientId = qboIdSecret[0];
                    this.qboAuth.clientSecret = qboIdSecret[1];
                }
            }
            catch (Exception e) {
                this.input(this.getLiteral("QuickBooks Online Encryption Error Parsing Values\r\n"));
                this.qboAuth = null;
                return;
            }
        }
    }

    public void setQBOAuthValues(String realmId, String accessToken, String refreshToken, long tokenExpires, long refreshExpires) {
        if (realmId.isEmpty() && accessToken.isEmpty() && refreshToken.isEmpty()) {
            QBOAuth tempAuth = new QBOAuth();
            if (this.qboAuth != null) {
                tempAuth = this.qboAuth.Copy();
            }
            tempAuth.accessCreated = 0L;
            tempAuth.refreshCreated = 0L;
            tempAuth.realmId = "";
            tempAuth.refreshToken = "";
            tempAuth.accessToken = "";
            this.qboAuth = null;
            String[] qboIdSecret = this.getQBOIdAndSecret(tempAuth.applicationKey);
            if (qboIdSecret != null) {
                tempAuth.clientId = qboIdSecret[0];
                tempAuth.clientSecret = qboIdSecret[1];
            }
            String fileName = System.getProperty("user.dir") + "/QBOAuth.cfg";
            try {
                Utility.writeXml((String)fileName, (String)tempAuth.toXml());
            }
            catch (IOException ex) {
                this.raiseException(ex);
            }
            return;
        }
        if (this.qboAuth == null) {
            this.qboAuth = new QBOAuth();
        }
        this.qboAuth.realmId = realmId;
        this.qboAuth.accessToken = accessToken;
        this.qboAuth.refreshToken = refreshToken;
        Date now = new Date();
        this.qboAuth.accessCreated = now.getTime() + tokenExpires * 1000L;
        this.qboAuth.refreshCreated = now.getTime() + refreshExpires * 1000L;
        String[] qboIdSecret = this.getQBOIdAndSecret(this.qboAuth.applicationKey);
        if (qboIdSecret != null) {
            this.qboAuth.clientId = qboIdSecret[0];
            this.qboAuth.clientSecret = qboIdSecret[1];
        }
        this.input(this.getLiteral("QuickBooks Online Credentials Loaded"));
        if (this.qboAuth.usingSandbox) {
            this.input(this.getLiteral("QuickBooks Online Auth using Development Sandbox Override Key and Secret"));
        }
        Date today = new Date();
        Date qboExpiration = new Date(this.qboAuth.accessCreated);
        Date qboRefreshExpiration = new Date(this.qboAuth.refreshCreated);
        GregorianCalendar startCal = new GregorianCalendar();
        GregorianCalendar endCal = new GregorianCalendar();
        GregorianCalendar refreshCal = new GregorianCalendar();
        startCal.setTime(today);
        endCal.setTime(qboExpiration);
        refreshCal.setTime(qboRefreshExpiration);
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
        String qboExpireString = sdf.format(qboExpiration);
        String qboRefreshExpireString = sdf.format(qboRefreshExpiration);
        this.input(this.getLiteral("QuickBooks Access Token Expires on ") + qboExpireString);
        this.input(this.getLiteral("QuickBooks Refresh Token Expires on ") + qboRefreshExpireString);
        long daysUntilExpiration = (refreshCal.getTimeInMillis() - startCal.getTimeInMillis()) / 1000L / 60L / 60L / 24L;
        if (daysUntilExpiration > 0L) {
            this.input(this.getLiteral("QuickBooks Online Credentials will expire in ") + daysUntilExpiration + this.getLiteral(" days"));
            String fileName = System.getProperty("user.dir") + "/QBOAuth.cfg";
            QBOAuth tempAuth = this.qboAuth.Copy();
            try {
                String encryptKey = this.integratorHandler.getEncryptKey();
                if (encryptKey == null || encryptKey.isEmpty()) {
                    encryptKey = this.getSerialNumber();
                    encryptKey = encryptKey + "00000";
                    encryptKey = encryptKey.substring(0, 16);
                }
                byte[] encryptedRealmId = this.encrypt(encryptKey, realmId);
                tempAuth.realmId = new String(Base64.encode(encryptedRealmId));
            }
            catch (Exception e) {
                this.input(this.getLiteral("QBOAuth Encryption Error Saving Values"));
                this.handleException(e);
                return;
            }
            try {
                Utility.writeXml((String)fileName, (String)tempAuth.toXml());
            }
            catch (IOException ex) {
                this.raiseException(ex);
            }
        } else {
            this.input(this.getLiteral("QuickBooks Online Credentials are not valid\r\nPlease connect with QuickBooks Online via AccuPOS Management"));
        }
    }

    public QBOAuth getQBOAuth() {
        if (this.qboAuth != null) {
            if (this.qboAuth.accessCreated != 0L || this.qboAuth.usingSandbox) {
                return this.qboAuth;
            }
            return null;
        }
        return null;
    }

    public void qboDisconnect() {
        if (this.hasQboIntegrator()) {
            this.integratorHandler.disconnectAuth();
        }
    }

    public QBOAuth getNewQBOAuth() {
        this.qboAuth = new QBOAuth();
        String[] qboIdSecret = this.getQBOIdAndSecret(this.qboAuth.applicationKey);
        if (qboIdSecret != null) {
            this.qboAuth.clientId = qboIdSecret[0];
            this.qboAuth.clientSecret = qboIdSecret[1];
        }
        return this.qboAuth;
    }

    public String[] getQBOIdAndSecret(String environmentName) {
        String[] qboIdSecret = new String[2];
        if (this.hasQboIntegrator()) {
            qboIdSecret = this.integratorHandler.getIdAndSecret(environmentName);
        } else {
            qboIdSecret[0] = "";
            qboIdSecret[1] = "";
        }
        return qboIdSecret;
    }

    public void readSageAuthValues() {
        String fileName = System.getProperty("user.dir") + "/SageAuth.cfg";
        String resultXml = Utility.getXml((String)fileName);
        this.sageAuth = resultXml != null && !resultXml.isEmpty() ? new SageAuth(resultXml) : new SageAuth();
    }

    public void setSageAuthValues(String token, String refreshToken, String issuedTime, String instanceUrl) {
        if (this.sageAuth == null) {
            this.sageAuth = new SageAuth();
        }
        this.sageAuth.token = token;
        this.sageAuth.refreshToken = refreshToken;
        this.sageAuth.sageInstanceUrl = instanceUrl;
        long created = 0L;
        try {
            created = Long.parseLong(issuedTime);
        }
        catch (Exception e) {
            Date now = new Date();
            created = now.getTime();
        }
        this.sageAuth.created = created;
        this.input(this.getLiteral("Sage Live Credentials Loaded"));
        if (this.sageAuth.usingSandbox) {
            this.input(this.getLiteral("Sage Live Auth using Development Sandbox Override Key and Secret"));
        }
        if (this.sageAuth.isValid()) {
            String fileName = System.getProperty("user.dir") + "/SageAuth.cfg";
            SageAuth tempAuth = this.sageAuth.Copy();
            try {
                Utility.writeXml((String)fileName, (String)tempAuth.toXml());
            }
            catch (IOException ex) {
                this.raiseException(ex);
            }
        } else {
            this.input(this.getLiteral("Sage Live Credentials are not valid\r\nPlease connect with Sage Live via AccuPOS Management"));
        }
    }

    public SageAuth getSageAuth() {
        return this.getSageAuth(false);
    }

    public SageAuth getSageAuth(boolean checkCreated) {
        if (this.sageAuth != null) {
            if (checkCreated) {
                if (this.sageAuth.created != 0L || this.sageAuth.usingSandbox) {
                    return this.sageAuth;
                }
                return null;
            }
            return this.sageAuth;
        }
        return null;
    }

    public POSDataContainer getLoyaltyPointsPrograms(Item thisItem) {
        POSDataContainer result = null;
        try {
            result = this.posLocalData.getLoyaltyPointsPrograms(thisItem);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        return result;
    }

    public POSDataContainer getAllLoyaltyPointsPrograms() {
        POSDataContainer result = null;
        try {
            result = this.posLocalData.getAllLoyaltyPointsPrograms();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        return result;
    }

    public boolean updateLoyaltyPointsProgram(LoyaltyPointsProgram program) {
        boolean result = true;
        try {
            this.posLocalData.updateLoyaltyPointsProgram(program);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean deleteLoyaltyPointsProgram(String programName) {
        boolean result = true;
        try {
            this.posLocalData.deleteLoyaltyPointsProgram(programName);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public SalePrice getSalePrice(String code, String type) {
        SalePrice salePrice = null;
        try {
            salePrice = this.posLocalData.getSalePrice(code, type);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return salePrice;
    }

    public boolean deleteSalePrice(int salePriceId) {
        boolean result = true;
        try {
            this.posLocalData.deleteSalePrice(salePriceId);
            String command = "<Action>LoadItems</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean updateSalePrice(SalePrice salePrice) {
        boolean result = true;
        try {
            this.posLocalData.updateSalePrice(salePrice);
            String command = "<Action>LoadItems</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public POSDataContainer getItemGroupMasterIds(boolean includeRecipe) {
        POSDataContainer itemIds = null;
        try {
            Hashtable itemGroupsTable = this.posLocalData.getItemGroupsTable();
            if (!itemGroupsTable.isEmpty()) {
                itemIds = new POSDataContainer();
                Enumeration e = itemGroupsTable.keys();
                while (e.hasMoreElements()) {
                    String itemCode = (String)e.nextElement();
                    Boolean isBundle = (Boolean)itemGroupsTable.get(itemCode);
                    if (includeRecipe) {
                        itemIds.add((Object)itemCode);
                        continue;
                    }
                    if (!isBundle.booleanValue()) continue;
                    itemIds.add((Object)itemCode);
                }
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return itemIds;
    }

    public POSDataContainer getItemGroup(String itemId) {
        POSDataContainer itemGroups = null;
        try {
            itemGroups = this.posLocalData.getItemGroup(itemId);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return itemGroups;
    }

    public String updateItemGroup(String itemId, POSDataContainer itemGroups) {
        String result = "OK";
        try {
            boolean validation = true;
            if (itemGroups != null && !itemGroups.isEmpty()) {
                int len = itemGroups.size();
                for (int i = 0; i < len; ++i) {
                    ItemGroup itemGroup = (ItemGroup)itemGroups.get(i);
                    validation = this.validateItemGroup(itemId, itemGroup.detailItem);
                    if (!validation) break;
                }
            }
            if (validation) {
                this.posLocalData.updateItemGroup(itemId, itemGroups);
            } else {
                result = "<Error>" + this.validationErrorMsg + "</Error>";
            }
        }
        catch (Exception ex) {
            result = "<Error>" + ex.getMessage() + "</Error>";
            this.raiseException(ex);
        }
        return result;
    }

    public String getOperatorMessage(String type) {
        String result = "";
        try {
            result = this.posLocalData.getOperatorMessage(type);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return result;
    }

    public boolean saveOperatorMessage(String type, String message) {
        boolean result = true;
        try {
            this.posLocalData.saveOperatorMessage(type, message);
            this.messagesList = this.posLocalData.getAllOperatorMessages();
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public Item getItemByCode(String itemCode) {
        Item item = null;
        int pos = this.itemList.indexOf((Object)new Item(itemCode, "", "", "", 0.0, 0.0, true));
        if (pos >= 0) {
            item = (Item)this.itemList.get(pos);
        }
        return item;
    }

    public Item getItemByName(String itemName) {
        Item item = null;
        try {
            item = this.posLocalData.getItemByName(itemName);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        if (item != null) {
            item = this.getItemByCode(item.code);
        }
        return item;
    }

    public Item getItemByAccountingRef(String accountingRef) throws Exception {
        Item item = null;
        try {
            item = this.posLocalData.getItemByAccountingRef(accountingRef);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return item;
    }

    public POSDataContainer getItemsBySearch(String filter, boolean includeRecipes, boolean stockOnly) {
        POSDataContainer items = new POSDataContainer();
        for (int i = 0; i < this.itemList.size(); ++i) {
            Item cachedItem = (Item)this.itemList.get(i);
            Item thisItem = new Item(cachedItem);
            if (thisItem.inactive) continue;
            if (!includeRecipes) {
                if (thisItem.isBundle || thisItem.isGroup || !thisItem.code.toLowerCase().contains(filter.toLowerCase()) && !thisItem.description.toLowerCase().contains(filter.toLowerCase()) || stockOnly && (!stockOnly || !thisItem.isStock)) continue;
                items.add((Object)thisItem);
                continue;
            }
            if ((thisItem.isBundle || !thisItem.isGroup) && (thisItem.isBundle || thisItem.isGroup) || !thisItem.code.toLowerCase().contains(filter.toLowerCase()) && !thisItem.description.toLowerCase().contains(filter.toLowerCase()) || stockOnly && (!stockOnly || !thisItem.isStock)) continue;
            items.add((Object)thisItem);
        }
        this.accuServerTaxHandler.calculatePriceWithTax(items);
        return items;
    }

    public UnitOfMeasure getUnitOfMeasure(String code) {
        UnitOfMeasure uom = null;
        try {
            uom = this.posLocalData.getUnitOfMeasure(code);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return uom;
    }

    public boolean deleteUnitOfMeasure(String itemCode) {
        boolean result = true;
        try {
            this.posLocalData.deleteUnitOfMeasure(itemCode);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean updateUnitOfMeasure(UnitOfMeasure uom) {
        boolean result = true;
        try {
            this.posLocalData.updateUnitOfMeasure(uom);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean saveNewItem(Item item) {
        boolean result = true;
        POSDataContainer newItem = null;
        try {
            newItem = new POSDataContainer();
            newItem.add((Object)item);
            this.saveAllItems(newItem, true);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public POSDataContainer loadAllItems() {
        return this.itemList;
    }

    public void loadFlexGroups() {
        this.flexGroups = new Hashtable();
        POSDataContainer groupList = null;
        try {
            groupList = this.posLocalData.getAllFlexGroups();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        if (groupList != null && groupList.size() > 0) {
            int len = groupList.size();
            for (int i = 0; i < len; ++i) {
                FlexGroup thisFlexGroup = (FlexGroup)groupList.get(i);
                this.flexGroups.put(thisFlexGroup.masterItemId, thisFlexGroup);
            }
        }
    }

    public void setFlexGroups(POSDataContainer groupList) {
        this.flexGroups = new Hashtable();
        if (groupList != null && groupList.size() > 0) {
            int len = groupList.size();
            for (int i = 0; i < len; ++i) {
                FlexGroup thisFlexGroup = (FlexGroup)groupList.get(i);
                this.flexGroups.put(thisFlexGroup.masterItemId, thisFlexGroup);
            }
        }
    }

    public void loadFlexGroupDetail() {
        this.flexGroupDetail = new Hashtable();
        POSDataContainer detailList = null;
        try {
            detailList = this.posLocalData.getAllFlexGroupDetail(true);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        if (detailList != null && detailList.size() > 0) {
            int len = detailList.size();
            String lastItemId = "";
            Vector<FlexGroupDetail> flexList = new Vector<FlexGroupDetail>();
            for (int i = 0; i < len; ++i) {
                FlexGroupDetail thisFlexDetail = (FlexGroupDetail)detailList.get(i);
                String thisItemId = thisFlexDetail.masterItemId + ";" + thisFlexDetail.detailItemId;
                if (!lastItemId.isEmpty() && lastItemId.compareTo(thisItemId) != 0) {
                    this.flexGroupDetail.remove(thisFlexDetail.masterItemId + ";" + thisFlexDetail.detailItemId);
                    this.flexGroupDetail.put(thisFlexDetail.masterItemId + ";" + thisFlexDetail.detailItemId, flexList);
                    lastItemId = thisItemId;
                    flexList = new Vector();
                    flexList.add(thisFlexDetail);
                } else {
                    flexList.add(thisFlexDetail);
                    lastItemId = thisItemId;
                }
                this.flexGroupDetail.remove(thisFlexDetail.masterItemId + ";" + thisFlexDetail.detailItemId);
                this.flexGroupDetail.put(thisFlexDetail.masterItemId + ";" + thisFlexDetail.detailItemId, flexList);
            }
        }
    }

    public void setFlexGroupDetail(POSDataContainer detailList) {
        this.flexGroupDetail = new Hashtable();
        if (detailList != null && detailList.size() > 0) {
            int len = detailList.size();
            String lastItemId = "";
            Vector<FlexGroupDetail> flexList = new Vector<FlexGroupDetail>();
            for (int i = 0; i < len; ++i) {
                FlexGroupDetail thisFlexDetail = (FlexGroupDetail)detailList.get(i);
                String thisItemId = thisFlexDetail.masterItemId + ";" + thisFlexDetail.detailItemId;
                if (!lastItemId.isEmpty() && lastItemId.compareTo(thisItemId) != 0) {
                    this.flexGroupDetail.remove(thisFlexDetail.masterItemId + ";" + thisFlexDetail.detailItemId);
                    this.flexGroupDetail.put(thisFlexDetail.masterItemId + ";" + thisFlexDetail.detailItemId, flexList);
                    lastItemId = thisItemId;
                    flexList = new Vector();
                    flexList.add(thisFlexDetail);
                } else {
                    flexList.add(thisFlexDetail);
                    lastItemId = thisItemId;
                }
                this.flexGroupDetail.remove(thisFlexDetail.masterItemId + ";" + thisFlexDetail.detailItemId);
                this.flexGroupDetail.put(thisFlexDetail.masterItemId + ";" + thisFlexDetail.detailItemId, flexList);
            }
        }
    }

    public void setQualifyingQtyTypes(POSDataContainer typesList) {
        this.qualifyingQtyTypes = new POSDataContainer();
        if (typesList != null && typesList.size() > 0) {
            this.qualifyingQtyTypes = typesList;
        }
    }

    public boolean updateQualifyingQtyType(QualifyingQtyType thisQualifyingQtyType) {
        boolean result = false;
        try {
            result = this.posLocalData.updateQualifyingQtyType(thisQualifyingQtyType);
            this.loadFlexGroups();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return result;
    }

    public LoyaltyProg getLoyaltyProgram() {
        LoyaltyProg loyalty = null;
        try {
            loyalty = this.posLocalData.getLoyaltyProgram();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return loyalty;
    }

    public boolean updateLoyaltyProgram(LoyaltyProg program) {
        boolean result = true;
        try {
            this.posLocalData.updateLoyaltyProgram(program);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public POSDataContainer getAllItemTypes() {
        POSDataContainer itemTypes = null;
        try {
            itemTypes = this.posLocalData.getAllItemTypes();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return itemTypes;
    }

    public String getPrinterNames() {
        StringBuffer result = new StringBuffer();
        PrintService[] printerServices = PrinterJob.lookupPrintServices();
        int len = printerServices.length;
        for (int i = 0; i < len; ++i) {
            String printerName = printerServices[i].getAttribute(PrinterName.class).getValue();
            result.append("<PrinterName>" + printerName + "</PrinterName>\n");
        }
        String fileXml = this.getAccuServerConfigFileContents();
        Vector printerParms = new Vector();
        Vector printerData = Utility.getElementList((String)"Module", (String)fileXml, printerParms);
        len = printerData.size();
        for (int i = 0; i < len; ++i) {
            Hashtable parameters;
            String printerName;
            String moduleName = (String)printerData.get(i);
            if (!moduleName.contains("OrderPrinter") || (printerName = (String)(parameters = (Hashtable)printerParms.get(i)).get("Name")) == null) continue;
            result.append("<PrinterName>" + printerName + "</PrinterName>\n");
        }
        this.input("Printer Names:\n" + result);
        return result.toString();
    }

    public POSDataContainer getAccuShiftConfigFiles() {
        POSDataContainer fileList = new POSDataContainer();
        String folderName = System.getProperty("user.dir") + "/AccuShiftClientConfigurations";
        File directory = new File(folderName);
        String[] children = directory.list();
        if (children != null) {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".cfg");
                }
            };
            children = directory.list(filter);
            int fileLen = children.length;
            for (int i = 0; i < fileLen; ++i) {
                fileList.add((Object)children[i]);
            }
        }
        return fileList;
    }

    public boolean removeAccuShiftClientConfiguration(String deviceId) {
        boolean result = true;
        String folder = System.getProperty("user.dir") + "/AccuShiftClientConfigurations";
        String fileName = folder + "/" + deviceId + ".cfg";
        File file = new File(fileName);
        result = file.delete();
        return result;
    }

    public boolean updateAccuShiftClientConfiguration(String deviceId, String content) {
        boolean result = true;
        String folder = System.getProperty("user.dir") + "/AccuShiftClientConfigurations";
        String fileName = folder + "/" + deviceId + ".cfg";
        try {
            Utility.writeXml((String)fileName, (String)content);
        }
        catch (IOException ex) {
            this.raiseException(ex);
        }
        return result;
    }

    public POSDataContainer getZebraConfigFiles() {
        POSDataContainer fileList = new POSDataContainer();
        String folderName = System.getProperty("user.dir") + "/ZebraLabelConfigurations";
        File directory = new File(folderName);
        String[] children = directory.list();
        if (children != null) {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".zpl");
                }
            };
            children = directory.list(filter);
            int fileLen = children.length;
            for (int i = 0; i < fileLen; ++i) {
                fileList.add((Object)children[i]);
            }
        }
        return fileList;
    }

    public String getZebraConfig(String configName) {
        String config = Utility.getXml((String)(System.getProperty("user.dir") + "/ZebraLabelConfigurations/" + configName));
        return config;
    }

    public boolean saveAllAlternateTaxes(POSDataContainer altTaxes) {
        boolean result = true;
        try {
            this.posLocalData.saveAllAlternateTaxes(altTaxes);
            this.alternateTaxAuthoritiesList = this.posLocalData.getAlternateTaxes();
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public CompanySetupInfo getCompanySetup() {
        CompanySetupInfo companySetup = null;
        try {
            companySetup = this.posLocalData.getCompanySetup();
            companySetup.country = this.country.trim();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return companySetup;
    }

    public int getAutoGratuitySize() {
        if (this.gratuitySetup == null) {
            try {
                this.gratuitySetup = this.posLocalData.getGratuitySetup();
            }
            catch (Exception ex) {
                this.raiseException(ex);
            }
        }
        return this.gratuitySetup.includeTipLimit;
    }

    public GratuitySetup getGratuitySetup() {
        GratuitySetup gratuitySetup = null;
        try {
            gratuitySetup = this.posLocalData.getGratuitySetup();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return gratuitySetup;
    }

    public PricingSetup getPricingSetup() {
        PricingSetup pricingSetup = null;
        try {
            pricingSetup = this.posLocalData.getPricingSetup();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return pricingSetup;
    }

    public POSDataContainer getTaxCodes() {
        POSDataContainer taxCodes = null;
        try {
            taxCodes = this.posLocalData.getTaxCodes();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return taxCodes;
    }

    public boolean updateCompanySetup(CompanySetupInfo setup) {
        boolean result = true;
        try {
            this.posLocalData.updateCompanySetup(setup);
            if (this.integratorHandler != null) {
                this.integratorHandler.setSiteName(setup.siteName);
            }
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean updateGratuitySetup(GratuitySetup setup) {
        boolean result = true;
        try {
            this.posLocalData.updateGratuitySetup(setup);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean updatePricingSetup(PricingSetup setup) {
        boolean result = true;
        try {
            this.posLocalData.updatePricingSetup(setup);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public POSDataContainer getAllTaxAuthorities() {
        POSDataContainer taxAuthorities = null;
        try {
            taxAuthorities = this.posLocalData.getAllTaxAuthorities();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return taxAuthorities;
    }

    public boolean updateAllTaxAuthorities(POSDataContainer taxAuthList) {
        boolean result = true;
        try {
            this.posLocalData.updateAllTaxAuthorities(taxAuthList);
            if (this.taxAuthoritiesTable != null) {
                this.taxAuthoritiesTable.clear();
            }
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean updateAllTaxCodes(POSDataContainer taxCodeList) {
        boolean result = true;
        try {
            this.posLocalData.updateAllTaxCodes(taxCodeList);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public POSDataContainer getFoodStampTypes() {
        POSDataContainer foodStampTypes = this.foodStampTypeList;
        if (this.foodStampTypeList == null) {
            try {
                foodStampTypes = this.posLocalData.getFoodStampTypes();
                this.setFoodStampTypesList(foodStampTypes);
            }
            catch (Exception ex) {
                this.raiseException(ex);
            }
        }
        return foodStampTypes;
    }

    public boolean updateFoodStampTypes(POSDataContainer foodStampTypes) {
        boolean result = true;
        try {
            this.posLocalData.updateFoodStampTypes(foodStampTypes);
            this.setFoodStampTypesList(foodStampTypes);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public POSDataContainer getCustomerTerms() {
        POSDataContainer customerTerms = null;
        try {
            customerTerms = this.posLocalData.getCustomerTerms();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return customerTerms;
    }

    public boolean updateCustomerTerms(POSDataContainer customerTerms) {
        boolean result = true;
        try {
            this.posLocalData.updateCustomerTerms(customerTerms);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public POSDataContainer getCompReasons() {
        POSDataContainer compReasons = null;
        try {
            compReasons = this.posLocalData.getCompReasons();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return compReasons;
    }

    public Hashtable getCompReasonsHashtable() {
        Hashtable compReasons = null;
        try {
            compReasons = this.posLocalData.getCompReasonsHashtable();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return compReasons;
    }

    public String getLoyaltyCompReason() {
        String result = null;
        if (this.loyaltyHandler != null) {
            result = this.loyaltyHandler.getLoyaltyCompReason();
        }
        return result;
    }

    public boolean updateCompReasons(POSDataContainer compReasons) {
        boolean result = true;
        try {
            this.posLocalData.updateCompReasons(compReasons);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean updateCompReasons(Hashtable compReasons) {
        boolean result = true;
        try {
            this.posLocalData.updateCompReasons(compReasons);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean deleteCompReasons(Vector compReasonIds) {
        boolean result = true;
        try {
            this.posLocalData.deleteCompReasons(compReasonIds);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public POSDataContainer getDiscountReasons() {
        POSDataContainer discountReasons = null;
        try {
            discountReasons = this.posLocalData.getDiscountReasons();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return discountReasons;
    }

    public Hashtable getDiscountReasonsHashtable() {
        Hashtable discountReasons = null;
        try {
            discountReasons = this.posLocalData.getDiscountReasonsHashtable();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return discountReasons;
    }

    public boolean updateDiscountReasons(POSDataContainer discountReasons) {
        boolean result = true;
        try {
            this.posLocalData.updateDiscountReasons(discountReasons);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean updateDiscountReasons(Hashtable discountReasons) {
        boolean result = true;
        try {
            this.posLocalData.updateDiscountReasons(discountReasons);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean deleteDiscountReasons(Vector discountReasonIds) {
        boolean result = true;
        try {
            this.posLocalData.deleteDiscountReasons(discountReasonIds);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public String getVersion() {
        return Version.getVersion();
    }

    public String getClientVersions(String clientType) {
        if (this.autoUpdates) {
            return Version.getClientVersions(clientType);
        }
        return "";
    }

    public double getApVersion() {
        double result = 0.0;
        String thisVersion = this.getVersion();
        double versionNumber = 0.0;
        try {
            versionNumber = Double.parseDouble(thisVersion);
        }
        catch (NumberFormatException numberFormatException) {
            versionNumber = 0.0;
        }
        if (versionNumber > 2013.0) {
            result = versionNumber - 1999.0;
        }
        if (result < 14.0) {
            try {
                result = this.posLocalData.getApVersion();
            }
            catch (Exception ex) {
                this.raiseException(ex);
            }
        }
        return result;
    }

    public POSDataContainer getAllTables() {
        POSDataContainer tables = null;
        try {
            tables = this.posLocalData.getTables();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return tables;
    }

    public boolean updateTables(POSDataContainer tableList) {
        boolean result = true;
        try {
            this.posLocalData.updateTables(tableList);
            String command = "<Action>LoadTables</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean deleteTable(String tableName) {
        boolean result = true;
        try {
            this.posLocalData.deleteTable(tableName);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public ReceiptPrintSetup getReceiptPrintSetup() {
        ReceiptPrintSetup receiptPrintSetup = null;
        try {
            receiptPrintSetup = this.posLocalData.getReceiptPrintSetup();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return receiptPrintSetup;
    }

    public boolean updateReceiptPrintSetup(ReceiptPrintSetup setup) {
        boolean result = true;
        try {
            this.posLocalData.updateReceiptPrintSetup(setup);
            String command = "<Action>GetCompany</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public BarCodeInfo getBarCodeSetup() {
        try {
            this.barCodeSetup = this.posLocalData.getBarCodeSetup();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return this.barCodeSetup;
    }

    public boolean updateBarCodeSetup(BarCodeInfo setup) {
        boolean result = true;
        try {
            this.posLocalData.updateBarCodeSetup(setup);
            this.barCodeSetup = setup;
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public POSDataContainer getPriceLevelTimes() {
        try {
            this.priceLevelList = this.posLocalData.getPriceLevelTimes();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return this.priceLevelList;
    }

    public boolean updateAllPriceLevelTimes(POSDataContainer priceLevelTimes) {
        boolean result = true;
        try {
            this.posLocalData.updateAllPriceLevelTimes(priceLevelTimes);
            this.priceLevelList = priceLevelTimes;
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public POSDataContainer getCustomers() {
        POSDataContainer customersList = null;
        try {
            customersList = this.posLocalData.getCustomers();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return customersList;
    }

    public Customer getCustomerByCode(String code) {
        Customer customer = null;
        try {
            customer = this.posLocalData.getCustomerByCode(code);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return customer;
    }

    public POSDataContainer getFilteredCustomers(String filter) {
        return this.getFilteredCustomers(filter, true);
    }

    public POSDataContainer getFilteredCustomers(String filter, boolean includedInactive) {
        String clubMemberXml;
        String comoResponse;
        POSDataContainer customersList = null;
        try {
            customersList = this.posLocalData.getFilteredCustomers(filter, includedInactive);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        if (!(customersList != null && customersList.size() != 0 || this.comoLoyaltyHandler == null || (comoResponse = this.getComoCustomer("<CustomerPhone>" + filter + "</CustomerPhone>")) == null || comoResponse.isEmpty() || (clubMemberXml = Utility.getElement((String)"ComoClubMember", (String)comoResponse)) == null || clubMemberXml.isEmpty())) {
            ComoClubMember comoMember = new ComoClubMember(clubMemberXml);
            Customer comoCustomer = new Customer();
            comoCustomer.first = comoMember.firstName;
            comoCustomer.middle = comoMember.middleName;
            comoCustomer.last = comoMember.lastName;
            comoCustomer.email = comoMember.email;
            comoCustomer.phone = comoMember.code;
            comoCustomer.code = comoMember.code;
            comoCustomer.contact = comoMember.firstName + " " + comoMember.lastName;
            comoCustomer.isComoCustomer = true;
            comoCustomer.taxable = true;
            boolean saved = this.updateCustomer(comoCustomer);
            if (saved) {
                customersList = new POSDataContainer();
                CustomerFiltered customerFiltered = new CustomerFiltered();
                customerFiltered.code = comoCustomer.code;
                customerFiltered.contactName = comoCustomer.contact;
                customerFiltered.phone = comoCustomer.phone;
                customersList.add((Object)customerFiltered);
            }
        }
        return customersList;
    }

    public int getFilteredCustomersCount(String filter) {
        int count = 0;
        try {
            count = this.posLocalData.getFilteredCustomersCount(filter);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return count;
    }

    public POSDataContainer getCustomerTransactions(String customerCode) {
        POSDataContainer transactionsList = null;
        try {
            transactionsList = this.posLocalData.getCustomerTransactions(customerCode);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return transactionsList;
    }

    public LoyaltyPurchase getCustomerLoyaltyPurchases(String custCode) {
        LoyaltyPurchase purchase = null;
        try {
            purchase = this.posLocalData.getCustomerLoyaltyPurchases(custCode);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return purchase;
    }

    public POSDataContainer getVatRecords() {
        if (this.vatRecordsList == null) {
            try {
                this.vatRecordsList = this.posLocalData.getVatRecords();
            }
            catch (Exception ex) {
                this.raiseException(ex);
            }
        }
        return this.vatRecordsList;
    }

    public boolean updateCustomer(Customer customer) {
        boolean result = true;
        try {
            this.posLocalData.updateCustomer(customer);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public POSDataContainer getCustomerDiscounts() {
        POSDataContainer discountsList = null;
        try {
            discountsList = this.posLocalData.getCustomerDiscounts();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return discountsList;
    }

    public POSDataContainer getUserList() {
        return this.usersList;
    }

    public POSDataContainer getUserGroups() {
        POSDataContainer userGroups = null;
        try {
            userGroups = this.posLocalData.getUserGroups();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return userGroups;
    }

    public boolean updateUsers(POSDataContainer users) {
        boolean result = true;
        try {
            this.posLocalData.updateUsers(users);
            String command = "<Action>LoadUsers</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean updateUserGroups(POSDataContainer userGroups) {
        boolean result = true;
        try {
            this.posLocalData.updateUserGroups(userGroups);
            String command = "<Action>LoadUsers</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean deleteChoiceKey(int id) {
        boolean result = true;
        try {
            this.posLocalData.deleteChoiceKey(id);
            this.deleteChoiceKeyFromCache(id);
            this.choicesCacheSyncTime = System.currentTimeMillis();
            String command = "<Action>LoadChoices</Action><CacheSyncTime>" + this.choicesCacheSyncTime + "</CacheSyncTime>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean deleteChoiceGroupPage(int page, String group) {
        boolean result = true;
        try {
            this.posLocalData.deleteChoiceGroupPage(page, group);
            this.deleteChoicePageFromCache(page, group);
            this.choicesCacheSyncTime = System.currentTimeMillis();
            String command = "<Action>LoadChoices</Action><CacheSyncTime>" + this.choicesCacheSyncTime + "</CacheSyncTime>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public int updateChoiceKey(int page, String group, Choice choiceKey) {
        int updateId = 0;
        try {
            updateId = this.posLocalData.updateChoiceKey(page, group, choiceKey);
            this.updateChoiceKeyCache(updateId, page, group, choiceKey);
            this.choicesCacheSyncTime = System.currentTimeMillis();
            String command = "<Action>LoadChoices</Action><CacheSyncTime>" + this.choicesCacheSyncTime + "</CacheSyncTime>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return updateId;
    }

    public boolean updateChoiceKeys(String choiceGroup, Vector pages) {
        boolean updated = false;
        try {
            updated = this.posLocalData.updateChoiceKeys(choiceGroup, pages);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return updated;
    }

    public boolean insertChoiceGroupPage(int copyPage, int newPage, String copyGroup, String newGroup) {
        boolean result = true;
        try {
            this.posLocalData.insertChoiceGroupPage(copyPage, newPage, copyGroup, newGroup);
            this.setChoicesList(this.posLocalData.getChoiceGroups());
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public POSDataContainer getMenuPages() {
        POSDataContainer menuPages = null;
        try {
            menuPages = this.posLocalData.getMenuPages();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return menuPages;
    }

    public POSDataContainer getKeySetNames() {
        POSDataContainer keySetNames = null;
        try {
            keySetNames = this.posLocalData.getKeySetNames();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return keySetNames;
    }

    public POSDataContainer getAllMenuKeys() {
        POSDataContainer keys = null;
        try {
            keys = this.posLocalData.getAllMenuKeys();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return keys;
    }

    public boolean deleteMenuKey(int keyId) {
        boolean result = true;
        try {
            this.posLocalData.deleteMenuKey(keyId);
            String command = "<Action>LoadMenuKeys</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean copyMenuPage(String oldName, String oldKeySet, String newName, String newKeySet) {
        boolean result = true;
        try {
            this.posLocalData.copyMenuPage(oldName, oldKeySet, newName, newKeySet);
            String command = "<Action>LoadMenuKeys</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean renameMenuPage(String oldName, String oldKeySet, String newName, String newKeySet) {
        boolean result = true;
        try {
            this.posLocalData.renameMenuPage(oldName, oldKeySet, newName, newKeySet);
            String command = "<Action>LoadMenuKeys</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean removeMenuPage(String name, String keySetName) {
        boolean result = true;
        try {
            this.posLocalData.removeMenuPage(name, keySetName);
            String command = "<Action>LoadMenuKeys</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean renameKeySet(String oldName, String newName) {
        boolean result = true;
        try {
            this.posLocalData.renameKeySet(oldName, newName);
            String command = "<Action>LoadMenuKeys</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean removeKeySet(String keySetName) {
        boolean result = true;
        try {
            this.posLocalData.removeKeySet(keySetName);
            String command = "<Action>LoadMenuKeys</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public int saveNewMenuKey(MenuKey key) {
        int result = 0;
        try {
            result = this.posLocalData.saveNewMenuKey(key);
            String command = "<Action>LoadMenuKeys</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            result = 0;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean updateMenuKey(MenuKey key) {
        boolean result = true;
        try {
            this.posLocalData.updateMenuKey(key);
            String command = "<Action>LoadMenuKeys</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public POSDataContainer getItemLookup(String sku) {
        POSDataContainer itemsList = null;
        try {
            itemsList = this.posLocalData.getItemLookup(sku);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return itemsList;
    }

    public POSDataContainer searchItemsByFilter(String searchTerm, String searchBy) {
        POSDataContainer itemsList = new POSDataContainer();
        try {
            itemsList = this.posLocalData.searchItemsByFilter(searchTerm, searchBy);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return itemsList;
    }

    public boolean getTillsLoggedIn() {
        boolean result = true;
        try {
            result = this.posLocalData.getTillsLoggedIn();
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public BackupInfo getBackupInfo() {
        BackupInfo backupInfo = null;
        try {
            backupInfo = this.posLocalData.getBackupInfo();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return backupInfo;
    }

    void startAutoBackupTimer() {
        Timer autoBackupTimer = new Timer();
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTimeInMillis(System.currentTimeMillis());
        Calendar start = Calendar.getInstance(TimeZone.getDefault());
        start.setTimeInMillis(System.currentTimeMillis());
        start.add(6, 1);
        int year = start.get(1);
        int month = start.get(2);
        int day = start.get(5);
        int max = 119;
        int min = 0;
        Random random = new Random();
        int startMinute = random.nextInt(max - min + 1) + min;
        int startHour = 3;
        if (startMinute >= 60) {
            startMinute -= 60;
            startHour = 4;
        }
        start.set(year, month, day, startHour, startMinute);
        String minuteString = "0" + startMinute;
        if (minuteString.length() > 2) {
            minuteString = minuteString.substring(minuteString.length() - 2, minuteString.length());
        }
        long delay = start.getTimeInMillis() - now.getTimeInMillis();
        this.input(this.getLiteral("AccuServer Database Backups scheduled to run daily at") + " " + startHour + ":" + minuteString + this.getLiteral("AM") + "\n");
        autoBackupTimer.schedule((TimerTask)new AutoBackupTimer(), delay, 86400000L);
    }

    public boolean createBackupFile() {
        boolean result = false;
        result = this.posLocalData.backupDatabase();
        return result;
    }

    public boolean updateBackupInfo(BackupInfo backupInfo) {
        boolean result = true;
        try {
            this.posLocalData.updateBackupInfo(backupInfo);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public POSDataContainer getBackupFileNames() {
        String[] children;
        POSDataContainer fileList = new POSDataContainer();
        File directory = null;
        String backupPath = this.posLocalData.getBackupPath();
        if (backupPath != null && (children = (directory = new File(backupPath)).list()) != null) {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".apb");
                }
            };
            children = directory.list(filter);
            int fileLen = children.length;
            for (int i = 0; i < fileLen; ++i) {
                fileList.add((Object)children[i]);
            }
        }
        return fileList;
    }

    public boolean restoreBackupFile(String fileName) {
        boolean result = false;
        this.posLocalData.shutDown();
        if (this.accuShiftLocalData != null) {
            this.accuShiftLocalData.shutDown();
        }
        String path = this.posLocalData.getDatabasePath();
        String backupPath = this.posLocalData.getBackupPath();
        String restoreFile = backupPath + "/" + fileName;
        result = Utility.readZipFile((String)restoreFile, (String)path);
        if (result) {
            String command = "<Action>CheckDatabase</Action>";
            this.posLocalData.setCommand(command);
        }
        return result;
    }

    public boolean updateVatRecords(POSDataContainer vatRecords) {
        boolean result = true;
        try {
            this.posLocalData.updateVatRecords(vatRecords);
            this.vatRecordsList = vatRecords;
            this.setVatTable(vatRecords);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean hasAccuShift() {
        boolean result = false;
        if (this.accuShiftLocalData != null && this.hasLicenseFor("AccuSHIFT")) {
            result = true;
        }
        return result;
    }

    public String getCardType(String data) {
        String result = "UNKNOWN";
        if (this.cardHandler != null) {
            result = this.cardHandler.getCardType(data);
        }
        return result;
    }

    public String processCreditCardVoid(String authCode, String reference, double amount, String user, String userTill, String orderXml, String code) {
        Order thisOrder = null;
        Tender newTender = null;
        String result = "DECLINED";
        if (this.cardHandler == null) {
            return result;
        }
        thisOrder = new Order(orderXml, true);
        try {
            int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
            if (orderNumber == -1) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
            thisOrder = this.posLocalData.getOrder(orderNumber, true);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        String responseData = Utility.getElement((String)"ResponseData", (String)orderXml);
        result = this.cardHandler.processVoid(authCode, amount, user, Integer.toString(thisOrder.orderNumber), reference, responseData, userTill);
        String approved = Utility.getElement((String)"RESULT", (String)result);
        if (approved.equalsIgnoreCase("APPROVED")) {
            String approval = Utility.getElement((String)"AUTH_CODE", (String)result);
            String newReference = Utility.getElement((String)"TROUTD", (String)result);
            String cardHolder = " ";
            String number = Utility.getElement((String)"CARD_NUMBER", (String)result);
            String expiry = Utility.getElement((String)"CARD_EXPIRY", (String)result);
            newTender = new Tender();
            newTender.amount = amount * -1.0;
            newTender.approval = approval;
            newTender.cardHolder = cardHolder;
            newTender.id = 0;
            newTender.newTender = true;
            newTender.reference = newReference;
            newTender.user = user;
            newTender.till = userTill;
            newTender.isChange = false;
            newTender.code = code;
            newTender.cardNumber = number;
            newTender.cardExpiry = expiry;
            TenderCode tenderCode = this.getTenderCode(code);
            newTender.type = tenderCode.tenderType;
            newTender.description = tenderCode.description;
            newTender.status = "V";
            Date now = new Date();
            newTender.created = now.getTime();
            if (thisOrder.tenderings == null) {
                thisOrder.tenderings = new Vector();
            }
            thisOrder.tenderings.add(newTender);
            try {
                int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
                thisOrder = this.posLocalData.getOrder(orderNumber, true);
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        } else {
            String authCodeError = Utility.getElement((String)"AUTH_CODE", (String)result);
            if (authCodeError.contains("Problem connecting to the HOST")) {
                result = result.replace("Problem connecting to the HOST", "Unable to connect to credit card processor");
            }
        }
        result = result + thisOrder.toXml();
        return result;
    }

    public String parseGiftCardNumber(String data) {
        String result = "";
        if (this.giftCardHandler != null) {
            result = this.giftCardHandler.parseCardNumber(data);
        }
        return result;
    }

    public String closeBatch() {
        String result = "";
        boolean postAuthDone = false;
        if (this.cardHandler == null) {
            result = "<RESULT>Error: Card Handler Not Defined</RESULT>";
            return result;
        }
        try {
            postAuthDone = this.posLocalData.getPostAuthCompleted();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        if (postAuthDone) {
            result = this.cardHandler.getBatchSummary();
            String approved = Utility.getElement((String)"RESULT", (String)result);
            if (approved.equalsIgnoreCase("APPROVED")) {
                String summary = Utility.getElement((String)"BATCHSUMMARY", (String)result);
                if (summary == null || summary.trim().length() == 0) {
                    summary = Utility.getElement((String)"BatchSummary", (String)result);
                }
                result = this.cardHandler.closeBatch(summary);
            }
        } else {
            String msg1 = this.getLiteral("Post Auth not completed.");
            String msg2 = this.getLiteral("Please try again at a later time.");
            result = "<RESULT>" + msg1 + "\n\n" + msg2 + "</RESULT>";
        }
        return result;
    }

    public String processCreditCard(String data, double amount, String user, String userTill, String orderXml, String code, boolean authOnly) {
        String ret = "";
        Date localTime = new Date();
        ret = this.processCreditCard(data, amount, user, userTill, orderXml, code, authOnly, null, localTime.getTime());
        return ret;
    }

    public String processCreditCard(String data, double amount, String user, String userTill, String orderXml, String code, boolean authOnly, String printerName) {
        String ret = "";
        Date localTime = new Date();
        ret = this.processCreditCard(data, amount, user, userTill, orderXml, code, authOnly, printerName, localTime.getTime());
        return ret;
    }

    public String processCreditCard(String data, double amount, String user, String userTill, String orderXml, String code, boolean authOnly, String printerName, long localTime) {
        Order thisOrder = null;
        Tender newTender = null;
        TenderCode tenderCode = null;
        OrderPrinter thisPrinter = null;
        boolean displayOnRemote = false;
        String result = "DECLINED";
        String newTenderResult = "";
        if (this.cardHandler == null) {
            return result;
        }
        thisOrder = new Order(orderXml, true);
        if (!authOnly) {
            try {
                if (thisOrder.user == null || thisOrder.user.length() == 0) {
                    thisOrder.user = user;
                }
                if (thisOrder.shift == null || thisOrder.shift.length() == 0) {
                    thisOrder.shift = userTill;
                }
                displayOnRemote = thisOrder.displayOnRemote;
                thisOrder.displayOnRemote = false;
                int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
                if (orderNumber == -1) {
                    result = "NOT_PROCESSED_SERVERERROR";
                    return result;
                }
                thisOrder = this.posLocalData.getOrder(orderNumber, true);
                if (thisOrder == null || thisOrder.orderNumber != orderNumber) {
                    result = "NOT_PROCESSED_SERVERERROR";
                    return result;
                }
                thisOrder.displayOnRemote = displayOnRemote;
            }
            catch (Exception exception) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
        }
        String printData = "";
        result = this.cardHandler.processCard(data, amount, user, Integer.toString(thisOrder.orderNumber), authOnly, userTill);
        String approved = Utility.getElement((String)"RESULT", (String)result);
        if (approved.equalsIgnoreCase("APPROVED") || approved.equalsIgnoreCase("PARITIALLY APPROVED")) {
            long thisTenderCreated = 0L;
            String approval = Utility.getElement((String)"AUTH_CODE", (String)result);
            String cardHolder = Utility.getElement((String)"CARD_HOLDER", (String)result);
            String reference = Utility.getElement((String)"TROUTD", (String)result);
            String number = Utility.getElement((String)"CARD_NUMBER", (String)result);
            String expiry = Utility.getElement((String)"CARD_EXPIRY", (String)result);
            String recordNumber = Utility.getElement((String)"RecordNo", (String)result);
            String responseData = Utility.getElement((String)"XML_REQUEST", (String)result);
            String approvalAmount = "";
            if (approved.equalsIgnoreCase("PARITIALLY APPROVED") && !(approvalAmount = Utility.getElement((String)"APPROVED_AMOUNT", (String)result)).isEmpty()) {
                amount = Double.valueOf(approvalAmount);
            }
            if (authOnly) {
                thisOrder.preAuthId = reference;
                thisOrder.preAuthApproval = approval;
                thisOrder.preAuthCode = code;
                thisOrder.preAuthNumber = number;
                thisOrder.preAuthExp = expiry;
                if (thisOrder.preAuthHolder.isEmpty() && !cardHolder.isEmpty()) {
                    thisOrder.preAuthHolder = cardHolder;
                }
                thisOrder.preAuthAmount = amount;
                thisOrder.preAuthRecordNumber = recordNumber;
            } else {
                newTender = new Tender();
                newTender.amount = amount;
                newTender.approval = approval;
                newTender.cardHolder = cardHolder;
                newTender.id = 0;
                newTender.newTender = true;
                newTender.reference = reference;
                newTender.user = user;
                newTender.till = userTill;
                newTender.isChange = false;
                newTender.code = code;
                newTender.cardNumber = number;
                newTender.cardExpiry = expiry;
                newTender.responseData = responseData;
                tenderCode = this.getTenderCode(code);
                newTender.type = tenderCode.tenderType;
                newTender.description = tenderCode.description;
                Date now = new Date();
                thisTenderCreated = newTender.created = now.getTime();
                if (thisOrder.tenderings == null) {
                    thisOrder.tenderings = new Vector();
                }
                thisOrder.tenderings.add(newTender);
            }
            try {
                displayOnRemote = thisOrder.displayOnRemote;
                thisOrder.displayOnRemote = false;
                int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
                thisPrinter = (OrderPrinter)this.orderPrinters.get(printerName);
                if (thisPrinter != null && !authOnly) {
                    printData = thisPrinter.printOrder(thisOrder, newTender);
                }
                thisOrder = this.calculateTaxes(this.posLocalData.getOrder(orderNumber, true).toXml(), localTime);
                int tenderLen = thisOrder.tenderings.size();
                for (int i = 0; i < tenderLen; ++i) {
                    Tender thisTender = (Tender)thisOrder.tenderings.get(i);
                    if (thisTender.created != thisTenderCreated) continue;
                    newTenderResult = "<NewTenderId>" + thisTender.id + "</NewTenderId>";
                }
                thisOrder.displayOnRemote = displayOnRemote;
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        } else {
            String authCodeError = Utility.getElement((String)"AUTH_CODE", (String)result);
            if (authCodeError.contains("Problem connecting to the HOST")) {
                result = result.replace("Problem connecting to the HOST", "Unable to connect to credit card processor");
            }
        }
        result = result + thisOrder.toXml() + "<PrintData>" + printData + "</PrintData>";
        result = result + newTenderResult;
        return result;
    }

    public String processCreditCardIL(String data, double amount, String chargeType, String cardCvv, String cardId, int numberPayments, double initialPayment, double paymentAmount, String user, String userTill, String orderXml, String code, String printerName, long localTime) {
        Order thisOrder = null;
        Tender newTender = null;
        TenderCode tenderCode = null;
        OrderPrinter thisPrinter = null;
        boolean displayOnRemote = false;
        String result = "DECLINED";
        if (this.cardHandler == null) {
            return result;
        }
        thisOrder = new Order(orderXml, true);
        try {
            if (thisOrder.user == null || thisOrder.user.length() == 0) {
                thisOrder.user = user;
            }
            if (thisOrder.shift == null || thisOrder.shift.length() == 0) {
                thisOrder.shift = userTill;
            }
            displayOnRemote = thisOrder.displayOnRemote;
            thisOrder.displayOnRemote = false;
            int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
            if (orderNumber == -1) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
            thisOrder = this.posLocalData.getOrder(orderNumber, true);
            thisOrder.displayOnRemote = displayOnRemote;
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        String printData = "";
        result = this.cardHandler.processCardIL(data, amount, chargeType, cardCvv, cardId, numberPayments, initialPayment, paymentAmount, user, Integer.toString(thisOrder.orderNumber));
        String approved = Utility.getElement((String)"RESULT", (String)result);
        if (this.logTendering) {
            logger.log("Credit card result = " + result + " for order " + thisOrder.orderNumber);
        }
        if (approved.equalsIgnoreCase("APPROVED") || approved.equalsIgnoreCase("PARITIALLY APPROVED")) {
            String approval = Utility.getElement((String)"AUTH_CODE", (String)result);
            String cardHolder = Utility.getElement((String)"CARD_HOLDER", (String)result);
            String reference = "";
            String shvaResponse = Utility.getElement((String)"SHVA_RESPONSE", (String)result);
            reference = shvaResponse != null && !shvaResponse.isEmpty() ? shvaResponse : Utility.getElement((String)"TROUTD", (String)result);
            String number = Utility.getElement((String)"CARD_NUMBER", (String)result);
            String expiry = Utility.getElement((String)"CARD_EXPIRY", (String)result);
            String responseData = Utility.getElement((String)"XML_REQUEST", (String)result);
            String approvalAmount = "";
            if (approved.equalsIgnoreCase("PARITIALLY APPROVED") && !(approvalAmount = Utility.getElement((String)"APPROVED_AMOUNT", (String)result)).isEmpty()) {
                amount = Double.valueOf(approvalAmount);
            }
            newTender = new Tender();
            newTender.amount = amount;
            newTender.approval = approval;
            newTender.cardHolder = cardHolder;
            newTender.id = 0;
            newTender.newTender = true;
            newTender.reference = reference;
            newTender.user = user;
            newTender.till = userTill;
            newTender.isChange = false;
            newTender.code = code;
            newTender.cardNumber = number;
            newTender.cardExpiry = expiry;
            newTender.responseData = responseData;
            tenderCode = this.getTenderCode(code);
            newTender.type = tenderCode.tenderType;
            newTender.description = tenderCode.description;
            Date now = new Date();
            newTender.created = now.getTime();
            if (thisOrder.tenderings == null) {
                thisOrder.tenderings = new Vector();
            }
            thisOrder.tenderings.add(newTender);
            if (this.logTendering) {
                logger.log("Credit Card Tender Added to order " + thisOrder.orderNumber + " " + newTender.toString());
            }
            try {
                thisOrder.displayOnRemote = false;
                int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
                if (this.logTendering) {
                    logger.log("Order " + thisOrder.orderNumber + " saved");
                }
                if ((thisPrinter = (OrderPrinter)this.orderPrinters.get(printerName)) != null) {
                    printData = thisPrinter.printOrder(thisOrder, newTender, numberPayments, initialPayment, paymentAmount);
                    newTender.responseData = newTender.responseData + "<PrintData>" + printData + "</PrintData>";
                }
                thisOrder = this.calculateTaxes(this.posLocalData.getOrder(orderNumber, true).toXml(), localTime);
                thisOrder.displayOnRemote = displayOnRemote;
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        } else {
            String authCodeError = Utility.getElement((String)"AUTH_CODE", (String)result);
            if (authCodeError.contains("Problem connecting to the HOST")) {
                result = result.replace("Problem connecting to the HOST", "Unable to connect to credit card processor");
            }
        }
        result = result + thisOrder.toXml() + "<PrintData>" + printData + "</PrintData>";
        return result;
    }

    public String processGiftCardVoid(String cardNumber, String reference, double amount, String user, String userTill, String orderXml, String code) {
        Order thisOrder = null;
        Tender newTender = null;
        TenderCode tenderCode = null;
        String result = "DECLINED";
        if (this.giftCardHandler == null) {
            return result;
        }
        thisOrder = new Order(orderXml, true);
        try {
            int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
            if (orderNumber == -1) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
            thisOrder = this.posLocalData.getOrder(orderNumber, true);
            if (thisOrder.created == null) {
                thisOrder.created = new Timestamp(Utility.getLongElement((String)"Created", (String)orderXml));
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        result = this.giftCardHandler.processGiftVoid(cardNumber, amount, user, Integer.toString(thisOrder.orderNumber), reference);
        String responseData = Utility.getElement((String)"XML_REQUEST", (String)result);
        String approved = Utility.getElement((String)"RESULT", (String)result);
        if (approved.equalsIgnoreCase("APPROVED")) {
            String approval = Utility.getElement((String)"AUTH_CODE", (String)result);
            String newReference = Utility.getElement((String)"TROUTD", (String)result);
            String cardHolder = " ";
            String number = Utility.getElement((String)"CARD_NUMBER", (String)result);
            String expiry = Utility.getElement((String)"CARD_EXPIRY", (String)result);
            newTender = new Tender();
            newTender.amount = amount * -1.0;
            newTender.approval = approval;
            newTender.cardHolder = cardHolder;
            newTender.id = 0;
            newTender.newTender = true;
            newTender.reference = newReference;
            newTender.user = user;
            newTender.till = userTill;
            newTender.isChange = false;
            newTender.code = code;
            newTender.cardNumber = number;
            newTender.cardExpiry = expiry;
            newTender.responseData = responseData;
            tenderCode = this.getTenderCode(code);
            newTender.type = tenderCode.tenderType;
            newTender.description = tenderCode.description;
            newTender.status = "V";
            Date now = new Date();
            newTender.created = now.getTime();
            if (thisOrder.tenderings == null) {
                thisOrder.tenderings = new Vector();
            }
            thisOrder.tenderings.add(newTender);
            try {
                int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
                thisOrder = this.posLocalData.getOrder(orderNumber, true);
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        } else {
            String authCodeError = Utility.getElement((String)"AUTH_CODE", (String)result);
            if (authCodeError.contains("Problem connecting to the HOST")) {
                result = result.replace("Problem connecting to the HOST", "Unable to connect to gift card processor");
            }
        }
        result = result + thisOrder.toXml();
        return result;
    }

    public String processGiftCard(String data, double amount, String user, String userTill, String orderXml, String code, boolean authOnly) {
        Order thisOrder = null;
        Tender newTender = null;
        TenderCode tenderCode = null;
        String result = "DECLINED";
        boolean displayOnRemote = false;
        if (this.giftCardHandler == null) {
            return result;
        }
        thisOrder = new Order(orderXml, true);
        try {
            if (thisOrder.user == null || thisOrder.user.length() == 0) {
                thisOrder.user = user;
            }
            if (thisOrder.shift == null || thisOrder.shift.length() == 0) {
                thisOrder.shift = userTill;
            }
            displayOnRemote = thisOrder.displayOnRemote;
            thisOrder.displayOnRemote = false;
            int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
            if (orderNumber == -1) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
            thisOrder = this.posLocalData.getOrder(orderNumber, true);
            if (thisOrder.created == null) {
                thisOrder.created = new Timestamp(Utility.getLongElement((String)"Created", (String)orderXml));
            }
            thisOrder.displayOnRemote = displayOnRemote;
        }
        catch (Exception exception) {
            this.handleException(exception);
            result = "NOT_PROCESSED_SERVERERROR";
            return result;
        }
        result = this.giftCardHandler.processGiftCard(data, amount, user, Integer.toString(thisOrder.orderNumber));
        String responseData = Utility.getElement((String)"XML_REQUEST", (String)result);
        String approved = Utility.getElement((String)"RESULT", (String)result);
        if (approved.equalsIgnoreCase("APPROVED") || approved.equalsIgnoreCase("PARITIALLY APPROVED")) {
            String approval = Utility.getElement((String)"AUTH_CODE", (String)result);
            String cardHolder = Utility.getElement((String)"CARD_HOLDER", (String)result);
            String reference = Utility.getElement((String)"TROUTD", (String)result);
            String number = Utility.getElement((String)"CARD_NUMBER", (String)result);
            String expiry = Utility.getElement((String)"CARD_EXPIRY", (String)result);
            String approvalAmount = "";
            approvalAmount = Utility.getElement((String)"AMOUNT_APPROVED", (String)result);
            if (!approvalAmount.isEmpty()) {
                amount = Double.valueOf(approvalAmount);
            }
            newTender = new Tender();
            newTender.amount = amount;
            newTender.approval = approval;
            newTender.cardHolder = cardHolder;
            newTender.id = 0;
            newTender.newTender = true;
            newTender.reference = reference;
            newTender.user = user;
            newTender.till = userTill;
            newTender.isChange = false;
            newTender.code = code;
            newTender.cardNumber = number;
            newTender.cardExpiry = expiry;
            newTender.responseData = responseData;
            tenderCode = this.getTenderCode(code);
            newTender.type = tenderCode.tenderType;
            newTender.description = tenderCode.description;
            Date now = new Date();
            newTender.created = now.getTime();
            if (thisOrder.tenderings == null) {
                thisOrder.tenderings = new Vector();
            }
            thisOrder.tenderings.add(newTender);
            try {
                displayOnRemote = thisOrder.displayOnRemote;
                thisOrder.displayOnRemote = false;
                int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
                thisOrder = this.calculateTaxes(this.posLocalData.getOrder(orderNumber, true).toXml());
                thisOrder.displayOnRemote = displayOnRemote;
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        } else {
            String authCodeError = Utility.getElement((String)"AUTH_CODE", (String)result);
            if (authCodeError.contains("Problem connecting to the HOST")) {
                result = result.replace("Problem connecting to the HOST", "Unable to connect to gift card processor");
            }
        }
        result = result + thisOrder.toXml();
        return result;
    }

    public String processGiftCardActivate(String data, double amount, String user, String userTill, String orderXml, Item giftItem, long localTime) {
        Order thisOrder = null;
        String result = "DECLINED";
        if (this.giftCardHandler == null) {
            return result;
        }
        thisOrder = new Order(orderXml, true);
        try {
            String approved;
            int orderNumber;
            if (thisOrder.user == null || thisOrder.user.length() == 0) {
                thisOrder.user = user;
            }
            if (thisOrder.shift == null || thisOrder.shift.length() == 0) {
                thisOrder.shift = userTill;
            }
            if ((orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill)) == -1) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
            thisOrder = this.posLocalData.getOrder(orderNumber, true);
            if (thisOrder.created == null) {
                thisOrder.created = new Timestamp(Utility.getLongElement((String)"Created", (String)orderXml));
            }
            if ((approved = Utility.getElement((String)"RESULT", (String)(result = this.giftCardHandler.processGiftActivate(data, amount, user, Integer.toString(thisOrder.orderNumber))))).equalsIgnoreCase("APPROVED")) {
                String approval = Utility.getElement((String)"AUTH_CODE", (String)result);
                String cardHolder = Utility.getElement((String)"CARD_HOLDER", (String)result);
                String reference = Utility.getElement((String)"TROUTD", (String)result);
                String number = Utility.getElement((String)"CARD_NUMBER", (String)result);
                String expiry = Utility.getElement((String)"CARD_EXPIRY", (String)result);
                if (giftItem != null && amount > 1.0E-4) {
                    LineItem thisLine = new LineItem();
                    thisLine.isGiftCard = true;
                    thisLine.id = 0;
                    thisLine.quantity = 1.0;
                    thisLine.changedDescription = true;
                    String cardNumber = Utility.getElement((String)"CardNumber", (String)data);
                    int maxItemDescLen = 29 - cardNumber.length();
                    thisLine.itemDescription = giftItem.description.length() > maxItemDescLen ? giftItem.description.substring(0, maxItemDescLen) + ":" + cardNumber : giftItem.description + ":" + cardNumber;
                    thisLine.displayOnRemote = false;
                    thisLine.itemId = giftItem.code;
                    thisLine.altDescription = giftItem.alternateDescription;
                    thisLine.list = giftItem.list;
                    thisLine.price = amount;
                    thisLine.originalPrice = amount;
                    thisLine.noDiscount = giftItem.noDiscount;
                    thisLine.isAppetizer = giftItem.isAppetizer;
                    thisLine.itemType = giftItem.type;
                    if (thisLine.tax == null) {
                        thisLine.tax = new Tax();
                    }
                    thisLine.tax.taxable = giftItem.taxable;
                    thisLine.taxable = giftItem.taxable;
                    if (giftItem.vatCode != null && !giftItem.vatCode.trim().isEmpty()) {
                        thisLine.taxCode = giftItem.vatCode.trim();
                        if (thisOrder != null && thisOrder.customer != null && thisOrder.customer.taxable && !thisOrder.customer.taxCode.trim().isEmpty()) {
                            thisLine.taxCode = thisOrder.customer.taxCode;
                        }
                    }
                    thisLine.noPartialQuantity = giftItem.noPartialQuantity;
                    thisLine.created = localTime;
                    thisLine.userId = user;
                    thisLine.total = thisLine.quantity * thisLine.price;
                    if (thisOrder.lineItems == null) {
                        thisOrder.lineItems = new Vector();
                    }
                    thisOrder.lineItems.add(thisLine);
                    boolean displayOnRemote = thisOrder.displayOnRemote;
                    thisOrder.displayOnRemote = false;
                    orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
                    if (orderNumber == -1) {
                        result = "NOT_PROCESSED_SERVERERROR";
                        return result;
                    }
                    thisOrder = this.calculateTaxes(this.posLocalData.getOrder(orderNumber, true).toXml(), localTime);
                    thisOrder.displayOnRemote = displayOnRemote;
                }
            } else {
                String authCodeError = Utility.getElement((String)"AUTH_CODE", (String)result);
                if (authCodeError.contains("Problem connecting to the HOST")) {
                    result = result.replace("Problem connecting to the HOST", "Unable to connect to gift card processor");
                }
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        result = result + thisOrder.toXml();
        return result;
    }

    public String processGiftCardIncrement(String data, double amount, String user, String userTill, String orderXml, Item giftItem, long localTime) {
        Order thisOrder = null;
        String result = "DECLINED";
        if (this.giftCardHandler == null) {
            return result;
        }
        thisOrder = new Order(orderXml, true);
        try {
            String approved;
            int orderNumber;
            if (thisOrder.user == null || thisOrder.user.length() == 0) {
                thisOrder.user = user;
            }
            if (thisOrder.shift == null || thisOrder.shift.length() == 0) {
                thisOrder.shift = userTill;
            }
            if ((orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill)) == -1) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
            thisOrder = this.posLocalData.getOrder(orderNumber, true);
            if (thisOrder.created == null) {
                thisOrder.created = new Timestamp(Utility.getLongElement((String)"Created", (String)orderXml));
            }
            if ((approved = Utility.getElement((String)"RESULT", (String)(result = this.giftCardHandler.processGiftIncrement(data, amount, user, Integer.toString(thisOrder.orderNumber))))).equalsIgnoreCase("APPROVED")) {
                String approval = Utility.getElement((String)"AUTH_CODE", (String)result);
                String cardHolder = Utility.getElement((String)"CARD_HOLDER", (String)result);
                String reference = Utility.getElement((String)"TROUTD", (String)result);
                String number = Utility.getElement((String)"CARD_NUMBER", (String)result);
                String expiry = Utility.getElement((String)"CARD_EXPIRY", (String)result);
                if (giftItem != null && amount > 1.0E-4) {
                    LineItem thisLine = new LineItem();
                    thisLine.isGiftCard = true;
                    thisLine.id = 0;
                    thisLine.quantity = 1.0;
                    thisLine.changedDescription = true;
                    String cardNumber = Utility.getElement((String)"CardNumber", (String)data);
                    int maxItemDescLen = 29 - cardNumber.length();
                    thisLine.itemDescription = giftItem.description.length() > maxItemDescLen ? giftItem.description.substring(0, maxItemDescLen) + ":" + cardNumber : giftItem.description + ":" + cardNumber;
                    thisLine.displayOnRemote = false;
                    thisLine.itemId = giftItem.code;
                    thisLine.altDescription = giftItem.alternateDescription;
                    thisLine.list = giftItem.list;
                    thisLine.price = amount;
                    thisLine.originalPrice = amount;
                    thisLine.noDiscount = giftItem.noDiscount;
                    thisLine.isAppetizer = giftItem.isAppetizer;
                    thisLine.itemType = giftItem.type;
                    if (thisLine.tax == null) {
                        thisLine.tax = new Tax();
                    }
                    thisLine.tax.taxable = giftItem.taxable;
                    thisLine.taxable = giftItem.taxable;
                    if (giftItem.vatCode != null && !giftItem.vatCode.trim().isEmpty()) {
                        thisLine.taxCode = giftItem.vatCode.trim();
                        if (thisOrder != null && thisOrder.customer != null && thisOrder.customer.taxable && !thisOrder.customer.taxCode.trim().isEmpty()) {
                            thisLine.taxCode = thisOrder.customer.taxCode;
                        }
                    }
                    thisLine.noPartialQuantity = giftItem.noPartialQuantity;
                    thisLine.created = localTime;
                    thisLine.userId = user;
                    thisLine.total = thisLine.quantity * thisLine.price;
                    if (thisOrder.lineItems == null) {
                        thisOrder.lineItems = new Vector();
                    }
                    thisOrder.lineItems.add(thisLine);
                    boolean displayOnRemote = thisOrder.displayOnRemote;
                    thisOrder.displayOnRemote = false;
                    orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
                    if (orderNumber == -1) {
                        result = "NOT_PROCESSED_SERVERERROR";
                        return result;
                    }
                    thisOrder = this.calculateTaxes(this.posLocalData.getOrder(orderNumber, true).toXml(), localTime);
                    thisOrder.displayOnRemote = displayOnRemote;
                }
            } else {
                String authCodeError = Utility.getElement((String)"AUTH_CODE", (String)result);
                if (authCodeError.contains("Problem connecting to the HOST")) {
                    result = result.replace("Problem connecting to the HOST", "Unable to connect to gift card processor");
                }
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        result = result + thisOrder.toXml();
        return result;
    }

    public String processGiftCardBalance(String data) {
        String result = "DECLINED";
        if (this.giftCardHandler == null) {
            return result;
        }
        result = this.giftCardHandler.processGiftBalance(data);
        String approved = Utility.getElement((String)"RESULT", (String)result);
        if (approved.equalsIgnoreCase("APPROVED")) {
            String approval = Utility.getElement((String)"AUTH_CODE", (String)result);
            String cardHolder = Utility.getElement((String)"CARD_HOLDER", (String)result);
            String reference = Utility.getElement((String)"TROUTD", (String)result);
            String number = Utility.getElement((String)"CARD_NUMBER", (String)result);
            String string = Utility.getElement((String)"CARD_EXPIRY", (String)result);
        } else {
            String authCodeError = Utility.getElement((String)"AUTH_CODE", (String)result);
            if (authCodeError.contains("Problem connecting to the HOST")) {
                result = result.replace("Problem connecting to the HOST", "Unable to connect to gift card processor");
            }
        }
        return result;
    }

    public String processGiftCardTip(String data, double amount, String user, String userTill, String orderXml, int masterTenderId, String code, boolean authOnly) {
        Order thisOrder = null;
        Tender newTender = null;
        TenderCode tenderCode = null;
        String result = "DECLINED";
        boolean displayOnRemote = false;
        if (this.giftCardHandler == null) {
            return result;
        }
        thisOrder = new Order(orderXml, true);
        try {
            if (thisOrder.user == null || thisOrder.user.length() == 0) {
                thisOrder.user = user;
            }
            if (thisOrder.shift == null || thisOrder.shift.length() == 0) {
                thisOrder.shift = userTill;
            }
            displayOnRemote = thisOrder.displayOnRemote;
            thisOrder.displayOnRemote = false;
            int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
            if (orderNumber == -1) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
            thisOrder = this.posLocalData.getOrder(orderNumber, true);
            if (thisOrder.created == null) {
                thisOrder.created = new Timestamp(Utility.getLongElement((String)"Created", (String)orderXml));
            }
            thisOrder.displayOnRemote = displayOnRemote;
        }
        catch (Exception exception) {
            this.handleException(exception);
            result = "NOT_PROCESSED_SERVERERROR";
            return result;
        }
        result = this.giftCardHandler.processGiftCard(data, amount, user, Integer.toString(thisOrder.orderNumber));
        String responseData = Utility.getElement((String)"XML_REQUEST", (String)result);
        String approved = Utility.getElement((String)"RESULT", (String)result);
        if (approved.equalsIgnoreCase("APPROVED") || approved.equalsIgnoreCase("PARITIALLY APPROVED")) {
            String approval = Utility.getElement((String)"AUTH_CODE", (String)result);
            String cardHolder = Utility.getElement((String)"CARD_HOLDER", (String)result);
            String reference = Utility.getElement((String)"TROUTD", (String)result);
            String number = Utility.getElement((String)"CARD_NUMBER", (String)result);
            String expiry = Utility.getElement((String)"CARD_EXPIRY", (String)result);
            String approvalAmount = "";
            approvalAmount = Utility.getElement((String)"AMOUNT_APPROVED", (String)result);
            if (!approvalAmount.isEmpty()) {
                amount = Double.valueOf(approvalAmount);
            }
            newTender = new Tender();
            newTender.amount = amount;
            newTender.approval = approval;
            newTender.cardHolder = cardHolder;
            newTender.id = 0;
            newTender.newTender = true;
            newTender.reference = reference;
            newTender.status = "G";
            newTender.user = user;
            newTender.till = userTill;
            newTender.isChange = false;
            newTender.code = code;
            newTender.cardNumber = number;
            newTender.cardExpiry = expiry;
            newTender.masterId = masterTenderId;
            newTender.responseData = responseData;
            tenderCode = this.getTenderCode(code);
            newTender.type = tenderCode.tenderType;
            newTender.description = tenderCode.description;
            Date now = new Date();
            newTender.created = now.getTime();
            if (thisOrder.tenderings == null) {
                thisOrder.tenderings = new Vector();
            }
            thisOrder.tenderings.add(newTender);
            Tender newCashoutTender = new Tender();
            newCashoutTender.amount = amount * -1.0;
            newCashoutTender.id = 0;
            newCashoutTender.newTender = true;
            newCashoutTender.status = "T";
            newCashoutTender.user = user;
            newCashoutTender.till = userTill;
            newCashoutTender.isChange = false;
            newCashoutTender.code = code;
            newCashoutTender.type = tenderCode.tenderType;
            newCashoutTender.description = tenderCode.description;
            newCashoutTender.created = now.getTime() + 1L;
            newCashoutTender.masterId = masterTenderId;
            thisOrder.tenderings.add(newCashoutTender);
            try {
                displayOnRemote = thisOrder.displayOnRemote;
                thisOrder.displayOnRemote = false;
                int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
                thisOrder = this.calculateTaxes(this.posLocalData.getOrder(orderNumber, true).toXml());
                thisOrder.displayOnRemote = displayOnRemote;
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        } else {
            String authCodeError = Utility.getElement((String)"AUTH_CODE", (String)result);
            if (authCodeError.contains("Problem connecting to the HOST")) {
                result = result.replace("Problem connecting to the HOST", "Unable to connect to gift card processor");
            }
        }
        result = result + thisOrder.toXml();
        return result;
    }

    public Vector getGiftCardDetailByAccountNumber(String filter) {
        String result = "";
        GiftCardDetail thisDetail = null;
        Vector<GiftCardDetail> detail = new Vector<GiftCardDetail>();
        if (this.giftCardHandler == null) {
            return null;
        }
        result = this.giftCardHandler.getGiftCardDetail(filter);
        String response = Utility.getElement((String)"RESULT", (String)result);
        if (response.equalsIgnoreCase("OK")) {
            String detailXml = Utility.getElement((String)"GiftCardDetail", (String)result);
            if (detailXml != null && !detailXml.isEmpty()) {
                thisDetail = new GiftCardDetail(detailXml);
                if (thisDetail.accountNumber.isEmpty()) {
                    thisDetail.accountNumber = "Card Not Found";
                    thisDetail.transactionList = new Vector();
                    GiftCardTransaction thisTrans = new GiftCardTransaction();
                    thisDetail.transactionList.add(thisTrans);
                }
                detail.add(thisDetail);
            }
        } else {
            String authCodeError = Utility.getElement((String)"AUTH_CODE", (String)result);
            if (authCodeError.contains("Problem connecting to the HOST")) {
                result = result.replace("Problem connecting to the HOST", "Unable to connect to gift card processor");
            }
        }
        return detail;
    }

    public String processOtherTender(String user, String userTill, String orderXml, String code, double amount, String managerId, long localTime, String tenderData) {
        boolean displayOnRemote = false;
        Order thisOrder = null;
        Tender newTender = null;
        TenderCode tenderCode = null;
        String result = "";
        String newTenderResult = "";
        try {
            thisOrder = new Order(orderXml, true);
            if (thisOrder.user == null || thisOrder.user.length() == 0) {
                thisOrder.user = user;
            }
            if (thisOrder.shift == null || thisOrder.shift.length() == 0) {
                thisOrder.shift = userTill;
            }
            newTender = new Tender();
            newTender.amount = amount;
            newTender.id = 0;
            newTender.newTender = true;
            newTender.user = user;
            newTender.till = userTill;
            newTender.isChange = false;
            newTender.code = code;
            if (managerId != null && !managerId.isEmpty()) {
                newTender.managerId = managerId;
            }
            tenderCode = this.getTenderCode(code);
            newTender.type = tenderCode.tenderType;
            newTender.description = tenderCode.description;
            newTender.responseData = tenderData;
            Date now = new Date();
            long thisTenderCreated = newTender.created = now.getTime();
            if (thisOrder.tenderings == null) {
                thisOrder.tenderings = new Vector();
            }
            newTender.conversionRate = tenderCode.conversionRate;
            thisOrder.tenderings.add(newTender);
            displayOnRemote = thisOrder.displayOnRemote;
            thisOrder.displayOnRemote = false;
            int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
            if (orderNumber == -1) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
            thisOrder = this.posLocalData.getOrder(orderNumber, true);
            thisOrder = this.calculateTaxes(thisOrder.toXml(), localTime);
            int tenderLen = thisOrder.tenderings.size();
            for (int i = 0; i < tenderLen; ++i) {
                Tender thisTender = (Tender)thisOrder.tenderings.get(i);
                if (thisTender.created != thisTenderCreated) continue;
                newTenderResult = "<NewTenderId>" + thisTender.id + "</NewTenderId>";
            }
            thisOrder.displayOnRemote = displayOnRemote;
            result = thisOrder.toXml();
            result = result + newTenderResult;
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
        return result;
    }

    public String processEMVTender(String user, String userTill, String orderXml, String code, double amount, String ccNumber, String approval, String reference, String responseData, String managerId, long localTime, String origin) {
        return this.processEMVTender(user, userTill, orderXml, code, amount, ccNumber, approval, reference, responseData, managerId, localTime, origin, null);
    }

    public String processEMVTender(String user, String userTill, String orderXml, String code, double amount, String ccNumber, String approval, String reference, String responseData, String managerId, long localTime, String origin, String printerName) {
        boolean displayOnRemote = false;
        Order thisOrder = null;
        Tender newTender = null;
        TenderCode tenderCode = null;
        String result = "";
        String newTenderResult = "";
        try {
            OrderPrinter thisPrinter;
            int i;
            thisOrder = new Order(orderXml, true);
            if (thisOrder.user == null || thisOrder.user.length() == 0) {
                thisOrder.user = user;
            }
            if (thisOrder.shift == null || thisOrder.shift.length() == 0) {
                thisOrder.shift = userTill;
            }
            tenderCode = this.getTenderCode(code);
            newTender = new Tender(tenderCode.code, amount);
            newTender.type = tenderCode.tenderType;
            newTender.description = tenderCode.description;
            newTender.user = user;
            newTender.id = 0;
            newTender.newTender = true;
            newTender.till = userTill;
            newTender.isChange = false;
            newTender.code = code;
            Date now = new Date();
            long thisTenderCreated = newTender.created = now.getTime();
            if (responseData != null) {
                newTender.responseData = responseData;
            }
            if (ccNumber != null && !ccNumber.isEmpty()) {
                newTender.cardNumber = ccNumber;
            }
            if (approval != null && !approval.isEmpty()) {
                newTender.approval = approval;
            }
            if (reference != null && !reference.isEmpty()) {
                newTender.reference = reference;
            }
            if (managerId != null) {
                newTender.managerId = managerId;
            }
            if (thisOrder.tenderings == null) {
                thisOrder.tenderings = new Vector();
            }
            newTender.origin = origin;
            String cardHolder = Utility.getElement((String)"CardholderName", (String)responseData);
            if (cardHolder != null) {
                newTender.cardHolder = cardHolder;
            }
            thisOrder.tenderings.add(newTender);
            if (tenderCode.tenderType.equalsIgnoreCase("M") || tenderCode.tenderType.equalsIgnoreCase("E")) {
                double snapTendered = 0.0;
                this.getFoodStampTypes();
                if (this.foodStampTypeList != null) {
                    int numItems = thisOrder.lineItems.size();
                    for (i = 0; i < numItems; ++i) {
                        LineItem thisItem = (LineItem)thisOrder.lineItems.get(i);
                        int pos = this.foodStampTypeList.indexOf((Object)thisItem.itemType);
                        if (pos <= -1 || !(newTender.amount > snapTendered)) continue;
                        snapTendered += thisItem.total;
                        thisItem.taxable = false;
                    }
                }
            }
            displayOnRemote = thisOrder.displayOnRemote;
            thisOrder.displayOnRemote = false;
            int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
            if (orderNumber == -1) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
            String printData = "";
            if (printerName != null && !origin.equalsIgnoreCase("MercuryEMV") && (thisPrinter = (OrderPrinter)this.orderPrinters.get(printerName)) != null) {
                printData = thisPrinter.printOrder(thisOrder, newTender);
            }
            thisOrder = this.calculateTaxes(this.posLocalData.getOrder(orderNumber, true).toXml(), localTime);
            int tenderLen = thisOrder.tenderings.size();
            for (i = 0; i < tenderLen; ++i) {
                Tender thisTender = (Tender)thisOrder.tenderings.get(i);
                if (thisTender.created != thisTenderCreated) continue;
                newTenderResult = "<NewTenderId>" + thisTender.id + "</NewTenderId>";
            }
            thisOrder.displayOnRemote = displayOnRemote;
            result = printData == null || printData.isEmpty() ? thisOrder.toXml() : thisOrder.toXml() + "<PrintData>" + printData + "</PrintData>";
            result = result + newTenderResult;
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
        return result;
    }

    public String processDebitCard(String cardKeyData, String cardPinData, String cardData, double amount, String user, String userTill, String orderXml, String code, boolean isDebit, String printerName, long localTime) {
        Order thisOrder = null;
        Tender newTender = null;
        TenderCode tenderCode = null;
        OrderPrinter thisPrinter = null;
        boolean displayOnRemote = false;
        String result = "DECLINED";
        if (this.cardHandler == null) {
            return result;
        }
        thisOrder = new Order(orderXml, true);
        try {
            if (thisOrder.user == null || thisOrder.user.length() == 0) {
                thisOrder.user = user;
            }
            if (thisOrder.shift == null || thisOrder.shift.length() == 0) {
                thisOrder.shift = userTill;
            }
            displayOnRemote = thisOrder.displayOnRemote;
            thisOrder.displayOnRemote = false;
            int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
            if (orderNumber == -1) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
            thisOrder = this.posLocalData.getOrder(orderNumber, true);
            thisOrder.displayOnRemote = displayOnRemote;
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        String printData = "";
        if (isDebit) {
            result = this.cardHandler.processDebitCard(cardKeyData, cardPinData, cardData, amount, user, Integer.toString(thisOrder.orderNumber));
        } else {
            tenderCode = this.getTenderCode(code);
            if (tenderCode.tenderType.equalsIgnoreCase("M")) {
                result = this.cardHandler.processEBTCard(cardKeyData, cardPinData, cardData, amount, user, Integer.toString(thisOrder.orderNumber));
            } else if (tenderCode.tenderType.equalsIgnoreCase("E")) {
                result = this.cardHandler.processEBTCash(cardKeyData, cardPinData, cardData, amount, user, Integer.toString(thisOrder.orderNumber));
            }
        }
        String approved = Utility.getElement((String)"RESULT", (String)result);
        if (approved.equalsIgnoreCase("APPROVED") || approved.equalsIgnoreCase("PARITIALLY APPROVED")) {
            String approval = Utility.getElement((String)"AUTH_CODE", (String)result);
            String cardHolder = Utility.getElement((String)"CARD_HOLDER", (String)result);
            String reference = Utility.getElement((String)"TROUTD", (String)result);
            String number = Utility.getElement((String)"CARD_NUMBER", (String)result);
            String expiry = Utility.getElement((String)"CARD_EXPIRY", (String)result);
            String responseData = Utility.getElement((String)"XML_REQUEST", (String)result);
            String approvalAmount = "";
            if (approved.equalsIgnoreCase("PARITIALLY APPROVED") && !(approvalAmount = Utility.getElement((String)"APPROVED_AMOUNT", (String)result)).isEmpty()) {
                amount = Double.valueOf(approvalAmount);
            }
            newTender = new Tender();
            newTender.amount = amount;
            newTender.approval = approval;
            newTender.cardHolder = cardHolder;
            newTender.id = 0;
            newTender.newTender = true;
            newTender.reference = reference;
            newTender.user = user;
            newTender.till = userTill;
            newTender.isChange = false;
            newTender.code = code;
            newTender.cardNumber = number;
            newTender.cardExpiry = expiry;
            newTender.responseData = responseData;
            tenderCode = this.getTenderCode(code);
            newTender.type = tenderCode.tenderType;
            newTender.description = tenderCode.description;
            Date now = new Date();
            newTender.created = now.getTime();
            if (thisOrder.tenderings == null) {
                thisOrder.tenderings = new Vector();
            }
            thisOrder.tenderings.add(newTender);
            try {
                thisOrder.displayOnRemote = false;
                int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
                thisPrinter = (OrderPrinter)this.orderPrinters.get(printerName);
                if (thisPrinter != null) {
                    printData = thisPrinter.printOrder(thisOrder, newTender);
                }
                thisOrder = this.calculateTaxes(this.posLocalData.getOrder(orderNumber, true).toXml(), localTime);
                thisOrder.displayOnRemote = displayOnRemote;
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        } else {
            String authCodeError = Utility.getElement((String)"AUTH_CODE", (String)result);
            if (authCodeError.contains("Problem connecting to the HOST")) {
                result = result.replace("Problem connecting to the HOST", "Unable to connect to credit card processor");
            }
        }
        result = result + thisOrder.toXml() + "<PrintData>" + printData + "</PrintData>";
        return result;
    }

    public void setCardHandler(CardHandlerBase cardHandler) {
        this.cardHandler = cardHandler;
    }

    public void setGiftCardHandler(GiftCardHandlerBase cardHandler) {
        this.giftCardHandler = cardHandler;
    }

    public void setLoyaltyHandler(LoyaltyHandlerBase loyaltyHandler) {
        this.loyaltyHandler = loyaltyHandler;
    }

    public void setIntegratorHandler(AccuServerIntegratorBase integratorHandler) {
        this.integratorHandler = integratorHandler;
    }

    public void setEmailExceptionHandler(AccuServerEmailBase emailHandler) {
        this.emailExceptionHandler = emailHandler;
    }

    public void setEmailReceiptHandler(AccuServerEmailBase emailHandler) {
        this.emailReceiptHandler = emailHandler;
    }

    public void setRemoteDisplayHandler(RemoteDisplayBase remoteDisplayHandler) {
        this.remoteDisplayHandler = remoteDisplayHandler;
    }

    public boolean hasRemoteDisplay() {
        return this.remoteDisplayHandler != null && !this.remoteDisplayHandler.isIntegratedRemoteDisplay();
    }

    public boolean hasIntegratedRemoteDisplay() {
        return this.remoteDisplayHandler != null && this.remoteDisplayHandler.isIntegratedRemoteDisplay();
    }

    public void setServerMonitor(AccuServerMonitorBase serverMonitor) {
        this.serverMonitor = serverMonitor;
        this.serverMonitor.output("AccuSERVER Copyright 2022 by AccuPOS Point Of Sale, All Rights Reserved.");
    }

    public void setNetReportServerHandler(NetReportServerBase netReportServer) {
        this.netReportServerHandler = netReportServer;
    }

    public NetReportServerBase getNetReportServerHandler() {
        return this.netReportServerHandler;
    }

    public void setCardPostAuthProcessor(CardPostAuthBase cardPostAuthProcessor) {
        this.cardPostAuthProcessor = cardPostAuthProcessor;
    }

    public void setServerPort(int port) {
        this.serverPort = port;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getSerialNumber() {
        String result = "";
        try {
            result = this.posLocalData.getSerialNumber();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return result;
    }

    public String getSiteName() {
        String result = "";
        try {
            result = this.posLocalData.getSiteName();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return result;
    }

    public void saveAllCustomers(POSDataContainer customers) {
        try {
            this.posLocalData.saveAllCustomers(customers);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public Till getTillByName(String name) {
        Till till = null;
        try {
            till = this.posLocalData.getTillByName(name);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return till;
    }

    public Reset getReset(String till, int sequence) {
        Reset reset = null;
        try {
            reset = this.posLocalData.getReset(till, sequence);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return reset;
    }

    public POSDataContainer getExportSales(int sequence, String till) throws Exception {
        POSDataContainer transactions = null;
        transactions = this.posLocalData.getExportSales(sequence, till);
        return transactions;
    }

    public POSDataContainer getTillsWithOpenOrders() {
        POSDataContainer tillsList = null;
        try {
            tillsList = this.posLocalData.getTillsWithOpenOrders();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return tillsList;
    }

    public int updateZOutData(String till, String total) {
        int zNum = 0;
        try {
            zNum = this.posLocalData.updateZOutData(till, total);
            if (zNum > 0) {
                if (this.cardPostAuthProcessor != null) {
                    ProcessPostAuth processPostAuth = new ProcessPostAuth(zNum);
                    processPostAuth.start();
                } else if (this.cardHandler != null && this.cardHandler.getGratuity().booleanValue()) {
                    zNum = -1;
                }
                if (this.cloudDataAccess != null) {
                    this.cloudDataAccess.syncData();
                }
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        Date today = new Date();
        String backupFolder = System.getProperty("user.dir") + "/Accuserver/Backups";
        String backupStatusFileName = backupFolder + "/backupstatus.xml";
        File backupStatusFile = new File(backupStatusFileName);
        boolean runBackup = false;
        if (backupStatusFile.exists()) {
            String statusXml = Utility.getXml((String)backupStatusFileName);
            long backupMillis = Utility.getLongElement((String)"BackupTime", (String)statusXml);
            long elapsedMillis = today.getTime() - backupMillis;
            if (elapsedMillis > 86400000L) {
                runBackup = true;
            }
        } else {
            runBackup = true;
        }
        if (runBackup) {
            BackupThread backupThread = new BackupThread();
            backupThread.start();
        }
        return zNum;
    }

    public String getLicenseFor(String action) {
        String result = "";
        result = this.licenseHandler == null ? "<Status>NOT ALLOWED</Status><Reason>NO LICENSE HANDLER</Reason>" : this.licenseHandler.getLicenseFor(action);
        return result;
    }

    public boolean isRegistered() {
        long result;
        boolean registered = false;
        if (this.licenseHandler != null && (result = this.licenseHandler.getStatus()) == 0L) {
            registered = true;
        }
        return registered;
    }

    public String getDatabaseDriverName() {
        return this.posLocalData.getDriverName();
    }

    public POSDataContainer getZOutTendering(String till, int sequence) {
        POSDataContainer tenderList = null;
        try {
            tenderList = this.posLocalData.getZOutTendering(till, sequence);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return tenderList;
    }

    public void updateSequenceSentToAccounting(String till, int sequence, boolean sentToAccounting) {
        try {
            this.posLocalData.updateSequenceSentToAccounting(till, sequence, sentToAccounting);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public void updateResetsSentToAccounting() {
        try {
            this.posLocalData.updateResetsSentToAccounting();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public POSDataContainer getZOutTaxes(String till, int sequence, Timestamp fromDate, Timestamp thruDate) {
        POSDataContainer taxesList = null;
        try {
            taxesList = this.posLocalData.getZOutTaxes(till, sequence, fromDate, thruDate);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return taxesList;
    }

    public String getAccuServerConfigFileContents() {
        String result = "";
        String fileName = System.getProperty("user.dir") + "/AccuServer.cfg";
        File configFile = new File(fileName);
        if (configFile.exists() && configFile.isFile()) {
            result = Utility.getXml((String)fileName);
        }
        return result;
    }

    public String getAccuServerModuleConfigurations() {
        String result = "";
        String fileName = System.getProperty("user.dir") + "/ModuleConfigurations.xml";
        File configFile = new File(fileName);
        if (configFile.exists() && configFile.isFile()) {
            result = Utility.getXml((String)fileName);
        }
        return result;
    }

    public boolean updateAccuServerConfigFile(String content) {
        boolean result = true;
        String[] lines = content.split("\r\n");
        if (lines != null && lines.length > 0) {
            StringBuilder output = new StringBuilder();
            boolean prevLineBlank = false;
            for (int i = 0; i < lines.length; ++i) {
                String thisLine = lines[i];
                if (!thisLine.isEmpty()) {
                    output.append(thisLine + "\r\n");
                    prevLineBlank = false;
                    continue;
                }
                if (prevLineBlank) continue;
                output.append("\r\n");
                prevLineBlank = true;
            }
            content = output.toString();
        }
        try {
            String fileName = System.getProperty("user.dir") + "/AccuServer.cfg";
            Utility.writeXml((String)fileName, (String)content);
        }
        catch (IOException ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public void convertAccuShiftConfigurationToNG() {
        String config = this.getAccuServerConfigFileContents();
        String accuShiftModuleOrig = "";
        Vector modules = new Vector();
        if (config != null) {
            int startPos;
            modules = Utility.getElementList((String)"Module", (String)config);
            String startTag = "<";
            String endTag = "AccuShiftDataAccessNG</Module>";
            int endPos = config.indexOf(endTag);
            if (endPos <= (startPos = config.lastIndexOf(startTag, endPos))) {
                return;
            }
            accuShiftModuleOrig = config.substring(startPos, endPos + endTag.length());
            String newModuleLine = "<Module";
            String dbDriverName = this.getDatabaseDriverName();
            if (dbDriverName.compareToIgnoreCase("sqlexpress") == 0) {
                String dbHost = this.getDatabaseHost();
                String dbName = this.getDatabaseName();
                String dbUser = this.getDatabaseUser();
                String dbPswd = this.getDatabasePswd();
                newModuleLine = newModuleLine + " dbDriver=sqlexpress";
                if (dbHost != null && !dbHost.isEmpty()) {
                    newModuleLine = newModuleLine + " Host=" + dbHost;
                }
                if (dbName != null && !dbName.isEmpty()) {
                    newModuleLine = newModuleLine + " DatabaseName=" + dbName;
                }
                if (dbUser != null && !dbUser.isEmpty()) {
                    newModuleLine = newModuleLine + " User=" + dbUser;
                }
                if (dbPswd != null && !dbPswd.isEmpty()) {
                    newModuleLine = newModuleLine + " Password=" + dbPswd;
                }
            } else {
                newModuleLine = newModuleLine + " dbDriver=" + dbDriverName;
                String dbPath = this.posLocalData.getDatabasePath();
                if (dbPath != null && !dbPath.isEmpty()) {
                    newModuleLine = newModuleLine + " path=" + dbPath;
                }
            }
            newModuleLine = newModuleLine + ">AccuShiftDataAccess.AccuShiftDataAccessNG</Module>";
            config = config.replace(accuShiftModuleOrig, newModuleLine);
            if (!modules.contains("AccuServerWebServers.AccuServerWebServerNew")) {
                config = config + "\r\n<Module>AccuServerWebServers.AccuServerWebServerNew</Module>";
            }
            this.updateAccuServerConfigFile(config);
        }
        if (!modules.contains("AccuServerWebServers.AccuServerWebServerNew")) {
            System.out.println("starting AccuServerWebServer");
            logger.log("starting AccuServerWebServer");
            Class c = null;
            ATSClassLoader loader = new ATSClassLoader();
            try {
                c = loader.loadClass("AccuServerWebServers.AccuServerWebServerNew");
                ServerObject o = null;
                if (c == null) {
                    System.out.println("cls not found");
                } else {
                    System.out.println("init class AccuServerWebServer");
                    o = (ServerObject)c.newInstance();
                    Hashtable theseParameters = new Hashtable();
                    o.initialize((ServerCore)this, theseParameters);
                }
                if (o == null) {
                    System.out.println("no object");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.raiseException(e);
            }
        }
    }

    public boolean deleteAllItems(boolean deleteGroups) {
        boolean result = true;
        try {
            this.posLocalData.deleteAllItems(deleteGroups);
            String command = "<Action>LoadItems</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean deleteAllCustomers() {
        boolean result = true;
        try {
            this.posLocalData.deleteAllCustomers();
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean deleteSalesRecords(Timestamp invoiceDate) {
        boolean result = true;
        try {
            this.posLocalData.deleteSalesRecords(invoiceDate);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public int masterResetTills(POSDataContainer tills) {
        int masterSequence = 0;
        try {
            masterSequence = this.posLocalData.masterResetTills(tills);
            if (masterSequence > 0) {
                if (this.cardPostAuthProcessor != null) {
                    ProcessPostAuth processPostAuth = new ProcessPostAuth(masterSequence);
                    processPostAuth.start();
                } else if (this.cardHandler != null && this.cardHandler.getGratuity().booleanValue()) {
                    masterSequence = -1;
                }
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return masterSequence;
    }

    public String getAccuServerLog() {
        String result = "";
        String fileName = System.getProperty("user.dir") + "/accuServerLog.xml";
        File logFile = new File(fileName);
        if (logFile.exists() && logFile.isFile()) {
            result = Utility.getXml((String)fileName);
        }
        return result;
    }

    public String getIntegratorLog() {
        String result = "";
        String fileName = System.getProperty("user.dir") + "/accuServerIntegratorLog.xml";
        File logFile = new File(fileName);
        if (logFile.exists() && logFile.isFile()) {
            result = Utility.getXml((String)fileName);
        }
        return result;
    }

    public boolean updateLiterals(String content) {
        boolean result = true;
        String fileName = System.getProperty("user.dir") + "/Literals.xml";
        try {
            Utility.writeXml((String)fileName, (String)content);
        }
        catch (IOException ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean updateFontNames(String content) {
        boolean result = true;
        String fileName = System.getProperty("user.dir") + "/FontNames.xml";
        try {
            Utility.writeXml((String)fileName, (String)content);
        }
        catch (IOException ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public POSDataContainer getResets() {
        POSDataContainer resetsList = null;
        try {
            resetsList = this.posLocalData.getResets();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return resetsList;
    }

    public POSDataContainer getTransactionData(TransactionReportOptions reportOptions) {
        POSDataContainer transactions = null;
        try {
            transactions = this.posLocalData.getTransactionData(reportOptions);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return transactions;
    }

    public POSDataContainer getTransactionDataWithFilters(TransactionReportOptions reportOptions) {
        POSDataContainer transactions = null;
        try {
            transactions = this.posLocalData.getTransactionDataWithFilters(reportOptions);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return transactions;
    }

    public POSDataContainer getTransactionReportData(TransactionReportOptions reportOptions) {
        POSDataContainer transactions = null;
        try {
            transactions = this.posLocalData.getTransactionReportData(reportOptions);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return transactions;
    }

    public POSDataContainer getTransactionReportDataEnhanced(TransactionReportOptions reportOptions) {
        POSDataContainer transactions = null;
        try {
            transactions = this.posLocalData.getTransactionReportDataEnhanced(reportOptions);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return transactions;
    }

    public POSDataContainer getOutOfBalanceTransactionData(TransactionReportOptions reportOptions) {
        POSDataContainer resultData = null;
        try {
            resultData = this.posLocalData.getOutOfBalanceTransactionData(reportOptions);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return resultData;
    }

    public POSDataContainer getAllCustomerLoyaltyPurchases() {
        POSDataContainer custPurchases = null;
        try {
            custPurchases = this.posLocalData.getAllCustomerLoyaltyPurchases();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return custPurchases;
    }

    public double getCreditCardReceiptThreshhold() {
        double result = 0.0;
        try {
            result = this.posLocalData.getCreditCardReceiptThreshhold();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return result;
    }

    public POSDataContainer getItemSoldData(String user, String till, int sequence, Timestamp fromDate, Timestamp thruDate) {
        return this.getItemSoldData(user, till, sequence, fromDate, thruDate, null);
    }

    public POSDataContainer getItemSoldData(String user, String till, int sequence, Timestamp fromDate, Timestamp thruDate, ArrayList itemList) {
        POSDataContainer itemsSold = null;
        try {
            itemsSold = this.posLocalData.getItemSoldData(user, till, sequence, fromDate, thruDate, itemList);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return itemsSold;
    }

    public POSDataContainer getZOutTenderData(String till, int sequence, Timestamp fromDate, Timestamp thruDate) {
        POSDataContainer tenderData = null;
        try {
            tenderData = this.posLocalData.getZOutTenderData(till, sequence, fromDate, thruDate);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return tenderData;
    }

    public POSDataContainer getZOutItemTypeData(String till, int sequence, Timestamp fromDate, Timestamp thruDate) {
        POSDataContainer itemTypeData = null;
        try {
            itemTypeData = this.posLocalData.getZOutItemTypeData(till, sequence, fromDate, thruDate);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return itemTypeData;
    }

    public POSDataContainer getZOutTillData(Timestamp fromDate, Timestamp thruDate) {
        POSDataContainer tillData = null;
        try {
            tillData = this.posLocalData.getZOutTillData(fromDate, thruDate);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return tillData;
    }

    public POSDataContainer getZOutStockItems() {
        POSDataContainer stockItems = null;
        try {
            stockItems = this.posLocalData.getZOutStockItems();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return stockItems;
    }

    public void addToShiftPrinters(ServerObject printer) {
        if (this.shiftPrinters == null) {
            this.shiftPrinters = new Hashtable();
        }
        this.shiftPrinters.put(((ReportShiftPrinter)printer).getName(), (ReportShiftPrinter)printer);
    }

    public String printShiftReport(String printerName, String till, int znum, String serverId, String reportType) {
        String report = "";
        ReportShiftPrinter thisPrinter = null;
        thisPrinter = (ReportShiftPrinter)this.shiftPrinters.get(printerName);
        if (thisPrinter != null) {
            report = reportType.equalsIgnoreCase("Server") ? thisPrinter.printServerReport(serverId) : thisPrinter.printReadResetReport(till, znum);
        }
        return report;
    }

    public void setTillInUse(String till, boolean inUse) {
        try {
            this.posLocalData.setShiftIn(till, inUse);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public void setTillStartingCash(Till till) {
        try {
            this.posLocalData.setTillStartingCash(till);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public void setPriceLevelList(POSDataContainer priceLevelList) {
        this.priceLevelList = priceLevelList;
    }

    public POSDataContainer getPriceLevelList() {
        return this.priceLevelList;
    }

    public Order calculateTaxes(String orderXml, long localTime) {
        Order order = null;
        try {
            if (this.accuServerTaxHandler != null) {
                order = this.accuServerTaxHandler.calculateTaxes(orderXml, localTime);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return order;
    }

    public POSDataContainer getFoodStampTypeList() {
        return this.foodStampTypeList;
    }

    public void setFoodStampTypesList(POSDataContainer foodStampTypes) {
        this.foodStampTypeList = foodStampTypes;
    }

    public POSDataContainer getOperatorMessagesList() {
        return this.messagesList;
    }

    public void setOperatorMessagesList(POSDataContainer messages) {
        this.messagesList = messages;
    }

    public POSDataContainer getFilteredItems(String filter, long localTime, Customer customer) {
        return this.getFilteredItems(filter, localTime, customer, 0);
    }

    public POSDataContainer getFilteredItems(String filter, long localTime, Customer customer, int orderPriceLevel) {
        POSDataContainer filteredItems = null;
        try {
            filteredItems = this.posLocalData.getFilteredItems(filter);
            this.accuServerTaxHandler.calculatePriceWithTax(filteredItems);
            this.accuServerTaxHandler.getPriceLevelPrices(filteredItems, localTime, customer, orderPriceLevel);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return filteredItems;
    }

    public void updateVatIncludedItemPrices(String vatCode, double originalVat, double updatedVat) {
        try {
            this.posLocalData.updateVatIncludedItemPrices(vatCode, originalVat, updatedVat);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public String getMerchantCredentials() {
        String reply = "";
        if (this.cardHandler != null) {
            reply = this.cardHandler.getCredentials();
        }
        return reply;
    }

    public POSDataContainer getAppetizerItemTypes() {
        POSDataContainer appetizers = null;
        try {
            appetizers = this.posLocalData.getAppetizerItemTypes();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return appetizers;
    }

    public POSDataContainer getAllItemCategories() {
        POSDataContainer itemCategories = null;
        try {
            itemCategories = this.posLocalData.getAllItemCategories();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return itemCategories;
    }

    public boolean updateItemCategories(POSDataContainer itemCategories) {
        boolean success = false;
        try {
            success = this.posLocalData.updateItemCategories(itemCategories);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return success;
    }

    public boolean deleteItemCategory(ItemCategory itemCategory) {
        boolean success = false;
        try {
            success = this.posLocalData.deleteItemCategory(itemCategory);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return success;
    }

    public String getUsersGroup(String userName) {
        String usersGroup = "";
        try {
            usersGroup = this.posLocalData.getUsersGroup(userName);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return usersGroup;
    }

    public void updateOrderRemoteDisplay(int orderNumber) {
        try {
            this.posLocalData.updateOrderRemoteDisplay(orderNumber);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public void updateOrderProcessStatus(int orderNumber, int ticketNumber, String processStatus) {
        try {
            this.posLocalData.updateOrderProcessStatus(orderNumber, ticketNumber, processStatus);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public void updateLineItemProcessStatus(int orderNumber, int lineNumber, String processStatus) {
        try {
            this.posLocalData.updateLineItemProcessStatus(orderNumber, lineNumber, processStatus);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public String saveEMVOrder(String user, String userTill, String orderXml) {
        boolean displayOnRemote = false;
        Order thisOrder = null;
        String result = "";
        try {
            thisOrder = new Order(orderXml, true);
            if (thisOrder.user == null || thisOrder.user.length() == 0) {
                thisOrder.user = user;
            }
            if (thisOrder.shift == null || thisOrder.shift.length() == 0) {
                thisOrder.shift = userTill;
            }
            displayOnRemote = thisOrder.displayOnRemote;
            thisOrder.displayOnRemote = false;
            int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
            if (orderNumber == -1) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
            thisOrder = this.calculateTaxes(this.posLocalData.getOrder(orderNumber, true).toXml());
            thisOrder.displayOnRemote = displayOnRemote;
            result = thisOrder.toXml();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        return result;
    }

    public String getEMVCardTypeInfo(String emvCardType) {
        String result = "UNKNOWN";
        if (this.cardHandler != null) {
            result = this.cardHandler.getEMVCardTypeInfo(emvCardType);
        }
        if (result.contains("UNKNOWN") || result.contains("EXPIRED") || result.contains("INVALID") || result.contains("NOT_FOUND")) {
            return result;
        }
        String code = Utility.getElement((String)"Code", (String)result);
        TenderCode tenderCode = this.getTenderCode(code);
        if (tenderCode != null) {
            result = result + tenderCode.toXml();
        }
        return result;
    }

    public void saveOrderCompleted(Order order) {
        try {
            if (this.remoteDisplayHandler != null) {
                order = this.posLocalData.getOrder(order.orderNumber, true);
                this.remoteDisplayHandler.createDisplayOrder(order);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public Timestamp getLastCloudSyncTime() {
        Timestamp result = null;
        if (this.posLocalData != null) {
            result = this.posLocalData.getLastCloudSyncTime();
        }
        return result;
    }

    public void orderInvoiced(int orderNumber) {
        if (this.cloudDataAccess != null) {
            this.cloudDataAccess.syncData();
        }
        if (this.integratorHandler != null) {
            this.integratorHandler.exportLiveAccountingUpdate();
        }
        ProcessOrderInvoiced processInvoiced = new ProcessOrderInvoiced(orderNumber);
        processInvoiced.start();
    }

    public Vector getCompanyInfoList() {
        if (this.integratorHandler != null && this.integratorHandler.getType() == 30) {
            return this.integratorHandler.getCompanyInfoList();
        }
        return null;
    }

    public UserSession getUserSession(String userId) {
        UserSession thisSession = (UserSession)this.userSessions.get(userId);
        return thisSession;
    }

    public void addUserSession(UserSession session) {
        this.userSessions.put(session.userId, session);
    }

    public void updateUserSessionLastActive(String userId) {
        Object thread = null;
        try {
            UserSession userSession = this.getUserSession(userId);
            if (userSession != null) {
                userSession.updateActive();
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public boolean updateUserSecureCodes(String userId, UserSecureCodes codes) {
        return this.posLocalData.updateUserSecureCodes(userId, codes);
    }

    public UserSecureCodes getUserSecureCodes(String userId) {
        UserSecureCodes codes = null;
        try {
            codes = this.posLocalData.getUserSecureCodes(userId);
        }
        catch (Exception exception) {
            codes = null;
        }
        return codes;
    }

    public void setUserSessionHandler(UserSecurityHandlerBase handler) {
        this.userSecurityHandler = handler;
    }

    public String createSecurePasscode(User user, User target, String oldPasscode, String newPasscode) {
        String result = "";
        if (user.id.isEmpty() && !user.password.isEmpty()) {
            user = this.getUserFromReference(user.password);
        }
        if (target.id.isEmpty() && !target.password.isEmpty()) {
            target = this.getUserFromReference(target.password);
        }
        if (this.userSecurityHandler != null) {
            result = this.userSecurityHandler.createNewPasscodes(user, target, oldPasscode, newPasscode);
        }
        return result;
    }

    public String registerTerminal(String terminalName, String newIPAddress) {
        if (terminalName == null || terminalName.isEmpty()) {
            return "FAILED";
        }
        if (newIPAddress == null || newIPAddress.isEmpty()) {
            return "FAILED";
        }
        if (this.terminalSessions == null) {
            this.terminalSessions = new Hashtable();
        }
        this.terminalSessions.put(terminalName, newIPAddress);
        return "OK";
    }

    public String getTerminalIP(String terminalName) {
        String terminalIP = "";
        if (this.terminalSessions != null) {
            terminalIP = (String)this.terminalSessions.get(terminalName);
        }
        if (terminalIP == null) {
            return "";
        }
        return terminalIP;
    }

    public POSDataContainer getEMVTerminals() {
        POSDataContainer emvTerminals = new POSDataContainer();
        if (this.terminalSessions != null) {
            for (Map.Entry pair : this.terminalSessions.entrySet()) {
                String terminalName = (String)pair.getKey();
                emvTerminals.add((Object)terminalName);
            }
        }
        return emvTerminals;
    }

    public void removeTerminal(String addressToRemove) {
        if (addressToRemove == null || addressToRemove.isEmpty()) {
            return;
        }
        if (this.terminalSessions != null) {
            for (Map.Entry pair : this.terminalSessions.entrySet()) {
                String terminalIp = (String)pair.getValue();
                String terminalName = (String)pair.getKey();
                if (terminalIp.compareToIgnoreCase(addressToRemove) != 0) continue;
                this.logText("RemoveEMVTerminal Terminal ID: " + terminalName + " IP Address: " + terminalIp);
                this.terminalSessions.remove(terminalName);
                break;
            }
        }
    }

    public void registerPOSStation(String machineId, String stationName) {
        if (machineId == null || machineId.isEmpty()) {
            return;
        }
        if (stationName == null || stationName.isEmpty()) {
            return;
        }
        if (this.posStations == null) {
            this.posStations = new Hashtable();
        }
        this.posStations.put(machineId, stationName);
        Hashtable<String, String> thisStation = new Hashtable<String, String>();
        thisStation.put(machineId, stationName);
        try {
            this.posLocalData.updatePOSStations(thisStation);
        }
        catch (Exception e) {
            this.raiseException(e);
        }
    }

    public String getPOSStationName(String machineId) {
        String stationName = "";
        if (this.posStations != null) {
            stationName = (String)this.posStations.get(machineId);
        }
        if (stationName == null || stationName.isEmpty()) {
            try {
                stationName = this.posLocalData.getPOSStation(machineId);
            }
            catch (Exception e) {
                this.raiseException(e);
            }
        }
        if (stationName == null) {
            return "";
        }
        return stationName;
    }

    public POSDataContainer getPOSStations() {
        POSDataContainer stations = new POSDataContainer();
        Hashtable dbStations = new Hashtable();
        try {
            dbStations = this.posLocalData.getPOSStations();
        }
        catch (Exception e) {
            this.raiseException(e);
        }
        if (dbStations != null) {
            for (Map.Entry pair : dbStations.entrySet()) {
                String machineId = (String)pair.getKey();
                stations.add((Object)machineId);
            }
        }
        return stations;
    }

    public String getAllPOSStations() {
        String stations = "";
        Hashtable dbStations = new Hashtable();
        try {
            dbStations = this.posLocalData.getPOSStations();
        }
        catch (Exception e) {
            this.raiseException(e);
        }
        if (dbStations != null) {
            for (Map.Entry pair : dbStations.entrySet()) {
                String machineId = (String)pair.getKey();
                String stationName = (String)pair.getValue();
                stations = stations + "<POSStation><StationName>" + stationName + "</StationName><MachineId>" + machineId + "</MachineId></POSStation>";
            }
        }
        return stations;
    }

    public void removePOSStation(String removeId) {
        if (removeId == null || removeId.isEmpty()) {
            return;
        }
        if (this.posStations != null) {
            for (Map.Entry pair : this.posStations.entrySet()) {
                String stationName = (String)pair.getValue();
                String machineId = (String)pair.getKey();
                if (machineId.compareToIgnoreCase(removeId) != 0) continue;
                this.logText("Remove POS Station Machine ID: " + machineId + " Station Name: " + stationName);
                this.posStations.remove(machineId);
                try {
                    this.posLocalData.deletePOSStation(machineId);
                }
                catch (Exception e) {
                    this.raiseException(e);
                }
                break;
            }
        }
    }

    public void updatePOSStations(Hashtable posStations) {
        if (posStations == null || posStations.isEmpty()) {
            return;
        }
        for (Map.Entry pair : posStations.entrySet()) {
            String stationName = (String)pair.getValue();
            String machineId = (String)pair.getKey();
            this.logText("Updating POS Station Machine ID: " + machineId + " Station Name: " + stationName);
            posStations.put(machineId, stationName);
        }
        try {
            this.posLocalData.updatePOSStations(posStations);
        }
        catch (Exception e) {
            this.raiseException(e);
        }
    }

    public POSDataContainer getCourseNames() {
        POSDataContainer courseNames = new POSDataContainer();
        try {
            courseNames = this.posLocalData.getCourseNames();
        }
        catch (Exception e) {
            this.raiseException(e);
        }
        return courseNames;
    }

    public Hashtable getCourseNamesHashtable() {
        Hashtable courseNamesHashtable = new Hashtable();
        try {
            courseNamesHashtable = this.posLocalData.getCourseNamesHashtable();
        }
        catch (Exception e) {
            this.raiseException(e);
        }
        return courseNamesHashtable;
    }

    public boolean updateCourseNames(Hashtable courseNames) {
        boolean result = true;
        try {
            this.posLocalData.updateCourseNames(courseNames);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public void fireTableOrders(String tableName, int orderNumber) {
        try {
            if (this.remoteDisplayHandler != null) {
                POSDataContainer orders;
                if (tableName != null && !tableName.isEmpty() && (orders = this.posLocalData.getOpenOrders(tableName, "", "", true)) != null) {
                    int len = orders.size();
                    for (int i = 0; i < len; ++i) {
                        Order order = (Order)orders.get(i);
                        this.logText("REMOTE DISPLAY FIRE TABLE ORDERS:\n" + order.toXml());
                        this.remoteDisplayHandler.fireOrder(order);
                    }
                }
                if (orderNumber > 0) {
                    Order order = this.posLocalData.getOrder(orderNumber, true);
                    this.remoteDisplayHandler.fireOrder(order);
                }
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public void updateOrderRemoteFired(int orderNumber) {
        try {
            this.posLocalData.setOrderFired(orderNumber);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public boolean setOrderCurrentCourse(int orderNumber, String currentCourse) {
        boolean success = false;
        try {
            this.posLocalData.setOrderCurrentCourse(orderNumber, currentCourse);
            success = true;
        }
        catch (Exception ex) {
            this.raiseException(ex);
            success = false;
        }
        return success;
    }

    public void setCourseLinesFired(int orderNumber, String currentCourse) {
        try {
            this.posLocalData.setCourseLinesFired(orderNumber, currentCourse);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public boolean licensed() {
        boolean result = false;
        int port = 9045;
        String host = "www.abouttimesoftware.com";
        return result;
    }

    public boolean updateSerialNumber(String serialNumber) {
        boolean result = true;
        Object thread = null;
        try {
            result = this.posLocalData.updateSerialNumber(serialNumber);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public Order getOrderByInvNum(int invoiceNumber) {
        Order order = null;
        try {
            order = this.posLocalData.getOrderByInvNum(invoiceNumber);
            if (order != null && order.customer != null && this.loyaltyHandler != null) {
                this.loyaltyHandler.getPlanBalances(order.customer);
            }
        }
        catch (Exception ex) {
            order = null;
            this.handleException(ex);
        }
        return order;
    }

    public boolean getCheckPrinted(int orderNumber) {
        boolean printed = false;
        try {
            printed = this.posLocalData.getCheckPrinted(orderNumber);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return printed;
    }

    public String emailTestSetup(String emailAddress) {
        String reply = "";
        reply = this.emailReceiptHandler != null ? this.emailReceiptHandler.emailTestSetup(emailAddress) : "EmailReceipt Module missing";
        return reply;
    }

    public boolean saveAllMenuKeys(String keysXml) {
        boolean result = false;
        try {
            POSDataContainer menuKeys = new POSDataContainer();
            Vector menuKeysList = null;
            menuKeysList = Utility.getElementList((String)"Button", (String)keysXml);
            int len = menuKeysList.size();
            for (int i = 0; i < len; ++i) {
                String menuKeyXml = (String)menuKeysList.get(i);
                MenuKey menuKey = new MenuKey(menuKeyXml);
                menuKeys.add((Object)menuKey);
            }
            result = this.posLocalData.saveAllMenuKeys(menuKeys);
            String command = "<Action>LoadMenuKeys</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception e) {
            this.raiseException(e);
        }
        return result;
    }

    public boolean saveAllMenuKeys(POSDataContainer menuKeys) {
        boolean result = false;
        try {
            result = this.posLocalData.saveAllMenuKeys(menuKeys);
            String command = "<Action>LoadMenuKeys</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception e) {
            this.raiseException(e);
        }
        return result;
    }

    public int getFilteredItemsCount(String filter, String fieldName) {
        return this.getFilteredItemsCount(filter, fieldName, "startsWith");
    }

    public int getFilteredItemsCount(String filter, String fieldName, String searchOption) {
        int count = 0;
        try {
            count = this.posLocalData.getFilteredItemsCount(filter, fieldName, searchOption);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return count;
    }

    public POSDataContainer getFilteredItemsByField(String filter, String fieldName, boolean detail) {
        return this.getFilteredItemsByField(filter, fieldName, "startsWith", detail);
    }

    public POSDataContainer getFilteredItemsByField(String filter, String fieldName, String searchOption, boolean detail) {
        POSDataContainer filteredItems = null;
        try {
            filteredItems = this.posLocalData.getFilteredItemsByField(filter, fieldName, searchOption, detail);
            if (!detail) {
                this.accuServerTaxHandler.calculatePriceWithTax(filteredItems);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return filteredItems;
    }

    public void showWaitDialog(boolean display) {
        if (this.serverMonitor != null) {
            this.serverMonitor.output("Modifying database.  Please wait ......");
        }
    }

    public POSDataContainer getPrinterTypeNames(int printerType, String posType) {
        POSDataContainer printers = null;
        if (printerType == 10) {
            if (this.orderPrinters != null && !this.orderPrinters.isEmpty()) {
                printers = new POSDataContainer();
                Enumeration e = this.orderPrinters.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    OrderPrinter thisPrinter = (OrderPrinter)this.orderPrinters.get(key);
                    String printerName = thisPrinter.getName();
                    String printerPOSType = thisPrinter.getPOSType();
                    if (printerPOSType.isEmpty() && printerName.contains(posType)) {
                        printers.add((Object)printerName);
                        continue;
                    }
                    if (printerPOSType.isEmpty() || !printerPOSType.equalsIgnoreCase(posType)) continue;
                    printers.add((Object)printerName);
                }
            }
        } else if (printerType == 13) {
            if (this.shiftPrinters != null && !this.shiftPrinters.isEmpty()) {
                printers = new POSDataContainer();
                Enumeration e = this.shiftPrinters.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    ReportShiftPrinter thisPrinter = (ReportShiftPrinter)this.shiftPrinters.get(key);
                    String printerName = thisPrinter.getName();
                    String printerPOSType = thisPrinter.getPOSType();
                    if (printerPOSType.isEmpty() && printerName.contains(posType)) {
                        printers.add((Object)printerName);
                        continue;
                    }
                    if (printerPOSType.isEmpty() || !printerPOSType.equalsIgnoreCase(posType)) continue;
                    printers.add((Object)printerName);
                }
            }
        } else if (printerType == 21 && this.clockTicketPrinter != null) {
            printers = new POSDataContainer();
            printers.add((Object)this.clockTicketPrinter.getName());
        }
        return printers;
    }

    public boolean importWizardData(String userName) {
        boolean result = true;
        String[] args = new String[]{userName, this.posLocalData.getDatabasePath()};
        String dbDriver = this.posLocalData.getDriverName();
        if (dbDriver.equalsIgnoreCase("sqlexpress")) {
            String sqlErrorMessage = "Import Wizard ERROR: Importing data into a SQLExpress database is not allowed.";
            this.input("\n" + sqlErrorMessage);
            result = false;
        } else {
            Main apow = new Main();
            result = Main.main((String[])args);
            if (result) {
                this.showWaitDialog(true);
                String command = "<Action>CheckDatabase</Action>";
                this.posLocalData.setCommand(command);
            } else {
                String ret = apow.getGuiLog();
                this.input("\n" + ret);
            }
        }
        return result;
    }

    void startAutoZOutTimer() {
        Timer autoZoutTimer = new Timer();
        autoZoutTimer.schedule((TimerTask)new AutoZOutTimer(), 60000L, 60000L);
    }

    public String getZOutSummaryData(TransactionReportOptions reportOptions) {
        DataSummary zOutDataSummary = null;
        try {
            zOutDataSummary = this.posLocalData.getZOutSummaryData(reportOptions);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        if (zOutDataSummary != null) {
            return zOutDataSummary.toXml();
        }
        return null;
    }

    public DataSummary getZOutSummaryDataObject(TransactionReportOptions reportOptions) {
        DataSummary zOutDataSummary = null;
        try {
            zOutDataSummary = this.posLocalData.getZOutSummaryData(reportOptions);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        if (zOutDataSummary != null) {
            return zOutDataSummary;
        }
        return null;
    }

    public DataSummary getZOutSummaryDataObjectByTill(TransactionReportOptions reportOptions, String tillName) {
        DataSummary zOutDataSummary = null;
        try {
            zOutDataSummary = this.posLocalData.getZOutSummaryDataObjectByTill(reportOptions, tillName);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        if (zOutDataSummary != null) {
            return zOutDataSummary;
        }
        return null;
    }

    public String printGiftReceipt(int orderNumber, String printerName, boolean local) {
        String result = "";
        Order thisOrder = null;
        User thisUser = null;
        OrderPrinter thisPrinter = null;
        try {
            thisOrder = this.getOrder(orderNumber, true);
            thisUser = this.getUser(thisOrder.user);
            if (thisUser != null && (thisPrinter = (OrderPrinter)this.orderPrinters.get(printerName)) != null) {
                if (local) {
                    result = thisPrinter.printGiftReceipt(thisOrder);
                } else {
                    this.printGiftReceipt(thisOrder, printerName);
                }
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return result;
    }

    public void printGiftReceipt(Order order, String printerName) {
        try {
            OrderPrinter thisPrinter = (OrderPrinter)this.orderPrinters.get(printerName);
            if (thisPrinter != null) {
                thisPrinter.printGiftReceipt(order);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public String printGiftOrderReceipt(Order giftReceiptOrder, String printerName) {
        String result = "";
        User thisUser = null;
        OrderPrinter thisPrinter = null;
        try {
            thisUser = this.getUser(giftReceiptOrder.user);
            if (thisUser != null && (thisPrinter = (OrderPrinter)this.orderPrinters.get(printerName)) != null) {
                result = thisPrinter.printGiftReceipt(giftReceiptOrder);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return result;
    }

    public POSDataContainer getFilteredOrders(String userId, String till, Timestamp orderDate, boolean detail) {
        POSDataContainer orders = null;
        try {
            orders = this.posLocalData.getFilteredOrders(userId, till, orderDate, detail);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return orders;
    }

    public POSDataContainer getCardLast4Orders(String till, Timestamp orderDate, boolean detail, String cardLast4) {
        POSDataContainer orders = null;
        try {
            orders = this.posLocalData.getCardLast4Orders(till, orderDate, detail, cardLast4);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return orders;
    }

    public String getLoyaltyPlanBalance(String customerCode) {
        String balance = "";
        try {
            if (this.loyaltyHandler == null) {
                balance = "No Loyalty Program";
            } else {
                Customer customer = this.posLocalData.getCustomerByCode(customerCode);
                Double custBalance = this.loyaltyHandler.getLoyaltyPlanBalance(customer);
                if (custBalance != null) {
                    try {
                        DecimalFormat numberFormat = new DecimalFormat("####0.00;-####0.00");
                        balance = numberFormat.format(custBalance);
                    }
                    catch (NumberFormatException numberFormatException) {
                        balance = "No Plan Balance";
                    }
                } else {
                    balance = "No Loyalty Plan";
                }
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return balance;
    }

    public Vector getLoyaltyCustomerByCode(String filter) {
        Vector<LoyaltyCustomer> loyaltyCustomers;
        block5: {
            loyaltyCustomers = new Vector<LoyaltyCustomer>();
            try {
                if (this.loyaltyHandler == null) {
                    return loyaltyCustomers;
                }
                Vector loyaltyCustomersXml = this.loyaltyHandler.getLoyaltyCustomers();
                if (loyaltyCustomersXml != null && loyaltyCustomersXml.size() > 0) {
                    int len = loyaltyCustomersXml.size();
                    for (int i = 0; i < len; ++i) {
                        String thisCustomerXml = (String)loyaltyCustomersXml.get(i);
                        LoyaltyCustomer thisLoyaltyCustomer = new LoyaltyCustomer(thisCustomerXml);
                        loyaltyCustomers.add(thisLoyaltyCustomer);
                    }
                    break block5;
                }
                return loyaltyCustomers;
            }
            catch (Exception ex) {
                this.raiseException(ex);
            }
        }
        return loyaltyCustomers;
    }

    public POSDataContainer getSignatureOrders(Timestamp fromDate, Timestamp thruDate, double fromAmount, double toAmount) {
        POSDataContainer orders = null;
        try {
            orders = this.posLocalData.getSignatureOrders(fromDate, thruDate, fromAmount, toAmount);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return orders;
    }

    public String getInstallFileInfo(String clientType, String clientVersion) {
        String fileName = "";
        if (clientType.equalsIgnoreCase("pcPOS")) {
            int offset = clientVersion.indexOf(46);
            String versionYear = clientVersion.substring(offset - 2, offset);
            String codeVersion = clientVersion.substring(offset + 1);
            fileName = "updates/" + versionYear + "/ACCUPOSPC/" + codeVersion + "/AccuPOS-Full-Install.exe";
        }
        return fileName;
    }

    public byte[] getFileSegment(String filename, int segmentSize, int segmentNumber) {
        byte[] bytes = Utility.getFileSegment((String)filename, (int)segmentSize, (int)segmentNumber);
        return bytes;
    }

    public boolean isInvoiceable(String orderXml, String who) {
        Order order = null;
        boolean result = true;
        try {
            if (this.accuServerTaxHandler != null) {
                order = this.accuServerTaxHandler.calculateTaxes(orderXml);
            }
            if (order == null) {
                result = false;
            } else {
                double totalDiff;
                double tenderTotal = 0.0;
                if (order.tenderings != null) {
                    int len = order.tenderings.size();
                    for (int i = 0; i < len; ++i) {
                        Tender tender = (Tender)order.tenderings.get(i);
                        if (tender.isAutoGratuity || (!tender.origin.contains("EConduitEMV") && !tender.origin.contains("TriPOS") || !tender.status.contains("G")) && tender.status.contains("G")) continue;
                        tenderTotal += tender.amount;
                    }
                }
                if ((totalDiff = Utility.roundDoubleToPennies((double)order.total) - order.preTipAmount - tenderTotal) < -0.005 || totalDiff > 0.005) {
                    result = false;
                }
            }
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        if (!result) {
            this.logAuditTrail("isInvoiceable", who, "Invoice order failed \n" + order.toXml());
        }
        return result;
    }

    public POSDataContainer getItemReferenceData() {
        POSDataContainer referenceData = null;
        if (this.itemList != null && !this.itemList.isEmpty()) {
            referenceData = new POSDataContainer();
            int len = this.itemList.size();
            for (int i = 0; i < len; ++i) {
                Item thisItem = (Item)this.itemList.get(i);
                Item itemCopy = new Item(thisItem);
                if (this.accuServerTaxHandler != null) {
                    this.accuServerTaxHandler.calculatePriceWithTax(itemCopy);
                }
                referenceData.add((Object)itemCopy);
            }
        }
        return referenceData;
    }

    public boolean importInventoryRequest() {
        boolean status = false;
        if (this.integratorHandler != null) {
            status = this.integratorHandler.importInventory();
        }
        return status;
    }

    public boolean importCustomersRequest() {
        boolean status = false;
        if (this.integratorHandler != null) {
            status = this.integratorHandler.importCustomers();
        }
        return status;
    }

    public boolean exportNewItemsRequest() {
        boolean status = false;
        if (this.integratorHandler != null) {
            status = this.integratorHandler.exportNewItems();
        }
        return status;
    }

    public boolean exportSalesRequest(int sequence, String till) {
        return this.exportSalesRequest(sequence, till, false);
    }

    public boolean exportSalesRequest(int sequence, String till, boolean isResend) {
        boolean status = true;
        if (this.integratorHandler != null) {
            status = this.integratorHandler.exportSales(sequence, till, isResend);
        }
        return status;
    }

    public boolean checkExistingApRequest() {
        boolean status = false;
        if (this.integratorHandler != null) {
            status = this.integratorHandler.checkExistingRequest();
        }
        return status;
    }

    public void updateMonitorBytesIn(int bytesIn) {
        this.bytesIn = bytesIn;
        if (this.serverMonitor != null) {
            this.serverMonitor.updateBytesIn(bytesIn);
        }
    }

    public void updateMonitorBytesOut(int bytesOut) {
        this.bytesOut = bytesOut;
        if (this.serverMonitor != null) {
            this.serverMonitor.updateBytesOut(bytesOut);
        }
    }

    public void updateMonitorServerPort(int port) {
        if (this.serverMonitor != null) {
            this.serverMonitor.updateServerPort(port);
        }
    }

    public boolean hasNetReportServer() {
        return this.netReportServerHandler != null;
    }

    public boolean hasAccountingIntegration() {
        return this.integratorHandler != null;
    }

    public String netXReportRequest() {
        String reply = "";
        if (this.netReportServerHandler != null) {
            reply = this.netReportServerHandler.xReport();
        }
        return reply;
    }

    public String netSalesReportRequest(Timestamp start, Timestamp end) {
        String reply = "";
        if (this.netReportServerHandler != null) {
            reply = this.netReportServerHandler.salesReport(start, end);
        }
        return reply;
    }

    public String netTenderReportRequest(Timestamp start, Timestamp end) {
        String reply = "";
        if (this.netReportServerHandler != null) {
            reply = this.netReportServerHandler.tenderReport(start, end);
        }
        return reply;
    }

    public String netInvoicedItemDetailRequest(Timestamp start, Timestamp end, String fromType, String thruType) {
        String reply = "";
        if (this.netReportServerHandler != null) {
            reply = this.netReportServerHandler.invoicedItemDetailData(start, end, fromType, thruType);
        }
        return reply;
    }

    public String netTransactionDetailRequest(Timestamp start, Timestamp end, String fromType, String thruType) {
        String reply = "";
        if (this.netReportServerHandler != null) {
            reply = this.netReportServerHandler.transactionDetailData(start, end, fromType, thruType);
        }
        return reply;
    }

    public String netUserDetailRequest(Timestamp start, Timestamp end, String fromType, String thruType) {
        String reply = "";
        if (this.netReportServerHandler != null) {
            reply = this.netReportServerHandler.transactionDetailData(start, end, fromType, thruType);
        }
        return reply;
    }

    public POSDataContainer getXReportData() {
        return this.posLocalData.doXReport();
    }

    public Hashtable getSalesReportData(Timestamp start, Timestamp end) {
        return this.posLocalData.doSalesReport(start, end);
    }

    public Hashtable getTenderReportData(Timestamp start, Timestamp end) {
        return this.posLocalData.doTenderReport(start, end);
    }

    public POSDataContainer getInvoicedItemDetailData(Timestamp start, Timestamp end) {
        return this.posLocalData.doItemSalesDetailData(start, end);
    }

    public POSDataContainer getTransactionDetailData(Timestamp start, Timestamp end) {
        return this.posLocalData.doTransactionDetailData(start, end);
    }

    public POSDataContainer getPostAuthRecords(int zNum) {
        POSDataContainer tenders = null;
        try {
            tenders = this.posLocalData.getPostAuthRecords(zNum);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return tenders;
    }

    public int getInvoiceNumber(int transactionNumber) {
        int invoiceNumber = 0;
        try {
            invoiceNumber = this.posLocalData.getInvoiceNumber(transactionNumber);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return invoiceNumber;
    }

    public void updateCreditCardTender(boolean succeeded, String cardNumber, int key, String responseData, String refNumber) {
        try {
            this.posLocalData.updateCreditCardTender(succeeded, cardNumber, key, responseData, refNumber);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public byte[] encrypt(String key, String value) throws GeneralSecurityException {
        if (this.encryption != null) {
            return this.encryption.encrypt(key, value);
        }
        return null;
    }

    public String decrypt(String key, byte[] encrypted) throws GeneralSecurityException {
        if (this.encryption != null) {
            return this.encryption.decrypt(key, encrypted);
        }
        return null;
    }

    public byte[] getEncodedKey() {
        if (this.encryption != null) {
            return this.encryption.getEncodedKey();
        }
        return null;
    }

    public byte[] getEncodedKey2() {
        if (this.encryption != null) {
            return this.encryption.getEncodedKey2();
        }
        return null;
    }

    public String processCheck(Check check, double amount, String user, String userTill, String orderXml, String code, String printerName, long localTime) {
        Order thisOrder = null;
        Tender newTender = null;
        OrderPrinter thisPrinter = null;
        boolean displayOnRemote = false;
        String result = "DECLINED";
        String newTenderResult = "";
        if (this.cardHandler == null) {
            return result;
        }
        if (check == null) {
            return "MISSING_CHECK_DATA";
        }
        thisOrder = new Order(orderXml, true);
        try {
            if (thisOrder.user == null || thisOrder.user.length() == 0) {
                thisOrder.user = user;
            }
            if (thisOrder.shift == null || thisOrder.shift.length() == 0) {
                thisOrder.shift = userTill;
            }
            displayOnRemote = thisOrder.displayOnRemote;
            thisOrder.displayOnRemote = false;
            int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
            if (orderNumber == -1) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
            thisOrder = this.posLocalData.getOrder(orderNumber, true);
            thisOrder.displayOnRemote = displayOnRemote;
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        if (check.isPersonalCheck) {
            result = this.cardHandler.processCheckPersonal(check, amount, user, Integer.toString(thisOrder.orderNumber));
        } else if (check.isCorporateCheck) {
            result = this.cardHandler.processCheckCorporate(check, amount, user, Integer.toString(thisOrder.orderNumber));
        } else if (check.isPersonalAuthenticateCheck) {
            result = this.cardHandler.processCheckPersonalAuthenticate(check, amount, user, Integer.toString(thisOrder.orderNumber));
        } else if (check.isWebCheck) {
            result = this.cardHandler.processCheckWeb(check, amount, user, Integer.toString(thisOrder.orderNumber));
        }
        String printData = "";
        String approved = Utility.getElement((String)"RESULT", (String)result);
        if (approved.equalsIgnoreCase("APPROVED") || approved.equalsIgnoreCase("PARITIALLY APPROVED")) {
            String approval = Utility.getElement((String)"AUTH_CODE", (String)result);
            String reference = Utility.getElement((String)"TROUTD", (String)result);
            String responseData = Utility.getElement((String)"XML_REQUEST", (String)result);
            newTender = new Tender();
            newTender.amount = amount;
            newTender.approval = approval;
            newTender.id = 0;
            newTender.newTender = true;
            newTender.reference = reference;
            newTender.user = user;
            newTender.till = userTill;
            newTender.isChange = false;
            newTender.code = code;
            newTender.responseData = responseData;
            TenderCode tenderCode = this.getTenderCode(code);
            newTender.type = tenderCode.tenderType;
            newTender.description = tenderCode.description;
            long thisTenderCreated = newTender.created = new Date().getTime();
            if (thisOrder.tenderings == null) {
                thisOrder.tenderings = new Vector();
            }
            thisOrder.tenderings.add(newTender);
            try {
                thisOrder.displayOnRemote = false;
                int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
                thisPrinter = (OrderPrinter)this.orderPrinters.get(printerName);
                if (thisPrinter != null) {
                    printData = thisPrinter.printOrder(thisOrder, newTender);
                }
                thisOrder = this.calculateTaxes(this.posLocalData.getOrder(orderNumber, true).toXml(), localTime);
                int tenderLen = thisOrder.tenderings.size();
                for (int i = 0; i < tenderLen; ++i) {
                    Tender thisTender = (Tender)thisOrder.tenderings.get(i);
                    if (thisTender.created != thisTenderCreated) continue;
                    newTenderResult = "<NewTenderId>" + thisTender.id + "</NewTenderId>";
                }
                thisOrder.displayOnRemote = displayOnRemote;
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        } else {
            String authCodeError = Utility.getElement((String)"AUTH_CODE", (String)result);
            if (authCodeError.contains("Problem connecting to the HOST")) {
                result = result.replace("Problem connecting to the HOST", "Unable to connect to check processor");
            }
        }
        result = result + thisOrder.toXml() + "<PrintData>" + printData + "</PrintData>";
        result = result + newTenderResult;
        return result;
    }

    public String processCheckVoid(String reference, double amount, String user, String userTill, String orderXml, String code) {
        Order thisOrder = null;
        Tender newTender = null;
        String result = "DECLINED";
        if (this.cardHandler == null) {
            return result;
        }
        thisOrder = new Order(orderXml, true);
        try {
            int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
            if (orderNumber == -1) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
            thisOrder = this.posLocalData.getOrder(orderNumber, true);
            if (thisOrder.created == null) {
                thisOrder.created = new Timestamp(Utility.getLongElement((String)"Created", (String)orderXml));
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        result = this.cardHandler.processCheckVoid(user, Integer.toString(thisOrder.orderNumber), reference);
        String approved = Utility.getElement((String)"RESULT", (String)result);
        if (approved.equalsIgnoreCase("APPROVED")) {
            String approval = Utility.getElement((String)"AUTH_CODE", (String)result);
            newTender = new Tender();
            newTender.amount = amount * -1.0;
            newTender.approval = approval;
            newTender.id = 0;
            newTender.newTender = true;
            newTender.user = user;
            newTender.till = userTill;
            newTender.isChange = false;
            newTender.code = code;
            TenderCode tenderCode = this.getTenderCode(code);
            newTender.type = tenderCode.tenderType;
            newTender.description = tenderCode.description;
            newTender.status = "V";
            newTender.created = new Date().getTime();
            if (thisOrder.tenderings == null) {
                thisOrder.tenderings = new Vector();
            }
            thisOrder.tenderings.add(newTender);
            try {
                int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
                thisOrder = this.posLocalData.getOrder(orderNumber, true);
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        } else {
            String authCodeError = Utility.getElement((String)"AUTH_CODE", (String)result);
            if (authCodeError.contains("Problem connecting to the HOST")) {
                result = result.replace("Problem connecting to the HOST", "Unable to connect to check processor");
            }
        }
        result = result + thisOrder.toXml();
        return result;
    }

    public void setBlockLogin(boolean blockLogin) {
        this.blockLogin = blockLogin;
    }

    public boolean isBlockLogin() {
        return this.blockLogin;
    }

    public void importReset() {
        if (this.integratorHandler != null) {
            this.integratorHandler.importReset();
        }
    }

    public String getCardsSetup() {
        return this.cardsSetupHandler.getCardsInfo();
    }

    public void saveCardsSetup(String cardsSetupXml) {
        this.cardsSetupHandler.saveCardsInfo(cardsSetupXml);
        if (this.cardHandler != null) {
            this.cardHandler.loadCards();
        }
        if (this.cardPostAuthProcessor != null) {
            this.cardPostAuthProcessor.loadCards();
        }
    }

    public void saveCardsMerchantId(String merchantId) {
        if (merchantId == null || merchantId.isEmpty()) {
            return;
        }
        if (this.cardsSetupHandler != null) {
            this.cardsSetupHandler.saveCardsMerchantId(merchantId);
        }
        if (this.cardHandler != null) {
            this.cardHandler.loadCards();
        }
        if (this.cardPostAuthProcessor != null) {
            this.cardPostAuthProcessor.loadCards();
        }
    }

    public POSDataContainer getNoPartialQuantityItems() {
        POSDataContainer itemsList = null;
        try {
            itemsList = this.posLocalData.getNoPartialQuantityItems();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return itemsList;
    }

    public boolean saveNoPartialQuantityItems(POSDataContainer noPartialQuantities) {
        return this.saveNoPartialQuantityItems(noPartialQuantities, false);
    }

    public boolean saveNoPartialQuantityItems(POSDataContainer noPartialQuantities, boolean loadItems) {
        boolean result = false;
        try {
            result = this.posLocalData.saveNoPartialQuantityItems(noPartialQuantities);
            if (loadItems) {
                String command = "<Action>LoadItems</Action>";
                this.posLocalData.setCommand(command);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return result;
    }

    public void emailReceipt(Order thisOrder, String emailAddress) {
        if (!emailAddress.isEmpty() && this.emailReceiptHandler != null) {
            EmailReceiptThread thisThread = new EmailReceiptThread(thisOrder, emailAddress);
            thisThread.start();
        }
    }

    public void sendSMSReceipt(int orderNumber, String smsAddress) {
        if (orderNumber != 0 && this.smsHandler != null) {
            SMSReceiptThread thisThread = new SMSReceiptThread(orderNumber, smsAddress);
            thisThread.start();
        }
    }

    public void emailException(String message, Exception ex) {
        if (this.emailExceptionHandler != null) {
            String companyName = "";
            if (this.company != null && this.company.name != null && !this.company.name.isEmpty()) {
                companyName = this.company.name;
            }
            String exceptionMessage = "";
            exceptionMessage = message != null && !message.isEmpty() ? message : this.getLiteral("AccuServer Exception");
            String serialNumber = "";
            if (this.licenseHandler != null) {
                serialNumber = this.getSerialNumber();
            }
            EmailExceptionThread thisThread = new EmailExceptionThread(companyName, serialNumber, exceptionMessage, ex);
            thisThread.start();
        }
    }

    public void showLoadingDataMessage(boolean start) {
        if (start) {
            this.input("\nServer Loading Data.... Login disabled....\n");
        } else {
            this.input("\nServer Loading Data Completed.... Login enabled....\n");
            this.startAutoBackupTimer();
        }
    }

    public boolean itemTypeExists(String itemType) {
        boolean itemTypeExists = false;
        if (this.itemList != null) {
            int len = this.itemList.size();
            for (int i = 0; i < len; ++i) {
                Item item = (Item)this.itemList.get(i);
                if (!item.type.equalsIgnoreCase(itemType)) continue;
                itemTypeExists = true;
                break;
            }
        }
        return itemTypeExists;
    }

    private boolean validateItemGroup(String itemId, String detailItem) throws Exception {
        boolean result = true;
        if (itemId.equalsIgnoreCase(detailItem)) {
            result = false;
        } else {
            int i;
            ChoiceGroup choiceGroup;
            Item thisItem = this.findPOSItemByCode(detailItem);
            if (thisItem == null) {
                return true;
            }
            if (thisItem != null && thisItem.isBundle) {
                this.validationErrorMsg = "Detail item (" + thisItem.description + ") has an \nItem Group which may trigger an endless loop.";
                result = false;
            }
            if (result && thisItem.choiceGroup != null && !thisItem.choiceGroup.isEmpty() && (choiceGroup = this.getChoiceGroup(thisItem.choiceGroup)) != null && choiceGroup.pages != null) {
                for (i = 0; i < choiceGroup.pages.length; ++i) {
                    ChoicesPage choicePage = choiceGroup.pages[i];
                    if (choicePage != null && !choicePage.choices.isEmpty()) {
                        int len = choicePage.choices.size();
                        for (int j = 0; j < len; ++j) {
                            Choice choice = (Choice)choicePage.choices.get(j);
                            if (choice.itemCode == null || choice.itemCode.isEmpty() || (result = this.validateItemGroup(itemId, choice.itemCode))) continue;
                            this.validationErrorMsg = "Detail item (" + thisItem.description + ") has a Choice (" + choice.text + ") that has a \nChoice Item (" + choice.itemCode + ") which may trigger an endless loop.";
                            break;
                        }
                    }
                    if (!result) break;
                }
            }
            if (result && thisItem.followOns != null) {
                int len = thisItem.followOns.items.size();
                for (i = 0; i < len; ++i) {
                    Item followOnItem = (Item)thisItem.followOns.items.get(i);
                    result = this.validateItemGroup(itemId, followOnItem.code);
                    if (result) continue;
                    this.validationErrorMsg = "Detail item (" + thisItem.description + ") has a FollowOn item (" + followOnItem.code + ") that has an \nItem Group which may trigger an endless loop.";
                    break;
                }
            }
        }
        return result;
    }

    private boolean validateFollowOns(String itemId, String followOnItem) throws Exception {
        boolean result = true;
        if (itemId.equalsIgnoreCase(followOnItem)) {
            result = false;
        } else {
            int i;
            Item thisItem = this.findPOSItemByCode(followOnItem);
            if (thisItem != null && thisItem.isBundle) {
                this.validationErrorMsg = "FollowOn item (" + thisItem.description + ") has an \nItem Group which may trigger an endless loop.";
                result = false;
            }
            if (result && thisItem.choiceGroup != null && !thisItem.choiceGroup.isEmpty()) {
                ChoiceGroup choiceGroup = this.getChoiceGroup(thisItem.choiceGroup);
                for (i = 0; i < choiceGroup.pages.length; ++i) {
                    ChoicesPage choicePage = choiceGroup.pages[i];
                    if (choicePage != null && !choicePage.choices.isEmpty()) {
                        int len = choicePage.choices.size();
                        for (int j = 0; j < len; ++j) {
                            Choice choice = (Choice)choicePage.choices.get(j);
                            if (choice.itemCode == null || choice.itemCode.isEmpty() || (result = this.validateFollowOns(itemId, choice.itemCode))) continue;
                            this.validationErrorMsg = "FollowOn item (" + thisItem.description + ") has a Choice (" + choice.text + ") that has a \nChoice Item (" + choice.itemCode + ") which may trigger an endless loop.";
                            break;
                        }
                    }
                    if (!result) break;
                }
            }
            if (result && thisItem.followOns != null) {
                int len = thisItem.followOns.items.size();
                for (i = 0; i < len; ++i) {
                    Item thisFollowOnItem = (Item)thisItem.followOns.items.get(i);
                    result = this.validateFollowOns(itemId, thisFollowOnItem.code);
                    if (result) continue;
                    this.validationErrorMsg = "FollowOn item (" + thisItem.description + ") has a FollowOn item (" + thisFollowOnItem.code + ") that has an \nItem Group or another FollowOn which may trigger an endless loop.";
                    break;
                }
            }
        }
        return result;
    }

    private ArrayList getItemCodesByItemType(String itemType) {
        ArrayList<String> result = null;
        if (this.itemList != null) {
            result = new ArrayList<String>();
            int len = this.itemList.size();
            for (int i = 0; i < len; ++i) {
                Item thisItem = (Item)this.itemList.get(i);
                if (!thisItem.type.equalsIgnoreCase(itemType)) continue;
                result.add(thisItem.code);
            }
        }
        return result;
    }

    public void setClockTicketPrinter(ClockTicketPrinter clockTicketPrinter) {
        this.clockTicketPrinter = clockTicketPrinter;
    }

    public void updateItemsCache(Item item, boolean isInitialLoad) {
        int pos;
        if (isInitialLoad) {
            this.itemList.add((Object)item);
        } else {
            pos = this.itemList.indexOf((Object)new Item(item.code, "", "", "", 0.0, 0.0, true));
            if (pos >= 0) {
                this.itemList.set(pos, (Object)item);
            } else {
                this.itemList.add((Object)item);
            }
        }
        if (item != null && item.type != null && item.type.equalsIgnoreCase("Payout")) {
            pos = this.payoutItemList.indexOf((Object)new Item(item.code, "", "", "", 0.0, 0.0, true));
            if (pos >= 0) {
                this.payoutItemList.set(pos, (Object)item);
            } else {
                this.payoutItemList.add((Object)item);
            }
        }
    }

    public double updateItemPrice(Item item, int priceColumn) {
        double price = item.price1;
        if (priceColumn >= 1 && priceColumn <= 5) {
            switch (priceColumn) {
                case 1: {
                    price = item.price1;
                    break;
                }
                case 2: {
                    price = item.price2;
                    break;
                }
                case 3: {
                    price = item.price3;
                    break;
                }
                case 4: {
                    price = item.price4;
                    break;
                }
                case 5: {
                    price = item.price5;
                }
            }
        }
        return price;
    }

    public boolean changeItemPrice(String itemCode, double newPrice) {
        boolean success = false;
        try {
            double updatePrice = newPrice;
            if (this.hasWithVatIncludedTaxCalculator()) {
                Item updateItem = this.findItemByCode(itemCode);
                updatePrice = this.accuServerTaxHandler.getPriceBeforeTax(newPrice, updateItem.vatCode);
            }
            if (this.posLocalData != null) {
                success = this.posLocalData.changeItemPrice(itemCode, updatePrice);
            }
            if (success = true) {
                int len = this.menuKeysList.size();
                for (int i = 0; i < len; ++i) {
                    MenuKey menuKey = (MenuKey)this.menuKeysList.get(i);
                    if (menuKey.text.compareToIgnoreCase(itemCode) != 0) continue;
                    menuKey.price = newPrice;
                }
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return success;
    }

    public String getTimeClockPassword() {
        String password = "";
        try {
            if (this.accuShiftLocalData != null) {
                password = this.accuShiftLocalData.getPassword();
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return password;
    }

    public void updateTimeClockPassword(String password) {
        try {
            if (this.accuShiftLocalData != null) {
                this.accuShiftLocalData.updatePassword(password);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public String[] getPayTypes() {
        String[] payTypes = new String[20];
        try {
            if (this.accuShiftLocalData != null) {
                payTypes = this.accuShiftLocalData.getPaytypes();
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return payTypes;
    }

    public PayPeriodInfo getPayPeriodInfo() {
        PayPeriodInfo payPeriodInfo = null;
        try {
            if (this.accuShiftLocalData != null) {
                payPeriodInfo = this.accuShiftLocalData.getPayPeriodInfo();
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return payPeriodInfo;
    }

    public void savePayTypes(String[] payTypes) {
        try {
            if (this.accuShiftLocalData != null) {
                this.accuShiftLocalData.savePayTypes(payTypes);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public void savePayPeriod(PayPeriodInfo payPeriodInfo) {
        try {
            if (this.accuShiftLocalData != null) {
                this.accuShiftLocalData.savePayPeriod(payPeriodInfo);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public ArrayList getEmployees() {
        ArrayList employees = null;
        try {
            if (this.accuShiftLocalData != null) {
                employees = this.accuShiftLocalData.getEmployees();
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return employees;
    }

    public void updateEmployee(Employee employee) {
        try {
            if (this.accuShiftLocalData != null) {
                this.accuShiftLocalData.updateEmployee(employee);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public void updateDataObjects(ArrayList dataList, String objectName) {
        if (objectName.equalsIgnoreCase("Employee")) {
            this.updateEmployees(dataList, false);
        }
    }

    public void removeDataObject(Object object, String objectName) {
        if (objectName.equalsIgnoreCase("Employee")) {
            Employee employee = (Employee)object;
            this.removeEmployee(employee.accountingId);
        }
    }

    public void updateEmployees(ArrayList employeesList, boolean updatePaytypes) {
        try {
            if (this.accuShiftLocalData != null) {
                this.accuShiftLocalData.updateEmployees(employeesList, updatePaytypes);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public void removeEmployee(String employeeId) {
        try {
            if (this.accuShiftLocalData != null) {
                this.accuShiftLocalData.removeEmployee(employeeId);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public void getEmployeePeriodDetail(Employee employee) {
        try {
            if (this.accuShiftLocalData != null) {
                this.accuShiftLocalData.getEmployeePeriodDetail(employee);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public Employee getEmployeePeriodDetailFromTimeRange(Employee employee, Timestamp startDate, Timestamp endDate) {
        Employee returnEmployee = null;
        try {
            if (this.accuShiftLocalData != null) {
                returnEmployee = this.accuShiftLocalData.getEmployeePeriodDetailFromTimeRange(employee, startDate, endDate);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return returnEmployee;
    }

    public void updatePayTypeNames(String payTypeNamesXml) {
        try {
            if (this.accuShiftLocalData != null) {
                this.accuShiftLocalData.updatePayTypeNames(payTypeNamesXml);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public String importEmployeesRequest(boolean resetPayTypes) {
        String response = "AccuServer is not configured for accounting integration";
        if (this.integratorHandler != null) {
            boolean status = this.integratorHandler.importEmployees(resetPayTypes);
            response = status ? "OK" : "Failed";
        }
        return response;
    }

    public ArrayList getEmployeesWithOpenDetail() {
        return this.getEmployeesWithOpenDetail(true);
    }

    public ArrayList getEmployeesWithOpenDetail(boolean includeBreaks) {
        ArrayList employeeList = null;
        try {
            if (this.accuShiftLocalData != null) {
                employeeList = this.accuShiftLocalData.getEmployeesWithOpenDetail(includeBreaks);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return employeeList;
    }

    public ArrayList getEmployeesWithOpenDetailFromTimeRange(Timestamp startDate, Timestamp endDate) {
        ArrayList employeeList = null;
        try {
            if (this.accuShiftLocalData != null) {
                employeeList = this.accuShiftLocalData.getEmployeesWithOpenDetailFromTimeRange(startDate, endDate);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return employeeList;
    }

    public String exportTimesRequest(ArrayList employeeArrayList) {
        String response = "AccuServer is not configured for accounting integration";
        if (this.integratorHandler != null) {
            boolean status = this.integratorHandler.exportTimes(employeeArrayList);
            response = status ? "OK" : "Failed";
        }
        return response;
    }

    public void updateEmployeeTime(String accountingId, TimeDetail detail) {
        try {
            if (this.accuShiftLocalData != null) {
                this.accuShiftLocalData.updateEmployeeTime(accountingId, detail);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public ArrayList getTimesSent() {
        ArrayList timesList = null;
        try {
            if (this.accuShiftLocalData != null) {
                timesList = this.accuShiftLocalData.getTimesSent();
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return timesList;
    }

    public ArrayList getEmployeeTimesSent(ArrayList timesSent) {
        ArrayList employeesList = null;
        try {
            if (this.accuShiftLocalData != null) {
                employeesList = this.accuShiftLocalData.getEmployeeTimesSent(timesSent);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return employeesList;
    }

    public void getEmployeeTimesSent(Employee employee) {
        try {
            if (this.accuShiftLocalData != null) {
                this.accuShiftLocalData.getEmployeeTimesSent(employee);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public ArrayList getEmployeesTimeFromDateRange(Timestamp startDate, Timestamp endDate) {
        ArrayList employeeTimes = null;
        try {
            if (this.accuShiftLocalData != null) {
                employeeTimes = this.accuShiftLocalData.getEmployeesTimeFromDateRange(startDate, endDate);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return employeeTimes;
    }

    public void getCurrentPeriodCompletedDetail(Employee employee) {
        try {
            if (this.accuShiftLocalData != null) {
                this.accuShiftLocalData.getCurrentPeriodCompletedDetail(employee);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public POSDataContainer getHolidays(Timestamp startDate, Timestamp endDate) {
        POSDataContainer holidaysResult = new POSDataContainer();
        try {
            if (this.accuShiftLocalData != null) {
                holidaysResult = this.accuShiftLocalData.getHolidays(startDate, endDate);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return holidaysResult;
    }

    public boolean updateHolidays(POSDataContainer holidays) {
        boolean success = false;
        try {
            if (this.accuShiftLocalData != null) {
                success = this.accuShiftLocalData.updateHolidays(holidays);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return success;
    }

    public boolean deleteHolidaysByIds(int[] ids) {
        boolean success = false;
        try {
            if (this.accuShiftLocalData != null) {
                success = this.accuShiftLocalData.deleteHolidaysByIds(ids);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return success;
    }

    public String getDatabasePath() {
        String path = "";
        try {
            if (this.posLocalData != null) {
                path = this.posLocalData.getDatabasePath();
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return path;
    }

    public String getDatabaseHost() {
        String dbHost = "";
        try {
            if (this.posLocalData != null) {
                dbHost = this.posLocalData.getDatabaseHost();
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return dbHost;
    }

    public String getDatabaseName() {
        String dbName = "";
        try {
            if (this.posLocalData != null) {
                dbName = this.posLocalData.getDatabaseName();
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return dbName;
    }

    public String getDatabaseUser() {
        String dbUser = "";
        try {
            if (this.posLocalData != null) {
                dbUser = this.posLocalData.getDatabaseUser();
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return dbUser;
    }

    public String getDatabasePswd() {
        String dbPswd = "";
        try {
            if (this.posLocalData != null) {
                dbPswd = this.posLocalData.getDatabasePswd();
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return dbPswd;
    }

    public Connection getDatabaseConnection() {
        Connection conn = null;
        try {
            if (this.posLocalData != null) {
                conn = this.posLocalData.getDatabaseConnection();
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return conn;
    }

    public String changeMerchantPassword(String oldPassword, String newPassword) {
        String result = "ERROR";
        if (this.cardHandler != null) {
            result = this.cardHandler.processChangeMerchantPassword(oldPassword, newPassword);
        }
        return result;
    }

    public String processCreditCardVoidIL(String user, String userTill, String orderXml, int tenderId) {
        Order thisOrder = null;
        Tender voidTender = null;
        Tender newTender = null;
        String result = "DECLINED";
        if (this.cardHandler == null) {
            return result;
        }
        thisOrder = new Order(orderXml, true);
        try {
            int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
            if (orderNumber == -1) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
            thisOrder = this.posLocalData.getOrder(orderNumber, true);
            voidTender = this.posLocalData.getTenderDetail(tenderId);
            result = this.cardHandler.processVoidIL(thisOrder.orderNumber, voidTender);
            Tender updatedTender = this.posLocalData.getTenderDetail(tenderId);
            voidTender.cardNumber = updatedTender.cardNumber;
            voidTender.status = "V";
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        String approved = Utility.getElement((String)"RESULT", (String)result);
        if (approved.equalsIgnoreCase("APPROVED")) {
            newTender = new Tender();
            newTender.amount = voidTender.amount * -1.0;
            newTender.approval = voidTender.approval;
            newTender.cardHolder = voidTender.cardHolder;
            newTender.id = 0;
            newTender.newTender = true;
            newTender.reference = voidTender.reference;
            newTender.user = user;
            newTender.till = userTill;
            newTender.isChange = false;
            newTender.code = voidTender.code;
            newTender.cardNumber = voidTender.cardNumber;
            newTender.cardExpiry = voidTender.cardExpiry;
            newTender.responseData = voidTender.responseData;
            TenderCode tenderCode = this.getTenderCode(voidTender.code);
            newTender.type = tenderCode.tenderType;
            newTender.description = tenderCode.description;
            newTender.status = "V";
            Date now = new Date();
            newTender.created = now.getTime();
            if (thisOrder.tenderings == null) {
                thisOrder.tenderings = new Vector();
            }
            thisOrder.tenderings.add(newTender);
            try {
                int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
                thisOrder = this.posLocalData.getOrder(orderNumber, true);
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        } else {
            String authCodeError = Utility.getElement((String)"AUTH_CODE", (String)result);
            if (authCodeError.contains("Problem connecting to the HOST")) {
                result = result.replace("Problem connecting to the HOST", "Unable to connect to credit card processor");
            }
        }
        result = result + thisOrder.toXml();
        return result;
    }

    public String getMessage() {
        String message = "";
        if (this.licenseHandler != null) {
            message = this.licenseHandler.getMessage();
        }
        return message;
    }

    public String getBatchSummary(String transmitDate, String referenceNumber) {
        String result = "";
        boolean postAuthDone = false;
        if (this.cardHandler == null) {
            result = "<RESULT>Error: Card Handler Not Defined</RESULT>";
            return result;
        }
        try {
            postAuthDone = this.posLocalData.getPostAuthCompleted();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        if (postAuthDone) {
            result = this.cardHandler.getBatchSummary(transmitDate, referenceNumber);
        } else {
            String msg1 = this.getLiteral("Post Auth not completed.");
            String msg2 = this.getLiteral("Please try again at a later time.");
            result = "<RESULT>" + msg1 + "\n\n" + msg2 + "</RESULT>";
        }
        return result;
    }

    public POSDataContainer getPostAuthsCompleted() {
        POSDataContainer result = null;
        try {
            result = this.posLocalData.getPostAuthsCompleted();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return result;
    }

    public ArrayList getBreaks() {
        ArrayList breaks = null;
        try {
            if (this.accuShiftLocalData != null) {
                breaks = this.accuShiftLocalData.getBreaks();
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return breaks;
    }

    public void removeBreak(int id) {
        try {
            if (this.accuShiftLocalData != null) {
                this.accuShiftLocalData.removeBreak(id);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public void updateBreaks(ArrayList breaksList) {
        try {
            if (this.accuShiftLocalData != null) {
                this.accuShiftLocalData.updateBreaks(breaksList);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public void deleteEmployeeTime(long timeId) {
        try {
            if (this.accuShiftLocalData != null) {
                this.accuShiftLocalData.deleteEmployeeTime(timeId);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public void setAd2POSClient(Ad2POSClientBase client) {
        this.ad2POSClient = client;
    }

    public POSDataContainer getAllUnitOfMeasures() {
        POSDataContainer uomList = null;
        try {
            uomList = this.posLocalData.getAllUnitOfMeasures();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return uomList;
    }

    public AdInfo getNextAd(String adType, String reference) {
        AdInfo result = null;
        result = this.ad2POSClient != null ? this.ad2POSClient.getNextAd(adType, reference) : new AdInfo();
        return result;
    }

    public void useAd(AdInfo ad) {
        if (this.ad2POSClient != null) {
            this.ad2POSClient.useAd(ad);
        }
    }

    public void setHostConnector(AccuServerHostConnectorBase connector) {
        if (connector != null) {
            this.hostConnector = connector;
            if (!this.disableHostConnection && !this.disableHostPing) {
                this.startPingHostConnectionTimer();
            }
        }
    }

    public Vector getObjectList(SearchObject searchObject) {
        Vector result = null;
        String methodName = "get" + searchObject.name;
        int len = searchObject.searchFields.size();
        String[] args = new String[len];
        for (int i = 0; i < len; ++i) {
            SearchField searchField = (SearchField)searchObject.searchFields.get(i);
            methodName = methodName + searchField.operator + searchField.field;
            args[i] = searchField.value;
        }
        Method[] methods = this.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equalsIgnoreCase(methodName)) continue;
            try {
                result = (Vector)methods[i].invoke((Object)this, (Object[])args);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.input(illegalAccessException.toString());
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.input(illegalArgumentException.toString());
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                this.input(invocationTargetException.toString());
            }
        }
        return result;
    }

    public Vector getObjectByDate(String objectName, String fromDate, String thruDate, String searchData) {
        Vector result = null;
        String methodName = "get" + objectName + "ByDate";
        String[] args = new String[]{fromDate, thruDate, searchData};
        Method[] methods = this.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equalsIgnoreCase(methodName)) continue;
            try {
                result = (Vector)methods[i].invoke((Object)this, (Object[])args);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.input(illegalAccessException.toString());
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.input(illegalArgumentException.toString());
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                this.input(invocationTargetException.toString());
            }
        }
        return result;
    }

    public Vector getEmployeeById(String id) {
        Vector<Employee> result = new Vector<Employee>();
        if (id.equalsIgnoreCase("ALL")) {
            ArrayList employees = this.getEmployees();
            if (employees != null) {
                result = new Vector(employees);
            }
        } else {
            Employee thisEmployee = this.getEmployeeInfo(id);
            result.add(thisEmployee);
            return result;
        }
        return result;
    }

    public Vector getInventoryItemByCode(String filter) {
        Vector result = new Vector();
        if (filter.equalsIgnoreCase("ALL")) {
            try {
                result = new Vector(this.posLocalData.getInventoryCounts(-1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }
        try {
            int code = Integer.parseInt(filter);
            result = new Vector(this.posLocalData.getInventoryCounts(code));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public Vector getInventoryTransactionByDate(String from, String thru, String itemId) {
        Vector result = new Vector();
        if (from == null || from.isEmpty()) {
            return result;
        }
        if (thru == null || thru.isEmpty()) {
            return result;
        }
        Timestamp fromDate = Timestamp.valueOf(from);
        Timestamp thruDate = Timestamp.valueOf(thru);
        try {
            boolean code = false;
            result = new Vector(this.posLocalData.getInventoryTransactionsByDate(fromDate, thruDate, itemId));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return result;
    }

    public POSDataContainer getAdjustmentSessionById(String filter) {
        POSDataContainer result = new POSDataContainer();
        if (filter.equalsIgnoreCase("ALL")) {
            try {
                result = this.posLocalData.getAdjustmentSessionById(-1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }
        try {
            int sessionId = Integer.parseInt(filter);
            result = this.posLocalData.getAdjustmentSessionById(sessionId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public POSDataContainer getReceivingSessionById(String filter) {
        POSDataContainer result = new POSDataContainer();
        if (filter.equalsIgnoreCase("ALL")) {
            try {
                result = this.posLocalData.getReceivingSessionById(-1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }
        try {
            int sessionId = Integer.parseInt(filter);
            result = this.posLocalData.getReceivingSessionById(sessionId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String waitForReply(String tag) {
        String reply = "";
        boolean waiting = true;
        int timeout = 180;
        do {
            if ((reply = this.getHostReply(tag)) != null && !reply.isEmpty()) {
                waiting = false;
                continue;
            }
            if (--timeout <= 0) {
                waiting = false;
                reply = "TIMED_OUT";
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (waiting);
        return reply;
    }

    public Vector getTenderCodeByCode(String code) {
        Vector<TenderCode> result = new Vector<TenderCode>();
        if (code.equalsIgnoreCase("ALL")) {
            return new Vector(this.getTenderCodesList());
        }
        TenderCode thisTenderCode = this.getTenderCode(code);
        result.add(thisTenderCode);
        return result;
    }

    public Vector getTenderCodeByDescription(String code) {
        Vector<TenderCode> result = new Vector<TenderCode>();
        if (code.equalsIgnoreCase("ALL")) {
            return new Vector(this.getTenderCodesList());
        }
        POSDataContainer allCodes = this.getTenderCodesList();
        int len = allCodes.size();
        for (int i = 0; i < len; ++i) {
            TenderCode thisCode = (TenderCode)allCodes.get(i);
            if (!thisCode.description.toUpperCase().contains(code.toUpperCase())) continue;
            result.add(thisCode);
        }
        return result;
    }

    public void getItemPricesWithTax(Item item) {
        if (this.accuServerTaxHandler != null) {
            this.accuServerTaxHandler.calculatePriceWithTax(item);
        }
    }

    public String repeatLineItem(String orderXml, int lineId) {
        LineItem line;
        int i;
        LineItem repeatItem = null;
        Order order = new Order(orderXml, true);
        if (order == null || order.lineItems == null) {
            return orderXml;
        }
        int len = order.lineItems.size();
        int nextLineNumber = len + 1;
        for (i = 0; i < len; ++i) {
            line = (LineItem)order.lineItems.get(i);
            if (line.id != lineId) continue;
            repeatItem = new LineItem(line.toXml());
            repeatItem.id = nextLineNumber++;
            repeatItem.created = new Date().getTime() + (long)nextLineNumber;
            repeatItem.displayOnRemote = true;
            order.lineItems.add(repeatItem);
            break;
        }
        for (i = 0; i < len; ++i) {
            line = (LineItem)order.lineItems.get(i);
            if (line.masterItem <= 0 || line.masterItem != lineId) continue;
            LineItem slaveItem = new LineItem(line.toXml());
            slaveItem.id = nextLineNumber++;
            slaveItem.created = new Date().getTime() + (long)nextLineNumber;
            slaveItem.masterItem = repeatItem.id;
            slaveItem.displayOnRemote = true;
            order.lineItems.add(slaveItem);
        }
        Order repeatOrder = this.calculateTaxes(order.toXml());
        return repeatOrder.toXml();
    }

    public String getEuroCardTypeInfo(String euroCardType) {
        String result = "UNKNOWN";
        if (this.cardHandler != null) {
            result = this.cardHandler.getEuroCardTypeInfo(euroCardType);
        }
        if (result.contains("UNKNOWN") || result.contains("EXPIRED") || result.contains("INVALID") || result.contains("NOT_FOUND")) {
            return result;
        }
        String code = Utility.getElement((String)"Code", (String)result);
        TenderCode tenderCode = this.getTenderCode(code);
        if (tenderCode != null) {
            result = result + tenderCode.toXml();
        }
        return result;
    }

    public String processEuroTender(String user, String userTill, String orderXml, String code, double amount, String ccNumber, String approval, String managerId, long localTime) {
        boolean displayOnRemote = false;
        Order thisOrder = null;
        Tender newTender = null;
        TenderCode tenderCode = null;
        String result = "";
        try {
            thisOrder = new Order(orderXml, true);
            if (thisOrder.user == null || thisOrder.user.length() == 0) {
                thisOrder.user = user;
            }
            if (thisOrder.shift == null || thisOrder.shift.length() == 0) {
                thisOrder.shift = userTill;
            }
            tenderCode = this.getTenderCode(code);
            newTender = new Tender(tenderCode.code, amount);
            newTender.type = tenderCode.tenderType;
            newTender.description = tenderCode.description;
            newTender.user = user;
            newTender.id = 0;
            newTender.newTender = true;
            newTender.till = userTill;
            newTender.isChange = false;
            newTender.code = code;
            Date now = new Date();
            newTender.created = now.getTime();
            if (ccNumber != null && !ccNumber.isEmpty()) {
                newTender.cardNumber = ccNumber;
            }
            if (approval != null && !approval.isEmpty()) {
                newTender.approval = approval;
            }
            if (managerId != null) {
                newTender.managerId = managerId;
            }
            if (thisOrder.tenderings == null) {
                thisOrder.tenderings = new Vector();
            }
            thisOrder.tenderings.add(newTender);
            displayOnRemote = thisOrder.displayOnRemote;
            thisOrder.displayOnRemote = false;
            int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
            if (orderNumber == -1) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
            thisOrder = this.calculateTaxes(this.posLocalData.getOrder(orderNumber, true).toXml(), localTime);
            thisOrder.displayOnRemote = displayOnRemote;
            result = thisOrder.toXml();
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
        return result;
    }

    public String getRoomChargeGuests(String roomNumber) {
        String resultXml = "";
        StringBuilder response = new StringBuilder();
        if (this.cardHandler == null) {
            response.append("<RESULT>Error: Card Handler Not Defined</RESULT>");
        } else {
            resultXml = this.cardHandler.getRoomChargeGuests(roomNumber);
            if (resultXml != null) {
                String result = Utility.getElement((String)"RESULT", (String)resultXml);
                if (result.equalsIgnoreCase("APPROVED")) {
                    response.append("<RESULT>" + result + "</RESULT>");
                    String accountsXml = Utility.getElement((String)"Accounts", (String)resultXml);
                    if (accountsXml != null) {
                        Vector accountsList = Utility.getElementList((String)"Account", (String)accountsXml);
                        int len = accountsList.size();
                        for (int i = 0; i < len; ++i) {
                            RoomChargeGuest guest = new RoomChargeGuest();
                            String thisAccountXml = (String)accountsList.get(i);
                            if (thisAccountXml == null) continue;
                            guest.postingId = Utility.getElement((String)"PostingNumber", (String)thisAccountXml);
                            guest.guestName = Utility.getElement((String)"Name", (String)thisAccountXml);
                            String canCharge = Utility.getElement((String)"ChargeAllowed", (String)thisAccountXml);
                            guest.canCharge = canCharge.equalsIgnoreCase("true");
                            response.append(guest.toXml());
                        }
                    }
                } else {
                    String errorMsg = Utility.getElement((String)"AUTH_CODE", (String)resultXml);
                    if (errorMsg.contains("Problem connecting to the HOST")) {
                        errorMsg = errorMsg.replace("Problem connecting to the HOST", "Unable to connect to room charge processor");
                    }
                    response.append("<RESULT>" + errorMsg + "</RESULT>");
                }
            } else {
                response.append("<RESULT>Error: No Guest Data Found</RESULT>");
            }
        }
        return response.toString();
    }

    public String processRoomCharge(String user, String userTill, String orderXml, String code, double amount, RoomChargeGuest guest, String managerId, String printerName, long localTime) {
        boolean displayOnRemote = false;
        String newTenderResult = "";
        String printData = "";
        if (this.cardHandler == null) {
            return "Error: Card Handler Not Defined";
        }
        Order thisOrder = new Order(orderXml, true);
        try {
            if (thisOrder.user == null || thisOrder.user.length() == 0) {
                thisOrder.user = user;
            }
            if (thisOrder.shift == null || thisOrder.shift.length() == 0) {
                thisOrder.shift = userTill;
            }
            displayOnRemote = thisOrder.displayOnRemote;
            thisOrder.displayOnRemote = false;
            int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
            if (orderNumber == -1) {
                return "NOT_PROCESSED_SERVERERROR";
            }
            thisOrder = this.posLocalData.getOrder(orderNumber, true);
            if (thisOrder == null || thisOrder.orderNumber != orderNumber) {
                return "NOT_PROCESSED_SERVERERROR";
            }
            thisOrder.displayOnRemote = displayOnRemote;
            String result = this.cardHandler.processRoomCharge(guest.postingId, guest.guestName, guest.roomNumber, amount, Integer.toString(thisOrder.orderNumber));
            String approved = Utility.getElement((String)"RESULT", (String)result);
            if (approved.equalsIgnoreCase("APPROVED") || approved.equalsIgnoreCase("PARITIALLY APPROVED")) {
                String approval = Utility.getElement((String)"AUTH_CODE", (String)result);
                String reference = Utility.getElement((String)"TROUTD", (String)result);
                String responseData = Utility.getElement((String)"XML_REQUEST", (String)result);
                Tender newTender = new Tender();
                newTender = new Tender();
                newTender.amount = amount;
                newTender.approval = approval;
                newTender.id = 0;
                newTender.newTender = true;
                newTender.cardNumber = guest.roomNumber;
                newTender.reference = reference;
                newTender.user = user;
                newTender.till = userTill;
                newTender.isChange = false;
                newTender.code = code;
                newTender.responseData = responseData;
                if (managerId != null && !managerId.isEmpty()) {
                    newTender.managerId = managerId;
                }
                TenderCode tenderCode = this.getTenderCode(code);
                newTender.type = tenderCode.tenderType;
                newTender.description = tenderCode.description;
                Date now = new Date();
                long thisTenderCreated = newTender.created = now.getTime();
                if (thisOrder.tenderings == null) {
                    thisOrder.tenderings = new Vector();
                }
                thisOrder.tenderings.add(newTender);
                displayOnRemote = thisOrder.displayOnRemote;
                thisOrder.displayOnRemote = false;
                orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
                OrderPrinter thisPrinter = (OrderPrinter)this.orderPrinters.get(printerName);
                if (thisPrinter != null) {
                    printData = thisPrinter.printOrder(thisOrder, newTender);
                }
                if (orderNumber == -1) {
                    return "NOT_PROCESSED_SERVERERROR";
                }
                thisOrder = this.calculateTaxes(this.posLocalData.getOrder(orderNumber, true).toXml(), localTime);
                int tenderLen = thisOrder.tenderings.size();
                for (int i = 0; i < tenderLen; ++i) {
                    Tender thisTender = (Tender)thisOrder.tenderings.get(i);
                    if (thisTender.created != thisTenderCreated) continue;
                    newTenderResult = "<NewTenderId>" + thisTender.id + "</NewTenderId>";
                }
                thisOrder.displayOnRemote = displayOnRemote;
            } else {
                String authCodeError = Utility.getElement((String)"AUTH_CODE", (String)result);
                if (authCodeError.contains("Problem connecting to the HOST")) {
                    result = result.replace("Problem connecting to the HOST", "Unable to connect to room charge processor");
                }
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
            return null;
        }
        String result = thisOrder.toXml();
        result = result + "<PrintData>" + printData + "</PrintData>";
        result = result + newTenderResult;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMissingValue(String value, String till, int sequence) {
        OutputStreamWriter fileWriter = null;
        try {
            String fileName = System.getProperty("user.dir") + "/Missing" + till + sequence + ".log";
            File file = new File(fileName);
            fileWriter = new FileWriter(file, true);
            fileWriter.write(value + "\r\n");
        }
        catch (IOException ex) {
            this.raiseException(ex);
        }
        finally {
            try {
                fileWriter.close();
            }
            catch (IOException ex) {
                this.raiseException(ex);
            }
        }
    }

    public void deleteMissingValueFile(String till, int sequence) {
        String fileName = System.getProperty("user.dir") + "/Missing" + till + sequence + ".log";
        File file = new File(fileName);
        boolean fileExists = file.exists();
        if (fileExists) {
            file.delete();
        }
    }

    public void setWebServer(WebServerBase webServer) {
        if (this.webServer != null) {
            String webServerReportPath = webServer.getReportPath();
            if (webServerReportPath.indexOf("AccuServerHtmlNew") > -1) {
                this.webServer = webServer;
            }
        } else {
            this.webServer = webServer;
        }
    }

    public WebServerBase getWebServer() {
        return this.webServer;
    }

    public void setWebSocketHost(WebSocketHostBase webSocketHost) {
        this.webSocketHost = webSocketHost;
    }

    public void sendDisplayOrder(String displayName, DisplayOrder order) {
        if (this.webSocketHost != null) {
            this.webSocketHost.sendMessage(displayName, "DisplayOrder", order.toXml(), "OK");
        }
    }

    public void sendAdapterMessage(String integratorMessage) {
        if (this.webSocketHost != null) {
            this.webSocketHost.sendAdapterMessage(integratorMessage);
        }
    }

    public void setTenbisCardHandler(MoneyCardHandlerBase cardHandler) {
        this.tenbisCardHandler = cardHandler;
    }

    public void setCibusCardHandler(MoneyCardHandlerBase cardHandler) {
        this.cibusCardHandler = cardHandler;
    }

    public String processMoneyCard(String cardNumber, double amount, String user, String userTill, String orderXml, String code, int companyCode) {
        String result = "";
        TenderCode tenderCode = this.getTenderCode(code);
        if (tenderCode.tenderType.equalsIgnoreCase("T")) {
            result = this.tenbisCardHandler == null ? "<RESULT>TenbisCardHandler module not defined</RESULT>" : this.processTenbisCard(cardNumber, amount, user, userTill, orderXml, code);
        } else if (tenderCode.tenderType.equalsIgnoreCase("U")) {
            result = this.cibusCardHandler == null ? "<RESULT>CibusCardHandler module not defined</RESULT>" : this.processCibusCard(cardNumber, amount, user, userTill, orderXml, code, companyCode);
        }
        return result;
    }

    public String processMoneyCardVoid(String cardNumber, String reference, double amount, String user, String userTill, String orderXml, String code) {
        String result = "";
        TenderCode tenderCode = this.getTenderCode(code);
        if (tenderCode.tenderType.equalsIgnoreCase("T")) {
            result = this.tenbisCardHandler == null ? "<RESULT>TenbisCardHandler module not defined</RESULT>" : this.processTenbisVoid(cardNumber, reference, amount, user, userTill, orderXml, code);
        } else if (tenderCode.tenderType.equalsIgnoreCase("U")) {
            result = this.cibusCardHandler == null ? "<RESULT>CibusCardHandler module not defined</RESULT>" : this.processCibusVoid(cardNumber, reference, amount, user, userTill, orderXml, code);
        }
        return result;
    }

    public String processMoneyCardBalance(String cardNumber, String code) {
        String result = "";
        TenderCode tenderCode = this.getTenderCode(code);
        if (tenderCode.tenderType.equalsIgnoreCase("T")) {
            if (this.tenbisCardHandler == null) {
                return "<RESULT>TenbisCardHandler module not defined</RESULT>";
            }
            result = this.tenbisCardHandler.processMoneyCardBalance(cardNumber);
        } else if (tenderCode.tenderType.equalsIgnoreCase("U")) {
            if (this.cibusCardHandler == null) {
                return "<RESULT>CiBusCardHandler module not defined</RESULT>";
            }
            result = this.cibusCardHandler.processMoneyCardBalance(cardNumber);
        }
        return result;
    }

    private String processTenbisCard(String cardNumber, double amount, String user, String userTill, String orderXml, String code) {
        Tender newTender = null;
        TenderCode tenderCode = null;
        String result = "DECLINED";
        boolean displayOnRemote = false;
        Order thisOrder = new Order(orderXml, true);
        try {
            if (thisOrder.user == null || thisOrder.user.length() == 0) {
                thisOrder.user = user;
            }
            if (thisOrder.shift == null || thisOrder.shift.length() == 0) {
                thisOrder.shift = userTill;
            }
            displayOnRemote = thisOrder.displayOnRemote;
            thisOrder.displayOnRemote = false;
            int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
            if (orderNumber == -1) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
            thisOrder = this.posLocalData.getOrder(orderNumber, true);
            if (thisOrder.created == null) {
                thisOrder.created = new Timestamp(Utility.getLongElement((String)"Created", (String)orderXml));
            }
            thisOrder.displayOnRemote = displayOnRemote;
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        String responseData = "";
        responseData = amount < -1.0E-4 ? this.tenbisCardHandler.processMoneyCardVoid(cardNumber, amount * -1.0) : this.tenbisCardHandler.processMoneyCard(cardNumber, amount, 0);
        String approved = Utility.getElement((String)"RESULT", (String)responseData);
        if (approved.equalsIgnoreCase("APPROVED")) {
            String cardData = Utility.getElement((String)"DATA", (String)responseData);
            String cardHolder = Utility.getElement((String)"CardOwnerName", (String)cardData);
            String reference = Utility.getElement((String)"TransID", (String)cardData);
            newTender = new Tender();
            newTender.amount = amount;
            newTender.approval = approved;
            newTender.cardHolder = cardHolder;
            newTender.id = 0;
            newTender.newTender = true;
            newTender.reference = reference;
            newTender.user = user;
            newTender.till = userTill;
            newTender.isChange = false;
            newTender.code = code;
            newTender.responseData = responseData = responseData + "<MoneyCardNumber>" + cardNumber + "</MoneyCardNumber>";
            tenderCode = this.getTenderCode(code);
            newTender.type = tenderCode.tenderType;
            newTender.description = tenderCode.description;
            Date now = new Date();
            newTender.created = now.getTime();
            if (thisOrder.tenderings == null) {
                thisOrder.tenderings = new Vector();
            }
            thisOrder.tenderings.add(newTender);
            try {
                displayOnRemote = thisOrder.displayOnRemote;
                thisOrder.displayOnRemote = false;
                int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
                thisOrder = this.calculateTaxes(this.posLocalData.getOrder(orderNumber, true).toXml());
                thisOrder.displayOnRemote = displayOnRemote;
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        } else {
            result = result + "<RESULT>" + approved + "</RESULT>";
        }
        result = result + thisOrder.toXml();
        return result;
    }

    private String processTenbisVoid(String cardNumber, String reference, double amount, String user, String userTill, String orderXml, String code) {
        Tender newTender = null;
        TenderCode tenderCode = null;
        String result = "DECLINED";
        Order thisOrder = new Order(orderXml, true);
        try {
            int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
            if (orderNumber == -1) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
            thisOrder = this.posLocalData.getOrder(orderNumber, true);
            if (thisOrder.created == null) {
                thisOrder.created = new Timestamp(Utility.getLongElement((String)"Created", (String)orderXml));
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        if (thisOrder != null && thisOrder.tenderings != null) {
            int len = thisOrder.tenderings.size();
            for (int i = 0; i < len; ++i) {
                Tender tender = (Tender)thisOrder.tenderings.get(i);
                if (tender == null || !tender.reference.equalsIgnoreCase(reference)) continue;
                cardNumber = Utility.getElement((String)"MoneyCardNumber", (String)tender.responseData);
                break;
            }
        }
        if (!cardNumber.trim().isEmpty()) {
            String responseData = this.tenbisCardHandler.processMoneyCardVoid(cardNumber, amount);
            String approved = Utility.getElement((String)"RESULT", (String)responseData);
            if (approved.equalsIgnoreCase("APPROVED")) {
                String cardData = Utility.getElement((String)"DATA", (String)responseData);
                String cardHolder = Utility.getElement((String)"CardOwnerName", (String)cardData);
                String newReference = Utility.getElement((String)"TransID", (String)cardData);
                newTender = new Tender();
                newTender.amount = amount * -1.0;
                newTender.approval = approved;
                newTender.cardHolder = cardHolder;
                newTender.id = 0;
                newTender.newTender = true;
                newTender.reference = newReference;
                newTender.user = user;
                newTender.till = userTill;
                newTender.isChange = false;
                newTender.code = code;
                newTender.responseData = responseData = responseData + "<MoneyCardNumber>" + cardNumber + "</MoneyCardNumber>";
                tenderCode = this.getTenderCode(code);
                newTender.type = tenderCode.tenderType;
                newTender.description = tenderCode.description;
                newTender.status = "V";
                Date now = new Date();
                newTender.created = now.getTime();
                if (thisOrder.tenderings == null) {
                    thisOrder.tenderings = new Vector();
                }
                thisOrder.tenderings.add(newTender);
                try {
                    int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
                    thisOrder = this.posLocalData.getOrder(orderNumber, true);
                }
                catch (Exception exception) {
                    this.handleException(exception);
                }
            } else {
                result = result + "<RESULT>" + approved + "</RESULT>";
            }
        } else {
            result = result + "<RESULT>INVALID CARD NUMBER</RESULT>";
        }
        result = result + thisOrder.toXml();
        return result;
    }

    public String processPreAuthCardTender(String user, String userTill, String orderXml, double amount, String managerId, String printerName, Long localTime) {
        String preAuthRecordNumber;
        boolean displayOnRemote = false;
        Order thisOrder = null;
        Tender newTender = null;
        OrderPrinter thisPrinter = null;
        TenderCode tenderCode = null;
        long thisTenderCreated = 0L;
        String newTenderResult = "";
        String printData = "";
        String result = "DECLINED";
        if (this.cardHandler == null) {
            return result;
        }
        thisOrder = new Order(orderXml, true);
        if (thisOrder.user == null || thisOrder.user.length() == 0) {
            thisOrder.user = user;
        }
        if (thisOrder.shift == null || thisOrder.shift.length() == 0) {
            thisOrder.shift = userTill;
        }
        if (!(preAuthRecordNumber = thisOrder.preAuthRecordNumber).contains("TriPOSEMV")) {
            result = this.cardHandler.processPreAuthCapture(amount, preAuthRecordNumber, thisOrder.preAuthId, thisOrder.preAuthApproval, Integer.toString(thisOrder.orderNumber), user);
            String approved = Utility.getElement((String)"RESULT", (String)result);
            if (approved == null || approved.isEmpty()) {
                newTender = new Tender();
                newTender.approval = thisOrder.preAuthApproval;
                newTender.reference = thisOrder.preAuthId;
            } else if (approved.equalsIgnoreCase("APPROVED")) {
                String newApproval = Utility.getElement((String)"AUTH_CODE", (String)result);
                String newReference = Utility.getElement((String)"TROUTD", (String)result);
                String newRecordNumber = Utility.getElement((String)"RecordNo", (String)result);
                newTender = new Tender();
                newTender.approval = newApproval;
                newTender.reference = newReference;
                preAuthRecordNumber = newRecordNumber;
            } else {
                String authCodeError = Utility.getElement((String)"AUTH_CODE", (String)result);
                if (authCodeError.contains("Problem connecting to the HOST")) {
                    result = result.replace("Problem connecting to the HOST", "Unable to connect to credit card processor");
                }
            }
        } else {
            newTender = new Tender();
            newTender.approval = thisOrder.preAuthApproval;
            newTender.reference = thisOrder.preAuthId;
            newTender.origin = "TriPOSEMV";
        }
        if (newTender != null) {
            newTender.amount = amount;
            newTender.id = 0;
            newTender.newTender = true;
            newTender.user = user;
            newTender.till = userTill;
            newTender.isChange = false;
            newTender.cardHolder = thisOrder.preAuthHolder;
            newTender.cardNumber = thisOrder.preAuthNumber;
            if (preAuthRecordNumber.contains("TriPOSEMV")) {
                String newCardNo;
                newTender.cardNumber = newCardNo = "000000000000" + newTender.cardNumber.substring(newTender.cardNumber.length() - 4, newTender.cardNumber.length());
            }
            newTender.cardExpiry = thisOrder.preAuthExp;
            if (managerId != null && !managerId.isEmpty()) {
                newTender.managerId = managerId;
            }
            newTender.code = thisOrder.preAuthCode;
            tenderCode = this.getTenderCode(thisOrder.preAuthCode);
            if (tenderCode != null) {
                newTender.type = tenderCode.tenderType;
                newTender.description = tenderCode.description;
            }
            Date now = new Date();
            thisTenderCreated = newTender.created = now.getTime();
            if (thisOrder.tenderings == null) {
                thisOrder.tenderings = new Vector();
            }
            thisOrder.tenderings.add(newTender);
            try {
                displayOnRemote = thisOrder.displayOnRemote;
                thisOrder.displayOnRemote = false;
                int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
                thisPrinter = (OrderPrinter)this.orderPrinters.get(printerName);
                if (thisPrinter != null) {
                    printData = thisPrinter.printOrder(thisOrder, newTender);
                }
                thisOrder = this.calculateTaxes(this.posLocalData.getOrder(orderNumber, true).toXml(), localTime);
                int tenderLen = thisOrder.tenderings.size();
                for (int i = 0; i < tenderLen; ++i) {
                    Tender thisTender = (Tender)thisOrder.tenderings.get(i);
                    if (thisTender.created != thisTenderCreated) continue;
                    thisTender.responseData = "<RecordNo>" + preAuthRecordNumber + "</RecordNo>";
                    thisTender.responseData = thisTender.responseData + "<PrintData>" + printData + "</PrintData>";
                    newTenderResult = "<NewTenderId>" + thisTender.id + "</NewTenderId>";
                }
                thisOrder.displayOnRemote = displayOnRemote;
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        }
        result = result + thisOrder.toXml() + newTenderResult;
        return result;
    }

    public POSDataContainer getAllFlexGroups() {
        POSDataContainer flexGroupList = null;
        try {
            flexGroupList = this.posLocalData.getAllFlexGroups();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return flexGroupList;
    }

    public Hashtable getFlexGroups() {
        return this.flexGroups;
    }

    public POSDataContainer getAllFlexGroupDetail() {
        POSDataContainer flexGroupDetailList = null;
        try {
            flexGroupDetailList = this.posLocalData.getAllFlexGroupDetail();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return flexGroupDetailList;
    }

    public Hashtable getFlexGroupDetail() {
        return this.flexGroupDetail;
    }

    public POSDataContainer getFlexGroupDetail(String itemCode) {
        POSDataContainer flexGroupDetailList = null;
        try {
            flexGroupDetailList = this.posLocalData.getFlexGroupDetail(itemCode);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return flexGroupDetailList;
    }

    public boolean isMenuKeyItem(String itemCode) {
        boolean result = false;
        try {
            result = this.posLocalData.isMenuKeyItem(itemCode);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return result;
    }

    private String processCibusCard(String cardNumber, double amount, String user, String userTill, String orderXml, String code, int companyCode) {
        Tender newTender = null;
        TenderCode tenderCode = null;
        String result = "";
        boolean displayOnRemote = false;
        Order thisOrder = new Order(orderXml, true);
        try {
            if (thisOrder.user == null || thisOrder.user.length() == 0) {
                thisOrder.user = user;
            }
            if (thisOrder.shift == null || thisOrder.shift.length() == 0) {
                thisOrder.shift = userTill;
            }
            displayOnRemote = thisOrder.displayOnRemote;
            thisOrder.displayOnRemote = false;
            int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
            if (orderNumber == -1) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
            thisOrder = this.posLocalData.getOrder(orderNumber, true);
            if (thisOrder.created == null) {
                thisOrder.created = new Timestamp(Utility.getLongElement((String)"Created", (String)orderXml));
            }
            thisOrder.displayOnRemote = displayOnRemote;
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        String responseData = "";
        responseData = amount < -1.0E-4 ? this.cibusCardHandler.processMoneyCardVoid(cardNumber, amount * -1.0) : this.cibusCardHandler.processMoneyCard(cardNumber, amount, companyCode);
        String approved = Utility.getElement((String)"RESULT", (String)responseData);
        if (approved.equalsIgnoreCase("APPROVED")) {
            String reference = Utility.getElement((String)"TROUTD", (String)responseData);
            result = "<RESULT>" + approved + "</RESULT>";
            newTender = new Tender();
            newTender.amount = amount;
            newTender.approval = approved;
            newTender.cardHolder = "";
            newTender.id = 0;
            newTender.newTender = true;
            newTender.reference = reference;
            newTender.user = user;
            newTender.till = userTill;
            newTender.isChange = false;
            newTender.code = code;
            newTender.responseData = responseData = responseData + "<MoneyCardNumber>" + cardNumber + "</MoneyCardNumber>";
            tenderCode = this.getTenderCode(code);
            newTender.type = tenderCode.tenderType;
            newTender.description = tenderCode.description;
            Date now = new Date();
            newTender.created = now.getTime();
            if (thisOrder.tenderings == null) {
                thisOrder.tenderings = new Vector();
            }
            thisOrder.tenderings.add(newTender);
            try {
                displayOnRemote = thisOrder.displayOnRemote;
                thisOrder.displayOnRemote = false;
                int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
                thisOrder = this.calculateTaxes(this.posLocalData.getOrder(orderNumber, true).toXml());
                thisOrder.displayOnRemote = displayOnRemote;
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        } else {
            result = result + "<RESULT>" + approved + "</RESULT>";
        }
        result = result + thisOrder.toXml();
        return result;
    }

    private String processCibusVoid(String cardNumber, String reference, double amount, String user, String userTill, String orderXml, String code) {
        Tender newTender = null;
        TenderCode tenderCode = null;
        String result = "DECLINED";
        Order thisOrder = new Order(orderXml, true);
        try {
            int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
            if (orderNumber == -1) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
            thisOrder = this.posLocalData.getOrder(orderNumber, true);
            if (thisOrder.created == null) {
                thisOrder.created = new Timestamp(Utility.getLongElement((String)"Created", (String)orderXml));
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        String responseData = this.cibusCardHandler.processMoneyCardVoid(reference);
        String approved = Utility.getElement((String)"RESULT", (String)responseData);
        if (approved.equalsIgnoreCase("APPROVED")) {
            String newReference = Utility.getElement((String)"TROUTD", (String)responseData);
            newTender = new Tender();
            newTender.amount = amount * -1.0;
            newTender.approval = approved;
            newTender.cardHolder = "";
            newTender.id = 0;
            newTender.newTender = true;
            newTender.reference = newReference;
            newTender.user = user;
            newTender.till = userTill;
            newTender.isChange = false;
            newTender.code = code;
            newTender.responseData = responseData = responseData + "<MoneyCardNumber>" + cardNumber + "</MoneyCardNumber>";
            tenderCode = this.getTenderCode(code);
            newTender.type = tenderCode.tenderType;
            newTender.description = tenderCode.description;
            newTender.status = "V";
            Date now = new Date();
            newTender.created = now.getTime();
            if (thisOrder.tenderings == null) {
                thisOrder.tenderings = new Vector();
            }
            thisOrder.tenderings.add(newTender);
            try {
                int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
                thisOrder = this.posLocalData.getOrder(orderNumber, true);
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        } else {
            result = result + "<RESULT>" + approved + "</RESULT>";
        }
        result = result + thisOrder.toXml();
        return result;
    }

    private void updateChoiceKeyCache(int updatedId, int pageNumber, String choiceGroup, Choice choiceKey) {
        ChoiceGroup thisGroup = null;
        if (this.choicesList != null) {
            boolean groupFound = false;
            int len = this.choicesList.size();
            for (int i = 0; i < len; ++i) {
                thisGroup = (ChoiceGroup)this.choicesList.get(i);
                if (!thisGroup.name.equals(choiceGroup)) continue;
                groupFound = true;
                break;
            }
            if (!groupFound) {
                thisGroup = new ChoiceGroup();
                thisGroup.name = choiceGroup;
                this.choicesList.add((Object)thisGroup);
            }
            if (choiceKey.id != 0) {
                boolean updateComplete = false;
                ChoicesPage thisPage = thisGroup.pages[pageNumber - 1];
                if (thisPage != null) {
                    int choicesLen = thisPage.choices.size();
                    for (int j = 0; j < choicesLen; ++j) {
                        Choice thisChoice = (Choice)thisPage.choices.get(j);
                        if (thisChoice.id != updatedId) continue;
                        thisPage.choices.remove(j);
                        thisPage.choices.add(j, choiceKey);
                        updateComplete = true;
                        break;
                    }
                    if (!updateComplete) {
                        thisPage.choices.add(choicesLen, choiceKey);
                        thisGroup.pages[pageNumber - 1] = thisPage;
                    }
                } else {
                    ChoicesPage newPage = new ChoicesPage();
                    newPage.choices.add(choiceKey);
                    thisGroup.pages[pageNumber - 1] = newPage;
                }
            } else {
                ChoicesPage thisPage = thisGroup.pages[pageNumber - 1];
                choiceKey.id = updatedId;
                if (thisPage == null) {
                    thisPage = new ChoicesPage();
                    thisPage.choices.add(choiceKey);
                    thisGroup.pages[pageNumber - 1] = thisPage;
                } else {
                    thisPage.choices.add(choiceKey);
                }
            }
        }
    }

    private void deleteChoiceKeyFromCache(int id) {
        if (this.choicesList != null) {
            int len = this.choicesList.size();
            for (int i = 0; i < len; ++i) {
                ChoiceGroup thisGroup = (ChoiceGroup)this.choicesList.get(i);
                for (int j = 0; j < thisGroup.pages.length; ++j) {
                    ChoicesPage thisPage = thisGroup.pages[j];
                    if (thisPage == null) continue;
                    int keyLen = thisPage.choices.size();
                    for (int k = 0; k < keyLen; ++k) {
                        Choice thisKey = (Choice)thisPage.choices.get(k);
                        if (thisKey.id != id) continue;
                        thisPage.choices.remove(k);
                        return;
                    }
                }
            }
        }
    }

    private void deleteChoicePageFromCache(int pageNumber, String choiceGroup) {
        if (this.choicesList != null) {
            int len = this.choicesList.size();
            for (int i = len - 1; i >= 0; --i) {
                ChoiceGroup thisGroup = (ChoiceGroup)this.choicesList.get(i);
                if (!thisGroup.name.equals(choiceGroup)) continue;
                ChoicesPage thisPage = thisGroup.pages[pageNumber - 1];
                if (thisPage != null) {
                    thisPage.choices.removeAllElements();
                }
                boolean groupHasOtherPages = false;
                for (int j = 0; j < thisGroup.pages.length; ++j) {
                    thisPage = thisGroup.pages[j];
                    if (thisPage == null || thisPage.choices.size() <= 0) continue;
                    groupHasOtherPages = true;
                    break;
                }
                if (groupHasOtherPages) break;
                this.choicesList.remove((Object)thisGroup);
                break;
            }
        }
    }

    public long getChoicesCacheSyncTime() {
        return this.choicesCacheSyncTime;
    }

    public void updateAppetizerItemTypes(POSDataContainer appetizerTypes) {
        try {
            this.posLocalData.updateAppetizerItemTypes(appetizerTypes);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public Vector getImageFileNames() {
        File[] files = null;
        Vector<String> fileNames = new Vector<String>();
        File imagesDirectory = null;
        try {
            imagesDirectory = new File(System.getProperty("user.dir") + "/images/ads/");
            if (!imagesDirectory.exists()) {
                return fileNames;
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        if (imagesDirectory == null) {
            return fileNames;
        }
        files = imagesDirectory.listFiles();
        if (files != null && files.length > 0) {
            for (File thisFile : files) {
                String fileName = thisFile.getName();
                if (!fileName.contains(".png")) continue;
                fileNames.add(fileName.trim());
            }
        }
        return fileNames;
    }

    public boolean updateFlexGroup(FlexGroup thisFlexGroup) {
        boolean result = false;
        try {
            result = this.posLocalData.updateFlexGroup(thisFlexGroup);
            this.loadFlexGroups();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return result;
    }

    public boolean updateFlexGroupDetail(FlexGroupDetail thisFlexDetail) {
        boolean result = false;
        try {
            result = this.posLocalData.updateFlexGroupDetail(thisFlexDetail);
            this.loadFlexGroupDetail();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return result;
    }

    public void deleteFlexGroup(String masterItemId) {
        try {
            this.posLocalData.deleteFlexGroup(masterItemId);
            this.loadFlexGroups();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public void deleteFlexGroupDetail(FlexGroupDetail thisFlexDetail) {
        try {
            this.posLocalData.deleteFlexGroupDetail(thisFlexDetail);
            this.loadFlexGroupDetail();
            this.loadFlexGroups();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public POSDataContainer getSalesAccounts() {
        POSDataContainer salesAccounts = null;
        try {
            salesAccounts = this.posLocalData.getSalesAccounts();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return salesAccounts;
    }

    public boolean tenderHasOrders(String tenderCode) {
        boolean result = false;
        try {
            result = this.posLocalData.tenderHasOrders(tenderCode);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return result;
    }

    public POSDataContainer getItemCategories() {
        POSDataContainer categories = null;
        try {
            categories = this.posLocalData.getItemCategories();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return categories;
    }

    public void setVatTable(POSDataContainer vatRecords) {
        this.vatTable = new Hashtable();
        if (vatRecords != null) {
            int vatLen = vatRecords.size();
            for (int i = 0; i < vatLen; ++i) {
                ValueAddedTax thisVat = (ValueAddedTax)vatRecords.get(i);
                this.vatTable.put(thisVat.code, thisVat);
            }
        }
    }

    public Hashtable getVatTable() {
        if (this.vatTable == null) {
            try {
                POSDataContainer vatRecords = this.posLocalData.getVatRecords();
                this.setVatTable(vatRecords);
            }
            catch (Exception ex) {
                this.raiseException(ex);
            }
        }
        return this.vatTable;
    }

    public POSDataContainer getRemoteDisplays() {
        POSDataContainer displayList = null;
        try {
            displayList = this.posLocalData.getRemoteDisplays();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return displayList;
    }

    public double getAutoGratuityTax(Order order) {
        double autoGratuityTax = 0.0;
        if (this.accuServerTaxHandler != null && order != null) {
            Hashtable vatTable = this.getVatTable();
            autoGratuityTax = this.accuServerTaxHandler.getAutoGratuityTax(order, vatTable);
        }
        return autoGratuityTax;
    }

    public String getCloudInfo() {
        String cloudInfo = "";
        if (this.licenseHandler != null) {
            cloudInfo = this.licenseHandler.getCloudInfo();
        }
        return cloudInfo;
    }

    public String getComoInfo() {
        String comoInfo = "";
        if (this.licenseHandler != null) {
            comoInfo = this.licenseHandler.getComoInfo();
        }
        return comoInfo;
    }

    public String getFTPInfo() {
        String ftpInfo = "";
        if (this.licenseHandler != null) {
            ftpInfo = this.licenseHandler.getFTPInfo();
        }
        return ftpInfo;
    }

    public String getDeviceId() {
        String deviceId = "";
        if (this.licenseHandler != null) {
            deviceId = this.licenseHandler.getDeviceId();
        }
        return deviceId;
    }

    public String getSiteTaxCode() {
        String taxCode = "";
        try {
            taxCode = this.posLocalData.getSiteTaxCode();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return taxCode;
    }

    public POSDataContainer getSyncOrders(Timestamp syncStartDate) {
        POSDataContainer orders = null;
        try {
            orders = this.posLocalData.getSyncOrders(syncStartDate);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return orders;
    }

    public void updateOrderCloudTimeStamp(int orderNumber, Timestamp lastUpdateTimeStamp) {
        Order checkReopenOrder = this.getOrder(orderNumber, true);
        if (checkReopenOrder.receiptNumber == 0) {
            return;
        }
        try {
            this.posLocalData.updateOrderCloudTimeStamp(orderNumber, lastUpdateTimeStamp);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public boolean hasCloudDataAccess() {
        return this.cloudDataAccess != null;
    }

    public POSDataContainer getAllLocations() {
        POSDataContainer locations = null;
        try {
            if (this.cloudDataAccess != null) {
                locations = this.cloudDataAccess.getAllLocations();
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return locations;
    }

    public Hashtable getCompReasonsTable() {
        Hashtable compReasons = this.posLocalData.getCompReasonsTable();
        return compReasons;
    }

    public Hashtable getTenderDescriptionsTable() {
        Hashtable tenderDescriptions = this.posLocalData.getTenderDescriptionsTable();
        return tenderDescriptions;
    }

    public Hashtable getTenderTypesTable() {
        Hashtable tenderTypes = this.posLocalData.getTenderTypesTable();
        return tenderTypes;
    }

    public POSDataContainer getCloudTransactionData(String selectedLocations, TransactionReportOptions reportOptions) {
        POSDataContainer transactions = null;
        try {
            if (this.cloudDataAccess != null) {
                transactions = this.cloudDataAccess.getCloudTransactionData(selectedLocations, reportOptions);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return transactions;
    }

    public POSDataContainer getCloudItemTypeSummaryData(String selectedLocations, TransactionReportOptions reportOptions) {
        POSDataContainer summary = null;
        try {
            if (this.cloudDataAccess != null) {
                summary = this.cloudDataAccess.getCloudItemTypeSummaryData(selectedLocations, reportOptions);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return summary;
    }

    public boolean getRemoveFoodService() {
        return this.removeFoodService;
    }

    public void saveItemsBlock(POSDataContainer list, boolean updateItems, boolean refreshCache) {
        if (this.posLocalData != null) {
            this.posLocalData.saveItemsBlock(list, updateItems, refreshCache);
        }
        if (updateItems) {
            this.updateMenuKeyCacheForItemList(list);
        }
    }

    public POSDataContainer getScheduledSyncCommands() {
        POSDataContainer syncCommands = null;
        try {
            if (this.posLocalData != null) {
                syncCommands = this.posLocalData.getScheduledSyncCommands();
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return syncCommands;
    }

    public POSDataContainer getCompletedSyncHistory(String locationName, String syncType) {
        POSDataContainer syncHistory = null;
        try {
            if (this.posLocalData != null) {
                syncHistory = this.posLocalData.getCompletedSyncHistory(locationName, syncType);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return syncHistory;
    }

    public POSDataContainer getMenuKeysSync(Timestamp lastSync) {
        POSDataContainer keys = null;
        try {
            keys = this.posLocalData.getMenuKeysSync(lastSync);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return keys;
    }

    public POSDataContainer getChoicesSync(Timestamp lastSync) {
        POSDataContainer choices = null;
        try {
            choices = this.posLocalData.getChoicesSync(lastSync);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return choices;
    }

    public String updateMenuKeysSync(String keysXml, String choicesXml, String itemsXml) {
        boolean good;
        String result = "OK";
        if (keysXml != null && !keysXml.isEmpty() && !(good = this.saveAllMenuKeys(keysXml))) {
            result = "Menu Keys Sync Error";
            return result;
        }
        if (choicesXml != null && !choicesXml.isEmpty()) {
            int numGroups = 0;
            Vector choiceGroups = Utility.getElementList((String)"ChoiceGroup", (String)choicesXml);
            if (choiceGroups != null && choiceGroups.size() > 0) {
                numGroups = choiceGroups.size();
                for (int g = 0; g < numGroups; ++g) {
                    String thisGroupXml = (String)choiceGroups.get(g);
                    ChoiceGroup thisGroup = new ChoiceGroup(thisGroupXml);
                    if (thisGroup == null || thisGroup.pages == null) continue;
                    int numPages = thisGroup.pages.length;
                    for (int p = 0; p < numPages; ++p) {
                        ChoicesPage thisPage = thisGroup.pages[p];
                        int page = p + 1;
                        if (thisPage == null || thisPage.choices.size() <= 0) continue;
                        int numChoices = thisPage.choices.size();
                        for (int c = 0; c < numChoices; ++c) {
                            int choiceKey = 0;
                            Choice thisChoice = (Choice)thisPage.choices.get(c);
                            if (thisChoice != null) {
                                choiceKey = this.updateChoiceKey(page, thisGroup.name, thisChoice);
                            }
                            if (choiceKey > 0) continue;
                            result = "Choice Key Sync Error";
                            return result;
                        }
                    }
                }
            }
        }
        if (itemsXml != null && !itemsXml.isEmpty()) {
            POSDataContainer items = new POSDataContainer();
            Vector itemsList = Utility.getElementList((String)"Item", (String)itemsXml);
            if (itemsList != null && !itemsList.isEmpty()) {
                int len = itemsList.size();
                for (int i = 0; i < len; ++i) {
                    String thisItemXml = (String)itemsList.get(i);
                    Item item = new Item(thisItemXml);
                    items.add((Object)item);
                }
                try {
                    this.saveAllItems(items, true);
                }
                catch (Exception ex) {
                    result = "Item Sync Error";
                    this.raiseException(ex);
                }
                if (result.compareTo("OK") != 0) {
                    return result;
                }
            }
        }
        return result;
    }

    public String updateItemsSync(String itemsXml, String followOnsXml, String uomXml, String itemGroupsXml, String salePricesXml, String flexGroupsXml, String flexGroupDetailXml, String noPartialQuantityXml) {
        int i;
        String result = "OK";
        if (itemsXml != null && !itemsXml.isEmpty()) {
            POSDataContainer items = new POSDataContainer();
            Vector itemsList = Utility.getElementList((String)"Item", (String)itemsXml);
            if (itemsList != null && !itemsList.isEmpty()) {
                int len = itemsList.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    String thisItemXml = (String)itemsList.get(i2);
                    Item item = new Item(thisItemXml);
                    items.add((Object)item);
                }
                try {
                    this.saveAllItems(items, true);
                }
                catch (Exception ex) {
                    result = "Item Sync Error";
                    this.raiseException(ex);
                }
                if (result.compareTo("OK") != 0) {
                    return result;
                }
            }
        }
        if (followOnsXml != null && !followOnsXml.isEmpty()) {
            Vector followOnsList = Utility.getElementList((String)"FollowOn", (String)followOnsXml);
            int numFollowOns = followOnsList.size();
            for (i = 0; i < numFollowOns; ++i) {
                String thisFollowOnXml = (String)followOnsList.get(i);
                FollowOn thisFollowOn = new FollowOn(thisFollowOnXml);
                String status = this.saveFollowOns(thisFollowOn);
                if (status.compareTo("OK") == 0) continue;
                result = "FollowOn Sync Error";
                return result;
            }
        }
        if (uomXml != null && !uomXml.isEmpty()) {
            Vector uomList = Utility.getElementList((String)"UOM", (String)uomXml);
            int numUOMs = uomList.size();
            for (i = 0; i < numUOMs; ++i) {
                String thisUOMXml = (String)uomList.get(i);
                UnitOfMeasure thisUOM = new UnitOfMeasure(thisUOMXml);
                boolean good = this.updateUnitOfMeasure(thisUOM);
                if (good) continue;
                result = "UOM Sync Error";
                return result;
            }
        }
        if (itemGroupsXml != null && !itemGroupsXml.isEmpty()) {
            String status;
            Vector itemGroupList = Utility.getElementList((String)"ItemGroup", (String)uomXml);
            int numItemGroups = itemGroupList.size();
            POSDataContainer masterGroups = new POSDataContainer();
            String lastItemCode = "";
            for (int i3 = 0; i3 < numItemGroups; ++i3) {
                String thisItemGroupXml = (String)itemGroupList.get(i3);
                ItemGroup thisItemGroup = new ItemGroup(thisItemGroupXml);
                if (lastItemCode.isEmpty()) {
                    lastItemCode = thisItemGroup.masterItem;
                    masterGroups.add((Object)thisItemGroup);
                    continue;
                }
                if (thisItemGroup.masterItem.compareTo(lastItemCode) != 0) {
                    this.updateItemGroup(thisItemGroup.masterItem, masterGroups);
                    masterGroups = new POSDataContainer();
                    lastItemCode = thisItemGroup.masterItem;
                    masterGroups.add((Object)thisItemGroup);
                    continue;
                }
                masterGroups.add((Object)thisItemGroup);
            }
            if (masterGroups != null && masterGroups.size() > 0 && (status = this.updateItemGroup(lastItemCode, masterGroups)).compareTo("OK") != 0) {
                result = "Item Group Sync Error";
                return result;
            }
        }
        if (salePricesXml != null && !salePricesXml.isEmpty()) {
            Vector salePricesList = Utility.getElementList((String)"SalePrice", (String)salePricesXml);
            int numSalePrices = salePricesList.size();
            for (int i4 = 0; i4 < numSalePrices; ++i4) {
                boolean good = true;
                String thisSalePriceXml = (String)salePricesList.get(i4);
                SalePrice thisSalePrice = new SalePrice(thisSalePriceXml);
                try {
                    good = this.posLocalData.updateSalePrice(thisSalePrice);
                }
                catch (Exception ex) {
                    this.raiseException(ex);
                }
                if (good) continue;
                result = "Sale Price Sync Error";
                return result;
            }
        }
        if (flexGroupsXml != null && !flexGroupsXml.isEmpty()) {
            Vector flexGroupsList = Utility.getElementList((String)"FlexGroup", (String)flexGroupsXml);
            int numFlexGroups = flexGroupsList.size();
            for (int i5 = 0; i5 < numFlexGroups; ++i5) {
                boolean good = false;
                String thisFlexGroupXml = (String)flexGroupsList.get(i5);
                FlexGroup thisFlexGroup = new FlexGroup(thisFlexGroupXml);
                try {
                    good = this.updateFlexGroup(thisFlexGroup);
                }
                catch (Exception ex) {
                    this.raiseException(ex);
                }
                if (good) continue;
                result = "Flex Group Sync Error";
                return result;
            }
        }
        if (flexGroupDetailXml != null && !flexGroupDetailXml.isEmpty()) {
            Vector flexGroupDetailList = Utility.getElementList((String)"FlexGroupDetail", (String)flexGroupDetailXml);
            int numFlexGroupDetail = flexGroupDetailList.size();
            for (int i6 = 0; i6 < numFlexGroupDetail; ++i6) {
                boolean good = false;
                String thisFlexGroupDetailXml = (String)flexGroupDetailList.get(i6);
                FlexGroupDetail thisFlexGroupDetail = new FlexGroupDetail(thisFlexGroupDetailXml);
                try {
                    good = this.updateFlexGroupDetail(thisFlexGroupDetail);
                }
                catch (Exception ex) {
                    this.raiseException(ex);
                }
                if (good) continue;
                result = "Flex Group Detail Sync Error";
                return result;
            }
        }
        if (noPartialQuantityXml != null && !noPartialQuantityXml.isEmpty()) {
            boolean good = false;
            POSDataContainer noPartialQuantities = new POSDataContainer();
            Vector noPartialQuantityList = Utility.getElementList((String)"NoPartialQuantity", (String)noPartialQuantityXml);
            int numNoPartialQuantity = noPartialQuantityList.size();
            for (int i7 = 0; i7 < numNoPartialQuantity; ++i7) {
                String thisNoPartialQuantitXml = (String)noPartialQuantityList.get(i7);
                NoPartialQuantity thisNoPartialQuantity = new NoPartialQuantity(thisNoPartialQuantitXml);
                noPartialQuantities.add((Object)thisNoPartialQuantity);
            }
            if (noPartialQuantities != null && noPartialQuantities.size() > 0) {
                good = this.saveNoPartialQuantityItems(noPartialQuantities);
            }
            if (!good) {
                result = "No Partial Qty Sync Error";
                return result;
            }
        }
        return result;
    }

    public String updatePriceLevelsSync(String priceLevelsXml) {
        String result = "OK";
        POSDataContainer priceLevelTimes = new POSDataContainer();
        if (priceLevelsXml != null && !priceLevelsXml.isEmpty()) {
            Vector priceLevelsList = Utility.getElementList((String)"PriceLevelTime", (String)priceLevelsXml);
            int numPriceLevels = priceLevelsList.size();
            for (int i = 0; i < numPriceLevels; ++i) {
                String thisPriceLevelTimeXml = (String)priceLevelsList.get(i);
                PriceLevelTime thisPriceLevelTime = new PriceLevelTime(thisPriceLevelTimeXml);
                priceLevelTimes.add((Object)thisPriceLevelTime);
            }
            boolean good = false;
            if (priceLevelTimes != null && priceLevelTimes.size() > 0) {
                good = this.updateAllPriceLevelTimes(priceLevelTimes);
            }
            if (!good) {
                result = "Price Levels Sync Error";
            }
        }
        return result;
    }

    public String updateCustomerTermsSync(String customerTermsXml) {
        String result = "OK";
        POSDataContainer customerTerms = new POSDataContainer();
        if (customerTermsXml != null && !customerTermsXml.isEmpty()) {
            Vector customerTermsList = Utility.getElementList((String)"CustomerTerm", (String)customerTermsXml);
            int numCustomerTerms = customerTermsList.size();
            for (int i = 0; i < numCustomerTerms; ++i) {
                String thisCustomerTermXml = (String)customerTermsList.get(i);
                CustomerTerm thisCustomerTerm = new CustomerTerm(thisCustomerTermXml);
                customerTerms.add((Object)thisCustomerTerm);
            }
            boolean good = false;
            if (customerTerms != null && customerTerms.size() > 0) {
                good = this.updateCustomerTerms(customerTerms);
            }
            if (!good) {
                result = "Customer Terms Sync Error";
            }
        }
        return result;
    }

    public String updateRemoteDisplaysSync(String remoteDisplaysXml) {
        String result = "OK";
        POSDataContainer remoteDisplays = new POSDataContainer();
        if (remoteDisplaysXml != null && !remoteDisplaysXml.isEmpty()) {
            Vector remoteDisplaysList = Utility.getElementList((String)"DisplayPrinter", (String)remoteDisplaysXml);
            int numRemoteDisplays = remoteDisplaysList.size();
            for (int i = 0; i < numRemoteDisplays; ++i) {
                String thisRemodeDisplayXml = (String)remoteDisplaysList.get(i);
                DisplayPrinter thisRemoteDisplay = new DisplayPrinter(thisRemodeDisplayXml, true);
                remoteDisplays.add((Object)thisRemoteDisplay);
            }
            boolean good = false;
            if (remoteDisplays != null && remoteDisplays.size() > 0) {
                try {
                    good = this.posLocalData.updateRemoteDisplays(remoteDisplays);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
            if (!good) {
                result = "Remote Displays Sync Error";
            }
        }
        return result;
    }

    public String updateCompReasonsSync(String compReasonsXml) {
        String result = "OK";
        POSDataContainer compReasons = new POSDataContainer();
        if (compReasonsXml != null && !compReasonsXml.isEmpty()) {
            Vector compReasonsList = Utility.getElementList((String)"CompReason", (String)compReasonsXml);
            int numCompReasons = compReasonsList.size();
            for (int i = 0; i < numCompReasons; ++i) {
                String thisCompReason = (String)compReasonsList.get(i);
                compReasons.add((Object)thisCompReason);
            }
            boolean good = false;
            if (compReasons != null && compReasons.size() > 0) {
                good = this.updateCompReasons(compReasons);
            }
            if (!good) {
                result = "Comp Reasons Sync Error";
            }
        }
        return result;
    }

    public String updateUserGroupsSync(String userGroupsXml) {
        String result = "OK";
        POSDataContainer userGroups = new POSDataContainer();
        if (userGroupsXml != null && !userGroupsXml.isEmpty()) {
            Vector userGroupsList = Utility.getElementList((String)"UserGroup", (String)userGroupsXml);
            int numUserGroups = userGroupsList.size();
            for (int i = 0; i < numUserGroups; ++i) {
                String thisUserGroupXml = (String)userGroupsList.get(i);
                UserGroupInfo thisUserGroup = new UserGroupInfo(thisUserGroupXml);
                userGroups.add((Object)thisUserGroup);
            }
            boolean good = false;
            if (userGroups != null && userGroups.size() > 0) {
                good = this.updateUserGroups(userGroups);
            }
            if (!good) {
                result = "User Groups Sync Error";
            }
        }
        return result;
    }

    public void updateSyncControl(SyncControl syncControl) {
        try {
            this.posLocalData.updateSyncControl(syncControl);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public POSDataContainer getItemsSync(Timestamp lastSync) {
        POSDataContainer items = null;
        try {
            items = this.posLocalData.getItemsSync(lastSync);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return items;
    }

    public POSDataContainer getNoPartialQuantityItemsSync(Timestamp lastSync) {
        POSDataContainer noPartialQtyItems = new POSDataContainer();
        try {
            noPartialQtyItems = this.posLocalData.getNoPartialQuantityItemsSync(lastSync);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return noPartialQtyItems;
    }

    public POSDataContainer getPriceLevelTimesSync(Timestamp lastSync) {
        POSDataContainer priceLevelTimes = new POSDataContainer();
        try {
            priceLevelTimes = this.posLocalData.getPriceLevelTimesSync(lastSync);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return priceLevelTimes;
    }

    public POSDataContainer getCustomerTermsSync(Timestamp lastSync) {
        POSDataContainer customerTerms = new POSDataContainer();
        try {
            customerTerms = this.posLocalData.getCustomerTermsSync(lastSync);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return customerTerms;
    }

    public String getTipsTenderCode() {
        return this.tipsTenderCode;
    }

    public void setTipsTenderCode(String tenderCode) {
        this.tipsTenderCode = tenderCode;
    }

    public void setDebugLogging(boolean debugLogFlag) {
        this.debugLoggingOn = debugLogFlag;
    }

    public void setAutoKeyCreate(boolean autoCreateFlag) {
        this.autoCreateMenuButtons = autoCreateFlag;
        this.editModuleLine("Settings", "AutoCreateMenuButton", "" + autoCreateFlag);
    }

    public void setRemoveFoodService(boolean foodServiceFlag) {
        this.removeFoodService = foodServiceFlag;
    }

    public String createTenderCode() {
        String tenderCode = "";
        try {
            tenderCode = this.posLocalData.createTenderCode();
        }
        catch (Exception ex) {
            tenderCode = "";
            this.handleException(ex);
        }
        return tenderCode;
    }

    public boolean compactRepairDatabase() {
        boolean result = false;
        String dbDriver = this.posLocalData.getDriverName();
        if (!dbDriver.equalsIgnoreCase("sqlexpress")) {
            String msAccessPath = this.getMsAccessPath();
            if (msAccessPath == null || msAccessPath.isEmpty()) {
                msAccessPath = this.posLocalData.getMsAccessPath();
            }
            if (msAccessPath == null || msAccessPath.isEmpty()) {
                this.input(this.getLiteral("Microsoft Access Path is not defined in configuration - unable to perform Compact/Repair"));
                return result;
            }
            this.posLocalData.shutDown();
            if (this.accuShiftLocalData != null) {
                this.accuShiftLocalData.shutDown();
            }
            try {
                Thread.sleep(1000L);
                msAccessPath = msAccessPath + System.getProperty("file.separator") + "msaccess.exe";
                ProcessBuilder pb = new ProcessBuilder(msAccessPath, this.posLocalData.getDatabasePath(), "/compact");
                Process compactRepair = pb.start();
                compactRepair.waitFor();
                int processExitValue = compactRepair.exitValue();
                if (processExitValue == 0) {
                    result = true;
                }
            }
            catch (Exception ex) {
                result = false;
                this.raiseException(ex);
            }
            if (result) {
                this.posLocalData.checkDatabase();
            }
        }
        return result;
    }

    private String getMsAccessPath() {
        String path = "";
        try {
            String[] command = null;
            command = new String[]{"cmd", "/c", "reg", "query", "\"HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\MSACCESS.EXE\""};
            ProcessBuilder pb = new ProcessBuilder(command);
            Process process = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append(System.getProperty("line.separator"));
            }
            String result = builder.toString();
            String[] lines = result.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                if (!lines[i].contains("    Path")) continue;
                path = lines[i].subSequence(19, lines[i].length()).toString();
                path = path.trim();
                break;
            }
        }
        catch (IOException e) {
            path = "";
        }
        return path;
    }

    public boolean hasRegionalServers() {
        return this.regionalSyncHandler != null;
    }

    public POSDataContainer getRegionalServers() {
        POSDataContainer regionalServers = new POSDataContainer();
        try {
            regionalServers = this.posLocalData.getServerLocations();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return regionalServers;
    }

    public void updateRegionalServer(ServerLocation serverLocation) {
        try {
            this.posLocalData.updateRegionalServer(serverLocation);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void deleteRegionalServer(String serverLocation) {
        try {
            this.posLocalData.deleteRegionalServer(serverLocation);
            if (this.regionalSyncHandler != null) {
                this.regionalSyncHandler.scheduleSyncCommands();
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void updateServerSyncSchedule(SyncControl syncControl) {
        try {
            this.posLocalData.updateServerSyncSchedule(syncControl);
            if (this.regionalSyncHandler != null) {
                this.regionalSyncHandler.scheduleSyncCommands();
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void deleteServerSyncSchedule(int syncControlId) {
        try {
            this.posLocalData.deleteServerSyncSchedule(syncControlId);
            if (this.regionalSyncHandler != null) {
                this.regionalSyncHandler.scheduleSyncCommands();
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public POSDataContainer getServerSyncControls(String location) {
        POSDataContainer serverControls = new POSDataContainer();
        try {
            serverControls = this.posLocalData.getServerSyncControls(location);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return serverControls;
    }

    public void setRegionalSyncHandler(AccuServerRegionalSyncBase regionalSyncHandler) {
        this.regionalSyncHandler = regionalSyncHandler;
    }

    public void setComoLoyaltyHandler(ComoLoyaltyHandlerBase comoLoyaltyHandler) {
        this.comoLoyaltyHandler = comoLoyaltyHandler;
    }

    public String getComoCustomer(String filter) {
        String result = "";
        if (this.comoLoyaltyHandler != null) {
            result = this.comoLoyaltyHandler.getComoCustomer(filter);
        }
        return result;
    }

    public String getComoCustomerBenefits(Order thisOrder) {
        String result = "";
        if (this.comoLoyaltyHandler != null) {
            result = this.comoLoyaltyHandler.getComoCustomerBenefits(thisOrder);
        }
        return result;
    }

    public String redeemComoGift(Order thisOrder, String assetKey, String redeemCode) {
        String result = "";
        if (this.comoLoyaltyHandler != null) {
            result = this.comoLoyaltyHandler.redeemGift(thisOrder, assetKey, redeemCode);
        }
        return result;
    }

    public String autoRegisterComoMember(String customerPhone) {
        String result = "";
        if (this.comoLoyaltyHandler != null) {
            result = this.comoLoyaltyHandler.autoRegisterComoMember(customerPhone);
        }
        return result;
    }

    public String processPayWithComoBudget(Order thisOrder, String verificationCode, double tenderAmount) {
        String result = "";
        if (this.comoLoyaltyHandler != null) {
            result = this.comoLoyaltyHandler.payWithBudget(thisOrder, verificationCode, tenderAmount);
        }
        return result;
    }

    public String processPayWithComoBudgetVoid(String paymentId, String verificationCode, double amount, String user, String userTill, String orderXml, String code) {
        if (this.comoLoyaltyHandler == null) {
            return "";
        }
        Order thisOrder = null;
        Tender newTender = null;
        String result = "DECLINED";
        if (this.cardHandler == null) {
            return result;
        }
        thisOrder = new Order(orderXml, true);
        try {
            int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
            if (orderNumber == -1) {
                result = "NOT_PROCESSED_SERVERERROR";
                return result;
            }
            thisOrder = this.posLocalData.getOrder(orderNumber, true);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        result = this.comoLoyaltyHandler.cancelBudgetPayment(paymentId, verificationCode);
        String status = Utility.getElement((String)"Result", (String)result);
        if (status.equalsIgnoreCase("OK")) {
            if (!code.isEmpty()) {
                newTender = new Tender();
                newTender.amount = amount * -1.0;
                newTender.id = 0;
                newTender.newTender = true;
                newTender.user = user;
                newTender.till = userTill;
                newTender.isChange = false;
                newTender.code = code;
                TenderCode tenderCode = this.getTenderCode(code);
                newTender.type = tenderCode.tenderType;
                newTender.description = tenderCode.description;
                newTender.status = "V";
                Date now = new Date();
                newTender.created = now.getTime();
                if (thisOrder.tenderings == null) {
                    thisOrder.tenderings = new Vector();
                }
                thisOrder.tenderings.add(newTender);
                try {
                    int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
                    thisOrder = this.posLocalData.getOrder(orderNumber, true);
                }
                catch (Exception exception) {
                    this.handleException(exception);
                }
            }
        } else {
            String errorCode = Utility.getElement((String)"ErrorCode", (String)result);
            String errorMessage = Utility.getElement((String)"ErrorMessage", (String)result);
            if (errorCode.compareToIgnoreCase("7001") == 0 || errorCode.compareToIgnoreCase("7004") == 0 || errorCode.compareToIgnoreCase("7005") == 0 || errorCode.compareToIgnoreCase("7006") == 0) {
                result = result + "<Result>" + errorMessage + "</Result>";
                result = result + "<ErrorCode>" + errorCode + "</ErrorCode>";
                result = result + "<ErrorMessage>ERROR</ErrorMessaget>";
            }
        }
        result = result + thisOrder.toXml();
        return result;
    }

    public POSDataContainer getCloudItemTypes(String locations) {
        POSDataContainer itemTypes = null;
        try {
            if (this.cloudDataAccess != null) {
                itemTypes = this.cloudDataAccess.getCloudItemTypes(locations);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return itemTypes;
    }

    public POSDataContainer getCloudItemCategories(String locations) {
        POSDataContainer itemCategories = null;
        try {
            if (this.cloudDataAccess != null) {
                itemCategories = this.cloudDataAccess.getCloudItemCategories(locations);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return itemCategories;
    }

    public POSDataContainer getCloudTenderSummaryData(String selectedLocations, TransactionReportOptions reportOptions) {
        POSDataContainer tenders = null;
        try {
            if (this.cloudDataAccess != null) {
                tenders = this.cloudDataAccess.getCloudTenderSummaryData(selectedLocations, reportOptions);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return tenders;
    }

    public POSDataContainer getCloudSalesByItem(String selectedLocations, TransactionReportOptions reportOptions) {
        POSDataContainer tenders = null;
        try {
            if (this.cloudDataAccess != null) {
                tenders = this.cloudDataAccess.getCloudSalesByItem(selectedLocations, reportOptions);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return tenders;
    }

    public POSDataContainer getCloudSalesByHour(String selectedLocations, TransactionReportOptions reportOptions) {
        POSDataContainer tenders = null;
        try {
            if (this.cloudDataAccess != null) {
                tenders = this.cloudDataAccess.getCloudSalesByHour(selectedLocations, reportOptions);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return tenders;
    }

    public POSDataContainer getTaxCodeTaxAuthorities(String taxCode) {
        POSDataContainer taxAuthorities = new POSDataContainer();
        if (this.taxAuthoritiesTable == null || !this.taxAuthoritiesTable.containsKey(taxCode)) {
            try {
                taxAuthorities = this.posLocalData.getTaxAuthorities(taxCode);
                if (this.taxAuthoritiesTable == null) {
                    this.taxAuthoritiesTable = new Hashtable();
                }
                this.taxAuthoritiesTable.put(taxCode, taxAuthorities);
            }
            catch (Exception ex) {
                this.raiseException(ex);
            }
        } else {
            taxAuthorities = (POSDataContainer)this.taxAuthoritiesTable.get(taxCode);
        }
        return taxAuthorities;
    }

    public Tender getTenderDetail(int tenderId) {
        Tender tender = null;
        try {
            tender = this.posLocalData.getTenderDetail(tenderId);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return tender;
    }

    public String printSummarizeReceipt(int orderNumber, String printerName, String summarizeDescription, boolean local) {
        String result = "";
        try {
            OrderPrinter thisPrinter;
            User thisUser;
            Order thisOrder = this.getOrder(orderNumber, true);
            if (this.accuServerTaxHandler != null) {
                thisOrder = this.accuServerTaxHandler.calculateTaxes(thisOrder.toXml());
            }
            if ((thisUser = this.getUser(thisOrder.user)) != null && (thisPrinter = (OrderPrinter)this.orderPrinters.get(printerName)) != null) {
                result = thisPrinter.printSummarizeReceipt(thisOrder, summarizeDescription);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return result;
    }

    public boolean saleWasCanceled(Order thisOrder) {
        boolean canceledSale = true;
        int numTenders = thisOrder.tenderings.size();
        for (int i = 0; i < numTenders; ++i) {
            Tender thisTender = (Tender)thisOrder.tenderings.get(i);
            if (thisTender.status.contains("V")) continue;
            canceledSale = false;
            break;
        }
        int numLines = thisOrder.lineItems.size();
        for (int i = 0; i < numLines; ++i) {
            LineItem thisLine = (LineItem)thisOrder.lineItems.get(i);
            if (thisLine.status.contains("V")) continue;
            canceledSale = false;
            break;
        }
        return canceledSale;
    }

    public boolean updateRemoteDisplay(DisplayPrinter thisPrinter, boolean deleteOnly) {
        boolean result = false;
        try {
            result = this.posLocalData.updateRemoteDisplay(thisPrinter, deleteOnly);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        if (this.remoteDisplayHandler != null) {
            this.remoteDisplayHandler.loadRemoteDisplays();
        }
        return result;
    }

    public boolean updateRemoteDisplays(POSDataContainer remoteDevices) {
        boolean result = false;
        try {
            result = this.posLocalData.updateRemoteDisplays(remoteDevices);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        if (this.remoteDisplayHandler != null) {
            this.remoteDisplayHandler.loadRemoteDisplays();
        }
        return result;
    }

    public POSDataContainer getCustomerOrdersInvoiced(String customerCode) {
        POSDataContainer result = null;
        try {
            result = this.posLocalData.getCustomerOrdersInvoiced(customerCode);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return result;
    }

    public POSDataContainer getDeliveryOrders(String driver) {
        this.debugLog("core - get delivery orders for driver " + driver);
        POSDataContainer orders = null;
        try {
            this.debugLog("core - calling DB for for driver " + driver);
            orders = this.posLocalData.getDeliveryOrders(driver);
            if (this.accuServerTaxHandler != null && orders.size() > 0) {
                this.debugLog("core - DB returned - calculating taxes");
                for (int i = 0; i < orders.size(); ++i) {
                    Order order = (Order)orders.get(i);
                    this.accuServerTaxHandler.calculateOrderTaxes(order);
                }
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        this.debugLog("core - returning delivery orders for driver " + driver);
        return orders;
    }

    public POSDataContainer getOutboundOrders(String driver) {
        this.debugLog("core - get carryout and delivery orders for driver " + driver);
        POSDataContainer orders = null;
        try {
            this.debugLog("core - calling DB for for driver " + driver);
            orders = this.posLocalData.getOutboundOrders(driver);
            if (this.accuServerTaxHandler != null && !this.hasWithVatIncludedTaxCalculator() && orders.size() > 0) {
                this.debugLog("core - DB returned - calculating taxes");
                for (int i = 0; i < orders.size(); ++i) {
                    Order order = (Order)orders.get(i);
                    if (this.hasWithVatIncludedTaxCalculator()) continue;
                    this.accuServerTaxHandler.calculateOrderTaxes(order);
                }
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        this.debugLog("core - returning carryout and delivery orders for driver " + driver);
        return orders;
    }

    public void setEConduitCardHandler(EConduitHandlerBase eConduitCardHandler) {
        this.eConduitCardHandler = eConduitCardHandler;
    }

    public POSDataContainer getEConduitTerminals() {
        POSDataContainer terminalData = null;
        try {
            terminalData = this.posLocalData.getEConduitTerminals();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return terminalData;
    }

    public EConduitTerminal getEConduitTerminalByName(String terminalName) {
        POSDataContainer terminalData = null;
        EConduitTerminal terminal = null;
        try {
            terminalData = this.posLocalData.getEConduitTerminalByName(terminalName);
            int len = terminalData.size();
            if (len == 1) {
                terminal = (EConduitTerminal)terminalData.get(0);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return terminal;
    }

    public EConduitTerminal getEConduitTerminalById(String terminalId) {
        POSDataContainer terminalData = null;
        EConduitTerminal terminal = null;
        try {
            terminalData = this.posLocalData.getEConduitTerminalById(terminalId);
            int len = terminalData.size();
            if (len == 1) {
                terminal = (EConduitTerminal)terminalData.get(0);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return terminal;
    }

    public String processEConduitSale(double amount, double gratuityAmount, String referenceId, String terminalId, String apiKey, String apiPswd) {
        String result = "";
        if (this.eConduitCardHandler != null) {
            try {
                result = this.eConduitCardHandler.processSale(amount, gratuityAmount, referenceId, terminalId, apiKey, apiPswd);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public String processEConduitVoid(double amount, String referenceId, String terminalId, String apiKey, String apiPswd, String tenderResponse) {
        String result = "";
        if (this.eConduitCardHandler != null) {
            try {
                result = this.eConduitCardHandler.processVoid(amount, referenceId, terminalId, apiKey, apiPswd, tenderResponse);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public String processEConduitRefund(double amount, double gratuityAmount, String referenceId, String terminalId, String apiKey, String apiPswd) {
        String result = "";
        if (this.eConduitCardHandler != null) {
            try {
                result = this.eConduitCardHandler.processRefund(amount, gratuityAmount, referenceId, terminalId, apiKey, apiPswd);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public String processEConduitTip(double amount, String referenceId, String terminalId, String apiKey, String apiPswd) {
        String result = "";
        if (this.eConduitCardHandler != null) {
            try {
                result = this.eConduitCardHandler.processTip(amount, referenceId, terminalId, apiKey, apiPswd);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public String processEConduitPreAuth(double amount, String referenceId, String terminalId, String apiKey, String apiPswd) {
        String result = "";
        if (this.eConduitCardHandler != null) {
            try {
                result = this.eConduitCardHandler.processPreAuth(amount, referenceId, terminalId, apiKey, apiPswd);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public String processEConduitCapture(double amount, String referenceId, String terminalId, String apiKey, String apiPswd) {
        String result = "";
        if (this.eConduitCardHandler != null) {
            try {
                result = this.eConduitCardHandler.processCapture(amount, referenceId, terminalId, apiKey, apiPswd);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public String getUserSelection(String title, Vector options, String terminalId, String apiKey, String apiPswd) {
        String result = "";
        if (this.eConduitCardHandler != null) {
            try {
                result = this.eConduitCardHandler.getUserSelection(title, options, terminalId, apiKey, apiPswd);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public String getUserInput(String title, String type, int maxLength, String terminalId, String apiKey, String apiPswd) {
        String result = "";
        if (this.eConduitCardHandler != null) {
            try {
                result = this.eConduitCardHandler.getUserInput(title, type, maxLength, terminalId, apiKey, apiPswd);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public String getEConduitTip(double amount, String terminalId, String apiKey, String apiPswd, Vector suggestedPercents) {
        String result = "";
        if (this.eConduitCardHandler != null) {
            try {
                result = this.eConduitCardHandler.getTipAmount(amount, terminalId, apiKey, apiPswd, suggestedPercents);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public boolean hasEConduitCardHandler() {
        return this.eConduitCardHandler != null;
    }

    public void updateEConduitTerminals(POSDataContainer terminals) {
        try {
            this.posLocalData.updateEConduitTerminals(terminals);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public boolean unpairEConduitTerminal(String terminalId) {
        String result;
        String response;
        boolean ret = false;
        if (this.eConduitCardHandler != null && (response = this.eConduitCardHandler.unpairTerminal(terminalId)) != null && !response.isEmpty() && (result = Utility.getElement((String)"Result", (String)response)).equalsIgnoreCase("OK")) {
            ret = true;
        }
        return ret;
    }

    public String pairEConduitTerminal(String terminalSerialNumber, String companyName, String contactName, String address, String city, String state, String zipCode, String email, String phoneNumber) {
        String result = "";
        if (this.eConduitCardHandler != null) {
            result = this.eConduitCardHandler.pairTerminal(terminalSerialNumber, companyName, contactName, address, city, state, zipCode, email, phoneNumber);
        }
        return result;
    }

    public void setTriPOSCardHandler(TriPOSHandlerBase triPOSCardHandler) {
        this.triPOSCardHandler = triPOSCardHandler;
    }

    public boolean hasTriPOSCardHandler() {
        return this.triPOSCardHandler != null;
    }

    public JSONArray queryTriPOSTerminals(boolean load) {
        JSONArray result = null;
        if (this.triPOSCardHandler != null) {
            try {
                result = this.triPOSCardHandler.queryTerminals(load);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public String pairTriPOSTerminal(String activationId, String terminalId, String terminalDescription) {
        String result = "";
        if (this.triPOSCardHandler != null) {
            try {
                result = this.triPOSCardHandler.pairTerminal(activationId, terminalId, terminalDescription);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public String unpairTriPOSTerminal(String terminalId) {
        String result = "";
        if (this.triPOSCardHandler != null) {
            try {
                result = this.triPOSCardHandler.unpairTerminal(terminalId);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public String processTriPOSSale(double amount, double serviceFee, boolean askGratuity, String chargeType, String refId, String terminalId, boolean isFoodService, Vector suggestedPercents, String customerToken, String cardLogo, String networkId) {
        String result = "";
        if (this.triPOSCardHandler != null) {
            try {
                result = this.triPOSCardHandler.processSale(amount, serviceFee, askGratuity, chargeType, refId, terminalId, isFoodService, suggestedPercents, customerToken, cardLogo, networkId);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public String processTriPOSTokenSale(double amount, double serviceFee, boolean askGratuity, String chargeType, String refId, String terminalId, boolean isFoodService, Vector suggestedPercents, String customerToken, String cardLogo, String expiryMonth, String expiryYear, String networkId) {
        String result = "";
        if (this.triPOSCardHandler != null) {
            try {
                result = this.triPOSCardHandler.processSaleToken(amount, serviceFee, askGratuity, chargeType, refId, terminalId, isFoodService, suggestedPercents, customerToken, cardLogo, expiryMonth, expiryYear, networkId);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public String processTriPOSAuth(double amount, double serviceFee, String refId, String user, String userTill, String orderXml, String terminalId, boolean isFoodService) {
        String result = "Failed";
        String response = "";
        if (this.triPOSCardHandler != null) {
            try {
                String resultXml = this.triPOSCardHandler.processAuth(amount, serviceFee, refId, terminalId, isFoodService);
                if (resultXml != null && !resultXml.isEmpty()) {
                    result = Utility.getElement((String)"Result", (String)resultXml);
                    String errorMessage = Utility.getElement((String)"ErrorMessage", (String)resultXml);
                    if (result.contains("Approved")) {
                        String authCode = Utility.getElement((String)"AuthCode", (String)resultXml);
                        String transactionId = Utility.getElement((String)"RefID", (String)resultXml);
                        double authAmount = Utility.getDoubleElement((String)"ApprovedAmount", (String)resultXml);
                        String cardType = Utility.getElement((String)"CardType", (String)resultXml);
                        String acctNumber = Utility.getElement((String)"AcctNumber", (String)resultXml);
                        String expiry = Utility.getElement((String)"Expiry", (String)resultXml);
                        String cardHolderName = Utility.getElement((String)"CardHolderName", (String)resultXml);
                        Order thisOrder = new Order(orderXml, true);
                        thisOrder.preAuthId = transactionId;
                        thisOrder.preAuthApproval = authCode;
                        thisOrder.preAuthCode = cardType;
                        thisOrder.preAuthNumber = acctNumber;
                        thisOrder.preAuthExp = expiry;
                        thisOrder.preAuthHolder = cardHolderName;
                        thisOrder.preAuthAmount = authAmount;
                        thisOrder.preAuthRecordNumber = "TriPOSEMV";
                        int orderNumber = this.posLocalData.saveOrder(thisOrder, user, userTill);
                        if (orderNumber == -1) {
                            result = "NOT_PROCESSED_SERVERERROR";
                            return result;
                        }
                        thisOrder = this.posLocalData.getOrder(orderNumber, true);
                        if (thisOrder == null || thisOrder.orderNumber != orderNumber) {
                            result = "NOT_PROCESSED_SERVERERROR";
                            return result;
                        }
                        if (orderNumber > -1) {
                            result = "Approved";
                        }
                        thisOrder = this.calculateTaxes(thisOrder.toXml(), new Date().getTime());
                        response = response + thisOrder.toXml();
                    } else {
                        response = "<ErrorMessage>" + errorMessage + "</ErrorMessage>";
                    }
                }
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        response = "<Result>" + result + "</Result>" + response;
        return response;
    }

    public String processTriPOSAuthCompletion(int orderNumber, double amount, double tipAmount, String transactionId, String terminalId, String refId, boolean isFoodService) {
        String result = "";
        if (this.triPOSCardHandler != null) {
            try {
                String triPOSResult;
                result = this.triPOSCardHandler.processAuthCompletion(amount, tipAmount, transactionId, terminalId, refId, isFoodService);
                if (result != null && !result.isEmpty() && (triPOSResult = Utility.getElement((String)"Result", (String)result)).contains("Approved")) {
                    Order thisOrder = this.posLocalData.getOrder(orderNumber, true);
                    if (thisOrder == null || thisOrder.orderNumber != orderNumber) {
                        result = "NOT_PROCESSED_SERVERERROR";
                        return result;
                    }
                    thisOrder = this.calculateTaxes(thisOrder.toXml(), new Date().getTime());
                    result = result + thisOrder.toXml();
                }
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public String processTriPOSReturn(double returnAmount, String transactionId, String terminalId, boolean isFoodService) {
        String result = "";
        if (this.triPOSCardHandler != null) {
            try {
                result = this.triPOSCardHandler.processReturn(returnAmount, transactionId, terminalId, isFoodService);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public String processTriPOSRefund(double returnAmount, String refId, String terminalId, boolean isFoodService) {
        String result = "";
        if (this.triPOSCardHandler != null) {
            try {
                result = this.triPOSCardHandler.processRefund(returnAmount, refId, terminalId, isFoodService);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public String processTriPOSVoid(String refId, String transactionId, String terminalId, boolean isFoodService, boolean isDebit, double voidAmount) {
        String result = "";
        if (this.triPOSCardHandler != null) {
            try {
                result = this.triPOSCardHandler.processVoid(refId, transactionId, terminalId, isFoodService, isDebit, voidAmount);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public String processTriPOSReadCard(String terminalId) {
        String result = "";
        if (this.triPOSCardHandler != null) {
            try {
                result = this.triPOSCardHandler.processReadCard(terminalId);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public String processTriPOSCreateOmniTokenFromTransaction(String terminalId, String transactionId, String customerCode) {
        String result = "";
        if (this.triPOSCardHandler != null) {
            try {
                result = this.triPOSCardHandler.createOmniTokenFromTransaction(terminalId, transactionId, customerCode);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public String processTriPOSAuthVoid(String refId, String transactionId, String terminalId, boolean isFoodService, boolean isDebit, double voidAmount) {
        String result = "";
        if (this.triPOSCardHandler != null) {
            try {
                result = this.triPOSCardHandler.processAuthVoid(refId, transactionId, terminalId, isFoodService, isDebit, voidAmount);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        return result;
    }

    public String printCardSlip(String orderXml, int orderNumber, int tenderRecord, String printerName) {
        StringBuilder result = new StringBuilder();
        Order order = null;
        OrderPrinter thisPrinter = null;
        try {
            order = new Order(orderXml, true);
            thisPrinter = (OrderPrinter)this.orderPrinters.get(printerName);
            if (thisPrinter != null) {
                if (this.accuServerTaxHandler != null) {
                    order = this.accuServerTaxHandler.calculateTaxes(orderXml);
                }
                thisPrinter.setPrintCopy(false);
                if (order.receiptNumber > 0) {
                    thisPrinter.setPrintCopy(true);
                }
            }
            int tenderLen = order.tenderings.size();
            for (int i = 0; i < tenderLen; ++i) {
                String slipData = "";
                Tender tender = (Tender)order.tenderings.get(i);
                if (tender.id != tenderRecord) continue;
                slipData = thisPrinter.printOrder(order, tender);
                result.append(slipData);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return result.toString();
    }

    public String printPaymentReceipt(String orderXml, int tenderRecord, String printerName) {
        StringBuilder result = new StringBuilder();
        Order order = null;
        OrderPrinter thisPrinter = null;
        try {
            order = new Order(orderXml, true);
            thisPrinter = (OrderPrinter)this.orderPrinters.get(printerName);
            if (thisPrinter != null) {
                if (this.accuServerTaxHandler != null) {
                    order = this.accuServerTaxHandler.calculateTaxes(orderXml);
                }
                thisPrinter.setPrintCopy(false);
                if (order.receiptNumber > 0) {
                    thisPrinter.setPrintCopy(true);
                }
            }
            int tenderLen = order.tenderings.size();
            for (int i = 0; i < tenderLen; ++i) {
                String slipData = "";
                Tender tender = (Tender)order.tenderings.get(i);
                if (tender.id != tenderRecord) continue;
                slipData = thisPrinter.printOrder(order, tender, true);
                result.append(slipData);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return result.toString();
    }

    public POSDataContainer getAllCustomerTypes() {
        POSDataContainer customerTypes = null;
        try {
            customerTypes = this.posLocalData.getAllCustomerTypes();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return customerTypes;
    }

    public boolean hasQboIntegrator() {
        return this.integratorHandler != null && this.integratorHandler.getType() == 24;
    }

    public boolean isVatIncluded() {
        return this.accuServerTaxHandler.isVatIncluded();
    }

    public void setPrintReportsRTL(boolean printReportsRTL) {
        this.printReportsRTL = printReportsRTL;
    }

    public boolean getPrintReportsRTL() {
        return this.printReportsRTL;
    }

    public boolean hasSageLiveIntegrator() {
        return this.integratorHandler != null && this.integratorHandler.getType() == 25;
    }

    public void validateAccountingIntegration() {
        String integrationType;
        if (!this.hasLicenseFor("AccountingIntegration") && this.integratorHandler != null) {
            this.input(this.getLiteral("Not Licensed for Accounting Integration"));
            this.integratorHandler = null;
        } else if (this.hasLicenseFor("AccountingIntegration") && this.integratorHandler != null && !(integrationType = this.getIntegrationType()).isEmpty()) {
            int loadedIntegrationType = this.integratorHandler.getType();
            if (integrationType.equalsIgnoreCase("Quickbooks Online")) {
                if (this.integratorHandler.getType() != 24) {
                    this.integratorHandler = null;
                }
            } else if (integrationType.equalsIgnoreCase("Sage Live Online")) {
                if (this.integratorHandler.getType() != 25) {
                    this.integratorHandler = null;
                }
            } else if (integrationType.equalsIgnoreCase("Desktop Adapter")) {
                if (this.integratorHandler.getType() != 12 && this.integratorHandler.getType() != 29) {
                    this.integratorHandler = null;
                }
            } else if (integrationType.equalsIgnoreCase("Priority Online")) {
                if (this.integratorHandler.getType() != 27) {
                    this.integratorHandler = null;
                }
            } else if (integrationType.equalsIgnoreCase("Rivhit Online")) {
                if (this.integratorHandler.getType() != 28) {
                    this.integratorHandler = null;
                }
            } else if (integrationType.equalsIgnoreCase("QB Web Integrator")) {
                if (this.integratorHandler.getType() != 29) {
                    this.integratorHandler = null;
                }
            } else if (integrationType.equalsIgnoreCase("Hashavshevet Web")) {
                if (this.integratorHandler.getType() != 31) {
                    this.integratorHandler = null;
                }
            } else if (integrationType.equalsIgnoreCase("Not Set") || integrationType.equalsIgnoreCase("Solo") || integrationType.isEmpty()) {
                this.integratorHandler = null;
            }
            if (this.integratorHandler == null) {
                String loadedType = "";
                if (loadedIntegrationType == 24) {
                    loadedType = "Quickbooks Online";
                } else if (loadedIntegrationType == 25) {
                    loadedType = "Sage Live";
                } else if (loadedIntegrationType == 12) {
                    loadedType = "Desktop";
                } else if (loadedIntegrationType == 27) {
                    loadedType = "Priority Online";
                } else if (loadedIntegrationType == 28) {
                    loadedType = "Rivhit Online";
                } else if (loadedIntegrationType == 29) {
                    loadedType = "QB Web Integrator";
                } else if (loadedIntegrationType == 31) {
                    loadedType = "Hashavshevet Web";
                }
                this.input(this.getLiteral("Not Licensed for") + " " + loadedType + " " + this.getLiteral("Accounting Integration"));
            }
        }
    }

    public int getOldestOpenSaleDays() {
        int openSaleDays = 0;
        try {
            Timestamp openSaleDate = this.posLocalData.getOldestOpenSaleDate();
            if (openSaleDate != null) {
                long oldestDate = openSaleDate.getTime();
                long dateNow = System.currentTimeMillis();
                long daysDiff = (dateNow - oldestDate) / 86400000L;
                openSaleDays = (int)daysDiff;
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return openSaleDays;
    }

    public POSDataContainer getProductLines() {
        POSDataContainer productLines = null;
        try {
            productLines = this.posLocalData.getProductLines();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return productLines;
    }

    public ProductLine getProductLine(int productLineId) {
        ProductLine productLine = null;
        try {
            productLine = this.posLocalData.getProductLine(productLineId);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return productLine;
    }

    public void updateProductLine(ProductLine productLine) {
        try {
            this.posLocalData.updateProductLine(productLine);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public void deleteProductLine(int productLineId) {
        try {
            this.posLocalData.deleteProductLine(productLineId);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public boolean hasOntarioTaxCalculator() {
        if (this.accuServerTaxHandler != null) {
            String taxCalculatorName = this.accuServerTaxHandler.getClass().getName();
            return taxCalculatorName.equalsIgnoreCase("AccuServerTaxCalculator.AccuServerTaxCalculatorOntario");
        }
        return false;
    }

    public String getDatabaseStatistics() {
        DecimalFormat decimalFormat = new DecimalFormat("####0.000;-####0.000");
        String statistics = this.posLocalData.getDatabaseStatistics();
        Double dbSize = Utility.getDoubleElement((String)"DBSize", (String)statistics);
        Double dbAvailable = Utility.getDoubleElement((String)"DBAvailable", (String)statistics);
        Double diskFree = Utility.getDoubleElement((String)"DiskFree", (String)statistics);
        String dbType = Utility.getElement((String)"DBType", (String)statistics);
        this.input(this.getLiteral("Database Type: ") + dbType);
        String dbSizeSuffix = "";
        if (dbSize != null && dbSize > 0.0) {
            if (dbSize > 9.99999999E8) {
                dbSizeSuffix = this.getLiteral("GB");
                dbSize = dbSize / 1.073741824E9;
            } else if (dbSize > 999999.0) {
                dbSizeSuffix = this.getLiteral("MB");
                dbSize = dbSize / 1048576.0;
            } else {
                dbSizeSuffix = this.getLiteral("KB");
                dbSize = dbSize / 1024.0;
            }
        }
        this.input(this.getLiteral("Database Size: ") + decimalFormat.format(dbSize) + dbSizeSuffix);
        String dbAvailableSuffix = "";
        if (dbAvailable != null && dbAvailable > 0.0) {
            if (dbAvailable > 9.99999999E8) {
                dbAvailableSuffix = this.getLiteral("GB");
                dbAvailable = dbAvailable / 1.073741824E9;
            } else if (dbAvailable > 999999.0) {
                dbAvailableSuffix = this.getLiteral("MB");
                dbAvailable = dbAvailable / 1048576.0;
            } else {
                dbAvailableSuffix = this.getLiteral("KB");
                dbAvailable = dbAvailable / 1024.0;
            }
        }
        this.input(this.getLiteral("Database Available: ") + decimalFormat.format(dbAvailable) + dbAvailableSuffix);
        String diskFreeSuffix = "";
        if (diskFree != null && diskFree > 0.0) {
            if (diskFree > 9.99999999E8) {
                diskFreeSuffix = this.getLiteral("GB");
                diskFree = diskFree / 1.073741824E9;
            } else if (diskFree > 999999.0) {
                diskFreeSuffix = this.getLiteral("MB");
                diskFree = diskFree / 1048576.0;
            } else {
                diskFreeSuffix = this.getLiteral("KB");
                diskFree = diskFree / 1024.0;
            }
        }
        this.input(this.getLiteral("Disk Freespace: ") + decimalFormat.format(diskFree) + diskFreeSuffix);
        return statistics;
    }

    public boolean hasAlternateTaxCalculator() {
        if (this.accuServerTaxHandler != null) {
            String taxCalculatorName = this.accuServerTaxHandler.getClass().getName();
            return taxCalculatorName.equalsIgnoreCase("AccuServerTaxCalculator.AccuServerTaxCalculatorWithAlternates");
        }
        return false;
    }

    public boolean hasWithVatIncludedTaxCalculator() {
        if (this.accuServerTaxHandler != null) {
            String taxCalculatorName = this.accuServerTaxHandler.getClass().getName();
            return taxCalculatorName.equalsIgnoreCase("AccuServerTaxCalculator.AccuServerTaxCalculatorWithVatIncluded");
        }
        return false;
    }

    public boolean hasWithVat2TaxCalculator() {
        if (this.accuServerTaxHandler != null) {
            String taxCalculatorName = this.accuServerTaxHandler.getClass().getName();
            return taxCalculatorName.equalsIgnoreCase("AccuServerTaxCalculator.AccuServerTaxCalculatorWithVat2");
        }
        return false;
    }

    public boolean checkSerialNumberBlocked() {
        boolean blocked = true;
        try {
            String blockedString = this.posLocalData.checkSerialNumberBlocked();
            if (blockedString == null || blockedString.isEmpty()) {
                return blocked;
            }
            String encryptKey = "abouttime0000000";
            byte[] dataBytes = Base64.decode(blockedString);
            String decryptedBlock = this.decrypt(encryptKey, dataBytes);
            if (decryptedBlock != null && !decryptedBlock.isEmpty() && decryptedBlock.compareTo("Good") == 0) {
                blocked = false;
            }
            return blocked;
        }
        catch (Exception ex) {
            blocked = true;
            return blocked;
        }
    }

    public void updateSerialNumberBlocked(boolean blocked) {
        try {
            String encryptKey = "abouttime0000000";
            String blockedString = "";
            if (blocked) {
                byte[] encryptedBlock = this.encrypt(encryptKey, "Blocked");
                blockedString = new String(Base64.encode(encryptedBlock));
            } else {
                byte[] encryptedBlock = this.encrypt(encryptKey, "Good");
                blockedString = new String(Base64.encode(encryptedBlock));
            }
            this.posLocalData.updateSerialNumberBlocked(blockedString);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public String getMonitorInfo() {
        DecimalFormat decimal = new DecimalFormat("##0.000");
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() / 1024L) / 1024.0 - (double)(Runtime.getRuntime().freeMemory() / 1024L) / 1024.0;
        String serverMemory = decimal.format(currentMemory) + " MB";
        StringBuilder serverStats = new StringBuilder();
        serverStats.append("<Version>" + this.getVersion() + "</Version>");
        serverStats.append("<DateStarted>" + this.serverStartupDate + "</DateStarted>");
        serverStats.append("<ServerMemory>" + serverMemory + "</ServerMemory>");
        serverStats.append("<BytesIn>" + this.bytesIn + "</BytesIn>");
        serverStats.append("<BytesOut>" + this.bytesOut + "</BytesOut>");
        serverStats.append("<InternalIp>" + this.internalIp + "</InternalIp>");
        serverStats.append("<ExternalIp>" + this.externalIp + "</ExternalIp>");
        serverStats.append("<ServerPort>" + this.getServerPort() + "</ServerPort>");
        serverStats.append("<SerialNumber>" + this.getSerialNumber() + "</SerialNumber>");
        serverStats.append("<MonitorLog>" + this.monitorLog.toString() + "</MonitorLog>");
        return serverStats.toString();
    }

    private void checkForServerUpdates() {
        CheckForServerUpdatesThread checkForServerUpdatesThread = new CheckForServerUpdatesThread();
        checkForServerUpdatesThread.start();
    }

    private boolean downloadAccuServerInstaller(String serverUpdateYear) {
        boolean downloadSuccessful = false;
        String sourceDirectory = "/" + serverUpdateYear + "/SERVER-UPDATE/AccuServerInstaller.jar";
        String destFile = System.getProperty("user.dir") + "/AccuServerInstaller.jar";
        File previousDownload = new File(destFile);
        if (previousDownload.exists()) {
            previousDownload.delete();
        }
        try {
            URL website = new URL("http://updates.accuposretail.com" + sourceDirectory);
            HttpURLConnection urlConnect = (HttpURLConnection)website.openConnection();
            urlConnect.setRequestMethod("HEAD");
            urlConnect.setConnectTimeout(15000);
            urlConnect.connect();
            this.input("\nDownloading AccuServerInstaller ...");
            if (urlConnect.getResponseCode() == 200) {
                File file = new File(destFile);
                ReadableByteChannel rbc = Channels.newChannel(website.openStream());
                FileOutputStream fos = new FileOutputStream(file);
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                fos.close();
                downloadSuccessful = true;
            } else {
                downloadSuccessful = false;
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
            downloadSuccessful = false;
        }
        return downloadSuccessful;
    }

    private boolean downloadAccuServerZip(String serverUpdateYear) {
        boolean downloadSuccessful = false;
        String countryCode = this.getCountry();
        String zipFileName = "AccuServer.zip";
        if (!countryCode.equalsIgnoreCase("US")) {
            zipFileName = "AccuServer" + countryCode + ".zip";
        }
        String sourceDirectory = "/" + serverUpdateYear + "/SERVER-UPDATE/" + zipFileName;
        String destFile = System.getProperty("user.dir") + "/AccuServer.zip";
        File previousDownload = new File(destFile);
        if (previousDownload.exists()) {
            previousDownload.delete();
        }
        try {
            URL website = new URL("http://updates.accuposretail.com" + sourceDirectory);
            HttpURLConnection urlConnect = (HttpURLConnection)website.openConnection();
            urlConnect.setRequestMethod("HEAD");
            urlConnect.setConnectTimeout(15000);
            urlConnect.connect();
            this.input("\nDownloading AccuServer.zip ...");
            if (urlConnect.getResponseCode() == 200) {
                File file = new File(destFile);
                ReadableByteChannel rbc = Channels.newChannel(website.openStream());
                FileOutputStream fos = new FileOutputStream(file);
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                fos.close();
                downloadSuccessful = true;
            } else {
                downloadSuccessful = false;
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
            downloadSuccessful = false;
        }
        return downloadSuccessful;
    }

    public void updateAccuServer() {
        this.downloadLauncherExe();
        String installTime = "";
        if (installTime.isEmpty()) {
            this.input("\nAccuServerInstaller Started...");
            System.out.println("\nAccuServerInstaller Started...");
        } else {
            this.input("\nAccuServerUInstaller Scheduled to Start at " + installTime + "...");
            System.out.println("\nAccuServerInstaller Scheduled to Start at " + installTime + "...");
        }
        try {
            String serverUpdateYear = this.licenseHandler.getServerUpdateYear();
            String serverPort = "" + this.getServerPort();
            String countryCode = this.getCountry();
            String javaPath = System.getProperty("java.home") + "\\bin";
            String launcherExe = System.getProperty("user.dir") + "\\Launcher.exe";
            String installerJar = "AccuServerInstaller.jar";
            File exeFile = new File(launcherExe);
            if (exeFile.exists()) {
                String[] command = null;
                command = installTime != null && !installTime.isEmpty() ? new String[]{"cmd", "/c", launcherExe, javaPath, installerJar, serverPort, countryCode, serverUpdateYear, installTime} : new String[]{"cmd", "/c", launcherExe, javaPath, installerJar, serverPort, countryCode, serverUpdateYear};
                ProcessBuilder pb = new ProcessBuilder(command);
                Process process = pb.start();
            } else {
                this.input("\nLauncher.exe to start the AccuServerInstaller NOT FOUND ...");
                System.out.println("\nLauncher.exe to start the AccuServerInstaller NOT FOUND ...");
            }
        }
        catch (IOException ex) {
            this.raiseException(ex);
        }
    }

    void startOpenSaleMessageTimer() {
        Calendar eightAmTime = Calendar.getInstance();
        eightAmTime.set(11, 8);
        eightAmTime.set(12, 0);
        eightAmTime.set(13, 0);
        Timer timer = new Timer();
        timer.schedule((TimerTask)new OpenSalesMesssageTimer(timer), eightAmTime.getTime());
    }

    public int getNewsBannerInterval() {
        int newsBannerInterval = 1;
        if (this.licenseHandler != null) {
            newsBannerInterval = this.licenseHandler.getNewsBannerInterval();
        }
        return newsBannerInterval;
    }

    public void restartAccuServer() {
        try {
            String serverPort = "" + this.getServerPort();
            String javaPath = System.getProperty("java.home") + "\\bin";
            String launcherExe = System.getProperty("user.dir") + "\\Launcher.exe";
            File exeFile = new File(launcherExe);
            if (exeFile.exists()) {
                String[] command = null;
                command = new String[]{"cmd", "/c", launcherExe, javaPath, "AccuServerRestarter.jar", serverPort};
                ProcessBuilder pb = new ProcessBuilder(command);
                Process process = pb.start();
            } else {
                this.input("\nLauncher.exe to start AccuServerRestarter NOT FOUND ...");
                System.out.println("\nLauncher.exe to start AccuServerRestarter NOT FOUND ...");
            }
        }
        catch (IOException ex) {
            this.raiseException(ex);
        }
    }

    public void reRegisterAccuServer() {
        String serialNumber = this.getSerialNumber();
        this.licenseHandler.checkLicense(serialNumber);
    }

    public void clearAllBarcodes() {
        try {
            String command = "<Action>ClearAllBarcodes</Action>";
            this.posLocalData.setCommand(command);
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public void updatePricesWithVatRemoved(Item item) {
        if (item.vatCode != null && !item.vatCode.isEmpty()) {
            item.price = this.accuServerTaxHandler.getPriceBeforeTax(item.price, item.vatCode);
            item.price1 = this.accuServerTaxHandler.getPriceBeforeTax(item.price1, item.vatCode);
            item.price2 = this.accuServerTaxHandler.getPriceBeforeTax(item.price2, item.vatCode);
            item.price3 = this.accuServerTaxHandler.getPriceBeforeTax(item.price3, item.vatCode);
            item.price4 = this.accuServerTaxHandler.getPriceBeforeTax(item.price4, item.vatCode);
            item.price5 = this.accuServerTaxHandler.getPriceBeforeTax(item.price5, item.vatCode);
        }
    }

    public boolean updateTaxAuthority(TaxAuthority taxAuthority) {
        boolean result = true;
        try {
            this.posLocalData.updateTaxAuthority(taxAuthority);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    public boolean updateTaxCode(TaxCode taxCode) {
        boolean result = true;
        try {
            this.posLocalData.updateTaxCode(taxCode);
        }
        catch (Exception ex) {
            result = false;
            this.raiseException(ex);
        }
        return result;
    }

    private void downloadLauncherExe() {
        String serverUpdateYear = this.licenseHandler.getServerUpdateYear();
        if (serverUpdateYear == null || serverUpdateYear.isEmpty()) {
            return;
        }
        String sourceFile = "/" + serverUpdateYear + "/SERVER-UPDATE/Launcher.exe";
        String destFile = System.getProperty("user.dir") + "/Launcher.exe";
        try {
            URL website = new URL("http://updates.accuposretail.com" + sourceFile);
            HttpURLConnection urlConnect = (HttpURLConnection)website.openConnection();
            urlConnect.setRequestMethod("HEAD");
            urlConnect.setConnectTimeout(15000);
            urlConnect.connect();
            this.input("\nDownloading Launcher.exe ...");
            if (urlConnect.getResponseCode() == 200) {
                File file = new File(destFile);
                ReadableByteChannel rbc = Channels.newChannel(website.openStream());
                FileOutputStream fos = new FileOutputStream(file);
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                fos.close();
                this.input("\nLauncher.exe Downloaded Successfully ...");
            } else {
                this.input("\nFAILED to Download Launcher.exe ...");
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public void setSetupDataReceiver(SetupDataReceiverBase setupDataReceiver) {
        this.setupDataReceiver = setupDataReceiver;
    }

    public void createSetupData(String serialNumber, String password) {
        if (this.setupDataReceiver != null) {
            this.setupDataReceiver.createSetupData(serialNumber, password);
        }
    }

    public String getSetupDataMessage() {
        String message = "";
        if (this.setupDataReceiver != null) {
            message = this.setupDataReceiver.getSetupDataMessage();
        }
        return message;
    }

    public boolean isMobileServer() {
        Class<?> className = this.getClass();
        return className.getName().compareToIgnoreCase("AccuServer.Mobile.AccuServerService") == 0;
    }

    public boolean hasLicenseFor(String action) {
        String licenseFor = this.getLicenseFor(action);
        String status = Utility.getElement((String)"Status", (String)licenseFor);
        boolean result = status.equalsIgnoreCase("Good");
        return result;
    }

    public String getIntegrationType() {
        String integrationType = "";
        if (this.licenseHandler != null) {
            integrationType = this.licenseHandler.getIntegrationType();
        }
        return integrationType;
    }

    public boolean sendMessageToProxyServer(byte[] message) {
        if (this.webSocketClient != null) {
            try {
                this.webSocketClient.send(message);
            }
            catch (Exception e) {
                this.raiseException(e);
                return false;
            }
        }
        return true;
    }

    public boolean sendMessageToProxyServer(String message) {
        if (this.webSocketClient != null) {
            try {
                this.webSocketClient.send(message);
            }
            catch (Exception e) {
                this.raiseException(e);
                return false;
            }
        }
        return true;
    }

    public WebSocketClientBase getWebSocketProxyClient() {
        return this.webSocketClient;
    }

    public void establishWebSocketClient(String proxyServerUri, boolean secure) {
        try {
            if (secure) {
                WebSocketProxyClient accuServerWebSocketClient = new WebSocketProxyClient(new URI(proxyServerUri), (ServerCore)this);
                String storeType = "JKS";
                String storePassword = "abouttime";
                String keyPassword = "abouttime";
                KeyStore trustStore = KeyStore.getInstance(storeType);
                FileInputStream trustStoreStream = new FileInputStream(System.getProperty("user.dir") + "/truststore.ts");
                FileInputStream keyStoreStream = new FileInputStream(System.getProperty("user.dir") + "/keystore.jks");
                trustStore.load(keyStoreStream, storePassword.toCharArray());
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(trustStore, keyPassword.toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(trustStore);
                trustStore.load(trustStoreStream, "abouttime".toCharArray());
                trustManagerFactory.init(trustStore);
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
                SSLSocketFactory factory = sslContext.getSocketFactory();
                accuServerWebSocketClient.setSocket(factory.createSocket());
                if (!accuServerWebSocketClient.connectBlocking()) {
                    this.input(String.format("Could not establish connection with the proxy server on %s", proxyServerUri));
                } else {
                    this.webSocketClient = accuServerWebSocketClient;
                }
            } else {
                this.input("Trying to connect to WS server at " + proxyServerUri);
                WebSocketProxyClient accuServerWebSocketClient = new WebSocketProxyClient(new URI(proxyServerUri), (ServerCore)this);
                if (!accuServerWebSocketClient.connectBlocking()) {
                    this.input(String.format("Could not establish connection with the proxy server on %s", proxyServerUri));
                } else {
                    this.webSocketClient = accuServerWebSocketClient;
                }
            }
        }
        catch (URISyntaxException e) {
            this.input("The given URI for the proxy server is invalid");
        }
        catch (KeyStoreException e) {
            this.input("Could not load the key store for a secure connection with the proxy server");
        }
        catch (IOException e) {
            this.input("Could not load the key store file for a secure connection with the proxy server");
        }
        catch (NoSuchAlgorithmException e) {
            this.input("Invalid encryption algorithm for secure connection with the proxy server");
        }
        catch (CertificateException e) {
            this.input("Invalid certificate for a secure connection with the proxy server");
        }
        catch (UnrecoverableKeyException e) {
            this.input("Unrecoverablel key for a secure connection with the proxy server");
        }
        catch (KeyManagementException e) {
            this.input("Unable to load key store management for a secure connection with the proxy server");
        }
        catch (InterruptedException e) {
            this.input("Connection with secure proxy server interrupted");
        }
    }

    public double getPriceWithVatIncluded(double price, String vatCode) {
        double priceWithVat = 0.0;
        if (this.accuServerTaxHandler.isVatIncluded()) {
            priceWithVat = this.accuServerTaxHandler.getPriceWithTaxIncluded(price, vatCode);
        }
        return priceWithVat;
    }

    public double getPriceWithVatRemoved(double vatPrice, String vatCode) {
        double priceBeforeVat = 0.0;
        if (this.accuServerTaxHandler.isVatIncluded()) {
            priceBeforeVat = this.accuServerTaxHandler.getPriceBeforeTax(vatPrice, vatCode);
        }
        return priceBeforeVat;
    }

    public String getCarryOutTaxCode() {
        String carryOutTaxCode = "";
        if (this.accuServerTaxHandler != null) {
            carryOutTaxCode = this.accuServerTaxHandler.getCarryOutTaxCode();
        }
        return carryOutTaxCode;
    }

    public boolean isAutoCreateMenuButtons() {
        return this.autoCreateMenuButtons;
    }

    public void saveReorderMenuKeys(POSDataContainer itemList) {
        Item thisItem;
        int i;
        int numItems;
        Vector<String> pagesChanged = new Vector<String>();
        Hashtable pages = this.getMenuButtons();
        String menuPage = "";
        String buttonColor = "";
        String mainPage = "";
        boolean addPage = true;
        Vector<MenuKey> topButtons = (Vector<MenuKey>)pages.get("TOP");
        if (pages != null && itemList != null) {
            numItems = itemList.size();
            for (i = 0; i < numItems; ++i) {
                thisItem = (Item)itemList.get(i);
                if (thisItem.productLineName != null && !thisItem.productLineName.isEmpty()) {
                    POSDataContainer productLines = this.getProductLines();
                    if (productLines != null && !productLines.isEmpty()) {
                        for (int j = 0; j < productLines.size(); ++j) {
                            ProductLine productLine = (ProductLine)productLines.get(j);
                            if (!productLine.description.equals(thisItem.productLineName)) continue;
                            menuPage = productLine.menuKeyPage;
                            buttonColor = productLine.buttonColor;
                            break;
                        }
                    }
                } else if (thisItem.menuPage != null && !thisItem.menuPage.isEmpty()) {
                    menuPage = thisItem.menuPage;
                    buttonColor = "posBtn01";
                }
                if (thisItem.menuPage == null || thisItem.menuPage.isEmpty()) continue;
                if (topButtons != null && !topButtons.isEmpty()) {
                    int numButtons = topButtons.size();
                    for (int b = 0; b < numButtons; ++b) {
                        MenuKey thisKey = (MenuKey)topButtons.get(b);
                        if (thisKey.name.compareToIgnoreCase("MAIN") == 0) {
                            mainPage = thisKey.name;
                        }
                        if (thisItem.menuPage.compareToIgnoreCase("None") != 0 && thisKey.name.compareToIgnoreCase(thisItem.menuPage) != 0 && (mainPage.isEmpty() || !mainPage.contains(thisItem.menuPage))) continue;
                        addPage = false;
                    }
                } else {
                    topButtons = new Vector<MenuKey>();
                }
                if (!addPage) continue;
                MenuKey newKey = new MenuKey();
                newKey.keysetName = "";
                newKey.name = menuPage;
                newKey.text = menuPage;
                newKey.isActive = true;
                newKey.page = "TOP";
                newKey.buttonColor = Utility.translateColor((int)0);
                newKey.textColor = Utility.translateColor((int)0);
                newKey.imageName = buttonColor != null && !buttonColor.isEmpty() ? buttonColor : "posBtn01";
                newKey.type = "Page";
                newKey.cr = true;
                this.saveNewMenuKey(newKey);
                topButtons.add(newKey);
                pages.put("TOP", topButtons);
                pagesChanged.add("TOP");
            }
        }
        pages = this.getMenuButtons();
        if (itemList != null) {
            numItems = itemList.size();
            for (i = 0; i < numItems; ++i) {
                MenuKey thisKey;
                thisItem = (Item)itemList.get(i);
                if (thisItem.menuPage == null || thisItem.menuPage.isEmpty()) continue;
                int nextX = 0;
                int nextY = 0;
                int buttonWide = 0;
                Vector buttons = (Vector)pages.get(thisItem.menuPage.toUpperCase());
                if (buttons == null) {
                    buttons = new Vector();
                    pages.put(thisItem.menuPage, new Vector());
                } else if (buttons.size() >= 24) {
                    thisItem.menuPage = thisItem.menuPage + " 2";
                    if (pages.containsKey(thisItem.menuPage.toUpperCase())) {
                        buttons = (Vector)pages.get(thisItem.menuPage.toUpperCase());
                    } else if (!thisItem.menuPage.equalsIgnoreCase("None")) {
                        Vector<MenuKey> newPageKeys = new Vector<MenuKey>();
                        MenuKey newKey = new MenuKey();
                        newKey.keysetName = "";
                        newKey.name = thisItem.description;
                        newKey.text = thisItem.code;
                        newKey.isActive = true;
                        newKey.page = thisItem.menuPage;
                        if (buttonColor != null && !buttonColor.isEmpty()) {
                            newKey.imageName = buttonColor;
                        }
                        newKey.buttonColor = Utility.translateColor((int)0);
                        newKey.textColor = Utility.translateColor((int)0);
                        newKey.type = "Item";
                        newKey.cr = true;
                        newKey.row = nextY;
                        newKey.column = nextX;
                        newKey.width = buttonWide;
                        newPageKeys.add(newKey);
                        pages.put(thisItem.menuPage.toUpperCase(), newPageKeys);
                        MenuKey topKey = new MenuKey();
                        topKey.keysetName = "";
                        topKey.name = thisItem.menuPage;
                        topKey.text = thisItem.menuPage;
                        topKey.isActive = true;
                        topKey.page = "TOP";
                        topKey.buttonColor = Utility.translateColor((int)0);
                        topKey.textColor = Utility.translateColor((int)0);
                        topKey.imageName = buttonColor != null && !buttonColor.isEmpty() ? buttonColor : "posBtn01";
                        topKey.type = "Page";
                        topKey.cr = true;
                        topButtons.add(topKey);
                        pages.put("TOP", topButtons);
                        pagesChanged.add("TOP");
                        addPage = true;
                        buttons = (Vector)pages.get(thisItem.menuPage.toUpperCase());
                    }
                }
                int numButtons = buttons.size();
                for (int r = 0; r < numButtons; ++r) {
                    thisKey = (MenuKey)buttons.get(r);
                    if (thisKey.row <= nextY) continue;
                    nextY = thisKey.row;
                    if (buttonWide != 0) continue;
                    buttonWide = thisKey.width;
                }
                for (int c = 0; c < numButtons; ++c) {
                    thisKey = (MenuKey)buttons.get(c);
                    if (thisKey.row != nextY || thisKey.column <= nextX) continue;
                    nextX = thisKey.column;
                }
                if (nextX + buttonWide >= 7) {
                    ++nextY;
                    nextX = 1;
                } else {
                    nextX += buttonWide + 1;
                }
                boolean found = false;
                for (int b = 0; b < numButtons; ++b) {
                    MenuKey thisKey2 = (MenuKey)buttons.get(b);
                    if (thisKey2.text.compareToIgnoreCase(thisItem.code) != 0) continue;
                    found = true;
                }
                if (!found) {
                    MenuKey newKey = new MenuKey();
                    newKey.keysetName = "";
                    newKey.name = thisItem.description;
                    newKey.text = thisItem.code;
                    newKey.isActive = true;
                    newKey.page = thisItem.menuPage;
                    if (buttonColor != null && !buttonColor.isEmpty()) {
                        newKey.imageName = buttonColor;
                    }
                    newKey.buttonColor = Utility.translateColor((int)0);
                    newKey.textColor = Utility.translateColor((int)0);
                    newKey.type = "Item";
                    newKey.cr = true;
                    newKey.row = nextY;
                    newKey.column = nextX;
                    newKey.width = buttonWide;
                    if (pagesChanged.contains("TOP")) {
                        this.saveNewMenuKey(newKey);
                    }
                    buttons.add(newKey);
                }
                pagesChanged.add(thisItem.menuPage);
            }
        }
        Iterator iterator = pages.entrySet().iterator();
        while (iterator.hasNext()) {
            int b;
            int buttonWide = 2;
            int buttonHigh = 1;
            Map.Entry pair = iterator.next();
            String pageName = (String)pair.getKey();
            int numChanged = 0;
            if (pagesChanged != null) {
                numChanged = pagesChanged.size();
            }
            boolean pageWasChanged = false;
            for (int c = 0; c < numChanged; ++c) {
                String thisChangedPage = (String)pagesChanged.get(c);
                if (thisChangedPage.compareToIgnoreCase(pageName) != 0 && pageName.compareToIgnoreCase("TOP") != 0) continue;
                pageWasChanged = true;
                break;
            }
            if (!pageWasChanged) continue;
            Vector<Object> buttons = (Vector<Object>)pair.getValue();
            int numButtons = buttons.size();
            int numRows = 0;
            for (int r = 0; r < numButtons; ++r) {
                MenuKey thisKey = (MenuKey)buttons.get(r);
                if (thisKey.row > numRows) {
                    numRows = thisKey.row;
                }
                if (buttonWide != 0) continue;
                buttonWide = thisKey.width;
            }
            if (pageName.contains("TOP") && addPage) {
                int topRow = 1;
                int column = 1;
                int topCounter = 0;
                for (b = 0; b < numButtons; ++b) {
                    if (numButtons == 1) {
                        buttonHigh = 2;
                        buttonWide = 7;
                    } else if (numButtons == 2) {
                        if (topCounter == 0) {
                            buttonHigh = 2;
                            buttonWide = 4;
                        } else {
                            buttonHigh = 2;
                            buttonWide = 3;
                        }
                    } else if (numButtons == 3) {
                        if (topCounter == 0 || topCounter == 2) {
                            buttonHigh = 2;
                            buttonWide = 2;
                        } else {
                            buttonHigh = 2;
                            buttonWide = 3;
                        }
                    } else if (numButtons == 4) {
                        if (topCounter == 3) {
                            buttonHigh = 2;
                            buttonWide = 1;
                        } else {
                            buttonHigh = 2;
                            buttonWide = 2;
                        }
                    } else if (numButtons == 5) {
                        if (topCounter < 2) {
                            buttonHigh = 2;
                            buttonWide = 2;
                        } else {
                            buttonHigh = 2;
                            buttonWide = 1;
                        }
                    } else if (numButtons == 6) {
                        if (topCounter == 0) {
                            buttonHigh = 2;
                            buttonWide = 2;
                        } else {
                            buttonHigh = 0;
                            buttonWide = 0;
                        }
                    } else if (numButtons == 7) {
                        buttonHigh = 2;
                        buttonWide = 1;
                    } else if (numButtons == 8) {
                        if (topCounter < 6) {
                            buttonHigh = 2;
                            buttonWide = 1;
                        } else {
                            buttonHigh = 1;
                            buttonWide = 1;
                        }
                    } else if (numButtons == 9) {
                        if (topCounter < 5) {
                            buttonHigh = 2;
                            buttonWide = 1;
                        } else {
                            buttonHigh = 1;
                            buttonWide = 1;
                        }
                    } else if (numButtons == 10) {
                        if (topCounter < 4) {
                            buttonHigh = 2;
                            buttonWide = 1;
                        } else {
                            buttonHigh = 1;
                            buttonWide = 1;
                        }
                    } else if (numButtons == 11) {
                        if (topCounter < 3) {
                            buttonHigh = 2;
                            buttonWide = 1;
                        } else {
                            buttonHigh = 1;
                            buttonWide = 1;
                        }
                    } else if (numButtons == 12) {
                        if (topCounter < 2) {
                            buttonHigh = 2;
                            buttonWide = 1;
                        } else {
                            buttonHigh = 1;
                            buttonWide = 1;
                        }
                    } else if (numButtons == 13) {
                        if (topCounter < 1) {
                            buttonHigh = 2;
                            buttonWide = 1;
                        } else {
                            buttonHigh = 1;
                            buttonWide = 1;
                        }
                    } else {
                        buttonHigh = 1;
                        buttonWide = 1;
                    }
                    MenuKey thisKey = (MenuKey)buttons.get(b);
                    thisKey.row = topRow;
                    thisKey.column = column;
                    thisKey.height = buttonHigh;
                    thisKey.width = buttonWide;
                    int colorNumber = topRow++;
                    buttons.set(b, thisKey);
                    this.updateMenuKey(thisKey);
                    if ((column += buttonWide) > 7) {
                        column = 1;
                    }
                    ++topCounter;
                }
                continue;
            }
            if (pageName.contains("TOP")) continue;
            buttonWide = 4;
            buttonHigh = 3;
            Collections.sort(buttons, new MenuKeyRowSortOrder());
            int thisRow = 0;
            Vector<Object> sortedRows = new Vector<Object>();
            Vector<MenuKey> currentRow = new Vector<MenuKey>();
            for (b = 0; b < numButtons; ++b) {
                MenuKey thisKey = (MenuKey)buttons.get(b);
                if (thisRow == 0) {
                    thisRow = thisKey.row;
                } else if (thisRow != thisKey.row) {
                    thisRow = thisKey.row;
                    if (currentRow.size() > 0) {
                        Collections.sort(currentRow, new MenuKeyColumnSortOrder());
                        sortedRows.addAll(currentRow);
                        currentRow = new Vector();
                    }
                }
                currentRow.add(thisKey);
            }
            if (currentRow.size() > 0) {
                Collections.sort(currentRow, new MenuKeyColumnSortOrder());
                sortedRows.addAll(currentRow);
                currentRow = new Vector();
            }
            buttons = sortedRows;
            if (numButtons == 1) {
                buttonHigh = 8;
                buttonWide = 6;
            } else if (numButtons <= 4 && numButtons > 1) {
                buttonHigh = 4;
                buttonWide = 3;
            } else if (numButtons > 4 && numButtons <= 6) {
                buttonHigh = 4;
                buttonWide = 2;
            } else if (numButtons > 6 && numButtons <= 12) {
                buttonHigh = 2;
                buttonWide = 2;
            } else if (numButtons > 12 && numButtons <= 24) {
                buttonHigh = 2;
                buttonWide = 1;
            } else if (numButtons > 24) {
                buttonHigh = 1;
                buttonWide = 1;
            }
            int row = 1;
            int column = 1;
            for (int b2 = 0; b2 < numButtons; ++b2) {
                MenuKey thisKey = (MenuKey)buttons.get(b2);
                if (thisKey.page.compareToIgnoreCase(mainPage) == 0) {
                    thisKey.page = "MAIN";
                }
                thisKey.row = row;
                thisKey.column = column;
                thisKey.height = buttonHigh;
                thisKey.width = buttonWide;
                float colorNumber = row + 2;
                if (row > 1) {
                    float tempRow = row;
                    colorNumber = Math.round(tempRow / (float)buttonHigh + 2.0f);
                }
                buttons.set(b2, thisKey);
                this.updateMenuKey(thisKey);
                if ((column += buttonWide) < 7) continue;
                column = 1;
                row += buttonHigh;
            }
        }
    }

    public Hashtable getMenuButtons() {
        POSDataContainer menuKeys = this.getAllMenuKeys();
        Hashtable<String, Vector<MenuKey>> pages = new Hashtable<String, Vector<MenuKey>>();
        int len = menuKeys.size();
        for (int i = 0; i < len; ++i) {
            Vector<MenuKey> buttons;
            MenuKey key = (MenuKey)menuKeys.get(i);
            if (key.type.compareToIgnoreCase("Item") != 0 && key.type.compareToIgnoreCase("Page") != 0 && key.type.compareToIgnoreCase("GeneralDiscount") != 0 && key.type.compareToIgnoreCase("Level") != 0 && key.type.compareToIgnoreCase("Price") != 0 && key.type.compareToIgnoreCase("Quantity") != 0 && key.type.compareToIgnoreCase("ItemDiscount") != 0 && key.type.compareToIgnoreCase("SaleDiscount") != 0 || key.keysetName.length() != 0) continue;
            if (pages == null) {
                pages = new Hashtable();
            }
            if ((buttons = (Vector<MenuKey>)pages.get(key.page.toUpperCase())) == null) {
                buttons = new Vector<MenuKey>();
            }
            buttons.add(key);
            pages.put(key.page.toUpperCase(), buttons);
        }
        return pages;
    }

    public SMTPCredentials getSMTPServiceCredentials() {
        SMTPCredentials smtpCredentials = this.licenseHandler.getSMTPCredentials();
        return smtpCredentials;
    }

    public void sendEmail(String emailContent, String emailAddress, String emailSubject, String attachmentFilePath, String attachmentName) {
        SendEmailThread sendEmailThread = new SendEmailThread(emailContent, emailAddress, emailSubject, attachmentFilePath, attachmentName);
        sendEmailThread.start();
    }

    private void editModuleLine(String module, String moduleName, String setTrueFalse) {
        String configXml = Utility.getXml((String)"AccuServer.cfg");
        String moduleLine = this.getModuleLine(configXml, module);
        if (!moduleLine.isEmpty()) {
            this.setParameterTag(configXml, moduleLine, moduleName, setTrueFalse);
        }
    }

    private String getModuleLine(String configXml, String module) {
        String moduleLine = "";
        String startTag = "<";
        String bodyEndTag = ">";
        String endTag = "";
        endTag = module.compareToIgnoreCase("Settings") == 0 ? "</Settings>" : module + "</Module>";
        int endPos = configXml.indexOf(endTag);
        while (endPos >= 0) {
            int bodyEndPos = configXml.lastIndexOf(bodyEndTag, endPos);
            int startPos = configXml.lastIndexOf(startTag, bodyEndPos);
            if (endPos > startPos) {
                moduleLine = configXml.substring(startPos, endPos + endTag.length());
            }
            if (moduleLine.startsWith("<Module") || moduleLine.startsWith("<Settings")) break;
            moduleLine = "";
            endPos = configXml.indexOf(endTag, endPos + 1);
        }
        return moduleLine;
    }

    private void setParameterTag(String configXml, String moduleLine, String parameter, String value) {
        StringBuilder moduleString = new StringBuilder(moduleLine);
        if (!parameter.isEmpty()) {
            String oldParm = "";
            String newParm = "";
            int startPos = moduleLine.indexOf(parameter + "=");
            int endPos = moduleLine.indexOf(">");
            if (startPos > -1) {
                String parameterLine = moduleLine.substring(startPos, endPos);
                String[] pairs = parameterLine.split(" ");
                boolean foundParameter = false;
                for (int i = 0; !(i >= pairs.length || foundParameter && pairs[i].contains("=")); ++i) {
                    String[] thisPair = pairs[i].split("=");
                    if (!foundParameter && thisPair[0].compareToIgnoreCase(parameter) == 0) {
                        foundParameter = true;
                    }
                    oldParm = thisPair.length > 1 ? thisPair[0].trim() + "=" + thisPair[1] : oldParm + " " + thisPair[0];
                }
                if (foundParameter) {
                    endPos = startPos + oldParm.length();
                }
            }
            if (startPos > -1 && endPos > startPos) {
                if (!value.isEmpty()) {
                    newParm = parameter + "=" + value;
                } else {
                    newParm = "";
                    if (startPos > 0 && moduleLine.substring(startPos - 1, startPos).compareTo(" ") == 0) {
                        --startPos;
                    }
                }
                moduleString.replace(startPos, endPos, newParm);
            } else if (value != null && !value.isEmpty()) {
                int insertPos = moduleLine.indexOf(">");
                newParm = " " + parameter + "=" + value;
                moduleString.insert(insertPos, newParm);
            }
            configXml = configXml.replace(moduleLine, moduleString.toString());
            this.updateAccuServerConfigFile(configXml);
        }
    }

    public void reprintRemoteTicket(int orderNumber) {
        this.debugLog("core - get open orders for order number " + orderNumber);
        Object orders = null;
        try {
            this.debugLog("core - calling DB for for order number " + orderNumber);
            Order order = this.posLocalData.getOrder(orderNumber, true);
            if (this.remoteDisplayHandler != null && order != null) {
                order.reprintRemoteTicket = true;
                int len = 0;
                if (order.lineItems != null) {
                    len = order.lineItems.size();
                }
                for (int n = 0; n < len; ++n) {
                    LineItem line = (LineItem)order.lineItems.get(n);
                    line.displayOnRemote = true;
                    order.lineItems.set(n, line);
                }
                this.remoteDisplayHandler.createDisplayOrder(order);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public void reprintTableTickets(String tableId) {
        this.debugLog("core - get open orders for table " + tableId);
        POSDataContainer orders = null;
        try {
            this.debugLog("core - calling DB for for table " + tableId);
            orders = this.posLocalData.getOpenOrders(tableId, "null", "null", true);
            this.debugLog("core - DB returned - calculating taxes");
            if (this.remoteDisplayHandler != null && orders.size() > 0) {
                for (int i = 0; i < orders.size(); ++i) {
                    Order order = (Order)orders.get(i);
                    order.reprintRemoteTicket = true;
                    int len = 0;
                    if (order.lineItems != null) {
                        len = order.lineItems.size();
                    }
                    for (int n = 0; n < len; ++n) {
                        LineItem line = (LineItem)order.lineItems.get(n);
                        line.displayOnRemote = true;
                        order.lineItems.set(n, line);
                    }
                    this.remoteDisplayHandler.createDisplayOrder(order);
                }
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
    }

    public void setMishlohaDataHandler(OnlineOrdersHandlerBase mishlohaDataHandler) {
        this.mishlohaDataHandler = mishlohaDataHandler;
    }

    public void setTenBisDataHandler(OnlineOrdersHandlerBase tenbisDataHandler) {
        this.tenbisDataHandler = tenbisDataHandler;
    }

    public void setCibusDataHandler(OnlineOrdersHandlerBase cibusDataHandler) {
        this.cibusDataHandler = cibusDataHandler;
    }

    public void setWoltDataHandler(OnlineOrdersHandlerBase woltDataHandler) {
        this.woltDataHandler = woltDataHandler;
    }

    public void setBiteDataHandler(OnlineOrdersHandlerBase biteDataHandler) {
        this.biteDataHandler = biteDataHandler;
    }

    public void setClickEatDataHandler(OnlineOrdersHandlerBase clickEatDataHandler) {
        this.clickEatDataHandler = clickEatDataHandler;
    }

    public boolean setOnlineOrderStatus(int orderNumber, String orderId, String orderUser, String orderStatus) {
        boolean success = false;
        if (!orderUser.isEmpty()) {
            if (orderUser.contains("Mishloha") && this.mishlohaDataHandler != null) {
                if (orderStatus != null && orderStatus.contains("Accept")) {
                    success = this.mishlohaDataHandler.setOrderStatus(4, orderId);
                } else if (orderStatus != null && orderStatus.contains("Reject")) {
                    success = this.mishlohaDataHandler.setOrderStatus(3, orderId);
                }
            } else if (orderUser.contains("Cibus") && this.cibusDataHandler != null) {
                if (orderStatus != null && orderStatus.contains("Accept")) {
                    success = this.cibusDataHandler.setOrderStatus(2, orderId);
                } else if (orderStatus != null && orderStatus.contains("Reject")) {
                    success = true;
                }
            } else if (orderUser.contains("TenBis") && this.tenbisDataHandler != null) {
                if (orderStatus != null && orderStatus.contains("Accept")) {
                    success = this.tenbisDataHandler.setOrderStatus(2, orderId);
                } else if (orderStatus != null && orderStatus.contains("Reject")) {
                    success = true;
                }
            } else if (orderUser.contains("Wolt") && this.woltDataHandler != null) {
                if (orderStatus != null && orderStatus.contains("Accept")) {
                    success = true;
                } else if (orderStatus != null && orderStatus.contains("Reject")) {
                    success = true;
                }
            } else if (orderUser.contains("Bite") && this.biteDataHandler != null) {
                if (orderStatus != null && orderStatus.contains("Accept")) {
                    success = true;
                } else if (orderStatus != null && orderStatus.contains("Reject")) {
                    success = true;
                }
            } else if (orderUser.contains("ClickEat") && this.clickEatDataHandler != null) {
                if (orderStatus != null && orderStatus.contains("Accept")) {
                    success = this.clickEatDataHandler.setOrderStatus(1, orderId);
                } else if (orderStatus != null && orderStatus.contains("Reject")) {
                    success = this.clickEatDataHandler.setOrderStatus(3, orderId);
                }
            } else if (orderUser.contains("WooCommerce") && this.clickEatDataHandler != null) {
                if (orderStatus != null && orderStatus.contains("Accept")) {
                    success = true;
                } else if (orderStatus != null && orderStatus.contains("Reject")) {
                    success = true;
                }
            }
        }
        if (success) {
            Order onlineOrder = this.getOrder(orderNumber, true);
            boolean wasInvoiced = false;
            if (onlineOrder.receiptNumber > 0) {
                wasInvoiced = true;
                onlineOrder = this.reopenOrder(onlineOrder.toXml(), onlineOrder.user, onlineOrder.shift);
            }
            if (onlineOrder != null) {
                if (orderStatus != null && orderStatus.contains("Accept")) {
                    onlineOrder.status = "Accepted";
                    this.saveOrder(onlineOrder.toXml(), onlineOrder.user, onlineOrder.shift);
                    if (wasInvoiced) {
                        this.invoiceOrder(onlineOrder.toXml(), onlineOrder.user, onlineOrder.shift, "", "");
                    }
                } else if (orderStatus != null && orderStatus.contains("Reject")) {
                    onlineOrder.status = "Rejected";
                    onlineOrder = this.voidOnlineOrder(onlineOrder);
                    this.invoiceOrder(onlineOrder.toXml(), onlineOrder.user, onlineOrder.shift, "", "");
                }
                success = true;
            } else {
                success = false;
            }
        }
        return success;
    }

    public Order voidOnlineOrder(Order onlineOrder) {
        int tenderLen = 0;
        if (onlineOrder.tenderings != null) {
            tenderLen = onlineOrder.tenderings.size();
        }
        Date now = new Date();
        long created = now.getTime();
        for (int i = tenderLen - 1; i >= 0; --i) {
            Tender thisTender = (Tender)onlineOrder.tenderings.get(i);
            thisTender.status = "V";
            Tender newTender = new Tender();
            newTender.amount = thisTender.amount * -1.0;
            newTender.code = thisTender.code;
            newTender.description = thisTender.description;
            newTender.id = 0;
            newTender.newTender = true;
            newTender.user = thisTender.user;
            newTender.type = thisTender.type;
            ++created;
            newTender.created = newTender.created;
            newTender.status = "V";
            onlineOrder.tenderings.add(newTender);
        }
        int itemsLen = onlineOrder.lineItems.size();
        for (int i = itemsLen - 1; i >= 0; --i) {
            LineItem thisItem = (LineItem)onlineOrder.lineItems.get(i);
            Vector<LineItem> newLines = new Vector<LineItem>();
            if (!thisItem.status.equalsIgnoreCase("V")) {
                thisItem.status = "V";
                thisItem.tax = new Tax();
                onlineOrder.lineItems.set(i, thisItem);
                LineItem newItem = new LineItem();
                ++created;
                newItem.created = newItem.created;
                newItem.status = "V";
                newItem.displayOnRemote = true;
                newItem.id = 0;
                newItem.itemDescription = thisItem.itemDescription;
                newItem.altDescription = thisItem.altDescription;
                newItem.itemId = thisItem.itemId;
                newItem.newLine = true;
                newItem.price = thisItem.price;
                newItem.quantity = thisItem.quantity * -1.0;
                newItem.total = thisItem.total * -1.0;
                newItem.vatTax1 = thisItem.vatTax1 * -1.0;
                newItem.vatTax2 = thisItem.vatTax2 * -1.0;
                newItem.vatGross = thisItem.vatGross * -1.0;
                newItem.userId = thisItem.userId;
                newItem.tax = new Tax();
                newItem.taxable = thisItem.taxable;
                newItem.itemType = thisItem.itemType;
                newLines.add(newItem);
            }
            onlineOrder.lineItems.addAll(newLines);
        }
        return onlineOrder;
    }

    public POSDataContainer getRemoteDisplayOrders(String displayName) {
        this.loadRemoteDisplays();
        POSDataContainer remoteDisplayOrders = new POSDataContainer();
        try {
            POSDataContainer orders = this.posLocalData.getRemoteDisplayOrders();
            boolean selectOrder = false;
            int numOrders = 0;
            if (orders != null) {
                numOrders = orders.size();
            }
            for (int o = 0; o < numOrders; ++o) {
                Order order = (Order)orders.get(o);
                int numberTickets = this.getNumberOfTickets(order.lineItems);
                for (int t = 0; t < numberTickets; ++t) {
                    ArrayList<DisplayItem> items = new ArrayList<DisplayItem>();
                    ArrayList<LineItem> ticketLineItems = new ArrayList<LineItem>();
                    int currentTicketNumber = t + 1;
                    int numLines = order.lineItems.size();
                    String thisItemsTill = "";
                    for (int i = 0; i < numLines; ++i) {
                        LineItem lineItem = (LineItem)order.lineItems.get(i);
                        if (lineItem.ticketNumber == 0 && lineItem.status.contains("V") || lineItem.ticketNumber != currentTicketNumber) continue;
                        String code = lineItem.itemId;
                        String description = lineItem.itemDescription;
                        float quantity = (float)lineItem.quantity;
                        String category = lineItem.itemType;
                        thisItemsTill = lineItem.till;
                        DisplayItem thisItem = new DisplayItem(code, description, quantity, category);
                        thisItem.key = lineItem.id;
                        thisItem.displayOnRemote = lineItem.displayOnRemote;
                        thisItem.carryOut = lineItem.carryOut;
                        thisItem.isAppetizer = lineItem.isAppetizer;
                        thisItem.seat = String.valueOf(lineItem.sort);
                        thisItem.processStatus = lineItem.processStatus;
                        thisItem.doNotPrint = lineItem.doNotPrint;
                        thisItem.lineStatus = lineItem.status;
                        if (lineItem.choices != null) {
                            int choiceNum = lineItem.choices.size();
                            for (int j = 0; j < choiceNum; ++j) {
                                ItemChoice itemChoice = (ItemChoice)lineItem.choices.get(j);
                                String line = itemChoice.text;
                                if (line.trim().length() > 0) {
                                    thisItem.addChoice(line);
                                    continue;
                                }
                                thisItem.addChoice(" ");
                            }
                        }
                        thisItem.userGroup = this.getUsersGroup(lineItem.userId);
                        items.add(thisItem);
                        ticketLineItems.add(lineItem);
                    }
                    if (items == null || items.size() == 0) continue;
                    DisplayOrder displayOrder = new DisplayOrder((long)order.orderNumber, items, order.orderId, "", order.carryOut, order.guestCount);
                    displayOrder.table = order.table;
                    displayOrder.setServer(order.user);
                    displayOrder.setUserGroup(this.getUsersGroup(order.user));
                    displayOrder.number = order.orderNumber;
                    displayOrder.guestCount = order.guestCount;
                    displayOrder.delivery = order.delivery;
                    displayOrder.request = order.requested;
                    displayOrder.created = order.created;
                    displayOrder.processStatus = order.processStatus;
                    displayOrder.ticketNumber = currentTicketNumber;
                    displayOrder.created = this.getTicketCreatedTime(ticketLineItems);
                    if (order.reprintRemoteTicket) {
                        displayOrder.reprint = true;
                    }
                    ArrayList<DisplayItem> printerItemList = new ArrayList<DisplayItem>();
                    for (int j = 0; j < items.size(); ++j) {
                        DisplayItem thisItem = (DisplayItem)items.get(j);
                        for (int p = 0; p < this.remoteDisplays.size(); ++p) {
                            int c;
                            DisplayPrinter thisPrinter = (DisplayPrinter)this.remoteDisplays.get(p);
                            if (thisPrinter.name.compareToIgnoreCase(displayName) != 0 || thisPrinter.itemTypes == null || thisPrinter.itemTypes.size() == 0 || !thisItem.displayOnRemote && !thisPrinter.isMonitor) continue;
                            int numCategories = thisPrinter.itemTypes.size();
                            int numTills = thisPrinter.tills.size();
                            boolean hasTillExcluded = false;
                            String thisItemType = "";
                            block8: for (int c2 = 0; c2 < numCategories; ++c2) {
                                thisItemType = (String)thisPrinter.itemTypes.get(c2);
                                for (int tl = 0; tl < numTills; ++tl) {
                                    String thisTill = (String)thisPrinter.tills.get(tl);
                                    if (thisItem.itemType.compareToIgnoreCase(thisItemType) != 0 || thisTill == null || thisTill.isEmpty() || !thisItemsTill.equalsIgnoreCase(thisTill)) continue;
                                    hasTillExcluded = true;
                                    continue block8;
                                }
                            }
                            boolean includeAllTypes = false;
                            for (c = 0; c < numCategories; ++c) {
                                thisItemType = (String)thisPrinter.itemTypes.get(c);
                                if (!thisItemType.contains("All")) continue;
                                includeAllTypes = true;
                                break;
                            }
                            for (c = 0; c < numCategories; ++c) {
                                thisItemType = (String)thisPrinter.itemTypes.get(c);
                                if (thisItem.itemType == null || !includeAllTypes && (thisItem.itemType.compareToIgnoreCase(thisItemType) != 0 || hasTillExcluded) || thisPrinter.excludeGroup != null && thisPrinter.excludeGroup.trim().length() != 0 && thisPrinter.excludeGroup.contains(thisItem.userGroup)) continue;
                                printerItemList.add(thisItem);
                                selectOrder = true;
                            }
                        }
                    }
                    if (!selectOrder) continue;
                    if (printerItemList != null) {
                        displayOrder.items = printerItemList;
                    }
                    remoteDisplayOrders.add((Object)displayOrder);
                }
            }
        }
        catch (Exception e) {
            this.raiseException(e);
        }
        return remoteDisplayOrders;
    }

    public void loadRemoteDisplays() {
        if (this.remoteDisplays == null || this.remoteDisplays.size() == 0) {
            this.remoteDisplays = this.getRemoteDisplays();
            this.remotePrinters = new Hashtable();
        }
    }

    public int getNumberOfTickets(Vector itemList) {
        int ticketNumber = -1;
        int numItems = 0;
        if (itemList != null) {
            numItems = itemList.size();
        }
        for (int i = 0; i < numItems; ++i) {
            LineItem thisItem = (LineItem)itemList.get(i);
            if (thisItem != null && thisItem.ticketNumber > ticketNumber) {
                ticketNumber = thisItem.ticketNumber;
                continue;
            }
            if (thisItem != null && thisItem.ticketNumber == 0 && !thisItem.status.contains("V")) continue;
        }
        return ticketNumber + 1;
    }

    public Timestamp getTicketCreatedTime(ArrayList itemList) {
        Timestamp createdTime = new Timestamp(0L);
        int numItems = 0;
        if (itemList != null) {
            numItems = itemList.size();
        }
        for (int i = 0; i < numItems; ++i) {
            LineItem thisItem = (LineItem)itemList.get(i);
            if (thisItem == null || thisItem.created <= createdTime.getTime()) continue;
            createdTime = new Timestamp(thisItem.created);
        }
        return createdTime;
    }

    public boolean printZeroFlexGroupItems() {
        return this.printZeroFlexGroupItems;
    }

    public String getCentralInfo() {
        String centralInfo = "";
        try {
            if (this.posLocalData != null) {
                centralInfo = this.posLocalData.getCentralInfo();
            }
        }
        catch (Exception e) {
            this.raiseException(e);
        }
        return centralInfo;
    }

    public String getTCControlXml() {
        String tcInfo = "";
        try {
            if (this.accuShiftLocalData != null) {
                tcInfo = this.accuShiftLocalData.getTCControlXml();
            }
        }
        catch (Exception e) {
            this.raiseException(e);
        }
        return tcInfo;
    }

    public String generateClientConnectCode() {
        if (this.clientConnectCode != null && !this.clientConnectCode.isEmpty()) {
            return this.clientConnectCode;
        }
        Random random = new Random();
        int newcode = random.nextInt(999999);
        this.clientConnectCode = String.format("%06d", newcode);
        this.logText("Client Request Code Generated: " + this.clientConnectCode);
        return this.clientConnectCode;
    }

    public boolean validateClientConnectCode(String enteredCode) {
        if (enteredCode != null && !enteredCode.isEmpty()) {
            if (enteredCode.compareTo(this.clientConnectCode) == 0) {
                this.clientConnectCode = "";
                this.input("Client Request Code Validated");
                this.logText("Client Request Code Validated");
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean updateCustomerExtended(String customerCode, String extendedData, String networkId) {
        boolean success = false;
        try {
            if (this.posLocalData != null) {
                String encryptedData = "";
                if (extendedData != null && !extendedData.isEmpty() && !extendedData.contains("**CLEAR**")) {
                    try {
                        String encodedKey = new String(this.getEncodedKey2(), "UTF-8");
                        byte[] dataEncrypted = this.encrypt(encodedKey, extendedData);
                        encryptedData = new String(Base64.encode(dataEncrypted));
                    }
                    catch (Exception exception) {}
                } else {
                    encryptedData = extendedData;
                }
                success = this.posLocalData.updateCustomerExtended(customerCode, encryptedData, networkId);
            }
        }
        catch (Exception e) {
            this.raiseException(e);
        }
        return success;
    }

    public void generatePluAndExport() {
        StringBuilder out = new StringBuilder();
        Pattern hebrewPattern = Pattern.compile(".*[\u0590-\u05ff]+.*");
        POSDataContainer items = this.getItemList();
        POSDataContainer deliScaleCategories = new POSDataContainer();
        POSDataContainer categories = this.getAllItemCategories();
        int categoriesLen = 0;
        if (categories != null) {
            categoriesLen = categories.size();
        }
        for (int i = 0; i < categoriesLen; ++i) {
            ItemCategory thisCategory = (ItemCategory)categories.get(i);
            if (!thisCategory.deliScale) continue;
            deliScaleCategories.add((Object)thisCategory.category);
        }
        int len = items.size();
        for (int i = 0; i < len; ++i) {
            try {
                Matcher m;
                Item item = (Item)items.get(i);
                if (!deliScaleCategories.contains((Object)item.itemCategory)) continue;
                Item itemVatIncluded = this.webServer.getPricesWithVatIncluded(item);
                String code = String.format("%013d", Integer.parseInt(itemVatIncluded.code));
                out.append(code).append(" ");
                String description = itemVatIncluded.description.trim();
                if (description.length() > 20) {
                    description = description.substring(0, 20);
                }
                if ((m = hebrewPattern.matcher(description)).matches()) {
                    StringBuilder sb = new StringBuilder(description);
                    description = sb.reverse().toString();
                }
                description = String.format("%1$20s", description.trim());
                out.append(description).append(" ");
                String weight = "1";
                out.append(weight).append(" ");
                int cost = (int)(itemVatIncluded.price * 100.0);
                String costString = String.format("%06d", cost);
                out.append(costString).append(" ");
                int price = (int)(itemVatIncluded.price * 100.0);
                String priceString = String.format("%06d", price);
                out.append(priceString).append(" ");
                out.append("00").append(" ");
                out.append("\r\n");
                continue;
            }
            catch (Exception item) {
                // empty catch block
            }
        }
        if (this.pluAddress.contains("LOCAL")) {
            String fileName = this.pluPath + "/plu.txt";
            try {
                File resultFile = new File(fileName);
                if (resultFile.exists()) {
                    resultFile.delete();
                }
            }
            catch (Exception ex) {
                this.raiseException(ex);
            }
            BufferedWriter fw = null;
            try {
                fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "Cp862"));
                fw.write(out.toString());
                ((Writer)fw).close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else {
            String reply = "";
            String proxyRequest = "<ApAdapterFileProxyRequest>";
            proxyRequest = proxyRequest + "<action>PLU_EXPORT</action>";
            proxyRequest = proxyRequest + "<PLU_PATH>";
            proxyRequest = proxyRequest + this.pluPath;
            proxyRequest = proxyRequest + "</PLU_PATH>";
            proxyRequest = proxyRequest + "<PLU_DATA>";
            proxyRequest = proxyRequest + out;
            proxyRequest = proxyRequest + "</PLU_DATA>";
            proxyRequest = proxyRequest + "</ApAdapterFileProxyRequest>\r\n";
            Utility utility = new Utility();
            try {
                Socket connection = this.getFileProxyConnection(5000);
                if (connection != null) {
                    reply = utility.sendRequest(connection, proxyRequest);
                } else {
                    this.input("Unable to connect to ApAdapterFileProxy");
                }
            }
            catch (Exception ex) {
                this.input("Unable to connect to ApAdapterFileProxy");
                this.logText(ex.toString());
            }
        }
    }

    public Socket getFileProxyConnection(int timeout) throws Exception {
        int trys = 3;
        Socket socket = null;
        Object sslSocketFactory = null;
        SocketFactory socketfactory = null;
        while (socket == null && trys > 0) {
            try {
                socketfactory = SocketFactory.getDefault();
                socket = socketfactory.createSocket(this.pluAddress, this.pluPort);
            }
            catch (Exception iOException) {
                this.logText(iOException.toString());
                this.input(this.getLiteral("Unable to create Socket for ApAdapterFileProxy"));
            }
            if (socket != null) {
                socket.setSoTimeout(timeout);
                boolean down = socket.isInputShutdown();
                if (down) {
                    System.out.println("down");
                }
            }
            if (socket != null) continue;
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                this.raiseException(e);
            }
            --trys;
        }
        if (socket == null) {
            this.input(this.getLiteral("Could not create Socket for ApAdapterFileProxy connection.") + " " + this.getLiteral("Please make sure the Accounting Adapter is Running"));
        }
        return socket;
    }

    public POSDataContainer getAllQualifyingQtyTypes() {
        this.qualifyingQtyTypes = null;
        try {
            this.qualifyingQtyTypes = this.posLocalData.getAllQualifyingQtyTypes();
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return this.qualifyingQtyTypes;
    }

    public POSDataContainer getQualifyingQtyTypes() {
        return this.qualifyingQtyTypes;
    }

    public POSDataContainer getItemAttributes() {
        POSDataContainer itemAttributes = null;
        try {
            if (this.posLocalData != null) {
                itemAttributes = this.posLocalData.getItemAttributes();
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return itemAttributes;
    }

    public boolean updateItemAttributes(POSDataContainer itemAttributes) {
        boolean success = false;
        try {
            if (this.posLocalData != null) {
                success = this.posLocalData.updateItemAttributes(itemAttributes);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return success;
    }

    public boolean deleteItemAttributes(int attributeNumber) {
        boolean success = false;
        try {
            if (this.posLocalData != null) {
                success = this.posLocalData.deleteItemAttributes(attributeNumber);
            }
        }
        catch (Exception ex) {
            this.raiseException(ex);
        }
        return success;
    }

    void startInternetConnectionTimer() {
        Timer internetConnectionTimer = new Timer();
        internetConnectionTimer.schedule((TimerTask)new InternetConnectionTimer(), 60000L, 60000L);
    }

    public void checkInternetStatus() {
        String testIp = this.getLiteral("Unavailable");
        try {
            URL whatismyip = new URL("http://checkip.amazonaws.com");
            URLConnection connection = whatismyip.openConnection();
            connection.addRequestProperty("Protocol", "Http/1.1");
            connection.addRequestProperty("Connection", "keep-alive");
            connection.addRequestProperty("User-Agent", "Web-Agent");
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            testIp = in.readLine();
            in.close();
            Object var3_5 = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (testIp.contains("Unavailable")) {
            System.out.println("Amazon IP for Internet Test: " + testIp);
            try {
                this.webSocketHost.sendAllPOSMessage(this.getLiteral("Internet access is not available.") + "\r\n" + this.getLiteral("Services that require Internet Connectivity may be impacted."));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.externalIp = testIp;
    }

    void startPingHostConnectionTimer() {
        Timer pingHostConnectionTimer = new Timer();
        pingHostConnectionTimer.schedule((TimerTask)new PingHostConnectionTimer(), 60000L, 60000L);
    }

    public void pingAccuPOSHost() {
        if (this.hostConnector != null && !this.disableHostPing) {
            this.logText("Pinging AccuPOSHost");
            this.sendToHost("<Request>Ping</Request>");
        }
    }

    public void updateIntegratorParameters(Hashtable parameters) {
        if (this.integratorHandler != null) {
            this.integratorHandler.updateParameters(parameters);
        }
    }

    public int checkStrongPswdCount(boolean increment) {
        int result = 0;
        if (this.posLocalData != null) {
            try {
                result = this.posLocalData.checkStrongPswdCount(increment);
            }
            catch (Exception ex) {
                this.raiseException(ex);
            }
        }
        return result;
    }

    public boolean isValidEmail(String email) {
        boolean result = true;
        try {
            InternetAddress emailAddr = new InternetAddress(email);
            emailAddr.validate();
        }
        catch (AddressException ex) {
            result = false;
        }
        return result;
    }

    public void processHostAccountingRequest(String soapActionLine, String integrationRequest) {
        if (this.integratorHandler != null) {
            this.integratorHandler.processHostAccountingRequest(soapActionLine, integrationRequest);
        }
    }

    public void processHostAccountingResponse(String soapActionLine, String integrationResponse) {
        if (this.integratorHandler != null) {
            this.integratorHandler.processHostAccountingResponse(soapActionLine, integrationResponse);
        }
    }

    public void setSMSHandler(AccuServerSMSHandlerBase smsHandlerLoaded) {
        this.smsHandler = smsHandlerLoaded;
    }

    public String sendSMSMessage(String messageText, String sendToNumber) {
        String response = "";
        if (this.smsHandler != null) {
            response = this.smsHandler.sendSMS(sendToNumber, messageText);
        }
        return response;
    }

    public void setHostSyncActive(String message) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd-yyyy");
        this.input("Host Sync set to Active");
        this.addToLog("Host Sync set to Active");
        if (this.cloudDataAccess != null) {
            this.hostSyncActive = true;
            if (message != null && !message.isEmpty()) {
                String syncStartDateText = Utility.getElement((String)"SyncStartDate", (String)message);
                this.input("Host Sync Start Date " + syncStartDateText);
                this.addToLog("Host Sync Start Date " + syncStartDateText);
                Date syncStartDate = null;
                try {
                    syncStartDate = dateFormat.parse(syncStartDateText);
                    Timestamp syncStartTimestamp = new Timestamp(syncStartDate.getTime());
                    this.cloudDataAccess.setSyncStartDate(syncStartTimestamp);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void disableHostSync() {
        this.hostSyncActive = false;
    }

    public boolean hostSyncActive() {
        return this.hostSyncActive;
    }

    public boolean disableCustomerBalance() {
        boolean disableCustomerBalance = false;
        if (this.integratorHandler != null) {
            disableCustomerBalance = this.integratorHandler.isDisableCustomerBalance();
        }
        return disableCustomerBalance;
    }

    public Vector searchDataChanges(String objectType, String objectKey, Timestamp startDate, Timestamp endDate) {
        Vector result = new Vector();
        if (this.posLocalData != null) {
            try {
                result = this.posLocalData.searchDataChanges(objectType, objectKey, startDate, endDate);
            }
            catch (Exception ex) {
                this.raiseException(ex);
            }
        }
        return result;
    }

    class PingHostConnectionTimer
    extends TimerTask {
        PingHostConnectionTimer() {
        }

        @Override
        public void run() {
            AccuServerCore.this.pingAccuPOSHost();
            if (AccuServerCore.this.disableHostPing) {
                this.cancel();
            }
        }
    }

    class InternetConnectionTimer
    extends TimerTask {
        InternetConnectionTimer() {
        }

        @Override
        public void run() {
            AccuServerCore.this.checkInternetStatus();
        }
    }

    private class ExportPLU
    extends Thread {
        @Override
        public void run() {
            AccuServerCore.this.generatePluAndExport();
        }
    }

    private class SendEmailThread
    extends Thread {
        String emailContent = "";
        String emailAddress = "";
        String emailSubject = "";
        String attachmentFilePath = "";
        String attachmentName = "";
        SMTPCredentials smtpCredentials = null;
        ReceiptPrintSetup receiptPrintSetup = null;
        Company companyInfo = null;

        public SendEmailThread(String emailContent, String emailAddress, String emailSubject, String attachmentFilePath, String attachmentName) {
            this.emailContent = emailContent;
            this.emailAddress = emailAddress;
            this.emailSubject = emailSubject;
            this.attachmentFilePath = attachmentFilePath;
            this.attachmentName = attachmentName;
        }

        @Override
        public void run() {
            boolean authenticate = false;
            try {
                this.receiptPrintSetup = AccuServerCore.this.getReceiptPrintSetup();
                if (this.receiptPrintSetup.companyEmail.isEmpty()) {
                    String msg = "emailReceipt canceled, No company email address defined";
                    AccuServerCore.this.input(msg);
                    AccuServerCore.this.logText(msg);
                    return;
                }
                if (this.emailAddress == null || this.emailAddress.isEmpty()) {
                    String msg = "email attempt canceled, No To email address defined";
                    AccuServerCore.this.input(msg);
                    AccuServerCore.this.logText(msg);
                    return;
                }
                this.smtpCredentials = AccuServerCore.this.getSMTPServiceCredentials();
                if (this.smtpCredentials != null) {
                    this.receiptPrintSetup.receiptEmailAccount = this.smtpCredentials.user;
                    this.receiptPrintSetup.receiptEmailPassword = this.smtpCredentials.password;
                    this.receiptPrintSetup.receiptEmailSMTPServer = this.smtpCredentials.host;
                    this.receiptPrintSetup.receiptEmailSMTPPort = this.smtpCredentials.port;
                }
                Properties props = System.getProperties();
                props.put("mail.smtp.timeout", "5000");
                props.put("mail.smtp.host", this.receiptPrintSetup.receiptEmailSMTPServer);
                if (this.receiptPrintSetup.receiptEmailSMTPPort != null && !this.receiptPrintSetup.receiptEmailSMTPPort.isEmpty()) {
                    props.put("mail.smtp.port", this.receiptPrintSetup.receiptEmailSMTPPort);
                }
                this.companyInfo = AccuServerCore.this.getCompany();
                authenticate = true;
                props.put("mail.smtp.auth", "true");
                Session session = Session.getInstance((Properties)props, null);
                MimeMessage msg = new MimeMessage(session);
                InternetAddress fromAddress = new InternetAddress(this.receiptPrintSetup.companyEmail, this.companyInfo.name);
                msg.setFrom((Address)fromAddress);
                InternetAddress toAddress = new InternetAddress(this.emailAddress);
                msg.addRecipient(Message.RecipientType.TO, (Address)toAddress);
                msg.setSubject(this.emailSubject);
                if (this.attachmentFilePath.isEmpty()) {
                    msg.setContent((Object)this.emailContent, "text/html; charset=UTF-8");
                } else {
                    MimeBodyPart messageBodyPart = new MimeBodyPart();
                    messageBodyPart.setContent((Object)this.emailContent, "text/html; charset=UTF-8");
                    MimeMultipart multipart = new MimeMultipart("related");
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                    MimeBodyPart attachment = new MimeBodyPart();
                    FileDataSource source = new FileDataSource(this.attachmentFilePath);
                    attachment.setDataHandler(new DataHandler((DataSource)source));
                    attachment.setHeader("Content-ID", this.attachmentName);
                    attachment.setFileName(this.attachmentName);
                    multipart.addBodyPart((BodyPart)attachment);
                    msg.setContent((Multipart)multipart);
                    msg.setSubject(this.emailSubject);
                }
                msg.setSentDate(new Date());
                msg.saveChanges();
                Transport transport = session.getTransport("smtp");
                if (authenticate) {
                    transport.connect(this.smtpCredentials.user, this.smtpCredentials.password);
                } else {
                    transport.connect();
                }
                transport.sendMessage((Message)msg, msg.getAllRecipients());
                transport.close();
            }
            catch (AddressException ex) {
                AccuServerCore.this.input("email address invalid");
            }
            catch (AuthenticationFailedException ex) {
                AccuServerCore.this.input("email address/password authentication failed");
            }
            catch (UnsupportedEncodingException ex) {
                AccuServerCore.this.input("return email address invalid");
            }
            catch (MessagingException ex) {
                this.sendSSL();
            }
        }

        private void sendSSL() {
            try {
                Properties props = new Properties();
                props.put("mail.smtp.host", this.receiptPrintSetup.receiptEmailSMTPServer);
                props.put("mail.smtp.port", this.receiptPrintSetup.receiptEmailSMTPPort);
                props.put("mail.smtp.socketFactory.port", this.receiptPrintSetup.receiptEmailSMTPPort);
                props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                props.put("mail.smtp.auth", "true");
                props.put("mail.smtp.timeout", "5000");
                Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(SendEmailThread.this.smtpCredentials.user, SendEmailThread.this.smtpCredentials.password);
                    }
                });
                MimeMessage message = new MimeMessage(session);
                InternetAddress fromAddress = new InternetAddress(this.receiptPrintSetup.companyEmail, this.companyInfo.name);
                message.setFrom((Address)fromAddress);
                InternetAddress toAddress = new InternetAddress(this.emailAddress);
                message.addRecipient(Message.RecipientType.TO, (Address)toAddress);
                message.setSubject(this.emailSubject);
                if (this.attachmentFilePath.isEmpty()) {
                    message.setContent((Object)this.emailContent, "text/html; charset=UTF-8");
                } else {
                    MimeBodyPart messageBodyPart = new MimeBodyPart();
                    messageBodyPart.setContent((Object)this.emailContent, "text/html; charset=UTF-8");
                    MimeMultipart multipart = new MimeMultipart("related");
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                    MimeBodyPart attachment = new MimeBodyPart();
                    FileDataSource source = new FileDataSource(this.attachmentFilePath);
                    attachment.setDataHandler(new DataHandler((DataSource)source));
                    attachment.setHeader("Content-ID", this.attachmentName);
                    attachment.setFileName(this.attachmentName);
                    multipart.addBodyPart((BodyPart)attachment);
                    message.setContent((Multipart)multipart);
                    message.setSubject(this.emailSubject);
                }
                message.setSentDate(new Date());
                Transport.send((Message)message);
            }
            catch (AddressException ex) {
                AccuServerCore.this.input("email address invalid");
            }
            catch (AuthenticationFailedException ex) {
                AccuServerCore.this.input("email address/password authentication failed");
            }
            catch (UnsupportedEncodingException ex) {
                AccuServerCore.this.input("return email address invalid");
            }
            catch (MessagingException ex) {
                AccuServerCore.this.raiseException((Exception)((Object)ex));
            }
        }
    }

    class MenuKeyColumnSortOrder
    implements Comparator {
        MenuKeyColumnSortOrder() {
        }

        public int compare(Object arg0, Object arg1) {
            int result = 0;
            if (arg0.getClass() != MenuKey.class) {
                return 0;
            }
            if (arg1.getClass() != MenuKey.class) {
                return 0;
            }
            if (((MenuKey)arg0).column > ((MenuKey)arg1).column) {
                result = 1;
            }
            if (((MenuKey)arg0).column < ((MenuKey)arg1).column) {
                result = -1;
            }
            if (((MenuKey)arg0).column == ((MenuKey)arg1).column) {
                result = 0;
            }
            return result;
        }
    }

    class MenuKeyRowSortOrder
    implements Comparator {
        MenuKeyRowSortOrder() {
        }

        public int compare(Object arg0, Object arg1) {
            int result = 0;
            if (arg0.getClass() != MenuKey.class) {
                return 0;
            }
            if (arg1.getClass() != MenuKey.class) {
                return 0;
            }
            if (((MenuKey)arg0).row > ((MenuKey)arg1).row) {
                result = 1;
            }
            if (((MenuKey)arg0).row < ((MenuKey)arg1).row) {
                result = -1;
            }
            if (((MenuKey)arg0).row == ((MenuKey)arg1).row) {
                result = 0;
            }
            return result;
        }
    }

    private class DownloadLauncherExe
    implements Runnable {
        private DownloadLauncherExe() {
        }

        @Override
        public void run() {
            AccuServerCore.this.downloadLauncherExe();
        }
    }

    private class OpenSalesMesssageTimer
    extends TimerTask {
        Timer timer = null;

        public OpenSalesMesssageTimer(Timer timer) {
            this.timer = timer;
        }

        @Override
        public void run() {
            String openSalesStatsXml;
            String runDate;
            this.timer.cancel();
            this.timer.purge();
            boolean alreadyRun = false;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
            String todaysDate = dateFormat.format(new Date().getTime());
            String statsFileName = System.getProperty("user.dir") + "/OpenSalesStat.xml";
            File file = new File(statsFileName);
            if (file.exists() && (runDate = Utility.getElement((String)"OpenSalesMessageDate", (String)(openSalesStatsXml = Utility.getXml((String)statsFileName)))) != null && !runDate.isEmpty()) {
                alreadyRun = runDate.equalsIgnoreCase(todaysDate);
            }
            if (!alreadyRun) {
                int openSalesDays;
                if (AccuServerCore.this.emailExceptionHandler != null && (openSalesDays = AccuServerCore.this.getOldestOpenSaleDays()) > 0) {
                    String companyName = "";
                    if (AccuServerCore.this.company != null && AccuServerCore.this.company.name != null && !AccuServerCore.this.company.name.isEmpty()) {
                        companyName = AccuServerCore.this.company.name;
                    }
                    String message = AccuServerCore.this.getLiteral("You have Tills with Open Sales more than");
                    message = message + " " + openSalesDays + " ";
                    message = message + AccuServerCore.this.getLiteral("days old");
                    String serialNumber = AccuServerCore.this.getSerialNumber();
                    EmailOpenSaleThread thisThread = new EmailOpenSaleThread(companyName, serialNumber, message);
                    thisThread.start();
                }
                String todaysDateXml = "<OpenSalesMessageDate>" + todaysDate + "</OpenSalesMessageDate>";
                try {
                    Utility.writeXml((String)statsFileName, (String)todaysDateXml);
                }
                catch (IOException ex) {
                    AccuServerCore.this.raiseException(ex);
                }
            }
            Calendar eightAmTime = Calendar.getInstance();
            eightAmTime.add(5, 1);
            eightAmTime.set(11, 8);
            eightAmTime.set(12, 0);
            eightAmTime.set(13, 0);
            Timer newTimer = new Timer();
            newTimer.schedule((TimerTask)new OpenSalesMesssageTimer(newTimer), eightAmTime.getTime());
        }
    }

    class CheckForServerUpdatesThread
    extends Thread {
        @Override
        public void run() {
            boolean serverUpdatesAvailable = AccuServerCore.this.licenseHandler.getServerUpdatesAvailable();
            File file = new File(System.getProperty("user.dir") + "/Launcher.exe");
            if (!file.exists()) {
                DownloadLauncherExe downloadLauncherExe = new DownloadLauncherExe();
                Thread launcherExeThread = new Thread(downloadLauncherExe);
                launcherExeThread.start();
            }
            String serverUpdateYear = AccuServerCore.this.licenseHandler.getServerUpdateYear();
            if (serverUpdatesAvailable && serverUpdateYear != null && !serverUpdateYear.isEmpty()) {
                if (AccuServerCore.this.downloadAccuServerInstaller(serverUpdateYear)) {
                    boolean updateDownloaded = AccuServerCore.this.downloadAccuServerZip(serverUpdateYear);
                    AccuServerCore.this.input("\nAccuServerInstaller Downloaded Successfully ...");
                    System.out.println("\nAccuServerInstaller Downloaded Successfully ...");
                    if (updateDownloaded) {
                        String title;
                        int result = 0;
                        String message = AccuServerCore.this.getLiteral("An update is available for AccuServer. Do you want to install it now?");
                        result = JOptionPane.showConfirmDialog(null, message, title = AccuServerCore.this.getLiteral("AccuServer Update"), 0, 0);
                        if (result == 0) {
                            AccuServerCore.this.updateAccuServer();
                        }
                    }
                } else {
                    AccuServerCore.this.input("\nAccuServerInstaller Download FAILED ...");
                    System.out.println("\nAccuServerInstaller Download FAILED ...");
                    return;
                }
            }
        }
    }

    private class ProcessOrderInvoiced
    extends Thread {
        int orderNumber = 0;

        public ProcessOrderInvoiced(int orderNumber) {
            this.orderNumber = orderNumber;
        }

        @Override
        public void run() {
            Order thisOrder = AccuServerCore.this.getOrder(this.orderNumber, true);
            Date now = new Date();
            if (AccuServerCore.this.loyaltyHandler != null) {
                AccuServerCore.this.loyaltyHandler.orderInvoiced(thisOrder, now);
            }
        }
    }

    private class EmailOpenSaleThread
    extends Thread {
        String companyName = "";
        String serialNumber = "";
        String message = "";

        public EmailOpenSaleThread(String companyName, String serialNumber, String message) {
            this.companyName = companyName;
            this.serialNumber = serialNumber;
            this.message = message;
        }

        @Override
        public void run() {
            if (AccuServerCore.this.emailExceptionHandler != null) {
                AccuServerCore.this.emailExceptionHandler.emailOpenSaleMessage(this.companyName, this.serialNumber, this.message);
            }
        }
    }

    private class EmailExceptionThread
    extends Thread {
        String companyName = "";
        String serialNumber = "";
        String message = "";
        Exception ex = null;

        public EmailExceptionThread(String companyName, String serialNumber, String message, Exception ex) {
            this.companyName = companyName;
            this.serialNumber = serialNumber;
            this.message = message;
            this.ex = ex;
        }

        @Override
        public void run() {
            if (AccuServerCore.this.emailExceptionHandler != null) {
                AccuServerCore.this.emailExceptionHandler.emailException(this.companyName, this.serialNumber, this.message, this.ex);
            }
        }
    }

    private class SMSReceiptThread
    extends Thread {
        int orderNumber = 0;
        String smsAddress = "";

        public SMSReceiptThread(int orderNumber, String smsAddress) {
            this.orderNumber = orderNumber;
            this.smsAddress = smsAddress;
        }

        @Override
        public void run() {
            if (!this.smsAddress.isEmpty() && this.orderNumber > 0) {
                String receiptLink;
                if (AccuServerCore.this.hostConnector != null && AccuServerCore.this.smsHandler != null) {
                    StringBuilder commandXml = new StringBuilder();
                    commandXml.append("<Request>GenerateClientReceiptLink</Request>");
                    commandXml.append("<OrderNumber>" + this.orderNumber + "</OrderNumber>");
                    AccuServerCore.this.sendToHost(commandXml.toString());
                }
                if ((receiptLink = AccuServerCore.this.waitForReply("GeneratedClientReceiptLink")) != null && !receiptLink.isEmpty()) {
                    ReceiptPrintSetup receiptPrintSetup = AccuServerCore.this.getReceiptPrintSetup();
                    String receiptHeaderText = AccuServerCore.this.getLiteral("Your Receipt from") + " " + receiptPrintSetup.companyName;
                    AccuServerCore.this.sendSMSMessage(receiptHeaderText + " " + receiptLink, this.smsAddress);
                }
            }
        }
    }

    private class EmailReceiptThread
    extends Thread {
        Order order = null;
        String emailAddress = "";

        public EmailReceiptThread(Order thisOrder, String address) {
            this.order = thisOrder;
            this.emailAddress = address;
        }

        @Override
        public void run() {
            if (!this.emailAddress.isEmpty() && AccuServerCore.this.emailReceiptHandler != null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int orderNumber = this.order.orderNumber;
                this.order = AccuServerCore.this.getOrder(orderNumber, true);
                try {
                    if (AccuServerCore.this.accuServerTaxHandler != null) {
                        this.order = AccuServerCore.this.accuServerTaxHandler.calculateTaxes(this.order.toXml());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.order == null) {
                    return;
                }
                if (AccuServerCore.this.hostConnector != null && AccuServerCore.this.hostEmailReceipt) {
                    StringBuilder commandXml = new StringBuilder();
                    commandXml.append("<Request>EmailClientReceipt</Request>");
                    commandXml.append("<OrderNumber>" + this.order.orderNumber + "</OrderNumber>");
                    commandXml.append("<EmailAddress>" + this.emailAddress + "</EmailAddress>");
                    AccuServerCore.this.sendToHost(commandXml.toString());
                } else {
                    AccuServerCore.this.emailReceiptHandler.emailReceipt(this.order, this.emailAddress);
                }
            }
        }
    }

    class VersionInstaller
    extends Thread {
        @Override
        public void run() {
            AccuServerCore.this.downloadingVersion = true;
            String currentVersions = Version.getClientVersions("pcPOS");
            String requiredVersion = Utility.getElement((String)"RequiredVersion", (String)currentVersions);
            String recommendedVersion = Utility.getElement((String)"RecommendedVersion", (String)currentVersions);
            int offset = requiredVersion.indexOf(46);
            String versionYear = requiredVersion.substring(offset - 2, offset);
            String requiredCodeVersion = requiredVersion.substring(offset + 1);
            String posFileName = versionYear + "/ACCUPOSPC/" + requiredCodeVersion + "/AccuPOS-Full-Install.exe";
            this.downloadFile(posFileName);
            offset = recommendedVersion.indexOf(46);
            versionYear = recommendedVersion.substring(offset - 2, offset);
            String recommendedCodeVersion = recommendedVersion.substring(offset + 1);
            posFileName = versionYear + "/ACCUPOSPC/" + recommendedCodeVersion + "/AccuPOS-Full-Install.exe";
            this.downloadFile(posFileName);
            this.removeOlderVersions(versionYear, "/ACCUPOSPC/", requiredCodeVersion, recommendedCodeVersion);
            AccuServerCore.this.downloadingVersion = false;
            AccuServerCore.this.showLoadingDataMessage(false);
        }

        private void downloadFile(String fileVersion) {
            String fileName = System.getProperty("user.dir") + "/updates/" + fileVersion;
            File file = new File(fileName);
            if (!file.exists()) {
                try {
                    file = new File(fileName);
                    file.getParentFile().mkdirs();
                    URL website = new URL("http://updates.accuposretail.com/" + fileVersion);
                    HttpURLConnection urlConnect = (HttpURLConnection)website.openConnection();
                    urlConnect.setRequestMethod("HEAD");
                    urlConnect.connect();
                    AccuServerCore.this.input("downloading new versions ...");
                    if (urlConnect.getResponseCode() == 200) {
                        ReadableByteChannel rbc = Channels.newChannel(website.openStream());
                        FileOutputStream fos = new FileOutputStream(fileName);
                        fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                    }
                }
                catch (Exception ex) {
                    AccuServerCore.this.raiseException(ex);
                }
            }
        }

        private void removeOlderVersions(String versionYear, String downloadType, String requiredCodeVersion, String recommendedCodeVersion) {
            int codeVersion = Integer.valueOf(requiredCodeVersion);
            if (codeVersion > Integer.valueOf(recommendedCodeVersion)) {
                codeVersion = Integer.valueOf(recommendedCodeVersion);
            }
            String folderName = System.getProperty("user.dir") + "/updates/" + versionYear + downloadType;
            for (int i = codeVersion - 1; i > 0; --i) {
                File directoryName = new File(folderName + i);
                this.deleteDir(directoryName);
            }
        }

        private void deleteDir(File dir) {
            if (dir.exists() && dir.isDirectory()) {
                String[] children = dir.list();
                for (int i = 0; i < children.length; ++i) {
                    File file = new File(dir, children[i]);
                    if (file.isDirectory()) {
                        this.deleteDir(file);
                        continue;
                    }
                    file.delete();
                }
                dir.delete();
            }
        }
    }

    class AutoZOutTimer
    extends TimerTask {
        POSDataContainer tillsWithOrders = null;

        AutoZOutTimer() {
        }

        @Override
        public void run() {
            Calendar now = Calendar.getInstance(TimeZone.getDefault());
            now.setTimeInMillis(System.currentTimeMillis());
            int nowHour = now.get(11);
            int nowMin = now.get(12);
            AccuServerCore.this.tillsList = AccuServerCore.this.getTillsList();
            int len = AccuServerCore.this.tillsList.size();
            for (int i = 0; i < len; ++i) {
                boolean requestExists;
                Till thisTill = (Till)AccuServerCore.this.tillsList.get(i);
                if (!thisTill.z || !thisTill.isAutoZ) continue;
                Calendar autoZtime = Calendar.getInstance(TimeZone.getDefault());
                autoZtime.setTimeInMillis(thisTill.autoZTime.getTime());
                int autoZhour = autoZtime.get(11);
                int autoZmin = autoZtime.get(12);
                if (autoZhour != nowHour || autoZmin != nowMin) continue;
                if (this.tillsWithOrders == null) {
                    this.tillsWithOrders = AccuServerCore.this.getTillsWithOpenOrders();
                }
                if (this.tillsWithOrders.contains((Object)thisTill.name)) continue;
                AccuServerCore.this.input("\nRunning Auto Z-Out for till: " + thisTill.name);
                int zNum = AccuServerCore.this.updateZOutData(thisTill.name, "0.0");
                if (zNum <= 0 || AccuServerCore.this.integratorHandler == null || (requestExists = AccuServerCore.this.integratorHandler.checkExistingRequest())) continue;
                AccuServerCore.this.integratorHandler.exportSales(zNum, thisTill.name, false);
            }
        }
    }

    class GCTask
    extends TimerTask {
        GCTask() {
        }

        @Override
        public void run() {
            System.gc();
        }
    }

    class ProcessPostAuth
    extends Thread {
        private int zNum = 0;

        public ProcessPostAuth(int zNum) {
            this.zNum = zNum;
        }

        @Override
        public void run() {
            if (AccuServerCore.this.cardPostAuthProcessor != null) {
                AccuServerCore.this.cardPostAuthProcessor.processPostAuth(this.zNum);
            }
        }
    }

    class ModuleParameters {
        public String name = "";
        public Hashtable parameters = null;

        ModuleParameters() {
        }
    }

    class AutoBackupTimer
    extends TimerTask {
        AutoBackupTimer() {
        }

        @Override
        public void run() {
            AccuServerCore.this.logText(AccuServerCore.this.getLiteral("Starting AccuPOS Database Backup"));
            AccuServerCore.this.createBackupFile();
        }
    }

    class BackupThread
    extends Thread {
        BackupThread() {
        }

        @Override
        public void run() {
            AccuServerCore.this.logText(AccuServerCore.this.getLiteral("Starting AccuPOS Database Backup"));
            AccuServerCore.this.createBackupFile();
        }
    }

    class CloudSyncTester
    extends TimerTask {
        CloudSyncTester() {
        }

        @Override
        public void run() {
            AccuServerCore.this.logText(AccuServerCore.this.getLiteral("Starting Cloud Sync Test"));
            if (AccuServerCore.this.cloudDataAccess != null) {
                AccuServerCore.this.cloudDataAccess.syncData();
            }
        }
    }

    private class SendToHostThread
    extends Thread {
        int orderNumber = this.orderNumber;
        String message = "";

        public SendToHostThread(String message) {
            this.message = message;
        }

        @Override
        public void run() {
            try {
                if (AccuServerCore.this.hostConnector != null) {
                    AccuServerCore.this.hostConnector.send(this.message);
                }
            }
            catch (Exception e) {
                AccuServerCore.this.raiseException(e);
            }
        }
    }
}

