/*
 * Decompiled with CFR 0.152.
 */
package AccuCountDataObjects;

import AccuCountDataObjects.InventoryItem;
import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdjustmentSession {
    public int id = 0;
    public String name = "";
    public String location = "";
    public Vector itemList = null;
    public boolean closed = false;
    public Timestamp created = null;
    public Timestamp sentToAccounting = null;
    public String user = null;

    public AdjustmentSession() {
    }

    public AdjustmentSession(String xml) {
        this.id = Utility.getIntElement("ID", xml);
        this.name = Utility.getElement("Name", xml);
        this.location = Utility.getElement("Location", xml);
        this.closed = Utility.getBooleanElement("Closed", xml);
        long createdTime = Utility.getLongElement("Created", xml);
        this.created = new Timestamp(createdTime);
        long sentTime = Utility.getLongElement("SentToAccounting", xml);
        if (sentTime > 0L) {
            this.sentToAccounting = new Timestamp(sentTime);
        }
        this.user = Utility.getElement("User", xml);
        this.itemList = new Vector();
        String itemsXml = Utility.getElement("ItemList", xml);
        Vector itemListXml = Utility.getElementList("InventoryItem", itemsXml);
        int len = itemListXml.size();
        for (int i = 0; i < len; ++i) {
            String thisItemXml = (String)itemListXml.get(i);
            InventoryItem thisItem = new InventoryItem(thisItemXml);
            this.itemList.add(thisItem);
        }
    }

    public AdjustmentSession(JSONString jsonString) {
        this.id = Utility.getJSONInt(jsonString.toString(), "id");
        this.name = Utility.getJSONString(jsonString.toString(), "name");
        this.location = Utility.getJSONString(jsonString.toString(), "location");
        this.closed = Utility.getJSONBoolean(jsonString.toString(), "closed");
        String createdString = Utility.getJSONString(jsonString.toString(), "created");
        String sentToAccountingString = Utility.getJSONString(jsonString.toString(), "sentToAccounting");
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM d,yyyy");
        try {
            this.created = new Timestamp(dateFormat.parse(createdString).getTime());
        }
        catch (Exception e) {
            this.created = null;
        }
        try {
            this.sentToAccounting = new Timestamp(dateFormat.parse(sentToAccountingString).getTime());
        }
        catch (Exception e) {
            this.sentToAccounting = null;
        }
        this.user = Utility.getJSONString(jsonString.toString(), "user");
        String itemsListJson = Utility.getJSONString(jsonString.toString(), "itemsList");
        try {
            JSONArray itemsArray = new JSONArray(itemsListJson);
            int len = itemsArray.length();
            for (int i = 0; i < len; ++i) {
                JSONObject thisItemJson = (JSONObject)itemsArray.get(i);
                InventoryItem thisItem = new InventoryItem(thisItemJson.toString());
                this.itemList.add(thisItem);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<AdjustmentSession>");
        xml.append("<ID>" + this.id + "</ID>");
        xml.append("<Name>" + this.name + "</Name>");
        xml.append("<Location>" + this.location + "</Location>");
        xml.append("<Closed>" + this.closed + "</Closed>");
        if (this.created != null) {
            xml.append("<Created>" + this.created.getTime() + "</Created>");
        } else {
            xml.append("<Created></Created>");
        }
        if (this.sentToAccounting != null) {
            xml.append("<SentToAccounting>" + this.sentToAccounting.getTime() + "</SentToAccounting>");
        } else {
            xml.append("<SentToAccounting></SentToAccounting>");
        }
        xml.append("<User>" + this.user + "</User>");
        xml.append("<ItemList>");
        if (this.itemList != null) {
            int len = this.itemList.size();
            for (int i = 0; i < len; ++i) {
                InventoryItem thisItem = (InventoryItem)this.itemList.get(i);
                xml.append(thisItem.toXml());
            }
        }
        xml.append("</ItemList>");
        xml.append("</AdjustmentSession>");
        return xml.toString();
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("id", this.id);
            jsonObject.put("name", (Object)this.name);
            jsonObject.put("location", (Object)this.location);
            jsonObject.put("closed", this.closed);
            jsonObject.put("created", (Object)this.created);
            jsonObject.put("sentToAccounting", (Object)this.sentToAccounting);
            jsonObject.put("user", (Object)this.user);
            JSONArray itemsArray = new JSONArray();
            if (this.itemList != null) {
                int len = this.itemList.size();
                for (int i = 0; i < len; ++i) {
                    InventoryItem thisItem = (InventoryItem)this.itemList.get(i);
                    itemsArray.put((Object)thisItem.toJson());
                }
            }
            jsonObject.put("itemsList", (Object)itemsArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    public int getCurrentTotalCount() {
        int currentCount = 0;
        if (this.itemList != null) {
            int len = this.itemList.size();
            for (int i = 0; i < len; ++i) {
                InventoryItem thisItem = (InventoryItem)this.itemList.get(i);
                currentCount = (int)((double)currentCount + thisItem.count);
            }
        }
        return currentCount;
    }

    public double getSessionCountForItem(String itemCode) {
        double currentCount = 0.0;
        if (this.itemList != null) {
            int len = this.itemList.size();
            for (int i = 0; i < len; ++i) {
                InventoryItem thisItem = (InventoryItem)this.itemList.get(i);
                if (thisItem.item == null || thisItem.item.code.compareToIgnoreCase(itemCode) != 0) continue;
                currentCount += thisItem.count;
            }
        }
        return currentCount;
    }

    public void setSentToAccounting() {
        this.sentToAccounting = new Timestamp(new Date().getTime());
        if (this.itemList != null) {
            int len = this.itemList.size();
            for (int i = 0; i < len; ++i) {
                InventoryItem thisItem = (InventoryItem)this.itemList.get(i);
                if (thisItem.item == null) continue;
                thisItem.sentToAccounting = this.sentToAccounting;
            }
        }
        this.closed = true;
    }
}

