/*
 * Decompiled with CFR 0.152.
 */
package AccuCountDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.Item;
import POSDataObjects.JSONString;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.json.JSONException;
import org.json.JSONObject;

public class InventoryItem {
    public String code = "";
    public Item item = null;
    public double count = 0.0;
    public double price = 0.0;
    public double price2 = 0.0;
    public double price3 = 0.0;
    public double price4 = 0.0;
    public double price5 = 0.0;
    public double cost = 0.0;
    public Timestamp created = null;
    public Timestamp sentToAccounting = null;
    public String user = null;
    public boolean removed = false;
    public int barcodeCount = 0;

    public InventoryItem() {
    }

    public InventoryItem(String xml) {
        this.code = Utility.getElement("ItemCode", xml);
        String itemText = Utility.getElement("Item", xml);
        if (itemText != null && itemText.length() > 0) {
            this.item = new Item(itemText);
        }
        this.count = Utility.getDoubleElement("Count", xml);
        this.price = Utility.getDoubleElement("PriceChange", xml);
        this.price2 = Utility.getDoubleElement("PriceLevel2Change", xml);
        this.price3 = Utility.getDoubleElement("PriceLevel3Change", xml);
        this.price4 = Utility.getDoubleElement("PriceLevel4Change", xml);
        this.price5 = Utility.getDoubleElement("PriceLevel5Change", xml);
        this.cost = Utility.getDoubleElement("ReceivedCost", xml);
        long createdTime = Utility.getLongElement("Created", xml);
        this.created = new Timestamp(createdTime);
        long sentTime = Utility.getLongElement("CountSentToAccounting", xml);
        if (sentTime > 0L) {
            this.sentToAccounting = new Timestamp(sentTime);
        }
        this.user = Utility.getElement("User", xml);
        this.removed = Utility.getBooleanElement("Removed", xml);
        this.barcodeCount = Utility.getIntElement("InventoryBarcodeCount", xml);
    }

    public InventoryItem(JSONString jsonString) {
        this.code = Utility.getJSONString(jsonString.toString(), "code");
        this.item = new Item(Utility.getJSONString(jsonString.toString(), "item"));
        this.count = Utility.getJSONDouble(jsonString.toString(), "count");
        this.price = Utility.getJSONDouble(jsonString.toString(), "price");
        this.price2 = Utility.getJSONDouble(jsonString.toString(), "price2");
        this.price3 = Utility.getJSONDouble(jsonString.toString(), "price3");
        this.price4 = Utility.getJSONDouble(jsonString.toString(), "price4");
        this.price5 = Utility.getJSONDouble(jsonString.toString(), "price5");
        this.cost = Utility.getJSONDouble(jsonString.toString(), "cost");
        String createdString = Utility.getJSONString(jsonString.toString(), "created");
        String sentToAccountingString = Utility.getJSONString(jsonString.toString(), "sentToAccounting");
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM d,yyyy");
        try {
            this.created = new Timestamp(dateFormat.parse(createdString).getTime());
        }
        catch (Exception e) {
            this.created = null;
        }
        try {
            this.sentToAccounting = new Timestamp(dateFormat.parse(sentToAccountingString).getTime());
        }
        catch (Exception e) {
            this.sentToAccounting = null;
        }
        this.user = Utility.getJSONString(jsonString.toString(), "user");
        this.removed = Utility.getJSONBoolean(jsonString.toString(), "removed");
        this.barcodeCount = Utility.getJSONInt(jsonString.toString(), "barcodeCount");
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<InventoryItem>");
        xml.append("<ItemCode>" + this.code + "</ItemCode>");
        if (this.item != null) {
            xml.append(this.item.toAccuCountXml());
        }
        xml.append("<Count>" + this.count + "</Count>");
        xml.append("<PriceChange>" + this.price + "</PriceChange>");
        xml.append("<PriceLevel2Change>" + this.price2 + "</PriceLevel2Change>");
        xml.append("<PriceLevel3Change>" + this.price3 + "</PriceLevel3Change>");
        xml.append("<PriceLevel4Change>" + this.price4 + "</PriceLevel4Change>");
        xml.append("<PriceLevel5Change>" + this.price5 + "</PriceLevel5Change>");
        xml.append("<ReceivedCost>" + this.cost + "</ReceivedCost>");
        xml.append("<Created>" + this.created.getTime() + "</Created>");
        if (this.sentToAccounting != null) {
            xml.append("<CountSentToAccounting>" + this.sentToAccounting.getTime() + "</CountSentToAccounting>");
        } else {
            xml.append("<CountSentToAccounting></CountSentToAccounting>");
        }
        xml.append("<User>" + this.user + "</User>");
        xml.append("<Removed>" + this.removed + "</Removed>");
        xml.append("<InventoryBarcodeCount>" + this.barcodeCount + "</InventoryBarcodeCount>");
        xml.append("</InventoryItem>");
        return xml.toString();
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("code", (Object)this.code);
            if (this.item != null) {
                jsonObject.put("item", (Object)this.item.toJson());
            }
            jsonObject.put("count", this.count);
            jsonObject.put("price", this.price);
            jsonObject.put("price2", this.price2);
            jsonObject.put("price3", this.price3);
            jsonObject.put("price4", this.price4);
            jsonObject.put("price5", this.price5);
            jsonObject.put("cost", this.cost);
            jsonObject.put("created", (Object)this.created);
            jsonObject.put("sentToAccounting", (Object)this.sentToAccounting);
            jsonObject.put("user", (Object)this.user);
            jsonObject.put("removed", this.removed);
            jsonObject.put("barcodeCount", this.barcodeCount);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    public double getDifference() {
        double difference = 0.0;
        difference = this.item != null ? this.count - this.item.onHand : this.count;
        return difference;
    }
}

