/*
 * Decompiled with CFR 0.152.
 */
package AccuShiftDataObjects;

import AccuServerBase.Utility;
import java.sql.Timestamp;
import java.text.DecimalFormat;

public class TimeDetail {
    public int payLevel;
    public Timestamp in;
    public Timestamp out;
    public long total;
    public Timestamp sent;
    public long id;
    public boolean canceled;
    public int breakTypeId = 0;
    public long dailyTotal;
    public long dailyOvertime;
    public long weeklyTotal;
    public long weeklyOvertime;
    public long payPeriodTotal;
    public long payPeriodOvertime;

    public TimeDetail(long id, int payLevel, Timestamp in, Timestamp out, long total, Timestamp sent) {
        this.id = id;
        this.payLevel = payLevel;
        this.in = in;
        this.out = out;
        this.total = total;
        if (sent == null) {
            sent = new Timestamp(0L);
        }
        this.sent = sent;
        this.canceled = false;
    }

    public TimeDetail() {
    }

    public TimeDetail(String xml) {
        long outValue;
        this.id = Utility.getIntElement("Id", xml);
        long inValue = Utility.getLongElement("In", xml);
        if (inValue > 0L) {
            this.in = new Timestamp(inValue);
        }
        if ((outValue = Utility.getLongElement("Out", xml)) > 0L) {
            this.out = new Timestamp(outValue);
        }
        this.total = Utility.getLongElement("Total", xml);
        long sentValue = Utility.getLongElement("Sent", xml);
        if (sentValue > 0L) {
            this.sent = new Timestamp(sentValue);
        }
        this.payLevel = Utility.getIntElement("PayLevel", xml);
        this.canceled = Utility.getBooleanElement("Canceled", xml);
        this.breakTypeId = Utility.getIntElement("BreakTypeId", xml);
        this.dailyTotal = Utility.getLongElement("DailyTotal", xml);
        this.dailyOvertime = Utility.getLongElement("DailyOvertime", xml);
        this.weeklyTotal = Utility.getLongElement("WeeklyTotal", xml);
        this.weeklyOvertime = Utility.getLongElement("WeeklyOvertime ", xml);
        this.payPeriodTotal = Utility.getLongElement("PayPeriodTotal", xml);
        this.payPeriodOvertime = Utility.getLongElement("PayPeriodOvertime", xml);
    }

    public String toXml() {
        DecimalFormat decimal = new DecimalFormat("####0.00##;-####0.00##");
        StringBuffer xml = new StringBuffer();
        xml.append("<TimeDetail>");
        xml.append("<Id>" + this.id + "</Id>");
        if (this.in != null) {
            xml.append("<In>" + this.in.getTime() + "</In>");
        }
        if (this.out != null) {
            xml.append("<Out>" + this.out.getTime() + "</Out>");
        }
        xml.append("<Total>" + this.total + "</Total>");
        if (this.sent != null) {
            xml.append("<Sent>" + this.sent.getTime() + "</Sent>");
        }
        xml.append("<PayLevel>" + this.payLevel + "</PayLevel>");
        xml.append("<Canceled>" + this.canceled + "</Canceled>");
        xml.append("<BreakTypeId>" + this.breakTypeId + "</BreakTypeId>");
        xml.append("<DailyTotal>" + decimal.format(this.dailyTotal) + "</DailyTotal>");
        xml.append("<DailyOvertime>" + decimal.format(this.dailyOvertime) + "</DailyOvertime>");
        xml.append("<WeeklyTotal>" + decimal.format(this.weeklyTotal) + "</WeeklyTotal>");
        xml.append("<WeeklyOvertime>" + decimal.format(this.weeklyOvertime) + "</WeeklyOvertime>");
        xml.append("<PayPeriodTotal>" + decimal.format(this.payPeriodTotal) + "</PayPeriodTotal>");
        xml.append("<PayPeriodOvertime>" + decimal.format(this.payPeriodOvertime) + "</PayPeriodOvertime>");
        xml.append("</TimeDetail>");
        return xml.toString();
    }
}

