/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;
import IntegratorDataObjects.QboTaxRateDetail;
import java.util.Vector;

public class QboTaxCode {
    public String id;
    public String name;
    public String description;
    public Vector taxRateDetail;

    public QboTaxCode() {
    }

    public QboTaxCode(String xmlString) {
        try {
            this.id = Utility.getElement("Id", xmlString);
            this.name = Utility.getElement("Name", xmlString);
            this.description = Utility.getElement("Description", xmlString);
            this.taxRateDetail = new Vector();
            String salesTaxRateList = Utility.getElement("SalesTaxRateList", xmlString);
            Vector taxRateDetailXml = Utility.getElementList("TaxRateDetail", salesTaxRateList);
            int numDetail = 0;
            if (taxRateDetailXml != null && !taxRateDetailXml.isEmpty()) {
                numDetail = taxRateDetailXml.size();
                for (int i = 0; i < numDetail; ++i) {
                    String thisTaxRateDetail = (String)taxRateDetailXml.get(i);
                    QboTaxRateDetail thisDetail = new QboTaxRateDetail(thisTaxRateDetail);
                    this.taxRateDetail.add(thisDetail);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getLocalizedMessage());
        }
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<qboTaxCode>");
        xml.append("<Id>" + this.id + "</Id>");
        xml.append("<Name>" + this.name + "</Name>");
        xml.append("<Description>" + this.description + "</Description>");
        xml.append("</qboTaxCode>");
        return xml.toString();
    }
}

