/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;
import IntegratorDataObjects.XmlInventoryItem;
import java.util.ArrayList;
import java.util.Vector;

public class XmlInventory {
    private ArrayList items;

    public XmlInventory(ArrayList<XmlInventoryItem> items) {
        this.items = items;
    }

    public XmlInventory(String xmlString) {
        String itemsXml = Utility.getElement("items", xmlString);
        Vector itemStrings = Utility.getElementList("item", itemsXml);
        ArrayList<XmlInventoryItem> itemList = new ArrayList<XmlInventoryItem>();
        int numInventoryItems = 0;
        if (itemStrings != null && !itemStrings.isEmpty()) {
            numInventoryItems = itemStrings.size();
        }
        for (int i = 0; i < numInventoryItems; ++i) {
            String thisItemXml = (String)itemStrings.get(i);
            XmlInventoryItem thisInventoryItem = new XmlInventoryItem(thisItemXml);
            itemList.add(thisInventoryItem);
        }
        this.items = itemList;
    }

    public XmlInventory() {
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<Inventory>");
        if (this.items != null) {
            xml.append("<items>");
            int numItems = 0;
            if (this.items != null && !this.items.isEmpty()) {
                numItems = this.items.size();
            }
            for (int i = 0; i < numItems; ++i) {
                XmlInventoryItem thisInventoryItem = (XmlInventoryItem)this.items.get(i);
                xml.append(thisInventoryItem.toXml());
            }
            xml.append("</items>");
        }
        xml.append("</Inventory>");
        return xml.toString();
    }

    public void setItems(ArrayList items) {
        this.items = items;
    }

    public ArrayList getItems() {
        return this.items;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }
}

