/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;
import IntegratorDataObjects.XmlInventoryAdjustment;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class XmlInventoryAdjustments {
    public ArrayList<XmlInventoryAdjustment> adjustments;
    public String glClass;
    public String reason;
    public GregorianCalendar date;
    public final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");

    public XmlInventoryAdjustments(String xmlString) {
        this.glClass = Utility.getElement("glClass", xmlString);
        this.reason = Utility.getElement("reason", xmlString);
        GregorianCalendar cal = new GregorianCalendar();
        try {
            Date parsedDate = this.dateFormat.parse(Utility.getElement("date", xmlString));
            cal.setTime(parsedDate);
            this.date = cal;
        }
        catch (ParseException ex) {
            this.date = null;
        }
        String adjustmentsXml = Utility.getElement("adjustments", xmlString);
        Vector adjustmentListStrings = Utility.getElementList("adjustmentList", adjustmentsXml);
        ArrayList<XmlInventoryAdjustment> adjustmentLists = new ArrayList<XmlInventoryAdjustment>();
        int numInventoryAdjustments = 0;
        if (adjustmentListStrings != null && !adjustmentListStrings.isEmpty()) {
            numInventoryAdjustments = adjustmentListStrings.size();
        }
        for (int i = 0; i < numInventoryAdjustments; ++i) {
            String thisAdjustmentXml = (String)adjustmentListStrings.get(i);
            XmlInventoryAdjustment thisInventoryAdjustment = new XmlInventoryAdjustment(thisAdjustmentXml);
            adjustmentLists.add(thisInventoryAdjustment);
        }
        this.adjustments = adjustmentLists;
    }

    public XmlInventoryAdjustments() {
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<InventoryAdjustments>");
        xml.append("    <adjustments>\r\n");
        if (this.adjustments != null) {
            for (XmlInventoryAdjustment adjustment : this.adjustments) {
                xml.append(adjustment.toXml());
            }
        }
        xml.append("    </adjustments>\r\n");
        xml.append("    <glClass>" + this.glClass + "</glClass>\r\n");
        xml.append("    <reason>" + this.reason + "</reason>\r\n");
        xml.append("    <date>" + this.dateFormat.format(this.date.getTime()) + "</date>\r\n");
        xml.append("</InventoryAdjustments>");
        return xml.toString();
    }

    public void setAdjustments(ArrayList adjustments) {
        this.adjustments = adjustments;
    }

    public void setGlClass(String glClass) {
        this.glClass = glClass;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setDate(GregorianCalendar date) {
        this.date = date;
    }

    public ArrayList<XmlInventoryAdjustment> getAdjustments() {
        return this.adjustments;
    }

    public String getGlClass() {
        return this.glClass;
    }

    public String getReason() {
        return this.reason;
    }

    public GregorianCalendar getDate() {
        return this.date;
    }
}

